package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a `AWS::SageMaker::EndpointConfig`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-07-02T17:21:10.261Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnEndpointConfigProps")
@software.amazon.jsii.Jsii.Proxy(CfnEndpointConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEndpointConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::SageMaker::EndpointConfig.ProductionVariants`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getProductionVariants();

    /**
     * `AWS::SageMaker::EndpointConfig.EndpointConfigName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndpointConfigName() {
        return null;
    }

    /**
     * `AWS::SageMaker::EndpointConfig.KmsKeyId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * `AWS::SageMaker::EndpointConfig.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEndpointConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEndpointConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEndpointConfigProps> {
        private java.lang.Object productionVariants;
        private java.lang.String endpointConfigName;
        private java.lang.String kmsKeyId;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getProductionVariants}
         * @param productionVariants `AWS::SageMaker::EndpointConfig.ProductionVariants`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productionVariants(software.amazon.awscdk.core.IResolvable productionVariants) {
            this.productionVariants = productionVariants;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getProductionVariants}
         * @param productionVariants `AWS::SageMaker::EndpointConfig.ProductionVariants`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productionVariants(java.util.List<java.lang.Object> productionVariants) {
            this.productionVariants = productionVariants;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getEndpointConfigName}
         * @param endpointConfigName `AWS::SageMaker::EndpointConfig.EndpointConfigName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfigName(java.lang.String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getKmsKeyId}
         * @param kmsKeyId `AWS::SageMaker::EndpointConfig.KmsKeyId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointConfigProps#getTags}
         * @param tags `AWS::SageMaker::EndpointConfig.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEndpointConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEndpointConfigProps build() {
            return new Jsii$Proxy(productionVariants, endpointConfigName, kmsKeyId, tags);
        }
    }

    /**
     * An implementation for {@link CfnEndpointConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEndpointConfigProps {
        private final java.lang.Object productionVariants;
        private final java.lang.String endpointConfigName;
        private final java.lang.String kmsKeyId;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.productionVariants = this.jsiiGet("productionVariants", java.lang.Object.class);
            this.endpointConfigName = this.jsiiGet("endpointConfigName", java.lang.String.class);
            this.kmsKeyId = this.jsiiGet("kmsKeyId", java.lang.String.class);
            this.tags = this.jsiiGet("tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Object productionVariants, final java.lang.String endpointConfigName, final java.lang.String kmsKeyId, final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.productionVariants = java.util.Objects.requireNonNull(productionVariants, "productionVariants is required");
            this.endpointConfigName = endpointConfigName;
            this.kmsKeyId = kmsKeyId;
            this.tags = tags;
        }

        @Override
        public java.lang.Object getProductionVariants() {
            return this.productionVariants;
        }

        @Override
        public java.lang.String getEndpointConfigName() {
            return this.endpointConfigName;
        }

        @Override
        public java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("productionVariants", om.valueToTree(this.getProductionVariants()));
            if (this.getEndpointConfigName() != null) {
                data.set("endpointConfigName", om.valueToTree(this.getEndpointConfigName()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnEndpointConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEndpointConfigProps.Jsii$Proxy that = (CfnEndpointConfigProps.Jsii$Proxy) o;

            if (!productionVariants.equals(that.productionVariants)) return false;
            if (this.endpointConfigName != null ? !this.endpointConfigName.equals(that.endpointConfigName) : that.endpointConfigName != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public int hashCode() {
            int result = this.productionVariants.hashCode();
            result = 31 * result + (this.endpointConfigName != null ? this.endpointConfigName.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
