package software.amazon.awscdk.services.sagemaker;

/**
 * A CloudFormation `AWS::SageMaker::CodeRepository`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-18T01:27:07.676Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnCodeRepository")
public class CfnCodeRepository extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnCodeRepository(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCodeRepository(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnCodeRepository.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::SageMaker::CodeRepository`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCodeRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnCodeRepositoryProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A factory method that creates a new instance of this class from an object containing the CloudFormation properties of this resource.
     * <p>
     * Used in the &#64;aws-cdk/cloudformation-include module.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param resourceAttributes This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnCodeRepository fromCloudFormation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.Object resourceAttributes, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FromCloudFormationOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.sagemaker.CfnCodeRepository.class, "fromCloudFormation", software.amazon.awscdk.services.sagemaker.CfnCodeRepository.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), resourceAttributes, java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCodeRepositoryName() {
        return this.jsiiGet("attrCodeRepositoryName", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::SageMaker::CodeRepository.GitConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-gitconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getGitConfig() {
        return this.jsiiGet("gitConfig", java.lang.Object.class);
    }

    /**
     * `AWS::SageMaker::CodeRepository.GitConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-gitconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGitConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnCodeRepository.GitConfigProperty value) {
        this.jsiiSet("gitConfig", java.util.Objects.requireNonNull(value, "gitConfig is required"));
    }

    /**
     * `AWS::SageMaker::CodeRepository.GitConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-gitconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGitConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("gitConfig", java.util.Objects.requireNonNull(value, "gitConfig is required"));
    }

    /**
     * `AWS::SageMaker::CodeRepository.CodeRepositoryName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-coderepositoryname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCodeRepositoryName() {
        return this.jsiiGet("codeRepositoryName", java.lang.String.class);
    }

    /**
     * `AWS::SageMaker::CodeRepository.CodeRepositoryName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-coderepositoryname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCodeRepositoryName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("codeRepositoryName", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnCodeRepository.GitConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(GitConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GitConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnCodeRepository.GitConfigProperty.RepositoryUrl`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-repositoryurl
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRepositoryUrl();

        /**
         * `CfnCodeRepository.GitConfigProperty.Branch`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-branch
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBranch() {
            return null;
        }

        /**
         * `CfnCodeRepository.GitConfigProperty.SecretArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-secretarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GitConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GitConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GitConfigProperty> {
            private java.lang.String repositoryUrl;
            private java.lang.String branch;
            private java.lang.String secretArn;

            /**
             * Sets the value of {@link GitConfigProperty#getRepositoryUrl}
             * @param repositoryUrl `CfnCodeRepository.GitConfigProperty.RepositoryUrl`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repositoryUrl(java.lang.String repositoryUrl) {
                this.repositoryUrl = repositoryUrl;
                return this;
            }

            /**
             * Sets the value of {@link GitConfigProperty#getBranch}
             * @param branch `CfnCodeRepository.GitConfigProperty.Branch`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder branch(java.lang.String branch) {
                this.branch = branch;
                return this;
            }

            /**
             * Sets the value of {@link GitConfigProperty#getSecretArn}
             * @param secretArn `CfnCodeRepository.GitConfigProperty.SecretArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GitConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GitConfigProperty build() {
                return new Jsii$Proxy(repositoryUrl, branch, secretArn);
            }
        }

        /**
         * An implementation for {@link GitConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitConfigProperty {
            private final java.lang.String repositoryUrl;
            private final java.lang.String branch;
            private final java.lang.String secretArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.repositoryUrl = this.jsiiGet("repositoryUrl", java.lang.String.class);
                this.branch = this.jsiiGet("branch", java.lang.String.class);
                this.secretArn = this.jsiiGet("secretArn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String repositoryUrl, final java.lang.String branch, final java.lang.String secretArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.repositoryUrl = java.util.Objects.requireNonNull(repositoryUrl, "repositoryUrl is required");
                this.branch = branch;
                this.secretArn = secretArn;
            }

            @Override
            public java.lang.String getRepositoryUrl() {
                return this.repositoryUrl;
            }

            @Override
            public java.lang.String getBranch() {
                return this.branch;
            }

            @Override
            public java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("repositoryUrl", om.valueToTree(this.getRepositoryUrl()));
                if (this.getBranch() != null) {
                    data.set("branch", om.valueToTree(this.getBranch()));
                }
                if (this.getSecretArn() != null) {
                    data.set("secretArn", om.valueToTree(this.getSecretArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnCodeRepository.GitConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GitConfigProperty.Jsii$Proxy that = (GitConfigProperty.Jsii$Proxy) o;

                if (!repositoryUrl.equals(that.repositoryUrl)) return false;
                if (this.branch != null ? !this.branch.equals(that.branch) : that.branch != null) return false;
                return this.secretArn != null ? this.secretArn.equals(that.secretArn) : that.secretArn == null;
            }

            @Override
            public int hashCode() {
                int result = this.repositoryUrl.hashCode();
                result = 31 * result + (this.branch != null ? this.branch.hashCode() : 0);
                result = 31 * result + (this.secretArn != null ? this.secretArn.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnCodeRepository}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnCodeRepository> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sagemaker.CfnCodeRepositoryProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sagemaker.CfnCodeRepositoryProps.Builder();
        }

        /**
         * `AWS::SageMaker::CodeRepository.GitConfig`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-gitconfig
         * @param gitConfig `AWS::SageMaker::CodeRepository.GitConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gitConfig(final software.amazon.awscdk.services.sagemaker.CfnCodeRepository.GitConfigProperty gitConfig) {
            this.props.gitConfig(gitConfig);
            return this;
        }
        /**
         * `AWS::SageMaker::CodeRepository.GitConfig`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-gitconfig
         * @param gitConfig `AWS::SageMaker::CodeRepository.GitConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gitConfig(final software.amazon.awscdk.core.IResolvable gitConfig) {
            this.props.gitConfig(gitConfig);
            return this;
        }

        /**
         * `AWS::SageMaker::CodeRepository.CodeRepositoryName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-coderepositoryname
         * @param codeRepositoryName `AWS::SageMaker::CodeRepository.CodeRepositoryName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeRepositoryName(final java.lang.String codeRepositoryName) {
            this.props.codeRepositoryName(codeRepositoryName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnCodeRepository}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnCodeRepository build() {
            return new software.amazon.awscdk.services.sagemaker.CfnCodeRepository(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
