package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a `AWS::SageMaker::EndpointConfig`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.1 (build ceff2ca)", date = "2019-08-27T17:25:20.080Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnEndpointConfigProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::SageMaker::EndpointConfig.ProductionVariants`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getProductionVariants();

    /**
     * `AWS::SageMaker::EndpointConfig.EndpointConfigName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getEndpointConfigName();

    /**
     * `AWS::SageMaker::EndpointConfig.KmsKeyId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getKmsKeyId();

    /**
     * `AWS::SageMaker::EndpointConfig.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<software.amazon.awscdk.core.CfnTag> getTags();

    /**
     * @return a {@link Builder} of {@link CfnEndpointConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnEndpointConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Builder {
        private java.lang.Object productionVariants;
        private java.lang.String endpointConfigName;
        private java.lang.String kmsKeyId;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of ProductionVariants
         * @param productionVariants `AWS::SageMaker::EndpointConfig.ProductionVariants`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder productionVariants(software.amazon.awscdk.core.IResolvable productionVariants) {
            this.productionVariants = productionVariants;
            return this;
        }

        /**
         * Sets the value of ProductionVariants
         * @param productionVariants `AWS::SageMaker::EndpointConfig.ProductionVariants`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder productionVariants(java.util.List<java.lang.Object> productionVariants) {
            this.productionVariants = productionVariants;
            return this;
        }

        /**
         * Sets the value of EndpointConfigName
         * @param endpointConfigName `AWS::SageMaker::EndpointConfig.EndpointConfigName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder endpointConfigName(java.lang.String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        /**
         * Sets the value of KmsKeyId
         * @param kmsKeyId `AWS::SageMaker::EndpointConfig.KmsKeyId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of Tags
         * @param tags `AWS::SageMaker::EndpointConfig.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEndpointConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnEndpointConfigProps build() {
            return new Jsii$Proxy(productionVariants, endpointConfigName, kmsKeyId, tags);
        }

    }

    /**
     * An implementation for {@link CfnEndpointConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEndpointConfigProps {
        private final java.lang.Object productionVariants;
        private final java.lang.String endpointConfigName;
        private final java.lang.String kmsKeyId;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.productionVariants = this.jsiiGet("productionVariants", java.lang.Object.class);
            this.endpointConfigName = this.jsiiGet("endpointConfigName", java.lang.String.class);
            this.kmsKeyId = this.jsiiGet("kmsKeyId", java.lang.String.class);
            this.tags = this.jsiiGet("tags", java.util.List.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Object productionVariants, java.lang.String endpointConfigName, java.lang.String kmsKeyId, java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.productionVariants = java.util.Objects.requireNonNull(productionVariants, "productionVariants is required");
            this.endpointConfigName = endpointConfigName;
            this.kmsKeyId = kmsKeyId;
            this.tags = tags;
        }

        @Override
        public java.lang.Object getProductionVariants() {
            return this.productionVariants;
        }

        @Override
        public java.lang.String getEndpointConfigName() {
            return this.endpointConfigName;
        }

        @Override
        public java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("productionVariants", om.valueToTree(this.getProductionVariants()));
            if (this.getEndpointConfigName() != null) {
                obj.set("endpointConfigName", om.valueToTree(this.getEndpointConfigName()));
            }
            if (this.getKmsKeyId() != null) {
                obj.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getTags() != null) {
                obj.set("tags", om.valueToTree(this.getTags()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEndpointConfigProps.Jsii$Proxy that = (CfnEndpointConfigProps.Jsii$Proxy) o;

            if (!productionVariants.equals(that.productionVariants)) return false;
            if (this.endpointConfigName != null ? !this.endpointConfigName.equals(that.endpointConfigName) : that.endpointConfigName != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public int hashCode() {
            int result = this.productionVariants.hashCode();
            result = 31 * result + (this.endpointConfigName != null ? this.endpointConfigName.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }

    }
}
