/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sagemaker;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.services.sagemaker.$Module;
import software.amazon.awscdk.services.sagemaker.CfnModel;
import software.amazon.awscdk.services.sagemaker.CfnModelProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModel")
public class CfnModel
extends CfnResource {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnModel.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnModel(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnModel(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnModel(Construct scope, String id, CfnModelProps props) {
        super(JsiiObject.InitializationMode.JSII);
        this.setObjRef(JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")}));
    }

    protected Map<String, Object> renderProperties(Map<String, Object> props) {
        return (Map)this.jsiiCall("renderProperties", Map.class, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public String getAttrModelName() {
        return (String)this.jsiiGet("attrModelName", String.class);
    }

    protected Map<String, Object> getCfnProperties() {
        return (Map)this.jsiiGet("cfnProperties", Map.class);
    }

    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    public String getExecutionRoleArn() {
        return (String)this.jsiiGet("executionRoleArn", String.class);
    }

    public void setExecutionRoleArn(String value) {
        this.jsiiSet("executionRoleArn", Objects.requireNonNull(value, "executionRoleArn is required"));
    }

    public Object getContainers() {
        return this.jsiiGet("containers", Object.class);
    }

    public void setContainers(IResolvable value) {
        this.jsiiSet("containers", value);
    }

    public void setContainers(List<Object> value) {
        this.jsiiSet("containers", value);
    }

    public String getModelName() {
        return (String)this.jsiiGet("modelName", String.class);
    }

    public void setModelName(String value) {
        this.jsiiSet("modelName", value);
    }

    public Object getPrimaryContainer() {
        return this.jsiiGet("primaryContainer", Object.class);
    }

    public void setPrimaryContainer(IResolvable value) {
        this.jsiiSet("primaryContainer", value);
    }

    public void setPrimaryContainer(ContainerDefinitionProperty value) {
        this.jsiiSet("primaryContainer", value);
    }

    public Object getVpcConfig() {
        return this.jsiiGet("vpcConfig", Object.class);
    }

    public void setVpcConfig(IResolvable value) {
        this.jsiiSet("vpcConfig", value);
    }

    public void setVpcConfig(VpcConfigProperty value) {
        this.jsiiSet("vpcConfig", value);
    }

    public static interface VpcConfigProperty
    extends JsiiSerializable {
        public List<String> getSecurityGroupIds();

        public List<String> getSubnets();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private List<String> securityGroupIds;
            private List<String> subnets;

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnets(List<String> subnets) {
                this.subnets = subnets;
                return this;
            }

            public VpcConfigProperty build() {
                return new Jsii.Proxy(this.securityGroupIds, this.subnets, null);
            }
        }
    }

    public static interface ContainerDefinitionProperty
    extends JsiiSerializable {
        public String getImage();

        public String getContainerHostname();

        public Object getEnvironment();

        public String getModelDataUrl();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String image;
            private String containerHostname;
            private Object environment;
            private String modelDataUrl;

            public Builder image(String image) {
                this.image = image;
                return this;
            }

            public Builder containerHostname(String containerHostname) {
                this.containerHostname = containerHostname;
                return this;
            }

            public Builder environment(Object environment) {
                this.environment = environment;
                return this;
            }

            public Builder modelDataUrl(String modelDataUrl) {
                this.modelDataUrl = modelDataUrl;
                return this;
            }

            public ContainerDefinitionProperty build() {
                return new Jsii.Proxy(this.image, this.containerHostname, this.environment, this.modelDataUrl, null);
            }
        }
    }
}

