package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a `AWS::SageMaker::NotebookInstance`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-07T19:57:27.185Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnNotebookInstanceProps")
@software.amazon.jsii.Jsii.Proxy(CfnNotebookInstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnNotebookInstanceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::SageMaker::NotebookInstance.InstanceType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-instancetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

    /**
     * `AWS::SageMaker::NotebookInstance.RoleArn`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rolearn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * `AWS::SageMaker::NotebookInstance.AcceleratorTypes`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-acceleratortypes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAcceleratorTypes() {
        return null;
    }

    /**
     * `AWS::SageMaker::NotebookInstance.AdditionalCodeRepositories`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-additionalcoderepositories
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdditionalCodeRepositories() {
        return null;
    }

    /**
     * `AWS::SageMaker::NotebookInstance.DefaultCodeRepository`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-defaultcoderepository
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultCodeRepository() {
        return null;
    }

    /**
     * `AWS::SageMaker::NotebookInstance.DirectInternetAccess`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-directinternetaccess
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDirectInternetAccess() {
        return null;
    }

    /**
     * `AWS::SageMaker::NotebookInstance.KmsKeyId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-kmskeyid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * `AWS::SageMaker::NotebookInstance.LifecycleConfigName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-lifecycleconfigname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLifecycleConfigName() {
        return null;
    }

    /**
     * `AWS::SageMaker::NotebookInstance.NotebookInstanceName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-notebookinstancename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNotebookInstanceName() {
        return null;
    }

    /**
     * `AWS::SageMaker::NotebookInstance.RootAccess`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rootaccess
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRootAccess() {
        return null;
    }

    /**
     * `AWS::SageMaker::NotebookInstance.SecurityGroupIds`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-securitygroupids
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return null;
    }

    /**
     * `AWS::SageMaker::NotebookInstance.SubnetId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-subnetid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
        return null;
    }

    /**
     * `AWS::SageMaker::NotebookInstance.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * `AWS::SageMaker::NotebookInstance.VolumeSizeInGB`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-volumesizeingb
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getVolumeSizeInGb() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnNotebookInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnNotebookInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnNotebookInstanceProps> {
        private java.lang.String instanceType;
        private java.lang.String roleArn;
        private java.util.List<java.lang.String> acceleratorTypes;
        private java.util.List<java.lang.String> additionalCodeRepositories;
        private java.lang.String defaultCodeRepository;
        private java.lang.String directInternetAccess;
        private java.lang.String kmsKeyId;
        private java.lang.String lifecycleConfigName;
        private java.lang.String notebookInstanceName;
        private java.lang.String rootAccess;
        private java.util.List<java.lang.String> securityGroupIds;
        private java.lang.String subnetId;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private java.lang.Number volumeSizeInGb;

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getInstanceType}
         * @param instanceType `AWS::SageMaker::NotebookInstance.InstanceType`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(java.lang.String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getRoleArn}
         * @param roleArn `AWS::SageMaker::NotebookInstance.RoleArn`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getAcceleratorTypes}
         * @param acceleratorTypes `AWS::SageMaker::NotebookInstance.AcceleratorTypes`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceleratorTypes(java.util.List<java.lang.String> acceleratorTypes) {
            this.acceleratorTypes = acceleratorTypes;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getAdditionalCodeRepositories}
         * @param additionalCodeRepositories `AWS::SageMaker::NotebookInstance.AdditionalCodeRepositories`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalCodeRepositories(java.util.List<java.lang.String> additionalCodeRepositories) {
            this.additionalCodeRepositories = additionalCodeRepositories;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getDefaultCodeRepository}
         * @param defaultCodeRepository `AWS::SageMaker::NotebookInstance.DefaultCodeRepository`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCodeRepository(java.lang.String defaultCodeRepository) {
            this.defaultCodeRepository = defaultCodeRepository;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getDirectInternetAccess}
         * @param directInternetAccess `AWS::SageMaker::NotebookInstance.DirectInternetAccess`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder directInternetAccess(java.lang.String directInternetAccess) {
            this.directInternetAccess = directInternetAccess;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getKmsKeyId}
         * @param kmsKeyId `AWS::SageMaker::NotebookInstance.KmsKeyId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getLifecycleConfigName}
         * @param lifecycleConfigName `AWS::SageMaker::NotebookInstance.LifecycleConfigName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleConfigName(java.lang.String lifecycleConfigName) {
            this.lifecycleConfigName = lifecycleConfigName;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getNotebookInstanceName}
         * @param notebookInstanceName `AWS::SageMaker::NotebookInstance.NotebookInstanceName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notebookInstanceName(java.lang.String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getRootAccess}
         * @param rootAccess `AWS::SageMaker::NotebookInstance.RootAccess`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rootAccess(java.lang.String rootAccess) {
            this.rootAccess = rootAccess;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getSecurityGroupIds}
         * @param securityGroupIds `AWS::SageMaker::NotebookInstance.SecurityGroupIds`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getSubnetId}
         * @param subnetId `AWS::SageMaker::NotebookInstance.SubnetId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetId(java.lang.String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getTags}
         * @param tags `AWS::SageMaker::NotebookInstance.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotebookInstanceProps#getVolumeSizeInGb}
         * @param volumeSizeInGb `AWS::SageMaker::NotebookInstance.VolumeSizeInGB`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeSizeInGb(java.lang.Number volumeSizeInGb) {
            this.volumeSizeInGb = volumeSizeInGb;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNotebookInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnNotebookInstanceProps build() {
            return new Jsii$Proxy(instanceType, roleArn, acceleratorTypes, additionalCodeRepositories, defaultCodeRepository, directInternetAccess, kmsKeyId, lifecycleConfigName, notebookInstanceName, rootAccess, securityGroupIds, subnetId, tags, volumeSizeInGb);
        }
    }

    /**
     * An implementation for {@link CfnNotebookInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnNotebookInstanceProps {
        private final java.lang.String instanceType;
        private final java.lang.String roleArn;
        private final java.util.List<java.lang.String> acceleratorTypes;
        private final java.util.List<java.lang.String> additionalCodeRepositories;
        private final java.lang.String defaultCodeRepository;
        private final java.lang.String directInternetAccess;
        private final java.lang.String kmsKeyId;
        private final java.lang.String lifecycleConfigName;
        private final java.lang.String notebookInstanceName;
        private final java.lang.String rootAccess;
        private final java.util.List<java.lang.String> securityGroupIds;
        private final java.lang.String subnetId;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.Number volumeSizeInGb;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceType = this.jsiiGet("instanceType", java.lang.String.class);
            this.roleArn = this.jsiiGet("roleArn", java.lang.String.class);
            this.acceleratorTypes = this.jsiiGet("acceleratorTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.additionalCodeRepositories = this.jsiiGet("additionalCodeRepositories", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.defaultCodeRepository = this.jsiiGet("defaultCodeRepository", java.lang.String.class);
            this.directInternetAccess = this.jsiiGet("directInternetAccess", java.lang.String.class);
            this.kmsKeyId = this.jsiiGet("kmsKeyId", java.lang.String.class);
            this.lifecycleConfigName = this.jsiiGet("lifecycleConfigName", java.lang.String.class);
            this.notebookInstanceName = this.jsiiGet("notebookInstanceName", java.lang.String.class);
            this.rootAccess = this.jsiiGet("rootAccess", java.lang.String.class);
            this.securityGroupIds = this.jsiiGet("securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.subnetId = this.jsiiGet("subnetId", java.lang.String.class);
            this.tags = this.jsiiGet("tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.volumeSizeInGb = this.jsiiGet("volumeSizeInGb", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        private Jsii$Proxy(final java.lang.String instanceType, final java.lang.String roleArn, final java.util.List<java.lang.String> acceleratorTypes, final java.util.List<java.lang.String> additionalCodeRepositories, final java.lang.String defaultCodeRepository, final java.lang.String directInternetAccess, final java.lang.String kmsKeyId, final java.lang.String lifecycleConfigName, final java.lang.String notebookInstanceName, final java.lang.String rootAccess, final java.util.List<java.lang.String> securityGroupIds, final java.lang.String subnetId, final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags, final java.lang.Number volumeSizeInGb) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceType = java.util.Objects.requireNonNull(instanceType, "instanceType is required");
            this.roleArn = java.util.Objects.requireNonNull(roleArn, "roleArn is required");
            this.acceleratorTypes = acceleratorTypes;
            this.additionalCodeRepositories = additionalCodeRepositories;
            this.defaultCodeRepository = defaultCodeRepository;
            this.directInternetAccess = directInternetAccess;
            this.kmsKeyId = kmsKeyId;
            this.lifecycleConfigName = lifecycleConfigName;
            this.notebookInstanceName = notebookInstanceName;
            this.rootAccess = rootAccess;
            this.securityGroupIds = securityGroupIds;
            this.subnetId = subnetId;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            this.volumeSizeInGb = volumeSizeInGb;
        }

        @Override
        public java.lang.String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public java.util.List<java.lang.String> getAcceleratorTypes() {
            return this.acceleratorTypes;
        }

        @Override
        public java.util.List<java.lang.String> getAdditionalCodeRepositories() {
            return this.additionalCodeRepositories;
        }

        @Override
        public java.lang.String getDefaultCodeRepository() {
            return this.defaultCodeRepository;
        }

        @Override
        public java.lang.String getDirectInternetAccess() {
            return this.directInternetAccess;
        }

        @Override
        public java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public java.lang.String getLifecycleConfigName() {
            return this.lifecycleConfigName;
        }

        @Override
        public java.lang.String getNotebookInstanceName() {
            return this.notebookInstanceName;
        }

        @Override
        public java.lang.String getRootAccess() {
            return this.rootAccess;
        }

        @Override
        public java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public java.lang.String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public java.lang.Number getVolumeSizeInGb() {
            return this.volumeSizeInGb;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getAcceleratorTypes() != null) {
                data.set("acceleratorTypes", om.valueToTree(this.getAcceleratorTypes()));
            }
            if (this.getAdditionalCodeRepositories() != null) {
                data.set("additionalCodeRepositories", om.valueToTree(this.getAdditionalCodeRepositories()));
            }
            if (this.getDefaultCodeRepository() != null) {
                data.set("defaultCodeRepository", om.valueToTree(this.getDefaultCodeRepository()));
            }
            if (this.getDirectInternetAccess() != null) {
                data.set("directInternetAccess", om.valueToTree(this.getDirectInternetAccess()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getLifecycleConfigName() != null) {
                data.set("lifecycleConfigName", om.valueToTree(this.getLifecycleConfigName()));
            }
            if (this.getNotebookInstanceName() != null) {
                data.set("notebookInstanceName", om.valueToTree(this.getNotebookInstanceName()));
            }
            if (this.getRootAccess() != null) {
                data.set("rootAccess", om.valueToTree(this.getRootAccess()));
            }
            if (this.getSecurityGroupIds() != null) {
                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
            }
            if (this.getSubnetId() != null) {
                data.set("subnetId", om.valueToTree(this.getSubnetId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVolumeSizeInGb() != null) {
                data.set("volumeSizeInGb", om.valueToTree(this.getVolumeSizeInGb()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnNotebookInstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnNotebookInstanceProps.Jsii$Proxy that = (CfnNotebookInstanceProps.Jsii$Proxy) o;

            if (!instanceType.equals(that.instanceType)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.acceleratorTypes != null ? !this.acceleratorTypes.equals(that.acceleratorTypes) : that.acceleratorTypes != null) return false;
            if (this.additionalCodeRepositories != null ? !this.additionalCodeRepositories.equals(that.additionalCodeRepositories) : that.additionalCodeRepositories != null) return false;
            if (this.defaultCodeRepository != null ? !this.defaultCodeRepository.equals(that.defaultCodeRepository) : that.defaultCodeRepository != null) return false;
            if (this.directInternetAccess != null ? !this.directInternetAccess.equals(that.directInternetAccess) : that.directInternetAccess != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.lifecycleConfigName != null ? !this.lifecycleConfigName.equals(that.lifecycleConfigName) : that.lifecycleConfigName != null) return false;
            if (this.notebookInstanceName != null ? !this.notebookInstanceName.equals(that.notebookInstanceName) : that.notebookInstanceName != null) return false;
            if (this.rootAccess != null ? !this.rootAccess.equals(that.rootAccess) : that.rootAccess != null) return false;
            if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
            if (this.subnetId != null ? !this.subnetId.equals(that.subnetId) : that.subnetId != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.volumeSizeInGb != null ? this.volumeSizeInGb.equals(that.volumeSizeInGb) : that.volumeSizeInGb == null;
        }

        @Override
        public int hashCode() {
            int result = this.instanceType.hashCode();
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.acceleratorTypes != null ? this.acceleratorTypes.hashCode() : 0);
            result = 31 * result + (this.additionalCodeRepositories != null ? this.additionalCodeRepositories.hashCode() : 0);
            result = 31 * result + (this.defaultCodeRepository != null ? this.defaultCodeRepository.hashCode() : 0);
            result = 31 * result + (this.directInternetAccess != null ? this.directInternetAccess.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.lifecycleConfigName != null ? this.lifecycleConfigName.hashCode() : 0);
            result = 31 * result + (this.notebookInstanceName != null ? this.notebookInstanceName.hashCode() : 0);
            result = 31 * result + (this.rootAccess != null ? this.rootAccess.hashCode() : 0);
            result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
            result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.volumeSizeInGb != null ? this.volumeSizeInGb.hashCode() : 0);
            return result;
        }
    }
}
