package software.amazon.awscdk.services.sagemaker;

/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2020-12-22T12:12:40.124Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnMonitoringSchedule")
public class CfnMonitoringSchedule extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnMonitoringSchedule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMonitoringSchedule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::SageMaker::MonitoringSchedule`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMonitoringSchedule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnMonitoringScheduleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastModifiedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModifiedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::SageMaker::MonitoringSchedule.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getMonitoringScheduleConfig() {
        return software.amazon.jsii.Kernel.get(this, "monitoringScheduleConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitoringScheduleConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "monitoringScheduleConfig", java.util.Objects.requireNonNull(value, "monitoringScheduleConfig is required"));
    }

    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitoringScheduleConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.MonitoringScheduleConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "monitoringScheduleConfig", java.util.Objects.requireNonNull(value, "monitoringScheduleConfig is required"));
    }

    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMonitoringScheduleName() {
        return software.amazon.jsii.Kernel.get(this, "monitoringScheduleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitoringScheduleName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "monitoringScheduleName", java.util.Objects.requireNonNull(value, "monitoringScheduleName is required"));
    }

    /**
     * `AWS::SageMaker::MonitoringSchedule.EndpointName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-endpointname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndpointName() {
        return software.amazon.jsii.Kernel.get(this, "endpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::SageMaker::MonitoringSchedule.EndpointName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-endpointname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endpointName", value);
    }

    /**
     * `AWS::SageMaker::MonitoringSchedule.FailureReason`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-failurereason
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFailureReason() {
        return software.amazon.jsii.Kernel.get(this, "failureReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::SageMaker::MonitoringSchedule.FailureReason`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-failurereason
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFailureReason(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "failureReason", value);
    }

    /**
     * `AWS::SageMaker::MonitoringSchedule.LastMonitoringExecutionSummary`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmonitoringexecutionsummary
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLastMonitoringExecutionSummary() {
        return software.amazon.jsii.Kernel.get(this, "lastMonitoringExecutionSummary", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SageMaker::MonitoringSchedule.LastMonitoringExecutionSummary`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmonitoringexecutionsummary
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLastMonitoringExecutionSummary(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "lastMonitoringExecutionSummary", value);
    }

    /**
     * `AWS::SageMaker::MonitoringSchedule.LastMonitoringExecutionSummary`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmonitoringexecutionsummary
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLastMonitoringExecutionSummary(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.MonitoringExecutionSummaryProperty value) {
        software.amazon.jsii.Kernel.set(this, "lastMonitoringExecutionSummary", value);
    }

    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleArn`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulearn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMonitoringScheduleArn() {
        return software.amazon.jsii.Kernel.get(this, "monitoringScheduleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleArn`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulearn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitoringScheduleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "monitoringScheduleArn", value);
    }

    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleStatus`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulestatus
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMonitoringScheduleStatus() {
        return software.amazon.jsii.Kernel.get(this, "monitoringScheduleStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleStatus`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulestatus
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitoringScheduleStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "monitoringScheduleStatus", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-baselineconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.BaselineConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(BaselineConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BaselineConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMonitoringSchedule.BaselineConfigProperty.ConstraintsResource`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-baselineconfig.html#cfn-sagemaker-monitoringschedule-baselineconfig-constraintsresource
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConstraintsResource() {
            return null;
        }

        /**
         * `CfnMonitoringSchedule.BaselineConfigProperty.StatisticsResource`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-baselineconfig.html#cfn-sagemaker-monitoringschedule-baselineconfig-statisticsresource
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStatisticsResource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BaselineConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BaselineConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BaselineConfigProperty> {
            private java.lang.Object constraintsResource;
            private java.lang.Object statisticsResource;

            /**
             * Sets the value of {@link BaselineConfigProperty#getConstraintsResource}
             * @param constraintsResource `CfnMonitoringSchedule.BaselineConfigProperty.ConstraintsResource`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constraintsResource(software.amazon.awscdk.core.IResolvable constraintsResource) {
                this.constraintsResource = constraintsResource;
                return this;
            }

            /**
             * Sets the value of {@link BaselineConfigProperty#getConstraintsResource}
             * @param constraintsResource `CfnMonitoringSchedule.BaselineConfigProperty.ConstraintsResource`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constraintsResource(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.ConstraintsResourceProperty constraintsResource) {
                this.constraintsResource = constraintsResource;
                return this;
            }

            /**
             * Sets the value of {@link BaselineConfigProperty#getStatisticsResource}
             * @param statisticsResource `CfnMonitoringSchedule.BaselineConfigProperty.StatisticsResource`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statisticsResource(software.amazon.awscdk.core.IResolvable statisticsResource) {
                this.statisticsResource = statisticsResource;
                return this;
            }

            /**
             * Sets the value of {@link BaselineConfigProperty#getStatisticsResource}
             * @param statisticsResource `CfnMonitoringSchedule.BaselineConfigProperty.StatisticsResource`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statisticsResource(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.StatisticsResourceProperty statisticsResource) {
                this.statisticsResource = statisticsResource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BaselineConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BaselineConfigProperty build() {
                return new Jsii$Proxy(constraintsResource, statisticsResource);
            }
        }

        /**
         * An implementation for {@link BaselineConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaselineConfigProperty {
            private final java.lang.Object constraintsResource;
            private final java.lang.Object statisticsResource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.constraintsResource = software.amazon.jsii.Kernel.get(this, "constraintsResource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.statisticsResource = software.amazon.jsii.Kernel.get(this, "statisticsResource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object constraintsResource, final java.lang.Object statisticsResource) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.constraintsResource = constraintsResource;
                this.statisticsResource = statisticsResource;
            }

            @Override
            public final java.lang.Object getConstraintsResource() {
                return this.constraintsResource;
            }

            @Override
            public final java.lang.Object getStatisticsResource() {
                return this.statisticsResource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConstraintsResource() != null) {
                    data.set("constraintsResource", om.valueToTree(this.getConstraintsResource()));
                }
                if (this.getStatisticsResource() != null) {
                    data.set("statisticsResource", om.valueToTree(this.getStatisticsResource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.BaselineConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BaselineConfigProperty.Jsii$Proxy that = (BaselineConfigProperty.Jsii$Proxy) o;

                if (this.constraintsResource != null ? !this.constraintsResource.equals(that.constraintsResource) : that.constraintsResource != null) return false;
                return this.statisticsResource != null ? this.statisticsResource.equals(that.statisticsResource) : that.statisticsResource == null;
            }

            @Override
            public final int hashCode() {
                int result = this.constraintsResource != null ? this.constraintsResource.hashCode() : 0;
                result = 31 * result + (this.statisticsResource != null ? this.statisticsResource.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.ClusterConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMonitoringSchedule.ClusterConfigProperty.InstanceCount`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-instancecount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getInstanceCount();

        /**
         * `CfnMonitoringSchedule.ClusterConfigProperty.InstanceType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-instancetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

        /**
         * `CfnMonitoringSchedule.ClusterConfigProperty.VolumeSizeInGB`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-volumesizeingb
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getVolumeSizeInGb();

        /**
         * `CfnMonitoringSchedule.ClusterConfigProperty.VolumeKmsKeyId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-volumekmskeyid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVolumeKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterConfigProperty> {
            private java.lang.Number instanceCount;
            private java.lang.String instanceType;
            private java.lang.Number volumeSizeInGb;
            private java.lang.String volumeKmsKeyId;

            /**
             * Sets the value of {@link ClusterConfigProperty#getInstanceCount}
             * @param instanceCount `CfnMonitoringSchedule.ClusterConfigProperty.InstanceCount`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceCount(java.lang.Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getInstanceType}
             * @param instanceType `CfnMonitoringSchedule.ClusterConfigProperty.InstanceType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getVolumeSizeInGb}
             * @param volumeSizeInGb `CfnMonitoringSchedule.ClusterConfigProperty.VolumeSizeInGB`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSizeInGb(java.lang.Number volumeSizeInGb) {
                this.volumeSizeInGb = volumeSizeInGb;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getVolumeKmsKeyId}
             * @param volumeKmsKeyId `CfnMonitoringSchedule.ClusterConfigProperty.VolumeKmsKeyId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeKmsKeyId(java.lang.String volumeKmsKeyId) {
                this.volumeKmsKeyId = volumeKmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterConfigProperty build() {
                return new Jsii$Proxy(instanceCount, instanceType, volumeSizeInGb, volumeKmsKeyId);
            }
        }

        /**
         * An implementation for {@link ClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterConfigProperty {
            private final java.lang.Number instanceCount;
            private final java.lang.String instanceType;
            private final java.lang.Number volumeSizeInGb;
            private final java.lang.String volumeKmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceCount = software.amazon.jsii.Kernel.get(this, "instanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.volumeSizeInGb = software.amazon.jsii.Kernel.get(this, "volumeSizeInGb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumeKmsKeyId = software.amazon.jsii.Kernel.get(this, "volumeKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Number instanceCount, final java.lang.String instanceType, final java.lang.Number volumeSizeInGb, final java.lang.String volumeKmsKeyId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceCount = java.util.Objects.requireNonNull(instanceCount, "instanceCount is required");
                this.instanceType = java.util.Objects.requireNonNull(instanceType, "instanceType is required");
                this.volumeSizeInGb = java.util.Objects.requireNonNull(volumeSizeInGb, "volumeSizeInGb is required");
                this.volumeKmsKeyId = volumeKmsKeyId;
            }

            @Override
            public final java.lang.Number getInstanceCount() {
                return this.instanceCount;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.Number getVolumeSizeInGb() {
                return this.volumeSizeInGb;
            }

            @Override
            public final java.lang.String getVolumeKmsKeyId() {
                return this.volumeKmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
                data.set("volumeSizeInGb", om.valueToTree(this.getVolumeSizeInGb()));
                if (this.getVolumeKmsKeyId() != null) {
                    data.set("volumeKmsKeyId", om.valueToTree(this.getVolumeKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.ClusterConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterConfigProperty.Jsii$Proxy that = (ClusterConfigProperty.Jsii$Proxy) o;

                if (!instanceCount.equals(that.instanceCount)) return false;
                if (!instanceType.equals(that.instanceType)) return false;
                if (!volumeSizeInGb.equals(that.volumeSizeInGb)) return false;
                return this.volumeKmsKeyId != null ? this.volumeKmsKeyId.equals(that.volumeKmsKeyId) : that.volumeKmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceCount.hashCode();
                result = 31 * result + (this.instanceType.hashCode());
                result = 31 * result + (this.volumeSizeInGb.hashCode());
                result = 31 * result + (this.volumeKmsKeyId != null ? this.volumeKmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-constraintsresource.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.ConstraintsResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(ConstraintsResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConstraintsResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMonitoringSchedule.ConstraintsResourceProperty.S3Uri`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-constraintsresource.html#cfn-sagemaker-monitoringschedule-constraintsresource-s3uri
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3Uri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConstraintsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConstraintsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConstraintsResourceProperty> {
            private java.lang.String s3Uri;

            /**
             * Sets the value of {@link ConstraintsResourceProperty#getS3Uri}
             * @param s3Uri `CfnMonitoringSchedule.ConstraintsResourceProperty.S3Uri`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConstraintsResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConstraintsResourceProperty build() {
                return new Jsii$Proxy(s3Uri);
            }
        }

        /**
         * An implementation for {@link ConstraintsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConstraintsResourceProperty {
            private final java.lang.String s3Uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String s3Uri) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Uri = s3Uri;
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3Uri() != null) {
                    data.set("s3Uri", om.valueToTree(this.getS3Uri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.ConstraintsResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConstraintsResourceProperty.Jsii$Proxy that = (ConstraintsResourceProperty.Jsii$Proxy) o;

                return this.s3Uri != null ? this.s3Uri.equals(that.s3Uri) : that.s3Uri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Uri != null ? this.s3Uri.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.EndpointInputProperty")
    @software.amazon.jsii.Jsii.Proxy(EndpointInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EndpointInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMonitoringSchedule.EndpointInputProperty.EndpointName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-endpointname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndpointName();

        /**
         * `CfnMonitoringSchedule.EndpointInputProperty.LocalPath`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-localpath
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocalPath();

        /**
         * `CfnMonitoringSchedule.EndpointInputProperty.S3DataDistributionType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-s3datadistributiontype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3DataDistributionType() {
            return null;
        }

        /**
         * `CfnMonitoringSchedule.EndpointInputProperty.S3InputMode`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-s3inputmode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3InputMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EndpointInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EndpointInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EndpointInputProperty> {
            private java.lang.String endpointName;
            private java.lang.String localPath;
            private java.lang.String s3DataDistributionType;
            private java.lang.String s3InputMode;

            /**
             * Sets the value of {@link EndpointInputProperty#getEndpointName}
             * @param endpointName `CfnMonitoringSchedule.EndpointInputProperty.EndpointName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointName(java.lang.String endpointName) {
                this.endpointName = endpointName;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getLocalPath}
             * @param localPath `CfnMonitoringSchedule.EndpointInputProperty.LocalPath`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localPath(java.lang.String localPath) {
                this.localPath = localPath;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getS3DataDistributionType}
             * @param s3DataDistributionType `CfnMonitoringSchedule.EndpointInputProperty.S3DataDistributionType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3DataDistributionType(java.lang.String s3DataDistributionType) {
                this.s3DataDistributionType = s3DataDistributionType;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getS3InputMode}
             * @param s3InputMode `CfnMonitoringSchedule.EndpointInputProperty.S3InputMode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3InputMode(java.lang.String s3InputMode) {
                this.s3InputMode = s3InputMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EndpointInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EndpointInputProperty build() {
                return new Jsii$Proxy(endpointName, localPath, s3DataDistributionType, s3InputMode);
            }
        }

        /**
         * An implementation for {@link EndpointInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EndpointInputProperty {
            private final java.lang.String endpointName;
            private final java.lang.String localPath;
            private final java.lang.String s3DataDistributionType;
            private final java.lang.String s3InputMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endpointName = software.amazon.jsii.Kernel.get(this, "endpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localPath = software.amazon.jsii.Kernel.get(this, "localPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3DataDistributionType = software.amazon.jsii.Kernel.get(this, "s3DataDistributionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3InputMode = software.amazon.jsii.Kernel.get(this, "s3InputMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String endpointName, final java.lang.String localPath, final java.lang.String s3DataDistributionType, final java.lang.String s3InputMode) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endpointName = java.util.Objects.requireNonNull(endpointName, "endpointName is required");
                this.localPath = java.util.Objects.requireNonNull(localPath, "localPath is required");
                this.s3DataDistributionType = s3DataDistributionType;
                this.s3InputMode = s3InputMode;
            }

            @Override
            public final java.lang.String getEndpointName() {
                return this.endpointName;
            }

            @Override
            public final java.lang.String getLocalPath() {
                return this.localPath;
            }

            @Override
            public final java.lang.String getS3DataDistributionType() {
                return this.s3DataDistributionType;
            }

            @Override
            public final java.lang.String getS3InputMode() {
                return this.s3InputMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endpointName", om.valueToTree(this.getEndpointName()));
                data.set("localPath", om.valueToTree(this.getLocalPath()));
                if (this.getS3DataDistributionType() != null) {
                    data.set("s3DataDistributionType", om.valueToTree(this.getS3DataDistributionType()));
                }
                if (this.getS3InputMode() != null) {
                    data.set("s3InputMode", om.valueToTree(this.getS3InputMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.EndpointInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EndpointInputProperty.Jsii$Proxy that = (EndpointInputProperty.Jsii$Proxy) o;

                if (!endpointName.equals(that.endpointName)) return false;
                if (!localPath.equals(that.localPath)) return false;
                if (this.s3DataDistributionType != null ? !this.s3DataDistributionType.equals(that.s3DataDistributionType) : that.s3DataDistributionType != null) return false;
                return this.s3InputMode != null ? this.s3InputMode.equals(that.s3InputMode) : that.s3InputMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.endpointName.hashCode();
                result = 31 * result + (this.localPath.hashCode());
                result = 31 * result + (this.s3DataDistributionType != null ? this.s3DataDistributionType.hashCode() : 0);
                result = 31 * result + (this.s3InputMode != null ? this.s3InputMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-environment.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.EnvironmentProperty")
    @software.amazon.jsii.Jsii.Proxy(EnvironmentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnvironmentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @return a {@link Builder} of {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnvironmentProperty> {

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnvironmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnvironmentProperty build() {
                return new Jsii$Proxy();
            }
        }

        /**
         * An implementation for {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnvironmentProperty {

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy() {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();


                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.EnvironmentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringAppSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringAppSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringAppSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.ImageUri`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-imageuri
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImageUri();

        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.ContainerArguments`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-containerarguments
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getContainerArguments() {
            return null;
        }

        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.ContainerEntrypoint`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-containerentrypoint
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getContainerEntrypoint() {
            return null;
        }

        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.PostAnalyticsProcessorSourceUri`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-postanalyticsprocessorsourceuri
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPostAnalyticsProcessorSourceUri() {
            return null;
        }

        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.RecordPreprocessorSourceUri`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-recordpreprocessorsourceuri
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRecordPreprocessorSourceUri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MonitoringAppSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringAppSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringAppSpecificationProperty> {
            private java.lang.String imageUri;
            private java.util.List<java.lang.String> containerArguments;
            private java.util.List<java.lang.String> containerEntrypoint;
            private java.lang.String postAnalyticsProcessorSourceUri;
            private java.lang.String recordPreprocessorSourceUri;

            /**
             * Sets the value of {@link MonitoringAppSpecificationProperty#getImageUri}
             * @param imageUri `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.ImageUri`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageUri(java.lang.String imageUri) {
                this.imageUri = imageUri;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringAppSpecificationProperty#getContainerArguments}
             * @param containerArguments `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.ContainerArguments`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerArguments(java.util.List<java.lang.String> containerArguments) {
                this.containerArguments = containerArguments;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringAppSpecificationProperty#getContainerEntrypoint}
             * @param containerEntrypoint `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.ContainerEntrypoint`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerEntrypoint(java.util.List<java.lang.String> containerEntrypoint) {
                this.containerEntrypoint = containerEntrypoint;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringAppSpecificationProperty#getPostAnalyticsProcessorSourceUri}
             * @param postAnalyticsProcessorSourceUri `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.PostAnalyticsProcessorSourceUri`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postAnalyticsProcessorSourceUri(java.lang.String postAnalyticsProcessorSourceUri) {
                this.postAnalyticsProcessorSourceUri = postAnalyticsProcessorSourceUri;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringAppSpecificationProperty#getRecordPreprocessorSourceUri}
             * @param recordPreprocessorSourceUri `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.RecordPreprocessorSourceUri`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordPreprocessorSourceUri(java.lang.String recordPreprocessorSourceUri) {
                this.recordPreprocessorSourceUri = recordPreprocessorSourceUri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringAppSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringAppSpecificationProperty build() {
                return new Jsii$Proxy(imageUri, containerArguments, containerEntrypoint, postAnalyticsProcessorSourceUri, recordPreprocessorSourceUri);
            }
        }

        /**
         * An implementation for {@link MonitoringAppSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringAppSpecificationProperty {
            private final java.lang.String imageUri;
            private final java.util.List<java.lang.String> containerArguments;
            private final java.util.List<java.lang.String> containerEntrypoint;
            private final java.lang.String postAnalyticsProcessorSourceUri;
            private final java.lang.String recordPreprocessorSourceUri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.imageUri = software.amazon.jsii.Kernel.get(this, "imageUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.containerArguments = software.amazon.jsii.Kernel.get(this, "containerArguments", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.containerEntrypoint = software.amazon.jsii.Kernel.get(this, "containerEntrypoint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.postAnalyticsProcessorSourceUri = software.amazon.jsii.Kernel.get(this, "postAnalyticsProcessorSourceUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.recordPreprocessorSourceUri = software.amazon.jsii.Kernel.get(this, "recordPreprocessorSourceUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String imageUri, final java.util.List<java.lang.String> containerArguments, final java.util.List<java.lang.String> containerEntrypoint, final java.lang.String postAnalyticsProcessorSourceUri, final java.lang.String recordPreprocessorSourceUri) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.imageUri = java.util.Objects.requireNonNull(imageUri, "imageUri is required");
                this.containerArguments = containerArguments;
                this.containerEntrypoint = containerEntrypoint;
                this.postAnalyticsProcessorSourceUri = postAnalyticsProcessorSourceUri;
                this.recordPreprocessorSourceUri = recordPreprocessorSourceUri;
            }

            @Override
            public final java.lang.String getImageUri() {
                return this.imageUri;
            }

            @Override
            public final java.util.List<java.lang.String> getContainerArguments() {
                return this.containerArguments;
            }

            @Override
            public final java.util.List<java.lang.String> getContainerEntrypoint() {
                return this.containerEntrypoint;
            }

            @Override
            public final java.lang.String getPostAnalyticsProcessorSourceUri() {
                return this.postAnalyticsProcessorSourceUri;
            }

            @Override
            public final java.lang.String getRecordPreprocessorSourceUri() {
                return this.recordPreprocessorSourceUri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("imageUri", om.valueToTree(this.getImageUri()));
                if (this.getContainerArguments() != null) {
                    data.set("containerArguments", om.valueToTree(this.getContainerArguments()));
                }
                if (this.getContainerEntrypoint() != null) {
                    data.set("containerEntrypoint", om.valueToTree(this.getContainerEntrypoint()));
                }
                if (this.getPostAnalyticsProcessorSourceUri() != null) {
                    data.set("postAnalyticsProcessorSourceUri", om.valueToTree(this.getPostAnalyticsProcessorSourceUri()));
                }
                if (this.getRecordPreprocessorSourceUri() != null) {
                    data.set("recordPreprocessorSourceUri", om.valueToTree(this.getRecordPreprocessorSourceUri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringAppSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringAppSpecificationProperty.Jsii$Proxy that = (MonitoringAppSpecificationProperty.Jsii$Proxy) o;

                if (!imageUri.equals(that.imageUri)) return false;
                if (this.containerArguments != null ? !this.containerArguments.equals(that.containerArguments) : that.containerArguments != null) return false;
                if (this.containerEntrypoint != null ? !this.containerEntrypoint.equals(that.containerEntrypoint) : that.containerEntrypoint != null) return false;
                if (this.postAnalyticsProcessorSourceUri != null ? !this.postAnalyticsProcessorSourceUri.equals(that.postAnalyticsProcessorSourceUri) : that.postAnalyticsProcessorSourceUri != null) return false;
                return this.recordPreprocessorSourceUri != null ? this.recordPreprocessorSourceUri.equals(that.recordPreprocessorSourceUri) : that.recordPreprocessorSourceUri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.imageUri.hashCode();
                result = 31 * result + (this.containerArguments != null ? this.containerArguments.hashCode() : 0);
                result = 31 * result + (this.containerEntrypoint != null ? this.containerEntrypoint.hashCode() : 0);
                result = 31 * result + (this.postAnalyticsProcessorSourceUri != null ? this.postAnalyticsProcessorSourceUri.hashCode() : 0);
                result = 31 * result + (this.recordPreprocessorSourceUri != null ? this.recordPreprocessorSourceUri.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringExecutionSummaryProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringExecutionSummaryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringExecutionSummaryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.CreationTime`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-creationtime
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCreationTime();

        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.LastModifiedTime`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-lastmodifiedtime
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLastModifiedTime();

        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.MonitoringExecutionStatus`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-monitoringexecutionstatus
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMonitoringExecutionStatus();

        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.MonitoringScheduleName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-monitoringschedulename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMonitoringScheduleName();

        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.ScheduledTime`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-scheduledtime
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScheduledTime();

        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.EndpointName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-endpointname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEndpointName() {
            return null;
        }

        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.FailureReason`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-failurereason
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFailureReason() {
            return null;
        }

        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.ProcessingJobArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-processingjobarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProcessingJobArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MonitoringExecutionSummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringExecutionSummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringExecutionSummaryProperty> {
            private java.lang.String creationTime;
            private java.lang.String lastModifiedTime;
            private java.lang.String monitoringExecutionStatus;
            private java.lang.String monitoringScheduleName;
            private java.lang.String scheduledTime;
            private java.lang.String endpointName;
            private java.lang.String failureReason;
            private java.lang.String processingJobArn;

            /**
             * Sets the value of {@link MonitoringExecutionSummaryProperty#getCreationTime}
             * @param creationTime `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.CreationTime`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder creationTime(java.lang.String creationTime) {
                this.creationTime = creationTime;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringExecutionSummaryProperty#getLastModifiedTime}
             * @param lastModifiedTime `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.LastModifiedTime`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lastModifiedTime(java.lang.String lastModifiedTime) {
                this.lastModifiedTime = lastModifiedTime;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringExecutionSummaryProperty#getMonitoringExecutionStatus}
             * @param monitoringExecutionStatus `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.MonitoringExecutionStatus`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringExecutionStatus(java.lang.String monitoringExecutionStatus) {
                this.monitoringExecutionStatus = monitoringExecutionStatus;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringExecutionSummaryProperty#getMonitoringScheduleName}
             * @param monitoringScheduleName `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.MonitoringScheduleName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringScheduleName(java.lang.String monitoringScheduleName) {
                this.monitoringScheduleName = monitoringScheduleName;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringExecutionSummaryProperty#getScheduledTime}
             * @param scheduledTime `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.ScheduledTime`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduledTime(java.lang.String scheduledTime) {
                this.scheduledTime = scheduledTime;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringExecutionSummaryProperty#getEndpointName}
             * @param endpointName `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.EndpointName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointName(java.lang.String endpointName) {
                this.endpointName = endpointName;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringExecutionSummaryProperty#getFailureReason}
             * @param failureReason `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.FailureReason`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureReason(java.lang.String failureReason) {
                this.failureReason = failureReason;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringExecutionSummaryProperty#getProcessingJobArn}
             * @param processingJobArn `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.ProcessingJobArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingJobArn(java.lang.String processingJobArn) {
                this.processingJobArn = processingJobArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringExecutionSummaryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringExecutionSummaryProperty build() {
                return new Jsii$Proxy(creationTime, lastModifiedTime, monitoringExecutionStatus, monitoringScheduleName, scheduledTime, endpointName, failureReason, processingJobArn);
            }
        }

        /**
         * An implementation for {@link MonitoringExecutionSummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringExecutionSummaryProperty {
            private final java.lang.String creationTime;
            private final java.lang.String lastModifiedTime;
            private final java.lang.String monitoringExecutionStatus;
            private final java.lang.String monitoringScheduleName;
            private final java.lang.String scheduledTime;
            private final java.lang.String endpointName;
            private final java.lang.String failureReason;
            private final java.lang.String processingJobArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.creationTime = software.amazon.jsii.Kernel.get(this, "creationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lastModifiedTime = software.amazon.jsii.Kernel.get(this, "lastModifiedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.monitoringExecutionStatus = software.amazon.jsii.Kernel.get(this, "monitoringExecutionStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.monitoringScheduleName = software.amazon.jsii.Kernel.get(this, "monitoringScheduleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scheduledTime = software.amazon.jsii.Kernel.get(this, "scheduledTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endpointName = software.amazon.jsii.Kernel.get(this, "endpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.failureReason = software.amazon.jsii.Kernel.get(this, "failureReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.processingJobArn = software.amazon.jsii.Kernel.get(this, "processingJobArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String creationTime, final java.lang.String lastModifiedTime, final java.lang.String monitoringExecutionStatus, final java.lang.String monitoringScheduleName, final java.lang.String scheduledTime, final java.lang.String endpointName, final java.lang.String failureReason, final java.lang.String processingJobArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.creationTime = java.util.Objects.requireNonNull(creationTime, "creationTime is required");
                this.lastModifiedTime = java.util.Objects.requireNonNull(lastModifiedTime, "lastModifiedTime is required");
                this.monitoringExecutionStatus = java.util.Objects.requireNonNull(monitoringExecutionStatus, "monitoringExecutionStatus is required");
                this.monitoringScheduleName = java.util.Objects.requireNonNull(monitoringScheduleName, "monitoringScheduleName is required");
                this.scheduledTime = java.util.Objects.requireNonNull(scheduledTime, "scheduledTime is required");
                this.endpointName = endpointName;
                this.failureReason = failureReason;
                this.processingJobArn = processingJobArn;
            }

            @Override
            public final java.lang.String getCreationTime() {
                return this.creationTime;
            }

            @Override
            public final java.lang.String getLastModifiedTime() {
                return this.lastModifiedTime;
            }

            @Override
            public final java.lang.String getMonitoringExecutionStatus() {
                return this.monitoringExecutionStatus;
            }

            @Override
            public final java.lang.String getMonitoringScheduleName() {
                return this.monitoringScheduleName;
            }

            @Override
            public final java.lang.String getScheduledTime() {
                return this.scheduledTime;
            }

            @Override
            public final java.lang.String getEndpointName() {
                return this.endpointName;
            }

            @Override
            public final java.lang.String getFailureReason() {
                return this.failureReason;
            }

            @Override
            public final java.lang.String getProcessingJobArn() {
                return this.processingJobArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("creationTime", om.valueToTree(this.getCreationTime()));
                data.set("lastModifiedTime", om.valueToTree(this.getLastModifiedTime()));
                data.set("monitoringExecutionStatus", om.valueToTree(this.getMonitoringExecutionStatus()));
                data.set("monitoringScheduleName", om.valueToTree(this.getMonitoringScheduleName()));
                data.set("scheduledTime", om.valueToTree(this.getScheduledTime()));
                if (this.getEndpointName() != null) {
                    data.set("endpointName", om.valueToTree(this.getEndpointName()));
                }
                if (this.getFailureReason() != null) {
                    data.set("failureReason", om.valueToTree(this.getFailureReason()));
                }
                if (this.getProcessingJobArn() != null) {
                    data.set("processingJobArn", om.valueToTree(this.getProcessingJobArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringExecutionSummaryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringExecutionSummaryProperty.Jsii$Proxy that = (MonitoringExecutionSummaryProperty.Jsii$Proxy) o;

                if (!creationTime.equals(that.creationTime)) return false;
                if (!lastModifiedTime.equals(that.lastModifiedTime)) return false;
                if (!monitoringExecutionStatus.equals(that.monitoringExecutionStatus)) return false;
                if (!monitoringScheduleName.equals(that.monitoringScheduleName)) return false;
                if (!scheduledTime.equals(that.scheduledTime)) return false;
                if (this.endpointName != null ? !this.endpointName.equals(that.endpointName) : that.endpointName != null) return false;
                if (this.failureReason != null ? !this.failureReason.equals(that.failureReason) : that.failureReason != null) return false;
                return this.processingJobArn != null ? this.processingJobArn.equals(that.processingJobArn) : that.processingJobArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.creationTime.hashCode();
                result = 31 * result + (this.lastModifiedTime.hashCode());
                result = 31 * result + (this.monitoringExecutionStatus.hashCode());
                result = 31 * result + (this.monitoringScheduleName.hashCode());
                result = 31 * result + (this.scheduledTime.hashCode());
                result = 31 * result + (this.endpointName != null ? this.endpointName.hashCode() : 0);
                result = 31 * result + (this.failureReason != null ? this.failureReason.hashCode() : 0);
                result = 31 * result + (this.processingJobArn != null ? this.processingJobArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinput.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringInputProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMonitoringSchedule.MonitoringInputProperty.EndpointInput`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinput.html#cfn-sagemaker-monitoringschedule-monitoringinput-endpointinput
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEndpointInput();

        /**
         * @return a {@link Builder} of {@link MonitoringInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringInputProperty> {
            private java.lang.Object endpointInput;

            /**
             * Sets the value of {@link MonitoringInputProperty#getEndpointInput}
             * @param endpointInput `CfnMonitoringSchedule.MonitoringInputProperty.EndpointInput`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointInput(software.amazon.awscdk.core.IResolvable endpointInput) {
                this.endpointInput = endpointInput;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringInputProperty#getEndpointInput}
             * @param endpointInput `CfnMonitoringSchedule.MonitoringInputProperty.EndpointInput`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointInput(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.EndpointInputProperty endpointInput) {
                this.endpointInput = endpointInput;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringInputProperty build() {
                return new Jsii$Proxy(endpointInput);
            }
        }

        /**
         * An implementation for {@link MonitoringInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringInputProperty {
            private final java.lang.Object endpointInput;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endpointInput = software.amazon.jsii.Kernel.get(this, "endpointInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object endpointInput) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endpointInput = java.util.Objects.requireNonNull(endpointInput, "endpointInput is required");
            }

            @Override
            public final java.lang.Object getEndpointInput() {
                return this.endpointInput;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endpointInput", om.valueToTree(this.getEndpointInput()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringInputProperty.Jsii$Proxy that = (MonitoringInputProperty.Jsii$Proxy) o;

                return this.endpointInput.equals(that.endpointInput);
            }

            @Override
            public final int hashCode() {
                int result = this.endpointInput.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinputs.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringInputsProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringInputsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringInputsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMonitoringSchedule.MonitoringInputsProperty.MonitoringInputs`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinputs.html#cfn-sagemaker-monitoringschedule-monitoringinputs-monitoringinputs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMonitoringInputs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MonitoringInputsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringInputsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringInputsProperty> {
            private java.lang.Object monitoringInputs;

            /**
             * Sets the value of {@link MonitoringInputsProperty#getMonitoringInputs}
             * @param monitoringInputs `CfnMonitoringSchedule.MonitoringInputsProperty.MonitoringInputs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringInputs(software.amazon.awscdk.core.IResolvable monitoringInputs) {
                this.monitoringInputs = monitoringInputs;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringInputsProperty#getMonitoringInputs}
             * @param monitoringInputs `CfnMonitoringSchedule.MonitoringInputsProperty.MonitoringInputs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringInputs(java.util.List<? extends java.lang.Object> monitoringInputs) {
                this.monitoringInputs = monitoringInputs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringInputsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringInputsProperty build() {
                return new Jsii$Proxy(monitoringInputs);
            }
        }

        /**
         * An implementation for {@link MonitoringInputsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringInputsProperty {
            private final java.lang.Object monitoringInputs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.monitoringInputs = software.amazon.jsii.Kernel.get(this, "monitoringInputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object monitoringInputs) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.monitoringInputs = monitoringInputs;
            }

            @Override
            public final java.lang.Object getMonitoringInputs() {
                return this.monitoringInputs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMonitoringInputs() != null) {
                    data.set("monitoringInputs", om.valueToTree(this.getMonitoringInputs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringInputsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringInputsProperty.Jsii$Proxy that = (MonitoringInputsProperty.Jsii$Proxy) o;

                return this.monitoringInputs != null ? this.monitoringInputs.equals(that.monitoringInputs) : that.monitoringInputs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.monitoringInputs != null ? this.monitoringInputs.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringJobDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringJobDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringJobDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringAppSpecification`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringappspecification
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMonitoringAppSpecification();

        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringInputs`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringinputs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMonitoringInputs();

        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringOutputConfig`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringoutputconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMonitoringOutputConfig();

        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringResources`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringresources
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMonitoringResources();

        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.RoleArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-rolearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.BaselineConfig`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-baselineconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBaselineConfig() {
            return null;
        }

        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.Environment`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-environment
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
            return null;
        }

        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.NetworkConfig`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-networkconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfig() {
            return null;
        }

        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.StoppingCondition`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-stoppingcondition
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStoppingCondition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MonitoringJobDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringJobDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringJobDefinitionProperty> {
            private java.lang.Object monitoringAppSpecification;
            private java.lang.Object monitoringInputs;
            private java.lang.Object monitoringOutputConfig;
            private java.lang.Object monitoringResources;
            private java.lang.String roleArn;
            private java.lang.Object baselineConfig;
            private java.lang.Object environment;
            private java.lang.Object networkConfig;
            private java.lang.Object stoppingCondition;

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getMonitoringAppSpecification}
             * @param monitoringAppSpecification `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringAppSpecification`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringAppSpecification(software.amazon.awscdk.core.IResolvable monitoringAppSpecification) {
                this.monitoringAppSpecification = monitoringAppSpecification;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getMonitoringAppSpecification}
             * @param monitoringAppSpecification `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringAppSpecification`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringAppSpecification(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.MonitoringAppSpecificationProperty monitoringAppSpecification) {
                this.monitoringAppSpecification = monitoringAppSpecification;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getMonitoringInputs}
             * @param monitoringInputs `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringInputs`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringInputs(software.amazon.awscdk.core.IResolvable monitoringInputs) {
                this.monitoringInputs = monitoringInputs;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getMonitoringInputs}
             * @param monitoringInputs `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringInputs`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringInputs(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.MonitoringInputsProperty monitoringInputs) {
                this.monitoringInputs = monitoringInputs;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getMonitoringOutputConfig}
             * @param monitoringOutputConfig `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringOutputConfig`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringOutputConfig(software.amazon.awscdk.core.IResolvable monitoringOutputConfig) {
                this.monitoringOutputConfig = monitoringOutputConfig;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getMonitoringOutputConfig}
             * @param monitoringOutputConfig `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringOutputConfig`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringOutputConfig(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.MonitoringOutputConfigProperty monitoringOutputConfig) {
                this.monitoringOutputConfig = monitoringOutputConfig;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getMonitoringResources}
             * @param monitoringResources `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringResources`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringResources(software.amazon.awscdk.core.IResolvable monitoringResources) {
                this.monitoringResources = monitoringResources;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getMonitoringResources}
             * @param monitoringResources `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringResources`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringResources(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.MonitoringResourcesProperty monitoringResources) {
                this.monitoringResources = monitoringResources;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getRoleArn}
             * @param roleArn `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.RoleArn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getBaselineConfig}
             * @param baselineConfig `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.BaselineConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baselineConfig(software.amazon.awscdk.core.IResolvable baselineConfig) {
                this.baselineConfig = baselineConfig;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getBaselineConfig}
             * @param baselineConfig `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.BaselineConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baselineConfig(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.BaselineConfigProperty baselineConfig) {
                this.baselineConfig = baselineConfig;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getEnvironment}
             * @param environment `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.Environment`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(software.amazon.awscdk.core.IResolvable environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getEnvironment}
             * @param environment `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.Environment`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.EnvironmentProperty environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getNetworkConfig}
             * @param networkConfig `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.NetworkConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkConfig(software.amazon.awscdk.core.IResolvable networkConfig) {
                this.networkConfig = networkConfig;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getNetworkConfig}
             * @param networkConfig `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.NetworkConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkConfig(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.NetworkConfigProperty networkConfig) {
                this.networkConfig = networkConfig;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getStoppingCondition}
             * @param stoppingCondition `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.StoppingCondition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stoppingCondition(software.amazon.awscdk.core.IResolvable stoppingCondition) {
                this.stoppingCondition = stoppingCondition;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getStoppingCondition}
             * @param stoppingCondition `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.StoppingCondition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stoppingCondition(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.StoppingConditionProperty stoppingCondition) {
                this.stoppingCondition = stoppingCondition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringJobDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringJobDefinitionProperty build() {
                return new Jsii$Proxy(monitoringAppSpecification, monitoringInputs, monitoringOutputConfig, monitoringResources, roleArn, baselineConfig, environment, networkConfig, stoppingCondition);
            }
        }

        /**
         * An implementation for {@link MonitoringJobDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringJobDefinitionProperty {
            private final java.lang.Object monitoringAppSpecification;
            private final java.lang.Object monitoringInputs;
            private final java.lang.Object monitoringOutputConfig;
            private final java.lang.Object monitoringResources;
            private final java.lang.String roleArn;
            private final java.lang.Object baselineConfig;
            private final java.lang.Object environment;
            private final java.lang.Object networkConfig;
            private final java.lang.Object stoppingCondition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.monitoringAppSpecification = software.amazon.jsii.Kernel.get(this, "monitoringAppSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.monitoringInputs = software.amazon.jsii.Kernel.get(this, "monitoringInputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.monitoringOutputConfig = software.amazon.jsii.Kernel.get(this, "monitoringOutputConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.monitoringResources = software.amazon.jsii.Kernel.get(this, "monitoringResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.baselineConfig = software.amazon.jsii.Kernel.get(this, "baselineConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkConfig = software.amazon.jsii.Kernel.get(this, "networkConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stoppingCondition = software.amazon.jsii.Kernel.get(this, "stoppingCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object monitoringAppSpecification, final java.lang.Object monitoringInputs, final java.lang.Object monitoringOutputConfig, final java.lang.Object monitoringResources, final java.lang.String roleArn, final java.lang.Object baselineConfig, final java.lang.Object environment, final java.lang.Object networkConfig, final java.lang.Object stoppingCondition) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.monitoringAppSpecification = java.util.Objects.requireNonNull(monitoringAppSpecification, "monitoringAppSpecification is required");
                this.monitoringInputs = java.util.Objects.requireNonNull(monitoringInputs, "monitoringInputs is required");
                this.monitoringOutputConfig = java.util.Objects.requireNonNull(monitoringOutputConfig, "monitoringOutputConfig is required");
                this.monitoringResources = java.util.Objects.requireNonNull(monitoringResources, "monitoringResources is required");
                this.roleArn = java.util.Objects.requireNonNull(roleArn, "roleArn is required");
                this.baselineConfig = baselineConfig;
                this.environment = environment;
                this.networkConfig = networkConfig;
                this.stoppingCondition = stoppingCondition;
            }

            @Override
            public final java.lang.Object getMonitoringAppSpecification() {
                return this.monitoringAppSpecification;
            }

            @Override
            public final java.lang.Object getMonitoringInputs() {
                return this.monitoringInputs;
            }

            @Override
            public final java.lang.Object getMonitoringOutputConfig() {
                return this.monitoringOutputConfig;
            }

            @Override
            public final java.lang.Object getMonitoringResources() {
                return this.monitoringResources;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getBaselineConfig() {
                return this.baselineConfig;
            }

            @Override
            public final java.lang.Object getEnvironment() {
                return this.environment;
            }

            @Override
            public final java.lang.Object getNetworkConfig() {
                return this.networkConfig;
            }

            @Override
            public final java.lang.Object getStoppingCondition() {
                return this.stoppingCondition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("monitoringAppSpecification", om.valueToTree(this.getMonitoringAppSpecification()));
                data.set("monitoringInputs", om.valueToTree(this.getMonitoringInputs()));
                data.set("monitoringOutputConfig", om.valueToTree(this.getMonitoringOutputConfig()));
                data.set("monitoringResources", om.valueToTree(this.getMonitoringResources()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getBaselineConfig() != null) {
                    data.set("baselineConfig", om.valueToTree(this.getBaselineConfig()));
                }
                if (this.getEnvironment() != null) {
                    data.set("environment", om.valueToTree(this.getEnvironment()));
                }
                if (this.getNetworkConfig() != null) {
                    data.set("networkConfig", om.valueToTree(this.getNetworkConfig()));
                }
                if (this.getStoppingCondition() != null) {
                    data.set("stoppingCondition", om.valueToTree(this.getStoppingCondition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringJobDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringJobDefinitionProperty.Jsii$Proxy that = (MonitoringJobDefinitionProperty.Jsii$Proxy) o;

                if (!monitoringAppSpecification.equals(that.monitoringAppSpecification)) return false;
                if (!monitoringInputs.equals(that.monitoringInputs)) return false;
                if (!monitoringOutputConfig.equals(that.monitoringOutputConfig)) return false;
                if (!monitoringResources.equals(that.monitoringResources)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (this.baselineConfig != null ? !this.baselineConfig.equals(that.baselineConfig) : that.baselineConfig != null) return false;
                if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
                if (this.networkConfig != null ? !this.networkConfig.equals(that.networkConfig) : that.networkConfig != null) return false;
                return this.stoppingCondition != null ? this.stoppingCondition.equals(that.stoppingCondition) : that.stoppingCondition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.monitoringAppSpecification.hashCode();
                result = 31 * result + (this.monitoringInputs.hashCode());
                result = 31 * result + (this.monitoringOutputConfig.hashCode());
                result = 31 * result + (this.monitoringResources.hashCode());
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.baselineConfig != null ? this.baselineConfig.hashCode() : 0);
                result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
                result = 31 * result + (this.networkConfig != null ? this.networkConfig.hashCode() : 0);
                result = 31 * result + (this.stoppingCondition != null ? this.stoppingCondition.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutputconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringOutputConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringOutputConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringOutputConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMonitoringSchedule.MonitoringOutputConfigProperty.MonitoringOutputs`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutputconfig.html#cfn-sagemaker-monitoringschedule-monitoringoutputconfig-monitoringoutputs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMonitoringOutputs();

        /**
         * `CfnMonitoringSchedule.MonitoringOutputConfigProperty.KmsKeyId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutputconfig.html#cfn-sagemaker-monitoringschedule-monitoringoutputconfig-kmskeyid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MonitoringOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringOutputConfigProperty> {
            private java.lang.Object monitoringOutputs;
            private java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link MonitoringOutputConfigProperty#getMonitoringOutputs}
             * @param monitoringOutputs `CfnMonitoringSchedule.MonitoringOutputConfigProperty.MonitoringOutputs`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringOutputs(software.amazon.awscdk.core.IResolvable monitoringOutputs) {
                this.monitoringOutputs = monitoringOutputs;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringOutputConfigProperty#getMonitoringOutputs}
             * @param monitoringOutputs `CfnMonitoringSchedule.MonitoringOutputConfigProperty.MonitoringOutputs`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringOutputs(java.util.List<? extends java.lang.Object> monitoringOutputs) {
                this.monitoringOutputs = monitoringOutputs;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringOutputConfigProperty#getKmsKeyId}
             * @param kmsKeyId `CfnMonitoringSchedule.MonitoringOutputConfigProperty.KmsKeyId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringOutputConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringOutputConfigProperty build() {
                return new Jsii$Proxy(monitoringOutputs, kmsKeyId);
            }
        }

        /**
         * An implementation for {@link MonitoringOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringOutputConfigProperty {
            private final java.lang.Object monitoringOutputs;
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.monitoringOutputs = software.amazon.jsii.Kernel.get(this, "monitoringOutputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object monitoringOutputs, final java.lang.String kmsKeyId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.monitoringOutputs = java.util.Objects.requireNonNull(monitoringOutputs, "monitoringOutputs is required");
                this.kmsKeyId = kmsKeyId;
            }

            @Override
            public final java.lang.Object getMonitoringOutputs() {
                return this.monitoringOutputs;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("monitoringOutputs", om.valueToTree(this.getMonitoringOutputs()));
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringOutputConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringOutputConfigProperty.Jsii$Proxy that = (MonitoringOutputConfigProperty.Jsii$Proxy) o;

                if (!monitoringOutputs.equals(that.monitoringOutputs)) return false;
                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.monitoringOutputs.hashCode();
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutput.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringOutputProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringOutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMonitoringSchedule.MonitoringOutputProperty.S3Output`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutput.html#cfn-sagemaker-monitoringschedule-monitoringoutput-s3output
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Output();

        /**
         * @return a {@link Builder} of {@link MonitoringOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringOutputProperty> {
            private java.lang.Object s3Output;

            /**
             * Sets the value of {@link MonitoringOutputProperty#getS3Output}
             * @param s3Output `CfnMonitoringSchedule.MonitoringOutputProperty.S3Output`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Output(software.amazon.awscdk.core.IResolvable s3Output) {
                this.s3Output = s3Output;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringOutputProperty#getS3Output}
             * @param s3Output `CfnMonitoringSchedule.MonitoringOutputProperty.S3Output`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Output(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.S3OutputProperty s3Output) {
                this.s3Output = s3Output;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringOutputProperty build() {
                return new Jsii$Proxy(s3Output);
            }
        }

        /**
         * An implementation for {@link MonitoringOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringOutputProperty {
            private final java.lang.Object s3Output;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Output = software.amazon.jsii.Kernel.get(this, "s3Output", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object s3Output) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Output = java.util.Objects.requireNonNull(s3Output, "s3Output is required");
            }

            @Override
            public final java.lang.Object getS3Output() {
                return this.s3Output;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Output", om.valueToTree(this.getS3Output()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringOutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringOutputProperty.Jsii$Proxy that = (MonitoringOutputProperty.Jsii$Proxy) o;

                return this.s3Output.equals(that.s3Output);
            }

            @Override
            public final int hashCode() {
                int result = this.s3Output.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringresources.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringResourcesProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringResourcesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringResourcesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMonitoringSchedule.MonitoringResourcesProperty.ClusterConfig`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringresources.html#cfn-sagemaker-monitoringschedule-monitoringresources-clusterconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getClusterConfig();

        /**
         * @return a {@link Builder} of {@link MonitoringResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringResourcesProperty> {
            private java.lang.Object clusterConfig;

            /**
             * Sets the value of {@link MonitoringResourcesProperty#getClusterConfig}
             * @param clusterConfig `CfnMonitoringSchedule.MonitoringResourcesProperty.ClusterConfig`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterConfig(software.amazon.awscdk.core.IResolvable clusterConfig) {
                this.clusterConfig = clusterConfig;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringResourcesProperty#getClusterConfig}
             * @param clusterConfig `CfnMonitoringSchedule.MonitoringResourcesProperty.ClusterConfig`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterConfig(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.ClusterConfigProperty clusterConfig) {
                this.clusterConfig = clusterConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringResourcesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringResourcesProperty build() {
                return new Jsii$Proxy(clusterConfig);
            }
        }

        /**
         * An implementation for {@link MonitoringResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringResourcesProperty {
            private final java.lang.Object clusterConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clusterConfig = software.amazon.jsii.Kernel.get(this, "clusterConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object clusterConfig) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clusterConfig = java.util.Objects.requireNonNull(clusterConfig, "clusterConfig is required");
            }

            @Override
            public final java.lang.Object getClusterConfig() {
                return this.clusterConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clusterConfig", om.valueToTree(this.getClusterConfig()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringResourcesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringResourcesProperty.Jsii$Proxy that = (MonitoringResourcesProperty.Jsii$Proxy) o;

                return this.clusterConfig.equals(that.clusterConfig);
            }

            @Override
            public final int hashCode() {
                int result = this.clusterConfig.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringScheduleConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringScheduleConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringScheduleConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMonitoringSchedule.MonitoringScheduleConfigProperty.MonitoringJobDefinition`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig-monitoringjobdefinition
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMonitoringJobDefinition();

        /**
         * `CfnMonitoringSchedule.MonitoringScheduleConfigProperty.ScheduleConfig`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig-scheduleconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScheduleConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MonitoringScheduleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringScheduleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringScheduleConfigProperty> {
            private java.lang.Object monitoringJobDefinition;
            private java.lang.Object scheduleConfig;

            /**
             * Sets the value of {@link MonitoringScheduleConfigProperty#getMonitoringJobDefinition}
             * @param monitoringJobDefinition `CfnMonitoringSchedule.MonitoringScheduleConfigProperty.MonitoringJobDefinition`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringJobDefinition(software.amazon.awscdk.core.IResolvable monitoringJobDefinition) {
                this.monitoringJobDefinition = monitoringJobDefinition;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringScheduleConfigProperty#getMonitoringJobDefinition}
             * @param monitoringJobDefinition `CfnMonitoringSchedule.MonitoringScheduleConfigProperty.MonitoringJobDefinition`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringJobDefinition(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.MonitoringJobDefinitionProperty monitoringJobDefinition) {
                this.monitoringJobDefinition = monitoringJobDefinition;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringScheduleConfigProperty#getScheduleConfig}
             * @param scheduleConfig `CfnMonitoringSchedule.MonitoringScheduleConfigProperty.ScheduleConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleConfig(software.amazon.awscdk.core.IResolvable scheduleConfig) {
                this.scheduleConfig = scheduleConfig;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringScheduleConfigProperty#getScheduleConfig}
             * @param scheduleConfig `CfnMonitoringSchedule.MonitoringScheduleConfigProperty.ScheduleConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleConfig(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.ScheduleConfigProperty scheduleConfig) {
                this.scheduleConfig = scheduleConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringScheduleConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringScheduleConfigProperty build() {
                return new Jsii$Proxy(monitoringJobDefinition, scheduleConfig);
            }
        }

        /**
         * An implementation for {@link MonitoringScheduleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringScheduleConfigProperty {
            private final java.lang.Object monitoringJobDefinition;
            private final java.lang.Object scheduleConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.monitoringJobDefinition = software.amazon.jsii.Kernel.get(this, "monitoringJobDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scheduleConfig = software.amazon.jsii.Kernel.get(this, "scheduleConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object monitoringJobDefinition, final java.lang.Object scheduleConfig) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.monitoringJobDefinition = java.util.Objects.requireNonNull(monitoringJobDefinition, "monitoringJobDefinition is required");
                this.scheduleConfig = scheduleConfig;
            }

            @Override
            public final java.lang.Object getMonitoringJobDefinition() {
                return this.monitoringJobDefinition;
            }

            @Override
            public final java.lang.Object getScheduleConfig() {
                return this.scheduleConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("monitoringJobDefinition", om.valueToTree(this.getMonitoringJobDefinition()));
                if (this.getScheduleConfig() != null) {
                    data.set("scheduleConfig", om.valueToTree(this.getScheduleConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringScheduleConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringScheduleConfigProperty.Jsii$Proxy that = (MonitoringScheduleConfigProperty.Jsii$Proxy) o;

                if (!monitoringJobDefinition.equals(that.monitoringJobDefinition)) return false;
                return this.scheduleConfig != null ? this.scheduleConfig.equals(that.scheduleConfig) : that.scheduleConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.monitoringJobDefinition.hashCode();
                result = 31 * result + (this.scheduleConfig != null ? this.scheduleConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.NetworkConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMonitoringSchedule.NetworkConfigProperty.EnableInterContainerTrafficEncryption`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html#cfn-sagemaker-monitoringschedule-networkconfig-enableintercontainertrafficencryption
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableInterContainerTrafficEncryption() {
            return null;
        }

        /**
         * `CfnMonitoringSchedule.NetworkConfigProperty.EnableNetworkIsolation`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html#cfn-sagemaker-monitoringschedule-networkconfig-enablenetworkisolation
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableNetworkIsolation() {
            return null;
        }

        /**
         * `CfnMonitoringSchedule.NetworkConfigProperty.VpcConfig`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html#cfn-sagemaker-monitoringschedule-networkconfig-vpcconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkConfigProperty> {
            private java.lang.Object enableInterContainerTrafficEncryption;
            private java.lang.Object enableNetworkIsolation;
            private java.lang.Object vpcConfig;

            /**
             * Sets the value of {@link NetworkConfigProperty#getEnableInterContainerTrafficEncryption}
             * @param enableInterContainerTrafficEncryption `CfnMonitoringSchedule.NetworkConfigProperty.EnableInterContainerTrafficEncryption`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableInterContainerTrafficEncryption(java.lang.Boolean enableInterContainerTrafficEncryption) {
                this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getEnableInterContainerTrafficEncryption}
             * @param enableInterContainerTrafficEncryption `CfnMonitoringSchedule.NetworkConfigProperty.EnableInterContainerTrafficEncryption`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableInterContainerTrafficEncryption(software.amazon.awscdk.core.IResolvable enableInterContainerTrafficEncryption) {
                this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getEnableNetworkIsolation}
             * @param enableNetworkIsolation `CfnMonitoringSchedule.NetworkConfigProperty.EnableNetworkIsolation`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableNetworkIsolation(java.lang.Boolean enableNetworkIsolation) {
                this.enableNetworkIsolation = enableNetworkIsolation;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getEnableNetworkIsolation}
             * @param enableNetworkIsolation `CfnMonitoringSchedule.NetworkConfigProperty.EnableNetworkIsolation`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableNetworkIsolation(software.amazon.awscdk.core.IResolvable enableNetworkIsolation) {
                this.enableNetworkIsolation = enableNetworkIsolation;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getVpcConfig}
             * @param vpcConfig `CfnMonitoringSchedule.NetworkConfigProperty.VpcConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfig(software.amazon.awscdk.core.IResolvable vpcConfig) {
                this.vpcConfig = vpcConfig;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getVpcConfig}
             * @param vpcConfig `CfnMonitoringSchedule.NetworkConfigProperty.VpcConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfig(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.VpcConfigProperty vpcConfig) {
                this.vpcConfig = vpcConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkConfigProperty build() {
                return new Jsii$Proxy(enableInterContainerTrafficEncryption, enableNetworkIsolation, vpcConfig);
            }
        }

        /**
         * An implementation for {@link NetworkConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkConfigProperty {
            private final java.lang.Object enableInterContainerTrafficEncryption;
            private final java.lang.Object enableNetworkIsolation;
            private final java.lang.Object vpcConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableInterContainerTrafficEncryption = software.amazon.jsii.Kernel.get(this, "enableInterContainerTrafficEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableNetworkIsolation = software.amazon.jsii.Kernel.get(this, "enableNetworkIsolation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpcConfig = software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object enableInterContainerTrafficEncryption, final java.lang.Object enableNetworkIsolation, final java.lang.Object vpcConfig) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
                this.enableNetworkIsolation = enableNetworkIsolation;
                this.vpcConfig = vpcConfig;
            }

            @Override
            public final java.lang.Object getEnableInterContainerTrafficEncryption() {
                return this.enableInterContainerTrafficEncryption;
            }

            @Override
            public final java.lang.Object getEnableNetworkIsolation() {
                return this.enableNetworkIsolation;
            }

            @Override
            public final java.lang.Object getVpcConfig() {
                return this.vpcConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnableInterContainerTrafficEncryption() != null) {
                    data.set("enableInterContainerTrafficEncryption", om.valueToTree(this.getEnableInterContainerTrafficEncryption()));
                }
                if (this.getEnableNetworkIsolation() != null) {
                    data.set("enableNetworkIsolation", om.valueToTree(this.getEnableNetworkIsolation()));
                }
                if (this.getVpcConfig() != null) {
                    data.set("vpcConfig", om.valueToTree(this.getVpcConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.NetworkConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkConfigProperty.Jsii$Proxy that = (NetworkConfigProperty.Jsii$Proxy) o;

                if (this.enableInterContainerTrafficEncryption != null ? !this.enableInterContainerTrafficEncryption.equals(that.enableInterContainerTrafficEncryption) : that.enableInterContainerTrafficEncryption != null) return false;
                if (this.enableNetworkIsolation != null ? !this.enableNetworkIsolation.equals(that.enableNetworkIsolation) : that.enableNetworkIsolation != null) return false;
                return this.vpcConfig != null ? this.vpcConfig.equals(that.vpcConfig) : that.vpcConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableInterContainerTrafficEncryption != null ? this.enableInterContainerTrafficEncryption.hashCode() : 0;
                result = 31 * result + (this.enableNetworkIsolation != null ? this.enableNetworkIsolation.hashCode() : 0);
                result = 31 * result + (this.vpcConfig != null ? this.vpcConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.S3OutputProperty")
    @software.amazon.jsii.Jsii.Proxy(S3OutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3OutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMonitoringSchedule.S3OutputProperty.LocalPath`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html#cfn-sagemaker-monitoringschedule-s3output-localpath
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocalPath();

        /**
         * `CfnMonitoringSchedule.S3OutputProperty.S3Uri`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html#cfn-sagemaker-monitoringschedule-s3output-s3uri
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Uri();

        /**
         * `CfnMonitoringSchedule.S3OutputProperty.S3UploadMode`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html#cfn-sagemaker-monitoringschedule-s3output-s3uploadmode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3UploadMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3OutputProperty> {
            private java.lang.String localPath;
            private java.lang.String s3Uri;
            private java.lang.String s3UploadMode;

            /**
             * Sets the value of {@link S3OutputProperty#getLocalPath}
             * @param localPath `CfnMonitoringSchedule.S3OutputProperty.LocalPath`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localPath(java.lang.String localPath) {
                this.localPath = localPath;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputProperty#getS3Uri}
             * @param s3Uri `CfnMonitoringSchedule.S3OutputProperty.S3Uri`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputProperty#getS3UploadMode}
             * @param s3UploadMode `CfnMonitoringSchedule.S3OutputProperty.S3UploadMode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3UploadMode(java.lang.String s3UploadMode) {
                this.s3UploadMode = s3UploadMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3OutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3OutputProperty build() {
                return new Jsii$Proxy(localPath, s3Uri, s3UploadMode);
            }
        }

        /**
         * An implementation for {@link S3OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3OutputProperty {
            private final java.lang.String localPath;
            private final java.lang.String s3Uri;
            private final java.lang.String s3UploadMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.localPath = software.amazon.jsii.Kernel.get(this, "localPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3UploadMode = software.amazon.jsii.Kernel.get(this, "s3UploadMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String localPath, final java.lang.String s3Uri, final java.lang.String s3UploadMode) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.localPath = java.util.Objects.requireNonNull(localPath, "localPath is required");
                this.s3Uri = java.util.Objects.requireNonNull(s3Uri, "s3Uri is required");
                this.s3UploadMode = s3UploadMode;
            }

            @Override
            public final java.lang.String getLocalPath() {
                return this.localPath;
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            public final java.lang.String getS3UploadMode() {
                return this.s3UploadMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("localPath", om.valueToTree(this.getLocalPath()));
                data.set("s3Uri", om.valueToTree(this.getS3Uri()));
                if (this.getS3UploadMode() != null) {
                    data.set("s3UploadMode", om.valueToTree(this.getS3UploadMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.S3OutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3OutputProperty.Jsii$Proxy that = (S3OutputProperty.Jsii$Proxy) o;

                if (!localPath.equals(that.localPath)) return false;
                if (!s3Uri.equals(that.s3Uri)) return false;
                return this.s3UploadMode != null ? this.s3UploadMode.equals(that.s3UploadMode) : that.s3UploadMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.localPath.hashCode();
                result = 31 * result + (this.s3Uri.hashCode());
                result = 31 * result + (this.s3UploadMode != null ? this.s3UploadMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-scheduleconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.ScheduleConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduleConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduleConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMonitoringSchedule.ScheduleConfigProperty.ScheduleExpression`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-scheduleconfig.html#cfn-sagemaker-monitoringschedule-scheduleconfig-scheduleexpression
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScheduleExpression();

        /**
         * @return a {@link Builder} of {@link ScheduleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduleConfigProperty> {
            private java.lang.String scheduleExpression;

            /**
             * Sets the value of {@link ScheduleConfigProperty#getScheduleExpression}
             * @param scheduleExpression `CfnMonitoringSchedule.ScheduleConfigProperty.ScheduleExpression`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleExpression(java.lang.String scheduleExpression) {
                this.scheduleExpression = scheduleExpression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduleConfigProperty build() {
                return new Jsii$Proxy(scheduleExpression);
            }
        }

        /**
         * An implementation for {@link ScheduleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleConfigProperty {
            private final java.lang.String scheduleExpression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scheduleExpression = software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String scheduleExpression) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scheduleExpression = java.util.Objects.requireNonNull(scheduleExpression, "scheduleExpression is required");
            }

            @Override
            public final java.lang.String getScheduleExpression() {
                return this.scheduleExpression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.ScheduleConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduleConfigProperty.Jsii$Proxy that = (ScheduleConfigProperty.Jsii$Proxy) o;

                return this.scheduleExpression.equals(that.scheduleExpression);
            }

            @Override
            public final int hashCode() {
                int result = this.scheduleExpression.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-statisticsresource.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.StatisticsResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(StatisticsResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StatisticsResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMonitoringSchedule.StatisticsResourceProperty.S3Uri`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-statisticsresource.html#cfn-sagemaker-monitoringschedule-statisticsresource-s3uri
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3Uri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StatisticsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StatisticsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StatisticsResourceProperty> {
            private java.lang.String s3Uri;

            /**
             * Sets the value of {@link StatisticsResourceProperty#getS3Uri}
             * @param s3Uri `CfnMonitoringSchedule.StatisticsResourceProperty.S3Uri`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StatisticsResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StatisticsResourceProperty build() {
                return new Jsii$Proxy(s3Uri);
            }
        }

        /**
         * An implementation for {@link StatisticsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StatisticsResourceProperty {
            private final java.lang.String s3Uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String s3Uri) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Uri = s3Uri;
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3Uri() != null) {
                    data.set("s3Uri", om.valueToTree(this.getS3Uri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.StatisticsResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StatisticsResourceProperty.Jsii$Proxy that = (StatisticsResourceProperty.Jsii$Proxy) o;

                return this.s3Uri != null ? this.s3Uri.equals(that.s3Uri) : that.s3Uri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Uri != null ? this.s3Uri.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-stoppingcondition.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.StoppingConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(StoppingConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StoppingConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMonitoringSchedule.StoppingConditionProperty.MaxRuntimeInSeconds`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-stoppingcondition.html#cfn-sagemaker-monitoringschedule-stoppingcondition-maxruntimeinseconds
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxRuntimeInSeconds();

        /**
         * @return a {@link Builder} of {@link StoppingConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StoppingConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StoppingConditionProperty> {
            private java.lang.Number maxRuntimeInSeconds;

            /**
             * Sets the value of {@link StoppingConditionProperty#getMaxRuntimeInSeconds}
             * @param maxRuntimeInSeconds `CfnMonitoringSchedule.StoppingConditionProperty.MaxRuntimeInSeconds`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxRuntimeInSeconds(java.lang.Number maxRuntimeInSeconds) {
                this.maxRuntimeInSeconds = maxRuntimeInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StoppingConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StoppingConditionProperty build() {
                return new Jsii$Proxy(maxRuntimeInSeconds);
            }
        }

        /**
         * An implementation for {@link StoppingConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StoppingConditionProperty {
            private final java.lang.Number maxRuntimeInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxRuntimeInSeconds = software.amazon.jsii.Kernel.get(this, "maxRuntimeInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Number maxRuntimeInSeconds) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxRuntimeInSeconds = java.util.Objects.requireNonNull(maxRuntimeInSeconds, "maxRuntimeInSeconds is required");
            }

            @Override
            public final java.lang.Number getMaxRuntimeInSeconds() {
                return this.maxRuntimeInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxRuntimeInSeconds", om.valueToTree(this.getMaxRuntimeInSeconds()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.StoppingConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StoppingConditionProperty.Jsii$Proxy that = (StoppingConditionProperty.Jsii$Proxy) o;

                return this.maxRuntimeInSeconds.equals(that.maxRuntimeInSeconds);
            }

            @Override
            public final int hashCode() {
                int result = this.maxRuntimeInSeconds.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-vpcconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.VpcConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMonitoringSchedule.VpcConfigProperty.SecurityGroupIds`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-vpcconfig.html#cfn-sagemaker-monitoringschedule-vpcconfig-securitygroupids
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIds();

        /**
         * `CfnMonitoringSchedule.VpcConfigProperty.Subnets`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-vpcconfig.html#cfn-sagemaker-monitoringschedule-vpcconfig-subnets
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnets();

        /**
         * @return a {@link Builder} of {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcConfigProperty> {
            private java.util.List<java.lang.String> securityGroupIds;
            private java.util.List<java.lang.String> subnets;

            /**
             * Sets the value of {@link VpcConfigProperty#getSecurityGroupIds}
             * @param securityGroupIds `CfnMonitoringSchedule.VpcConfigProperty.SecurityGroupIds`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VpcConfigProperty#getSubnets}
             * @param subnets `CfnMonitoringSchedule.VpcConfigProperty.Subnets`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcConfigProperty build() {
                return new Jsii$Proxy(securityGroupIds, subnets);
            }
        }

        /**
         * An implementation for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConfigProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.util.List<java.lang.String> securityGroupIds, final java.util.List<java.lang.String> subnets) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = java.util.Objects.requireNonNull(securityGroupIds, "securityGroupIds is required");
                this.subnets = java.util.Objects.requireNonNull(subnets, "subnets is required");
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                data.set("subnets", om.valueToTree(this.getSubnets()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.VpcConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcConfigProperty.Jsii$Proxy that = (VpcConfigProperty.Jsii$Proxy) o;

                if (!securityGroupIds.equals(that.securityGroupIds)) return false;
                return this.subnets.equals(that.subnets);
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds.hashCode();
                result = 31 * result + (this.subnets.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sagemaker.CfnMonitoringScheduleProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sagemaker.CfnMonitoringScheduleProps.Builder();
        }

        /**
         * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleConfig`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig
         * @param monitoringScheduleConfig `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringScheduleConfig(final software.amazon.awscdk.core.IResolvable monitoringScheduleConfig) {
            this.props.monitoringScheduleConfig(monitoringScheduleConfig);
            return this;
        }
        /**
         * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleConfig`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig
         * @param monitoringScheduleConfig `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringScheduleConfig(final software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.MonitoringScheduleConfigProperty monitoringScheduleConfig) {
            this.props.monitoringScheduleConfig(monitoringScheduleConfig);
            return this;
        }

        /**
         * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulename
         * @param monitoringScheduleName `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringScheduleName(final java.lang.String monitoringScheduleName) {
            this.props.monitoringScheduleName(monitoringScheduleName);
            return this;
        }

        /**
         * `AWS::SageMaker::MonitoringSchedule.EndpointName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-endpointname
         * @param endpointName `AWS::SageMaker::MonitoringSchedule.EndpointName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointName(final java.lang.String endpointName) {
            this.props.endpointName(endpointName);
            return this;
        }

        /**
         * `AWS::SageMaker::MonitoringSchedule.FailureReason`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-failurereason
         * @param failureReason `AWS::SageMaker::MonitoringSchedule.FailureReason`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failureReason(final java.lang.String failureReason) {
            this.props.failureReason(failureReason);
            return this;
        }

        /**
         * `AWS::SageMaker::MonitoringSchedule.LastMonitoringExecutionSummary`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmonitoringexecutionsummary
         * @param lastMonitoringExecutionSummary `AWS::SageMaker::MonitoringSchedule.LastMonitoringExecutionSummary`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lastMonitoringExecutionSummary(final software.amazon.awscdk.core.IResolvable lastMonitoringExecutionSummary) {
            this.props.lastMonitoringExecutionSummary(lastMonitoringExecutionSummary);
            return this;
        }
        /**
         * `AWS::SageMaker::MonitoringSchedule.LastMonitoringExecutionSummary`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmonitoringexecutionsummary
         * @param lastMonitoringExecutionSummary `AWS::SageMaker::MonitoringSchedule.LastMonitoringExecutionSummary`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lastMonitoringExecutionSummary(final software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.MonitoringExecutionSummaryProperty lastMonitoringExecutionSummary) {
            this.props.lastMonitoringExecutionSummary(lastMonitoringExecutionSummary);
            return this;
        }

        /**
         * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleArn`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulearn
         * @param monitoringScheduleArn `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleArn`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringScheduleArn(final java.lang.String monitoringScheduleArn) {
            this.props.monitoringScheduleArn(monitoringScheduleArn);
            return this;
        }

        /**
         * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleStatus`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulestatus
         * @param monitoringScheduleStatus `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleStatus`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringScheduleStatus(final java.lang.String monitoringScheduleStatus) {
            this.props.monitoringScheduleStatus(monitoringScheduleStatus);
            return this;
        }

        /**
         * `AWS::SageMaker::MonitoringSchedule.Tags`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-tags
         * @param tags `AWS::SageMaker::MonitoringSchedule.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule build() {
            return new software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
