package software.amazon.awscdk.services.sagemaker;

/**
 * A CloudFormation `AWS::SageMaker::EndpointConfig`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2021-01-03T09:45:20.596Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnEndpointConfig")
public class CfnEndpointConfig extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnEndpointConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEndpointConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::SageMaker::EndpointConfig`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEndpointConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnEndpointConfigProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpointConfigName() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpointConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::SageMaker::EndpointConfig.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * `AWS::SageMaker::EndpointConfig.ProductionVariants`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getProductionVariants() {
        return software.amazon.jsii.Kernel.get(this, "productionVariants", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SageMaker::EndpointConfig.ProductionVariants`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProductionVariants(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "productionVariants", java.util.Objects.requireNonNull(value, "productionVariants is required"));
    }

    /**
     * `AWS::SageMaker::EndpointConfig.ProductionVariants`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProductionVariants(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "productionVariants", java.util.Objects.requireNonNull(value, "productionVariants is required"));
    }

    /**
     * `AWS::SageMaker::EndpointConfig.DataCaptureConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataCaptureConfig() {
        return software.amazon.jsii.Kernel.get(this, "dataCaptureConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SageMaker::EndpointConfig.DataCaptureConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataCaptureConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataCaptureConfig", value);
    }

    /**
     * `AWS::SageMaker::EndpointConfig.DataCaptureConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataCaptureConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.DataCaptureConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "dataCaptureConfig", value);
    }

    /**
     * `AWS::SageMaker::EndpointConfig.EndpointConfigName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndpointConfigName() {
        return software.amazon.jsii.Kernel.get(this, "endpointConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::SageMaker::EndpointConfig.EndpointConfigName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointConfigName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endpointConfigName", value);
    }

    /**
     * `AWS::SageMaker::EndpointConfig.KmsKeyId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::SageMaker::EndpointConfig.KmsKeyId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty")
    @software.amazon.jsii.Jsii.Proxy(CaptureContentTypeHeaderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CaptureContentTypeHeaderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEndpointConfig.CaptureContentTypeHeaderProperty.CsvContentTypes`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader-csvcontenttypes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCsvContentTypes() {
            return null;
        }

        /**
         * `CfnEndpointConfig.CaptureContentTypeHeaderProperty.JsonContentTypes`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader-jsoncontenttypes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getJsonContentTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CaptureContentTypeHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CaptureContentTypeHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CaptureContentTypeHeaderProperty> {
            private java.util.List<java.lang.String> csvContentTypes;
            private java.util.List<java.lang.String> jsonContentTypes;

            /**
             * Sets the value of {@link CaptureContentTypeHeaderProperty#getCsvContentTypes}
             * @param csvContentTypes `CfnEndpointConfig.CaptureContentTypeHeaderProperty.CsvContentTypes`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csvContentTypes(java.util.List<java.lang.String> csvContentTypes) {
                this.csvContentTypes = csvContentTypes;
                return this;
            }

            /**
             * Sets the value of {@link CaptureContentTypeHeaderProperty#getJsonContentTypes}
             * @param jsonContentTypes `CfnEndpointConfig.CaptureContentTypeHeaderProperty.JsonContentTypes`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonContentTypes(java.util.List<java.lang.String> jsonContentTypes) {
                this.jsonContentTypes = jsonContentTypes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CaptureContentTypeHeaderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CaptureContentTypeHeaderProperty build() {
                return new Jsii$Proxy(csvContentTypes, jsonContentTypes);
            }
        }

        /**
         * An implementation for {@link CaptureContentTypeHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CaptureContentTypeHeaderProperty {
            private final java.util.List<java.lang.String> csvContentTypes;
            private final java.util.List<java.lang.String> jsonContentTypes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.csvContentTypes = software.amazon.jsii.Kernel.get(this, "csvContentTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.jsonContentTypes = software.amazon.jsii.Kernel.get(this, "jsonContentTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.util.List<java.lang.String> csvContentTypes, final java.util.List<java.lang.String> jsonContentTypes) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.csvContentTypes = csvContentTypes;
                this.jsonContentTypes = jsonContentTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getCsvContentTypes() {
                return this.csvContentTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getJsonContentTypes() {
                return this.jsonContentTypes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCsvContentTypes() != null) {
                    data.set("csvContentTypes", om.valueToTree(this.getCsvContentTypes()));
                }
                if (this.getJsonContentTypes() != null) {
                    data.set("jsonContentTypes", om.valueToTree(this.getJsonContentTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CaptureContentTypeHeaderProperty.Jsii$Proxy that = (CaptureContentTypeHeaderProperty.Jsii$Proxy) o;

                if (this.csvContentTypes != null ? !this.csvContentTypes.equals(that.csvContentTypes) : that.csvContentTypes != null) return false;
                return this.jsonContentTypes != null ? this.jsonContentTypes.equals(that.jsonContentTypes) : that.jsonContentTypes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.csvContentTypes != null ? this.csvContentTypes.hashCode() : 0;
                result = 31 * result + (this.jsonContentTypes != null ? this.jsonContentTypes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-captureoption.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnEndpointConfig.CaptureOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(CaptureOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CaptureOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEndpointConfig.CaptureOptionProperty.CaptureMode`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-captureoption.html#cfn-sagemaker-endpointconfig-captureoption-capturemode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCaptureMode();

        /**
         * @return a {@link Builder} of {@link CaptureOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CaptureOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CaptureOptionProperty> {
            private java.lang.String captureMode;

            /**
             * Sets the value of {@link CaptureOptionProperty#getCaptureMode}
             * @param captureMode `CfnEndpointConfig.CaptureOptionProperty.CaptureMode`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureMode(java.lang.String captureMode) {
                this.captureMode = captureMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CaptureOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CaptureOptionProperty build() {
                return new Jsii$Proxy(captureMode);
            }
        }

        /**
         * An implementation for {@link CaptureOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CaptureOptionProperty {
            private final java.lang.String captureMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.captureMode = software.amazon.jsii.Kernel.get(this, "captureMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String captureMode) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.captureMode = java.util.Objects.requireNonNull(captureMode, "captureMode is required");
            }

            @Override
            public final java.lang.String getCaptureMode() {
                return this.captureMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("captureMode", om.valueToTree(this.getCaptureMode()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnEndpointConfig.CaptureOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CaptureOptionProperty.Jsii$Proxy that = (CaptureOptionProperty.Jsii$Proxy) o;

                return this.captureMode.equals(that.captureMode);
            }

            @Override
            public final int hashCode() {
                int result = this.captureMode.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnEndpointConfig.DataCaptureConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DataCaptureConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataCaptureConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.CaptureOptions`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-captureoptions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCaptureOptions();

        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.DestinationS3Uri`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-destinations3uri
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestinationS3Uri();

        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.InitialSamplingPercentage`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-initialsamplingpercentage
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getInitialSamplingPercentage();

        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.CaptureContentTypeHeader`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCaptureContentTypeHeader() {
            return null;
        }

        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.EnableCapture`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-enablecapture
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableCapture() {
            return null;
        }

        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.KmsKeyId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-kmskeyid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataCaptureConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataCaptureConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataCaptureConfigProperty> {
            private java.lang.Object captureOptions;
            private java.lang.String destinationS3Uri;
            private java.lang.Number initialSamplingPercentage;
            private java.lang.Object captureContentTypeHeader;
            private java.lang.Object enableCapture;
            private java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getCaptureOptions}
             * @param captureOptions `CfnEndpointConfig.DataCaptureConfigProperty.CaptureOptions`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureOptions(software.amazon.awscdk.core.IResolvable captureOptions) {
                this.captureOptions = captureOptions;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getCaptureOptions}
             * @param captureOptions `CfnEndpointConfig.DataCaptureConfigProperty.CaptureOptions`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureOptions(java.util.List<? extends java.lang.Object> captureOptions) {
                this.captureOptions = captureOptions;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getDestinationS3Uri}
             * @param destinationS3Uri `CfnEndpointConfig.DataCaptureConfigProperty.DestinationS3Uri`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationS3Uri(java.lang.String destinationS3Uri) {
                this.destinationS3Uri = destinationS3Uri;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getInitialSamplingPercentage}
             * @param initialSamplingPercentage `CfnEndpointConfig.DataCaptureConfigProperty.InitialSamplingPercentage`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initialSamplingPercentage(java.lang.Number initialSamplingPercentage) {
                this.initialSamplingPercentage = initialSamplingPercentage;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getCaptureContentTypeHeader}
             * @param captureContentTypeHeader `CfnEndpointConfig.DataCaptureConfigProperty.CaptureContentTypeHeader`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureContentTypeHeader(software.amazon.awscdk.core.IResolvable captureContentTypeHeader) {
                this.captureContentTypeHeader = captureContentTypeHeader;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getCaptureContentTypeHeader}
             * @param captureContentTypeHeader `CfnEndpointConfig.DataCaptureConfigProperty.CaptureContentTypeHeader`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureContentTypeHeader(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty captureContentTypeHeader) {
                this.captureContentTypeHeader = captureContentTypeHeader;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getEnableCapture}
             * @param enableCapture `CfnEndpointConfig.DataCaptureConfigProperty.EnableCapture`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableCapture(java.lang.Boolean enableCapture) {
                this.enableCapture = enableCapture;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getEnableCapture}
             * @param enableCapture `CfnEndpointConfig.DataCaptureConfigProperty.EnableCapture`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableCapture(software.amazon.awscdk.core.IResolvable enableCapture) {
                this.enableCapture = enableCapture;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getKmsKeyId}
             * @param kmsKeyId `CfnEndpointConfig.DataCaptureConfigProperty.KmsKeyId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataCaptureConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataCaptureConfigProperty build() {
                return new Jsii$Proxy(captureOptions, destinationS3Uri, initialSamplingPercentage, captureContentTypeHeader, enableCapture, kmsKeyId);
            }
        }

        /**
         * An implementation for {@link DataCaptureConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataCaptureConfigProperty {
            private final java.lang.Object captureOptions;
            private final java.lang.String destinationS3Uri;
            private final java.lang.Number initialSamplingPercentage;
            private final java.lang.Object captureContentTypeHeader;
            private final java.lang.Object enableCapture;
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.captureOptions = software.amazon.jsii.Kernel.get(this, "captureOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.destinationS3Uri = software.amazon.jsii.Kernel.get(this, "destinationS3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.initialSamplingPercentage = software.amazon.jsii.Kernel.get(this, "initialSamplingPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.captureContentTypeHeader = software.amazon.jsii.Kernel.get(this, "captureContentTypeHeader", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableCapture = software.amazon.jsii.Kernel.get(this, "enableCapture", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object captureOptions, final java.lang.String destinationS3Uri, final java.lang.Number initialSamplingPercentage, final java.lang.Object captureContentTypeHeader, final java.lang.Object enableCapture, final java.lang.String kmsKeyId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.captureOptions = java.util.Objects.requireNonNull(captureOptions, "captureOptions is required");
                this.destinationS3Uri = java.util.Objects.requireNonNull(destinationS3Uri, "destinationS3Uri is required");
                this.initialSamplingPercentage = java.util.Objects.requireNonNull(initialSamplingPercentage, "initialSamplingPercentage is required");
                this.captureContentTypeHeader = captureContentTypeHeader;
                this.enableCapture = enableCapture;
                this.kmsKeyId = kmsKeyId;
            }

            @Override
            public final java.lang.Object getCaptureOptions() {
                return this.captureOptions;
            }

            @Override
            public final java.lang.String getDestinationS3Uri() {
                return this.destinationS3Uri;
            }

            @Override
            public final java.lang.Number getInitialSamplingPercentage() {
                return this.initialSamplingPercentage;
            }

            @Override
            public final java.lang.Object getCaptureContentTypeHeader() {
                return this.captureContentTypeHeader;
            }

            @Override
            public final java.lang.Object getEnableCapture() {
                return this.enableCapture;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("captureOptions", om.valueToTree(this.getCaptureOptions()));
                data.set("destinationS3Uri", om.valueToTree(this.getDestinationS3Uri()));
                data.set("initialSamplingPercentage", om.valueToTree(this.getInitialSamplingPercentage()));
                if (this.getCaptureContentTypeHeader() != null) {
                    data.set("captureContentTypeHeader", om.valueToTree(this.getCaptureContentTypeHeader()));
                }
                if (this.getEnableCapture() != null) {
                    data.set("enableCapture", om.valueToTree(this.getEnableCapture()));
                }
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnEndpointConfig.DataCaptureConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataCaptureConfigProperty.Jsii$Proxy that = (DataCaptureConfigProperty.Jsii$Proxy) o;

                if (!captureOptions.equals(that.captureOptions)) return false;
                if (!destinationS3Uri.equals(that.destinationS3Uri)) return false;
                if (!initialSamplingPercentage.equals(that.initialSamplingPercentage)) return false;
                if (this.captureContentTypeHeader != null ? !this.captureContentTypeHeader.equals(that.captureContentTypeHeader) : that.captureContentTypeHeader != null) return false;
                if (this.enableCapture != null ? !this.enableCapture.equals(that.enableCapture) : that.enableCapture != null) return false;
                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.captureOptions.hashCode();
                result = 31 * result + (this.destinationS3Uri.hashCode());
                result = 31 * result + (this.initialSamplingPercentage.hashCode());
                result = 31 * result + (this.captureContentTypeHeader != null ? this.captureContentTypeHeader.hashCode() : 0);
                result = 31 * result + (this.enableCapture != null ? this.enableCapture.hashCode() : 0);
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sagemaker.$Module.class, fqn = "@aws-cdk/aws-sagemaker.CfnEndpointConfig.ProductionVariantProperty")
    @software.amazon.jsii.Jsii.Proxy(ProductionVariantProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProductionVariantProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InitialInstanceCount`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialinstancecount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getInitialInstanceCount();

        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InitialVariantWeight`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialvariantweight
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getInitialVariantWeight();

        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InstanceType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-instancetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

        /**
         * `CfnEndpointConfig.ProductionVariantProperty.ModelName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modelname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getModelName();

        /**
         * `CfnEndpointConfig.ProductionVariantProperty.VariantName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-variantname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVariantName();

        /**
         * `CfnEndpointConfig.ProductionVariantProperty.AcceleratorType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-acceleratortype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAcceleratorType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProductionVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProductionVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProductionVariantProperty> {
            private java.lang.Number initialInstanceCount;
            private java.lang.Number initialVariantWeight;
            private java.lang.String instanceType;
            private java.lang.String modelName;
            private java.lang.String variantName;
            private java.lang.String acceleratorType;

            /**
             * Sets the value of {@link ProductionVariantProperty#getInitialInstanceCount}
             * @param initialInstanceCount `CfnEndpointConfig.ProductionVariantProperty.InitialInstanceCount`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initialInstanceCount(java.lang.Number initialInstanceCount) {
                this.initialInstanceCount = initialInstanceCount;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getInitialVariantWeight}
             * @param initialVariantWeight `CfnEndpointConfig.ProductionVariantProperty.InitialVariantWeight`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initialVariantWeight(java.lang.Number initialVariantWeight) {
                this.initialVariantWeight = initialVariantWeight;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getInstanceType}
             * @param instanceType `CfnEndpointConfig.ProductionVariantProperty.InstanceType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getModelName}
             * @param modelName `CfnEndpointConfig.ProductionVariantProperty.ModelName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelName(java.lang.String modelName) {
                this.modelName = modelName;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getVariantName}
             * @param variantName `CfnEndpointConfig.ProductionVariantProperty.VariantName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variantName(java.lang.String variantName) {
                this.variantName = variantName;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getAcceleratorType}
             * @param acceleratorType `CfnEndpointConfig.ProductionVariantProperty.AcceleratorType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorType(java.lang.String acceleratorType) {
                this.acceleratorType = acceleratorType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProductionVariantProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProductionVariantProperty build() {
                return new Jsii$Proxy(initialInstanceCount, initialVariantWeight, instanceType, modelName, variantName, acceleratorType);
            }
        }

        /**
         * An implementation for {@link ProductionVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProductionVariantProperty {
            private final java.lang.Number initialInstanceCount;
            private final java.lang.Number initialVariantWeight;
            private final java.lang.String instanceType;
            private final java.lang.String modelName;
            private final java.lang.String variantName;
            private final java.lang.String acceleratorType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.initialInstanceCount = software.amazon.jsii.Kernel.get(this, "initialInstanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.initialVariantWeight = software.amazon.jsii.Kernel.get(this, "initialVariantWeight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.modelName = software.amazon.jsii.Kernel.get(this, "modelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.variantName = software.amazon.jsii.Kernel.get(this, "variantName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.acceleratorType = software.amazon.jsii.Kernel.get(this, "acceleratorType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Number initialInstanceCount, final java.lang.Number initialVariantWeight, final java.lang.String instanceType, final java.lang.String modelName, final java.lang.String variantName, final java.lang.String acceleratorType) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.initialInstanceCount = java.util.Objects.requireNonNull(initialInstanceCount, "initialInstanceCount is required");
                this.initialVariantWeight = java.util.Objects.requireNonNull(initialVariantWeight, "initialVariantWeight is required");
                this.instanceType = java.util.Objects.requireNonNull(instanceType, "instanceType is required");
                this.modelName = java.util.Objects.requireNonNull(modelName, "modelName is required");
                this.variantName = java.util.Objects.requireNonNull(variantName, "variantName is required");
                this.acceleratorType = acceleratorType;
            }

            @Override
            public final java.lang.Number getInitialInstanceCount() {
                return this.initialInstanceCount;
            }

            @Override
            public final java.lang.Number getInitialVariantWeight() {
                return this.initialVariantWeight;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.String getModelName() {
                return this.modelName;
            }

            @Override
            public final java.lang.String getVariantName() {
                return this.variantName;
            }

            @Override
            public final java.lang.String getAcceleratorType() {
                return this.acceleratorType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("initialInstanceCount", om.valueToTree(this.getInitialInstanceCount()));
                data.set("initialVariantWeight", om.valueToTree(this.getInitialVariantWeight()));
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
                data.set("modelName", om.valueToTree(this.getModelName()));
                data.set("variantName", om.valueToTree(this.getVariantName()));
                if (this.getAcceleratorType() != null) {
                    data.set("acceleratorType", om.valueToTree(this.getAcceleratorType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sagemaker.CfnEndpointConfig.ProductionVariantProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProductionVariantProperty.Jsii$Proxy that = (ProductionVariantProperty.Jsii$Proxy) o;

                if (!initialInstanceCount.equals(that.initialInstanceCount)) return false;
                if (!initialVariantWeight.equals(that.initialVariantWeight)) return false;
                if (!instanceType.equals(that.instanceType)) return false;
                if (!modelName.equals(that.modelName)) return false;
                if (!variantName.equals(that.variantName)) return false;
                return this.acceleratorType != null ? this.acceleratorType.equals(that.acceleratorType) : that.acceleratorType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.initialInstanceCount.hashCode();
                result = 31 * result + (this.initialVariantWeight.hashCode());
                result = 31 * result + (this.instanceType.hashCode());
                result = 31 * result + (this.modelName.hashCode());
                result = 31 * result + (this.variantName.hashCode());
                result = 31 * result + (this.acceleratorType != null ? this.acceleratorType.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnEndpointConfig> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sagemaker.CfnEndpointConfigProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sagemaker.CfnEndpointConfigProps.Builder();
        }

        /**
         * `AWS::SageMaker::EndpointConfig.ProductionVariants`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
         * @param productionVariants `AWS::SageMaker::EndpointConfig.ProductionVariants`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productionVariants(final software.amazon.awscdk.core.IResolvable productionVariants) {
            this.props.productionVariants(productionVariants);
            return this;
        }
        /**
         * `AWS::SageMaker::EndpointConfig.ProductionVariants`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
         * @param productionVariants `AWS::SageMaker::EndpointConfig.ProductionVariants`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productionVariants(final java.util.List<? extends java.lang.Object> productionVariants) {
            this.props.productionVariants(productionVariants);
            return this;
        }

        /**
         * `AWS::SageMaker::EndpointConfig.DataCaptureConfig`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig
         * @param dataCaptureConfig `AWS::SageMaker::EndpointConfig.DataCaptureConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCaptureConfig(final software.amazon.awscdk.core.IResolvable dataCaptureConfig) {
            this.props.dataCaptureConfig(dataCaptureConfig);
            return this;
        }
        /**
         * `AWS::SageMaker::EndpointConfig.DataCaptureConfig`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig
         * @param dataCaptureConfig `AWS::SageMaker::EndpointConfig.DataCaptureConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCaptureConfig(final software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.DataCaptureConfigProperty dataCaptureConfig) {
            this.props.dataCaptureConfig(dataCaptureConfig);
            return this;
        }

        /**
         * `AWS::SageMaker::EndpointConfig.EndpointConfigName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
         * @param endpointConfigName `AWS::SageMaker::EndpointConfig.EndpointConfigName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfigName(final java.lang.String endpointConfigName) {
            this.props.endpointConfigName(endpointConfigName);
            return this;
        }

        /**
         * `AWS::SageMaker::EndpointConfig.KmsKeyId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
         * @param kmsKeyId `AWS::SageMaker::EndpointConfig.KmsKeyId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * `AWS::SageMaker::EndpointConfig.Tags`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
         * @param tags `AWS::SageMaker::EndpointConfig.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnEndpointConfig build() {
            return new software.amazon.awscdk.services.sagemaker.CfnEndpointConfig(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
