package software.amazon.awscdk.services.sam;

/**
 * A CloudFormation `AWS::Serverless::Api`.
 * 
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:09:23.354Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnApi")
public class CfnApi extends software.amazon.awscdk.CfnResource {
    protected CfnApi(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        REQUIRED_TRANSFORM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnApi.class, "requiredTransform", java.lang.String.class);
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnApi.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::Serverless::Api`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    public CfnApi(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.sam.CfnApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { properties });
    }
    /**
     * The `Transform` a template must use in order to use this resource.
     */
    public final static java.lang.String REQUIRED_TRANSFORM;
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getApiName() {
        return this.jsiiGet("apiName", java.lang.String.class);
    }

    public software.amazon.awscdk.services.sam.CfnApiProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.sam.CfnApiProps.class);
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api-auth-object
     */
    public static interface AuthProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApi.AuthProperty.Authorizers`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api-auth-object
         */
        java.lang.Object getAuthorizers();
        /**
         * `CfnApi.AuthProperty.DefaultAuthorizer`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api-auth-object
         */
        java.lang.String getDefaultAuthorizer();

        /**
         * @return a {@link Builder} of {@link AuthProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AuthProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _authorizers;
            @javax.annotation.Nullable
            private java.lang.String _defaultAuthorizer;

            /**
             * Sets the value of Authorizers
             * @param value `CfnApi.AuthProperty.Authorizers`.
             * @return {@code this}
             */
            public Builder withAuthorizers(@javax.annotation.Nullable final com.fasterxml.jackson.databind.node.ObjectNode value) {
                this._authorizers = value;
                return this;
            }
            /**
             * Sets the value of Authorizers
             * @param value `CfnApi.AuthProperty.Authorizers`.
             * @return {@code this}
             */
            public Builder withAuthorizers(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._authorizers = value;
                return this;
            }
            /**
             * Sets the value of DefaultAuthorizer
             * @param value `CfnApi.AuthProperty.DefaultAuthorizer`.
             * @return {@code this}
             */
            public Builder withDefaultAuthorizer(@javax.annotation.Nullable final java.lang.String value) {
                this._defaultAuthorizer = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AuthProperty build() {
                return new AuthProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $authorizers = _authorizers;
                    @javax.annotation.Nullable
                    private final java.lang.String $defaultAuthorizer = _defaultAuthorizer;

                    @Override
                    public java.lang.Object getAuthorizers() {
                        return this.$authorizers;
                    }

                    @Override
                    public java.lang.String getDefaultAuthorizer() {
                        return this.$defaultAuthorizer;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("authorizers", om.valueToTree(this.getAuthorizers()));
                        obj.set("defaultAuthorizer", om.valueToTree(this.getDefaultAuthorizer()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnApi.AuthProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApi.AuthProperty.Authorizers`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api-auth-object
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAuthorizers() {
                return this.jsiiGet("authorizers", java.lang.Object.class);
            }

            /**
             * `CfnApi.AuthProperty.DefaultAuthorizer`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api-auth-object
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getDefaultAuthorizer() {
                return this.jsiiGet("defaultAuthorizer", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3-location-object
     */
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApi.S3LocationProperty.Bucket`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        java.lang.String getBucket();
        /**
         * `CfnApi.S3LocationProperty.Key`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        java.lang.String getKey();
        /**
         * `CfnApi.S3LocationProperty.Version`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        java.lang.Object getVersion();

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link S3LocationProperty}
         */
        final class Builder {
            private java.lang.String _bucket;
            private java.lang.String _key;
            private java.lang.Object _version;

            /**
             * Sets the value of Bucket
             * @param value `CfnApi.S3LocationProperty.Bucket`.
             * @return {@code this}
             */
            public Builder withBucket(final java.lang.String value) {
                this._bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                return this;
            }
            /**
             * Sets the value of Key
             * @param value `CfnApi.S3LocationProperty.Key`.
             * @return {@code this}
             */
            public Builder withKey(final java.lang.String value) {
                this._key = java.util.Objects.requireNonNull(value, "key is required");
                return this;
            }
            /**
             * Sets the value of Version
             * @param value `CfnApi.S3LocationProperty.Version`.
             * @return {@code this}
             */
            public Builder withVersion(final java.lang.Number value) {
                this._version = java.util.Objects.requireNonNull(value, "version is required");
                return this;
            }
            /**
             * Sets the value of Version
             * @param value `CfnApi.S3LocationProperty.Version`.
             * @return {@code this}
             */
            public Builder withVersion(final software.amazon.awscdk.Token value) {
                this._version = java.util.Objects.requireNonNull(value, "version is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public S3LocationProperty build() {
                return new S3LocationProperty() {
                    private final java.lang.String $bucket = java.util.Objects.requireNonNull(_bucket, "bucket is required");
                    private final java.lang.String $key = java.util.Objects.requireNonNull(_key, "key is required");
                    private final java.lang.Object $version = java.util.Objects.requireNonNull(_version, "version is required");

                    @Override
                    public java.lang.String getBucket() {
                        return this.$bucket;
                    }

                    @Override
                    public java.lang.String getKey() {
                        return this.$key;
                    }

                    @Override
                    public java.lang.Object getVersion() {
                        return this.$version;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("bucket", om.valueToTree(this.getBucket()));
                        obj.set("key", om.valueToTree(this.getKey()));
                        obj.set("version", om.valueToTree(this.getVersion()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnApi.S3LocationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApi.S3LocationProperty.Bucket`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
             */
            @Override
            public java.lang.String getBucket() {
                return this.jsiiGet("bucket", java.lang.String.class);
            }

            /**
             * `CfnApi.S3LocationProperty.Key`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
             */
            @Override
            public java.lang.String getKey() {
                return this.jsiiGet("key", java.lang.String.class);
            }

            /**
             * `CfnApi.S3LocationProperty.Version`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
             */
            @Override
            public java.lang.Object getVersion() {
                return this.jsiiGet("version", java.lang.Object.class);
            }
        }
    }
}
