package software.amazon.awscdk.services.sam;

/**
 * A CloudFormation `AWS::Serverless::Application`.
 * 
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:09:23.379Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnApplication")
public class CfnApplication extends software.amazon.awscdk.CfnResource {
    protected CfnApplication(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        REQUIRED_TRANSFORM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnApplication.class, "requiredTransform", java.lang.String.class);
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnApplication.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::Serverless::Application`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    public CfnApplication(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.sam.CfnApplicationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { properties });
    }
    /**
     * The `Transform` a template must use in order to use this resource.
     */
    public final static java.lang.String REQUIRED_TRANSFORM;
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getApplicationName() {
        return this.jsiiGet("applicationName", java.lang.String.class);
    }

    public software.amazon.awscdk.services.sam.CfnApplicationProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.sam.CfnApplicationProps.class);
    }

    /**
     * The `TagManager` handles setting, removing and formatting tags.
     * 
     * Tags should be managed either passing them as properties during
     * initiation or by calling methods on this object. If both techniques are
     * used only the tags from the TagManager will be used. `Tag` (aspect)
     * will use the manager.
     */
    public software.amazon.awscdk.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.TagManager.class);
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    public static interface ApplicationLocationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplication.ApplicationLocationProperty.ApplicationId`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
         */
        java.lang.String getApplicationId();
        /**
         * `CfnApplication.ApplicationLocationProperty.SemanticVersion`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
         */
        java.lang.String getSemanticVersion();

        /**
         * @return a {@link Builder} of {@link ApplicationLocationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ApplicationLocationProperty}
         */
        final class Builder {
            private java.lang.String _applicationId;
            private java.lang.String _semanticVersion;

            /**
             * Sets the value of ApplicationId
             * @param value `CfnApplication.ApplicationLocationProperty.ApplicationId`.
             * @return {@code this}
             */
            public Builder withApplicationId(final java.lang.String value) {
                this._applicationId = java.util.Objects.requireNonNull(value, "applicationId is required");
                return this;
            }
            /**
             * Sets the value of SemanticVersion
             * @param value `CfnApplication.ApplicationLocationProperty.SemanticVersion`.
             * @return {@code this}
             */
            public Builder withSemanticVersion(final java.lang.String value) {
                this._semanticVersion = java.util.Objects.requireNonNull(value, "semanticVersion is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ApplicationLocationProperty build() {
                return new ApplicationLocationProperty() {
                    private final java.lang.String $applicationId = java.util.Objects.requireNonNull(_applicationId, "applicationId is required");
                    private final java.lang.String $semanticVersion = java.util.Objects.requireNonNull(_semanticVersion, "semanticVersion is required");

                    @Override
                    public java.lang.String getApplicationId() {
                        return this.$applicationId;
                    }

                    @Override
                    public java.lang.String getSemanticVersion() {
                        return this.$semanticVersion;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("applicationId", om.valueToTree(this.getApplicationId()));
                        obj.set("semanticVersion", om.valueToTree(this.getSemanticVersion()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnApplication.ApplicationLocationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplication.ApplicationLocationProperty.ApplicationId`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
             */
            @Override
            public java.lang.String getApplicationId() {
                return this.jsiiGet("applicationId", java.lang.String.class);
            }

            /**
             * `CfnApplication.ApplicationLocationProperty.SemanticVersion`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
             */
            @Override
            public java.lang.String getSemanticVersion() {
                return this.jsiiGet("semanticVersion", java.lang.String.class);
            }
        }
    }
}
