package software.amazon.awscdk.services.sam;

/**
 * A CloudFormation `AWS::Serverless::Function`.
 * 
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-06T20:51:56.860Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction")
public class CfnFunction extends software.amazon.awscdk.CfnResource {
    protected CfnFunction(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        REQUIRED_TRANSFORM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnFunction.class, "requiredTransform", java.lang.String.class);
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnFunction.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::Serverless::Function`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    public CfnFunction(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.sam.CfnFunctionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { properties });
    }
    /**
     * The `Transform` a template must use in order to use this resource.
     */
    public final static java.lang.String REQUIRED_TRANSFORM;
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getFunctionName() {
        return this.jsiiGet("functionName", java.lang.String.class);
    }

    public software.amazon.awscdk.services.sam.CfnFunctionProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.sam.CfnFunctionProps.class);
    }

    /**
     * The `TagManager` handles setting, removing and formatting tags.
     * 
     * Tags should be managed either passing them as properties during
     * initiation or by calling methods on this object. If both techniques are
     * used only the tags from the TagManager will be used. `Tag` (aspect)
     * will use the manager.
     */
    public software.amazon.awscdk.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.TagManager.class);
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#alexaskill
     */
    public static interface AlexaSkillEventProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.AlexaSkillEventProperty.Variables`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#alexaskill
         */
        java.lang.Object getVariables();

        /**
         * @return a {@link Builder} of {@link AlexaSkillEventProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AlexaSkillEventProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _variables;

            /**
             * Sets the value of Variables
             * @param value `CfnFunction.AlexaSkillEventProperty.Variables`.
             * @return {@code this}
             */
            public Builder withVariables(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._variables = value;
                return this;
            }
            /**
             * Sets the value of Variables
             * @param value `CfnFunction.AlexaSkillEventProperty.Variables`.
             * @return {@code this}
             */
            public Builder withVariables(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                this._variables = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlexaSkillEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AlexaSkillEventProperty build() {
                return new AlexaSkillEventProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $variables = _variables;

                    @Override
                    public java.lang.Object getVariables() {
                        return this.$variables;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("variables", om.valueToTree(this.getVariables()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.AlexaSkillEventProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.AlexaSkillEventProperty.Variables`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#alexaskill
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getVariables() {
                return this.jsiiGet("variables", java.lang.Object.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
     */
    public static interface ApiEventProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.ApiEventProperty.Method`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         */
        java.lang.String getMethod();
        /**
         * `CfnFunction.ApiEventProperty.Path`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         */
        java.lang.String getPath();
        /**
         * `CfnFunction.ApiEventProperty.RestApiId`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         */
        java.lang.String getRestApiId();

        /**
         * @return a {@link Builder} of {@link ApiEventProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ApiEventProperty}
         */
        final class Builder {
            private java.lang.String _method;
            private java.lang.String _path;
            @javax.annotation.Nullable
            private java.lang.String _restApiId;

            /**
             * Sets the value of Method
             * @param value `CfnFunction.ApiEventProperty.Method`.
             * @return {@code this}
             */
            public Builder withMethod(final java.lang.String value) {
                this._method = java.util.Objects.requireNonNull(value, "method is required");
                return this;
            }
            /**
             * Sets the value of Path
             * @param value `CfnFunction.ApiEventProperty.Path`.
             * @return {@code this}
             */
            public Builder withPath(final java.lang.String value) {
                this._path = java.util.Objects.requireNonNull(value, "path is required");
                return this;
            }
            /**
             * Sets the value of RestApiId
             * @param value `CfnFunction.ApiEventProperty.RestApiId`.
             * @return {@code this}
             */
            public Builder withRestApiId(@javax.annotation.Nullable final java.lang.String value) {
                this._restApiId = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApiEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ApiEventProperty build() {
                return new ApiEventProperty() {
                    private final java.lang.String $method = java.util.Objects.requireNonNull(_method, "method is required");
                    private final java.lang.String $path = java.util.Objects.requireNonNull(_path, "path is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $restApiId = _restApiId;

                    @Override
                    public java.lang.String getMethod() {
                        return this.$method;
                    }

                    @Override
                    public java.lang.String getPath() {
                        return this.$path;
                    }

                    @Override
                    public java.lang.String getRestApiId() {
                        return this.$restApiId;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("method", om.valueToTree(this.getMethod()));
                        obj.set("path", om.valueToTree(this.getPath()));
                        obj.set("restApiId", om.valueToTree(this.getRestApiId()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.ApiEventProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.ApiEventProperty.Method`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
             */
            @Override
            public java.lang.String getMethod() {
                return this.jsiiGet("method", java.lang.String.class);
            }

            /**
             * `CfnFunction.ApiEventProperty.Path`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
             */
            @Override
            public java.lang.String getPath() {
                return this.jsiiGet("path", java.lang.String.class);
            }

            /**
             * `CfnFunction.ApiEventProperty.RestApiId`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getRestApiId() {
                return this.jsiiGet("restApiId", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
     */
    public static interface CloudWatchEventEventProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.CloudWatchEventEventProperty.Pattern`.
         * 
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html
         */
        java.lang.Object getPattern();
        /**
         * `CfnFunction.CloudWatchEventEventProperty.Input`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
         */
        java.lang.String getInput();
        /**
         * `CfnFunction.CloudWatchEventEventProperty.InputPath`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
         */
        java.lang.String getInputPath();

        /**
         * @return a {@link Builder} of {@link CloudWatchEventEventProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CloudWatchEventEventProperty}
         */
        final class Builder {
            private java.lang.Object _pattern;
            @javax.annotation.Nullable
            private java.lang.String _input;
            @javax.annotation.Nullable
            private java.lang.String _inputPath;

            /**
             * Sets the value of Pattern
             * @param value `CfnFunction.CloudWatchEventEventProperty.Pattern`.
             * @return {@code this}
             */
            public Builder withPattern(final com.fasterxml.jackson.databind.node.ObjectNode value) {
                this._pattern = java.util.Objects.requireNonNull(value, "pattern is required");
                return this;
            }
            /**
             * Sets the value of Pattern
             * @param value `CfnFunction.CloudWatchEventEventProperty.Pattern`.
             * @return {@code this}
             */
            public Builder withPattern(final software.amazon.awscdk.Token value) {
                this._pattern = java.util.Objects.requireNonNull(value, "pattern is required");
                return this;
            }
            /**
             * Sets the value of Input
             * @param value `CfnFunction.CloudWatchEventEventProperty.Input`.
             * @return {@code this}
             */
            public Builder withInput(@javax.annotation.Nullable final java.lang.String value) {
                this._input = value;
                return this;
            }
            /**
             * Sets the value of InputPath
             * @param value `CfnFunction.CloudWatchEventEventProperty.InputPath`.
             * @return {@code this}
             */
            public Builder withInputPath(@javax.annotation.Nullable final java.lang.String value) {
                this._inputPath = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchEventEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public CloudWatchEventEventProperty build() {
                return new CloudWatchEventEventProperty() {
                    private final java.lang.Object $pattern = java.util.Objects.requireNonNull(_pattern, "pattern is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $input = _input;
                    @javax.annotation.Nullable
                    private final java.lang.String $inputPath = _inputPath;

                    @Override
                    public java.lang.Object getPattern() {
                        return this.$pattern;
                    }

                    @Override
                    public java.lang.String getInput() {
                        return this.$input;
                    }

                    @Override
                    public java.lang.String getInputPath() {
                        return this.$inputPath;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("pattern", om.valueToTree(this.getPattern()));
                        obj.set("input", om.valueToTree(this.getInput()));
                        obj.set("inputPath", om.valueToTree(this.getInputPath()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.CloudWatchEventEventProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.CloudWatchEventEventProperty.Pattern`.
             * 
             * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html
             */
            @Override
            public java.lang.Object getPattern() {
                return this.jsiiGet("pattern", java.lang.Object.class);
            }

            /**
             * `CfnFunction.CloudWatchEventEventProperty.Input`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getInput() {
                return this.jsiiGet("input", java.lang.String.class);
            }

            /**
             * `CfnFunction.CloudWatchEventEventProperty.InputPath`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getInputPath() {
                return this.jsiiGet("inputPath", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deadletterqueue-object
     */
    public static interface DeadLetterQueueProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.DeadLetterQueueProperty.TargetArn`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        java.lang.String getTargetArn();
        /**
         * `CfnFunction.DeadLetterQueueProperty.Type`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link DeadLetterQueueProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DeadLetterQueueProperty}
         */
        final class Builder {
            private java.lang.String _targetArn;
            private java.lang.String _type;

            /**
             * Sets the value of TargetArn
             * @param value `CfnFunction.DeadLetterQueueProperty.TargetArn`.
             * @return {@code this}
             */
            public Builder withTargetArn(final java.lang.String value) {
                this._targetArn = java.util.Objects.requireNonNull(value, "targetArn is required");
                return this;
            }
            /**
             * Sets the value of Type
             * @param value `CfnFunction.DeadLetterQueueProperty.Type`.
             * @return {@code this}
             */
            public Builder withType(final java.lang.String value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeadLetterQueueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public DeadLetterQueueProperty build() {
                return new DeadLetterQueueProperty() {
                    private final java.lang.String $targetArn = java.util.Objects.requireNonNull(_targetArn, "targetArn is required");
                    private final java.lang.String $type = java.util.Objects.requireNonNull(_type, "type is required");

                    @Override
                    public java.lang.String getTargetArn() {
                        return this.$targetArn;
                    }

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("targetArn", om.valueToTree(this.getTargetArn()));
                        obj.set("type", om.valueToTree(this.getType()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.DeadLetterQueueProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.DeadLetterQueueProperty.TargetArn`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
             */
            @Override
            public java.lang.String getTargetArn() {
                return this.jsiiGet("targetArn", java.lang.String.class);
            }

            /**
             * `CfnFunction.DeadLetterQueueProperty.Type`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
             */
            @Override
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/safe_lambda_deployments.rst
     */
    public static interface DeploymentPreferenceProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.DeploymentPreferenceProperty.Enabled`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         */
        java.lang.Object getEnabled();
        /**
         * `CfnFunction.DeploymentPreferenceProperty.Type`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         */
        java.lang.String getType();
        /**
         * `CfnFunction.DeploymentPreferenceProperty.Alarms`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         */
        java.util.List<java.lang.String> getAlarms();
        /**
         * `CfnFunction.DeploymentPreferenceProperty.Hooks`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         */
        java.util.List<java.lang.String> getHooks();

        /**
         * @return a {@link Builder} of {@link DeploymentPreferenceProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DeploymentPreferenceProperty}
         */
        final class Builder {
            private java.lang.Object _enabled;
            private java.lang.String _type;
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _alarms;
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _hooks;

            /**
             * Sets the value of Enabled
             * @param value `CfnFunction.DeploymentPreferenceProperty.Enabled`.
             * @return {@code this}
             */
            public Builder withEnabled(final java.lang.Boolean value) {
                this._enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnFunction.DeploymentPreferenceProperty.Enabled`.
             * @return {@code this}
             */
            public Builder withEnabled(final software.amazon.awscdk.Token value) {
                this._enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                return this;
            }
            /**
             * Sets the value of Type
             * @param value `CfnFunction.DeploymentPreferenceProperty.Type`.
             * @return {@code this}
             */
            public Builder withType(final java.lang.String value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }
            /**
             * Sets the value of Alarms
             * @param value `CfnFunction.DeploymentPreferenceProperty.Alarms`.
             * @return {@code this}
             */
            public Builder withAlarms(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._alarms = value;
                return this;
            }
            /**
             * Sets the value of Hooks
             * @param value `CfnFunction.DeploymentPreferenceProperty.Hooks`.
             * @return {@code this}
             */
            public Builder withHooks(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._hooks = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentPreferenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public DeploymentPreferenceProperty build() {
                return new DeploymentPreferenceProperty() {
                    private final java.lang.Object $enabled = java.util.Objects.requireNonNull(_enabled, "enabled is required");
                    private final java.lang.String $type = java.util.Objects.requireNonNull(_type, "type is required");
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $alarms = _alarms;
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $hooks = _hooks;

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    @Override
                    public java.util.List<java.lang.String> getAlarms() {
                        return this.$alarms;
                    }

                    @Override
                    public java.util.List<java.lang.String> getHooks() {
                        return this.$hooks;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("enabled", om.valueToTree(this.getEnabled()));
                        obj.set("type", om.valueToTree(this.getType()));
                        obj.set("alarms", om.valueToTree(this.getAlarms()));
                        obj.set("hooks", om.valueToTree(this.getHooks()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.DeploymentPreferenceProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.DeploymentPreferenceProperty.Enabled`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
             */
            @Override
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * `CfnFunction.DeploymentPreferenceProperty.Type`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
             */
            @Override
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }

            /**
             * `CfnFunction.DeploymentPreferenceProperty.Alarms`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
             */
            @Override
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getAlarms() {
                return this.jsiiGet("alarms", java.util.List.class);
            }

            /**
             * `CfnFunction.DeploymentPreferenceProperty.Hooks`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
             */
            @Override
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getHooks() {
                return this.jsiiGet("hooks", java.util.List.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
     */
    public static interface DynamoDBEventProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.DynamoDBEventProperty.StartingPosition`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        java.lang.String getStartingPosition();
        /**
         * `CfnFunction.DynamoDBEventProperty.Stream`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        java.lang.String getStream();
        /**
         * `CfnFunction.DynamoDBEventProperty.BatchSize`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        java.lang.Object getBatchSize();
        /**
         * `CfnFunction.DynamoDBEventProperty.Enabled`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link DynamoDBEventProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DynamoDBEventProperty}
         */
        final class Builder {
            private java.lang.String _startingPosition;
            private java.lang.String _stream;
            @javax.annotation.Nullable
            private java.lang.Object _batchSize;
            @javax.annotation.Nullable
            private java.lang.Object _enabled;

            /**
             * Sets the value of StartingPosition
             * @param value `CfnFunction.DynamoDBEventProperty.StartingPosition`.
             * @return {@code this}
             */
            public Builder withStartingPosition(final java.lang.String value) {
                this._startingPosition = java.util.Objects.requireNonNull(value, "startingPosition is required");
                return this;
            }
            /**
             * Sets the value of Stream
             * @param value `CfnFunction.DynamoDBEventProperty.Stream`.
             * @return {@code this}
             */
            public Builder withStream(final java.lang.String value) {
                this._stream = java.util.Objects.requireNonNull(value, "stream is required");
                return this;
            }
            /**
             * Sets the value of BatchSize
             * @param value `CfnFunction.DynamoDBEventProperty.BatchSize`.
             * @return {@code this}
             */
            public Builder withBatchSize(@javax.annotation.Nullable final java.lang.Number value) {
                this._batchSize = value;
                return this;
            }
            /**
             * Sets the value of BatchSize
             * @param value `CfnFunction.DynamoDBEventProperty.BatchSize`.
             * @return {@code this}
             */
            public Builder withBatchSize(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._batchSize = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnFunction.DynamoDBEventProperty.Enabled`.
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnFunction.DynamoDBEventProperty.Enabled`.
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._enabled = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynamoDBEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public DynamoDBEventProperty build() {
                return new DynamoDBEventProperty() {
                    private final java.lang.String $startingPosition = java.util.Objects.requireNonNull(_startingPosition, "startingPosition is required");
                    private final java.lang.String $stream = java.util.Objects.requireNonNull(_stream, "stream is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $batchSize = _batchSize;
                    @javax.annotation.Nullable
                    private final java.lang.Object $enabled = _enabled;

                    @Override
                    public java.lang.String getStartingPosition() {
                        return this.$startingPosition;
                    }

                    @Override
                    public java.lang.String getStream() {
                        return this.$stream;
                    }

                    @Override
                    public java.lang.Object getBatchSize() {
                        return this.$batchSize;
                    }

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("startingPosition", om.valueToTree(this.getStartingPosition()));
                        obj.set("stream", om.valueToTree(this.getStream()));
                        obj.set("batchSize", om.valueToTree(this.getBatchSize()));
                        obj.set("enabled", om.valueToTree(this.getEnabled()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.DynamoDBEventProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.DynamoDBEventProperty.StartingPosition`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
             */
            @Override
            public java.lang.String getStartingPosition() {
                return this.jsiiGet("startingPosition", java.lang.String.class);
            }

            /**
             * `CfnFunction.DynamoDBEventProperty.Stream`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
             */
            @Override
            public java.lang.String getStream() {
                return this.jsiiGet("stream", java.lang.String.class);
            }

            /**
             * `CfnFunction.DynamoDBEventProperty.BatchSize`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getBatchSize() {
                return this.jsiiGet("batchSize", java.lang.Object.class);
            }

            /**
             * `CfnFunction.DynamoDBEventProperty.Enabled`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-object
     */
    public static interface EventSourceProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.EventSourceProperty.Properties`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-types
         */
        java.lang.Object getProperties();
        /**
         * `CfnFunction.EventSourceProperty.Type`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-object
         */
        java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link EventSourceProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EventSourceProperty}
         */
        final class Builder {
            private java.lang.Object _properties;
            private java.lang.String _type;

            /**
             * Sets the value of Properties
             * @param value `CfnFunction.EventSourceProperty.Properties`.
             * @return {@code this}
             */
            public Builder withProperties(final software.amazon.awscdk.Token value) {
                this._properties = java.util.Objects.requireNonNull(value, "properties is required");
                return this;
            }
            /**
             * Sets the value of Properties
             * @param value `CfnFunction.EventSourceProperty.Properties`.
             * @return {@code this}
             */
            public Builder withProperties(final software.amazon.awscdk.services.sam.CfnFunction.AlexaSkillEventProperty value) {
                this._properties = java.util.Objects.requireNonNull(value, "properties is required");
                return this;
            }
            /**
             * Sets the value of Properties
             * @param value `CfnFunction.EventSourceProperty.Properties`.
             * @return {@code this}
             */
            public Builder withProperties(final software.amazon.awscdk.services.sam.CfnFunction.ApiEventProperty value) {
                this._properties = java.util.Objects.requireNonNull(value, "properties is required");
                return this;
            }
            /**
             * Sets the value of Properties
             * @param value `CfnFunction.EventSourceProperty.Properties`.
             * @return {@code this}
             */
            public Builder withProperties(final software.amazon.awscdk.services.sam.CfnFunction.CloudWatchEventEventProperty value) {
                this._properties = java.util.Objects.requireNonNull(value, "properties is required");
                return this;
            }
            /**
             * Sets the value of Properties
             * @param value `CfnFunction.EventSourceProperty.Properties`.
             * @return {@code this}
             */
            public Builder withProperties(final software.amazon.awscdk.services.sam.CfnFunction.DynamoDBEventProperty value) {
                this._properties = java.util.Objects.requireNonNull(value, "properties is required");
                return this;
            }
            /**
             * Sets the value of Properties
             * @param value `CfnFunction.EventSourceProperty.Properties`.
             * @return {@code this}
             */
            public Builder withProperties(final software.amazon.awscdk.services.sam.CfnFunction.S3EventProperty value) {
                this._properties = java.util.Objects.requireNonNull(value, "properties is required");
                return this;
            }
            /**
             * Sets the value of Properties
             * @param value `CfnFunction.EventSourceProperty.Properties`.
             * @return {@code this}
             */
            public Builder withProperties(final software.amazon.awscdk.services.sam.CfnFunction.SNSEventProperty value) {
                this._properties = java.util.Objects.requireNonNull(value, "properties is required");
                return this;
            }
            /**
             * Sets the value of Properties
             * @param value `CfnFunction.EventSourceProperty.Properties`.
             * @return {@code this}
             */
            public Builder withProperties(final software.amazon.awscdk.services.sam.CfnFunction.SQSEventProperty value) {
                this._properties = java.util.Objects.requireNonNull(value, "properties is required");
                return this;
            }
            /**
             * Sets the value of Properties
             * @param value `CfnFunction.EventSourceProperty.Properties`.
             * @return {@code this}
             */
            public Builder withProperties(final software.amazon.awscdk.services.sam.CfnFunction.KinesisEventProperty value) {
                this._properties = java.util.Objects.requireNonNull(value, "properties is required");
                return this;
            }
            /**
             * Sets the value of Properties
             * @param value `CfnFunction.EventSourceProperty.Properties`.
             * @return {@code this}
             */
            public Builder withProperties(final software.amazon.awscdk.services.sam.CfnFunction.ScheduleEventProperty value) {
                this._properties = java.util.Objects.requireNonNull(value, "properties is required");
                return this;
            }
            /**
             * Sets the value of Properties
             * @param value `CfnFunction.EventSourceProperty.Properties`.
             * @return {@code this}
             */
            public Builder withProperties(final software.amazon.awscdk.services.sam.CfnFunction.IoTRuleEventProperty value) {
                this._properties = java.util.Objects.requireNonNull(value, "properties is required");
                return this;
            }
            /**
             * Sets the value of Type
             * @param value `CfnFunction.EventSourceProperty.Type`.
             * @return {@code this}
             */
            public Builder withType(final java.lang.String value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EventSourceProperty build() {
                return new EventSourceProperty() {
                    private final java.lang.Object $properties = java.util.Objects.requireNonNull(_properties, "properties is required");
                    private final java.lang.String $type = java.util.Objects.requireNonNull(_type, "type is required");

                    @Override
                    public java.lang.Object getProperties() {
                        return this.$properties;
                    }

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("properties", om.valueToTree(this.getProperties()));
                        obj.set("type", om.valueToTree(this.getType()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.EventSourceProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.EventSourceProperty.Properties`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-types
             */
            @Override
            public java.lang.Object getProperties() {
                return this.jsiiGet("properties", java.lang.Object.class);
            }

            /**
             * `CfnFunction.EventSourceProperty.Type`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-object
             */
            @Override
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#environment-object
     */
    public static interface FunctionEnvironmentProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.FunctionEnvironmentProperty.Variables`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#environment-object
         */
        java.lang.Object getVariables();

        /**
         * @return a {@link Builder} of {@link FunctionEnvironmentProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link FunctionEnvironmentProperty}
         */
        final class Builder {
            private java.lang.Object _variables;

            /**
             * Sets the value of Variables
             * @param value `CfnFunction.FunctionEnvironmentProperty.Variables`.
             * @return {@code this}
             */
            public Builder withVariables(final software.amazon.awscdk.Token value) {
                this._variables = java.util.Objects.requireNonNull(value, "variables is required");
                return this;
            }
            /**
             * Sets the value of Variables
             * @param value `CfnFunction.FunctionEnvironmentProperty.Variables`.
             * @return {@code this}
             */
            public Builder withVariables(final java.util.Map<java.lang.String, java.lang.String> value) {
                this._variables = java.util.Objects.requireNonNull(value, "variables is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FunctionEnvironmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public FunctionEnvironmentProperty build() {
                return new FunctionEnvironmentProperty() {
                    private final java.lang.Object $variables = java.util.Objects.requireNonNull(_variables, "variables is required");

                    @Override
                    public java.lang.Object getVariables() {
                        return this.$variables;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("variables", om.valueToTree(this.getVariables()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.FunctionEnvironmentProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.FunctionEnvironmentProperty.Variables`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#environment-object
             */
            @Override
            public java.lang.Object getVariables() {
                return this.jsiiGet("variables", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html
     */
    public static interface IAMPolicyDocumentProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.IAMPolicyDocumentProperty.Statement`.
         * 
         * @see http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html
         */
        java.lang.Object getStatement();

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.IAMPolicyDocumentProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.IAMPolicyDocumentProperty.Statement`.
             * 
             * @see http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html
             */
            @Override
            public java.lang.Object getStatement() {
                return this.jsiiGet("statement", java.lang.Object.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#iotrule
     */
    public static interface IoTRuleEventProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.IoTRuleEventProperty.Sql`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#iotrule
         */
        java.lang.String getSql();
        /**
         * `CfnFunction.IoTRuleEventProperty.AwsIotSqlVersion`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#iotrule
         */
        java.lang.String getAwsIotSqlVersion();

        /**
         * @return a {@link Builder} of {@link IoTRuleEventProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link IoTRuleEventProperty}
         */
        final class Builder {
            private java.lang.String _sql;
            @javax.annotation.Nullable
            private java.lang.String _awsIotSqlVersion;

            /**
             * Sets the value of Sql
             * @param value `CfnFunction.IoTRuleEventProperty.Sql`.
             * @return {@code this}
             */
            public Builder withSql(final java.lang.String value) {
                this._sql = java.util.Objects.requireNonNull(value, "sql is required");
                return this;
            }
            /**
             * Sets the value of AwsIotSqlVersion
             * @param value `CfnFunction.IoTRuleEventProperty.AwsIotSqlVersion`.
             * @return {@code this}
             */
            public Builder withAwsIotSqlVersion(@javax.annotation.Nullable final java.lang.String value) {
                this._awsIotSqlVersion = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IoTRuleEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public IoTRuleEventProperty build() {
                return new IoTRuleEventProperty() {
                    private final java.lang.String $sql = java.util.Objects.requireNonNull(_sql, "sql is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $awsIotSqlVersion = _awsIotSqlVersion;

                    @Override
                    public java.lang.String getSql() {
                        return this.$sql;
                    }

                    @Override
                    public java.lang.String getAwsIotSqlVersion() {
                        return this.$awsIotSqlVersion;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("sql", om.valueToTree(this.getSql()));
                        obj.set("awsIotSqlVersion", om.valueToTree(this.getAwsIotSqlVersion()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.IoTRuleEventProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.IoTRuleEventProperty.Sql`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#iotrule
             */
            @Override
            public java.lang.String getSql() {
                return this.jsiiGet("sql", java.lang.String.class);
            }

            /**
             * `CfnFunction.IoTRuleEventProperty.AwsIotSqlVersion`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#iotrule
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getAwsIotSqlVersion() {
                return this.jsiiGet("awsIotSqlVersion", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
     */
    public static interface KinesisEventProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.KinesisEventProperty.StartingPosition`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         */
        java.lang.String getStartingPosition();
        /**
         * `CfnFunction.KinesisEventProperty.Stream`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         */
        java.lang.String getStream();
        /**
         * `CfnFunction.KinesisEventProperty.BatchSize`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         */
        java.lang.Object getBatchSize();
        /**
         * `CfnFunction.KinesisEventProperty.Enabled`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         */
        java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link KinesisEventProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link KinesisEventProperty}
         */
        final class Builder {
            private java.lang.String _startingPosition;
            private java.lang.String _stream;
            @javax.annotation.Nullable
            private java.lang.Object _batchSize;
            @javax.annotation.Nullable
            private java.lang.Object _enabled;

            /**
             * Sets the value of StartingPosition
             * @param value `CfnFunction.KinesisEventProperty.StartingPosition`.
             * @return {@code this}
             */
            public Builder withStartingPosition(final java.lang.String value) {
                this._startingPosition = java.util.Objects.requireNonNull(value, "startingPosition is required");
                return this;
            }
            /**
             * Sets the value of Stream
             * @param value `CfnFunction.KinesisEventProperty.Stream`.
             * @return {@code this}
             */
            public Builder withStream(final java.lang.String value) {
                this._stream = java.util.Objects.requireNonNull(value, "stream is required");
                return this;
            }
            /**
             * Sets the value of BatchSize
             * @param value `CfnFunction.KinesisEventProperty.BatchSize`.
             * @return {@code this}
             */
            public Builder withBatchSize(@javax.annotation.Nullable final java.lang.Number value) {
                this._batchSize = value;
                return this;
            }
            /**
             * Sets the value of BatchSize
             * @param value `CfnFunction.KinesisEventProperty.BatchSize`.
             * @return {@code this}
             */
            public Builder withBatchSize(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._batchSize = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnFunction.KinesisEventProperty.Enabled`.
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnFunction.KinesisEventProperty.Enabled`.
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._enabled = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public KinesisEventProperty build() {
                return new KinesisEventProperty() {
                    private final java.lang.String $startingPosition = java.util.Objects.requireNonNull(_startingPosition, "startingPosition is required");
                    private final java.lang.String $stream = java.util.Objects.requireNonNull(_stream, "stream is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $batchSize = _batchSize;
                    @javax.annotation.Nullable
                    private final java.lang.Object $enabled = _enabled;

                    @Override
                    public java.lang.String getStartingPosition() {
                        return this.$startingPosition;
                    }

                    @Override
                    public java.lang.String getStream() {
                        return this.$stream;
                    }

                    @Override
                    public java.lang.Object getBatchSize() {
                        return this.$batchSize;
                    }

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("startingPosition", om.valueToTree(this.getStartingPosition()));
                        obj.set("stream", om.valueToTree(this.getStream()));
                        obj.set("batchSize", om.valueToTree(this.getBatchSize()));
                        obj.set("enabled", om.valueToTree(this.getEnabled()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.KinesisEventProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.KinesisEventProperty.StartingPosition`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
             */
            @Override
            public java.lang.String getStartingPosition() {
                return this.jsiiGet("startingPosition", java.lang.String.class);
            }

            /**
             * `CfnFunction.KinesisEventProperty.Stream`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
             */
            @Override
            public java.lang.String getStream() {
                return this.jsiiGet("stream", java.lang.String.class);
            }

            /**
             * `CfnFunction.KinesisEventProperty.BatchSize`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getBatchSize() {
                return this.jsiiGet("batchSize", java.lang.Object.class);
            }

            /**
             * `CfnFunction.KinesisEventProperty.Enabled`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
     */
    public static interface S3EventProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.S3EventProperty.Bucket`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
         */
        java.lang.String getBucket();
        /**
         * `CfnFunction.S3EventProperty.Events`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
         */
        java.lang.Object getEvents();
        /**
         * `CfnFunction.S3EventProperty.Filter`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
         */
        java.lang.Object getFilter();

        /**
         * @return a {@link Builder} of {@link S3EventProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link S3EventProperty}
         */
        final class Builder {
            private java.lang.String _bucket;
            private java.lang.Object _events;
            @javax.annotation.Nullable
            private java.lang.Object _filter;

            /**
             * Sets the value of Bucket
             * @param value `CfnFunction.S3EventProperty.Bucket`.
             * @return {@code this}
             */
            public Builder withBucket(final java.lang.String value) {
                this._bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                return this;
            }
            /**
             * Sets the value of Events
             * @param value `CfnFunction.S3EventProperty.Events`.
             * @return {@code this}
             */
            public Builder withEvents(final java.lang.String value) {
                this._events = java.util.Objects.requireNonNull(value, "events is required");
                return this;
            }
            /**
             * Sets the value of Events
             * @param value `CfnFunction.S3EventProperty.Events`.
             * @return {@code this}
             */
            public Builder withEvents(final software.amazon.awscdk.Token value) {
                this._events = java.util.Objects.requireNonNull(value, "events is required");
                return this;
            }
            /**
             * Sets the value of Events
             * @param value `CfnFunction.S3EventProperty.Events`.
             * @return {@code this}
             */
            public Builder withEvents(final java.util.List<java.lang.String> value) {
                this._events = java.util.Objects.requireNonNull(value, "events is required");
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value `CfnFunction.S3EventProperty.Filter`.
             * @return {@code this}
             */
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._filter = value;
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value `CfnFunction.S3EventProperty.Filter`.
             * @return {@code this}
             */
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.S3NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3EventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public S3EventProperty build() {
                return new S3EventProperty() {
                    private final java.lang.String $bucket = java.util.Objects.requireNonNull(_bucket, "bucket is required");
                    private final java.lang.Object $events = java.util.Objects.requireNonNull(_events, "events is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $filter = _filter;

                    @Override
                    public java.lang.String getBucket() {
                        return this.$bucket;
                    }

                    @Override
                    public java.lang.Object getEvents() {
                        return this.$events;
                    }

                    @Override
                    public java.lang.Object getFilter() {
                        return this.$filter;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("bucket", om.valueToTree(this.getBucket()));
                        obj.set("events", om.valueToTree(this.getEvents()));
                        obj.set("filter", om.valueToTree(this.getFilter()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.S3EventProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.S3EventProperty.Bucket`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
             */
            @Override
            public java.lang.String getBucket() {
                return this.jsiiGet("bucket", java.lang.String.class);
            }

            /**
             * `CfnFunction.S3EventProperty.Events`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
             */
            @Override
            public java.lang.Object getEvents() {
                return this.jsiiGet("events", java.lang.Object.class);
            }

            /**
             * `CfnFunction.S3EventProperty.Filter`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getFilter() {
                return this.jsiiGet("filter", java.lang.Object.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3-location-object
     */
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.S3LocationProperty.Bucket`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        java.lang.String getBucket();
        /**
         * `CfnFunction.S3LocationProperty.Key`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        java.lang.String getKey();
        /**
         * `CfnFunction.S3LocationProperty.Version`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        java.lang.Object getVersion();

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link S3LocationProperty}
         */
        final class Builder {
            private java.lang.String _bucket;
            private java.lang.String _key;
            @javax.annotation.Nullable
            private java.lang.Object _version;

            /**
             * Sets the value of Bucket
             * @param value `CfnFunction.S3LocationProperty.Bucket`.
             * @return {@code this}
             */
            public Builder withBucket(final java.lang.String value) {
                this._bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                return this;
            }
            /**
             * Sets the value of Key
             * @param value `CfnFunction.S3LocationProperty.Key`.
             * @return {@code this}
             */
            public Builder withKey(final java.lang.String value) {
                this._key = java.util.Objects.requireNonNull(value, "key is required");
                return this;
            }
            /**
             * Sets the value of Version
             * @param value `CfnFunction.S3LocationProperty.Version`.
             * @return {@code this}
             */
            public Builder withVersion(@javax.annotation.Nullable final java.lang.Number value) {
                this._version = value;
                return this;
            }
            /**
             * Sets the value of Version
             * @param value `CfnFunction.S3LocationProperty.Version`.
             * @return {@code this}
             */
            public Builder withVersion(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._version = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public S3LocationProperty build() {
                return new S3LocationProperty() {
                    private final java.lang.String $bucket = java.util.Objects.requireNonNull(_bucket, "bucket is required");
                    private final java.lang.String $key = java.util.Objects.requireNonNull(_key, "key is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $version = _version;

                    @Override
                    public java.lang.String getBucket() {
                        return this.$bucket;
                    }

                    @Override
                    public java.lang.String getKey() {
                        return this.$key;
                    }

                    @Override
                    public java.lang.Object getVersion() {
                        return this.$version;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("bucket", om.valueToTree(this.getBucket()));
                        obj.set("key", om.valueToTree(this.getKey()));
                        obj.set("version", om.valueToTree(this.getVersion()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.S3LocationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.S3LocationProperty.Bucket`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
             */
            @Override
            public java.lang.String getBucket() {
                return this.jsiiGet("bucket", java.lang.String.class);
            }

            /**
             * `CfnFunction.S3LocationProperty.Key`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
             */
            @Override
            public java.lang.String getKey() {
                return this.jsiiGet("key", java.lang.String.class);
            }

            /**
             * `CfnFunction.S3LocationProperty.Version`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getVersion() {
                return this.jsiiGet("version", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
     */
    public static interface S3NotificationFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.S3NotificationFilterProperty.S3Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
         */
        java.lang.String getS3Key();

        /**
         * @return a {@link Builder} of {@link S3NotificationFilterProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link S3NotificationFilterProperty}
         */
        final class Builder {
            private java.lang.String _s3Key;

            /**
             * Sets the value of S3Key
             * @param value `CfnFunction.S3NotificationFilterProperty.S3Key`.
             * @return {@code this}
             */
            public Builder withS3Key(final java.lang.String value) {
                this._s3Key = java.util.Objects.requireNonNull(value, "s3Key is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3NotificationFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public S3NotificationFilterProperty build() {
                return new S3NotificationFilterProperty() {
                    private final java.lang.String $s3Key = java.util.Objects.requireNonNull(_s3Key, "s3Key is required");

                    @Override
                    public java.lang.String getS3Key() {
                        return this.$s3Key;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("s3Key", om.valueToTree(this.getS3Key()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.S3NotificationFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.S3NotificationFilterProperty.S3Key`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
             */
            @Override
            public java.lang.String getS3Key() {
                return this.jsiiGet("s3Key", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sns
     */
    public static interface SNSEventProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.SNSEventProperty.Topic`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sns
         */
        java.lang.String getTopic();

        /**
         * @return a {@link Builder} of {@link SNSEventProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SNSEventProperty}
         */
        final class Builder {
            private java.lang.String _topic;

            /**
             * Sets the value of Topic
             * @param value `CfnFunction.SNSEventProperty.Topic`.
             * @return {@code this}
             */
            public Builder withTopic(final java.lang.String value) {
                this._topic = java.util.Objects.requireNonNull(value, "topic is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SNSEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SNSEventProperty build() {
                return new SNSEventProperty() {
                    private final java.lang.String $topic = java.util.Objects.requireNonNull(_topic, "topic is required");

                    @Override
                    public java.lang.String getTopic() {
                        return this.$topic;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("topic", om.valueToTree(this.getTopic()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.SNSEventProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.SNSEventProperty.Topic`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sns
             */
            @Override
            public java.lang.String getTopic() {
                return this.jsiiGet("topic", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
     */
    public static interface SQSEventProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.SQSEventProperty.Queue`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
         */
        java.lang.String getQueue();
        /**
         * `CfnFunction.SQSEventProperty.BatchSize`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
         */
        java.lang.Object getBatchSize();
        /**
         * `CfnFunction.SQSEventProperty.Enabled`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
         */
        java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link SQSEventProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SQSEventProperty}
         */
        final class Builder {
            private java.lang.String _queue;
            @javax.annotation.Nullable
            private java.lang.Object _batchSize;
            @javax.annotation.Nullable
            private java.lang.Object _enabled;

            /**
             * Sets the value of Queue
             * @param value `CfnFunction.SQSEventProperty.Queue`.
             * @return {@code this}
             */
            public Builder withQueue(final java.lang.String value) {
                this._queue = java.util.Objects.requireNonNull(value, "queue is required");
                return this;
            }
            /**
             * Sets the value of BatchSize
             * @param value `CfnFunction.SQSEventProperty.BatchSize`.
             * @return {@code this}
             */
            public Builder withBatchSize(@javax.annotation.Nullable final java.lang.Number value) {
                this._batchSize = value;
                return this;
            }
            /**
             * Sets the value of BatchSize
             * @param value `CfnFunction.SQSEventProperty.BatchSize`.
             * @return {@code this}
             */
            public Builder withBatchSize(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._batchSize = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnFunction.SQSEventProperty.Enabled`.
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnFunction.SQSEventProperty.Enabled`.
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._enabled = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SQSEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SQSEventProperty build() {
                return new SQSEventProperty() {
                    private final java.lang.String $queue = java.util.Objects.requireNonNull(_queue, "queue is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $batchSize = _batchSize;
                    @javax.annotation.Nullable
                    private final java.lang.Object $enabled = _enabled;

                    @Override
                    public java.lang.String getQueue() {
                        return this.$queue;
                    }

                    @Override
                    public java.lang.Object getBatchSize() {
                        return this.$batchSize;
                    }

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("queue", om.valueToTree(this.getQueue()));
                        obj.set("batchSize", om.valueToTree(this.getBatchSize()));
                        obj.set("enabled", om.valueToTree(this.getEnabled()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.SQSEventProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.SQSEventProperty.Queue`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
             */
            @Override
            public java.lang.String getQueue() {
                return this.jsiiGet("queue", java.lang.String.class);
            }

            /**
             * `CfnFunction.SQSEventProperty.BatchSize`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getBatchSize() {
                return this.jsiiGet("batchSize", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SQSEventProperty.Enabled`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
     */
    public static interface ScheduleEventProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.ScheduleEventProperty.Schedule`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
         */
        java.lang.String getSchedule();
        /**
         * `CfnFunction.ScheduleEventProperty.Input`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
         */
        java.lang.String getInput();

        /**
         * @return a {@link Builder} of {@link ScheduleEventProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ScheduleEventProperty}
         */
        final class Builder {
            private java.lang.String _schedule;
            @javax.annotation.Nullable
            private java.lang.String _input;

            /**
             * Sets the value of Schedule
             * @param value `CfnFunction.ScheduleEventProperty.Schedule`.
             * @return {@code this}
             */
            public Builder withSchedule(final java.lang.String value) {
                this._schedule = java.util.Objects.requireNonNull(value, "schedule is required");
                return this;
            }
            /**
             * Sets the value of Input
             * @param value `CfnFunction.ScheduleEventProperty.Input`.
             * @return {@code this}
             */
            public Builder withInput(@javax.annotation.Nullable final java.lang.String value) {
                this._input = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ScheduleEventProperty build() {
                return new ScheduleEventProperty() {
                    private final java.lang.String $schedule = java.util.Objects.requireNonNull(_schedule, "schedule is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $input = _input;

                    @Override
                    public java.lang.String getSchedule() {
                        return this.$schedule;
                    }

                    @Override
                    public java.lang.String getInput() {
                        return this.$input;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("schedule", om.valueToTree(this.getSchedule()));
                        obj.set("input", om.valueToTree(this.getInput()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.ScheduleEventProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.ScheduleEventProperty.Schedule`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
             */
            @Override
            public java.lang.String getSchedule() {
                return this.jsiiGet("schedule", java.lang.String.class);
            }

            /**
             * `CfnFunction.ScheduleEventProperty.Input`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getInput() {
                return this.jsiiGet("input", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
     */
    public static interface VpcConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.VpcConfigProperty.SecurityGroupIds`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
         */
        java.util.List<java.lang.String> getSecurityGroupIds();
        /**
         * `CfnFunction.VpcConfigProperty.SubnetIds`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
         */
        java.util.List<java.lang.String> getSubnetIds();

        /**
         * @return a {@link Builder} of {@link VpcConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link VpcConfigProperty}
         */
        final class Builder {
            private java.util.List<java.lang.String> _securityGroupIds;
            private java.util.List<java.lang.String> _subnetIds;

            /**
             * Sets the value of SecurityGroupIds
             * @param value `CfnFunction.VpcConfigProperty.SecurityGroupIds`.
             * @return {@code this}
             */
            public Builder withSecurityGroupIds(final java.util.List<java.lang.String> value) {
                this._securityGroupIds = java.util.Objects.requireNonNull(value, "securityGroupIds is required");
                return this;
            }
            /**
             * Sets the value of SubnetIds
             * @param value `CfnFunction.VpcConfigProperty.SubnetIds`.
             * @return {@code this}
             */
            public Builder withSubnetIds(final java.util.List<java.lang.String> value) {
                this._subnetIds = java.util.Objects.requireNonNull(value, "subnetIds is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public VpcConfigProperty build() {
                return new VpcConfigProperty() {
                    private final java.util.List<java.lang.String> $securityGroupIds = java.util.Objects.requireNonNull(_securityGroupIds, "securityGroupIds is required");
                    private final java.util.List<java.lang.String> $subnetIds = java.util.Objects.requireNonNull(_subnetIds, "subnetIds is required");

                    @Override
                    public java.util.List<java.lang.String> getSecurityGroupIds() {
                        return this.$securityGroupIds;
                    }

                    @Override
                    public java.util.List<java.lang.String> getSubnetIds() {
                        return this.$subnetIds;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                        obj.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.VpcConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.VpcConfigProperty.SecurityGroupIds`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
             */
            @Override
            public java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.jsiiGet("securityGroupIds", java.util.List.class);
            }

            /**
             * `CfnFunction.VpcConfigProperty.SubnetIds`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
             */
            @Override
            public java.util.List<java.lang.String> getSubnetIds() {
                return this.jsiiGet("subnetIds", java.util.List.class);
            }
        }
    }
}
