/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sam;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.Token;
import software.amazon.awscdk.services.sam.CfnFunction;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnFunctionProps
extends JsiiSerializable {
    public Object getCodeUri();

    public String getHandler();

    public String getRuntime();

    public String getAutoPublishAlias();

    public Object getDeadLetterQueue();

    public Object getDeploymentPreference();

    public String getDescription();

    public Object getEnvironment();

    public Object getEvents();

    public String getFunctionName();

    public String getKmsKeyArn();

    public List<String> getLayers();

    public Object getMemorySize();

    public String getPermissionsBoundary();

    public Object getPolicies();

    public Object getReservedConcurrentExecutions();

    public String getRole();

    public Map<String, String> getTags();

    public Object getTimeout();

    public String getTracing();

    public Object getVpcConfig();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Object _codeUri;
        private String _handler;
        private String _runtime;
        @Nullable
        private String _autoPublishAlias;
        @Nullable
        private Object _deadLetterQueue;
        @Nullable
        private Object _deploymentPreference;
        @Nullable
        private String _description;
        @Nullable
        private Object _environment;
        @Nullable
        private Object _events;
        @Nullable
        private String _functionName;
        @Nullable
        private String _kmsKeyArn;
        @Nullable
        private List<String> _layers;
        @Nullable
        private Object _memorySize;
        @Nullable
        private String _permissionsBoundary;
        @Nullable
        private Object _policies;
        @Nullable
        private Object _reservedConcurrentExecutions;
        @Nullable
        private String _role;
        @Nullable
        private Map<String, String> _tags;
        @Nullable
        private Object _timeout;
        @Nullable
        private String _tracing;
        @Nullable
        private Object _vpcConfig;

        public Builder withCodeUri(String value) {
            this._codeUri = Objects.requireNonNull(value, "codeUri is required");
            return this;
        }

        public Builder withCodeUri(Token value) {
            this._codeUri = Objects.requireNonNull(value, "codeUri is required");
            return this;
        }

        public Builder withCodeUri(CfnFunction.S3LocationProperty value) {
            this._codeUri = Objects.requireNonNull(value, "codeUri is required");
            return this;
        }

        public Builder withHandler(String value) {
            this._handler = Objects.requireNonNull(value, "handler is required");
            return this;
        }

        public Builder withRuntime(String value) {
            this._runtime = Objects.requireNonNull(value, "runtime is required");
            return this;
        }

        public Builder withAutoPublishAlias(@Nullable String value) {
            this._autoPublishAlias = value;
            return this;
        }

        public Builder withDeadLetterQueue(@Nullable Token value) {
            this._deadLetterQueue = value;
            return this;
        }

        public Builder withDeadLetterQueue(@Nullable CfnFunction.DeadLetterQueueProperty value) {
            this._deadLetterQueue = value;
            return this;
        }

        public Builder withDeploymentPreference(@Nullable Token value) {
            this._deploymentPreference = value;
            return this;
        }

        public Builder withDeploymentPreference(@Nullable CfnFunction.DeploymentPreferenceProperty value) {
            this._deploymentPreference = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withEnvironment(@Nullable Token value) {
            this._environment = value;
            return this;
        }

        public Builder withEnvironment(@Nullable CfnFunction.FunctionEnvironmentProperty value) {
            this._environment = value;
            return this;
        }

        public Builder withEvents(@Nullable Token value) {
            this._events = value;
            return this;
        }

        public Builder withEvents(@Nullable Map<String, Object> value) {
            this._events = value;
            return this;
        }

        public Builder withFunctionName(@Nullable String value) {
            this._functionName = value;
            return this;
        }

        public Builder withKmsKeyArn(@Nullable String value) {
            this._kmsKeyArn = value;
            return this;
        }

        public Builder withLayers(@Nullable List<String> value) {
            this._layers = value;
            return this;
        }

        public Builder withMemorySize(@Nullable Number value) {
            this._memorySize = value;
            return this;
        }

        public Builder withMemorySize(@Nullable Token value) {
            this._memorySize = value;
            return this;
        }

        public Builder withPermissionsBoundary(@Nullable String value) {
            this._permissionsBoundary = value;
            return this;
        }

        public Builder withPolicies(@Nullable String value) {
            this._policies = value;
            return this;
        }

        public Builder withPolicies(@Nullable Token value) {
            this._policies = value;
            return this;
        }

        public Builder withPolicies(@Nullable CfnFunction.IAMPolicyDocumentProperty value) {
            this._policies = value;
            return this;
        }

        public Builder withPolicies(@Nullable List<Object> value) {
            this._policies = value;
            return this;
        }

        public Builder withReservedConcurrentExecutions(@Nullable Number value) {
            this._reservedConcurrentExecutions = value;
            return this;
        }

        public Builder withReservedConcurrentExecutions(@Nullable Token value) {
            this._reservedConcurrentExecutions = value;
            return this;
        }

        public Builder withRole(@Nullable String value) {
            this._role = value;
            return this;
        }

        public Builder withTags(@Nullable Map<String, String> value) {
            this._tags = value;
            return this;
        }

        public Builder withTimeout(@Nullable Number value) {
            this._timeout = value;
            return this;
        }

        public Builder withTimeout(@Nullable Token value) {
            this._timeout = value;
            return this;
        }

        public Builder withTracing(@Nullable String value) {
            this._tracing = value;
            return this;
        }

        public Builder withVpcConfig(@Nullable Token value) {
            this._vpcConfig = value;
            return this;
        }

        public Builder withVpcConfig(@Nullable CfnFunction.VpcConfigProperty value) {
            this._vpcConfig = value;
            return this;
        }

        public CfnFunctionProps build() {
            return new CfnFunctionProps(){
                private final Object $codeUri;
                private final String $handler;
                private final String $runtime;
                @Nullable
                private final String $autoPublishAlias;
                @Nullable
                private final Object $deadLetterQueue;
                @Nullable
                private final Object $deploymentPreference;
                @Nullable
                private final String $description;
                @Nullable
                private final Object $environment;
                @Nullable
                private final Object $events;
                @Nullable
                private final String $functionName;
                @Nullable
                private final String $kmsKeyArn;
                @Nullable
                private final List<String> $layers;
                @Nullable
                private final Object $memorySize;
                @Nullable
                private final String $permissionsBoundary;
                @Nullable
                private final Object $policies;
                @Nullable
                private final Object $reservedConcurrentExecutions;
                @Nullable
                private final String $role;
                @Nullable
                private final Map<String, String> $tags;
                @Nullable
                private final Object $timeout;
                @Nullable
                private final String $tracing;
                @Nullable
                private final Object $vpcConfig;
                {
                    this.$codeUri = Objects.requireNonNull(_codeUri, "codeUri is required");
                    this.$handler = Objects.requireNonNull(_handler, "handler is required");
                    this.$runtime = Objects.requireNonNull(_runtime, "runtime is required");
                    this.$autoPublishAlias = _autoPublishAlias;
                    this.$deadLetterQueue = _deadLetterQueue;
                    this.$deploymentPreference = _deploymentPreference;
                    this.$description = _description;
                    this.$environment = _environment;
                    this.$events = _events;
                    this.$functionName = _functionName;
                    this.$kmsKeyArn = _kmsKeyArn;
                    this.$layers = _layers;
                    this.$memorySize = _memorySize;
                    this.$permissionsBoundary = _permissionsBoundary;
                    this.$policies = _policies;
                    this.$reservedConcurrentExecutions = _reservedConcurrentExecutions;
                    this.$role = _role;
                    this.$tags = _tags;
                    this.$timeout = _timeout;
                    this.$tracing = _tracing;
                    this.$vpcConfig = _vpcConfig;
                }

                @Override
                public Object getCodeUri() {
                    return this.$codeUri;
                }

                @Override
                public String getHandler() {
                    return this.$handler;
                }

                @Override
                public String getRuntime() {
                    return this.$runtime;
                }

                @Override
                public String getAutoPublishAlias() {
                    return this.$autoPublishAlias;
                }

                @Override
                public Object getDeadLetterQueue() {
                    return this.$deadLetterQueue;
                }

                @Override
                public Object getDeploymentPreference() {
                    return this.$deploymentPreference;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public Object getEnvironment() {
                    return this.$environment;
                }

                @Override
                public Object getEvents() {
                    return this.$events;
                }

                @Override
                public String getFunctionName() {
                    return this.$functionName;
                }

                @Override
                public String getKmsKeyArn() {
                    return this.$kmsKeyArn;
                }

                @Override
                public List<String> getLayers() {
                    return this.$layers;
                }

                @Override
                public Object getMemorySize() {
                    return this.$memorySize;
                }

                @Override
                public String getPermissionsBoundary() {
                    return this.$permissionsBoundary;
                }

                @Override
                public Object getPolicies() {
                    return this.$policies;
                }

                @Override
                public Object getReservedConcurrentExecutions() {
                    return this.$reservedConcurrentExecutions;
                }

                @Override
                public String getRole() {
                    return this.$role;
                }

                @Override
                public Map<String, String> getTags() {
                    return this.$tags;
                }

                @Override
                public Object getTimeout() {
                    return this.$timeout;
                }

                @Override
                public String getTracing() {
                    return this.$tracing;
                }

                @Override
                public Object getVpcConfig() {
                    return this.$vpcConfig;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("codeUri", om.valueToTree(this.getCodeUri()));
                    obj.set("handler", om.valueToTree((Object)this.getHandler()));
                    obj.set("runtime", om.valueToTree((Object)this.getRuntime()));
                    obj.set("autoPublishAlias", om.valueToTree((Object)this.getAutoPublishAlias()));
                    obj.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
                    obj.set("deploymentPreference", om.valueToTree(this.getDeploymentPreference()));
                    obj.set("description", om.valueToTree((Object)this.getDescription()));
                    obj.set("environment", om.valueToTree(this.getEnvironment()));
                    obj.set("events", om.valueToTree(this.getEvents()));
                    obj.set("functionName", om.valueToTree((Object)this.getFunctionName()));
                    obj.set("kmsKeyArn", om.valueToTree((Object)this.getKmsKeyArn()));
                    obj.set("layers", om.valueToTree(this.getLayers()));
                    obj.set("memorySize", om.valueToTree(this.getMemorySize()));
                    obj.set("permissionsBoundary", om.valueToTree((Object)this.getPermissionsBoundary()));
                    obj.set("policies", om.valueToTree(this.getPolicies()));
                    obj.set("reservedConcurrentExecutions", om.valueToTree(this.getReservedConcurrentExecutions()));
                    obj.set("role", om.valueToTree((Object)this.getRole()));
                    obj.set("tags", om.valueToTree(this.getTags()));
                    obj.set("timeout", om.valueToTree(this.getTimeout()));
                    obj.set("tracing", om.valueToTree((Object)this.getTracing()));
                    obj.set("vpcConfig", om.valueToTree(this.getVpcConfig()));
                    return obj;
                }
            };
        }
    }
}

