package software.amazon.awscdk.services.sam;

/**
 * A CloudFormation `AWS::Serverless::Function`.
 * 
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.2 (build e881f16)", date = "2019-07-19T19:03:57.065Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction")
public class CfnFunction extends software.amazon.awscdk.core.CfnResource {
    protected CfnFunction(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnFunction.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
        REQUIRED_TRANSFORM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnFunction.class, "REQUIRED_TRANSFORM", java.lang.String.class);
    }
    /**
     * Create a new `AWS::Serverless::Function`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnFunction(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.sam.CfnFunctionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;
    /**
     * The `Transform` a template must use in order to use this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String REQUIRED_TRANSFORM;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return this.jsiiGet("cfnProperties", java.util.Map.class);
    }

    /**
     * `AWS::Serverless::Function.Tags`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::Serverless::Function.CodeUri`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getCodeUri() {
        return this.jsiiGet("codeUri", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Function.CodeUri`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCodeUri(final java.lang.String value) {
        this.jsiiSet("codeUri", java.util.Objects.requireNonNull(value, "codeUri is required"));
    }

    /**
     * `AWS::Serverless::Function.CodeUri`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCodeUri(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("codeUri", java.util.Objects.requireNonNull(value, "codeUri is required"));
    }

    /**
     * `AWS::Serverless::Function.CodeUri`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCodeUri(final software.amazon.awscdk.services.sam.CfnFunction.S3LocationProperty value) {
        this.jsiiSet("codeUri", java.util.Objects.requireNonNull(value, "codeUri is required"));
    }

    /**
     * `AWS::Serverless::Function.Handler`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getHandler() {
        return this.jsiiGet("handler", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Function.Handler`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setHandler(final java.lang.String value) {
        this.jsiiSet("handler", java.util.Objects.requireNonNull(value, "handler is required"));
    }

    /**
     * `AWS::Serverless::Function.Runtime`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getRuntime() {
        return this.jsiiGet("runtime", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Function.Runtime`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRuntime(final java.lang.String value) {
        this.jsiiSet("runtime", java.util.Objects.requireNonNull(value, "runtime is required"));
    }

    /**
     * `AWS::Serverless::Function.AutoPublishAlias`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getAutoPublishAlias() {
        return this.jsiiGet("autoPublishAlias", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Function.AutoPublishAlias`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAutoPublishAlias(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("autoPublishAlias", value);
    }

    /**
     * `AWS::Serverless::Function.DeadLetterQueue`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getDeadLetterQueue() {
        return this.jsiiGet("deadLetterQueue", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Function.DeadLetterQueue`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDeadLetterQueue(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("deadLetterQueue", value);
    }

    /**
     * `AWS::Serverless::Function.DeadLetterQueue`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDeadLetterQueue(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.DeadLetterQueueProperty value) {
        this.jsiiSet("deadLetterQueue", value);
    }

    /**
     * `AWS::Serverless::Function.DeploymentPreference`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getDeploymentPreference() {
        return this.jsiiGet("deploymentPreference", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Function.DeploymentPreference`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDeploymentPreference(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("deploymentPreference", value);
    }

    /**
     * `AWS::Serverless::Function.DeploymentPreference`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDeploymentPreference(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.DeploymentPreferenceProperty value) {
        this.jsiiSet("deploymentPreference", value);
    }

    /**
     * `AWS::Serverless::Function.Description`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getDescription() {
        return this.jsiiGet("description", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Function.Description`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("description", value);
    }

    /**
     * `AWS::Serverless::Function.Environment`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getEnvironment() {
        return this.jsiiGet("environment", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Function.Environment`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEnvironment(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("environment", value);
    }

    /**
     * `AWS::Serverless::Function.Environment`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEnvironment(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.FunctionEnvironmentProperty value) {
        this.jsiiSet("environment", value);
    }

    /**
     * `AWS::Serverless::Function.Events`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getEvents() {
        return this.jsiiGet("events", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Function.Events`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEvents(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("events", value);
    }

    /**
     * `AWS::Serverless::Function.Events`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEvents(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
        this.jsiiSet("events", value);
    }

    /**
     * `AWS::Serverless::Function.FunctionName`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getFunctionName() {
        return this.jsiiGet("functionName", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Function.FunctionName`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setFunctionName(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("functionName", value);
    }

    /**
     * `AWS::Serverless::Function.KmsKeyArn`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getKmsKeyArn() {
        return this.jsiiGet("kmsKeyArn", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Function.KmsKeyArn`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setKmsKeyArn(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("kmsKeyArn", value);
    }

    /**
     * `AWS::Serverless::Function.Layers`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.util.List<java.lang.String> getLayers() {
        return this.jsiiGet("layers", java.util.List.class);
    }

    /**
     * `AWS::Serverless::Function.Layers`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLayers(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
        this.jsiiSet("layers", value);
    }

    /**
     * `AWS::Serverless::Function.MemorySize`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Number getMemorySize() {
        return this.jsiiGet("memorySize", java.lang.Number.class);
    }

    /**
     * `AWS::Serverless::Function.MemorySize`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMemorySize(@javax.annotation.Nullable final java.lang.Number value) {
        this.jsiiSet("memorySize", value);
    }

    /**
     * `AWS::Serverless::Function.PermissionsBoundary`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getPermissionsBoundary() {
        return this.jsiiGet("permissionsBoundary", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Function.PermissionsBoundary`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPermissionsBoundary(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("permissionsBoundary", value);
    }

    /**
     * `AWS::Serverless::Function.Policies`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getPolicies() {
        return this.jsiiGet("policies", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Function.Policies`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPolicies(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("policies", value);
    }

    /**
     * `AWS::Serverless::Function.Policies`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPolicies(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("policies", value);
    }

    /**
     * `AWS::Serverless::Function.Policies`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPolicies(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.IAMPolicyDocumentProperty value) {
        this.jsiiSet("policies", value);
    }

    /**
     * `AWS::Serverless::Function.Policies`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPolicies(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
        this.jsiiSet("policies", value);
    }

    /**
     * `AWS::Serverless::Function.ReservedConcurrentExecutions`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Number getReservedConcurrentExecutions() {
        return this.jsiiGet("reservedConcurrentExecutions", java.lang.Number.class);
    }

    /**
     * `AWS::Serverless::Function.ReservedConcurrentExecutions`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setReservedConcurrentExecutions(@javax.annotation.Nullable final java.lang.Number value) {
        this.jsiiSet("reservedConcurrentExecutions", value);
    }

    /**
     * `AWS::Serverless::Function.Role`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getRole() {
        return this.jsiiGet("role", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Function.Role`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRole(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("role", value);
    }

    /**
     * `AWS::Serverless::Function.Timeout`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Number getTimeout() {
        return this.jsiiGet("timeout", java.lang.Number.class);
    }

    /**
     * `AWS::Serverless::Function.Timeout`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTimeout(@javax.annotation.Nullable final java.lang.Number value) {
        this.jsiiSet("timeout", value);
    }

    /**
     * `AWS::Serverless::Function.Tracing`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getTracing() {
        return this.jsiiGet("tracing", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Function.Tracing`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTracing(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("tracing", value);
    }

    /**
     * `AWS::Serverless::Function.VpcConfig`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getVpcConfig() {
        return this.jsiiGet("vpcConfig", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Function.VpcConfig`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVpcConfig(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("vpcConfig", value);
    }

    /**
     * `AWS::Serverless::Function.VpcConfig`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVpcConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.VpcConfigProperty value) {
        this.jsiiSet("vpcConfig", value);
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#alexaskill
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AlexaSkillEventProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.AlexaSkillEventProperty.Variables`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#alexaskill
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getVariables();

        /**
         * @return a {@link Builder} of {@link AlexaSkillEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AlexaSkillEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _variables;

            /**
             * Sets the value of Variables
             * @param value `CfnFunction.AlexaSkillEventProperty.Variables`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withVariables(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._variables = value;
                return this;
            }
            /**
             * Sets the value of Variables
             * @param value `CfnFunction.AlexaSkillEventProperty.Variables`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withVariables(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                this._variables = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlexaSkillEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AlexaSkillEventProperty build() {
                return new AlexaSkillEventProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $variables = _variables;

                    @Override
                    public java.lang.Object getVariables() {
                        return this.$variables;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getVariables() != null) {
                            obj.set("variables", om.valueToTree(this.getVariables()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.AlexaSkillEventProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.AlexaSkillEventProperty.Variables`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#alexaskill
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getVariables() {
                return this.jsiiGet("variables", java.lang.Object.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ApiEventProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.ApiEventProperty.Method`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getMethod();
        /**
         * `CfnFunction.ApiEventProperty.Path`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPath();
        /**
         * `CfnFunction.ApiEventProperty.RestApiId`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getRestApiId();

        /**
         * @return a {@link Builder} of {@link ApiEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ApiEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _method;
            private java.lang.String _path;
            @javax.annotation.Nullable
            private java.lang.String _restApiId;

            /**
             * Sets the value of Method
             * @param value `CfnFunction.ApiEventProperty.Method`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withMethod(final java.lang.String value) {
                this._method = java.util.Objects.requireNonNull(value, "method is required");
                return this;
            }
            /**
             * Sets the value of Path
             * @param value `CfnFunction.ApiEventProperty.Path`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withPath(final java.lang.String value) {
                this._path = java.util.Objects.requireNonNull(value, "path is required");
                return this;
            }
            /**
             * Sets the value of RestApiId
             * @param value `CfnFunction.ApiEventProperty.RestApiId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withRestApiId(@javax.annotation.Nullable final java.lang.String value) {
                this._restApiId = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApiEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ApiEventProperty build() {
                return new ApiEventProperty() {
                    private final java.lang.String $method = java.util.Objects.requireNonNull(_method, "method is required");
                    private final java.lang.String $path = java.util.Objects.requireNonNull(_path, "path is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $restApiId = _restApiId;

                    @Override
                    public java.lang.String getMethod() {
                        return this.$method;
                    }

                    @Override
                    public java.lang.String getPath() {
                        return this.$path;
                    }

                    @Override
                    public java.lang.String getRestApiId() {
                        return this.$restApiId;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("method", om.valueToTree(this.getMethod()));
                        obj.set("path", om.valueToTree(this.getPath()));
                        if (this.getRestApiId() != null) {
                            obj.set("restApiId", om.valueToTree(this.getRestApiId()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.ApiEventProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.ApiEventProperty.Method`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getMethod() {
                return this.jsiiGet("method", java.lang.String.class);
            }

            /**
             * `CfnFunction.ApiEventProperty.Path`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getPath() {
                return this.jsiiGet("path", java.lang.String.class);
            }

            /**
             * `CfnFunction.ApiEventProperty.RestApiId`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getRestApiId() {
                return this.jsiiGet("restApiId", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface BucketSAMPTProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.BucketSAMPTProperty.BucketName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getBucketName();

        /**
         * @return a {@link Builder} of {@link BucketSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link BucketSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _bucketName;

            /**
             * Sets the value of BucketName
             * @param value `CfnFunction.BucketSAMPTProperty.BucketName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withBucketName(final java.lang.String value) {
                this._bucketName = java.util.Objects.requireNonNull(value, "bucketName is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BucketSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public BucketSAMPTProperty build() {
                return new BucketSAMPTProperty() {
                    private final java.lang.String $bucketName = java.util.Objects.requireNonNull(_bucketName, "bucketName is required");

                    @Override
                    public java.lang.String getBucketName() {
                        return this.$bucketName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("bucketName", om.valueToTree(this.getBucketName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.BucketSAMPTProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.BucketSAMPTProperty.BucketName`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getBucketName() {
                return this.jsiiGet("bucketName", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CloudWatchEventEventProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.CloudWatchEventEventProperty.Pattern`.
         * 
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getPattern();
        /**
         * `CfnFunction.CloudWatchEventEventProperty.Input`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getInput();
        /**
         * `CfnFunction.CloudWatchEventEventProperty.InputPath`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getInputPath();

        /**
         * @return a {@link Builder} of {@link CloudWatchEventEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CloudWatchEventEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object _pattern;
            @javax.annotation.Nullable
            private java.lang.String _input;
            @javax.annotation.Nullable
            private java.lang.String _inputPath;

            /**
             * Sets the value of Pattern
             * @param value `CfnFunction.CloudWatchEventEventProperty.Pattern`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withPattern(final java.lang.Object value) {
                this._pattern = java.util.Objects.requireNonNull(value, "pattern is required");
                return this;
            }
            /**
             * Sets the value of Input
             * @param value `CfnFunction.CloudWatchEventEventProperty.Input`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withInput(@javax.annotation.Nullable final java.lang.String value) {
                this._input = value;
                return this;
            }
            /**
             * Sets the value of InputPath
             * @param value `CfnFunction.CloudWatchEventEventProperty.InputPath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withInputPath(@javax.annotation.Nullable final java.lang.String value) {
                this._inputPath = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchEventEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CloudWatchEventEventProperty build() {
                return new CloudWatchEventEventProperty() {
                    private final java.lang.Object $pattern = java.util.Objects.requireNonNull(_pattern, "pattern is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $input = _input;
                    @javax.annotation.Nullable
                    private final java.lang.String $inputPath = _inputPath;

                    @Override
                    public java.lang.Object getPattern() {
                        return this.$pattern;
                    }

                    @Override
                    public java.lang.String getInput() {
                        return this.$input;
                    }

                    @Override
                    public java.lang.String getInputPath() {
                        return this.$inputPath;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("pattern", om.valueToTree(this.getPattern()));
                        if (this.getInput() != null) {
                            obj.set("input", om.valueToTree(this.getInput()));
                        }
                        if (this.getInputPath() != null) {
                            obj.set("inputPath", om.valueToTree(this.getInputPath()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.CloudWatchEventEventProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.CloudWatchEventEventProperty.Pattern`.
             * 
             * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getPattern() {
                return this.jsiiGet("pattern", java.lang.Object.class);
            }

            /**
             * `CfnFunction.CloudWatchEventEventProperty.Input`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getInput() {
                return this.jsiiGet("input", java.lang.String.class);
            }

            /**
             * `CfnFunction.CloudWatchEventEventProperty.InputPath`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getInputPath() {
                return this.jsiiGet("inputPath", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CollectionSAMPTProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.CollectionSAMPTProperty.CollectionId`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCollectionId();

        /**
         * @return a {@link Builder} of {@link CollectionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CollectionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _collectionId;

            /**
             * Sets the value of CollectionId
             * @param value `CfnFunction.CollectionSAMPTProperty.CollectionId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCollectionId(final java.lang.String value) {
                this._collectionId = java.util.Objects.requireNonNull(value, "collectionId is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CollectionSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CollectionSAMPTProperty build() {
                return new CollectionSAMPTProperty() {
                    private final java.lang.String $collectionId = java.util.Objects.requireNonNull(_collectionId, "collectionId is required");

                    @Override
                    public java.lang.String getCollectionId() {
                        return this.$collectionId;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("collectionId", om.valueToTree(this.getCollectionId()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.CollectionSAMPTProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.CollectionSAMPTProperty.CollectionId`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getCollectionId() {
                return this.jsiiGet("collectionId", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deadletterqueue-object
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface DeadLetterQueueProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.DeadLetterQueueProperty.TargetArn`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getTargetArn();
        /**
         * `CfnFunction.DeadLetterQueueProperty.Type`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link DeadLetterQueueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DeadLetterQueueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _targetArn;
            private java.lang.String _type;

            /**
             * Sets the value of TargetArn
             * @param value `CfnFunction.DeadLetterQueueProperty.TargetArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withTargetArn(final java.lang.String value) {
                this._targetArn = java.util.Objects.requireNonNull(value, "targetArn is required");
                return this;
            }
            /**
             * Sets the value of Type
             * @param value `CfnFunction.DeadLetterQueueProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withType(final java.lang.String value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeadLetterQueueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public DeadLetterQueueProperty build() {
                return new DeadLetterQueueProperty() {
                    private final java.lang.String $targetArn = java.util.Objects.requireNonNull(_targetArn, "targetArn is required");
                    private final java.lang.String $type = java.util.Objects.requireNonNull(_type, "type is required");

                    @Override
                    public java.lang.String getTargetArn() {
                        return this.$targetArn;
                    }

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("targetArn", om.valueToTree(this.getTargetArn()));
                        obj.set("type", om.valueToTree(this.getType()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.DeadLetterQueueProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.DeadLetterQueueProperty.TargetArn`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getTargetArn() {
                return this.jsiiGet("targetArn", java.lang.String.class);
            }

            /**
             * `CfnFunction.DeadLetterQueueProperty.Type`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/safe_lambda_deployments.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface DeploymentPreferenceProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.DeploymentPreferenceProperty.Enabled`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEnabled();
        /**
         * `CfnFunction.DeploymentPreferenceProperty.Type`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getType();
        /**
         * `CfnFunction.DeploymentPreferenceProperty.Alarms`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getAlarms();
        /**
         * `CfnFunction.DeploymentPreferenceProperty.Hooks`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getHooks();

        /**
         * @return a {@link Builder} of {@link DeploymentPreferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DeploymentPreferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object _enabled;
            private java.lang.String _type;
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _alarms;
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _hooks;

            /**
             * Sets the value of Enabled
             * @param value `CfnFunction.DeploymentPreferenceProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEnabled(final java.lang.Boolean value) {
                this._enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnFunction.DeploymentPreferenceProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEnabled(final software.amazon.awscdk.core.IResolvable value) {
                this._enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                return this;
            }
            /**
             * Sets the value of Type
             * @param value `CfnFunction.DeploymentPreferenceProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withType(final java.lang.String value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }
            /**
             * Sets the value of Alarms
             * @param value `CfnFunction.DeploymentPreferenceProperty.Alarms`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withAlarms(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._alarms = value;
                return this;
            }
            /**
             * Sets the value of Hooks
             * @param value `CfnFunction.DeploymentPreferenceProperty.Hooks`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withHooks(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._hooks = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentPreferenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public DeploymentPreferenceProperty build() {
                return new DeploymentPreferenceProperty() {
                    private final java.lang.Object $enabled = java.util.Objects.requireNonNull(_enabled, "enabled is required");
                    private final java.lang.String $type = java.util.Objects.requireNonNull(_type, "type is required");
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $alarms = _alarms;
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $hooks = _hooks;

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    @Override
                    public java.util.List<java.lang.String> getAlarms() {
                        return this.$alarms;
                    }

                    @Override
                    public java.util.List<java.lang.String> getHooks() {
                        return this.$hooks;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("enabled", om.valueToTree(this.getEnabled()));
                        obj.set("type", om.valueToTree(this.getType()));
                        if (this.getAlarms() != null) {
                            obj.set("alarms", om.valueToTree(this.getAlarms()));
                        }
                        if (this.getHooks() != null) {
                            obj.set("hooks", om.valueToTree(this.getHooks()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.DeploymentPreferenceProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.DeploymentPreferenceProperty.Enabled`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * `CfnFunction.DeploymentPreferenceProperty.Type`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }

            /**
             * `CfnFunction.DeploymentPreferenceProperty.Alarms`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getAlarms() {
                return this.jsiiGet("alarms", java.util.List.class);
            }

            /**
             * `CfnFunction.DeploymentPreferenceProperty.Hooks`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getHooks() {
                return this.jsiiGet("hooks", java.util.List.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface DomainSAMPTProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.DomainSAMPTProperty.DomainName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDomainName();

        /**
         * @return a {@link Builder} of {@link DomainSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DomainSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _domainName;

            /**
             * Sets the value of DomainName
             * @param value `CfnFunction.DomainSAMPTProperty.DomainName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDomainName(final java.lang.String value) {
                this._domainName = java.util.Objects.requireNonNull(value, "domainName is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DomainSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public DomainSAMPTProperty build() {
                return new DomainSAMPTProperty() {
                    private final java.lang.String $domainName = java.util.Objects.requireNonNull(_domainName, "domainName is required");

                    @Override
                    public java.lang.String getDomainName() {
                        return this.$domainName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("domainName", om.valueToTree(this.getDomainName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.DomainSAMPTProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.DomainSAMPTProperty.DomainName`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getDomainName() {
                return this.jsiiGet("domainName", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface DynamoDBEventProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.DynamoDBEventProperty.StartingPosition`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStartingPosition();
        /**
         * `CfnFunction.DynamoDBEventProperty.Stream`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStream();
        /**
         * `CfnFunction.DynamoDBEventProperty.BatchSize`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getBatchSize();
        /**
         * `CfnFunction.DynamoDBEventProperty.Enabled`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link DynamoDBEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DynamoDBEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _startingPosition;
            private java.lang.String _stream;
            @javax.annotation.Nullable
            private java.lang.Number _batchSize;
            @javax.annotation.Nullable
            private java.lang.Object _enabled;

            /**
             * Sets the value of StartingPosition
             * @param value `CfnFunction.DynamoDBEventProperty.StartingPosition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withStartingPosition(final java.lang.String value) {
                this._startingPosition = java.util.Objects.requireNonNull(value, "startingPosition is required");
                return this;
            }
            /**
             * Sets the value of Stream
             * @param value `CfnFunction.DynamoDBEventProperty.Stream`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withStream(final java.lang.String value) {
                this._stream = java.util.Objects.requireNonNull(value, "stream is required");
                return this;
            }
            /**
             * Sets the value of BatchSize
             * @param value `CfnFunction.DynamoDBEventProperty.BatchSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withBatchSize(@javax.annotation.Nullable final java.lang.Number value) {
                this._batchSize = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnFunction.DynamoDBEventProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnFunction.DynamoDBEventProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEnabled(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._enabled = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynamoDBEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public DynamoDBEventProperty build() {
                return new DynamoDBEventProperty() {
                    private final java.lang.String $startingPosition = java.util.Objects.requireNonNull(_startingPosition, "startingPosition is required");
                    private final java.lang.String $stream = java.util.Objects.requireNonNull(_stream, "stream is required");
                    @javax.annotation.Nullable
                    private final java.lang.Number $batchSize = _batchSize;
                    @javax.annotation.Nullable
                    private final java.lang.Object $enabled = _enabled;

                    @Override
                    public java.lang.String getStartingPosition() {
                        return this.$startingPosition;
                    }

                    @Override
                    public java.lang.String getStream() {
                        return this.$stream;
                    }

                    @Override
                    public java.lang.Number getBatchSize() {
                        return this.$batchSize;
                    }

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("startingPosition", om.valueToTree(this.getStartingPosition()));
                        obj.set("stream", om.valueToTree(this.getStream()));
                        if (this.getBatchSize() != null) {
                            obj.set("batchSize", om.valueToTree(this.getBatchSize()));
                        }
                        if (this.getEnabled() != null) {
                            obj.set("enabled", om.valueToTree(this.getEnabled()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.DynamoDBEventProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.DynamoDBEventProperty.StartingPosition`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getStartingPosition() {
                return this.jsiiGet("startingPosition", java.lang.String.class);
            }

            /**
             * `CfnFunction.DynamoDBEventProperty.Stream`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getStream() {
                return this.jsiiGet("stream", java.lang.String.class);
            }

            /**
             * `CfnFunction.DynamoDBEventProperty.BatchSize`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Number getBatchSize() {
                return this.jsiiGet("batchSize", java.lang.Number.class);
            }

            /**
             * `CfnFunction.DynamoDBEventProperty.Enabled`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface EmptySAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @return a {@link Builder} of {@link EmptySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EmptySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {


            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmptySAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public EmptySAMPTProperty build() {
                return new EmptySAMPTProperty() {

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-object
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface EventSourceProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.EventSourceProperty.Properties`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-types
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getProperties();
        /**
         * `CfnFunction.EventSourceProperty.Type`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-object
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link EventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object _properties;
            private java.lang.String _type;

            /**
             * Sets the value of Properties
             * @param value `CfnFunction.EventSourceProperty.Properties`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withProperties(final software.amazon.awscdk.core.IResolvable value) {
                this._properties = java.util.Objects.requireNonNull(value, "properties is required");
                return this;
            }
            /**
             * Sets the value of Properties
             * @param value `CfnFunction.EventSourceProperty.Properties`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withProperties(final software.amazon.awscdk.services.sam.CfnFunction.AlexaSkillEventProperty value) {
                this._properties = java.util.Objects.requireNonNull(value, "properties is required");
                return this;
            }
            /**
             * Sets the value of Properties
             * @param value `CfnFunction.EventSourceProperty.Properties`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withProperties(final software.amazon.awscdk.services.sam.CfnFunction.ApiEventProperty value) {
                this._properties = java.util.Objects.requireNonNull(value, "properties is required");
                return this;
            }
            /**
             * Sets the value of Properties
             * @param value `CfnFunction.EventSourceProperty.Properties`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withProperties(final software.amazon.awscdk.services.sam.CfnFunction.CloudWatchEventEventProperty value) {
                this._properties = java.util.Objects.requireNonNull(value, "properties is required");
                return this;
            }
            /**
             * Sets the value of Properties
             * @param value `CfnFunction.EventSourceProperty.Properties`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withProperties(final software.amazon.awscdk.services.sam.CfnFunction.DynamoDBEventProperty value) {
                this._properties = java.util.Objects.requireNonNull(value, "properties is required");
                return this;
            }
            /**
             * Sets the value of Properties
             * @param value `CfnFunction.EventSourceProperty.Properties`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withProperties(final software.amazon.awscdk.services.sam.CfnFunction.S3EventProperty value) {
                this._properties = java.util.Objects.requireNonNull(value, "properties is required");
                return this;
            }
            /**
             * Sets the value of Properties
             * @param value `CfnFunction.EventSourceProperty.Properties`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withProperties(final software.amazon.awscdk.services.sam.CfnFunction.SNSEventProperty value) {
                this._properties = java.util.Objects.requireNonNull(value, "properties is required");
                return this;
            }
            /**
             * Sets the value of Properties
             * @param value `CfnFunction.EventSourceProperty.Properties`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withProperties(final software.amazon.awscdk.services.sam.CfnFunction.SQSEventProperty value) {
                this._properties = java.util.Objects.requireNonNull(value, "properties is required");
                return this;
            }
            /**
             * Sets the value of Properties
             * @param value `CfnFunction.EventSourceProperty.Properties`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withProperties(final software.amazon.awscdk.services.sam.CfnFunction.KinesisEventProperty value) {
                this._properties = java.util.Objects.requireNonNull(value, "properties is required");
                return this;
            }
            /**
             * Sets the value of Properties
             * @param value `CfnFunction.EventSourceProperty.Properties`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withProperties(final software.amazon.awscdk.services.sam.CfnFunction.ScheduleEventProperty value) {
                this._properties = java.util.Objects.requireNonNull(value, "properties is required");
                return this;
            }
            /**
             * Sets the value of Properties
             * @param value `CfnFunction.EventSourceProperty.Properties`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withProperties(final software.amazon.awscdk.services.sam.CfnFunction.IoTRuleEventProperty value) {
                this._properties = java.util.Objects.requireNonNull(value, "properties is required");
                return this;
            }
            /**
             * Sets the value of Type
             * @param value `CfnFunction.EventSourceProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withType(final java.lang.String value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public EventSourceProperty build() {
                return new EventSourceProperty() {
                    private final java.lang.Object $properties = java.util.Objects.requireNonNull(_properties, "properties is required");
                    private final java.lang.String $type = java.util.Objects.requireNonNull(_type, "type is required");

                    @Override
                    public java.lang.Object getProperties() {
                        return this.$properties;
                    }

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("properties", om.valueToTree(this.getProperties()));
                        obj.set("type", om.valueToTree(this.getType()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.EventSourceProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.EventSourceProperty.Properties`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-types
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.Object getProperties() {
                return this.jsiiGet("properties", java.lang.Object.class);
            }

            /**
             * `CfnFunction.EventSourceProperty.Type`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-object
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#environment-object
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface FunctionEnvironmentProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.FunctionEnvironmentProperty.Variables`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#environment-object
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getVariables();

        /**
         * @return a {@link Builder} of {@link FunctionEnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link FunctionEnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object _variables;

            /**
             * Sets the value of Variables
             * @param value `CfnFunction.FunctionEnvironmentProperty.Variables`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withVariables(final software.amazon.awscdk.core.IResolvable value) {
                this._variables = java.util.Objects.requireNonNull(value, "variables is required");
                return this;
            }
            /**
             * Sets the value of Variables
             * @param value `CfnFunction.FunctionEnvironmentProperty.Variables`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withVariables(final java.util.Map<java.lang.String, java.lang.String> value) {
                this._variables = java.util.Objects.requireNonNull(value, "variables is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FunctionEnvironmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public FunctionEnvironmentProperty build() {
                return new FunctionEnvironmentProperty() {
                    private final java.lang.Object $variables = java.util.Objects.requireNonNull(_variables, "variables is required");

                    @Override
                    public java.lang.Object getVariables() {
                        return this.$variables;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("variables", om.valueToTree(this.getVariables()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.FunctionEnvironmentProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.FunctionEnvironmentProperty.Variables`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#environment-object
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.Object getVariables() {
                return this.jsiiGet("variables", java.lang.Object.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface FunctionSAMPTProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.FunctionSAMPTProperty.FunctionName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getFunctionName();

        /**
         * @return a {@link Builder} of {@link FunctionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link FunctionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _functionName;

            /**
             * Sets the value of FunctionName
             * @param value `CfnFunction.FunctionSAMPTProperty.FunctionName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withFunctionName(final java.lang.String value) {
                this._functionName = java.util.Objects.requireNonNull(value, "functionName is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FunctionSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public FunctionSAMPTProperty build() {
                return new FunctionSAMPTProperty() {
                    private final java.lang.String $functionName = java.util.Objects.requireNonNull(_functionName, "functionName is required");

                    @Override
                    public java.lang.String getFunctionName() {
                        return this.$functionName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("functionName", om.valueToTree(this.getFunctionName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.FunctionSAMPTProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.FunctionSAMPTProperty.FunctionName`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getFunctionName() {
                return this.jsiiGet("functionName", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface IAMPolicyDocumentProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.IAMPolicyDocumentProperty.Statement`.
         * 
         * @see http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getStatement();

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.IAMPolicyDocumentProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.IAMPolicyDocumentProperty.Statement`.
             * 
             * @see http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getStatement() {
                return this.jsiiGet("statement", java.lang.Object.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface IdentitySAMPTProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.IdentitySAMPTProperty.IdentityName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getIdentityName();

        /**
         * @return a {@link Builder} of {@link IdentitySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link IdentitySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _identityName;

            /**
             * Sets the value of IdentityName
             * @param value `CfnFunction.IdentitySAMPTProperty.IdentityName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withIdentityName(final java.lang.String value) {
                this._identityName = java.util.Objects.requireNonNull(value, "identityName is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdentitySAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public IdentitySAMPTProperty build() {
                return new IdentitySAMPTProperty() {
                    private final java.lang.String $identityName = java.util.Objects.requireNonNull(_identityName, "identityName is required");

                    @Override
                    public java.lang.String getIdentityName() {
                        return this.$identityName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("identityName", om.valueToTree(this.getIdentityName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.IdentitySAMPTProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.IdentitySAMPTProperty.IdentityName`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getIdentityName() {
                return this.jsiiGet("identityName", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#iotrule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface IoTRuleEventProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.IoTRuleEventProperty.Sql`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#iotrule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSql();
        /**
         * `CfnFunction.IoTRuleEventProperty.AwsIotSqlVersion`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#iotrule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getAwsIotSqlVersion();

        /**
         * @return a {@link Builder} of {@link IoTRuleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link IoTRuleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _sql;
            @javax.annotation.Nullable
            private java.lang.String _awsIotSqlVersion;

            /**
             * Sets the value of Sql
             * @param value `CfnFunction.IoTRuleEventProperty.Sql`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSql(final java.lang.String value) {
                this._sql = java.util.Objects.requireNonNull(value, "sql is required");
                return this;
            }
            /**
             * Sets the value of AwsIotSqlVersion
             * @param value `CfnFunction.IoTRuleEventProperty.AwsIotSqlVersion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withAwsIotSqlVersion(@javax.annotation.Nullable final java.lang.String value) {
                this._awsIotSqlVersion = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IoTRuleEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public IoTRuleEventProperty build() {
                return new IoTRuleEventProperty() {
                    private final java.lang.String $sql = java.util.Objects.requireNonNull(_sql, "sql is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $awsIotSqlVersion = _awsIotSqlVersion;

                    @Override
                    public java.lang.String getSql() {
                        return this.$sql;
                    }

                    @Override
                    public java.lang.String getAwsIotSqlVersion() {
                        return this.$awsIotSqlVersion;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("sql", om.valueToTree(this.getSql()));
                        if (this.getAwsIotSqlVersion() != null) {
                            obj.set("awsIotSqlVersion", om.valueToTree(this.getAwsIotSqlVersion()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.IoTRuleEventProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.IoTRuleEventProperty.Sql`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#iotrule
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getSql() {
                return this.jsiiGet("sql", java.lang.String.class);
            }

            /**
             * `CfnFunction.IoTRuleEventProperty.AwsIotSqlVersion`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#iotrule
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getAwsIotSqlVersion() {
                return this.jsiiGet("awsIotSqlVersion", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface KeySAMPTProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.KeySAMPTProperty.KeyId`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKeyId();

        /**
         * @return a {@link Builder} of {@link KeySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link KeySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _keyId;

            /**
             * Sets the value of KeyId
             * @param value `CfnFunction.KeySAMPTProperty.KeyId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withKeyId(final java.lang.String value) {
                this._keyId = java.util.Objects.requireNonNull(value, "keyId is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeySAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public KeySAMPTProperty build() {
                return new KeySAMPTProperty() {
                    private final java.lang.String $keyId = java.util.Objects.requireNonNull(_keyId, "keyId is required");

                    @Override
                    public java.lang.String getKeyId() {
                        return this.$keyId;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("keyId", om.valueToTree(this.getKeyId()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.KeySAMPTProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.KeySAMPTProperty.KeyId`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getKeyId() {
                return this.jsiiGet("keyId", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface KinesisEventProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.KinesisEventProperty.StartingPosition`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStartingPosition();
        /**
         * `CfnFunction.KinesisEventProperty.Stream`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStream();
        /**
         * `CfnFunction.KinesisEventProperty.BatchSize`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getBatchSize();
        /**
         * `CfnFunction.KinesisEventProperty.Enabled`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link KinesisEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link KinesisEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _startingPosition;
            private java.lang.String _stream;
            @javax.annotation.Nullable
            private java.lang.Number _batchSize;
            @javax.annotation.Nullable
            private java.lang.Object _enabled;

            /**
             * Sets the value of StartingPosition
             * @param value `CfnFunction.KinesisEventProperty.StartingPosition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withStartingPosition(final java.lang.String value) {
                this._startingPosition = java.util.Objects.requireNonNull(value, "startingPosition is required");
                return this;
            }
            /**
             * Sets the value of Stream
             * @param value `CfnFunction.KinesisEventProperty.Stream`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withStream(final java.lang.String value) {
                this._stream = java.util.Objects.requireNonNull(value, "stream is required");
                return this;
            }
            /**
             * Sets the value of BatchSize
             * @param value `CfnFunction.KinesisEventProperty.BatchSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withBatchSize(@javax.annotation.Nullable final java.lang.Number value) {
                this._batchSize = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnFunction.KinesisEventProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnFunction.KinesisEventProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEnabled(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._enabled = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public KinesisEventProperty build() {
                return new KinesisEventProperty() {
                    private final java.lang.String $startingPosition = java.util.Objects.requireNonNull(_startingPosition, "startingPosition is required");
                    private final java.lang.String $stream = java.util.Objects.requireNonNull(_stream, "stream is required");
                    @javax.annotation.Nullable
                    private final java.lang.Number $batchSize = _batchSize;
                    @javax.annotation.Nullable
                    private final java.lang.Object $enabled = _enabled;

                    @Override
                    public java.lang.String getStartingPosition() {
                        return this.$startingPosition;
                    }

                    @Override
                    public java.lang.String getStream() {
                        return this.$stream;
                    }

                    @Override
                    public java.lang.Number getBatchSize() {
                        return this.$batchSize;
                    }

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("startingPosition", om.valueToTree(this.getStartingPosition()));
                        obj.set("stream", om.valueToTree(this.getStream()));
                        if (this.getBatchSize() != null) {
                            obj.set("batchSize", om.valueToTree(this.getBatchSize()));
                        }
                        if (this.getEnabled() != null) {
                            obj.set("enabled", om.valueToTree(this.getEnabled()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.KinesisEventProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.KinesisEventProperty.StartingPosition`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getStartingPosition() {
                return this.jsiiGet("startingPosition", java.lang.String.class);
            }

            /**
             * `CfnFunction.KinesisEventProperty.Stream`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getStream() {
                return this.jsiiGet("stream", java.lang.String.class);
            }

            /**
             * `CfnFunction.KinesisEventProperty.BatchSize`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Number getBatchSize() {
                return this.jsiiGet("batchSize", java.lang.Number.class);
            }

            /**
             * `CfnFunction.KinesisEventProperty.Enabled`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface LogGroupSAMPTProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.LogGroupSAMPTProperty.LogGroupName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getLogGroupName();

        /**
         * @return a {@link Builder} of {@link LogGroupSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LogGroupSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _logGroupName;

            /**
             * Sets the value of LogGroupName
             * @param value `CfnFunction.LogGroupSAMPTProperty.LogGroupName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withLogGroupName(final java.lang.String value) {
                this._logGroupName = java.util.Objects.requireNonNull(value, "logGroupName is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogGroupSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public LogGroupSAMPTProperty build() {
                return new LogGroupSAMPTProperty() {
                    private final java.lang.String $logGroupName = java.util.Objects.requireNonNull(_logGroupName, "logGroupName is required");

                    @Override
                    public java.lang.String getLogGroupName() {
                        return this.$logGroupName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("logGroupName", om.valueToTree(this.getLogGroupName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.LogGroupSAMPTProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.LogGroupSAMPTProperty.LogGroupName`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getLogGroupName() {
                return this.jsiiGet("logGroupName", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface QueueSAMPTProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.QueueSAMPTProperty.QueueName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getQueueName();

        /**
         * @return a {@link Builder} of {@link QueueSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link QueueSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _queueName;

            /**
             * Sets the value of QueueName
             * @param value `CfnFunction.QueueSAMPTProperty.QueueName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withQueueName(final java.lang.String value) {
                this._queueName = java.util.Objects.requireNonNull(value, "queueName is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueueSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public QueueSAMPTProperty build() {
                return new QueueSAMPTProperty() {
                    private final java.lang.String $queueName = java.util.Objects.requireNonNull(_queueName, "queueName is required");

                    @Override
                    public java.lang.String getQueueName() {
                        return this.$queueName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("queueName", om.valueToTree(this.getQueueName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.QueueSAMPTProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.QueueSAMPTProperty.QueueName`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getQueueName() {
                return this.jsiiGet("queueName", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface S3EventProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.S3EventProperty.Bucket`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getBucket();
        /**
         * `CfnFunction.S3EventProperty.Events`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEvents();
        /**
         * `CfnFunction.S3EventProperty.Filter`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getFilter();

        /**
         * @return a {@link Builder} of {@link S3EventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link S3EventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _bucket;
            private java.lang.Object _events;
            @javax.annotation.Nullable
            private java.lang.Object _filter;

            /**
             * Sets the value of Bucket
             * @param value `CfnFunction.S3EventProperty.Bucket`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withBucket(final java.lang.String value) {
                this._bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                return this;
            }
            /**
             * Sets the value of Events
             * @param value `CfnFunction.S3EventProperty.Events`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEvents(final java.lang.String value) {
                this._events = java.util.Objects.requireNonNull(value, "events is required");
                return this;
            }
            /**
             * Sets the value of Events
             * @param value `CfnFunction.S3EventProperty.Events`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEvents(final software.amazon.awscdk.core.IResolvable value) {
                this._events = java.util.Objects.requireNonNull(value, "events is required");
                return this;
            }
            /**
             * Sets the value of Events
             * @param value `CfnFunction.S3EventProperty.Events`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEvents(final java.util.List<java.lang.String> value) {
                this._events = java.util.Objects.requireNonNull(value, "events is required");
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value `CfnFunction.S3EventProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._filter = value;
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value `CfnFunction.S3EventProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.S3NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3EventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public S3EventProperty build() {
                return new S3EventProperty() {
                    private final java.lang.String $bucket = java.util.Objects.requireNonNull(_bucket, "bucket is required");
                    private final java.lang.Object $events = java.util.Objects.requireNonNull(_events, "events is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $filter = _filter;

                    @Override
                    public java.lang.String getBucket() {
                        return this.$bucket;
                    }

                    @Override
                    public java.lang.Object getEvents() {
                        return this.$events;
                    }

                    @Override
                    public java.lang.Object getFilter() {
                        return this.$filter;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("bucket", om.valueToTree(this.getBucket()));
                        obj.set("events", om.valueToTree(this.getEvents()));
                        if (this.getFilter() != null) {
                            obj.set("filter", om.valueToTree(this.getFilter()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.S3EventProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.S3EventProperty.Bucket`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getBucket() {
                return this.jsiiGet("bucket", java.lang.String.class);
            }

            /**
             * `CfnFunction.S3EventProperty.Events`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.Object getEvents() {
                return this.jsiiGet("events", java.lang.Object.class);
            }

            /**
             * `CfnFunction.S3EventProperty.Filter`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getFilter() {
                return this.jsiiGet("filter", java.lang.Object.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3-location-object
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.S3LocationProperty.Bucket`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getBucket();
        /**
         * `CfnFunction.S3LocationProperty.Key`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKey();
        /**
         * `CfnFunction.S3LocationProperty.Version`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getVersion();

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _bucket;
            private java.lang.String _key;
            @javax.annotation.Nullable
            private java.lang.Number _version;

            /**
             * Sets the value of Bucket
             * @param value `CfnFunction.S3LocationProperty.Bucket`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withBucket(final java.lang.String value) {
                this._bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                return this;
            }
            /**
             * Sets the value of Key
             * @param value `CfnFunction.S3LocationProperty.Key`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withKey(final java.lang.String value) {
                this._key = java.util.Objects.requireNonNull(value, "key is required");
                return this;
            }
            /**
             * Sets the value of Version
             * @param value `CfnFunction.S3LocationProperty.Version`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withVersion(@javax.annotation.Nullable final java.lang.Number value) {
                this._version = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public S3LocationProperty build() {
                return new S3LocationProperty() {
                    private final java.lang.String $bucket = java.util.Objects.requireNonNull(_bucket, "bucket is required");
                    private final java.lang.String $key = java.util.Objects.requireNonNull(_key, "key is required");
                    @javax.annotation.Nullable
                    private final java.lang.Number $version = _version;

                    @Override
                    public java.lang.String getBucket() {
                        return this.$bucket;
                    }

                    @Override
                    public java.lang.String getKey() {
                        return this.$key;
                    }

                    @Override
                    public java.lang.Number getVersion() {
                        return this.$version;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("bucket", om.valueToTree(this.getBucket()));
                        obj.set("key", om.valueToTree(this.getKey()));
                        if (this.getVersion() != null) {
                            obj.set("version", om.valueToTree(this.getVersion()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.S3LocationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.S3LocationProperty.Bucket`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getBucket() {
                return this.jsiiGet("bucket", java.lang.String.class);
            }

            /**
             * `CfnFunction.S3LocationProperty.Key`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getKey() {
                return this.jsiiGet("key", java.lang.String.class);
            }

            /**
             * `CfnFunction.S3LocationProperty.Version`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Number getVersion() {
                return this.jsiiGet("version", java.lang.Number.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface S3NotificationFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.S3NotificationFilterProperty.S3Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getS3Key();

        /**
         * @return a {@link Builder} of {@link S3NotificationFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link S3NotificationFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _s3Key;

            /**
             * Sets the value of S3Key
             * @param value `CfnFunction.S3NotificationFilterProperty.S3Key`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withS3Key(final java.lang.String value) {
                this._s3Key = java.util.Objects.requireNonNull(value, "s3Key is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3NotificationFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public S3NotificationFilterProperty build() {
                return new S3NotificationFilterProperty() {
                    private final java.lang.String $s3Key = java.util.Objects.requireNonNull(_s3Key, "s3Key is required");

                    @Override
                    public java.lang.String getS3Key() {
                        return this.$s3Key;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("s3Key", om.valueToTree(this.getS3Key()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.S3NotificationFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.S3NotificationFilterProperty.S3Key`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getS3Key() {
                return this.jsiiGet("s3Key", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface SAMPolicyTemplateProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.AMIDescribePolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getAmiDescribePolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.CloudFormationDescribeStacksPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getCloudFormationDescribeStacksPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.CloudWatchPutMetricPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getCloudWatchPutMetricPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.DynamoDBCrudPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getDynamoDbCrudPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.DynamoDBReadPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getDynamoDbReadPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.DynamoDBStreamReadPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getDynamoDbStreamReadPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.EC2DescribePolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEc2DescribePolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.ElasticsearchHttpPostPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getElasticsearchHttpPostPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.FilterLogEventsPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getFilterLogEventsPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.KinesisCrudPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getKinesisCrudPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.KinesisStreamReadPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getKinesisStreamReadPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.KMSDecryptPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getKmsDecryptPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.LambdaInvokePolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getLambdaInvokePolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionDetectOnlyPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRekognitionDetectOnlyPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionLabelsPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRekognitionLabelsPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionNoDataAccessPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRekognitionNoDataAccessPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionReadPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRekognitionReadPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionWriteOnlyAccessPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRekognitionWriteOnlyAccessPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.S3CrudPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getS3CrudPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.S3ReadPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getS3ReadPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESBulkTemplatedCrudPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSesBulkTemplatedCrudPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESCrudPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSesCrudPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESEmailTemplateCrudPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSesEmailTemplateCrudPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESSendBouncePolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSesSendBouncePolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SNSCrudPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSnsCrudPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SNSPublishMessagePolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSnsPublishMessagePolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SQSPollerPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSqsPollerPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SQSSendMessagePolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSqsSendMessagePolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.StepFunctionsExecutionPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getStepFunctionsExecutionPolicy();
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.VPCAccessPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getVpcAccessPolicy();

        /**
         * @return a {@link Builder} of {@link SAMPolicyTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SAMPolicyTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _amiDescribePolicy;
            @javax.annotation.Nullable
            private java.lang.Object _cloudFormationDescribeStacksPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _cloudWatchPutMetricPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _dynamoDbCrudPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _dynamoDbReadPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _dynamoDbStreamReadPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _ec2DescribePolicy;
            @javax.annotation.Nullable
            private java.lang.Object _elasticsearchHttpPostPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _filterLogEventsPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _kinesisCrudPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _kinesisStreamReadPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _kmsDecryptPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _lambdaInvokePolicy;
            @javax.annotation.Nullable
            private java.lang.Object _rekognitionDetectOnlyPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _rekognitionLabelsPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _rekognitionNoDataAccessPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _rekognitionReadPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _rekognitionWriteOnlyAccessPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _s3CrudPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _s3ReadPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _sesBulkTemplatedCrudPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _sesCrudPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _sesEmailTemplateCrudPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _sesSendBouncePolicy;
            @javax.annotation.Nullable
            private java.lang.Object _snsCrudPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _snsPublishMessagePolicy;
            @javax.annotation.Nullable
            private java.lang.Object _sqsPollerPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _sqsSendMessagePolicy;
            @javax.annotation.Nullable
            private java.lang.Object _stepFunctionsExecutionPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _vpcAccessPolicy;

            /**
             * Sets the value of AmiDescribePolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.AMIDescribePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withAmiDescribePolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._amiDescribePolicy = value;
                return this;
            }
            /**
             * Sets the value of AmiDescribePolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.AMIDescribePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withAmiDescribePolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty value) {
                this._amiDescribePolicy = value;
                return this;
            }
            /**
             * Sets the value of CloudFormationDescribeStacksPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.CloudFormationDescribeStacksPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCloudFormationDescribeStacksPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._cloudFormationDescribeStacksPolicy = value;
                return this;
            }
            /**
             * Sets the value of CloudFormationDescribeStacksPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.CloudFormationDescribeStacksPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCloudFormationDescribeStacksPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty value) {
                this._cloudFormationDescribeStacksPolicy = value;
                return this;
            }
            /**
             * Sets the value of CloudWatchPutMetricPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.CloudWatchPutMetricPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCloudWatchPutMetricPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._cloudWatchPutMetricPolicy = value;
                return this;
            }
            /**
             * Sets the value of CloudWatchPutMetricPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.CloudWatchPutMetricPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCloudWatchPutMetricPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty value) {
                this._cloudWatchPutMetricPolicy = value;
                return this;
            }
            /**
             * Sets the value of DynamoDbCrudPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.DynamoDBCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDynamoDbCrudPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._dynamoDbCrudPolicy = value;
                return this;
            }
            /**
             * Sets the value of DynamoDbCrudPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.DynamoDBCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDynamoDbCrudPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.TableSAMPTProperty value) {
                this._dynamoDbCrudPolicy = value;
                return this;
            }
            /**
             * Sets the value of DynamoDbReadPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.DynamoDBReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDynamoDbReadPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._dynamoDbReadPolicy = value;
                return this;
            }
            /**
             * Sets the value of DynamoDbReadPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.DynamoDBReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDynamoDbReadPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.TableSAMPTProperty value) {
                this._dynamoDbReadPolicy = value;
                return this;
            }
            /**
             * Sets the value of DynamoDbStreamReadPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.DynamoDBStreamReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDynamoDbStreamReadPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._dynamoDbStreamReadPolicy = value;
                return this;
            }
            /**
             * Sets the value of DynamoDbStreamReadPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.DynamoDBStreamReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDynamoDbStreamReadPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.TableStreamSAMPTProperty value) {
                this._dynamoDbStreamReadPolicy = value;
                return this;
            }
            /**
             * Sets the value of Ec2DescribePolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.EC2DescribePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEc2DescribePolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._ec2DescribePolicy = value;
                return this;
            }
            /**
             * Sets the value of Ec2DescribePolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.EC2DescribePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEc2DescribePolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty value) {
                this._ec2DescribePolicy = value;
                return this;
            }
            /**
             * Sets the value of ElasticsearchHttpPostPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.ElasticsearchHttpPostPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withElasticsearchHttpPostPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._elasticsearchHttpPostPolicy = value;
                return this;
            }
            /**
             * Sets the value of ElasticsearchHttpPostPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.ElasticsearchHttpPostPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withElasticsearchHttpPostPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.DomainSAMPTProperty value) {
                this._elasticsearchHttpPostPolicy = value;
                return this;
            }
            /**
             * Sets the value of FilterLogEventsPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.FilterLogEventsPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withFilterLogEventsPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._filterLogEventsPolicy = value;
                return this;
            }
            /**
             * Sets the value of FilterLogEventsPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.FilterLogEventsPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withFilterLogEventsPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.LogGroupSAMPTProperty value) {
                this._filterLogEventsPolicy = value;
                return this;
            }
            /**
             * Sets the value of KinesisCrudPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.KinesisCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withKinesisCrudPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._kinesisCrudPolicy = value;
                return this;
            }
            /**
             * Sets the value of KinesisCrudPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.KinesisCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withKinesisCrudPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.StreamSAMPTProperty value) {
                this._kinesisCrudPolicy = value;
                return this;
            }
            /**
             * Sets the value of KinesisStreamReadPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.KinesisStreamReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withKinesisStreamReadPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._kinesisStreamReadPolicy = value;
                return this;
            }
            /**
             * Sets the value of KinesisStreamReadPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.KinesisStreamReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withKinesisStreamReadPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.StreamSAMPTProperty value) {
                this._kinesisStreamReadPolicy = value;
                return this;
            }
            /**
             * Sets the value of KmsDecryptPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.KMSDecryptPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withKmsDecryptPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._kmsDecryptPolicy = value;
                return this;
            }
            /**
             * Sets the value of KmsDecryptPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.KMSDecryptPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withKmsDecryptPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.KeySAMPTProperty value) {
                this._kmsDecryptPolicy = value;
                return this;
            }
            /**
             * Sets the value of LambdaInvokePolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.LambdaInvokePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withLambdaInvokePolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._lambdaInvokePolicy = value;
                return this;
            }
            /**
             * Sets the value of LambdaInvokePolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.LambdaInvokePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withLambdaInvokePolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.FunctionSAMPTProperty value) {
                this._lambdaInvokePolicy = value;
                return this;
            }
            /**
             * Sets the value of RekognitionDetectOnlyPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.RekognitionDetectOnlyPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withRekognitionDetectOnlyPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._rekognitionDetectOnlyPolicy = value;
                return this;
            }
            /**
             * Sets the value of RekognitionDetectOnlyPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.RekognitionDetectOnlyPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withRekognitionDetectOnlyPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty value) {
                this._rekognitionDetectOnlyPolicy = value;
                return this;
            }
            /**
             * Sets the value of RekognitionLabelsPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.RekognitionLabelsPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withRekognitionLabelsPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._rekognitionLabelsPolicy = value;
                return this;
            }
            /**
             * Sets the value of RekognitionLabelsPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.RekognitionLabelsPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withRekognitionLabelsPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty value) {
                this._rekognitionLabelsPolicy = value;
                return this;
            }
            /**
             * Sets the value of RekognitionNoDataAccessPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.RekognitionNoDataAccessPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withRekognitionNoDataAccessPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._rekognitionNoDataAccessPolicy = value;
                return this;
            }
            /**
             * Sets the value of RekognitionNoDataAccessPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.RekognitionNoDataAccessPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withRekognitionNoDataAccessPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.CollectionSAMPTProperty value) {
                this._rekognitionNoDataAccessPolicy = value;
                return this;
            }
            /**
             * Sets the value of RekognitionReadPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.RekognitionReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withRekognitionReadPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._rekognitionReadPolicy = value;
                return this;
            }
            /**
             * Sets the value of RekognitionReadPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.RekognitionReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withRekognitionReadPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.CollectionSAMPTProperty value) {
                this._rekognitionReadPolicy = value;
                return this;
            }
            /**
             * Sets the value of RekognitionWriteOnlyAccessPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.RekognitionWriteOnlyAccessPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withRekognitionWriteOnlyAccessPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._rekognitionWriteOnlyAccessPolicy = value;
                return this;
            }
            /**
             * Sets the value of RekognitionWriteOnlyAccessPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.RekognitionWriteOnlyAccessPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withRekognitionWriteOnlyAccessPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.CollectionSAMPTProperty value) {
                this._rekognitionWriteOnlyAccessPolicy = value;
                return this;
            }
            /**
             * Sets the value of S3CrudPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.S3CrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withS3CrudPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._s3CrudPolicy = value;
                return this;
            }
            /**
             * Sets the value of S3CrudPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.S3CrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withS3CrudPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.BucketSAMPTProperty value) {
                this._s3CrudPolicy = value;
                return this;
            }
            /**
             * Sets the value of S3ReadPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.S3ReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withS3ReadPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._s3ReadPolicy = value;
                return this;
            }
            /**
             * Sets the value of S3ReadPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.S3ReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withS3ReadPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.BucketSAMPTProperty value) {
                this._s3ReadPolicy = value;
                return this;
            }
            /**
             * Sets the value of SesBulkTemplatedCrudPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.SESBulkTemplatedCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSesBulkTemplatedCrudPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._sesBulkTemplatedCrudPolicy = value;
                return this;
            }
            /**
             * Sets the value of SesBulkTemplatedCrudPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.SESBulkTemplatedCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSesBulkTemplatedCrudPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.IdentitySAMPTProperty value) {
                this._sesBulkTemplatedCrudPolicy = value;
                return this;
            }
            /**
             * Sets the value of SesCrudPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.SESCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSesCrudPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._sesCrudPolicy = value;
                return this;
            }
            /**
             * Sets the value of SesCrudPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.SESCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSesCrudPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.IdentitySAMPTProperty value) {
                this._sesCrudPolicy = value;
                return this;
            }
            /**
             * Sets the value of SesEmailTemplateCrudPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.SESEmailTemplateCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSesEmailTemplateCrudPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._sesEmailTemplateCrudPolicy = value;
                return this;
            }
            /**
             * Sets the value of SesEmailTemplateCrudPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.SESEmailTemplateCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSesEmailTemplateCrudPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty value) {
                this._sesEmailTemplateCrudPolicy = value;
                return this;
            }
            /**
             * Sets the value of SesSendBouncePolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.SESSendBouncePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSesSendBouncePolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._sesSendBouncePolicy = value;
                return this;
            }
            /**
             * Sets the value of SesSendBouncePolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.SESSendBouncePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSesSendBouncePolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.IdentitySAMPTProperty value) {
                this._sesSendBouncePolicy = value;
                return this;
            }
            /**
             * Sets the value of SnsCrudPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.SNSCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSnsCrudPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._snsCrudPolicy = value;
                return this;
            }
            /**
             * Sets the value of SnsCrudPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.SNSCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSnsCrudPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.TopicSAMPTProperty value) {
                this._snsCrudPolicy = value;
                return this;
            }
            /**
             * Sets the value of SnsPublishMessagePolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.SNSPublishMessagePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSnsPublishMessagePolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._snsPublishMessagePolicy = value;
                return this;
            }
            /**
             * Sets the value of SnsPublishMessagePolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.SNSPublishMessagePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSnsPublishMessagePolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.TopicSAMPTProperty value) {
                this._snsPublishMessagePolicy = value;
                return this;
            }
            /**
             * Sets the value of SqsPollerPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.SQSPollerPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSqsPollerPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._sqsPollerPolicy = value;
                return this;
            }
            /**
             * Sets the value of SqsPollerPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.SQSPollerPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSqsPollerPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.QueueSAMPTProperty value) {
                this._sqsPollerPolicy = value;
                return this;
            }
            /**
             * Sets the value of SqsSendMessagePolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.SQSSendMessagePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSqsSendMessagePolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._sqsSendMessagePolicy = value;
                return this;
            }
            /**
             * Sets the value of SqsSendMessagePolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.SQSSendMessagePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSqsSendMessagePolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.QueueSAMPTProperty value) {
                this._sqsSendMessagePolicy = value;
                return this;
            }
            /**
             * Sets the value of StepFunctionsExecutionPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.StepFunctionsExecutionPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withStepFunctionsExecutionPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._stepFunctionsExecutionPolicy = value;
                return this;
            }
            /**
             * Sets the value of StepFunctionsExecutionPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.StepFunctionsExecutionPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withStepFunctionsExecutionPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.StateMachineSAMPTProperty value) {
                this._stepFunctionsExecutionPolicy = value;
                return this;
            }
            /**
             * Sets the value of VpcAccessPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.VPCAccessPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withVpcAccessPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._vpcAccessPolicy = value;
                return this;
            }
            /**
             * Sets the value of VpcAccessPolicy
             * @param value `CfnFunction.SAMPolicyTemplateProperty.VPCAccessPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withVpcAccessPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty value) {
                this._vpcAccessPolicy = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SAMPolicyTemplateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public SAMPolicyTemplateProperty build() {
                return new SAMPolicyTemplateProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $amiDescribePolicy = _amiDescribePolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $cloudFormationDescribeStacksPolicy = _cloudFormationDescribeStacksPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $cloudWatchPutMetricPolicy = _cloudWatchPutMetricPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $dynamoDbCrudPolicy = _dynamoDbCrudPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $dynamoDbReadPolicy = _dynamoDbReadPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $dynamoDbStreamReadPolicy = _dynamoDbStreamReadPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $ec2DescribePolicy = _ec2DescribePolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $elasticsearchHttpPostPolicy = _elasticsearchHttpPostPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $filterLogEventsPolicy = _filterLogEventsPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $kinesisCrudPolicy = _kinesisCrudPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $kinesisStreamReadPolicy = _kinesisStreamReadPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $kmsDecryptPolicy = _kmsDecryptPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $lambdaInvokePolicy = _lambdaInvokePolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $rekognitionDetectOnlyPolicy = _rekognitionDetectOnlyPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $rekognitionLabelsPolicy = _rekognitionLabelsPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $rekognitionNoDataAccessPolicy = _rekognitionNoDataAccessPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $rekognitionReadPolicy = _rekognitionReadPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $rekognitionWriteOnlyAccessPolicy = _rekognitionWriteOnlyAccessPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $s3CrudPolicy = _s3CrudPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $s3ReadPolicy = _s3ReadPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $sesBulkTemplatedCrudPolicy = _sesBulkTemplatedCrudPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $sesCrudPolicy = _sesCrudPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $sesEmailTemplateCrudPolicy = _sesEmailTemplateCrudPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $sesSendBouncePolicy = _sesSendBouncePolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $snsCrudPolicy = _snsCrudPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $snsPublishMessagePolicy = _snsPublishMessagePolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $sqsPollerPolicy = _sqsPollerPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $sqsSendMessagePolicy = _sqsSendMessagePolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $stepFunctionsExecutionPolicy = _stepFunctionsExecutionPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $vpcAccessPolicy = _vpcAccessPolicy;

                    @Override
                    public java.lang.Object getAmiDescribePolicy() {
                        return this.$amiDescribePolicy;
                    }

                    @Override
                    public java.lang.Object getCloudFormationDescribeStacksPolicy() {
                        return this.$cloudFormationDescribeStacksPolicy;
                    }

                    @Override
                    public java.lang.Object getCloudWatchPutMetricPolicy() {
                        return this.$cloudWatchPutMetricPolicy;
                    }

                    @Override
                    public java.lang.Object getDynamoDbCrudPolicy() {
                        return this.$dynamoDbCrudPolicy;
                    }

                    @Override
                    public java.lang.Object getDynamoDbReadPolicy() {
                        return this.$dynamoDbReadPolicy;
                    }

                    @Override
                    public java.lang.Object getDynamoDbStreamReadPolicy() {
                        return this.$dynamoDbStreamReadPolicy;
                    }

                    @Override
                    public java.lang.Object getEc2DescribePolicy() {
                        return this.$ec2DescribePolicy;
                    }

                    @Override
                    public java.lang.Object getElasticsearchHttpPostPolicy() {
                        return this.$elasticsearchHttpPostPolicy;
                    }

                    @Override
                    public java.lang.Object getFilterLogEventsPolicy() {
                        return this.$filterLogEventsPolicy;
                    }

                    @Override
                    public java.lang.Object getKinesisCrudPolicy() {
                        return this.$kinesisCrudPolicy;
                    }

                    @Override
                    public java.lang.Object getKinesisStreamReadPolicy() {
                        return this.$kinesisStreamReadPolicy;
                    }

                    @Override
                    public java.lang.Object getKmsDecryptPolicy() {
                        return this.$kmsDecryptPolicy;
                    }

                    @Override
                    public java.lang.Object getLambdaInvokePolicy() {
                        return this.$lambdaInvokePolicy;
                    }

                    @Override
                    public java.lang.Object getRekognitionDetectOnlyPolicy() {
                        return this.$rekognitionDetectOnlyPolicy;
                    }

                    @Override
                    public java.lang.Object getRekognitionLabelsPolicy() {
                        return this.$rekognitionLabelsPolicy;
                    }

                    @Override
                    public java.lang.Object getRekognitionNoDataAccessPolicy() {
                        return this.$rekognitionNoDataAccessPolicy;
                    }

                    @Override
                    public java.lang.Object getRekognitionReadPolicy() {
                        return this.$rekognitionReadPolicy;
                    }

                    @Override
                    public java.lang.Object getRekognitionWriteOnlyAccessPolicy() {
                        return this.$rekognitionWriteOnlyAccessPolicy;
                    }

                    @Override
                    public java.lang.Object getS3CrudPolicy() {
                        return this.$s3CrudPolicy;
                    }

                    @Override
                    public java.lang.Object getS3ReadPolicy() {
                        return this.$s3ReadPolicy;
                    }

                    @Override
                    public java.lang.Object getSesBulkTemplatedCrudPolicy() {
                        return this.$sesBulkTemplatedCrudPolicy;
                    }

                    @Override
                    public java.lang.Object getSesCrudPolicy() {
                        return this.$sesCrudPolicy;
                    }

                    @Override
                    public java.lang.Object getSesEmailTemplateCrudPolicy() {
                        return this.$sesEmailTemplateCrudPolicy;
                    }

                    @Override
                    public java.lang.Object getSesSendBouncePolicy() {
                        return this.$sesSendBouncePolicy;
                    }

                    @Override
                    public java.lang.Object getSnsCrudPolicy() {
                        return this.$snsCrudPolicy;
                    }

                    @Override
                    public java.lang.Object getSnsPublishMessagePolicy() {
                        return this.$snsPublishMessagePolicy;
                    }

                    @Override
                    public java.lang.Object getSqsPollerPolicy() {
                        return this.$sqsPollerPolicy;
                    }

                    @Override
                    public java.lang.Object getSqsSendMessagePolicy() {
                        return this.$sqsSendMessagePolicy;
                    }

                    @Override
                    public java.lang.Object getStepFunctionsExecutionPolicy() {
                        return this.$stepFunctionsExecutionPolicy;
                    }

                    @Override
                    public java.lang.Object getVpcAccessPolicy() {
                        return this.$vpcAccessPolicy;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getAmiDescribePolicy() != null) {
                            obj.set("amiDescribePolicy", om.valueToTree(this.getAmiDescribePolicy()));
                        }
                        if (this.getCloudFormationDescribeStacksPolicy() != null) {
                            obj.set("cloudFormationDescribeStacksPolicy", om.valueToTree(this.getCloudFormationDescribeStacksPolicy()));
                        }
                        if (this.getCloudWatchPutMetricPolicy() != null) {
                            obj.set("cloudWatchPutMetricPolicy", om.valueToTree(this.getCloudWatchPutMetricPolicy()));
                        }
                        if (this.getDynamoDbCrudPolicy() != null) {
                            obj.set("dynamoDbCrudPolicy", om.valueToTree(this.getDynamoDbCrudPolicy()));
                        }
                        if (this.getDynamoDbReadPolicy() != null) {
                            obj.set("dynamoDbReadPolicy", om.valueToTree(this.getDynamoDbReadPolicy()));
                        }
                        if (this.getDynamoDbStreamReadPolicy() != null) {
                            obj.set("dynamoDbStreamReadPolicy", om.valueToTree(this.getDynamoDbStreamReadPolicy()));
                        }
                        if (this.getEc2DescribePolicy() != null) {
                            obj.set("ec2DescribePolicy", om.valueToTree(this.getEc2DescribePolicy()));
                        }
                        if (this.getElasticsearchHttpPostPolicy() != null) {
                            obj.set("elasticsearchHttpPostPolicy", om.valueToTree(this.getElasticsearchHttpPostPolicy()));
                        }
                        if (this.getFilterLogEventsPolicy() != null) {
                            obj.set("filterLogEventsPolicy", om.valueToTree(this.getFilterLogEventsPolicy()));
                        }
                        if (this.getKinesisCrudPolicy() != null) {
                            obj.set("kinesisCrudPolicy", om.valueToTree(this.getKinesisCrudPolicy()));
                        }
                        if (this.getKinesisStreamReadPolicy() != null) {
                            obj.set("kinesisStreamReadPolicy", om.valueToTree(this.getKinesisStreamReadPolicy()));
                        }
                        if (this.getKmsDecryptPolicy() != null) {
                            obj.set("kmsDecryptPolicy", om.valueToTree(this.getKmsDecryptPolicy()));
                        }
                        if (this.getLambdaInvokePolicy() != null) {
                            obj.set("lambdaInvokePolicy", om.valueToTree(this.getLambdaInvokePolicy()));
                        }
                        if (this.getRekognitionDetectOnlyPolicy() != null) {
                            obj.set("rekognitionDetectOnlyPolicy", om.valueToTree(this.getRekognitionDetectOnlyPolicy()));
                        }
                        if (this.getRekognitionLabelsPolicy() != null) {
                            obj.set("rekognitionLabelsPolicy", om.valueToTree(this.getRekognitionLabelsPolicy()));
                        }
                        if (this.getRekognitionNoDataAccessPolicy() != null) {
                            obj.set("rekognitionNoDataAccessPolicy", om.valueToTree(this.getRekognitionNoDataAccessPolicy()));
                        }
                        if (this.getRekognitionReadPolicy() != null) {
                            obj.set("rekognitionReadPolicy", om.valueToTree(this.getRekognitionReadPolicy()));
                        }
                        if (this.getRekognitionWriteOnlyAccessPolicy() != null) {
                            obj.set("rekognitionWriteOnlyAccessPolicy", om.valueToTree(this.getRekognitionWriteOnlyAccessPolicy()));
                        }
                        if (this.getS3CrudPolicy() != null) {
                            obj.set("s3CrudPolicy", om.valueToTree(this.getS3CrudPolicy()));
                        }
                        if (this.getS3ReadPolicy() != null) {
                            obj.set("s3ReadPolicy", om.valueToTree(this.getS3ReadPolicy()));
                        }
                        if (this.getSesBulkTemplatedCrudPolicy() != null) {
                            obj.set("sesBulkTemplatedCrudPolicy", om.valueToTree(this.getSesBulkTemplatedCrudPolicy()));
                        }
                        if (this.getSesCrudPolicy() != null) {
                            obj.set("sesCrudPolicy", om.valueToTree(this.getSesCrudPolicy()));
                        }
                        if (this.getSesEmailTemplateCrudPolicy() != null) {
                            obj.set("sesEmailTemplateCrudPolicy", om.valueToTree(this.getSesEmailTemplateCrudPolicy()));
                        }
                        if (this.getSesSendBouncePolicy() != null) {
                            obj.set("sesSendBouncePolicy", om.valueToTree(this.getSesSendBouncePolicy()));
                        }
                        if (this.getSnsCrudPolicy() != null) {
                            obj.set("snsCrudPolicy", om.valueToTree(this.getSnsCrudPolicy()));
                        }
                        if (this.getSnsPublishMessagePolicy() != null) {
                            obj.set("snsPublishMessagePolicy", om.valueToTree(this.getSnsPublishMessagePolicy()));
                        }
                        if (this.getSqsPollerPolicy() != null) {
                            obj.set("sqsPollerPolicy", om.valueToTree(this.getSqsPollerPolicy()));
                        }
                        if (this.getSqsSendMessagePolicy() != null) {
                            obj.set("sqsSendMessagePolicy", om.valueToTree(this.getSqsSendMessagePolicy()));
                        }
                        if (this.getStepFunctionsExecutionPolicy() != null) {
                            obj.set("stepFunctionsExecutionPolicy", om.valueToTree(this.getStepFunctionsExecutionPolicy()));
                        }
                        if (this.getVpcAccessPolicy() != null) {
                            obj.set("vpcAccessPolicy", om.valueToTree(this.getVpcAccessPolicy()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.SAMPolicyTemplateProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.AMIDescribePolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getAmiDescribePolicy() {
                return this.jsiiGet("amiDescribePolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.CloudFormationDescribeStacksPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getCloudFormationDescribeStacksPolicy() {
                return this.jsiiGet("cloudFormationDescribeStacksPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.CloudWatchPutMetricPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getCloudWatchPutMetricPolicy() {
                return this.jsiiGet("cloudWatchPutMetricPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.DynamoDBCrudPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getDynamoDbCrudPolicy() {
                return this.jsiiGet("dynamoDbCrudPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.DynamoDBReadPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getDynamoDbReadPolicy() {
                return this.jsiiGet("dynamoDbReadPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.DynamoDBStreamReadPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getDynamoDbStreamReadPolicy() {
                return this.jsiiGet("dynamoDbStreamReadPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.EC2DescribePolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getEc2DescribePolicy() {
                return this.jsiiGet("ec2DescribePolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.ElasticsearchHttpPostPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getElasticsearchHttpPostPolicy() {
                return this.jsiiGet("elasticsearchHttpPostPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.FilterLogEventsPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getFilterLogEventsPolicy() {
                return this.jsiiGet("filterLogEventsPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.KinesisCrudPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getKinesisCrudPolicy() {
                return this.jsiiGet("kinesisCrudPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.KinesisStreamReadPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getKinesisStreamReadPolicy() {
                return this.jsiiGet("kinesisStreamReadPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.KMSDecryptPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getKmsDecryptPolicy() {
                return this.jsiiGet("kmsDecryptPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.LambdaInvokePolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getLambdaInvokePolicy() {
                return this.jsiiGet("lambdaInvokePolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.RekognitionDetectOnlyPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getRekognitionDetectOnlyPolicy() {
                return this.jsiiGet("rekognitionDetectOnlyPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.RekognitionLabelsPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getRekognitionLabelsPolicy() {
                return this.jsiiGet("rekognitionLabelsPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.RekognitionNoDataAccessPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getRekognitionNoDataAccessPolicy() {
                return this.jsiiGet("rekognitionNoDataAccessPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.RekognitionReadPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getRekognitionReadPolicy() {
                return this.jsiiGet("rekognitionReadPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.RekognitionWriteOnlyAccessPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getRekognitionWriteOnlyAccessPolicy() {
                return this.jsiiGet("rekognitionWriteOnlyAccessPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.S3CrudPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getS3CrudPolicy() {
                return this.jsiiGet("s3CrudPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.S3ReadPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getS3ReadPolicy() {
                return this.jsiiGet("s3ReadPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.SESBulkTemplatedCrudPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getSesBulkTemplatedCrudPolicy() {
                return this.jsiiGet("sesBulkTemplatedCrudPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.SESCrudPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getSesCrudPolicy() {
                return this.jsiiGet("sesCrudPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.SESEmailTemplateCrudPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getSesEmailTemplateCrudPolicy() {
                return this.jsiiGet("sesEmailTemplateCrudPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.SESSendBouncePolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getSesSendBouncePolicy() {
                return this.jsiiGet("sesSendBouncePolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.SNSCrudPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getSnsCrudPolicy() {
                return this.jsiiGet("snsCrudPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.SNSPublishMessagePolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getSnsPublishMessagePolicy() {
                return this.jsiiGet("snsPublishMessagePolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.SQSPollerPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getSqsPollerPolicy() {
                return this.jsiiGet("sqsPollerPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.SQSSendMessagePolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getSqsSendMessagePolicy() {
                return this.jsiiGet("sqsSendMessagePolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.StepFunctionsExecutionPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getStepFunctionsExecutionPolicy() {
                return this.jsiiGet("stepFunctionsExecutionPolicy", java.lang.Object.class);
            }

            /**
             * `CfnFunction.SAMPolicyTemplateProperty.VPCAccessPolicy`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getVpcAccessPolicy() {
                return this.jsiiGet("vpcAccessPolicy", java.lang.Object.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sns
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface SNSEventProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.SNSEventProperty.Topic`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sns
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getTopic();

        /**
         * @return a {@link Builder} of {@link SNSEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SNSEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _topic;

            /**
             * Sets the value of Topic
             * @param value `CfnFunction.SNSEventProperty.Topic`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withTopic(final java.lang.String value) {
                this._topic = java.util.Objects.requireNonNull(value, "topic is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SNSEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public SNSEventProperty build() {
                return new SNSEventProperty() {
                    private final java.lang.String $topic = java.util.Objects.requireNonNull(_topic, "topic is required");

                    @Override
                    public java.lang.String getTopic() {
                        return this.$topic;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("topic", om.valueToTree(this.getTopic()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.SNSEventProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.SNSEventProperty.Topic`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sns
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getTopic() {
                return this.jsiiGet("topic", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface SQSEventProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.SQSEventProperty.Queue`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getQueue();
        /**
         * `CfnFunction.SQSEventProperty.BatchSize`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getBatchSize();
        /**
         * `CfnFunction.SQSEventProperty.Enabled`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link SQSEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SQSEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _queue;
            @javax.annotation.Nullable
            private java.lang.Number _batchSize;
            @javax.annotation.Nullable
            private java.lang.Object _enabled;

            /**
             * Sets the value of Queue
             * @param value `CfnFunction.SQSEventProperty.Queue`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withQueue(final java.lang.String value) {
                this._queue = java.util.Objects.requireNonNull(value, "queue is required");
                return this;
            }
            /**
             * Sets the value of BatchSize
             * @param value `CfnFunction.SQSEventProperty.BatchSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withBatchSize(@javax.annotation.Nullable final java.lang.Number value) {
                this._batchSize = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnFunction.SQSEventProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnFunction.SQSEventProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEnabled(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._enabled = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SQSEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public SQSEventProperty build() {
                return new SQSEventProperty() {
                    private final java.lang.String $queue = java.util.Objects.requireNonNull(_queue, "queue is required");
                    @javax.annotation.Nullable
                    private final java.lang.Number $batchSize = _batchSize;
                    @javax.annotation.Nullable
                    private final java.lang.Object $enabled = _enabled;

                    @Override
                    public java.lang.String getQueue() {
                        return this.$queue;
                    }

                    @Override
                    public java.lang.Number getBatchSize() {
                        return this.$batchSize;
                    }

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("queue", om.valueToTree(this.getQueue()));
                        if (this.getBatchSize() != null) {
                            obj.set("batchSize", om.valueToTree(this.getBatchSize()));
                        }
                        if (this.getEnabled() != null) {
                            obj.set("enabled", om.valueToTree(this.getEnabled()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.SQSEventProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.SQSEventProperty.Queue`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getQueue() {
                return this.jsiiGet("queue", java.lang.String.class);
            }

            /**
             * `CfnFunction.SQSEventProperty.BatchSize`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Number getBatchSize() {
                return this.jsiiGet("batchSize", java.lang.Number.class);
            }

            /**
             * `CfnFunction.SQSEventProperty.Enabled`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ScheduleEventProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.ScheduleEventProperty.Schedule`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSchedule();
        /**
         * `CfnFunction.ScheduleEventProperty.Input`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getInput();

        /**
         * @return a {@link Builder} of {@link ScheduleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ScheduleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _schedule;
            @javax.annotation.Nullable
            private java.lang.String _input;

            /**
             * Sets the value of Schedule
             * @param value `CfnFunction.ScheduleEventProperty.Schedule`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSchedule(final java.lang.String value) {
                this._schedule = java.util.Objects.requireNonNull(value, "schedule is required");
                return this;
            }
            /**
             * Sets the value of Input
             * @param value `CfnFunction.ScheduleEventProperty.Input`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withInput(@javax.annotation.Nullable final java.lang.String value) {
                this._input = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ScheduleEventProperty build() {
                return new ScheduleEventProperty() {
                    private final java.lang.String $schedule = java.util.Objects.requireNonNull(_schedule, "schedule is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $input = _input;

                    @Override
                    public java.lang.String getSchedule() {
                        return this.$schedule;
                    }

                    @Override
                    public java.lang.String getInput() {
                        return this.$input;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("schedule", om.valueToTree(this.getSchedule()));
                        if (this.getInput() != null) {
                            obj.set("input", om.valueToTree(this.getInput()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.ScheduleEventProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.ScheduleEventProperty.Schedule`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getSchedule() {
                return this.jsiiGet("schedule", java.lang.String.class);
            }

            /**
             * `CfnFunction.ScheduleEventProperty.Input`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getInput() {
                return this.jsiiGet("input", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface StateMachineSAMPTProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.StateMachineSAMPTProperty.StateMachineName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStateMachineName();

        /**
         * @return a {@link Builder} of {@link StateMachineSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link StateMachineSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _stateMachineName;

            /**
             * Sets the value of StateMachineName
             * @param value `CfnFunction.StateMachineSAMPTProperty.StateMachineName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withStateMachineName(final java.lang.String value) {
                this._stateMachineName = java.util.Objects.requireNonNull(value, "stateMachineName is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StateMachineSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public StateMachineSAMPTProperty build() {
                return new StateMachineSAMPTProperty() {
                    private final java.lang.String $stateMachineName = java.util.Objects.requireNonNull(_stateMachineName, "stateMachineName is required");

                    @Override
                    public java.lang.String getStateMachineName() {
                        return this.$stateMachineName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("stateMachineName", om.valueToTree(this.getStateMachineName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.StateMachineSAMPTProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.StateMachineSAMPTProperty.StateMachineName`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getStateMachineName() {
                return this.jsiiGet("stateMachineName", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface StreamSAMPTProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.StreamSAMPTProperty.StreamName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStreamName();

        /**
         * @return a {@link Builder} of {@link StreamSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link StreamSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _streamName;

            /**
             * Sets the value of StreamName
             * @param value `CfnFunction.StreamSAMPTProperty.StreamName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withStreamName(final java.lang.String value) {
                this._streamName = java.util.Objects.requireNonNull(value, "streamName is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public StreamSAMPTProperty build() {
                return new StreamSAMPTProperty() {
                    private final java.lang.String $streamName = java.util.Objects.requireNonNull(_streamName, "streamName is required");

                    @Override
                    public java.lang.String getStreamName() {
                        return this.$streamName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("streamName", om.valueToTree(this.getStreamName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.StreamSAMPTProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.StreamSAMPTProperty.StreamName`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getStreamName() {
                return this.jsiiGet("streamName", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TableSAMPTProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.TableSAMPTProperty.TableName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getTableName();

        /**
         * @return a {@link Builder} of {@link TableSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TableSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _tableName;

            /**
             * Sets the value of TableName
             * @param value `CfnFunction.TableSAMPTProperty.TableName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withTableName(final java.lang.String value) {
                this._tableName = java.util.Objects.requireNonNull(value, "tableName is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TableSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TableSAMPTProperty build() {
                return new TableSAMPTProperty() {
                    private final java.lang.String $tableName = java.util.Objects.requireNonNull(_tableName, "tableName is required");

                    @Override
                    public java.lang.String getTableName() {
                        return this.$tableName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("tableName", om.valueToTree(this.getTableName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.TableSAMPTProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.TableSAMPTProperty.TableName`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getTableName() {
                return this.jsiiGet("tableName", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TableStreamSAMPTProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.TableStreamSAMPTProperty.StreamName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStreamName();
        /**
         * `CfnFunction.TableStreamSAMPTProperty.TableName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getTableName();

        /**
         * @return a {@link Builder} of {@link TableStreamSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TableStreamSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _streamName;
            private java.lang.String _tableName;

            /**
             * Sets the value of StreamName
             * @param value `CfnFunction.TableStreamSAMPTProperty.StreamName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withStreamName(final java.lang.String value) {
                this._streamName = java.util.Objects.requireNonNull(value, "streamName is required");
                return this;
            }
            /**
             * Sets the value of TableName
             * @param value `CfnFunction.TableStreamSAMPTProperty.TableName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withTableName(final java.lang.String value) {
                this._tableName = java.util.Objects.requireNonNull(value, "tableName is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TableStreamSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TableStreamSAMPTProperty build() {
                return new TableStreamSAMPTProperty() {
                    private final java.lang.String $streamName = java.util.Objects.requireNonNull(_streamName, "streamName is required");
                    private final java.lang.String $tableName = java.util.Objects.requireNonNull(_tableName, "tableName is required");

                    @Override
                    public java.lang.String getStreamName() {
                        return this.$streamName;
                    }

                    @Override
                    public java.lang.String getTableName() {
                        return this.$tableName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("streamName", om.valueToTree(this.getStreamName()));
                        obj.set("tableName", om.valueToTree(this.getTableName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.TableStreamSAMPTProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.TableStreamSAMPTProperty.StreamName`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getStreamName() {
                return this.jsiiGet("streamName", java.lang.String.class);
            }

            /**
             * `CfnFunction.TableStreamSAMPTProperty.TableName`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getTableName() {
                return this.jsiiGet("tableName", java.lang.String.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TopicSAMPTProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.TopicSAMPTProperty.TopicName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getTopicName();

        /**
         * @return a {@link Builder} of {@link TopicSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TopicSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _topicName;

            /**
             * Sets the value of TopicName
             * @param value `CfnFunction.TopicSAMPTProperty.TopicName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withTopicName(final java.lang.String value) {
                this._topicName = java.util.Objects.requireNonNull(value, "topicName is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TopicSAMPTProperty build() {
                return new TopicSAMPTProperty() {
                    private final java.lang.String $topicName = java.util.Objects.requireNonNull(_topicName, "topicName is required");

                    @Override
                    public java.lang.String getTopicName() {
                        return this.$topicName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("topicName", om.valueToTree(this.getTopicName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.TopicSAMPTProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.TopicSAMPTProperty.TopicName`.
             * 
             * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getTopicName() {
                return this.jsiiGet("topicName", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface VpcConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnFunction.VpcConfigProperty.SecurityGroupIds`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getSecurityGroupIds();
        /**
         * `CfnFunction.VpcConfigProperty.SubnetIds`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getSubnetIds();

        /**
         * @return a {@link Builder} of {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.util.List<java.lang.String> _securityGroupIds;
            private java.util.List<java.lang.String> _subnetIds;

            /**
             * Sets the value of SecurityGroupIds
             * @param value `CfnFunction.VpcConfigProperty.SecurityGroupIds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSecurityGroupIds(final java.util.List<java.lang.String> value) {
                this._securityGroupIds = java.util.Objects.requireNonNull(value, "securityGroupIds is required");
                return this;
            }
            /**
             * Sets the value of SubnetIds
             * @param value `CfnFunction.VpcConfigProperty.SubnetIds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSubnetIds(final java.util.List<java.lang.String> value) {
                this._subnetIds = java.util.Objects.requireNonNull(value, "subnetIds is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public VpcConfigProperty build() {
                return new VpcConfigProperty() {
                    private final java.util.List<java.lang.String> $securityGroupIds = java.util.Objects.requireNonNull(_securityGroupIds, "securityGroupIds is required");
                    private final java.util.List<java.lang.String> $subnetIds = java.util.Objects.requireNonNull(_subnetIds, "subnetIds is required");

                    @Override
                    public java.util.List<java.lang.String> getSecurityGroupIds() {
                        return this.$securityGroupIds;
                    }

                    @Override
                    public java.util.List<java.lang.String> getSubnetIds() {
                        return this.$subnetIds;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                        obj.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.VpcConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnFunction.VpcConfigProperty.SecurityGroupIds`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.jsiiGet("securityGroupIds", java.util.List.class);
            }

            /**
             * `CfnFunction.VpcConfigProperty.SubnetIds`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.util.List<java.lang.String> getSubnetIds() {
                return this.jsiiGet("subnetIds", java.util.List.class);
            }
        }
    }
}
