package software.amazon.awscdk.services.sam;

/**
 * A CloudFormation `AWS::Serverless::Application`.
 * 
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.1 (build f4a0dbe)", date = "2019-10-02T18:21:43.680Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnApplication")
public class CfnApplication extends software.amazon.awscdk.core.CfnResource {

    protected CfnApplication(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplication(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnApplication.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
        REQUIRED_TRANSFORM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnApplication.class, "REQUIRED_TRANSFORM", java.lang.String.class);
    }

    /**
     * Create a new `AWS::Serverless::Application`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnApplication(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.sam.CfnApplicationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The `Transform` a template must use in order to use this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String REQUIRED_TRANSFORM;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::Serverless::Application.Tags`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::Serverless::Application.Location`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getLocation() {
        return this.jsiiGet("location", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Application.Location`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLocation(final java.lang.String value) {
        this.jsiiSet("location", java.util.Objects.requireNonNull(value, "location is required"));
    }

    /**
     * `AWS::Serverless::Application.Location`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLocation(final software.amazon.awscdk.services.sam.CfnApplication.ApplicationLocationProperty value) {
        this.jsiiSet("location", java.util.Objects.requireNonNull(value, "location is required"));
    }

    /**
     * `AWS::Serverless::Application.Location`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLocation(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("location", java.util.Objects.requireNonNull(value, "location is required"));
    }

    /**
     * `AWS::Serverless::Application.NotificationArns`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.util.List<java.lang.String> getNotificationArns() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("notificationArns", java.util.List.class));
    }

    /**
     * `AWS::Serverless::Application.NotificationArns`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setNotificationArns(final java.util.List<java.lang.String> value) {
        this.jsiiSet("notificationArns", value);
    }

    /**
     * `AWS::Serverless::Application.Parameters`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getParameters() {
        return this.jsiiGet("parameters", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Application.Parameters`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setParameters(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("parameters", value);
    }

    /**
     * `AWS::Serverless::Application.Parameters`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setParameters(final java.util.Map<java.lang.String, java.lang.String> value) {
        this.jsiiSet("parameters", value);
    }

    /**
     * `AWS::Serverless::Application.TimeoutInMinutes`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Number getTimeoutInMinutes() {
        return this.jsiiGet("timeoutInMinutes", java.lang.Number.class);
    }

    /**
     * `AWS::Serverless::Application.TimeoutInMinutes`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTimeoutInMinutes(final java.lang.Number value) {
        this.jsiiSet("timeoutInMinutes", value);
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ApplicationLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplication.ApplicationLocationProperty.ApplicationId`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getApplicationId();

        /**
         * `CfnApplication.ApplicationLocationProperty.SemanticVersion`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSemanticVersion();

        /**
         * @return a {@link Builder} of {@link ApplicationLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApplicationLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String applicationId;
            private java.lang.String semanticVersion;

            /**
             * Sets the value of ApplicationId
             * @param applicationId `CfnApplication.ApplicationLocationProperty.ApplicationId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder applicationId(java.lang.String applicationId) {
                this.applicationId = applicationId;
                return this;
            }

            /**
             * Sets the value of SemanticVersion
             * @param semanticVersion `CfnApplication.ApplicationLocationProperty.SemanticVersion`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder semanticVersion(java.lang.String semanticVersion) {
                this.semanticVersion = semanticVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ApplicationLocationProperty build() {
                return new Jsii$Proxy(applicationId, semanticVersion);
            }
        }

        /**
         * An implementation for {@link ApplicationLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationLocationProperty {
            private final java.lang.String applicationId;
            private final java.lang.String semanticVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.applicationId = this.jsiiGet("applicationId", java.lang.String.class);
                this.semanticVersion = this.jsiiGet("semanticVersion", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String applicationId, java.lang.String semanticVersion) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.applicationId = java.util.Objects.requireNonNull(applicationId, "applicationId is required");
                this.semanticVersion = java.util.Objects.requireNonNull(semanticVersion, "semanticVersion is required");
            }

            @Override
            public java.lang.String getApplicationId() {
                return this.applicationId;
            }

            @Override
            public java.lang.String getSemanticVersion() {
                return this.semanticVersion;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("applicationId", om.valueToTree(this.getApplicationId()));
                obj.set("semanticVersion", om.valueToTree(this.getSemanticVersion()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApplicationLocationProperty.Jsii$Proxy that = (ApplicationLocationProperty.Jsii$Proxy) o;

                if (!applicationId.equals(that.applicationId)) return false;
                return this.semanticVersion.equals(that.semanticVersion);
            }

            @Override
            public int hashCode() {
                int result = this.applicationId.hashCode();
                result = 31 * result + (this.semanticVersion.hashCode());
                return result;
            }
        }
    }
}
