package software.amazon.awscdk.services.sam;

/**
 * A CloudFormation `AWS::Serverless::Api`.
 * 
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T12:26:49.482Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnApi")
public class CfnApi extends software.amazon.awscdk.core.CfnResource {

    protected CfnApi(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApi(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnApi.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
        REQUIRED_TRANSFORM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnApi.class, "REQUIRED_TRANSFORM", java.lang.String.class);
    }

    /**
     * Create a new `AWS::Serverless::Api`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnApi(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.sam.CfnApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The `Transform` a template must use in order to use this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String REQUIRED_TRANSFORM;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::Serverless::Api.DefinitionBody`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getDefinitionBody() {
        return this.jsiiGet("definitionBody", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Api.DefinitionBody`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDefinitionBody(final java.lang.Object value) {
        this.jsiiSet("definitionBody", java.util.Objects.requireNonNull(value, "definitionBody is required"));
    }

    /**
     * `AWS::Serverless::Api.MethodSettings`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getMethodSettings() {
        return this.jsiiGet("methodSettings", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Api.MethodSettings`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMethodSettings(final java.lang.Object value) {
        this.jsiiSet("methodSettings", java.util.Objects.requireNonNull(value, "methodSettings is required"));
    }

    /**
     * `AWS::Serverless::Api.StageName`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getStageName() {
        return this.jsiiGet("stageName", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Api.StageName`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setStageName(final java.lang.String value) {
        this.jsiiSet("stageName", java.util.Objects.requireNonNull(value, "stageName is required"));
    }

    /**
     * `AWS::Serverless::Api.AccessLogSetting`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getAccessLogSetting() {
        return this.jsiiGet("accessLogSetting", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Api.AccessLogSetting`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAccessLogSetting(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("accessLogSetting", value);
    }

    /**
     * `AWS::Serverless::Api.AccessLogSetting`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAccessLogSetting(final software.amazon.awscdk.services.sam.CfnApi.AccessLogSettingProperty value) {
        this.jsiiSet("accessLogSetting", value);
    }

    /**
     * `AWS::Serverless::Api.Auth`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getAuth() {
        return this.jsiiGet("auth", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Api.Auth`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAuth(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("auth", value);
    }

    /**
     * `AWS::Serverless::Api.Auth`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAuth(final software.amazon.awscdk.services.sam.CfnApi.AuthProperty value) {
        this.jsiiSet("auth", value);
    }

    /**
     * `AWS::Serverless::Api.BinaryMediaTypes`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.util.List<java.lang.String> getBinaryMediaTypes() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("binaryMediaTypes", java.util.List.class));
    }

    /**
     * `AWS::Serverless::Api.BinaryMediaTypes`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setBinaryMediaTypes(final java.util.List<java.lang.String> value) {
        this.jsiiSet("binaryMediaTypes", value);
    }

    /**
     * `AWS::Serverless::Api.CacheClusterEnabled`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getCacheClusterEnabled() {
        return this.jsiiGet("cacheClusterEnabled", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Api.CacheClusterEnabled`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCacheClusterEnabled(final java.lang.Boolean value) {
        this.jsiiSet("cacheClusterEnabled", value);
    }

    /**
     * `AWS::Serverless::Api.CacheClusterEnabled`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCacheClusterEnabled(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("cacheClusterEnabled", value);
    }

    /**
     * `AWS::Serverless::Api.CacheClusterSize`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getCacheClusterSize() {
        return this.jsiiGet("cacheClusterSize", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Api.CacheClusterSize`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCacheClusterSize(final java.lang.String value) {
        this.jsiiSet("cacheClusterSize", value);
    }

    /**
     * `AWS::Serverless::Api.Cors`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getCors() {
        return this.jsiiGet("cors", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Api.Cors`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCors(final java.lang.String value) {
        this.jsiiSet("cors", value);
    }

    /**
     * `AWS::Serverless::Api.DefinitionUri`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getDefinitionUri() {
        return this.jsiiGet("definitionUri", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Api.DefinitionUri`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDefinitionUri(final java.lang.String value) {
        this.jsiiSet("definitionUri", value);
    }

    /**
     * `AWS::Serverless::Api.DefinitionUri`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDefinitionUri(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("definitionUri", value);
    }

    /**
     * `AWS::Serverless::Api.DefinitionUri`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDefinitionUri(final software.amazon.awscdk.services.sam.CfnApi.S3LocationProperty value) {
        this.jsiiSet("definitionUri", value);
    }

    /**
     * `AWS::Serverless::Api.EndpointConfiguration`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getEndpointConfiguration() {
        return this.jsiiGet("endpointConfiguration", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Api.EndpointConfiguration`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEndpointConfiguration(final java.lang.String value) {
        this.jsiiSet("endpointConfiguration", value);
    }

    /**
     * `AWS::Serverless::Api.Name`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getName() {
        return this.jsiiGet("name", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Api.Name`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setName(final java.lang.String value) {
        this.jsiiSet("name", value);
    }

    /**
     * `AWS::Serverless::Api.TracingEnabled`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getTracingEnabled() {
        return this.jsiiGet("tracingEnabled", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Api.TracingEnabled`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTracingEnabled(final java.lang.Boolean value) {
        this.jsiiSet("tracingEnabled", value);
    }

    /**
     * `AWS::Serverless::Api.TracingEnabled`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTracingEnabled(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("tracingEnabled", value);
    }

    /**
     * `AWS::Serverless::Api.Variables`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getVariables() {
        return this.jsiiGet("variables", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Api.Variables`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVariables(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("variables", value);
    }

    /**
     * `AWS::Serverless::Api.Variables`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVariables(final java.util.Map<java.lang.String, java.lang.String> value) {
        this.jsiiSet("variables", value);
    }
    /**
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AccessLogSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApi.AccessLogSettingProperty.DestinationArn`.
         * 
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-destinationarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDestinationArn();

        /**
         * `CfnApi.AccessLogSettingProperty.Format`.
         * 
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-format
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getFormat();

        /**
         * @return a {@link Builder} of {@link AccessLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String destinationArn;
            private java.lang.String format;

            /**
             * Sets the value of DestinationArn
             * @param destinationArn `CfnApi.AccessLogSettingProperty.DestinationArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder destinationArn(java.lang.String destinationArn) {
                this.destinationArn = destinationArn;
                return this;
            }

            /**
             * Sets the value of Format
             * @param format `CfnApi.AccessLogSettingProperty.Format`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessLogSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AccessLogSettingProperty build() {
                return new Jsii$Proxy(destinationArn, format);
            }
        }

        /**
         * An implementation for {@link AccessLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessLogSettingProperty {
            private final java.lang.String destinationArn;
            private final java.lang.String format;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.destinationArn = this.jsiiGet("destinationArn", java.lang.String.class);
                this.format = this.jsiiGet("format", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String destinationArn, java.lang.String format) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationArn = destinationArn;
                this.format = format;
            }

            @Override
            public java.lang.String getDestinationArn() {
                return this.destinationArn;
            }

            @Override
            public java.lang.String getFormat() {
                return this.format;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getDestinationArn() != null) {
                    obj.set("destinationArn", om.valueToTree(this.getDestinationArn()));
                }
                if (this.getFormat() != null) {
                    obj.set("format", om.valueToTree(this.getFormat()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessLogSettingProperty.Jsii$Proxy that = (AccessLogSettingProperty.Jsii$Proxy) o;

                if (this.destinationArn != null ? !this.destinationArn.equals(that.destinationArn) : that.destinationArn != null) return false;
                return this.format != null ? this.format.equals(that.format) : that.format == null;
            }

            @Override
            public int hashCode() {
                int result = this.destinationArn != null ? this.destinationArn.hashCode() : 0;
                result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api-auth-object
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AuthProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApi.AuthProperty.Authorizers`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api-auth-object
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getAuthorizers();

        /**
         * `CfnApi.AuthProperty.DefaultAuthorizer`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api-auth-object
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDefaultAuthorizer();

        /**
         * @return a {@link Builder} of {@link AuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object authorizers;
            private java.lang.String defaultAuthorizer;

            /**
             * Sets the value of Authorizers
             * @param authorizers `CfnApi.AuthProperty.Authorizers`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder authorizers(java.lang.Object authorizers) {
                this.authorizers = authorizers;
                return this;
            }

            /**
             * Sets the value of DefaultAuthorizer
             * @param defaultAuthorizer `CfnApi.AuthProperty.DefaultAuthorizer`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder defaultAuthorizer(java.lang.String defaultAuthorizer) {
                this.defaultAuthorizer = defaultAuthorizer;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AuthProperty build() {
                return new Jsii$Proxy(authorizers, defaultAuthorizer);
            }
        }

        /**
         * An implementation for {@link AuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthProperty {
            private final java.lang.Object authorizers;
            private final java.lang.String defaultAuthorizer;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.authorizers = this.jsiiGet("authorizers", java.lang.Object.class);
                this.defaultAuthorizer = this.jsiiGet("defaultAuthorizer", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object authorizers, java.lang.String defaultAuthorizer) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authorizers = authorizers;
                this.defaultAuthorizer = defaultAuthorizer;
            }

            @Override
            public java.lang.Object getAuthorizers() {
                return this.authorizers;
            }

            @Override
            public java.lang.String getDefaultAuthorizer() {
                return this.defaultAuthorizer;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getAuthorizers() != null) {
                    obj.set("authorizers", om.valueToTree(this.getAuthorizers()));
                }
                if (this.getDefaultAuthorizer() != null) {
                    obj.set("defaultAuthorizer", om.valueToTree(this.getDefaultAuthorizer()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthProperty.Jsii$Proxy that = (AuthProperty.Jsii$Proxy) o;

                if (this.authorizers != null ? !this.authorizers.equals(that.authorizers) : that.authorizers != null) return false;
                return this.defaultAuthorizer != null ? this.defaultAuthorizer.equals(that.defaultAuthorizer) : that.defaultAuthorizer == null;
            }

            @Override
            public int hashCode() {
                int result = this.authorizers != null ? this.authorizers.hashCode() : 0;
                result = 31 * result + (this.defaultAuthorizer != null ? this.defaultAuthorizer.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3-location-object
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApi.S3LocationProperty.Bucket`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getBucket();

        /**
         * `CfnApi.S3LocationProperty.Key`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKey();

        /**
         * `CfnApi.S3LocationProperty.Version`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getVersion();

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String bucket;
            private java.lang.String key;
            private java.lang.Number version;

            /**
             * Sets the value of Bucket
             * @param bucket `CfnApi.S3LocationProperty.Bucket`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of Key
             * @param key `CfnApi.S3LocationProperty.Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of Version
             * @param version `CfnApi.S3LocationProperty.Version`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder version(java.lang.Number version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public S3LocationProperty build() {
                return new Jsii$Proxy(bucket, key, version);
            }
        }

        /**
         * An implementation for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String key;
            private final java.lang.Number version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.bucket = this.jsiiGet("bucket", java.lang.String.class);
                this.key = this.jsiiGet("key", java.lang.String.class);
                this.version = this.jsiiGet("version", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String bucket, java.lang.String key, java.lang.Number version) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(bucket, "bucket is required");
                this.key = java.util.Objects.requireNonNull(key, "key is required");
                this.version = java.util.Objects.requireNonNull(version, "version is required");
            }

            @Override
            public java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public java.lang.String getKey() {
                return this.key;
            }

            @Override
            public java.lang.Number getVersion() {
                return this.version;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("bucket", om.valueToTree(this.getBucket()));
                obj.set("key", om.valueToTree(this.getKey()));
                obj.set("version", om.valueToTree(this.getVersion()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LocationProperty.Jsii$Proxy that = (S3LocationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (!key.equals(that.key)) return false;
                return this.version.equals(that.version);
            }

            @Override
            public int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.key.hashCode());
                result = 31 * result + (this.version.hashCode());
                return result;
            }
        }
    }
}
