package software.amazon.awscdk.services.sam;

/**
 * A CloudFormation `AWS::Serverless::Function`.
 * 
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T12:26:49.490Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction")
public class CfnFunction extends software.amazon.awscdk.core.CfnResource {

    protected CfnFunction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFunction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnFunction.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
        REQUIRED_TRANSFORM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnFunction.class, "REQUIRED_TRANSFORM", java.lang.String.class);
    }

    /**
     * Create a new `AWS::Serverless::Function`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnFunction(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.sam.CfnFunctionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The `Transform` a template must use in order to use this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String REQUIRED_TRANSFORM;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::Serverless::Function.Tags`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::Serverless::Function.CodeUri`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getCodeUri() {
        return this.jsiiGet("codeUri", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Function.CodeUri`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCodeUri(final java.lang.String value) {
        this.jsiiSet("codeUri", java.util.Objects.requireNonNull(value, "codeUri is required"));
    }

    /**
     * `AWS::Serverless::Function.CodeUri`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCodeUri(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("codeUri", java.util.Objects.requireNonNull(value, "codeUri is required"));
    }

    /**
     * `AWS::Serverless::Function.CodeUri`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCodeUri(final software.amazon.awscdk.services.sam.CfnFunction.S3LocationProperty value) {
        this.jsiiSet("codeUri", java.util.Objects.requireNonNull(value, "codeUri is required"));
    }

    /**
     * `AWS::Serverless::Function.Handler`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getHandler() {
        return this.jsiiGet("handler", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Function.Handler`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setHandler(final java.lang.String value) {
        this.jsiiSet("handler", java.util.Objects.requireNonNull(value, "handler is required"));
    }

    /**
     * `AWS::Serverless::Function.Runtime`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getRuntime() {
        return this.jsiiGet("runtime", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Function.Runtime`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRuntime(final java.lang.String value) {
        this.jsiiSet("runtime", java.util.Objects.requireNonNull(value, "runtime is required"));
    }

    /**
     * `AWS::Serverless::Function.AutoPublishAlias`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAutoPublishAlias() {
        return this.jsiiGet("autoPublishAlias", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Function.AutoPublishAlias`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAutoPublishAlias(final java.lang.String value) {
        this.jsiiSet("autoPublishAlias", value);
    }

    /**
     * `AWS::Serverless::Function.DeadLetterQueue`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getDeadLetterQueue() {
        return this.jsiiGet("deadLetterQueue", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Function.DeadLetterQueue`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDeadLetterQueue(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("deadLetterQueue", value);
    }

    /**
     * `AWS::Serverless::Function.DeadLetterQueue`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDeadLetterQueue(final software.amazon.awscdk.services.sam.CfnFunction.DeadLetterQueueProperty value) {
        this.jsiiSet("deadLetterQueue", value);
    }

    /**
     * `AWS::Serverless::Function.DeploymentPreference`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getDeploymentPreference() {
        return this.jsiiGet("deploymentPreference", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Function.DeploymentPreference`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDeploymentPreference(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("deploymentPreference", value);
    }

    /**
     * `AWS::Serverless::Function.DeploymentPreference`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDeploymentPreference(final software.amazon.awscdk.services.sam.CfnFunction.DeploymentPreferenceProperty value) {
        this.jsiiSet("deploymentPreference", value);
    }

    /**
     * `AWS::Serverless::Function.Description`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getDescription() {
        return this.jsiiGet("description", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Function.Description`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDescription(final java.lang.String value) {
        this.jsiiSet("description", value);
    }

    /**
     * `AWS::Serverless::Function.Environment`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getEnvironment() {
        return this.jsiiGet("environment", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Function.Environment`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEnvironment(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("environment", value);
    }

    /**
     * `AWS::Serverless::Function.Environment`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEnvironment(final software.amazon.awscdk.services.sam.CfnFunction.FunctionEnvironmentProperty value) {
        this.jsiiSet("environment", value);
    }

    /**
     * `AWS::Serverless::Function.Events`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getEvents() {
        return this.jsiiGet("events", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Function.Events`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEvents(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("events", value);
    }

    /**
     * `AWS::Serverless::Function.Events`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEvents(final java.util.Map<java.lang.String, java.lang.Object> value) {
        this.jsiiSet("events", value);
    }

    /**
     * `AWS::Serverless::Function.FunctionName`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getFunctionName() {
        return this.jsiiGet("functionName", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Function.FunctionName`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setFunctionName(final java.lang.String value) {
        this.jsiiSet("functionName", value);
    }

    /**
     * `AWS::Serverless::Function.KmsKeyArn`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getKmsKeyArn() {
        return this.jsiiGet("kmsKeyArn", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Function.KmsKeyArn`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setKmsKeyArn(final java.lang.String value) {
        this.jsiiSet("kmsKeyArn", value);
    }

    /**
     * `AWS::Serverless::Function.Layers`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.util.List<java.lang.String> getLayers() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("layers", java.util.List.class));
    }

    /**
     * `AWS::Serverless::Function.Layers`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLayers(final java.util.List<java.lang.String> value) {
        this.jsiiSet("layers", value);
    }

    /**
     * `AWS::Serverless::Function.MemorySize`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Number getMemorySize() {
        return this.jsiiGet("memorySize", java.lang.Number.class);
    }

    /**
     * `AWS::Serverless::Function.MemorySize`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMemorySize(final java.lang.Number value) {
        this.jsiiSet("memorySize", value);
    }

    /**
     * `AWS::Serverless::Function.PermissionsBoundary`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getPermissionsBoundary() {
        return this.jsiiGet("permissionsBoundary", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Function.PermissionsBoundary`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPermissionsBoundary(final java.lang.String value) {
        this.jsiiSet("permissionsBoundary", value);
    }

    /**
     * `AWS::Serverless::Function.Policies`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getPolicies() {
        return this.jsiiGet("policies", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Function.Policies`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPolicies(final java.lang.String value) {
        this.jsiiSet("policies", value);
    }

    /**
     * `AWS::Serverless::Function.Policies`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPolicies(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("policies", value);
    }

    /**
     * `AWS::Serverless::Function.Policies`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPolicies(final software.amazon.awscdk.services.sam.CfnFunction.IAMPolicyDocumentProperty value) {
        this.jsiiSet("policies", value);
    }

    /**
     * `AWS::Serverless::Function.Policies`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPolicies(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("policies", value);
    }

    /**
     * `AWS::Serverless::Function.ReservedConcurrentExecutions`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Number getReservedConcurrentExecutions() {
        return this.jsiiGet("reservedConcurrentExecutions", java.lang.Number.class);
    }

    /**
     * `AWS::Serverless::Function.ReservedConcurrentExecutions`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setReservedConcurrentExecutions(final java.lang.Number value) {
        this.jsiiSet("reservedConcurrentExecutions", value);
    }

    /**
     * `AWS::Serverless::Function.Role`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getRole() {
        return this.jsiiGet("role", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Function.Role`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRole(final java.lang.String value) {
        this.jsiiSet("role", value);
    }

    /**
     * `AWS::Serverless::Function.Timeout`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Number getTimeout() {
        return this.jsiiGet("timeout", java.lang.Number.class);
    }

    /**
     * `AWS::Serverless::Function.Timeout`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTimeout(final java.lang.Number value) {
        this.jsiiSet("timeout", value);
    }

    /**
     * `AWS::Serverless::Function.Tracing`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getTracing() {
        return this.jsiiGet("tracing", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Function.Tracing`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTracing(final java.lang.String value) {
        this.jsiiSet("tracing", value);
    }

    /**
     * `AWS::Serverless::Function.VpcConfig`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getVpcConfig() {
        return this.jsiiGet("vpcConfig", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Function.VpcConfig`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVpcConfig(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("vpcConfig", value);
    }

    /**
     * `AWS::Serverless::Function.VpcConfig`.
     * 
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVpcConfig(final software.amazon.awscdk.services.sam.CfnFunction.VpcConfigProperty value) {
        this.jsiiSet("vpcConfig", value);
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#alexaskill
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AlexaSkillEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.AlexaSkillEventProperty.Variables`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#alexaskill
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getVariables();

        /**
         * @return a {@link Builder} of {@link AlexaSkillEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AlexaSkillEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object variables;

            /**
             * Sets the value of Variables
             * @param variables `CfnFunction.AlexaSkillEventProperty.Variables`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder variables(software.amazon.awscdk.core.IResolvable variables) {
                this.variables = variables;
                return this;
            }

            /**
             * Sets the value of Variables
             * @param variables `CfnFunction.AlexaSkillEventProperty.Variables`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder variables(java.util.Map<java.lang.String, java.lang.String> variables) {
                this.variables = variables;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlexaSkillEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AlexaSkillEventProperty build() {
                return new Jsii$Proxy(variables);
            }
        }

        /**
         * An implementation for {@link AlexaSkillEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlexaSkillEventProperty {
            private final java.lang.Object variables;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.variables = this.jsiiGet("variables", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object variables) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.variables = variables;
            }

            @Override
            public java.lang.Object getVariables() {
                return this.variables;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getVariables() != null) {
                    obj.set("variables", om.valueToTree(this.getVariables()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AlexaSkillEventProperty.Jsii$Proxy that = (AlexaSkillEventProperty.Jsii$Proxy) o;

                return this.variables != null ? this.variables.equals(that.variables) : that.variables == null;
            }

            @Override
            public int hashCode() {
                int result = this.variables != null ? this.variables.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ApiEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.ApiEventProperty.Method`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getMethod();

        /**
         * `CfnFunction.ApiEventProperty.Path`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPath();

        /**
         * `CfnFunction.ApiEventProperty.RestApiId`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getRestApiId();

        /**
         * @return a {@link Builder} of {@link ApiEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApiEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String method;
            private java.lang.String path;
            private java.lang.String restApiId;

            /**
             * Sets the value of Method
             * @param method `CfnFunction.ApiEventProperty.Method`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder method(java.lang.String method) {
                this.method = method;
                return this;
            }

            /**
             * Sets the value of Path
             * @param path `CfnFunction.ApiEventProperty.Path`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of RestApiId
             * @param restApiId `CfnFunction.ApiEventProperty.RestApiId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder restApiId(java.lang.String restApiId) {
                this.restApiId = restApiId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApiEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ApiEventProperty build() {
                return new Jsii$Proxy(method, path, restApiId);
            }
        }

        /**
         * An implementation for {@link ApiEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiEventProperty {
            private final java.lang.String method;
            private final java.lang.String path;
            private final java.lang.String restApiId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.method = this.jsiiGet("method", java.lang.String.class);
                this.path = this.jsiiGet("path", java.lang.String.class);
                this.restApiId = this.jsiiGet("restApiId", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String method, java.lang.String path, java.lang.String restApiId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.method = java.util.Objects.requireNonNull(method, "method is required");
                this.path = java.util.Objects.requireNonNull(path, "path is required");
                this.restApiId = restApiId;
            }

            @Override
            public java.lang.String getMethod() {
                return this.method;
            }

            @Override
            public java.lang.String getPath() {
                return this.path;
            }

            @Override
            public java.lang.String getRestApiId() {
                return this.restApiId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("method", om.valueToTree(this.getMethod()));
                obj.set("path", om.valueToTree(this.getPath()));
                if (this.getRestApiId() != null) {
                    obj.set("restApiId", om.valueToTree(this.getRestApiId()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApiEventProperty.Jsii$Proxy that = (ApiEventProperty.Jsii$Proxy) o;

                if (!method.equals(that.method)) return false;
                if (!path.equals(that.path)) return false;
                return this.restApiId != null ? this.restApiId.equals(that.restApiId) : that.restApiId == null;
            }

            @Override
            public int hashCode() {
                int result = this.method.hashCode();
                result = 31 * result + (this.path.hashCode());
                result = 31 * result + (this.restApiId != null ? this.restApiId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface BucketSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.BucketSAMPTProperty.BucketName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getBucketName();

        /**
         * @return a {@link Builder} of {@link BucketSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BucketSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String bucketName;

            /**
             * Sets the value of BucketName
             * @param bucketName `CfnFunction.BucketSAMPTProperty.BucketName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BucketSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public BucketSAMPTProperty build() {
                return new Jsii$Proxy(bucketName);
            }
        }

        /**
         * An implementation for {@link BucketSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BucketSAMPTProperty {
            private final java.lang.String bucketName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.bucketName = this.jsiiGet("bucketName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String bucketName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(bucketName, "bucketName is required");
            }

            @Override
            public java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("bucketName", om.valueToTree(this.getBucketName()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BucketSAMPTProperty.Jsii$Proxy that = (BucketSAMPTProperty.Jsii$Proxy) o;

                return this.bucketName.equals(that.bucketName);
            }

            @Override
            public int hashCode() {
                int result = this.bucketName.hashCode();
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CloudWatchEventEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.CloudWatchEventEventProperty.Pattern`.
         * 
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getPattern();

        /**
         * `CfnFunction.CloudWatchEventEventProperty.Input`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getInput();

        /**
         * `CfnFunction.CloudWatchEventEventProperty.InputPath`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getInputPath();

        /**
         * @return a {@link Builder} of {@link CloudWatchEventEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchEventEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object pattern;
            private java.lang.String input;
            private java.lang.String inputPath;

            /**
             * Sets the value of Pattern
             * @param pattern `CfnFunction.CloudWatchEventEventProperty.Pattern`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder pattern(java.lang.Object pattern) {
                this.pattern = pattern;
                return this;
            }

            /**
             * Sets the value of Input
             * @param input `CfnFunction.CloudWatchEventEventProperty.Input`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder input(java.lang.String input) {
                this.input = input;
                return this;
            }

            /**
             * Sets the value of InputPath
             * @param inputPath `CfnFunction.CloudWatchEventEventProperty.InputPath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder inputPath(java.lang.String inputPath) {
                this.inputPath = inputPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchEventEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CloudWatchEventEventProperty build() {
                return new Jsii$Proxy(pattern, input, inputPath);
            }
        }

        /**
         * An implementation for {@link CloudWatchEventEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchEventEventProperty {
            private final java.lang.Object pattern;
            private final java.lang.String input;
            private final java.lang.String inputPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.pattern = this.jsiiGet("pattern", java.lang.Object.class);
                this.input = this.jsiiGet("input", java.lang.String.class);
                this.inputPath = this.jsiiGet("inputPath", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object pattern, java.lang.String input, java.lang.String inputPath) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pattern = java.util.Objects.requireNonNull(pattern, "pattern is required");
                this.input = input;
                this.inputPath = inputPath;
            }

            @Override
            public java.lang.Object getPattern() {
                return this.pattern;
            }

            @Override
            public java.lang.String getInput() {
                return this.input;
            }

            @Override
            public java.lang.String getInputPath() {
                return this.inputPath;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("pattern", om.valueToTree(this.getPattern()));
                if (this.getInput() != null) {
                    obj.set("input", om.valueToTree(this.getInput()));
                }
                if (this.getInputPath() != null) {
                    obj.set("inputPath", om.valueToTree(this.getInputPath()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchEventEventProperty.Jsii$Proxy that = (CloudWatchEventEventProperty.Jsii$Proxy) o;

                if (!pattern.equals(that.pattern)) return false;
                if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
                return this.inputPath != null ? this.inputPath.equals(that.inputPath) : that.inputPath == null;
            }

            @Override
            public int hashCode() {
                int result = this.pattern.hashCode();
                result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
                result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CollectionSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.CollectionSAMPTProperty.CollectionId`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCollectionId();

        /**
         * @return a {@link Builder} of {@link CollectionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CollectionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String collectionId;

            /**
             * Sets the value of CollectionId
             * @param collectionId `CfnFunction.CollectionSAMPTProperty.CollectionId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder collectionId(java.lang.String collectionId) {
                this.collectionId = collectionId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CollectionSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CollectionSAMPTProperty build() {
                return new Jsii$Proxy(collectionId);
            }
        }

        /**
         * An implementation for {@link CollectionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CollectionSAMPTProperty {
            private final java.lang.String collectionId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.collectionId = this.jsiiGet("collectionId", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String collectionId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.collectionId = java.util.Objects.requireNonNull(collectionId, "collectionId is required");
            }

            @Override
            public java.lang.String getCollectionId() {
                return this.collectionId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("collectionId", om.valueToTree(this.getCollectionId()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CollectionSAMPTProperty.Jsii$Proxy that = (CollectionSAMPTProperty.Jsii$Proxy) o;

                return this.collectionId.equals(that.collectionId);
            }

            @Override
            public int hashCode() {
                int result = this.collectionId.hashCode();
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deadletterqueue-object
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface DeadLetterQueueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.DeadLetterQueueProperty.TargetArn`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getTargetArn();

        /**
         * `CfnFunction.DeadLetterQueueProperty.Type`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link DeadLetterQueueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeadLetterQueueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String targetArn;
            private java.lang.String type;

            /**
             * Sets the value of TargetArn
             * @param targetArn `CfnFunction.DeadLetterQueueProperty.TargetArn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder targetArn(java.lang.String targetArn) {
                this.targetArn = targetArn;
                return this;
            }

            /**
             * Sets the value of Type
             * @param type `CfnFunction.DeadLetterQueueProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeadLetterQueueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public DeadLetterQueueProperty build() {
                return new Jsii$Proxy(targetArn, type);
            }
        }

        /**
         * An implementation for {@link DeadLetterQueueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeadLetterQueueProperty {
            private final java.lang.String targetArn;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.targetArn = this.jsiiGet("targetArn", java.lang.String.class);
                this.type = this.jsiiGet("type", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String targetArn, java.lang.String type) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetArn = java.util.Objects.requireNonNull(targetArn, "targetArn is required");
                this.type = java.util.Objects.requireNonNull(type, "type is required");
            }

            @Override
            public java.lang.String getTargetArn() {
                return this.targetArn;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("targetArn", om.valueToTree(this.getTargetArn()));
                obj.set("type", om.valueToTree(this.getType()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeadLetterQueueProperty.Jsii$Proxy that = (DeadLetterQueueProperty.Jsii$Proxy) o;

                if (!targetArn.equals(that.targetArn)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public int hashCode() {
                int result = this.targetArn.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/safe_lambda_deployments.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface DeploymentPreferenceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.DeploymentPreferenceProperty.Enabled`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEnabled();

        /**
         * `CfnFunction.DeploymentPreferenceProperty.Type`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getType();

        /**
         * `CfnFunction.DeploymentPreferenceProperty.Alarms`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getAlarms();

        /**
         * `CfnFunction.DeploymentPreferenceProperty.Hooks`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getHooks();

        /**
         * @return a {@link Builder} of {@link DeploymentPreferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentPreferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object enabled;
            private java.lang.String type;
            private java.util.List<java.lang.String> alarms;
            private java.util.List<java.lang.String> hooks;

            /**
             * Sets the value of Enabled
             * @param enabled `CfnFunction.DeploymentPreferenceProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of Enabled
             * @param enabled `CfnFunction.DeploymentPreferenceProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of Type
             * @param type `CfnFunction.DeploymentPreferenceProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of Alarms
             * @param alarms `CfnFunction.DeploymentPreferenceProperty.Alarms`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder alarms(java.util.List<java.lang.String> alarms) {
                this.alarms = alarms;
                return this;
            }

            /**
             * Sets the value of Hooks
             * @param hooks `CfnFunction.DeploymentPreferenceProperty.Hooks`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder hooks(java.util.List<java.lang.String> hooks) {
                this.hooks = hooks;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentPreferenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public DeploymentPreferenceProperty build() {
                return new Jsii$Proxy(enabled, type, alarms, hooks);
            }
        }

        /**
         * An implementation for {@link DeploymentPreferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentPreferenceProperty {
            private final java.lang.Object enabled;
            private final java.lang.String type;
            private final java.util.List<java.lang.String> alarms;
            private final java.util.List<java.lang.String> hooks;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
                this.type = this.jsiiGet("type", java.lang.String.class);
                this.alarms = this.jsiiGet("alarms", java.util.List.class);
                this.hooks = this.jsiiGet("hooks", java.util.List.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object enabled, java.lang.String type, java.util.List<java.lang.String> alarms, java.util.List<java.lang.String> hooks) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(enabled, "enabled is required");
                this.type = java.util.Objects.requireNonNull(type, "type is required");
                this.alarms = alarms;
                this.hooks = hooks;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public java.util.List<java.lang.String> getAlarms() {
                return this.alarms;
            }

            @Override
            public java.util.List<java.lang.String> getHooks() {
                return this.hooks;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("enabled", om.valueToTree(this.getEnabled()));
                obj.set("type", om.valueToTree(this.getType()));
                if (this.getAlarms() != null) {
                    obj.set("alarms", om.valueToTree(this.getAlarms()));
                }
                if (this.getHooks() != null) {
                    obj.set("hooks", om.valueToTree(this.getHooks()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentPreferenceProperty.Jsii$Proxy that = (DeploymentPreferenceProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                if (!type.equals(that.type)) return false;
                if (this.alarms != null ? !this.alarms.equals(that.alarms) : that.alarms != null) return false;
                return this.hooks != null ? this.hooks.equals(that.hooks) : that.hooks == null;
            }

            @Override
            public int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.alarms != null ? this.alarms.hashCode() : 0);
                result = 31 * result + (this.hooks != null ? this.hooks.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface DomainSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.DomainSAMPTProperty.DomainName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDomainName();

        /**
         * @return a {@link Builder} of {@link DomainSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DomainSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String domainName;

            /**
             * Sets the value of DomainName
             * @param domainName `CfnFunction.DomainSAMPTProperty.DomainName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder domainName(java.lang.String domainName) {
                this.domainName = domainName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DomainSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public DomainSAMPTProperty build() {
                return new Jsii$Proxy(domainName);
            }
        }

        /**
         * An implementation for {@link DomainSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainSAMPTProperty {
            private final java.lang.String domainName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.domainName = this.jsiiGet("domainName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String domainName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainName = java.util.Objects.requireNonNull(domainName, "domainName is required");
            }

            @Override
            public java.lang.String getDomainName() {
                return this.domainName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("domainName", om.valueToTree(this.getDomainName()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DomainSAMPTProperty.Jsii$Proxy that = (DomainSAMPTProperty.Jsii$Proxy) o;

                return this.domainName.equals(that.domainName);
            }

            @Override
            public int hashCode() {
                int result = this.domainName.hashCode();
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface DynamoDBEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.DynamoDBEventProperty.StartingPosition`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStartingPosition();

        /**
         * `CfnFunction.DynamoDBEventProperty.Stream`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStream();

        /**
         * `CfnFunction.DynamoDBEventProperty.BatchSize`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getBatchSize();

        /**
         * `CfnFunction.DynamoDBEventProperty.Enabled`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link DynamoDBEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynamoDBEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String startingPosition;
            private java.lang.String stream;
            private java.lang.Number batchSize;
            private java.lang.Object enabled;

            /**
             * Sets the value of StartingPosition
             * @param startingPosition `CfnFunction.DynamoDBEventProperty.StartingPosition`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder startingPosition(java.lang.String startingPosition) {
                this.startingPosition = startingPosition;
                return this;
            }

            /**
             * Sets the value of Stream
             * @param stream `CfnFunction.DynamoDBEventProperty.Stream`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder stream(java.lang.String stream) {
                this.stream = stream;
                return this;
            }

            /**
             * Sets the value of BatchSize
             * @param batchSize `CfnFunction.DynamoDBEventProperty.BatchSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder batchSize(java.lang.Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            /**
             * Sets the value of Enabled
             * @param enabled `CfnFunction.DynamoDBEventProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of Enabled
             * @param enabled `CfnFunction.DynamoDBEventProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynamoDBEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public DynamoDBEventProperty build() {
                return new Jsii$Proxy(startingPosition, stream, batchSize, enabled);
            }
        }

        /**
         * An implementation for {@link DynamoDBEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamoDBEventProperty {
            private final java.lang.String startingPosition;
            private final java.lang.String stream;
            private final java.lang.Number batchSize;
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.startingPosition = this.jsiiGet("startingPosition", java.lang.String.class);
                this.stream = this.jsiiGet("stream", java.lang.String.class);
                this.batchSize = this.jsiiGet("batchSize", java.lang.Number.class);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String startingPosition, java.lang.String stream, java.lang.Number batchSize, java.lang.Object enabled) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.startingPosition = java.util.Objects.requireNonNull(startingPosition, "startingPosition is required");
                this.stream = java.util.Objects.requireNonNull(stream, "stream is required");
                this.batchSize = batchSize;
                this.enabled = enabled;
            }

            @Override
            public java.lang.String getStartingPosition() {
                return this.startingPosition;
            }

            @Override
            public java.lang.String getStream() {
                return this.stream;
            }

            @Override
            public java.lang.Number getBatchSize() {
                return this.batchSize;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("startingPosition", om.valueToTree(this.getStartingPosition()));
                obj.set("stream", om.valueToTree(this.getStream()));
                if (this.getBatchSize() != null) {
                    obj.set("batchSize", om.valueToTree(this.getBatchSize()));
                }
                if (this.getEnabled() != null) {
                    obj.set("enabled", om.valueToTree(this.getEnabled()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynamoDBEventProperty.Jsii$Proxy that = (DynamoDBEventProperty.Jsii$Proxy) o;

                if (!startingPosition.equals(that.startingPosition)) return false;
                if (!stream.equals(that.stream)) return false;
                if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public int hashCode() {
                int result = this.startingPosition.hashCode();
                result = 31 * result + (this.stream.hashCode());
                result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface EmptySAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @return a {@link Builder} of {@link EmptySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmptySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmptySAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public EmptySAMPTProperty build() {
                return new Jsii$Proxy();
            }
        }

        /**
         * An implementation for {@link EmptySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmptySAMPTProperty {

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy() {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                return obj;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-object
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface EventSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.EventSourceProperty.Properties`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-types
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getProperties();

        /**
         * `CfnFunction.EventSourceProperty.Type`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-object
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link EventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object properties;
            private java.lang.String type;

            /**
             * Sets the value of Properties
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder properties(software.amazon.awscdk.core.IResolvable properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of Properties
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.AlexaSkillEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of Properties
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.ApiEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of Properties
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.CloudWatchEventEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of Properties
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.DynamoDBEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of Properties
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.IoTRuleEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of Properties
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.KinesisEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of Properties
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.S3EventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of Properties
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.SNSEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of Properties
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.SQSEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of Properties
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.ScheduleEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of Type
             * @param type `CfnFunction.EventSourceProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public EventSourceProperty build() {
                return new Jsii$Proxy(properties, type);
            }
        }

        /**
         * An implementation for {@link EventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventSourceProperty {
            private final java.lang.Object properties;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.properties = this.jsiiGet("properties", java.lang.Object.class);
                this.type = this.jsiiGet("type", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object properties, java.lang.String type) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.properties = java.util.Objects.requireNonNull(properties, "properties is required");
                this.type = java.util.Objects.requireNonNull(type, "type is required");
            }

            @Override
            public java.lang.Object getProperties() {
                return this.properties;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("properties", om.valueToTree(this.getProperties()));
                obj.set("type", om.valueToTree(this.getType()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventSourceProperty.Jsii$Proxy that = (EventSourceProperty.Jsii$Proxy) o;

                if (!properties.equals(that.properties)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public int hashCode() {
                int result = this.properties.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#environment-object
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface FunctionEnvironmentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.FunctionEnvironmentProperty.Variables`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#environment-object
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getVariables();

        /**
         * @return a {@link Builder} of {@link FunctionEnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FunctionEnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object variables;

            /**
             * Sets the value of Variables
             * @param variables `CfnFunction.FunctionEnvironmentProperty.Variables`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder variables(software.amazon.awscdk.core.IResolvable variables) {
                this.variables = variables;
                return this;
            }

            /**
             * Sets the value of Variables
             * @param variables `CfnFunction.FunctionEnvironmentProperty.Variables`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder variables(java.util.Map<java.lang.String, java.lang.String> variables) {
                this.variables = variables;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FunctionEnvironmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public FunctionEnvironmentProperty build() {
                return new Jsii$Proxy(variables);
            }
        }

        /**
         * An implementation for {@link FunctionEnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionEnvironmentProperty {
            private final java.lang.Object variables;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.variables = this.jsiiGet("variables", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object variables) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.variables = java.util.Objects.requireNonNull(variables, "variables is required");
            }

            @Override
            public java.lang.Object getVariables() {
                return this.variables;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("variables", om.valueToTree(this.getVariables()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FunctionEnvironmentProperty.Jsii$Proxy that = (FunctionEnvironmentProperty.Jsii$Proxy) o;

                return this.variables.equals(that.variables);
            }

            @Override
            public int hashCode() {
                int result = this.variables.hashCode();
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface FunctionSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.FunctionSAMPTProperty.FunctionName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getFunctionName();

        /**
         * @return a {@link Builder} of {@link FunctionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FunctionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String functionName;

            /**
             * Sets the value of FunctionName
             * @param functionName `CfnFunction.FunctionSAMPTProperty.FunctionName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder functionName(java.lang.String functionName) {
                this.functionName = functionName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FunctionSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public FunctionSAMPTProperty build() {
                return new Jsii$Proxy(functionName);
            }
        }

        /**
         * An implementation for {@link FunctionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionSAMPTProperty {
            private final java.lang.String functionName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.functionName = this.jsiiGet("functionName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String functionName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.functionName = java.util.Objects.requireNonNull(functionName, "functionName is required");
            }

            @Override
            public java.lang.String getFunctionName() {
                return this.functionName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("functionName", om.valueToTree(this.getFunctionName()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FunctionSAMPTProperty.Jsii$Proxy that = (FunctionSAMPTProperty.Jsii$Proxy) o;

                return this.functionName.equals(that.functionName);
            }

            @Override
            public int hashCode() {
                int result = this.functionName.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface IAMPolicyDocumentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.IAMPolicyDocumentProperty.Statement`.
         * 
         * @see http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getStatement();

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sam.CfnFunction.IAMPolicyDocumentProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
            }

            /**
             * `CfnFunction.IAMPolicyDocumentProperty.Statement`.
             * 
             * @see http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.Object getStatement() {
                return this.jsiiGet("statement", java.lang.Object.class);
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface IdentitySAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.IdentitySAMPTProperty.IdentityName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getIdentityName();

        /**
         * @return a {@link Builder} of {@link IdentitySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdentitySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String identityName;

            /**
             * Sets the value of IdentityName
             * @param identityName `CfnFunction.IdentitySAMPTProperty.IdentityName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder identityName(java.lang.String identityName) {
                this.identityName = identityName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdentitySAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public IdentitySAMPTProperty build() {
                return new Jsii$Proxy(identityName);
            }
        }

        /**
         * An implementation for {@link IdentitySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentitySAMPTProperty {
            private final java.lang.String identityName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.identityName = this.jsiiGet("identityName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String identityName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.identityName = java.util.Objects.requireNonNull(identityName, "identityName is required");
            }

            @Override
            public java.lang.String getIdentityName() {
                return this.identityName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("identityName", om.valueToTree(this.getIdentityName()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdentitySAMPTProperty.Jsii$Proxy that = (IdentitySAMPTProperty.Jsii$Proxy) o;

                return this.identityName.equals(that.identityName);
            }

            @Override
            public int hashCode() {
                int result = this.identityName.hashCode();
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#iotrule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface IoTRuleEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.IoTRuleEventProperty.Sql`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#iotrule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSql();

        /**
         * `CfnFunction.IoTRuleEventProperty.AwsIotSqlVersion`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#iotrule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getAwsIotSqlVersion();

        /**
         * @return a {@link Builder} of {@link IoTRuleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IoTRuleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String sql;
            private java.lang.String awsIotSqlVersion;

            /**
             * Sets the value of Sql
             * @param sql `CfnFunction.IoTRuleEventProperty.Sql`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sql(java.lang.String sql) {
                this.sql = sql;
                return this;
            }

            /**
             * Sets the value of AwsIotSqlVersion
             * @param awsIotSqlVersion `CfnFunction.IoTRuleEventProperty.AwsIotSqlVersion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder awsIotSqlVersion(java.lang.String awsIotSqlVersion) {
                this.awsIotSqlVersion = awsIotSqlVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IoTRuleEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public IoTRuleEventProperty build() {
                return new Jsii$Proxy(sql, awsIotSqlVersion);
            }
        }

        /**
         * An implementation for {@link IoTRuleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IoTRuleEventProperty {
            private final java.lang.String sql;
            private final java.lang.String awsIotSqlVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.sql = this.jsiiGet("sql", java.lang.String.class);
                this.awsIotSqlVersion = this.jsiiGet("awsIotSqlVersion", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String sql, java.lang.String awsIotSqlVersion) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sql = java.util.Objects.requireNonNull(sql, "sql is required");
                this.awsIotSqlVersion = awsIotSqlVersion;
            }

            @Override
            public java.lang.String getSql() {
                return this.sql;
            }

            @Override
            public java.lang.String getAwsIotSqlVersion() {
                return this.awsIotSqlVersion;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("sql", om.valueToTree(this.getSql()));
                if (this.getAwsIotSqlVersion() != null) {
                    obj.set("awsIotSqlVersion", om.valueToTree(this.getAwsIotSqlVersion()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IoTRuleEventProperty.Jsii$Proxy that = (IoTRuleEventProperty.Jsii$Proxy) o;

                if (!sql.equals(that.sql)) return false;
                return this.awsIotSqlVersion != null ? this.awsIotSqlVersion.equals(that.awsIotSqlVersion) : that.awsIotSqlVersion == null;
            }

            @Override
            public int hashCode() {
                int result = this.sql.hashCode();
                result = 31 * result + (this.awsIotSqlVersion != null ? this.awsIotSqlVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface KeySAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.KeySAMPTProperty.KeyId`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKeyId();

        /**
         * @return a {@link Builder} of {@link KeySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KeySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String keyId;

            /**
             * Sets the value of KeyId
             * @param keyId `CfnFunction.KeySAMPTProperty.KeyId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder keyId(java.lang.String keyId) {
                this.keyId = keyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeySAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public KeySAMPTProperty build() {
                return new Jsii$Proxy(keyId);
            }
        }

        /**
         * An implementation for {@link KeySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeySAMPTProperty {
            private final java.lang.String keyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.keyId = this.jsiiGet("keyId", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String keyId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.keyId = java.util.Objects.requireNonNull(keyId, "keyId is required");
            }

            @Override
            public java.lang.String getKeyId() {
                return this.keyId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("keyId", om.valueToTree(this.getKeyId()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KeySAMPTProperty.Jsii$Proxy that = (KeySAMPTProperty.Jsii$Proxy) o;

                return this.keyId.equals(that.keyId);
            }

            @Override
            public int hashCode() {
                int result = this.keyId.hashCode();
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface KinesisEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.KinesisEventProperty.StartingPosition`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStartingPosition();

        /**
         * `CfnFunction.KinesisEventProperty.Stream`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStream();

        /**
         * `CfnFunction.KinesisEventProperty.BatchSize`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getBatchSize();

        /**
         * `CfnFunction.KinesisEventProperty.Enabled`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link KinesisEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String startingPosition;
            private java.lang.String stream;
            private java.lang.Number batchSize;
            private java.lang.Object enabled;

            /**
             * Sets the value of StartingPosition
             * @param startingPosition `CfnFunction.KinesisEventProperty.StartingPosition`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder startingPosition(java.lang.String startingPosition) {
                this.startingPosition = startingPosition;
                return this;
            }

            /**
             * Sets the value of Stream
             * @param stream `CfnFunction.KinesisEventProperty.Stream`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder stream(java.lang.String stream) {
                this.stream = stream;
                return this;
            }

            /**
             * Sets the value of BatchSize
             * @param batchSize `CfnFunction.KinesisEventProperty.BatchSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder batchSize(java.lang.Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            /**
             * Sets the value of Enabled
             * @param enabled `CfnFunction.KinesisEventProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of Enabled
             * @param enabled `CfnFunction.KinesisEventProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public KinesisEventProperty build() {
                return new Jsii$Proxy(startingPosition, stream, batchSize, enabled);
            }
        }

        /**
         * An implementation for {@link KinesisEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisEventProperty {
            private final java.lang.String startingPosition;
            private final java.lang.String stream;
            private final java.lang.Number batchSize;
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.startingPosition = this.jsiiGet("startingPosition", java.lang.String.class);
                this.stream = this.jsiiGet("stream", java.lang.String.class);
                this.batchSize = this.jsiiGet("batchSize", java.lang.Number.class);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String startingPosition, java.lang.String stream, java.lang.Number batchSize, java.lang.Object enabled) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.startingPosition = java.util.Objects.requireNonNull(startingPosition, "startingPosition is required");
                this.stream = java.util.Objects.requireNonNull(stream, "stream is required");
                this.batchSize = batchSize;
                this.enabled = enabled;
            }

            @Override
            public java.lang.String getStartingPosition() {
                return this.startingPosition;
            }

            @Override
            public java.lang.String getStream() {
                return this.stream;
            }

            @Override
            public java.lang.Number getBatchSize() {
                return this.batchSize;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("startingPosition", om.valueToTree(this.getStartingPosition()));
                obj.set("stream", om.valueToTree(this.getStream()));
                if (this.getBatchSize() != null) {
                    obj.set("batchSize", om.valueToTree(this.getBatchSize()));
                }
                if (this.getEnabled() != null) {
                    obj.set("enabled", om.valueToTree(this.getEnabled()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisEventProperty.Jsii$Proxy that = (KinesisEventProperty.Jsii$Proxy) o;

                if (!startingPosition.equals(that.startingPosition)) return false;
                if (!stream.equals(that.stream)) return false;
                if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public int hashCode() {
                int result = this.startingPosition.hashCode();
                result = 31 * result + (this.stream.hashCode());
                result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface LogGroupSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.LogGroupSAMPTProperty.LogGroupName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getLogGroupName();

        /**
         * @return a {@link Builder} of {@link LogGroupSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogGroupSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String logGroupName;

            /**
             * Sets the value of LogGroupName
             * @param logGroupName `CfnFunction.LogGroupSAMPTProperty.LogGroupName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder logGroupName(java.lang.String logGroupName) {
                this.logGroupName = logGroupName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogGroupSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public LogGroupSAMPTProperty build() {
                return new Jsii$Proxy(logGroupName);
            }
        }

        /**
         * An implementation for {@link LogGroupSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogGroupSAMPTProperty {
            private final java.lang.String logGroupName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.logGroupName = this.jsiiGet("logGroupName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String logGroupName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logGroupName = java.util.Objects.requireNonNull(logGroupName, "logGroupName is required");
            }

            @Override
            public java.lang.String getLogGroupName() {
                return this.logGroupName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("logGroupName", om.valueToTree(this.getLogGroupName()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogGroupSAMPTProperty.Jsii$Proxy that = (LogGroupSAMPTProperty.Jsii$Proxy) o;

                return this.logGroupName.equals(that.logGroupName);
            }

            @Override
            public int hashCode() {
                int result = this.logGroupName.hashCode();
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface QueueSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.QueueSAMPTProperty.QueueName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getQueueName();

        /**
         * @return a {@link Builder} of {@link QueueSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueueSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String queueName;

            /**
             * Sets the value of QueueName
             * @param queueName `CfnFunction.QueueSAMPTProperty.QueueName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder queueName(java.lang.String queueName) {
                this.queueName = queueName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueueSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public QueueSAMPTProperty build() {
                return new Jsii$Proxy(queueName);
            }
        }

        /**
         * An implementation for {@link QueueSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueueSAMPTProperty {
            private final java.lang.String queueName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.queueName = this.jsiiGet("queueName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String queueName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.queueName = java.util.Objects.requireNonNull(queueName, "queueName is required");
            }

            @Override
            public java.lang.String getQueueName() {
                return this.queueName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("queueName", om.valueToTree(this.getQueueName()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueueSAMPTProperty.Jsii$Proxy that = (QueueSAMPTProperty.Jsii$Proxy) o;

                return this.queueName.equals(that.queueName);
            }

            @Override
            public int hashCode() {
                int result = this.queueName.hashCode();
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface S3EventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.S3EventProperty.Bucket`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getBucket();

        /**
         * `CfnFunction.S3EventProperty.Events`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEvents();

        /**
         * `CfnFunction.S3EventProperty.Filter`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getFilter();

        /**
         * @return a {@link Builder} of {@link S3EventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3EventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String bucket;
            private java.lang.Object events;
            private java.lang.Object filter;

            /**
             * Sets the value of Bucket
             * @param bucket `CfnFunction.S3EventProperty.Bucket`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of Events
             * @param events `CfnFunction.S3EventProperty.Events`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder events(java.lang.String events) {
                this.events = events;
                return this;
            }

            /**
             * Sets the value of Events
             * @param events `CfnFunction.S3EventProperty.Events`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder events(software.amazon.awscdk.core.IResolvable events) {
                this.events = events;
                return this;
            }

            /**
             * Sets the value of Events
             * @param events `CfnFunction.S3EventProperty.Events`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder events(java.util.List<java.lang.String> events) {
                this.events = events;
                return this;
            }

            /**
             * Sets the value of Filter
             * @param filter `CfnFunction.S3EventProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder filter(software.amazon.awscdk.core.IResolvable filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of Filter
             * @param filter `CfnFunction.S3EventProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder filter(software.amazon.awscdk.services.sam.CfnFunction.S3NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3EventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public S3EventProperty build() {
                return new Jsii$Proxy(bucket, events, filter);
            }
        }

        /**
         * An implementation for {@link S3EventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3EventProperty {
            private final java.lang.String bucket;
            private final java.lang.Object events;
            private final java.lang.Object filter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.bucket = this.jsiiGet("bucket", java.lang.String.class);
                this.events = this.jsiiGet("events", java.lang.Object.class);
                this.filter = this.jsiiGet("filter", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String bucket, java.lang.Object events, java.lang.Object filter) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(bucket, "bucket is required");
                this.events = java.util.Objects.requireNonNull(events, "events is required");
                this.filter = filter;
            }

            @Override
            public java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public java.lang.Object getEvents() {
                return this.events;
            }

            @Override
            public java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("bucket", om.valueToTree(this.getBucket()));
                obj.set("events", om.valueToTree(this.getEvents()));
                if (this.getFilter() != null) {
                    obj.set("filter", om.valueToTree(this.getFilter()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3EventProperty.Jsii$Proxy that = (S3EventProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (!events.equals(that.events)) return false;
                return this.filter != null ? this.filter.equals(that.filter) : that.filter == null;
            }

            @Override
            public int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.events.hashCode());
                result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3-location-object
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.S3LocationProperty.Bucket`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getBucket();

        /**
         * `CfnFunction.S3LocationProperty.Key`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKey();

        /**
         * `CfnFunction.S3LocationProperty.Version`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getVersion();

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String bucket;
            private java.lang.String key;
            private java.lang.Number version;

            /**
             * Sets the value of Bucket
             * @param bucket `CfnFunction.S3LocationProperty.Bucket`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of Key
             * @param key `CfnFunction.S3LocationProperty.Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of Version
             * @param version `CfnFunction.S3LocationProperty.Version`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder version(java.lang.Number version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public S3LocationProperty build() {
                return new Jsii$Proxy(bucket, key, version);
            }
        }

        /**
         * An implementation for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String key;
            private final java.lang.Number version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.bucket = this.jsiiGet("bucket", java.lang.String.class);
                this.key = this.jsiiGet("key", java.lang.String.class);
                this.version = this.jsiiGet("version", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String bucket, java.lang.String key, java.lang.Number version) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(bucket, "bucket is required");
                this.key = java.util.Objects.requireNonNull(key, "key is required");
                this.version = version;
            }

            @Override
            public java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public java.lang.String getKey() {
                return this.key;
            }

            @Override
            public java.lang.Number getVersion() {
                return this.version;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("bucket", om.valueToTree(this.getBucket()));
                obj.set("key", om.valueToTree(this.getKey()));
                if (this.getVersion() != null) {
                    obj.set("version", om.valueToTree(this.getVersion()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LocationProperty.Jsii$Proxy that = (S3LocationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (!key.equals(that.key)) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.key.hashCode());
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface S3NotificationFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.S3NotificationFilterProperty.S3Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getS3Key();

        /**
         * @return a {@link Builder} of {@link S3NotificationFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3NotificationFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String s3Key;

            /**
             * Sets the value of S3Key
             * @param s3Key `CfnFunction.S3NotificationFilterProperty.S3Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder s3Key(java.lang.String s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3NotificationFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public S3NotificationFilterProperty build() {
                return new Jsii$Proxy(s3Key);
            }
        }

        /**
         * An implementation for {@link S3NotificationFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3NotificationFilterProperty {
            private final java.lang.String s3Key;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.s3Key = this.jsiiGet("s3Key", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String s3Key) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Key = java.util.Objects.requireNonNull(s3Key, "s3Key is required");
            }

            @Override
            public java.lang.String getS3Key() {
                return this.s3Key;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("s3Key", om.valueToTree(this.getS3Key()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3NotificationFilterProperty.Jsii$Proxy that = (S3NotificationFilterProperty.Jsii$Proxy) o;

                return this.s3Key.equals(that.s3Key);
            }

            @Override
            public int hashCode() {
                int result = this.s3Key.hashCode();
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface SAMPolicyTemplateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.AMIDescribePolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getAmiDescribePolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.CloudFormationDescribeStacksPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getCloudFormationDescribeStacksPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.CloudWatchPutMetricPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getCloudWatchPutMetricPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.DynamoDBCrudPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getDynamoDbCrudPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.DynamoDBReadPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getDynamoDbReadPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.DynamoDBStreamReadPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getDynamoDbStreamReadPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.EC2DescribePolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEc2DescribePolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.ElasticsearchHttpPostPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getElasticsearchHttpPostPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.FilterLogEventsPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getFilterLogEventsPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.KinesisCrudPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getKinesisCrudPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.KinesisStreamReadPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getKinesisStreamReadPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.KMSDecryptPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getKmsDecryptPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.LambdaInvokePolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getLambdaInvokePolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionDetectOnlyPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRekognitionDetectOnlyPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionLabelsPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRekognitionLabelsPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionNoDataAccessPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRekognitionNoDataAccessPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionReadPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRekognitionReadPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionWriteOnlyAccessPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRekognitionWriteOnlyAccessPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.S3CrudPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getS3CrudPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.S3ReadPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getS3ReadPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESBulkTemplatedCrudPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSesBulkTemplatedCrudPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESCrudPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSesCrudPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESEmailTemplateCrudPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSesEmailTemplateCrudPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESSendBouncePolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSesSendBouncePolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SNSCrudPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSnsCrudPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SNSPublishMessagePolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSnsPublishMessagePolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SQSPollerPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSqsPollerPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SQSSendMessagePolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSqsSendMessagePolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.StepFunctionsExecutionPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getStepFunctionsExecutionPolicy();

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.VPCAccessPolicy`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getVpcAccessPolicy();

        /**
         * @return a {@link Builder} of {@link SAMPolicyTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SAMPolicyTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object amiDescribePolicy;
            private java.lang.Object cloudFormationDescribeStacksPolicy;
            private java.lang.Object cloudWatchPutMetricPolicy;
            private java.lang.Object dynamoDbCrudPolicy;
            private java.lang.Object dynamoDbReadPolicy;
            private java.lang.Object dynamoDbStreamReadPolicy;
            private java.lang.Object ec2DescribePolicy;
            private java.lang.Object elasticsearchHttpPostPolicy;
            private java.lang.Object filterLogEventsPolicy;
            private java.lang.Object kinesisCrudPolicy;
            private java.lang.Object kinesisStreamReadPolicy;
            private java.lang.Object kmsDecryptPolicy;
            private java.lang.Object lambdaInvokePolicy;
            private java.lang.Object rekognitionDetectOnlyPolicy;
            private java.lang.Object rekognitionLabelsPolicy;
            private java.lang.Object rekognitionNoDataAccessPolicy;
            private java.lang.Object rekognitionReadPolicy;
            private java.lang.Object rekognitionWriteOnlyAccessPolicy;
            private java.lang.Object s3CrudPolicy;
            private java.lang.Object s3ReadPolicy;
            private java.lang.Object sesBulkTemplatedCrudPolicy;
            private java.lang.Object sesCrudPolicy;
            private java.lang.Object sesEmailTemplateCrudPolicy;
            private java.lang.Object sesSendBouncePolicy;
            private java.lang.Object snsCrudPolicy;
            private java.lang.Object snsPublishMessagePolicy;
            private java.lang.Object sqsPollerPolicy;
            private java.lang.Object sqsSendMessagePolicy;
            private java.lang.Object stepFunctionsExecutionPolicy;
            private java.lang.Object vpcAccessPolicy;

            /**
             * Sets the value of AmiDescribePolicy
             * @param amiDescribePolicy `CfnFunction.SAMPolicyTemplateProperty.AMIDescribePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder amiDescribePolicy(software.amazon.awscdk.core.IResolvable amiDescribePolicy) {
                this.amiDescribePolicy = amiDescribePolicy;
                return this;
            }

            /**
             * Sets the value of AmiDescribePolicy
             * @param amiDescribePolicy `CfnFunction.SAMPolicyTemplateProperty.AMIDescribePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder amiDescribePolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty amiDescribePolicy) {
                this.amiDescribePolicy = amiDescribePolicy;
                return this;
            }

            /**
             * Sets the value of CloudFormationDescribeStacksPolicy
             * @param cloudFormationDescribeStacksPolicy `CfnFunction.SAMPolicyTemplateProperty.CloudFormationDescribeStacksPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cloudFormationDescribeStacksPolicy(software.amazon.awscdk.core.IResolvable cloudFormationDescribeStacksPolicy) {
                this.cloudFormationDescribeStacksPolicy = cloudFormationDescribeStacksPolicy;
                return this;
            }

            /**
             * Sets the value of CloudFormationDescribeStacksPolicy
             * @param cloudFormationDescribeStacksPolicy `CfnFunction.SAMPolicyTemplateProperty.CloudFormationDescribeStacksPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cloudFormationDescribeStacksPolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty cloudFormationDescribeStacksPolicy) {
                this.cloudFormationDescribeStacksPolicy = cloudFormationDescribeStacksPolicy;
                return this;
            }

            /**
             * Sets the value of CloudWatchPutMetricPolicy
             * @param cloudWatchPutMetricPolicy `CfnFunction.SAMPolicyTemplateProperty.CloudWatchPutMetricPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cloudWatchPutMetricPolicy(software.amazon.awscdk.core.IResolvable cloudWatchPutMetricPolicy) {
                this.cloudWatchPutMetricPolicy = cloudWatchPutMetricPolicy;
                return this;
            }

            /**
             * Sets the value of CloudWatchPutMetricPolicy
             * @param cloudWatchPutMetricPolicy `CfnFunction.SAMPolicyTemplateProperty.CloudWatchPutMetricPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cloudWatchPutMetricPolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty cloudWatchPutMetricPolicy) {
                this.cloudWatchPutMetricPolicy = cloudWatchPutMetricPolicy;
                return this;
            }

            /**
             * Sets the value of DynamoDbCrudPolicy
             * @param dynamoDbCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.DynamoDBCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder dynamoDbCrudPolicy(software.amazon.awscdk.core.IResolvable dynamoDbCrudPolicy) {
                this.dynamoDbCrudPolicy = dynamoDbCrudPolicy;
                return this;
            }

            /**
             * Sets the value of DynamoDbCrudPolicy
             * @param dynamoDbCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.DynamoDBCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder dynamoDbCrudPolicy(software.amazon.awscdk.services.sam.CfnFunction.TableSAMPTProperty dynamoDbCrudPolicy) {
                this.dynamoDbCrudPolicy = dynamoDbCrudPolicy;
                return this;
            }

            /**
             * Sets the value of DynamoDbReadPolicy
             * @param dynamoDbReadPolicy `CfnFunction.SAMPolicyTemplateProperty.DynamoDBReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder dynamoDbReadPolicy(software.amazon.awscdk.core.IResolvable dynamoDbReadPolicy) {
                this.dynamoDbReadPolicy = dynamoDbReadPolicy;
                return this;
            }

            /**
             * Sets the value of DynamoDbReadPolicy
             * @param dynamoDbReadPolicy `CfnFunction.SAMPolicyTemplateProperty.DynamoDBReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder dynamoDbReadPolicy(software.amazon.awscdk.services.sam.CfnFunction.TableSAMPTProperty dynamoDbReadPolicy) {
                this.dynamoDbReadPolicy = dynamoDbReadPolicy;
                return this;
            }

            /**
             * Sets the value of DynamoDbStreamReadPolicy
             * @param dynamoDbStreamReadPolicy `CfnFunction.SAMPolicyTemplateProperty.DynamoDBStreamReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder dynamoDbStreamReadPolicy(software.amazon.awscdk.core.IResolvable dynamoDbStreamReadPolicy) {
                this.dynamoDbStreamReadPolicy = dynamoDbStreamReadPolicy;
                return this;
            }

            /**
             * Sets the value of DynamoDbStreamReadPolicy
             * @param dynamoDbStreamReadPolicy `CfnFunction.SAMPolicyTemplateProperty.DynamoDBStreamReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder dynamoDbStreamReadPolicy(software.amazon.awscdk.services.sam.CfnFunction.TableStreamSAMPTProperty dynamoDbStreamReadPolicy) {
                this.dynamoDbStreamReadPolicy = dynamoDbStreamReadPolicy;
                return this;
            }

            /**
             * Sets the value of Ec2DescribePolicy
             * @param ec2DescribePolicy `CfnFunction.SAMPolicyTemplateProperty.EC2DescribePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ec2DescribePolicy(software.amazon.awscdk.core.IResolvable ec2DescribePolicy) {
                this.ec2DescribePolicy = ec2DescribePolicy;
                return this;
            }

            /**
             * Sets the value of Ec2DescribePolicy
             * @param ec2DescribePolicy `CfnFunction.SAMPolicyTemplateProperty.EC2DescribePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ec2DescribePolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty ec2DescribePolicy) {
                this.ec2DescribePolicy = ec2DescribePolicy;
                return this;
            }

            /**
             * Sets the value of ElasticsearchHttpPostPolicy
             * @param elasticsearchHttpPostPolicy `CfnFunction.SAMPolicyTemplateProperty.ElasticsearchHttpPostPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder elasticsearchHttpPostPolicy(software.amazon.awscdk.core.IResolvable elasticsearchHttpPostPolicy) {
                this.elasticsearchHttpPostPolicy = elasticsearchHttpPostPolicy;
                return this;
            }

            /**
             * Sets the value of ElasticsearchHttpPostPolicy
             * @param elasticsearchHttpPostPolicy `CfnFunction.SAMPolicyTemplateProperty.ElasticsearchHttpPostPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder elasticsearchHttpPostPolicy(software.amazon.awscdk.services.sam.CfnFunction.DomainSAMPTProperty elasticsearchHttpPostPolicy) {
                this.elasticsearchHttpPostPolicy = elasticsearchHttpPostPolicy;
                return this;
            }

            /**
             * Sets the value of FilterLogEventsPolicy
             * @param filterLogEventsPolicy `CfnFunction.SAMPolicyTemplateProperty.FilterLogEventsPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder filterLogEventsPolicy(software.amazon.awscdk.core.IResolvable filterLogEventsPolicy) {
                this.filterLogEventsPolicy = filterLogEventsPolicy;
                return this;
            }

            /**
             * Sets the value of FilterLogEventsPolicy
             * @param filterLogEventsPolicy `CfnFunction.SAMPolicyTemplateProperty.FilterLogEventsPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder filterLogEventsPolicy(software.amazon.awscdk.services.sam.CfnFunction.LogGroupSAMPTProperty filterLogEventsPolicy) {
                this.filterLogEventsPolicy = filterLogEventsPolicy;
                return this;
            }

            /**
             * Sets the value of KinesisCrudPolicy
             * @param kinesisCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.KinesisCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kinesisCrudPolicy(software.amazon.awscdk.core.IResolvable kinesisCrudPolicy) {
                this.kinesisCrudPolicy = kinesisCrudPolicy;
                return this;
            }

            /**
             * Sets the value of KinesisCrudPolicy
             * @param kinesisCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.KinesisCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kinesisCrudPolicy(software.amazon.awscdk.services.sam.CfnFunction.StreamSAMPTProperty kinesisCrudPolicy) {
                this.kinesisCrudPolicy = kinesisCrudPolicy;
                return this;
            }

            /**
             * Sets the value of KinesisStreamReadPolicy
             * @param kinesisStreamReadPolicy `CfnFunction.SAMPolicyTemplateProperty.KinesisStreamReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kinesisStreamReadPolicy(software.amazon.awscdk.core.IResolvable kinesisStreamReadPolicy) {
                this.kinesisStreamReadPolicy = kinesisStreamReadPolicy;
                return this;
            }

            /**
             * Sets the value of KinesisStreamReadPolicy
             * @param kinesisStreamReadPolicy `CfnFunction.SAMPolicyTemplateProperty.KinesisStreamReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kinesisStreamReadPolicy(software.amazon.awscdk.services.sam.CfnFunction.StreamSAMPTProperty kinesisStreamReadPolicy) {
                this.kinesisStreamReadPolicy = kinesisStreamReadPolicy;
                return this;
            }

            /**
             * Sets the value of KmsDecryptPolicy
             * @param kmsDecryptPolicy `CfnFunction.SAMPolicyTemplateProperty.KMSDecryptPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kmsDecryptPolicy(software.amazon.awscdk.core.IResolvable kmsDecryptPolicy) {
                this.kmsDecryptPolicy = kmsDecryptPolicy;
                return this;
            }

            /**
             * Sets the value of KmsDecryptPolicy
             * @param kmsDecryptPolicy `CfnFunction.SAMPolicyTemplateProperty.KMSDecryptPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kmsDecryptPolicy(software.amazon.awscdk.services.sam.CfnFunction.KeySAMPTProperty kmsDecryptPolicy) {
                this.kmsDecryptPolicy = kmsDecryptPolicy;
                return this;
            }

            /**
             * Sets the value of LambdaInvokePolicy
             * @param lambdaInvokePolicy `CfnFunction.SAMPolicyTemplateProperty.LambdaInvokePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder lambdaInvokePolicy(software.amazon.awscdk.core.IResolvable lambdaInvokePolicy) {
                this.lambdaInvokePolicy = lambdaInvokePolicy;
                return this;
            }

            /**
             * Sets the value of LambdaInvokePolicy
             * @param lambdaInvokePolicy `CfnFunction.SAMPolicyTemplateProperty.LambdaInvokePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder lambdaInvokePolicy(software.amazon.awscdk.services.sam.CfnFunction.FunctionSAMPTProperty lambdaInvokePolicy) {
                this.lambdaInvokePolicy = lambdaInvokePolicy;
                return this;
            }

            /**
             * Sets the value of RekognitionDetectOnlyPolicy
             * @param rekognitionDetectOnlyPolicy `CfnFunction.SAMPolicyTemplateProperty.RekognitionDetectOnlyPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder rekognitionDetectOnlyPolicy(software.amazon.awscdk.core.IResolvable rekognitionDetectOnlyPolicy) {
                this.rekognitionDetectOnlyPolicy = rekognitionDetectOnlyPolicy;
                return this;
            }

            /**
             * Sets the value of RekognitionDetectOnlyPolicy
             * @param rekognitionDetectOnlyPolicy `CfnFunction.SAMPolicyTemplateProperty.RekognitionDetectOnlyPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder rekognitionDetectOnlyPolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty rekognitionDetectOnlyPolicy) {
                this.rekognitionDetectOnlyPolicy = rekognitionDetectOnlyPolicy;
                return this;
            }

            /**
             * Sets the value of RekognitionLabelsPolicy
             * @param rekognitionLabelsPolicy `CfnFunction.SAMPolicyTemplateProperty.RekognitionLabelsPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder rekognitionLabelsPolicy(software.amazon.awscdk.core.IResolvable rekognitionLabelsPolicy) {
                this.rekognitionLabelsPolicy = rekognitionLabelsPolicy;
                return this;
            }

            /**
             * Sets the value of RekognitionLabelsPolicy
             * @param rekognitionLabelsPolicy `CfnFunction.SAMPolicyTemplateProperty.RekognitionLabelsPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder rekognitionLabelsPolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty rekognitionLabelsPolicy) {
                this.rekognitionLabelsPolicy = rekognitionLabelsPolicy;
                return this;
            }

            /**
             * Sets the value of RekognitionNoDataAccessPolicy
             * @param rekognitionNoDataAccessPolicy `CfnFunction.SAMPolicyTemplateProperty.RekognitionNoDataAccessPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder rekognitionNoDataAccessPolicy(software.amazon.awscdk.core.IResolvable rekognitionNoDataAccessPolicy) {
                this.rekognitionNoDataAccessPolicy = rekognitionNoDataAccessPolicy;
                return this;
            }

            /**
             * Sets the value of RekognitionNoDataAccessPolicy
             * @param rekognitionNoDataAccessPolicy `CfnFunction.SAMPolicyTemplateProperty.RekognitionNoDataAccessPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder rekognitionNoDataAccessPolicy(software.amazon.awscdk.services.sam.CfnFunction.CollectionSAMPTProperty rekognitionNoDataAccessPolicy) {
                this.rekognitionNoDataAccessPolicy = rekognitionNoDataAccessPolicy;
                return this;
            }

            /**
             * Sets the value of RekognitionReadPolicy
             * @param rekognitionReadPolicy `CfnFunction.SAMPolicyTemplateProperty.RekognitionReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder rekognitionReadPolicy(software.amazon.awscdk.core.IResolvable rekognitionReadPolicy) {
                this.rekognitionReadPolicy = rekognitionReadPolicy;
                return this;
            }

            /**
             * Sets the value of RekognitionReadPolicy
             * @param rekognitionReadPolicy `CfnFunction.SAMPolicyTemplateProperty.RekognitionReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder rekognitionReadPolicy(software.amazon.awscdk.services.sam.CfnFunction.CollectionSAMPTProperty rekognitionReadPolicy) {
                this.rekognitionReadPolicy = rekognitionReadPolicy;
                return this;
            }

            /**
             * Sets the value of RekognitionWriteOnlyAccessPolicy
             * @param rekognitionWriteOnlyAccessPolicy `CfnFunction.SAMPolicyTemplateProperty.RekognitionWriteOnlyAccessPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder rekognitionWriteOnlyAccessPolicy(software.amazon.awscdk.core.IResolvable rekognitionWriteOnlyAccessPolicy) {
                this.rekognitionWriteOnlyAccessPolicy = rekognitionWriteOnlyAccessPolicy;
                return this;
            }

            /**
             * Sets the value of RekognitionWriteOnlyAccessPolicy
             * @param rekognitionWriteOnlyAccessPolicy `CfnFunction.SAMPolicyTemplateProperty.RekognitionWriteOnlyAccessPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder rekognitionWriteOnlyAccessPolicy(software.amazon.awscdk.services.sam.CfnFunction.CollectionSAMPTProperty rekognitionWriteOnlyAccessPolicy) {
                this.rekognitionWriteOnlyAccessPolicy = rekognitionWriteOnlyAccessPolicy;
                return this;
            }

            /**
             * Sets the value of S3CrudPolicy
             * @param s3CrudPolicy `CfnFunction.SAMPolicyTemplateProperty.S3CrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder s3CrudPolicy(software.amazon.awscdk.core.IResolvable s3CrudPolicy) {
                this.s3CrudPolicy = s3CrudPolicy;
                return this;
            }

            /**
             * Sets the value of S3CrudPolicy
             * @param s3CrudPolicy `CfnFunction.SAMPolicyTemplateProperty.S3CrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder s3CrudPolicy(software.amazon.awscdk.services.sam.CfnFunction.BucketSAMPTProperty s3CrudPolicy) {
                this.s3CrudPolicy = s3CrudPolicy;
                return this;
            }

            /**
             * Sets the value of S3ReadPolicy
             * @param s3ReadPolicy `CfnFunction.SAMPolicyTemplateProperty.S3ReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder s3ReadPolicy(software.amazon.awscdk.core.IResolvable s3ReadPolicy) {
                this.s3ReadPolicy = s3ReadPolicy;
                return this;
            }

            /**
             * Sets the value of S3ReadPolicy
             * @param s3ReadPolicy `CfnFunction.SAMPolicyTemplateProperty.S3ReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder s3ReadPolicy(software.amazon.awscdk.services.sam.CfnFunction.BucketSAMPTProperty s3ReadPolicy) {
                this.s3ReadPolicy = s3ReadPolicy;
                return this;
            }

            /**
             * Sets the value of SesBulkTemplatedCrudPolicy
             * @param sesBulkTemplatedCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.SESBulkTemplatedCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sesBulkTemplatedCrudPolicy(software.amazon.awscdk.core.IResolvable sesBulkTemplatedCrudPolicy) {
                this.sesBulkTemplatedCrudPolicy = sesBulkTemplatedCrudPolicy;
                return this;
            }

            /**
             * Sets the value of SesBulkTemplatedCrudPolicy
             * @param sesBulkTemplatedCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.SESBulkTemplatedCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sesBulkTemplatedCrudPolicy(software.amazon.awscdk.services.sam.CfnFunction.IdentitySAMPTProperty sesBulkTemplatedCrudPolicy) {
                this.sesBulkTemplatedCrudPolicy = sesBulkTemplatedCrudPolicy;
                return this;
            }

            /**
             * Sets the value of SesCrudPolicy
             * @param sesCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.SESCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sesCrudPolicy(software.amazon.awscdk.core.IResolvable sesCrudPolicy) {
                this.sesCrudPolicy = sesCrudPolicy;
                return this;
            }

            /**
             * Sets the value of SesCrudPolicy
             * @param sesCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.SESCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sesCrudPolicy(software.amazon.awscdk.services.sam.CfnFunction.IdentitySAMPTProperty sesCrudPolicy) {
                this.sesCrudPolicy = sesCrudPolicy;
                return this;
            }

            /**
             * Sets the value of SesEmailTemplateCrudPolicy
             * @param sesEmailTemplateCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.SESEmailTemplateCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sesEmailTemplateCrudPolicy(software.amazon.awscdk.core.IResolvable sesEmailTemplateCrudPolicy) {
                this.sesEmailTemplateCrudPolicy = sesEmailTemplateCrudPolicy;
                return this;
            }

            /**
             * Sets the value of SesEmailTemplateCrudPolicy
             * @param sesEmailTemplateCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.SESEmailTemplateCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sesEmailTemplateCrudPolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty sesEmailTemplateCrudPolicy) {
                this.sesEmailTemplateCrudPolicy = sesEmailTemplateCrudPolicy;
                return this;
            }

            /**
             * Sets the value of SesSendBouncePolicy
             * @param sesSendBouncePolicy `CfnFunction.SAMPolicyTemplateProperty.SESSendBouncePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sesSendBouncePolicy(software.amazon.awscdk.core.IResolvable sesSendBouncePolicy) {
                this.sesSendBouncePolicy = sesSendBouncePolicy;
                return this;
            }

            /**
             * Sets the value of SesSendBouncePolicy
             * @param sesSendBouncePolicy `CfnFunction.SAMPolicyTemplateProperty.SESSendBouncePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sesSendBouncePolicy(software.amazon.awscdk.services.sam.CfnFunction.IdentitySAMPTProperty sesSendBouncePolicy) {
                this.sesSendBouncePolicy = sesSendBouncePolicy;
                return this;
            }

            /**
             * Sets the value of SnsCrudPolicy
             * @param snsCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.SNSCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder snsCrudPolicy(software.amazon.awscdk.core.IResolvable snsCrudPolicy) {
                this.snsCrudPolicy = snsCrudPolicy;
                return this;
            }

            /**
             * Sets the value of SnsCrudPolicy
             * @param snsCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.SNSCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder snsCrudPolicy(software.amazon.awscdk.services.sam.CfnFunction.TopicSAMPTProperty snsCrudPolicy) {
                this.snsCrudPolicy = snsCrudPolicy;
                return this;
            }

            /**
             * Sets the value of SnsPublishMessagePolicy
             * @param snsPublishMessagePolicy `CfnFunction.SAMPolicyTemplateProperty.SNSPublishMessagePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder snsPublishMessagePolicy(software.amazon.awscdk.core.IResolvable snsPublishMessagePolicy) {
                this.snsPublishMessagePolicy = snsPublishMessagePolicy;
                return this;
            }

            /**
             * Sets the value of SnsPublishMessagePolicy
             * @param snsPublishMessagePolicy `CfnFunction.SAMPolicyTemplateProperty.SNSPublishMessagePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder snsPublishMessagePolicy(software.amazon.awscdk.services.sam.CfnFunction.TopicSAMPTProperty snsPublishMessagePolicy) {
                this.snsPublishMessagePolicy = snsPublishMessagePolicy;
                return this;
            }

            /**
             * Sets the value of SqsPollerPolicy
             * @param sqsPollerPolicy `CfnFunction.SAMPolicyTemplateProperty.SQSPollerPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sqsPollerPolicy(software.amazon.awscdk.core.IResolvable sqsPollerPolicy) {
                this.sqsPollerPolicy = sqsPollerPolicy;
                return this;
            }

            /**
             * Sets the value of SqsPollerPolicy
             * @param sqsPollerPolicy `CfnFunction.SAMPolicyTemplateProperty.SQSPollerPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sqsPollerPolicy(software.amazon.awscdk.services.sam.CfnFunction.QueueSAMPTProperty sqsPollerPolicy) {
                this.sqsPollerPolicy = sqsPollerPolicy;
                return this;
            }

            /**
             * Sets the value of SqsSendMessagePolicy
             * @param sqsSendMessagePolicy `CfnFunction.SAMPolicyTemplateProperty.SQSSendMessagePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sqsSendMessagePolicy(software.amazon.awscdk.core.IResolvable sqsSendMessagePolicy) {
                this.sqsSendMessagePolicy = sqsSendMessagePolicy;
                return this;
            }

            /**
             * Sets the value of SqsSendMessagePolicy
             * @param sqsSendMessagePolicy `CfnFunction.SAMPolicyTemplateProperty.SQSSendMessagePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sqsSendMessagePolicy(software.amazon.awscdk.services.sam.CfnFunction.QueueSAMPTProperty sqsSendMessagePolicy) {
                this.sqsSendMessagePolicy = sqsSendMessagePolicy;
                return this;
            }

            /**
             * Sets the value of StepFunctionsExecutionPolicy
             * @param stepFunctionsExecutionPolicy `CfnFunction.SAMPolicyTemplateProperty.StepFunctionsExecutionPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder stepFunctionsExecutionPolicy(software.amazon.awscdk.core.IResolvable stepFunctionsExecutionPolicy) {
                this.stepFunctionsExecutionPolicy = stepFunctionsExecutionPolicy;
                return this;
            }

            /**
             * Sets the value of StepFunctionsExecutionPolicy
             * @param stepFunctionsExecutionPolicy `CfnFunction.SAMPolicyTemplateProperty.StepFunctionsExecutionPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder stepFunctionsExecutionPolicy(software.amazon.awscdk.services.sam.CfnFunction.StateMachineSAMPTProperty stepFunctionsExecutionPolicy) {
                this.stepFunctionsExecutionPolicy = stepFunctionsExecutionPolicy;
                return this;
            }

            /**
             * Sets the value of VpcAccessPolicy
             * @param vpcAccessPolicy `CfnFunction.SAMPolicyTemplateProperty.VPCAccessPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder vpcAccessPolicy(software.amazon.awscdk.core.IResolvable vpcAccessPolicy) {
                this.vpcAccessPolicy = vpcAccessPolicy;
                return this;
            }

            /**
             * Sets the value of VpcAccessPolicy
             * @param vpcAccessPolicy `CfnFunction.SAMPolicyTemplateProperty.VPCAccessPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder vpcAccessPolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty vpcAccessPolicy) {
                this.vpcAccessPolicy = vpcAccessPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SAMPolicyTemplateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public SAMPolicyTemplateProperty build() {
                return new Jsii$Proxy(amiDescribePolicy, cloudFormationDescribeStacksPolicy, cloudWatchPutMetricPolicy, dynamoDbCrudPolicy, dynamoDbReadPolicy, dynamoDbStreamReadPolicy, ec2DescribePolicy, elasticsearchHttpPostPolicy, filterLogEventsPolicy, kinesisCrudPolicy, kinesisStreamReadPolicy, kmsDecryptPolicy, lambdaInvokePolicy, rekognitionDetectOnlyPolicy, rekognitionLabelsPolicy, rekognitionNoDataAccessPolicy, rekognitionReadPolicy, rekognitionWriteOnlyAccessPolicy, s3CrudPolicy, s3ReadPolicy, sesBulkTemplatedCrudPolicy, sesCrudPolicy, sesEmailTemplateCrudPolicy, sesSendBouncePolicy, snsCrudPolicy, snsPublishMessagePolicy, sqsPollerPolicy, sqsSendMessagePolicy, stepFunctionsExecutionPolicy, vpcAccessPolicy);
            }
        }

        /**
         * An implementation for {@link SAMPolicyTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SAMPolicyTemplateProperty {
            private final java.lang.Object amiDescribePolicy;
            private final java.lang.Object cloudFormationDescribeStacksPolicy;
            private final java.lang.Object cloudWatchPutMetricPolicy;
            private final java.lang.Object dynamoDbCrudPolicy;
            private final java.lang.Object dynamoDbReadPolicy;
            private final java.lang.Object dynamoDbStreamReadPolicy;
            private final java.lang.Object ec2DescribePolicy;
            private final java.lang.Object elasticsearchHttpPostPolicy;
            private final java.lang.Object filterLogEventsPolicy;
            private final java.lang.Object kinesisCrudPolicy;
            private final java.lang.Object kinesisStreamReadPolicy;
            private final java.lang.Object kmsDecryptPolicy;
            private final java.lang.Object lambdaInvokePolicy;
            private final java.lang.Object rekognitionDetectOnlyPolicy;
            private final java.lang.Object rekognitionLabelsPolicy;
            private final java.lang.Object rekognitionNoDataAccessPolicy;
            private final java.lang.Object rekognitionReadPolicy;
            private final java.lang.Object rekognitionWriteOnlyAccessPolicy;
            private final java.lang.Object s3CrudPolicy;
            private final java.lang.Object s3ReadPolicy;
            private final java.lang.Object sesBulkTemplatedCrudPolicy;
            private final java.lang.Object sesCrudPolicy;
            private final java.lang.Object sesEmailTemplateCrudPolicy;
            private final java.lang.Object sesSendBouncePolicy;
            private final java.lang.Object snsCrudPolicy;
            private final java.lang.Object snsPublishMessagePolicy;
            private final java.lang.Object sqsPollerPolicy;
            private final java.lang.Object sqsSendMessagePolicy;
            private final java.lang.Object stepFunctionsExecutionPolicy;
            private final java.lang.Object vpcAccessPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.amiDescribePolicy = this.jsiiGet("amiDescribePolicy", java.lang.Object.class);
                this.cloudFormationDescribeStacksPolicy = this.jsiiGet("cloudFormationDescribeStacksPolicy", java.lang.Object.class);
                this.cloudWatchPutMetricPolicy = this.jsiiGet("cloudWatchPutMetricPolicy", java.lang.Object.class);
                this.dynamoDbCrudPolicy = this.jsiiGet("dynamoDbCrudPolicy", java.lang.Object.class);
                this.dynamoDbReadPolicy = this.jsiiGet("dynamoDbReadPolicy", java.lang.Object.class);
                this.dynamoDbStreamReadPolicy = this.jsiiGet("dynamoDbStreamReadPolicy", java.lang.Object.class);
                this.ec2DescribePolicy = this.jsiiGet("ec2DescribePolicy", java.lang.Object.class);
                this.elasticsearchHttpPostPolicy = this.jsiiGet("elasticsearchHttpPostPolicy", java.lang.Object.class);
                this.filterLogEventsPolicy = this.jsiiGet("filterLogEventsPolicy", java.lang.Object.class);
                this.kinesisCrudPolicy = this.jsiiGet("kinesisCrudPolicy", java.lang.Object.class);
                this.kinesisStreamReadPolicy = this.jsiiGet("kinesisStreamReadPolicy", java.lang.Object.class);
                this.kmsDecryptPolicy = this.jsiiGet("kmsDecryptPolicy", java.lang.Object.class);
                this.lambdaInvokePolicy = this.jsiiGet("lambdaInvokePolicy", java.lang.Object.class);
                this.rekognitionDetectOnlyPolicy = this.jsiiGet("rekognitionDetectOnlyPolicy", java.lang.Object.class);
                this.rekognitionLabelsPolicy = this.jsiiGet("rekognitionLabelsPolicy", java.lang.Object.class);
                this.rekognitionNoDataAccessPolicy = this.jsiiGet("rekognitionNoDataAccessPolicy", java.lang.Object.class);
                this.rekognitionReadPolicy = this.jsiiGet("rekognitionReadPolicy", java.lang.Object.class);
                this.rekognitionWriteOnlyAccessPolicy = this.jsiiGet("rekognitionWriteOnlyAccessPolicy", java.lang.Object.class);
                this.s3CrudPolicy = this.jsiiGet("s3CrudPolicy", java.lang.Object.class);
                this.s3ReadPolicy = this.jsiiGet("s3ReadPolicy", java.lang.Object.class);
                this.sesBulkTemplatedCrudPolicy = this.jsiiGet("sesBulkTemplatedCrudPolicy", java.lang.Object.class);
                this.sesCrudPolicy = this.jsiiGet("sesCrudPolicy", java.lang.Object.class);
                this.sesEmailTemplateCrudPolicy = this.jsiiGet("sesEmailTemplateCrudPolicy", java.lang.Object.class);
                this.sesSendBouncePolicy = this.jsiiGet("sesSendBouncePolicy", java.lang.Object.class);
                this.snsCrudPolicy = this.jsiiGet("snsCrudPolicy", java.lang.Object.class);
                this.snsPublishMessagePolicy = this.jsiiGet("snsPublishMessagePolicy", java.lang.Object.class);
                this.sqsPollerPolicy = this.jsiiGet("sqsPollerPolicy", java.lang.Object.class);
                this.sqsSendMessagePolicy = this.jsiiGet("sqsSendMessagePolicy", java.lang.Object.class);
                this.stepFunctionsExecutionPolicy = this.jsiiGet("stepFunctionsExecutionPolicy", java.lang.Object.class);
                this.vpcAccessPolicy = this.jsiiGet("vpcAccessPolicy", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object amiDescribePolicy, java.lang.Object cloudFormationDescribeStacksPolicy, java.lang.Object cloudWatchPutMetricPolicy, java.lang.Object dynamoDbCrudPolicy, java.lang.Object dynamoDbReadPolicy, java.lang.Object dynamoDbStreamReadPolicy, java.lang.Object ec2DescribePolicy, java.lang.Object elasticsearchHttpPostPolicy, java.lang.Object filterLogEventsPolicy, java.lang.Object kinesisCrudPolicy, java.lang.Object kinesisStreamReadPolicy, java.lang.Object kmsDecryptPolicy, java.lang.Object lambdaInvokePolicy, java.lang.Object rekognitionDetectOnlyPolicy, java.lang.Object rekognitionLabelsPolicy, java.lang.Object rekognitionNoDataAccessPolicy, java.lang.Object rekognitionReadPolicy, java.lang.Object rekognitionWriteOnlyAccessPolicy, java.lang.Object s3CrudPolicy, java.lang.Object s3ReadPolicy, java.lang.Object sesBulkTemplatedCrudPolicy, java.lang.Object sesCrudPolicy, java.lang.Object sesEmailTemplateCrudPolicy, java.lang.Object sesSendBouncePolicy, java.lang.Object snsCrudPolicy, java.lang.Object snsPublishMessagePolicy, java.lang.Object sqsPollerPolicy, java.lang.Object sqsSendMessagePolicy, java.lang.Object stepFunctionsExecutionPolicy, java.lang.Object vpcAccessPolicy) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.amiDescribePolicy = amiDescribePolicy;
                this.cloudFormationDescribeStacksPolicy = cloudFormationDescribeStacksPolicy;
                this.cloudWatchPutMetricPolicy = cloudWatchPutMetricPolicy;
                this.dynamoDbCrudPolicy = dynamoDbCrudPolicy;
                this.dynamoDbReadPolicy = dynamoDbReadPolicy;
                this.dynamoDbStreamReadPolicy = dynamoDbStreamReadPolicy;
                this.ec2DescribePolicy = ec2DescribePolicy;
                this.elasticsearchHttpPostPolicy = elasticsearchHttpPostPolicy;
                this.filterLogEventsPolicy = filterLogEventsPolicy;
                this.kinesisCrudPolicy = kinesisCrudPolicy;
                this.kinesisStreamReadPolicy = kinesisStreamReadPolicy;
                this.kmsDecryptPolicy = kmsDecryptPolicy;
                this.lambdaInvokePolicy = lambdaInvokePolicy;
                this.rekognitionDetectOnlyPolicy = rekognitionDetectOnlyPolicy;
                this.rekognitionLabelsPolicy = rekognitionLabelsPolicy;
                this.rekognitionNoDataAccessPolicy = rekognitionNoDataAccessPolicy;
                this.rekognitionReadPolicy = rekognitionReadPolicy;
                this.rekognitionWriteOnlyAccessPolicy = rekognitionWriteOnlyAccessPolicy;
                this.s3CrudPolicy = s3CrudPolicy;
                this.s3ReadPolicy = s3ReadPolicy;
                this.sesBulkTemplatedCrudPolicy = sesBulkTemplatedCrudPolicy;
                this.sesCrudPolicy = sesCrudPolicy;
                this.sesEmailTemplateCrudPolicy = sesEmailTemplateCrudPolicy;
                this.sesSendBouncePolicy = sesSendBouncePolicy;
                this.snsCrudPolicy = snsCrudPolicy;
                this.snsPublishMessagePolicy = snsPublishMessagePolicy;
                this.sqsPollerPolicy = sqsPollerPolicy;
                this.sqsSendMessagePolicy = sqsSendMessagePolicy;
                this.stepFunctionsExecutionPolicy = stepFunctionsExecutionPolicy;
                this.vpcAccessPolicy = vpcAccessPolicy;
            }

            @Override
            public java.lang.Object getAmiDescribePolicy() {
                return this.amiDescribePolicy;
            }

            @Override
            public java.lang.Object getCloudFormationDescribeStacksPolicy() {
                return this.cloudFormationDescribeStacksPolicy;
            }

            @Override
            public java.lang.Object getCloudWatchPutMetricPolicy() {
                return this.cloudWatchPutMetricPolicy;
            }

            @Override
            public java.lang.Object getDynamoDbCrudPolicy() {
                return this.dynamoDbCrudPolicy;
            }

            @Override
            public java.lang.Object getDynamoDbReadPolicy() {
                return this.dynamoDbReadPolicy;
            }

            @Override
            public java.lang.Object getDynamoDbStreamReadPolicy() {
                return this.dynamoDbStreamReadPolicy;
            }

            @Override
            public java.lang.Object getEc2DescribePolicy() {
                return this.ec2DescribePolicy;
            }

            @Override
            public java.lang.Object getElasticsearchHttpPostPolicy() {
                return this.elasticsearchHttpPostPolicy;
            }

            @Override
            public java.lang.Object getFilterLogEventsPolicy() {
                return this.filterLogEventsPolicy;
            }

            @Override
            public java.lang.Object getKinesisCrudPolicy() {
                return this.kinesisCrudPolicy;
            }

            @Override
            public java.lang.Object getKinesisStreamReadPolicy() {
                return this.kinesisStreamReadPolicy;
            }

            @Override
            public java.lang.Object getKmsDecryptPolicy() {
                return this.kmsDecryptPolicy;
            }

            @Override
            public java.lang.Object getLambdaInvokePolicy() {
                return this.lambdaInvokePolicy;
            }

            @Override
            public java.lang.Object getRekognitionDetectOnlyPolicy() {
                return this.rekognitionDetectOnlyPolicy;
            }

            @Override
            public java.lang.Object getRekognitionLabelsPolicy() {
                return this.rekognitionLabelsPolicy;
            }

            @Override
            public java.lang.Object getRekognitionNoDataAccessPolicy() {
                return this.rekognitionNoDataAccessPolicy;
            }

            @Override
            public java.lang.Object getRekognitionReadPolicy() {
                return this.rekognitionReadPolicy;
            }

            @Override
            public java.lang.Object getRekognitionWriteOnlyAccessPolicy() {
                return this.rekognitionWriteOnlyAccessPolicy;
            }

            @Override
            public java.lang.Object getS3CrudPolicy() {
                return this.s3CrudPolicy;
            }

            @Override
            public java.lang.Object getS3ReadPolicy() {
                return this.s3ReadPolicy;
            }

            @Override
            public java.lang.Object getSesBulkTemplatedCrudPolicy() {
                return this.sesBulkTemplatedCrudPolicy;
            }

            @Override
            public java.lang.Object getSesCrudPolicy() {
                return this.sesCrudPolicy;
            }

            @Override
            public java.lang.Object getSesEmailTemplateCrudPolicy() {
                return this.sesEmailTemplateCrudPolicy;
            }

            @Override
            public java.lang.Object getSesSendBouncePolicy() {
                return this.sesSendBouncePolicy;
            }

            @Override
            public java.lang.Object getSnsCrudPolicy() {
                return this.snsCrudPolicy;
            }

            @Override
            public java.lang.Object getSnsPublishMessagePolicy() {
                return this.snsPublishMessagePolicy;
            }

            @Override
            public java.lang.Object getSqsPollerPolicy() {
                return this.sqsPollerPolicy;
            }

            @Override
            public java.lang.Object getSqsSendMessagePolicy() {
                return this.sqsSendMessagePolicy;
            }

            @Override
            public java.lang.Object getStepFunctionsExecutionPolicy() {
                return this.stepFunctionsExecutionPolicy;
            }

            @Override
            public java.lang.Object getVpcAccessPolicy() {
                return this.vpcAccessPolicy;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getAmiDescribePolicy() != null) {
                    obj.set("amiDescribePolicy", om.valueToTree(this.getAmiDescribePolicy()));
                }
                if (this.getCloudFormationDescribeStacksPolicy() != null) {
                    obj.set("cloudFormationDescribeStacksPolicy", om.valueToTree(this.getCloudFormationDescribeStacksPolicy()));
                }
                if (this.getCloudWatchPutMetricPolicy() != null) {
                    obj.set("cloudWatchPutMetricPolicy", om.valueToTree(this.getCloudWatchPutMetricPolicy()));
                }
                if (this.getDynamoDbCrudPolicy() != null) {
                    obj.set("dynamoDbCrudPolicy", om.valueToTree(this.getDynamoDbCrudPolicy()));
                }
                if (this.getDynamoDbReadPolicy() != null) {
                    obj.set("dynamoDbReadPolicy", om.valueToTree(this.getDynamoDbReadPolicy()));
                }
                if (this.getDynamoDbStreamReadPolicy() != null) {
                    obj.set("dynamoDbStreamReadPolicy", om.valueToTree(this.getDynamoDbStreamReadPolicy()));
                }
                if (this.getEc2DescribePolicy() != null) {
                    obj.set("ec2DescribePolicy", om.valueToTree(this.getEc2DescribePolicy()));
                }
                if (this.getElasticsearchHttpPostPolicy() != null) {
                    obj.set("elasticsearchHttpPostPolicy", om.valueToTree(this.getElasticsearchHttpPostPolicy()));
                }
                if (this.getFilterLogEventsPolicy() != null) {
                    obj.set("filterLogEventsPolicy", om.valueToTree(this.getFilterLogEventsPolicy()));
                }
                if (this.getKinesisCrudPolicy() != null) {
                    obj.set("kinesisCrudPolicy", om.valueToTree(this.getKinesisCrudPolicy()));
                }
                if (this.getKinesisStreamReadPolicy() != null) {
                    obj.set("kinesisStreamReadPolicy", om.valueToTree(this.getKinesisStreamReadPolicy()));
                }
                if (this.getKmsDecryptPolicy() != null) {
                    obj.set("kmsDecryptPolicy", om.valueToTree(this.getKmsDecryptPolicy()));
                }
                if (this.getLambdaInvokePolicy() != null) {
                    obj.set("lambdaInvokePolicy", om.valueToTree(this.getLambdaInvokePolicy()));
                }
                if (this.getRekognitionDetectOnlyPolicy() != null) {
                    obj.set("rekognitionDetectOnlyPolicy", om.valueToTree(this.getRekognitionDetectOnlyPolicy()));
                }
                if (this.getRekognitionLabelsPolicy() != null) {
                    obj.set("rekognitionLabelsPolicy", om.valueToTree(this.getRekognitionLabelsPolicy()));
                }
                if (this.getRekognitionNoDataAccessPolicy() != null) {
                    obj.set("rekognitionNoDataAccessPolicy", om.valueToTree(this.getRekognitionNoDataAccessPolicy()));
                }
                if (this.getRekognitionReadPolicy() != null) {
                    obj.set("rekognitionReadPolicy", om.valueToTree(this.getRekognitionReadPolicy()));
                }
                if (this.getRekognitionWriteOnlyAccessPolicy() != null) {
                    obj.set("rekognitionWriteOnlyAccessPolicy", om.valueToTree(this.getRekognitionWriteOnlyAccessPolicy()));
                }
                if (this.getS3CrudPolicy() != null) {
                    obj.set("s3CrudPolicy", om.valueToTree(this.getS3CrudPolicy()));
                }
                if (this.getS3ReadPolicy() != null) {
                    obj.set("s3ReadPolicy", om.valueToTree(this.getS3ReadPolicy()));
                }
                if (this.getSesBulkTemplatedCrudPolicy() != null) {
                    obj.set("sesBulkTemplatedCrudPolicy", om.valueToTree(this.getSesBulkTemplatedCrudPolicy()));
                }
                if (this.getSesCrudPolicy() != null) {
                    obj.set("sesCrudPolicy", om.valueToTree(this.getSesCrudPolicy()));
                }
                if (this.getSesEmailTemplateCrudPolicy() != null) {
                    obj.set("sesEmailTemplateCrudPolicy", om.valueToTree(this.getSesEmailTemplateCrudPolicy()));
                }
                if (this.getSesSendBouncePolicy() != null) {
                    obj.set("sesSendBouncePolicy", om.valueToTree(this.getSesSendBouncePolicy()));
                }
                if (this.getSnsCrudPolicy() != null) {
                    obj.set("snsCrudPolicy", om.valueToTree(this.getSnsCrudPolicy()));
                }
                if (this.getSnsPublishMessagePolicy() != null) {
                    obj.set("snsPublishMessagePolicy", om.valueToTree(this.getSnsPublishMessagePolicy()));
                }
                if (this.getSqsPollerPolicy() != null) {
                    obj.set("sqsPollerPolicy", om.valueToTree(this.getSqsPollerPolicy()));
                }
                if (this.getSqsSendMessagePolicy() != null) {
                    obj.set("sqsSendMessagePolicy", om.valueToTree(this.getSqsSendMessagePolicy()));
                }
                if (this.getStepFunctionsExecutionPolicy() != null) {
                    obj.set("stepFunctionsExecutionPolicy", om.valueToTree(this.getStepFunctionsExecutionPolicy()));
                }
                if (this.getVpcAccessPolicy() != null) {
                    obj.set("vpcAccessPolicy", om.valueToTree(this.getVpcAccessPolicy()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SAMPolicyTemplateProperty.Jsii$Proxy that = (SAMPolicyTemplateProperty.Jsii$Proxy) o;

                if (this.amiDescribePolicy != null ? !this.amiDescribePolicy.equals(that.amiDescribePolicy) : that.amiDescribePolicy != null) return false;
                if (this.cloudFormationDescribeStacksPolicy != null ? !this.cloudFormationDescribeStacksPolicy.equals(that.cloudFormationDescribeStacksPolicy) : that.cloudFormationDescribeStacksPolicy != null) return false;
                if (this.cloudWatchPutMetricPolicy != null ? !this.cloudWatchPutMetricPolicy.equals(that.cloudWatchPutMetricPolicy) : that.cloudWatchPutMetricPolicy != null) return false;
                if (this.dynamoDbCrudPolicy != null ? !this.dynamoDbCrudPolicy.equals(that.dynamoDbCrudPolicy) : that.dynamoDbCrudPolicy != null) return false;
                if (this.dynamoDbReadPolicy != null ? !this.dynamoDbReadPolicy.equals(that.dynamoDbReadPolicy) : that.dynamoDbReadPolicy != null) return false;
                if (this.dynamoDbStreamReadPolicy != null ? !this.dynamoDbStreamReadPolicy.equals(that.dynamoDbStreamReadPolicy) : that.dynamoDbStreamReadPolicy != null) return false;
                if (this.ec2DescribePolicy != null ? !this.ec2DescribePolicy.equals(that.ec2DescribePolicy) : that.ec2DescribePolicy != null) return false;
                if (this.elasticsearchHttpPostPolicy != null ? !this.elasticsearchHttpPostPolicy.equals(that.elasticsearchHttpPostPolicy) : that.elasticsearchHttpPostPolicy != null) return false;
                if (this.filterLogEventsPolicy != null ? !this.filterLogEventsPolicy.equals(that.filterLogEventsPolicy) : that.filterLogEventsPolicy != null) return false;
                if (this.kinesisCrudPolicy != null ? !this.kinesisCrudPolicy.equals(that.kinesisCrudPolicy) : that.kinesisCrudPolicy != null) return false;
                if (this.kinesisStreamReadPolicy != null ? !this.kinesisStreamReadPolicy.equals(that.kinesisStreamReadPolicy) : that.kinesisStreamReadPolicy != null) return false;
                if (this.kmsDecryptPolicy != null ? !this.kmsDecryptPolicy.equals(that.kmsDecryptPolicy) : that.kmsDecryptPolicy != null) return false;
                if (this.lambdaInvokePolicy != null ? !this.lambdaInvokePolicy.equals(that.lambdaInvokePolicy) : that.lambdaInvokePolicy != null) return false;
                if (this.rekognitionDetectOnlyPolicy != null ? !this.rekognitionDetectOnlyPolicy.equals(that.rekognitionDetectOnlyPolicy) : that.rekognitionDetectOnlyPolicy != null) return false;
                if (this.rekognitionLabelsPolicy != null ? !this.rekognitionLabelsPolicy.equals(that.rekognitionLabelsPolicy) : that.rekognitionLabelsPolicy != null) return false;
                if (this.rekognitionNoDataAccessPolicy != null ? !this.rekognitionNoDataAccessPolicy.equals(that.rekognitionNoDataAccessPolicy) : that.rekognitionNoDataAccessPolicy != null) return false;
                if (this.rekognitionReadPolicy != null ? !this.rekognitionReadPolicy.equals(that.rekognitionReadPolicy) : that.rekognitionReadPolicy != null) return false;
                if (this.rekognitionWriteOnlyAccessPolicy != null ? !this.rekognitionWriteOnlyAccessPolicy.equals(that.rekognitionWriteOnlyAccessPolicy) : that.rekognitionWriteOnlyAccessPolicy != null) return false;
                if (this.s3CrudPolicy != null ? !this.s3CrudPolicy.equals(that.s3CrudPolicy) : that.s3CrudPolicy != null) return false;
                if (this.s3ReadPolicy != null ? !this.s3ReadPolicy.equals(that.s3ReadPolicy) : that.s3ReadPolicy != null) return false;
                if (this.sesBulkTemplatedCrudPolicy != null ? !this.sesBulkTemplatedCrudPolicy.equals(that.sesBulkTemplatedCrudPolicy) : that.sesBulkTemplatedCrudPolicy != null) return false;
                if (this.sesCrudPolicy != null ? !this.sesCrudPolicy.equals(that.sesCrudPolicy) : that.sesCrudPolicy != null) return false;
                if (this.sesEmailTemplateCrudPolicy != null ? !this.sesEmailTemplateCrudPolicy.equals(that.sesEmailTemplateCrudPolicy) : that.sesEmailTemplateCrudPolicy != null) return false;
                if (this.sesSendBouncePolicy != null ? !this.sesSendBouncePolicy.equals(that.sesSendBouncePolicy) : that.sesSendBouncePolicy != null) return false;
                if (this.snsCrudPolicy != null ? !this.snsCrudPolicy.equals(that.snsCrudPolicy) : that.snsCrudPolicy != null) return false;
                if (this.snsPublishMessagePolicy != null ? !this.snsPublishMessagePolicy.equals(that.snsPublishMessagePolicy) : that.snsPublishMessagePolicy != null) return false;
                if (this.sqsPollerPolicy != null ? !this.sqsPollerPolicy.equals(that.sqsPollerPolicy) : that.sqsPollerPolicy != null) return false;
                if (this.sqsSendMessagePolicy != null ? !this.sqsSendMessagePolicy.equals(that.sqsSendMessagePolicy) : that.sqsSendMessagePolicy != null) return false;
                if (this.stepFunctionsExecutionPolicy != null ? !this.stepFunctionsExecutionPolicy.equals(that.stepFunctionsExecutionPolicy) : that.stepFunctionsExecutionPolicy != null) return false;
                return this.vpcAccessPolicy != null ? this.vpcAccessPolicy.equals(that.vpcAccessPolicy) : that.vpcAccessPolicy == null;
            }

            @Override
            public int hashCode() {
                int result = this.amiDescribePolicy != null ? this.amiDescribePolicy.hashCode() : 0;
                result = 31 * result + (this.cloudFormationDescribeStacksPolicy != null ? this.cloudFormationDescribeStacksPolicy.hashCode() : 0);
                result = 31 * result + (this.cloudWatchPutMetricPolicy != null ? this.cloudWatchPutMetricPolicy.hashCode() : 0);
                result = 31 * result + (this.dynamoDbCrudPolicy != null ? this.dynamoDbCrudPolicy.hashCode() : 0);
                result = 31 * result + (this.dynamoDbReadPolicy != null ? this.dynamoDbReadPolicy.hashCode() : 0);
                result = 31 * result + (this.dynamoDbStreamReadPolicy != null ? this.dynamoDbStreamReadPolicy.hashCode() : 0);
                result = 31 * result + (this.ec2DescribePolicy != null ? this.ec2DescribePolicy.hashCode() : 0);
                result = 31 * result + (this.elasticsearchHttpPostPolicy != null ? this.elasticsearchHttpPostPolicy.hashCode() : 0);
                result = 31 * result + (this.filterLogEventsPolicy != null ? this.filterLogEventsPolicy.hashCode() : 0);
                result = 31 * result + (this.kinesisCrudPolicy != null ? this.kinesisCrudPolicy.hashCode() : 0);
                result = 31 * result + (this.kinesisStreamReadPolicy != null ? this.kinesisStreamReadPolicy.hashCode() : 0);
                result = 31 * result + (this.kmsDecryptPolicy != null ? this.kmsDecryptPolicy.hashCode() : 0);
                result = 31 * result + (this.lambdaInvokePolicy != null ? this.lambdaInvokePolicy.hashCode() : 0);
                result = 31 * result + (this.rekognitionDetectOnlyPolicy != null ? this.rekognitionDetectOnlyPolicy.hashCode() : 0);
                result = 31 * result + (this.rekognitionLabelsPolicy != null ? this.rekognitionLabelsPolicy.hashCode() : 0);
                result = 31 * result + (this.rekognitionNoDataAccessPolicy != null ? this.rekognitionNoDataAccessPolicy.hashCode() : 0);
                result = 31 * result + (this.rekognitionReadPolicy != null ? this.rekognitionReadPolicy.hashCode() : 0);
                result = 31 * result + (this.rekognitionWriteOnlyAccessPolicy != null ? this.rekognitionWriteOnlyAccessPolicy.hashCode() : 0);
                result = 31 * result + (this.s3CrudPolicy != null ? this.s3CrudPolicy.hashCode() : 0);
                result = 31 * result + (this.s3ReadPolicy != null ? this.s3ReadPolicy.hashCode() : 0);
                result = 31 * result + (this.sesBulkTemplatedCrudPolicy != null ? this.sesBulkTemplatedCrudPolicy.hashCode() : 0);
                result = 31 * result + (this.sesCrudPolicy != null ? this.sesCrudPolicy.hashCode() : 0);
                result = 31 * result + (this.sesEmailTemplateCrudPolicy != null ? this.sesEmailTemplateCrudPolicy.hashCode() : 0);
                result = 31 * result + (this.sesSendBouncePolicy != null ? this.sesSendBouncePolicy.hashCode() : 0);
                result = 31 * result + (this.snsCrudPolicy != null ? this.snsCrudPolicy.hashCode() : 0);
                result = 31 * result + (this.snsPublishMessagePolicy != null ? this.snsPublishMessagePolicy.hashCode() : 0);
                result = 31 * result + (this.sqsPollerPolicy != null ? this.sqsPollerPolicy.hashCode() : 0);
                result = 31 * result + (this.sqsSendMessagePolicy != null ? this.sqsSendMessagePolicy.hashCode() : 0);
                result = 31 * result + (this.stepFunctionsExecutionPolicy != null ? this.stepFunctionsExecutionPolicy.hashCode() : 0);
                result = 31 * result + (this.vpcAccessPolicy != null ? this.vpcAccessPolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sns
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface SNSEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.SNSEventProperty.Topic`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sns
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getTopic();

        /**
         * @return a {@link Builder} of {@link SNSEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SNSEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String topic;

            /**
             * Sets the value of Topic
             * @param topic `CfnFunction.SNSEventProperty.Topic`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder topic(java.lang.String topic) {
                this.topic = topic;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SNSEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public SNSEventProperty build() {
                return new Jsii$Proxy(topic);
            }
        }

        /**
         * An implementation for {@link SNSEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SNSEventProperty {
            private final java.lang.String topic;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.topic = this.jsiiGet("topic", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String topic) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.topic = java.util.Objects.requireNonNull(topic, "topic is required");
            }

            @Override
            public java.lang.String getTopic() {
                return this.topic;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("topic", om.valueToTree(this.getTopic()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SNSEventProperty.Jsii$Proxy that = (SNSEventProperty.Jsii$Proxy) o;

                return this.topic.equals(that.topic);
            }

            @Override
            public int hashCode() {
                int result = this.topic.hashCode();
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface SQSEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.SQSEventProperty.Queue`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getQueue();

        /**
         * `CfnFunction.SQSEventProperty.BatchSize`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getBatchSize();

        /**
         * `CfnFunction.SQSEventProperty.Enabled`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link SQSEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SQSEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String queue;
            private java.lang.Number batchSize;
            private java.lang.Object enabled;

            /**
             * Sets the value of Queue
             * @param queue `CfnFunction.SQSEventProperty.Queue`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder queue(java.lang.String queue) {
                this.queue = queue;
                return this;
            }

            /**
             * Sets the value of BatchSize
             * @param batchSize `CfnFunction.SQSEventProperty.BatchSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder batchSize(java.lang.Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            /**
             * Sets the value of Enabled
             * @param enabled `CfnFunction.SQSEventProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of Enabled
             * @param enabled `CfnFunction.SQSEventProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SQSEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public SQSEventProperty build() {
                return new Jsii$Proxy(queue, batchSize, enabled);
            }
        }

        /**
         * An implementation for {@link SQSEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SQSEventProperty {
            private final java.lang.String queue;
            private final java.lang.Number batchSize;
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.queue = this.jsiiGet("queue", java.lang.String.class);
                this.batchSize = this.jsiiGet("batchSize", java.lang.Number.class);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String queue, java.lang.Number batchSize, java.lang.Object enabled) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.queue = java.util.Objects.requireNonNull(queue, "queue is required");
                this.batchSize = batchSize;
                this.enabled = enabled;
            }

            @Override
            public java.lang.String getQueue() {
                return this.queue;
            }

            @Override
            public java.lang.Number getBatchSize() {
                return this.batchSize;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("queue", om.valueToTree(this.getQueue()));
                if (this.getBatchSize() != null) {
                    obj.set("batchSize", om.valueToTree(this.getBatchSize()));
                }
                if (this.getEnabled() != null) {
                    obj.set("enabled", om.valueToTree(this.getEnabled()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SQSEventProperty.Jsii$Proxy that = (SQSEventProperty.Jsii$Proxy) o;

                if (!queue.equals(that.queue)) return false;
                if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public int hashCode() {
                int result = this.queue.hashCode();
                result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ScheduleEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.ScheduleEventProperty.Schedule`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSchedule();

        /**
         * `CfnFunction.ScheduleEventProperty.Input`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getInput();

        /**
         * @return a {@link Builder} of {@link ScheduleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String schedule;
            private java.lang.String input;

            /**
             * Sets the value of Schedule
             * @param schedule `CfnFunction.ScheduleEventProperty.Schedule`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder schedule(java.lang.String schedule) {
                this.schedule = schedule;
                return this;
            }

            /**
             * Sets the value of Input
             * @param input `CfnFunction.ScheduleEventProperty.Input`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder input(java.lang.String input) {
                this.input = input;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ScheduleEventProperty build() {
                return new Jsii$Proxy(schedule, input);
            }
        }

        /**
         * An implementation for {@link ScheduleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleEventProperty {
            private final java.lang.String schedule;
            private final java.lang.String input;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.schedule = this.jsiiGet("schedule", java.lang.String.class);
                this.input = this.jsiiGet("input", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String schedule, java.lang.String input) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.schedule = java.util.Objects.requireNonNull(schedule, "schedule is required");
                this.input = input;
            }

            @Override
            public java.lang.String getSchedule() {
                return this.schedule;
            }

            @Override
            public java.lang.String getInput() {
                return this.input;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("schedule", om.valueToTree(this.getSchedule()));
                if (this.getInput() != null) {
                    obj.set("input", om.valueToTree(this.getInput()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduleEventProperty.Jsii$Proxy that = (ScheduleEventProperty.Jsii$Proxy) o;

                if (!schedule.equals(that.schedule)) return false;
                return this.input != null ? this.input.equals(that.input) : that.input == null;
            }

            @Override
            public int hashCode() {
                int result = this.schedule.hashCode();
                result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface StateMachineSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.StateMachineSAMPTProperty.StateMachineName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStateMachineName();

        /**
         * @return a {@link Builder} of {@link StateMachineSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StateMachineSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String stateMachineName;

            /**
             * Sets the value of StateMachineName
             * @param stateMachineName `CfnFunction.StateMachineSAMPTProperty.StateMachineName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder stateMachineName(java.lang.String stateMachineName) {
                this.stateMachineName = stateMachineName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StateMachineSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public StateMachineSAMPTProperty build() {
                return new Jsii$Proxy(stateMachineName);
            }
        }

        /**
         * An implementation for {@link StateMachineSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StateMachineSAMPTProperty {
            private final java.lang.String stateMachineName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.stateMachineName = this.jsiiGet("stateMachineName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String stateMachineName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.stateMachineName = java.util.Objects.requireNonNull(stateMachineName, "stateMachineName is required");
            }

            @Override
            public java.lang.String getStateMachineName() {
                return this.stateMachineName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("stateMachineName", om.valueToTree(this.getStateMachineName()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StateMachineSAMPTProperty.Jsii$Proxy that = (StateMachineSAMPTProperty.Jsii$Proxy) o;

                return this.stateMachineName.equals(that.stateMachineName);
            }

            @Override
            public int hashCode() {
                int result = this.stateMachineName.hashCode();
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface StreamSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.StreamSAMPTProperty.StreamName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStreamName();

        /**
         * @return a {@link Builder} of {@link StreamSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StreamSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String streamName;

            /**
             * Sets the value of StreamName
             * @param streamName `CfnFunction.StreamSAMPTProperty.StreamName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder streamName(java.lang.String streamName) {
                this.streamName = streamName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public StreamSAMPTProperty build() {
                return new Jsii$Proxy(streamName);
            }
        }

        /**
         * An implementation for {@link StreamSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamSAMPTProperty {
            private final java.lang.String streamName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.streamName = this.jsiiGet("streamName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String streamName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.streamName = java.util.Objects.requireNonNull(streamName, "streamName is required");
            }

            @Override
            public java.lang.String getStreamName() {
                return this.streamName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("streamName", om.valueToTree(this.getStreamName()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StreamSAMPTProperty.Jsii$Proxy that = (StreamSAMPTProperty.Jsii$Proxy) o;

                return this.streamName.equals(that.streamName);
            }

            @Override
            public int hashCode() {
                int result = this.streamName.hashCode();
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TableSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.TableSAMPTProperty.TableName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getTableName();

        /**
         * @return a {@link Builder} of {@link TableSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TableSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String tableName;

            /**
             * Sets the value of TableName
             * @param tableName `CfnFunction.TableSAMPTProperty.TableName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TableSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TableSAMPTProperty build() {
                return new Jsii$Proxy(tableName);
            }
        }

        /**
         * An implementation for {@link TableSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableSAMPTProperty {
            private final java.lang.String tableName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.tableName = this.jsiiGet("tableName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String tableName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tableName = java.util.Objects.requireNonNull(tableName, "tableName is required");
            }

            @Override
            public java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("tableName", om.valueToTree(this.getTableName()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TableSAMPTProperty.Jsii$Proxy that = (TableSAMPTProperty.Jsii$Proxy) o;

                return this.tableName.equals(that.tableName);
            }

            @Override
            public int hashCode() {
                int result = this.tableName.hashCode();
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TableStreamSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.TableStreamSAMPTProperty.StreamName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStreamName();

        /**
         * `CfnFunction.TableStreamSAMPTProperty.TableName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getTableName();

        /**
         * @return a {@link Builder} of {@link TableStreamSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TableStreamSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String streamName;
            private java.lang.String tableName;

            /**
             * Sets the value of StreamName
             * @param streamName `CfnFunction.TableStreamSAMPTProperty.StreamName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder streamName(java.lang.String streamName) {
                this.streamName = streamName;
                return this;
            }

            /**
             * Sets the value of TableName
             * @param tableName `CfnFunction.TableStreamSAMPTProperty.TableName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TableStreamSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TableStreamSAMPTProperty build() {
                return new Jsii$Proxy(streamName, tableName);
            }
        }

        /**
         * An implementation for {@link TableStreamSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableStreamSAMPTProperty {
            private final java.lang.String streamName;
            private final java.lang.String tableName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.streamName = this.jsiiGet("streamName", java.lang.String.class);
                this.tableName = this.jsiiGet("tableName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String streamName, java.lang.String tableName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.streamName = java.util.Objects.requireNonNull(streamName, "streamName is required");
                this.tableName = java.util.Objects.requireNonNull(tableName, "tableName is required");
            }

            @Override
            public java.lang.String getStreamName() {
                return this.streamName;
            }

            @Override
            public java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("streamName", om.valueToTree(this.getStreamName()));
                obj.set("tableName", om.valueToTree(this.getTableName()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TableStreamSAMPTProperty.Jsii$Proxy that = (TableStreamSAMPTProperty.Jsii$Proxy) o;

                if (!streamName.equals(that.streamName)) return false;
                return this.tableName.equals(that.tableName);
            }

            @Override
            public int hashCode() {
                int result = this.streamName.hashCode();
                result = 31 * result + (this.tableName.hashCode());
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TopicSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.TopicSAMPTProperty.TopicName`.
         * 
         * @see https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getTopicName();

        /**
         * @return a {@link Builder} of {@link TopicSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String topicName;

            /**
             * Sets the value of TopicName
             * @param topicName `CfnFunction.TopicSAMPTProperty.TopicName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder topicName(java.lang.String topicName) {
                this.topicName = topicName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TopicSAMPTProperty build() {
                return new Jsii$Proxy(topicName);
            }
        }

        /**
         * An implementation for {@link TopicSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicSAMPTProperty {
            private final java.lang.String topicName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.topicName = this.jsiiGet("topicName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String topicName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.topicName = java.util.Objects.requireNonNull(topicName, "topicName is required");
            }

            @Override
            public java.lang.String getTopicName() {
                return this.topicName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("topicName", om.valueToTree(this.getTopicName()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicSAMPTProperty.Jsii$Proxy that = (TopicSAMPTProperty.Jsii$Proxy) o;

                return this.topicName.equals(that.topicName);
            }

            @Override
            public int hashCode() {
                int result = this.topicName.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface VpcConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.VpcConfigProperty.SecurityGroupIds`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getSecurityGroupIds();

        /**
         * `CfnFunction.VpcConfigProperty.SubnetIds`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getSubnetIds();

        /**
         * @return a {@link Builder} of {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.util.List<java.lang.String> securityGroupIds;
            private java.util.List<java.lang.String> subnetIds;

            /**
             * Sets the value of SecurityGroupIds
             * @param securityGroupIds `CfnFunction.VpcConfigProperty.SecurityGroupIds`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of SubnetIds
             * @param subnetIds `CfnFunction.VpcConfigProperty.SubnetIds`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public VpcConfigProperty build() {
                return new Jsii$Proxy(securityGroupIds, subnetIds);
            }
        }

        /**
         * An implementation for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConfigProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnetIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.securityGroupIds = this.jsiiGet("securityGroupIds", java.util.List.class);
                this.subnetIds = this.jsiiGet("subnetIds", java.util.List.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.util.List<java.lang.String> securityGroupIds, java.util.List<java.lang.String> subnetIds) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = java.util.Objects.requireNonNull(securityGroupIds, "securityGroupIds is required");
                this.subnetIds = java.util.Objects.requireNonNull(subnetIds, "subnetIds is required");
            }

            @Override
            public java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                obj.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcConfigProperty.Jsii$Proxy that = (VpcConfigProperty.Jsii$Proxy) o;

                if (!securityGroupIds.equals(that.securityGroupIds)) return false;
                return this.subnetIds.equals(that.subnetIds);
            }

            @Override
            public int hashCode() {
                int result = this.securityGroupIds.hashCode();
                result = 31 * result + (this.subnetIds.hashCode());
                return result;
            }
        }
    }
}
