/**
 * <h1>AWS Serverless Application Model Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * All classes with the <code>Cfn</code> prefix in this module (<a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib">CFN Resources</a>) are always stable and safe to use.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module includes low-level constructs that synthesize into <code>AWS::Serverless</code> resources.
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.sam.*;
 * </pre></blockquote>
 * <p>
 * <h2>Related</h2>
 * <p>
 * The following AWS CDK modules include constructs that can be used to work with Amazon API Gateway and AWS Lambda:
 * <p>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/cdk/api/latest/docs/aws-lambda-readme.html">aws-lambda</a>: define AWS Lambda functions</li>
 * <li><a href="https://docs.aws.amazon.com/cdk/api/latest/docs/aws-lambda-event-sources-readme.html">aws-lambda-event-sources</a>: classes that allow using various AWS services as event sources for AWS Lambda functions</li>
 * <li><a href="https://docs.aws.amazon.com/cdk/api/latest/docs/aws-apigateway-readme.html">aws-apigateway</a>: define APIs through Amazon API Gateway</li>
 * <li><a href="https://docs.aws.amazon.com/cdk/api/latest/docs/aws-codedeploy-readme.html#lambda-applications">aws-codedeploy</a>: define AWS Lambda deployment with traffic shifting support</li>
 * </ul>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.sam;
