package software.amazon.awscdk.services.sam;

/**
 * Properties for defining a `AWS::Serverless::SimpleTable`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sam.*;
 * CfnSimpleTableProps cfnSimpleTableProps = CfnSimpleTableProps.builder()
 *         .primaryKey(PrimaryKeyProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .name("name")
 *                 .build())
 *         .provisionedThroughput(ProvisionedThroughputProperty.builder()
 *                 .writeCapacityUnits(123)
 *                 // the properties below are optional
 *                 .readCapacityUnits(123)
 *                 .build())
 *         .sseSpecification(SSESpecificationProperty.builder()
 *                 .sseEnabled(false)
 *                 .build())
 *         .tableName("tableName")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-21T16:39:00.610Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnSimpleTableProps")
@software.amazon.jsii.Jsii.Proxy(CfnSimpleTableProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSimpleTableProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::Serverless::SimpleTable.PrimaryKey`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPrimaryKey() {
        return null;
    }

    /**
     * `AWS::Serverless::SimpleTable.ProvisionedThroughput`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProvisionedThroughput() {
        return null;
    }

    /**
     * `AWS::Serverless::SimpleTable.SSESpecification`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSseSpecification() {
        return null;
    }

    /**
     * `AWS::Serverless::SimpleTable.TableName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
        return null;
    }

    /**
     * `AWS::Serverless::SimpleTable.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSimpleTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSimpleTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSimpleTableProps> {
        java.lang.Object primaryKey;
        java.lang.Object provisionedThroughput;
        java.lang.Object sseSpecification;
        java.lang.String tableName;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnSimpleTableProps#getPrimaryKey}
         * @param primaryKey `AWS::Serverless::SimpleTable.PrimaryKey`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder primaryKey(software.amazon.awscdk.core.IResolvable primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimpleTableProps#getPrimaryKey}
         * @param primaryKey `AWS::Serverless::SimpleTable.PrimaryKey`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder primaryKey(software.amazon.awscdk.services.sam.CfnSimpleTable.PrimaryKeyProperty primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimpleTableProps#getProvisionedThroughput}
         * @param provisionedThroughput `AWS::Serverless::SimpleTable.ProvisionedThroughput`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedThroughput(software.amazon.awscdk.core.IResolvable provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimpleTableProps#getProvisionedThroughput}
         * @param provisionedThroughput `AWS::Serverless::SimpleTable.ProvisionedThroughput`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedThroughput(software.amazon.awscdk.services.sam.CfnSimpleTable.ProvisionedThroughputProperty provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimpleTableProps#getSseSpecification}
         * @param sseSpecification `AWS::Serverless::SimpleTable.SSESpecification`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseSpecification(software.amazon.awscdk.core.IResolvable sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimpleTableProps#getSseSpecification}
         * @param sseSpecification `AWS::Serverless::SimpleTable.SSESpecification`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseSpecification(software.amazon.awscdk.services.sam.CfnSimpleTable.SSESpecificationProperty sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimpleTableProps#getTableName}
         * @param tableName `AWS::Serverless::SimpleTable.TableName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Sets the value of {@link CfnSimpleTableProps#getTags}
         * @param tags `AWS::Serverless::SimpleTable.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSimpleTableProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSimpleTableProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSimpleTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSimpleTableProps {
        private final java.lang.Object primaryKey;
        private final java.lang.Object provisionedThroughput;
        private final java.lang.Object sseSpecification;
        private final java.lang.String tableName;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.primaryKey = software.amazon.jsii.Kernel.get(this, "primaryKey", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.provisionedThroughput = software.amazon.jsii.Kernel.get(this, "provisionedThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sseSpecification = software.amazon.jsii.Kernel.get(this, "sseSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.primaryKey = builder.primaryKey;
            this.provisionedThroughput = builder.provisionedThroughput;
            this.sseSpecification = builder.sseSpecification;
            this.tableName = builder.tableName;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.Object getPrimaryKey() {
            return this.primaryKey;
        }

        @Override
        public final java.lang.Object getProvisionedThroughput() {
            return this.provisionedThroughput;
        }

        @Override
        public final java.lang.Object getSseSpecification() {
            return this.sseSpecification;
        }

        @Override
        public final java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPrimaryKey() != null) {
                data.set("primaryKey", om.valueToTree(this.getPrimaryKey()));
            }
            if (this.getProvisionedThroughput() != null) {
                data.set("provisionedThroughput", om.valueToTree(this.getProvisionedThroughput()));
            }
            if (this.getSseSpecification() != null) {
                data.set("sseSpecification", om.valueToTree(this.getSseSpecification()));
            }
            if (this.getTableName() != null) {
                data.set("tableName", om.valueToTree(this.getTableName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnSimpleTableProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSimpleTableProps.Jsii$Proxy that = (CfnSimpleTableProps.Jsii$Proxy) o;

            if (this.primaryKey != null ? !this.primaryKey.equals(that.primaryKey) : that.primaryKey != null) return false;
            if (this.provisionedThroughput != null ? !this.provisionedThroughput.equals(that.provisionedThroughput) : that.provisionedThroughput != null) return false;
            if (this.sseSpecification != null ? !this.sseSpecification.equals(that.sseSpecification) : that.sseSpecification != null) return false;
            if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.primaryKey != null ? this.primaryKey.hashCode() : 0;
            result = 31 * result + (this.provisionedThroughput != null ? this.provisionedThroughput.hashCode() : 0);
            result = 31 * result + (this.sseSpecification != null ? this.sseSpecification.hashCode() : 0);
            result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
