package software.amazon.awscdk.services.sam;

/**
 * A CloudFormation `AWS::Serverless::Function`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sam.*;
 * Object assumeRolePolicyDocument;
 * CfnFunction cfnFunction = CfnFunction.Builder.create(this, "MyCfnFunction")
 *         .architectures(List.of("architectures"))
 *         .assumeRolePolicyDocument(assumeRolePolicyDocument)
 *         .autoPublishAlias("autoPublishAlias")
 *         .autoPublishCodeSha256("autoPublishCodeSha256")
 *         .codeSigningConfigArn("codeSigningConfigArn")
 *         .codeUri("codeUri")
 *         .deadLetterQueue(DeadLetterQueueProperty.builder()
 *                 .targetArn("targetArn")
 *                 .type("type")
 *                 .build())
 *         .deploymentPreference(DeploymentPreferenceProperty.builder()
 *                 .enabled(false)
 *                 .type("type")
 *                 // the properties below are optional
 *                 .alarms(List.of("alarms"))
 *                 .hooks(List.of("hooks"))
 *                 .build())
 *         .description("description")
 *         .environment(FunctionEnvironmentProperty.builder()
 *                 .variables(Map.of(
 *                         "variablesKey", "variables"))
 *                 .build())
 *         .eventInvokeConfig(EventInvokeConfigProperty.builder()
 *                 .destinationConfig(EventInvokeDestinationConfigProperty.builder()
 *                         .onFailure(DestinationProperty.builder()
 *                                 .destination("destination")
 *                                 // the properties below are optional
 *                                 .type("type")
 *                                 .build())
 *                         .onSuccess(DestinationProperty.builder()
 *                                 .destination("destination")
 *                                 // the properties below are optional
 *                                 .type("type")
 *                                 .build())
 *                         .build())
 *                 .maximumEventAgeInSeconds(123)
 *                 .maximumRetryAttempts(123)
 *                 .build())
 *         .events(Map.of(
 *                 "eventsKey", EventSourceProperty.builder()
 *                         .properties(S3EventProperty.builder()
 *                                 .variables(Map.of(
 *                                         "variablesKey", "variables"))
 *                                 .build())
 *                         .type("type")
 *                         .build()))
 *         .fileSystemConfigs(List.of(FileSystemConfigProperty.builder()
 *                 .arn("arn")
 *                 .localMountPath("localMountPath")
 *                 .build()))
 *         .functionName("functionName")
 *         .handler("handler")
 *         .imageConfig(ImageConfigProperty.builder()
 *                 .command(List.of("command"))
 *                 .entryPoint(List.of("entryPoint"))
 *                 .workingDirectory("workingDirectory")
 *                 .build())
 *         .imageUri("imageUri")
 *         .inlineCode("inlineCode")
 *         .kmsKeyArn("kmsKeyArn")
 *         .layers(List.of("layers"))
 *         .memorySize(123)
 *         .packageType("packageType")
 *         .permissionsBoundary("permissionsBoundary")
 *         .policies("policies")
 *         .provisionedConcurrencyConfig(ProvisionedConcurrencyConfigProperty.builder()
 *                 .provisionedConcurrentExecutions("provisionedConcurrentExecutions")
 *                 .build())
 *         .reservedConcurrentExecutions(123)
 *         .role("role")
 *         .runtime("runtime")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .timeout(123)
 *         .tracing("tracing")
 *         .versionDescription("versionDescription")
 *         .vpcConfig(VpcConfigProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-02-08T19:43:49.582Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction")
public class CfnFunction extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnFunction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFunction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnFunction.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        REQUIRED_TRANSFORM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnFunction.class, "REQUIRED_TRANSFORM", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Serverless::Function`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFunction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnFunctionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::Serverless::Function`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFunction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The `Transform` a template must use in order to use this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String REQUIRED_TRANSFORM;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::Serverless::Function.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * `AWS::Serverless::Function.AssumeRolePolicyDocument`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAssumeRolePolicyDocument() {
        return software.amazon.jsii.Kernel.get(this, "assumeRolePolicyDocument", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::Function.AssumeRolePolicyDocument`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssumeRolePolicyDocument(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "assumeRolePolicyDocument", java.util.Objects.requireNonNull(value, "assumeRolePolicyDocument is required"));
    }

    /**
     * `AWS::Serverless::Function.Architectures`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArchitectures() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "architectures", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::Serverless::Function.Architectures`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArchitectures(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "architectures", value);
    }

    /**
     * `AWS::Serverless::Function.AutoPublishAlias`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAutoPublishAlias() {
        return software.amazon.jsii.Kernel.get(this, "autoPublishAlias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Serverless::Function.AutoPublishAlias`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoPublishAlias(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "autoPublishAlias", value);
    }

    /**
     * `AWS::Serverless::Function.AutoPublishCodeSha256`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAutoPublishCodeSha256() {
        return software.amazon.jsii.Kernel.get(this, "autoPublishCodeSha256", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Serverless::Function.AutoPublishCodeSha256`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoPublishCodeSha256(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "autoPublishCodeSha256", value);
    }

    /**
     * `AWS::Serverless::Function.CodeSigningConfigArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCodeSigningConfigArn() {
        return software.amazon.jsii.Kernel.get(this, "codeSigningConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Serverless::Function.CodeSigningConfigArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCodeSigningConfigArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "codeSigningConfigArn", value);
    }

    /**
     * `AWS::Serverless::Function.CodeUri`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCodeUri() {
        return software.amazon.jsii.Kernel.get(this, "codeUri", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::Function.CodeUri`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCodeUri(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "codeUri", value);
    }

    /**
     * `AWS::Serverless::Function.CodeUri`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCodeUri(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "codeUri", value);
    }

    /**
     * `AWS::Serverless::Function.CodeUri`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCodeUri(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnFunction.S3LocationProperty value) {
        software.amazon.jsii.Kernel.set(this, "codeUri", value);
    }

    /**
     * `AWS::Serverless::Function.DeadLetterQueue`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeadLetterQueue() {
        return software.amazon.jsii.Kernel.get(this, "deadLetterQueue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::Function.DeadLetterQueue`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeadLetterQueue(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deadLetterQueue", value);
    }

    /**
     * `AWS::Serverless::Function.DeadLetterQueue`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeadLetterQueue(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnFunction.DeadLetterQueueProperty value) {
        software.amazon.jsii.Kernel.set(this, "deadLetterQueue", value);
    }

    /**
     * `AWS::Serverless::Function.DeploymentPreference`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentPreference() {
        return software.amazon.jsii.Kernel.get(this, "deploymentPreference", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::Function.DeploymentPreference`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentPreference(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deploymentPreference", value);
    }

    /**
     * `AWS::Serverless::Function.DeploymentPreference`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentPreference(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnFunction.DeploymentPreferenceProperty value) {
        software.amazon.jsii.Kernel.set(this, "deploymentPreference", value);
    }

    /**
     * `AWS::Serverless::Function.Description`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Serverless::Function.Description`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * `AWS::Serverless::Function.Environment`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
        return software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::Function.Environment`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironment(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "environment", value);
    }

    /**
     * `AWS::Serverless::Function.Environment`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironment(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnFunction.FunctionEnvironmentProperty value) {
        software.amazon.jsii.Kernel.set(this, "environment", value);
    }

    /**
     * `AWS::Serverless::Function.EventInvokeConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEventInvokeConfig() {
        return software.amazon.jsii.Kernel.get(this, "eventInvokeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::Function.EventInvokeConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventInvokeConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "eventInvokeConfig", value);
    }

    /**
     * `AWS::Serverless::Function.EventInvokeConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventInvokeConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnFunction.EventInvokeConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "eventInvokeConfig", value);
    }

    /**
     * `AWS::Serverless::Function.Events`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEvents() {
        return software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::Function.Events`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEvents(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "events", value);
    }

    /**
     * `AWS::Serverless::Function.Events`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEvents(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "events", value);
    }

    /**
     * `AWS::Serverless::Function.FileSystemConfigs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFileSystemConfigs() {
        return software.amazon.jsii.Kernel.get(this, "fileSystemConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::Function.FileSystemConfigs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileSystemConfigs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "fileSystemConfigs", value);
    }

    /**
     * `AWS::Serverless::Function.FileSystemConfigs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileSystemConfigs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "fileSystemConfigs", value);
    }

    /**
     * `AWS::Serverless::Function.FunctionName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFunctionName() {
        return software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Serverless::Function.FunctionName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFunctionName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "functionName", value);
    }

    /**
     * `AWS::Serverless::Function.Handler`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHandler() {
        return software.amazon.jsii.Kernel.get(this, "handler", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Serverless::Function.Handler`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHandler(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "handler", value);
    }

    /**
     * `AWS::Serverless::Function.ImageConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getImageConfig() {
        return software.amazon.jsii.Kernel.get(this, "imageConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::Function.ImageConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "imageConfig", value);
    }

    /**
     * `AWS::Serverless::Function.ImageConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnFunction.ImageConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "imageConfig", value);
    }

    /**
     * `AWS::Serverless::Function.ImageUri`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getImageUri() {
        return software.amazon.jsii.Kernel.get(this, "imageUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Serverless::Function.ImageUri`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageUri(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "imageUri", value);
    }

    /**
     * `AWS::Serverless::Function.InlineCode`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInlineCode() {
        return software.amazon.jsii.Kernel.get(this, "inlineCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Serverless::Function.InlineCode`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInlineCode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "inlineCode", value);
    }

    /**
     * `AWS::Serverless::Function.KmsKeyArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Serverless::Function.KmsKeyArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyArn", value);
    }

    /**
     * `AWS::Serverless::Function.Layers`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLayers() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "layers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::Serverless::Function.Layers`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLayers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "layers", value);
    }

    /**
     * `AWS::Serverless::Function.MemorySize`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMemorySize() {
        return software.amazon.jsii.Kernel.get(this, "memorySize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * `AWS::Serverless::Function.MemorySize`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMemorySize(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "memorySize", value);
    }

    /**
     * `AWS::Serverless::Function.PackageType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPackageType() {
        return software.amazon.jsii.Kernel.get(this, "packageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Serverless::Function.PackageType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPackageType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "packageType", value);
    }

    /**
     * `AWS::Serverless::Function.PermissionsBoundary`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPermissionsBoundary() {
        return software.amazon.jsii.Kernel.get(this, "permissionsBoundary", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Serverless::Function.PermissionsBoundary`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissionsBoundary(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "permissionsBoundary", value);
    }

    /**
     * `AWS::Serverless::Function.Policies`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPolicies() {
        return software.amazon.jsii.Kernel.get(this, "policies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::Function.Policies`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicies(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "policies", value);
    }

    /**
     * `AWS::Serverless::Function.Policies`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "policies", value);
    }

    /**
     * `AWS::Serverless::Function.Policies`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnFunction.IAMPolicyDocumentProperty value) {
        software.amazon.jsii.Kernel.set(this, "policies", value);
    }

    /**
     * `AWS::Serverless::Function.Policies`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicies(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "policies", value);
    }

    /**
     * `AWS::Serverless::Function.ProvisionedConcurrencyConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getProvisionedConcurrencyConfig() {
        return software.amazon.jsii.Kernel.get(this, "provisionedConcurrencyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::Function.ProvisionedConcurrencyConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisionedConcurrencyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "provisionedConcurrencyConfig", value);
    }

    /**
     * `AWS::Serverless::Function.ProvisionedConcurrencyConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisionedConcurrencyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnFunction.ProvisionedConcurrencyConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "provisionedConcurrencyConfig", value);
    }

    /**
     * `AWS::Serverless::Function.ReservedConcurrentExecutions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getReservedConcurrentExecutions() {
        return software.amazon.jsii.Kernel.get(this, "reservedConcurrentExecutions", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * `AWS::Serverless::Function.ReservedConcurrentExecutions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReservedConcurrentExecutions(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "reservedConcurrentExecutions", value);
    }

    /**
     * `AWS::Serverless::Function.Role`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Serverless::Function.Role`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRole(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "role", value);
    }

    /**
     * `AWS::Serverless::Function.Runtime`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRuntime() {
        return software.amazon.jsii.Kernel.get(this, "runtime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Serverless::Function.Runtime`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuntime(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "runtime", value);
    }

    /**
     * `AWS::Serverless::Function.Timeout`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getTimeout() {
        return software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * `AWS::Serverless::Function.Timeout`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeout(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "timeout", value);
    }

    /**
     * `AWS::Serverless::Function.Tracing`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTracing() {
        return software.amazon.jsii.Kernel.get(this, "tracing", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Serverless::Function.Tracing`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTracing(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tracing", value);
    }

    /**
     * `AWS::Serverless::Function.VersionDescription`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVersionDescription() {
        return software.amazon.jsii.Kernel.get(this, "versionDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Serverless::Function.VersionDescription`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVersionDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "versionDescription", value);
    }

    /**
     * `AWS::Serverless::Function.VpcConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfig() {
        return software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::Function.VpcConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfig", value);
    }

    /**
     * `AWS::Serverless::Function.VpcConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnFunction.VpcConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfig", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * AlexaSkillEventProperty alexaSkillEventProperty = AlexaSkillEventProperty.builder()
     *         .variables(Map.of(
     *                 "variablesKey", "variables"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.AlexaSkillEventProperty")
    @software.amazon.jsii.Jsii.Proxy(AlexaSkillEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AlexaSkillEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.AlexaSkillEventProperty.Variables`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVariables() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AlexaSkillEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AlexaSkillEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AlexaSkillEventProperty> {
            java.lang.Object variables;

            /**
             * Sets the value of {@link AlexaSkillEventProperty#getVariables}
             * @param variables `CfnFunction.AlexaSkillEventProperty.Variables`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variables(software.amazon.awscdk.core.IResolvable variables) {
                this.variables = variables;
                return this;
            }

            /**
             * Sets the value of {@link AlexaSkillEventProperty#getVariables}
             * @param variables `CfnFunction.AlexaSkillEventProperty.Variables`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variables(java.util.Map<java.lang.String, java.lang.String> variables) {
                this.variables = variables;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlexaSkillEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AlexaSkillEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AlexaSkillEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlexaSkillEventProperty {
            private final java.lang.Object variables;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.variables = software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.variables = builder.variables;
            }

            @Override
            public final java.lang.Object getVariables() {
                return this.variables;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getVariables() != null) {
                    data.set("variables", om.valueToTree(this.getVariables()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.AlexaSkillEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AlexaSkillEventProperty.Jsii$Proxy that = (AlexaSkillEventProperty.Jsii$Proxy) o;

                return this.variables != null ? this.variables.equals(that.variables) : that.variables == null;
            }

            @Override
            public final int hashCode() {
                int result = this.variables != null ? this.variables.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * Object customStatements;
     * ApiEventProperty apiEventProperty = ApiEventProperty.builder()
     *         .method("method")
     *         .path("path")
     *         // the properties below are optional
     *         .auth(AuthProperty.builder()
     *                 .apiKeyRequired(false)
     *                 .authorizationScopes(List.of("authorizationScopes"))
     *                 .authorizer("authorizer")
     *                 .resourcePolicy(AuthResourcePolicyProperty.builder()
     *                         .awsAccountBlacklist(List.of("awsAccountBlacklist"))
     *                         .awsAccountWhitelist(List.of("awsAccountWhitelist"))
     *                         .customStatements(List.of(customStatements))
     *                         .intrinsicVpcBlacklist(List.of("intrinsicVpcBlacklist"))
     *                         .intrinsicVpceBlacklist(List.of("intrinsicVpceBlacklist"))
     *                         .intrinsicVpceWhitelist(List.of("intrinsicVpceWhitelist"))
     *                         .intrinsicVpcWhitelist(List.of("intrinsicVpcWhitelist"))
     *                         .ipRangeBlacklist(List.of("ipRangeBlacklist"))
     *                         .ipRangeWhitelist(List.of("ipRangeWhitelist"))
     *                         .sourceVpcBlacklist(List.of("sourceVpcBlacklist"))
     *                         .sourceVpcWhitelist(List.of("sourceVpcWhitelist"))
     *                         .build())
     *                 .build())
     *         .restApiId("restApiId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.ApiEventProperty")
    @software.amazon.jsii.Jsii.Proxy(ApiEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApiEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.ApiEventProperty.Method`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMethod();

        /**
         * `CfnFunction.ApiEventProperty.Path`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPath();

        /**
         * `CfnFunction.ApiEventProperty.Auth`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuth() {
            return null;
        }

        /**
         * `CfnFunction.ApiEventProperty.RestApiId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRestApiId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApiEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApiEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApiEventProperty> {
            java.lang.String method;
            java.lang.String path;
            java.lang.Object auth;
            java.lang.String restApiId;

            /**
             * Sets the value of {@link ApiEventProperty#getMethod}
             * @param method `CfnFunction.ApiEventProperty.Method`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder method(java.lang.String method) {
                this.method = method;
                return this;
            }

            /**
             * Sets the value of {@link ApiEventProperty#getPath}
             * @param path `CfnFunction.ApiEventProperty.Path`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link ApiEventProperty#getAuth}
             * @param auth `CfnFunction.ApiEventProperty.Auth`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder auth(software.amazon.awscdk.core.IResolvable auth) {
                this.auth = auth;
                return this;
            }

            /**
             * Sets the value of {@link ApiEventProperty#getAuth}
             * @param auth `CfnFunction.ApiEventProperty.Auth`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder auth(software.amazon.awscdk.services.sam.CfnFunction.AuthProperty auth) {
                this.auth = auth;
                return this;
            }

            /**
             * Sets the value of {@link ApiEventProperty#getRestApiId}
             * @param restApiId `CfnFunction.ApiEventProperty.RestApiId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restApiId(java.lang.String restApiId) {
                this.restApiId = restApiId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApiEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApiEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApiEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiEventProperty {
            private final java.lang.String method;
            private final java.lang.String path;
            private final java.lang.Object auth;
            private final java.lang.String restApiId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.auth = software.amazon.jsii.Kernel.get(this, "auth", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.restApiId = software.amazon.jsii.Kernel.get(this, "restApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.method = java.util.Objects.requireNonNull(builder.method, "method is required");
                this.path = java.util.Objects.requireNonNull(builder.path, "path is required");
                this.auth = builder.auth;
                this.restApiId = builder.restApiId;
            }

            @Override
            public final java.lang.String getMethod() {
                return this.method;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            public final java.lang.Object getAuth() {
                return this.auth;
            }

            @Override
            public final java.lang.String getRestApiId() {
                return this.restApiId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("method", om.valueToTree(this.getMethod()));
                data.set("path", om.valueToTree(this.getPath()));
                if (this.getAuth() != null) {
                    data.set("auth", om.valueToTree(this.getAuth()));
                }
                if (this.getRestApiId() != null) {
                    data.set("restApiId", om.valueToTree(this.getRestApiId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.ApiEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApiEventProperty.Jsii$Proxy that = (ApiEventProperty.Jsii$Proxy) o;

                if (!method.equals(that.method)) return false;
                if (!path.equals(that.path)) return false;
                if (this.auth != null ? !this.auth.equals(that.auth) : that.auth != null) return false;
                return this.restApiId != null ? this.restApiId.equals(that.restApiId) : that.restApiId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.method.hashCode();
                result = 31 * result + (this.path.hashCode());
                result = 31 * result + (this.auth != null ? this.auth.hashCode() : 0);
                result = 31 * result + (this.restApiId != null ? this.restApiId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * Object customStatements;
     * AuthProperty authProperty = AuthProperty.builder()
     *         .apiKeyRequired(false)
     *         .authorizationScopes(List.of("authorizationScopes"))
     *         .authorizer("authorizer")
     *         .resourcePolicy(AuthResourcePolicyProperty.builder()
     *                 .awsAccountBlacklist(List.of("awsAccountBlacklist"))
     *                 .awsAccountWhitelist(List.of("awsAccountWhitelist"))
     *                 .customStatements(List.of(customStatements))
     *                 .intrinsicVpcBlacklist(List.of("intrinsicVpcBlacklist"))
     *                 .intrinsicVpceBlacklist(List.of("intrinsicVpceBlacklist"))
     *                 .intrinsicVpceWhitelist(List.of("intrinsicVpceWhitelist"))
     *                 .intrinsicVpcWhitelist(List.of("intrinsicVpcWhitelist"))
     *                 .ipRangeBlacklist(List.of("ipRangeBlacklist"))
     *                 .ipRangeWhitelist(List.of("ipRangeWhitelist"))
     *                 .sourceVpcBlacklist(List.of("sourceVpcBlacklist"))
     *                 .sourceVpcWhitelist(List.of("sourceVpcWhitelist"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.AuthProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.AuthProperty.ApiKeyRequired`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getApiKeyRequired() {
            return null;
        }

        /**
         * `CfnFunction.AuthProperty.AuthorizationScopes`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAuthorizationScopes() {
            return null;
        }

        /**
         * `CfnFunction.AuthProperty.Authorizer`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizer() {
            return null;
        }

        /**
         * `CfnFunction.AuthProperty.ResourcePolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourcePolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthProperty> {
            java.lang.Object apiKeyRequired;
            java.util.List<java.lang.String> authorizationScopes;
            java.lang.String authorizer;
            java.lang.Object resourcePolicy;

            /**
             * Sets the value of {@link AuthProperty#getApiKeyRequired}
             * @param apiKeyRequired `CfnFunction.AuthProperty.ApiKeyRequired`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiKeyRequired(java.lang.Boolean apiKeyRequired) {
                this.apiKeyRequired = apiKeyRequired;
                return this;
            }

            /**
             * Sets the value of {@link AuthProperty#getApiKeyRequired}
             * @param apiKeyRequired `CfnFunction.AuthProperty.ApiKeyRequired`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiKeyRequired(software.amazon.awscdk.core.IResolvable apiKeyRequired) {
                this.apiKeyRequired = apiKeyRequired;
                return this;
            }

            /**
             * Sets the value of {@link AuthProperty#getAuthorizationScopes}
             * @param authorizationScopes `CfnFunction.AuthProperty.AuthorizationScopes`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationScopes(java.util.List<java.lang.String> authorizationScopes) {
                this.authorizationScopes = authorizationScopes;
                return this;
            }

            /**
             * Sets the value of {@link AuthProperty#getAuthorizer}
             * @param authorizer `CfnFunction.AuthProperty.Authorizer`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizer(java.lang.String authorizer) {
                this.authorizer = authorizer;
                return this;
            }

            /**
             * Sets the value of {@link AuthProperty#getResourcePolicy}
             * @param resourcePolicy `CfnFunction.AuthProperty.ResourcePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourcePolicy(software.amazon.awscdk.core.IResolvable resourcePolicy) {
                this.resourcePolicy = resourcePolicy;
                return this;
            }

            /**
             * Sets the value of {@link AuthProperty#getResourcePolicy}
             * @param resourcePolicy `CfnFunction.AuthProperty.ResourcePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourcePolicy(software.amazon.awscdk.services.sam.CfnFunction.AuthResourcePolicyProperty resourcePolicy) {
                this.resourcePolicy = resourcePolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthProperty {
            private final java.lang.Object apiKeyRequired;
            private final java.util.List<java.lang.String> authorizationScopes;
            private final java.lang.String authorizer;
            private final java.lang.Object resourcePolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.apiKeyRequired = software.amazon.jsii.Kernel.get(this, "apiKeyRequired", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.authorizationScopes = software.amazon.jsii.Kernel.get(this, "authorizationScopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.authorizer = software.amazon.jsii.Kernel.get(this, "authorizer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourcePolicy = software.amazon.jsii.Kernel.get(this, "resourcePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.apiKeyRequired = builder.apiKeyRequired;
                this.authorizationScopes = builder.authorizationScopes;
                this.authorizer = builder.authorizer;
                this.resourcePolicy = builder.resourcePolicy;
            }

            @Override
            public final java.lang.Object getApiKeyRequired() {
                return this.apiKeyRequired;
            }

            @Override
            public final java.util.List<java.lang.String> getAuthorizationScopes() {
                return this.authorizationScopes;
            }

            @Override
            public final java.lang.String getAuthorizer() {
                return this.authorizer;
            }

            @Override
            public final java.lang.Object getResourcePolicy() {
                return this.resourcePolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApiKeyRequired() != null) {
                    data.set("apiKeyRequired", om.valueToTree(this.getApiKeyRequired()));
                }
                if (this.getAuthorizationScopes() != null) {
                    data.set("authorizationScopes", om.valueToTree(this.getAuthorizationScopes()));
                }
                if (this.getAuthorizer() != null) {
                    data.set("authorizer", om.valueToTree(this.getAuthorizer()));
                }
                if (this.getResourcePolicy() != null) {
                    data.set("resourcePolicy", om.valueToTree(this.getResourcePolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.AuthProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthProperty.Jsii$Proxy that = (AuthProperty.Jsii$Proxy) o;

                if (this.apiKeyRequired != null ? !this.apiKeyRequired.equals(that.apiKeyRequired) : that.apiKeyRequired != null) return false;
                if (this.authorizationScopes != null ? !this.authorizationScopes.equals(that.authorizationScopes) : that.authorizationScopes != null) return false;
                if (this.authorizer != null ? !this.authorizer.equals(that.authorizer) : that.authorizer != null) return false;
                return this.resourcePolicy != null ? this.resourcePolicy.equals(that.resourcePolicy) : that.resourcePolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.apiKeyRequired != null ? this.apiKeyRequired.hashCode() : 0;
                result = 31 * result + (this.authorizationScopes != null ? this.authorizationScopes.hashCode() : 0);
                result = 31 * result + (this.authorizer != null ? this.authorizer.hashCode() : 0);
                result = 31 * result + (this.resourcePolicy != null ? this.resourcePolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * Object customStatements;
     * AuthResourcePolicyProperty authResourcePolicyProperty = AuthResourcePolicyProperty.builder()
     *         .awsAccountBlacklist(List.of("awsAccountBlacklist"))
     *         .awsAccountWhitelist(List.of("awsAccountWhitelist"))
     *         .customStatements(List.of(customStatements))
     *         .intrinsicVpcBlacklist(List.of("intrinsicVpcBlacklist"))
     *         .intrinsicVpceBlacklist(List.of("intrinsicVpceBlacklist"))
     *         .intrinsicVpceWhitelist(List.of("intrinsicVpceWhitelist"))
     *         .intrinsicVpcWhitelist(List.of("intrinsicVpcWhitelist"))
     *         .ipRangeBlacklist(List.of("ipRangeBlacklist"))
     *         .ipRangeWhitelist(List.of("ipRangeWhitelist"))
     *         .sourceVpcBlacklist(List.of("sourceVpcBlacklist"))
     *         .sourceVpcWhitelist(List.of("sourceVpcWhitelist"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.AuthResourcePolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthResourcePolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthResourcePolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.AuthResourcePolicyProperty.AwsAccountBlacklist`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAwsAccountBlacklist() {
            return null;
        }

        /**
         * `CfnFunction.AuthResourcePolicyProperty.AwsAccountWhitelist`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAwsAccountWhitelist() {
            return null;
        }

        /**
         * `CfnFunction.AuthResourcePolicyProperty.CustomStatements`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomStatements() {
            return null;
        }

        /**
         * `CfnFunction.AuthResourcePolicyProperty.IntrinsicVpcBlacklist`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIntrinsicVpcBlacklist() {
            return null;
        }

        /**
         * `CfnFunction.AuthResourcePolicyProperty.IntrinsicVpceBlacklist`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIntrinsicVpceBlacklist() {
            return null;
        }

        /**
         * `CfnFunction.AuthResourcePolicyProperty.IntrinsicVpceWhitelist`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIntrinsicVpceWhitelist() {
            return null;
        }

        /**
         * `CfnFunction.AuthResourcePolicyProperty.IntrinsicVpcWhitelist`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIntrinsicVpcWhitelist() {
            return null;
        }

        /**
         * `CfnFunction.AuthResourcePolicyProperty.IpRangeBlacklist`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIpRangeBlacklist() {
            return null;
        }

        /**
         * `CfnFunction.AuthResourcePolicyProperty.IpRangeWhitelist`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIpRangeWhitelist() {
            return null;
        }

        /**
         * `CfnFunction.AuthResourcePolicyProperty.SourceVpcBlacklist`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSourceVpcBlacklist() {
            return null;
        }

        /**
         * `CfnFunction.AuthResourcePolicyProperty.SourceVpcWhitelist`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSourceVpcWhitelist() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthResourcePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthResourcePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthResourcePolicyProperty> {
            java.util.List<java.lang.String> awsAccountBlacklist;
            java.util.List<java.lang.String> awsAccountWhitelist;
            java.lang.Object customStatements;
            java.util.List<java.lang.String> intrinsicVpcBlacklist;
            java.util.List<java.lang.String> intrinsicVpceBlacklist;
            java.util.List<java.lang.String> intrinsicVpceWhitelist;
            java.util.List<java.lang.String> intrinsicVpcWhitelist;
            java.util.List<java.lang.String> ipRangeBlacklist;
            java.util.List<java.lang.String> ipRangeWhitelist;
            java.util.List<java.lang.String> sourceVpcBlacklist;
            java.util.List<java.lang.String> sourceVpcWhitelist;

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getAwsAccountBlacklist}
             * @param awsAccountBlacklist `CfnFunction.AuthResourcePolicyProperty.AwsAccountBlacklist`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsAccountBlacklist(java.util.List<java.lang.String> awsAccountBlacklist) {
                this.awsAccountBlacklist = awsAccountBlacklist;
                return this;
            }

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getAwsAccountWhitelist}
             * @param awsAccountWhitelist `CfnFunction.AuthResourcePolicyProperty.AwsAccountWhitelist`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsAccountWhitelist(java.util.List<java.lang.String> awsAccountWhitelist) {
                this.awsAccountWhitelist = awsAccountWhitelist;
                return this;
            }

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getCustomStatements}
             * @param customStatements `CfnFunction.AuthResourcePolicyProperty.CustomStatements`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customStatements(java.util.List<? extends java.lang.Object> customStatements) {
                this.customStatements = customStatements;
                return this;
            }

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getCustomStatements}
             * @param customStatements `CfnFunction.AuthResourcePolicyProperty.CustomStatements`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customStatements(software.amazon.awscdk.core.IResolvable customStatements) {
                this.customStatements = customStatements;
                return this;
            }

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getIntrinsicVpcBlacklist}
             * @param intrinsicVpcBlacklist `CfnFunction.AuthResourcePolicyProperty.IntrinsicVpcBlacklist`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intrinsicVpcBlacklist(java.util.List<java.lang.String> intrinsicVpcBlacklist) {
                this.intrinsicVpcBlacklist = intrinsicVpcBlacklist;
                return this;
            }

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getIntrinsicVpceBlacklist}
             * @param intrinsicVpceBlacklist `CfnFunction.AuthResourcePolicyProperty.IntrinsicVpceBlacklist`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intrinsicVpceBlacklist(java.util.List<java.lang.String> intrinsicVpceBlacklist) {
                this.intrinsicVpceBlacklist = intrinsicVpceBlacklist;
                return this;
            }

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getIntrinsicVpceWhitelist}
             * @param intrinsicVpceWhitelist `CfnFunction.AuthResourcePolicyProperty.IntrinsicVpceWhitelist`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intrinsicVpceWhitelist(java.util.List<java.lang.String> intrinsicVpceWhitelist) {
                this.intrinsicVpceWhitelist = intrinsicVpceWhitelist;
                return this;
            }

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getIntrinsicVpcWhitelist}
             * @param intrinsicVpcWhitelist `CfnFunction.AuthResourcePolicyProperty.IntrinsicVpcWhitelist`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intrinsicVpcWhitelist(java.util.List<java.lang.String> intrinsicVpcWhitelist) {
                this.intrinsicVpcWhitelist = intrinsicVpcWhitelist;
                return this;
            }

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getIpRangeBlacklist}
             * @param ipRangeBlacklist `CfnFunction.AuthResourcePolicyProperty.IpRangeBlacklist`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipRangeBlacklist(java.util.List<java.lang.String> ipRangeBlacklist) {
                this.ipRangeBlacklist = ipRangeBlacklist;
                return this;
            }

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getIpRangeWhitelist}
             * @param ipRangeWhitelist `CfnFunction.AuthResourcePolicyProperty.IpRangeWhitelist`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipRangeWhitelist(java.util.List<java.lang.String> ipRangeWhitelist) {
                this.ipRangeWhitelist = ipRangeWhitelist;
                return this;
            }

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getSourceVpcBlacklist}
             * @param sourceVpcBlacklist `CfnFunction.AuthResourcePolicyProperty.SourceVpcBlacklist`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceVpcBlacklist(java.util.List<java.lang.String> sourceVpcBlacklist) {
                this.sourceVpcBlacklist = sourceVpcBlacklist;
                return this;
            }

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getSourceVpcWhitelist}
             * @param sourceVpcWhitelist `CfnFunction.AuthResourcePolicyProperty.SourceVpcWhitelist`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceVpcWhitelist(java.util.List<java.lang.String> sourceVpcWhitelist) {
                this.sourceVpcWhitelist = sourceVpcWhitelist;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthResourcePolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthResourcePolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthResourcePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthResourcePolicyProperty {
            private final java.util.List<java.lang.String> awsAccountBlacklist;
            private final java.util.List<java.lang.String> awsAccountWhitelist;
            private final java.lang.Object customStatements;
            private final java.util.List<java.lang.String> intrinsicVpcBlacklist;
            private final java.util.List<java.lang.String> intrinsicVpceBlacklist;
            private final java.util.List<java.lang.String> intrinsicVpceWhitelist;
            private final java.util.List<java.lang.String> intrinsicVpcWhitelist;
            private final java.util.List<java.lang.String> ipRangeBlacklist;
            private final java.util.List<java.lang.String> ipRangeWhitelist;
            private final java.util.List<java.lang.String> sourceVpcBlacklist;
            private final java.util.List<java.lang.String> sourceVpcWhitelist;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsAccountBlacklist = software.amazon.jsii.Kernel.get(this, "awsAccountBlacklist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.awsAccountWhitelist = software.amazon.jsii.Kernel.get(this, "awsAccountWhitelist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.customStatements = software.amazon.jsii.Kernel.get(this, "customStatements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.intrinsicVpcBlacklist = software.amazon.jsii.Kernel.get(this, "intrinsicVpcBlacklist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.intrinsicVpceBlacklist = software.amazon.jsii.Kernel.get(this, "intrinsicVpceBlacklist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.intrinsicVpceWhitelist = software.amazon.jsii.Kernel.get(this, "intrinsicVpceWhitelist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.intrinsicVpcWhitelist = software.amazon.jsii.Kernel.get(this, "intrinsicVpcWhitelist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.ipRangeBlacklist = software.amazon.jsii.Kernel.get(this, "ipRangeBlacklist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.ipRangeWhitelist = software.amazon.jsii.Kernel.get(this, "ipRangeWhitelist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.sourceVpcBlacklist = software.amazon.jsii.Kernel.get(this, "sourceVpcBlacklist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.sourceVpcWhitelist = software.amazon.jsii.Kernel.get(this, "sourceVpcWhitelist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsAccountBlacklist = builder.awsAccountBlacklist;
                this.awsAccountWhitelist = builder.awsAccountWhitelist;
                this.customStatements = builder.customStatements;
                this.intrinsicVpcBlacklist = builder.intrinsicVpcBlacklist;
                this.intrinsicVpceBlacklist = builder.intrinsicVpceBlacklist;
                this.intrinsicVpceWhitelist = builder.intrinsicVpceWhitelist;
                this.intrinsicVpcWhitelist = builder.intrinsicVpcWhitelist;
                this.ipRangeBlacklist = builder.ipRangeBlacklist;
                this.ipRangeWhitelist = builder.ipRangeWhitelist;
                this.sourceVpcBlacklist = builder.sourceVpcBlacklist;
                this.sourceVpcWhitelist = builder.sourceVpcWhitelist;
            }

            @Override
            public final java.util.List<java.lang.String> getAwsAccountBlacklist() {
                return this.awsAccountBlacklist;
            }

            @Override
            public final java.util.List<java.lang.String> getAwsAccountWhitelist() {
                return this.awsAccountWhitelist;
            }

            @Override
            public final java.lang.Object getCustomStatements() {
                return this.customStatements;
            }

            @Override
            public final java.util.List<java.lang.String> getIntrinsicVpcBlacklist() {
                return this.intrinsicVpcBlacklist;
            }

            @Override
            public final java.util.List<java.lang.String> getIntrinsicVpceBlacklist() {
                return this.intrinsicVpceBlacklist;
            }

            @Override
            public final java.util.List<java.lang.String> getIntrinsicVpceWhitelist() {
                return this.intrinsicVpceWhitelist;
            }

            @Override
            public final java.util.List<java.lang.String> getIntrinsicVpcWhitelist() {
                return this.intrinsicVpcWhitelist;
            }

            @Override
            public final java.util.List<java.lang.String> getIpRangeBlacklist() {
                return this.ipRangeBlacklist;
            }

            @Override
            public final java.util.List<java.lang.String> getIpRangeWhitelist() {
                return this.ipRangeWhitelist;
            }

            @Override
            public final java.util.List<java.lang.String> getSourceVpcBlacklist() {
                return this.sourceVpcBlacklist;
            }

            @Override
            public final java.util.List<java.lang.String> getSourceVpcWhitelist() {
                return this.sourceVpcWhitelist;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAwsAccountBlacklist() != null) {
                    data.set("awsAccountBlacklist", om.valueToTree(this.getAwsAccountBlacklist()));
                }
                if (this.getAwsAccountWhitelist() != null) {
                    data.set("awsAccountWhitelist", om.valueToTree(this.getAwsAccountWhitelist()));
                }
                if (this.getCustomStatements() != null) {
                    data.set("customStatements", om.valueToTree(this.getCustomStatements()));
                }
                if (this.getIntrinsicVpcBlacklist() != null) {
                    data.set("intrinsicVpcBlacklist", om.valueToTree(this.getIntrinsicVpcBlacklist()));
                }
                if (this.getIntrinsicVpceBlacklist() != null) {
                    data.set("intrinsicVpceBlacklist", om.valueToTree(this.getIntrinsicVpceBlacklist()));
                }
                if (this.getIntrinsicVpceWhitelist() != null) {
                    data.set("intrinsicVpceWhitelist", om.valueToTree(this.getIntrinsicVpceWhitelist()));
                }
                if (this.getIntrinsicVpcWhitelist() != null) {
                    data.set("intrinsicVpcWhitelist", om.valueToTree(this.getIntrinsicVpcWhitelist()));
                }
                if (this.getIpRangeBlacklist() != null) {
                    data.set("ipRangeBlacklist", om.valueToTree(this.getIpRangeBlacklist()));
                }
                if (this.getIpRangeWhitelist() != null) {
                    data.set("ipRangeWhitelist", om.valueToTree(this.getIpRangeWhitelist()));
                }
                if (this.getSourceVpcBlacklist() != null) {
                    data.set("sourceVpcBlacklist", om.valueToTree(this.getSourceVpcBlacklist()));
                }
                if (this.getSourceVpcWhitelist() != null) {
                    data.set("sourceVpcWhitelist", om.valueToTree(this.getSourceVpcWhitelist()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.AuthResourcePolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthResourcePolicyProperty.Jsii$Proxy that = (AuthResourcePolicyProperty.Jsii$Proxy) o;

                if (this.awsAccountBlacklist != null ? !this.awsAccountBlacklist.equals(that.awsAccountBlacklist) : that.awsAccountBlacklist != null) return false;
                if (this.awsAccountWhitelist != null ? !this.awsAccountWhitelist.equals(that.awsAccountWhitelist) : that.awsAccountWhitelist != null) return false;
                if (this.customStatements != null ? !this.customStatements.equals(that.customStatements) : that.customStatements != null) return false;
                if (this.intrinsicVpcBlacklist != null ? !this.intrinsicVpcBlacklist.equals(that.intrinsicVpcBlacklist) : that.intrinsicVpcBlacklist != null) return false;
                if (this.intrinsicVpceBlacklist != null ? !this.intrinsicVpceBlacklist.equals(that.intrinsicVpceBlacklist) : that.intrinsicVpceBlacklist != null) return false;
                if (this.intrinsicVpceWhitelist != null ? !this.intrinsicVpceWhitelist.equals(that.intrinsicVpceWhitelist) : that.intrinsicVpceWhitelist != null) return false;
                if (this.intrinsicVpcWhitelist != null ? !this.intrinsicVpcWhitelist.equals(that.intrinsicVpcWhitelist) : that.intrinsicVpcWhitelist != null) return false;
                if (this.ipRangeBlacklist != null ? !this.ipRangeBlacklist.equals(that.ipRangeBlacklist) : that.ipRangeBlacklist != null) return false;
                if (this.ipRangeWhitelist != null ? !this.ipRangeWhitelist.equals(that.ipRangeWhitelist) : that.ipRangeWhitelist != null) return false;
                if (this.sourceVpcBlacklist != null ? !this.sourceVpcBlacklist.equals(that.sourceVpcBlacklist) : that.sourceVpcBlacklist != null) return false;
                return this.sourceVpcWhitelist != null ? this.sourceVpcWhitelist.equals(that.sourceVpcWhitelist) : that.sourceVpcWhitelist == null;
            }

            @Override
            public final int hashCode() {
                int result = this.awsAccountBlacklist != null ? this.awsAccountBlacklist.hashCode() : 0;
                result = 31 * result + (this.awsAccountWhitelist != null ? this.awsAccountWhitelist.hashCode() : 0);
                result = 31 * result + (this.customStatements != null ? this.customStatements.hashCode() : 0);
                result = 31 * result + (this.intrinsicVpcBlacklist != null ? this.intrinsicVpcBlacklist.hashCode() : 0);
                result = 31 * result + (this.intrinsicVpceBlacklist != null ? this.intrinsicVpceBlacklist.hashCode() : 0);
                result = 31 * result + (this.intrinsicVpceWhitelist != null ? this.intrinsicVpceWhitelist.hashCode() : 0);
                result = 31 * result + (this.intrinsicVpcWhitelist != null ? this.intrinsicVpcWhitelist.hashCode() : 0);
                result = 31 * result + (this.ipRangeBlacklist != null ? this.ipRangeBlacklist.hashCode() : 0);
                result = 31 * result + (this.ipRangeWhitelist != null ? this.ipRangeWhitelist.hashCode() : 0);
                result = 31 * result + (this.sourceVpcBlacklist != null ? this.sourceVpcBlacklist.hashCode() : 0);
                result = 31 * result + (this.sourceVpcWhitelist != null ? this.sourceVpcWhitelist.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * BucketSAMPTProperty bucketSAMPTProperty = BucketSAMPTProperty.builder()
     *         .bucketName("bucketName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.BucketSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(BucketSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BucketSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.BucketSAMPTProperty.BucketName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * @return a {@link Builder} of {@link BucketSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BucketSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BucketSAMPTProperty> {
            java.lang.String bucketName;

            /**
             * Sets the value of {@link BucketSAMPTProperty#getBucketName}
             * @param bucketName `CfnFunction.BucketSAMPTProperty.BucketName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BucketSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BucketSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BucketSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BucketSAMPTProperty {
            private final java.lang.String bucketName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.BucketSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BucketSAMPTProperty.Jsii$Proxy that = (BucketSAMPTProperty.Jsii$Proxy) o;

                return this.bucketName.equals(that.bucketName);
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * Object pattern;
     * CloudWatchEventEventProperty cloudWatchEventEventProperty = CloudWatchEventEventProperty.builder()
     *         .pattern(pattern)
     *         // the properties below are optional
     *         .input("input")
     *         .inputPath("inputPath")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.CloudWatchEventEventProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchEventEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchEventEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.CloudWatchEventEventProperty.Pattern`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPattern();

        /**
         * `CfnFunction.CloudWatchEventEventProperty.Input`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInput() {
            return null;
        }

        /**
         * `CfnFunction.CloudWatchEventEventProperty.InputPath`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudWatchEventEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchEventEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchEventEventProperty> {
            java.lang.Object pattern;
            java.lang.String input;
            java.lang.String inputPath;

            /**
             * Sets the value of {@link CloudWatchEventEventProperty#getPattern}
             * @param pattern `CfnFunction.CloudWatchEventEventProperty.Pattern`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pattern(java.lang.Object pattern) {
                this.pattern = pattern;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchEventEventProperty#getInput}
             * @param input `CfnFunction.CloudWatchEventEventProperty.Input`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder input(java.lang.String input) {
                this.input = input;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchEventEventProperty#getInputPath}
             * @param inputPath `CfnFunction.CloudWatchEventEventProperty.InputPath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputPath(java.lang.String inputPath) {
                this.inputPath = inputPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchEventEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchEventEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchEventEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchEventEventProperty {
            private final java.lang.Object pattern;
            private final java.lang.String input;
            private final java.lang.String inputPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pattern = software.amazon.jsii.Kernel.get(this, "pattern", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pattern = java.util.Objects.requireNonNull(builder.pattern, "pattern is required");
                this.input = builder.input;
                this.inputPath = builder.inputPath;
            }

            @Override
            public final java.lang.Object getPattern() {
                return this.pattern;
            }

            @Override
            public final java.lang.String getInput() {
                return this.input;
            }

            @Override
            public final java.lang.String getInputPath() {
                return this.inputPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("pattern", om.valueToTree(this.getPattern()));
                if (this.getInput() != null) {
                    data.set("input", om.valueToTree(this.getInput()));
                }
                if (this.getInputPath() != null) {
                    data.set("inputPath", om.valueToTree(this.getInputPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.CloudWatchEventEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchEventEventProperty.Jsii$Proxy that = (CloudWatchEventEventProperty.Jsii$Proxy) o;

                if (!pattern.equals(that.pattern)) return false;
                if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
                return this.inputPath != null ? this.inputPath.equals(that.inputPath) : that.inputPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.pattern.hashCode();
                result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
                result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * CloudWatchLogsEventProperty cloudWatchLogsEventProperty = CloudWatchLogsEventProperty.builder()
     *         .filterPattern("filterPattern")
     *         .logGroupName("logGroupName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.CloudWatchLogsEventProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchLogsEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchLogsEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.CloudWatchLogsEventProperty.FilterPattern`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFilterPattern();

        /**
         * `CfnFunction.CloudWatchLogsEventProperty.LogGroupName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogGroupName();

        /**
         * @return a {@link Builder} of {@link CloudWatchLogsEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchLogsEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchLogsEventProperty> {
            java.lang.String filterPattern;
            java.lang.String logGroupName;

            /**
             * Sets the value of {@link CloudWatchLogsEventProperty#getFilterPattern}
             * @param filterPattern `CfnFunction.CloudWatchLogsEventProperty.FilterPattern`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterPattern(java.lang.String filterPattern) {
                this.filterPattern = filterPattern;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLogsEventProperty#getLogGroupName}
             * @param logGroupName `CfnFunction.CloudWatchLogsEventProperty.LogGroupName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroupName(java.lang.String logGroupName) {
                this.logGroupName = logGroupName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchLogsEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchLogsEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchLogsEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchLogsEventProperty {
            private final java.lang.String filterPattern;
            private final java.lang.String logGroupName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.filterPattern = software.amazon.jsii.Kernel.get(this, "filterPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logGroupName = software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.filterPattern = java.util.Objects.requireNonNull(builder.filterPattern, "filterPattern is required");
                this.logGroupName = java.util.Objects.requireNonNull(builder.logGroupName, "logGroupName is required");
            }

            @Override
            public final java.lang.String getFilterPattern() {
                return this.filterPattern;
            }

            @Override
            public final java.lang.String getLogGroupName() {
                return this.logGroupName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("filterPattern", om.valueToTree(this.getFilterPattern()));
                data.set("logGroupName", om.valueToTree(this.getLogGroupName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.CloudWatchLogsEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchLogsEventProperty.Jsii$Proxy that = (CloudWatchLogsEventProperty.Jsii$Proxy) o;

                if (!filterPattern.equals(that.filterPattern)) return false;
                return this.logGroupName.equals(that.logGroupName);
            }

            @Override
            public final int hashCode() {
                int result = this.filterPattern.hashCode();
                result = 31 * result + (this.logGroupName.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * CollectionSAMPTProperty collectionSAMPTProperty = CollectionSAMPTProperty.builder()
     *         .collectionId("collectionId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.CollectionSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(CollectionSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CollectionSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.CollectionSAMPTProperty.CollectionId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCollectionId();

        /**
         * @return a {@link Builder} of {@link CollectionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CollectionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CollectionSAMPTProperty> {
            java.lang.String collectionId;

            /**
             * Sets the value of {@link CollectionSAMPTProperty#getCollectionId}
             * @param collectionId `CfnFunction.CollectionSAMPTProperty.CollectionId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder collectionId(java.lang.String collectionId) {
                this.collectionId = collectionId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CollectionSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CollectionSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CollectionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CollectionSAMPTProperty {
            private final java.lang.String collectionId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.collectionId = software.amazon.jsii.Kernel.get(this, "collectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.collectionId = java.util.Objects.requireNonNull(builder.collectionId, "collectionId is required");
            }

            @Override
            public final java.lang.String getCollectionId() {
                return this.collectionId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("collectionId", om.valueToTree(this.getCollectionId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.CollectionSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CollectionSAMPTProperty.Jsii$Proxy that = (CollectionSAMPTProperty.Jsii$Proxy) o;

                return this.collectionId.equals(that.collectionId);
            }

            @Override
            public final int hashCode() {
                int result = this.collectionId.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * DeadLetterQueueProperty deadLetterQueueProperty = DeadLetterQueueProperty.builder()
     *         .targetArn("targetArn")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.DeadLetterQueueProperty")
    @software.amazon.jsii.Jsii.Proxy(DeadLetterQueueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeadLetterQueueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.DeadLetterQueueProperty.TargetArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetArn();

        /**
         * `CfnFunction.DeadLetterQueueProperty.Type`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link DeadLetterQueueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeadLetterQueueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeadLetterQueueProperty> {
            java.lang.String targetArn;
            java.lang.String type;

            /**
             * Sets the value of {@link DeadLetterQueueProperty#getTargetArn}
             * @param targetArn `CfnFunction.DeadLetterQueueProperty.TargetArn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetArn(java.lang.String targetArn) {
                this.targetArn = targetArn;
                return this;
            }

            /**
             * Sets the value of {@link DeadLetterQueueProperty#getType}
             * @param type `CfnFunction.DeadLetterQueueProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeadLetterQueueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeadLetterQueueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeadLetterQueueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeadLetterQueueProperty {
            private final java.lang.String targetArn;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetArn = software.amazon.jsii.Kernel.get(this, "targetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetArn = java.util.Objects.requireNonNull(builder.targetArn, "targetArn is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getTargetArn() {
                return this.targetArn;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetArn", om.valueToTree(this.getTargetArn()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.DeadLetterQueueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeadLetterQueueProperty.Jsii$Proxy that = (DeadLetterQueueProperty.Jsii$Proxy) o;

                if (!targetArn.equals(that.targetArn)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.targetArn.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * DeploymentPreferenceProperty deploymentPreferenceProperty = DeploymentPreferenceProperty.builder()
     *         .enabled(false)
     *         .type("type")
     *         // the properties below are optional
     *         .alarms(List.of("alarms"))
     *         .hooks(List.of("hooks"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.DeploymentPreferenceProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentPreferenceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentPreferenceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.DeploymentPreferenceProperty.Enabled`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * `CfnFunction.DeploymentPreferenceProperty.Type`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * `CfnFunction.DeploymentPreferenceProperty.Alarms`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAlarms() {
            return null;
        }

        /**
         * `CfnFunction.DeploymentPreferenceProperty.Hooks`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHooks() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeploymentPreferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentPreferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentPreferenceProperty> {
            java.lang.Object enabled;
            java.lang.String type;
            java.util.List<java.lang.String> alarms;
            java.util.List<java.lang.String> hooks;

            /**
             * Sets the value of {@link DeploymentPreferenceProperty#getEnabled}
             * @param enabled `CfnFunction.DeploymentPreferenceProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentPreferenceProperty#getEnabled}
             * @param enabled `CfnFunction.DeploymentPreferenceProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentPreferenceProperty#getType}
             * @param type `CfnFunction.DeploymentPreferenceProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentPreferenceProperty#getAlarms}
             * @param alarms `CfnFunction.DeploymentPreferenceProperty.Alarms`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarms(java.util.List<java.lang.String> alarms) {
                this.alarms = alarms;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentPreferenceProperty#getHooks}
             * @param hooks `CfnFunction.DeploymentPreferenceProperty.Hooks`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hooks(java.util.List<java.lang.String> hooks) {
                this.hooks = hooks;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentPreferenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentPreferenceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentPreferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentPreferenceProperty {
            private final java.lang.Object enabled;
            private final java.lang.String type;
            private final java.util.List<java.lang.String> alarms;
            private final java.util.List<java.lang.String> hooks;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.alarms = software.amazon.jsii.Kernel.get(this, "alarms", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.hooks = software.amazon.jsii.Kernel.get(this, "hooks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.alarms = builder.alarms;
                this.hooks = builder.hooks;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.util.List<java.lang.String> getAlarms() {
                return this.alarms;
            }

            @Override
            public final java.util.List<java.lang.String> getHooks() {
                return this.hooks;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getAlarms() != null) {
                    data.set("alarms", om.valueToTree(this.getAlarms()));
                }
                if (this.getHooks() != null) {
                    data.set("hooks", om.valueToTree(this.getHooks()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.DeploymentPreferenceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentPreferenceProperty.Jsii$Proxy that = (DeploymentPreferenceProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                if (!type.equals(that.type)) return false;
                if (this.alarms != null ? !this.alarms.equals(that.alarms) : that.alarms != null) return false;
                return this.hooks != null ? this.hooks.equals(that.hooks) : that.hooks == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.alarms != null ? this.alarms.hashCode() : 0);
                result = 31 * result + (this.hooks != null ? this.hooks.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * DestinationConfigProperty destinationConfigProperty = DestinationConfigProperty.builder()
     *         .onFailure(DestinationProperty.builder()
     *                 .destination("destination")
     *                 // the properties below are optional
     *                 .type("type")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.DestinationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DestinationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DestinationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.DestinationConfigProperty.OnFailure`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOnFailure();

        /**
         * @return a {@link Builder} of {@link DestinationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DestinationConfigProperty> {
            java.lang.Object onFailure;

            /**
             * Sets the value of {@link DestinationConfigProperty#getOnFailure}
             * @param onFailure `CfnFunction.DestinationConfigProperty.OnFailure`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onFailure(software.amazon.awscdk.core.IResolvable onFailure) {
                this.onFailure = onFailure;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConfigProperty#getOnFailure}
             * @param onFailure `CfnFunction.DestinationConfigProperty.OnFailure`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onFailure(software.amazon.awscdk.services.sam.CfnFunction.DestinationProperty onFailure) {
                this.onFailure = onFailure;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DestinationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DestinationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationConfigProperty {
            private final java.lang.Object onFailure;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.onFailure = software.amazon.jsii.Kernel.get(this, "onFailure", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.onFailure = java.util.Objects.requireNonNull(builder.onFailure, "onFailure is required");
            }

            @Override
            public final java.lang.Object getOnFailure() {
                return this.onFailure;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("onFailure", om.valueToTree(this.getOnFailure()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.DestinationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationConfigProperty.Jsii$Proxy that = (DestinationConfigProperty.Jsii$Proxy) o;

                return this.onFailure.equals(that.onFailure);
            }

            @Override
            public final int hashCode() {
                int result = this.onFailure.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * DestinationProperty destinationProperty = DestinationProperty.builder()
     *         .destination("destination")
     *         // the properties below are optional
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.DestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(DestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.DestinationProperty.Destination`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestination();

        /**
         * `CfnFunction.DestinationProperty.Type`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DestinationProperty> {
            java.lang.String destination;
            java.lang.String type;

            /**
             * Sets the value of {@link DestinationProperty#getDestination}
             * @param destination `CfnFunction.DestinationProperty.Destination`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(java.lang.String destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link DestinationProperty#getType}
             * @param type `CfnFunction.DestinationProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationProperty {
            private final java.lang.String destination;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destination", om.valueToTree(this.getDestination()));
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.DestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationProperty.Jsii$Proxy that = (DestinationProperty.Jsii$Proxy) o;

                if (!destination.equals(that.destination)) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * DomainSAMPTProperty domainSAMPTProperty = DomainSAMPTProperty.builder()
     *         .domainName("domainName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.DomainSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(DomainSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DomainSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.DomainSAMPTProperty.DomainName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

        /**
         * @return a {@link Builder} of {@link DomainSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DomainSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DomainSAMPTProperty> {
            java.lang.String domainName;

            /**
             * Sets the value of {@link DomainSAMPTProperty#getDomainName}
             * @param domainName `CfnFunction.DomainSAMPTProperty.DomainName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainName(java.lang.String domainName) {
                this.domainName = domainName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DomainSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DomainSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DomainSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainSAMPTProperty {
            private final java.lang.String domainName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            }

            @Override
            public final java.lang.String getDomainName() {
                return this.domainName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("domainName", om.valueToTree(this.getDomainName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.DomainSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DomainSAMPTProperty.Jsii$Proxy that = (DomainSAMPTProperty.Jsii$Proxy) o;

                return this.domainName.equals(that.domainName);
            }

            @Override
            public final int hashCode() {
                int result = this.domainName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * DynamoDBEventProperty dynamoDBEventProperty = DynamoDBEventProperty.builder()
     *         .startingPosition("startingPosition")
     *         .stream("stream")
     *         // the properties below are optional
     *         .batchSize(123)
     *         .bisectBatchOnFunctionError(false)
     *         .destinationConfig(DestinationConfigProperty.builder()
     *                 .onFailure(DestinationProperty.builder()
     *                         .destination("destination")
     *                         // the properties below are optional
     *                         .type("type")
     *                         .build())
     *                 .build())
     *         .enabled(false)
     *         .maximumBatchingWindowInSeconds(123)
     *         .maximumRecordAgeInSeconds(123)
     *         .maximumRetryAttempts(123)
     *         .parallelizationFactor(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.DynamoDBEventProperty")
    @software.amazon.jsii.Jsii.Proxy(DynamoDBEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynamoDBEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.DynamoDBEventProperty.StartingPosition`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStartingPosition();

        /**
         * `CfnFunction.DynamoDBEventProperty.Stream`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStream();

        /**
         * `CfnFunction.DynamoDBEventProperty.BatchSize`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBatchSize() {
            return null;
        }

        /**
         * `CfnFunction.DynamoDBEventProperty.BisectBatchOnFunctionError`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBisectBatchOnFunctionError() {
            return null;
        }

        /**
         * `CfnFunction.DynamoDBEventProperty.DestinationConfig`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestinationConfig() {
            return null;
        }

        /**
         * `CfnFunction.DynamoDBEventProperty.Enabled`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * `CfnFunction.DynamoDBEventProperty.MaximumBatchingWindowInSeconds`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumBatchingWindowInSeconds() {
            return null;
        }

        /**
         * `CfnFunction.DynamoDBEventProperty.MaximumRecordAgeInSeconds`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumRecordAgeInSeconds() {
            return null;
        }

        /**
         * `CfnFunction.DynamoDBEventProperty.MaximumRetryAttempts`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumRetryAttempts() {
            return null;
        }

        /**
         * `CfnFunction.DynamoDBEventProperty.ParallelizationFactor`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getParallelizationFactor() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DynamoDBEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynamoDBEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynamoDBEventProperty> {
            java.lang.String startingPosition;
            java.lang.String stream;
            java.lang.Number batchSize;
            java.lang.Object bisectBatchOnFunctionError;
            java.lang.Object destinationConfig;
            java.lang.Object enabled;
            java.lang.Number maximumBatchingWindowInSeconds;
            java.lang.Number maximumRecordAgeInSeconds;
            java.lang.Number maximumRetryAttempts;
            java.lang.Number parallelizationFactor;

            /**
             * Sets the value of {@link DynamoDBEventProperty#getStartingPosition}
             * @param startingPosition `CfnFunction.DynamoDBEventProperty.StartingPosition`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startingPosition(java.lang.String startingPosition) {
                this.startingPosition = startingPosition;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getStream}
             * @param stream `CfnFunction.DynamoDBEventProperty.Stream`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stream(java.lang.String stream) {
                this.stream = stream;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getBatchSize}
             * @param batchSize `CfnFunction.DynamoDBEventProperty.BatchSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchSize(java.lang.Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getBisectBatchOnFunctionError}
             * @param bisectBatchOnFunctionError `CfnFunction.DynamoDBEventProperty.BisectBatchOnFunctionError`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bisectBatchOnFunctionError(java.lang.Boolean bisectBatchOnFunctionError) {
                this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getBisectBatchOnFunctionError}
             * @param bisectBatchOnFunctionError `CfnFunction.DynamoDBEventProperty.BisectBatchOnFunctionError`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bisectBatchOnFunctionError(software.amazon.awscdk.core.IResolvable bisectBatchOnFunctionError) {
                this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getDestinationConfig}
             * @param destinationConfig `CfnFunction.DynamoDBEventProperty.DestinationConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationConfig(software.amazon.awscdk.core.IResolvable destinationConfig) {
                this.destinationConfig = destinationConfig;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getDestinationConfig}
             * @param destinationConfig `CfnFunction.DynamoDBEventProperty.DestinationConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationConfig(software.amazon.awscdk.services.sam.CfnFunction.DestinationConfigProperty destinationConfig) {
                this.destinationConfig = destinationConfig;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getEnabled}
             * @param enabled `CfnFunction.DynamoDBEventProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getEnabled}
             * @param enabled `CfnFunction.DynamoDBEventProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getMaximumBatchingWindowInSeconds}
             * @param maximumBatchingWindowInSeconds `CfnFunction.DynamoDBEventProperty.MaximumBatchingWindowInSeconds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumBatchingWindowInSeconds(java.lang.Number maximumBatchingWindowInSeconds) {
                this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getMaximumRecordAgeInSeconds}
             * @param maximumRecordAgeInSeconds `CfnFunction.DynamoDBEventProperty.MaximumRecordAgeInSeconds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumRecordAgeInSeconds(java.lang.Number maximumRecordAgeInSeconds) {
                this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getMaximumRetryAttempts}
             * @param maximumRetryAttempts `CfnFunction.DynamoDBEventProperty.MaximumRetryAttempts`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumRetryAttempts(java.lang.Number maximumRetryAttempts) {
                this.maximumRetryAttempts = maximumRetryAttempts;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getParallelizationFactor}
             * @param parallelizationFactor `CfnFunction.DynamoDBEventProperty.ParallelizationFactor`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parallelizationFactor(java.lang.Number parallelizationFactor) {
                this.parallelizationFactor = parallelizationFactor;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynamoDBEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynamoDBEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynamoDBEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamoDBEventProperty {
            private final java.lang.String startingPosition;
            private final java.lang.String stream;
            private final java.lang.Number batchSize;
            private final java.lang.Object bisectBatchOnFunctionError;
            private final java.lang.Object destinationConfig;
            private final java.lang.Object enabled;
            private final java.lang.Number maximumBatchingWindowInSeconds;
            private final java.lang.Number maximumRecordAgeInSeconds;
            private final java.lang.Number maximumRetryAttempts;
            private final java.lang.Number parallelizationFactor;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.startingPosition = software.amazon.jsii.Kernel.get(this, "startingPosition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stream = software.amazon.jsii.Kernel.get(this, "stream", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.batchSize = software.amazon.jsii.Kernel.get(this, "batchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.bisectBatchOnFunctionError = software.amazon.jsii.Kernel.get(this, "bisectBatchOnFunctionError", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.destinationConfig = software.amazon.jsii.Kernel.get(this, "destinationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maximumBatchingWindowInSeconds = software.amazon.jsii.Kernel.get(this, "maximumBatchingWindowInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumRecordAgeInSeconds = software.amazon.jsii.Kernel.get(this, "maximumRecordAgeInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumRetryAttempts = software.amazon.jsii.Kernel.get(this, "maximumRetryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.parallelizationFactor = software.amazon.jsii.Kernel.get(this, "parallelizationFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.startingPosition = java.util.Objects.requireNonNull(builder.startingPosition, "startingPosition is required");
                this.stream = java.util.Objects.requireNonNull(builder.stream, "stream is required");
                this.batchSize = builder.batchSize;
                this.bisectBatchOnFunctionError = builder.bisectBatchOnFunctionError;
                this.destinationConfig = builder.destinationConfig;
                this.enabled = builder.enabled;
                this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
                this.maximumRecordAgeInSeconds = builder.maximumRecordAgeInSeconds;
                this.maximumRetryAttempts = builder.maximumRetryAttempts;
                this.parallelizationFactor = builder.parallelizationFactor;
            }

            @Override
            public final java.lang.String getStartingPosition() {
                return this.startingPosition;
            }

            @Override
            public final java.lang.String getStream() {
                return this.stream;
            }

            @Override
            public final java.lang.Number getBatchSize() {
                return this.batchSize;
            }

            @Override
            public final java.lang.Object getBisectBatchOnFunctionError() {
                return this.bisectBatchOnFunctionError;
            }

            @Override
            public final java.lang.Object getDestinationConfig() {
                return this.destinationConfig;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Number getMaximumBatchingWindowInSeconds() {
                return this.maximumBatchingWindowInSeconds;
            }

            @Override
            public final java.lang.Number getMaximumRecordAgeInSeconds() {
                return this.maximumRecordAgeInSeconds;
            }

            @Override
            public final java.lang.Number getMaximumRetryAttempts() {
                return this.maximumRetryAttempts;
            }

            @Override
            public final java.lang.Number getParallelizationFactor() {
                return this.parallelizationFactor;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("startingPosition", om.valueToTree(this.getStartingPosition()));
                data.set("stream", om.valueToTree(this.getStream()));
                if (this.getBatchSize() != null) {
                    data.set("batchSize", om.valueToTree(this.getBatchSize()));
                }
                if (this.getBisectBatchOnFunctionError() != null) {
                    data.set("bisectBatchOnFunctionError", om.valueToTree(this.getBisectBatchOnFunctionError()));
                }
                if (this.getDestinationConfig() != null) {
                    data.set("destinationConfig", om.valueToTree(this.getDestinationConfig()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getMaximumBatchingWindowInSeconds() != null) {
                    data.set("maximumBatchingWindowInSeconds", om.valueToTree(this.getMaximumBatchingWindowInSeconds()));
                }
                if (this.getMaximumRecordAgeInSeconds() != null) {
                    data.set("maximumRecordAgeInSeconds", om.valueToTree(this.getMaximumRecordAgeInSeconds()));
                }
                if (this.getMaximumRetryAttempts() != null) {
                    data.set("maximumRetryAttempts", om.valueToTree(this.getMaximumRetryAttempts()));
                }
                if (this.getParallelizationFactor() != null) {
                    data.set("parallelizationFactor", om.valueToTree(this.getParallelizationFactor()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.DynamoDBEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynamoDBEventProperty.Jsii$Proxy that = (DynamoDBEventProperty.Jsii$Proxy) o;

                if (!startingPosition.equals(that.startingPosition)) return false;
                if (!stream.equals(that.stream)) return false;
                if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
                if (this.bisectBatchOnFunctionError != null ? !this.bisectBatchOnFunctionError.equals(that.bisectBatchOnFunctionError) : that.bisectBatchOnFunctionError != null) return false;
                if (this.destinationConfig != null ? !this.destinationConfig.equals(that.destinationConfig) : that.destinationConfig != null) return false;
                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.maximumBatchingWindowInSeconds != null ? !this.maximumBatchingWindowInSeconds.equals(that.maximumBatchingWindowInSeconds) : that.maximumBatchingWindowInSeconds != null) return false;
                if (this.maximumRecordAgeInSeconds != null ? !this.maximumRecordAgeInSeconds.equals(that.maximumRecordAgeInSeconds) : that.maximumRecordAgeInSeconds != null) return false;
                if (this.maximumRetryAttempts != null ? !this.maximumRetryAttempts.equals(that.maximumRetryAttempts) : that.maximumRetryAttempts != null) return false;
                return this.parallelizationFactor != null ? this.parallelizationFactor.equals(that.parallelizationFactor) : that.parallelizationFactor == null;
            }

            @Override
            public final int hashCode() {
                int result = this.startingPosition.hashCode();
                result = 31 * result + (this.stream.hashCode());
                result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
                result = 31 * result + (this.bisectBatchOnFunctionError != null ? this.bisectBatchOnFunctionError.hashCode() : 0);
                result = 31 * result + (this.destinationConfig != null ? this.destinationConfig.hashCode() : 0);
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                result = 31 * result + (this.maximumBatchingWindowInSeconds != null ? this.maximumBatchingWindowInSeconds.hashCode() : 0);
                result = 31 * result + (this.maximumRecordAgeInSeconds != null ? this.maximumRecordAgeInSeconds.hashCode() : 0);
                result = 31 * result + (this.maximumRetryAttempts != null ? this.maximumRetryAttempts.hashCode() : 0);
                result = 31 * result + (this.parallelizationFactor != null ? this.parallelizationFactor.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * EmptySAMPTProperty emptySAMPTProperty = EmptySAMPTProperty.builder().build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.EmptySAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(EmptySAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmptySAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @return a {@link Builder} of {@link EmptySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmptySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EmptySAMPTProperty> {

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmptySAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EmptySAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EmptySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmptySAMPTProperty {

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();


                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.EmptySAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * Object pattern;
     * EventBridgeRuleEventProperty eventBridgeRuleEventProperty = EventBridgeRuleEventProperty.builder()
     *         .pattern(pattern)
     *         // the properties below are optional
     *         .eventBusName("eventBusName")
     *         .input("input")
     *         .inputPath("inputPath")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.EventBridgeRuleEventProperty")
    @software.amazon.jsii.Jsii.Proxy(EventBridgeRuleEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventBridgeRuleEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.EventBridgeRuleEventProperty.Pattern`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPattern();

        /**
         * `CfnFunction.EventBridgeRuleEventProperty.EventBusName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEventBusName() {
            return null;
        }

        /**
         * `CfnFunction.EventBridgeRuleEventProperty.Input`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInput() {
            return null;
        }

        /**
         * `CfnFunction.EventBridgeRuleEventProperty.InputPath`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventBridgeRuleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventBridgeRuleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventBridgeRuleEventProperty> {
            java.lang.Object pattern;
            java.lang.String eventBusName;
            java.lang.String input;
            java.lang.String inputPath;

            /**
             * Sets the value of {@link EventBridgeRuleEventProperty#getPattern}
             * @param pattern `CfnFunction.EventBridgeRuleEventProperty.Pattern`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pattern(java.lang.Object pattern) {
                this.pattern = pattern;
                return this;
            }

            /**
             * Sets the value of {@link EventBridgeRuleEventProperty#getEventBusName}
             * @param eventBusName `CfnFunction.EventBridgeRuleEventProperty.EventBusName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBusName(java.lang.String eventBusName) {
                this.eventBusName = eventBusName;
                return this;
            }

            /**
             * Sets the value of {@link EventBridgeRuleEventProperty#getInput}
             * @param input `CfnFunction.EventBridgeRuleEventProperty.Input`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder input(java.lang.String input) {
                this.input = input;
                return this;
            }

            /**
             * Sets the value of {@link EventBridgeRuleEventProperty#getInputPath}
             * @param inputPath `CfnFunction.EventBridgeRuleEventProperty.InputPath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputPath(java.lang.String inputPath) {
                this.inputPath = inputPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventBridgeRuleEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventBridgeRuleEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventBridgeRuleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventBridgeRuleEventProperty {
            private final java.lang.Object pattern;
            private final java.lang.String eventBusName;
            private final java.lang.String input;
            private final java.lang.String inputPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pattern = software.amazon.jsii.Kernel.get(this, "pattern", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eventBusName = software.amazon.jsii.Kernel.get(this, "eventBusName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pattern = java.util.Objects.requireNonNull(builder.pattern, "pattern is required");
                this.eventBusName = builder.eventBusName;
                this.input = builder.input;
                this.inputPath = builder.inputPath;
            }

            @Override
            public final java.lang.Object getPattern() {
                return this.pattern;
            }

            @Override
            public final java.lang.String getEventBusName() {
                return this.eventBusName;
            }

            @Override
            public final java.lang.String getInput() {
                return this.input;
            }

            @Override
            public final java.lang.String getInputPath() {
                return this.inputPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("pattern", om.valueToTree(this.getPattern()));
                if (this.getEventBusName() != null) {
                    data.set("eventBusName", om.valueToTree(this.getEventBusName()));
                }
                if (this.getInput() != null) {
                    data.set("input", om.valueToTree(this.getInput()));
                }
                if (this.getInputPath() != null) {
                    data.set("inputPath", om.valueToTree(this.getInputPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.EventBridgeRuleEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventBridgeRuleEventProperty.Jsii$Proxy that = (EventBridgeRuleEventProperty.Jsii$Proxy) o;

                if (!pattern.equals(that.pattern)) return false;
                if (this.eventBusName != null ? !this.eventBusName.equals(that.eventBusName) : that.eventBusName != null) return false;
                if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
                return this.inputPath != null ? this.inputPath.equals(that.inputPath) : that.inputPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.pattern.hashCode();
                result = 31 * result + (this.eventBusName != null ? this.eventBusName.hashCode() : 0);
                result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
                result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * EventInvokeConfigProperty eventInvokeConfigProperty = EventInvokeConfigProperty.builder()
     *         .destinationConfig(EventInvokeDestinationConfigProperty.builder()
     *                 .onFailure(DestinationProperty.builder()
     *                         .destination("destination")
     *                         // the properties below are optional
     *                         .type("type")
     *                         .build())
     *                 .onSuccess(DestinationProperty.builder()
     *                         .destination("destination")
     *                         // the properties below are optional
     *                         .type("type")
     *                         .build())
     *                 .build())
     *         .maximumEventAgeInSeconds(123)
     *         .maximumRetryAttempts(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.EventInvokeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EventInvokeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventInvokeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.EventInvokeConfigProperty.DestinationConfig`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestinationConfig() {
            return null;
        }

        /**
         * `CfnFunction.EventInvokeConfigProperty.MaximumEventAgeInSeconds`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumEventAgeInSeconds() {
            return null;
        }

        /**
         * `CfnFunction.EventInvokeConfigProperty.MaximumRetryAttempts`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumRetryAttempts() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventInvokeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventInvokeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventInvokeConfigProperty> {
            java.lang.Object destinationConfig;
            java.lang.Number maximumEventAgeInSeconds;
            java.lang.Number maximumRetryAttempts;

            /**
             * Sets the value of {@link EventInvokeConfigProperty#getDestinationConfig}
             * @param destinationConfig `CfnFunction.EventInvokeConfigProperty.DestinationConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationConfig(software.amazon.awscdk.core.IResolvable destinationConfig) {
                this.destinationConfig = destinationConfig;
                return this;
            }

            /**
             * Sets the value of {@link EventInvokeConfigProperty#getDestinationConfig}
             * @param destinationConfig `CfnFunction.EventInvokeConfigProperty.DestinationConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationConfig(software.amazon.awscdk.services.sam.CfnFunction.EventInvokeDestinationConfigProperty destinationConfig) {
                this.destinationConfig = destinationConfig;
                return this;
            }

            /**
             * Sets the value of {@link EventInvokeConfigProperty#getMaximumEventAgeInSeconds}
             * @param maximumEventAgeInSeconds `CfnFunction.EventInvokeConfigProperty.MaximumEventAgeInSeconds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumEventAgeInSeconds(java.lang.Number maximumEventAgeInSeconds) {
                this.maximumEventAgeInSeconds = maximumEventAgeInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link EventInvokeConfigProperty#getMaximumRetryAttempts}
             * @param maximumRetryAttempts `CfnFunction.EventInvokeConfigProperty.MaximumRetryAttempts`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumRetryAttempts(java.lang.Number maximumRetryAttempts) {
                this.maximumRetryAttempts = maximumRetryAttempts;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventInvokeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventInvokeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventInvokeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventInvokeConfigProperty {
            private final java.lang.Object destinationConfig;
            private final java.lang.Number maximumEventAgeInSeconds;
            private final java.lang.Number maximumRetryAttempts;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationConfig = software.amazon.jsii.Kernel.get(this, "destinationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maximumEventAgeInSeconds = software.amazon.jsii.Kernel.get(this, "maximumEventAgeInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumRetryAttempts = software.amazon.jsii.Kernel.get(this, "maximumRetryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationConfig = builder.destinationConfig;
                this.maximumEventAgeInSeconds = builder.maximumEventAgeInSeconds;
                this.maximumRetryAttempts = builder.maximumRetryAttempts;
            }

            @Override
            public final java.lang.Object getDestinationConfig() {
                return this.destinationConfig;
            }

            @Override
            public final java.lang.Number getMaximumEventAgeInSeconds() {
                return this.maximumEventAgeInSeconds;
            }

            @Override
            public final java.lang.Number getMaximumRetryAttempts() {
                return this.maximumRetryAttempts;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestinationConfig() != null) {
                    data.set("destinationConfig", om.valueToTree(this.getDestinationConfig()));
                }
                if (this.getMaximumEventAgeInSeconds() != null) {
                    data.set("maximumEventAgeInSeconds", om.valueToTree(this.getMaximumEventAgeInSeconds()));
                }
                if (this.getMaximumRetryAttempts() != null) {
                    data.set("maximumRetryAttempts", om.valueToTree(this.getMaximumRetryAttempts()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.EventInvokeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventInvokeConfigProperty.Jsii$Proxy that = (EventInvokeConfigProperty.Jsii$Proxy) o;

                if (this.destinationConfig != null ? !this.destinationConfig.equals(that.destinationConfig) : that.destinationConfig != null) return false;
                if (this.maximumEventAgeInSeconds != null ? !this.maximumEventAgeInSeconds.equals(that.maximumEventAgeInSeconds) : that.maximumEventAgeInSeconds != null) return false;
                return this.maximumRetryAttempts != null ? this.maximumRetryAttempts.equals(that.maximumRetryAttempts) : that.maximumRetryAttempts == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationConfig != null ? this.destinationConfig.hashCode() : 0;
                result = 31 * result + (this.maximumEventAgeInSeconds != null ? this.maximumEventAgeInSeconds.hashCode() : 0);
                result = 31 * result + (this.maximumRetryAttempts != null ? this.maximumRetryAttempts.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * EventInvokeDestinationConfigProperty eventInvokeDestinationConfigProperty = EventInvokeDestinationConfigProperty.builder()
     *         .onFailure(DestinationProperty.builder()
     *                 .destination("destination")
     *                 // the properties below are optional
     *                 .type("type")
     *                 .build())
     *         .onSuccess(DestinationProperty.builder()
     *                 .destination("destination")
     *                 // the properties below are optional
     *                 .type("type")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.EventInvokeDestinationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EventInvokeDestinationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventInvokeDestinationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.EventInvokeDestinationConfigProperty.OnFailure`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOnFailure();

        /**
         * `CfnFunction.EventInvokeDestinationConfigProperty.OnSuccess`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOnSuccess();

        /**
         * @return a {@link Builder} of {@link EventInvokeDestinationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventInvokeDestinationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventInvokeDestinationConfigProperty> {
            java.lang.Object onFailure;
            java.lang.Object onSuccess;

            /**
             * Sets the value of {@link EventInvokeDestinationConfigProperty#getOnFailure}
             * @param onFailure `CfnFunction.EventInvokeDestinationConfigProperty.OnFailure`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onFailure(software.amazon.awscdk.core.IResolvable onFailure) {
                this.onFailure = onFailure;
                return this;
            }

            /**
             * Sets the value of {@link EventInvokeDestinationConfigProperty#getOnFailure}
             * @param onFailure `CfnFunction.EventInvokeDestinationConfigProperty.OnFailure`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onFailure(software.amazon.awscdk.services.sam.CfnFunction.DestinationProperty onFailure) {
                this.onFailure = onFailure;
                return this;
            }

            /**
             * Sets the value of {@link EventInvokeDestinationConfigProperty#getOnSuccess}
             * @param onSuccess `CfnFunction.EventInvokeDestinationConfigProperty.OnSuccess`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onSuccess(software.amazon.awscdk.core.IResolvable onSuccess) {
                this.onSuccess = onSuccess;
                return this;
            }

            /**
             * Sets the value of {@link EventInvokeDestinationConfigProperty#getOnSuccess}
             * @param onSuccess `CfnFunction.EventInvokeDestinationConfigProperty.OnSuccess`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onSuccess(software.amazon.awscdk.services.sam.CfnFunction.DestinationProperty onSuccess) {
                this.onSuccess = onSuccess;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventInvokeDestinationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventInvokeDestinationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventInvokeDestinationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventInvokeDestinationConfigProperty {
            private final java.lang.Object onFailure;
            private final java.lang.Object onSuccess;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.onFailure = software.amazon.jsii.Kernel.get(this, "onFailure", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.onSuccess = software.amazon.jsii.Kernel.get(this, "onSuccess", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.onFailure = java.util.Objects.requireNonNull(builder.onFailure, "onFailure is required");
                this.onSuccess = java.util.Objects.requireNonNull(builder.onSuccess, "onSuccess is required");
            }

            @Override
            public final java.lang.Object getOnFailure() {
                return this.onFailure;
            }

            @Override
            public final java.lang.Object getOnSuccess() {
                return this.onSuccess;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("onFailure", om.valueToTree(this.getOnFailure()));
                data.set("onSuccess", om.valueToTree(this.getOnSuccess()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.EventInvokeDestinationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventInvokeDestinationConfigProperty.Jsii$Proxy that = (EventInvokeDestinationConfigProperty.Jsii$Proxy) o;

                if (!onFailure.equals(that.onFailure)) return false;
                return this.onSuccess.equals(that.onSuccess);
            }

            @Override
            public final int hashCode() {
                int result = this.onFailure.hashCode();
                result = 31 * result + (this.onSuccess.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * EventSourceProperty eventSourceProperty = EventSourceProperty.builder()
     *         .properties(S3EventProperty.builder()
     *                 .variables(Map.of(
     *                         "variablesKey", "variables"))
     *                 .build())
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.EventSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(EventSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.EventSourceProperty.Properties`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getProperties();

        /**
         * `CfnFunction.EventSourceProperty.Type`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link EventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventSourceProperty> {
            java.lang.Object properties;
            java.lang.String type;

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.core.IResolvable properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.AlexaSkillEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.ApiEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.CloudWatchEventEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.CloudWatchLogsEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.DynamoDBEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.EventBridgeRuleEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.IoTRuleEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.KinesisEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.S3EventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.SNSEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.SQSEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties `CfnFunction.EventSourceProperty.Properties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.ScheduleEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getType}
             * @param type `CfnFunction.EventSourceProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventSourceProperty {
            private final java.lang.Object properties;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.properties = software.amazon.jsii.Kernel.get(this, "properties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.properties = java.util.Objects.requireNonNull(builder.properties, "properties is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.Object getProperties() {
                return this.properties;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("properties", om.valueToTree(this.getProperties()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.EventSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventSourceProperty.Jsii$Proxy that = (EventSourceProperty.Jsii$Proxy) o;

                if (!properties.equals(that.properties)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.properties.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * FileSystemConfigProperty fileSystemConfigProperty = FileSystemConfigProperty.builder()
     *         .arn("arn")
     *         .localMountPath("localMountPath")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.FileSystemConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(FileSystemConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FileSystemConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.FileSystemConfigProperty.Arn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArn() {
            return null;
        }

        /**
         * `CfnFunction.FileSystemConfigProperty.LocalMountPath`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocalMountPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FileSystemConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FileSystemConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FileSystemConfigProperty> {
            java.lang.String arn;
            java.lang.String localMountPath;

            /**
             * Sets the value of {@link FileSystemConfigProperty#getArn}
             * @param arn `CfnFunction.FileSystemConfigProperty.Arn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link FileSystemConfigProperty#getLocalMountPath}
             * @param localMountPath `CfnFunction.FileSystemConfigProperty.LocalMountPath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localMountPath(java.lang.String localMountPath) {
                this.localMountPath = localMountPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FileSystemConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FileSystemConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FileSystemConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileSystemConfigProperty {
            private final java.lang.String arn;
            private final java.lang.String localMountPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localMountPath = software.amazon.jsii.Kernel.get(this, "localMountPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = builder.arn;
                this.localMountPath = builder.localMountPath;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.String getLocalMountPath() {
                return this.localMountPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArn() != null) {
                    data.set("arn", om.valueToTree(this.getArn()));
                }
                if (this.getLocalMountPath() != null) {
                    data.set("localMountPath", om.valueToTree(this.getLocalMountPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.FileSystemConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FileSystemConfigProperty.Jsii$Proxy that = (FileSystemConfigProperty.Jsii$Proxy) o;

                if (this.arn != null ? !this.arn.equals(that.arn) : that.arn != null) return false;
                return this.localMountPath != null ? this.localMountPath.equals(that.localMountPath) : that.localMountPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn != null ? this.arn.hashCode() : 0;
                result = 31 * result + (this.localMountPath != null ? this.localMountPath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * FunctionEnvironmentProperty functionEnvironmentProperty = FunctionEnvironmentProperty.builder()
     *         .variables(Map.of(
     *                 "variablesKey", "variables"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.FunctionEnvironmentProperty")
    @software.amazon.jsii.Jsii.Proxy(FunctionEnvironmentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FunctionEnvironmentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.FunctionEnvironmentProperty.Variables`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVariables();

        /**
         * @return a {@link Builder} of {@link FunctionEnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FunctionEnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FunctionEnvironmentProperty> {
            java.lang.Object variables;

            /**
             * Sets the value of {@link FunctionEnvironmentProperty#getVariables}
             * @param variables `CfnFunction.FunctionEnvironmentProperty.Variables`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variables(software.amazon.awscdk.core.IResolvable variables) {
                this.variables = variables;
                return this;
            }

            /**
             * Sets the value of {@link FunctionEnvironmentProperty#getVariables}
             * @param variables `CfnFunction.FunctionEnvironmentProperty.Variables`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variables(java.util.Map<java.lang.String, java.lang.String> variables) {
                this.variables = variables;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FunctionEnvironmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FunctionEnvironmentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FunctionEnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionEnvironmentProperty {
            private final java.lang.Object variables;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.variables = software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.variables = java.util.Objects.requireNonNull(builder.variables, "variables is required");
            }

            @Override
            public final java.lang.Object getVariables() {
                return this.variables;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("variables", om.valueToTree(this.getVariables()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.FunctionEnvironmentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FunctionEnvironmentProperty.Jsii$Proxy that = (FunctionEnvironmentProperty.Jsii$Proxy) o;

                return this.variables.equals(that.variables);
            }

            @Override
            public final int hashCode() {
                int result = this.variables.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * FunctionSAMPTProperty functionSAMPTProperty = FunctionSAMPTProperty.builder()
     *         .functionName("functionName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.FunctionSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(FunctionSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FunctionSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.FunctionSAMPTProperty.FunctionName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFunctionName();

        /**
         * @return a {@link Builder} of {@link FunctionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FunctionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FunctionSAMPTProperty> {
            java.lang.String functionName;

            /**
             * Sets the value of {@link FunctionSAMPTProperty#getFunctionName}
             * @param functionName `CfnFunction.FunctionSAMPTProperty.FunctionName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionName(java.lang.String functionName) {
                this.functionName = functionName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FunctionSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FunctionSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FunctionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionSAMPTProperty {
            private final java.lang.String functionName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.functionName = software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.functionName = java.util.Objects.requireNonNull(builder.functionName, "functionName is required");
            }

            @Override
            public final java.lang.String getFunctionName() {
                return this.functionName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("functionName", om.valueToTree(this.getFunctionName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.FunctionSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FunctionSAMPTProperty.Jsii$Proxy that = (FunctionSAMPTProperty.Jsii$Proxy) o;

                return this.functionName.equals(that.functionName);
            }

            @Override
            public final int hashCode() {
                int result = this.functionName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * Object statement;
     * IAMPolicyDocumentProperty iAMPolicyDocumentProperty = Map.of(
     *         "statement", statement);
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.IAMPolicyDocumentProperty")
    @software.amazon.jsii.Jsii.Proxy(IAMPolicyDocumentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IAMPolicyDocumentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.IAMPolicyDocumentProperty.Statement`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStatement();

        /**
         * @return a {@link Builder} of {@link IAMPolicyDocumentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IAMPolicyDocumentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IAMPolicyDocumentProperty> {
            java.lang.Object statement;

            /**
             * Sets the value of {@link IAMPolicyDocumentProperty#getStatement}
             * @param statement `CfnFunction.IAMPolicyDocumentProperty.Statement`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statement(java.lang.Object statement) {
                this.statement = statement;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IAMPolicyDocumentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IAMPolicyDocumentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IAMPolicyDocumentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IAMPolicyDocumentProperty {
            private final java.lang.Object statement;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statement = software.amazon.jsii.Kernel.get(this, "statement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statement = java.util.Objects.requireNonNull(builder.statement, "statement is required");
            }

            @Override
            public final java.lang.Object getStatement() {
                return this.statement;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statement", om.valueToTree(this.getStatement()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.IAMPolicyDocumentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IAMPolicyDocumentProperty.Jsii$Proxy that = (IAMPolicyDocumentProperty.Jsii$Proxy) o;

                return this.statement.equals(that.statement);
            }

            @Override
            public final int hashCode() {
                int result = this.statement.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * IdentitySAMPTProperty identitySAMPTProperty = IdentitySAMPTProperty.builder()
     *         .identityName("identityName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.IdentitySAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(IdentitySAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdentitySAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.IdentitySAMPTProperty.IdentityName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIdentityName();

        /**
         * @return a {@link Builder} of {@link IdentitySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdentitySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdentitySAMPTProperty> {
            java.lang.String identityName;

            /**
             * Sets the value of {@link IdentitySAMPTProperty#getIdentityName}
             * @param identityName `CfnFunction.IdentitySAMPTProperty.IdentityName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityName(java.lang.String identityName) {
                this.identityName = identityName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdentitySAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdentitySAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdentitySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentitySAMPTProperty {
            private final java.lang.String identityName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.identityName = software.amazon.jsii.Kernel.get(this, "identityName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.identityName = java.util.Objects.requireNonNull(builder.identityName, "identityName is required");
            }

            @Override
            public final java.lang.String getIdentityName() {
                return this.identityName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("identityName", om.valueToTree(this.getIdentityName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.IdentitySAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdentitySAMPTProperty.Jsii$Proxy that = (IdentitySAMPTProperty.Jsii$Proxy) o;

                return this.identityName.equals(that.identityName);
            }

            @Override
            public final int hashCode() {
                int result = this.identityName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * ImageConfigProperty imageConfigProperty = ImageConfigProperty.builder()
     *         .command(List.of("command"))
     *         .entryPoint(List.of("entryPoint"))
     *         .workingDirectory("workingDirectory")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.ImageConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ImageConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImageConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.ImageConfigProperty.Command`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
            return null;
        }

        /**
         * `CfnFunction.ImageConfigProperty.EntryPoint`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEntryPoint() {
            return null;
        }

        /**
         * `CfnFunction.ImageConfigProperty.WorkingDirectory`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWorkingDirectory() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ImageConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImageConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImageConfigProperty> {
            java.util.List<java.lang.String> command;
            java.util.List<java.lang.String> entryPoint;
            java.lang.String workingDirectory;

            /**
             * Sets the value of {@link ImageConfigProperty#getCommand}
             * @param command `CfnFunction.ImageConfigProperty.Command`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder command(java.util.List<java.lang.String> command) {
                this.command = command;
                return this;
            }

            /**
             * Sets the value of {@link ImageConfigProperty#getEntryPoint}
             * @param entryPoint `CfnFunction.ImageConfigProperty.EntryPoint`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entryPoint(java.util.List<java.lang.String> entryPoint) {
                this.entryPoint = entryPoint;
                return this;
            }

            /**
             * Sets the value of {@link ImageConfigProperty#getWorkingDirectory}
             * @param workingDirectory `CfnFunction.ImageConfigProperty.WorkingDirectory`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workingDirectory(java.lang.String workingDirectory) {
                this.workingDirectory = workingDirectory;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImageConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImageConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImageConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImageConfigProperty {
            private final java.util.List<java.lang.String> command;
            private final java.util.List<java.lang.String> entryPoint;
            private final java.lang.String workingDirectory;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.entryPoint = software.amazon.jsii.Kernel.get(this, "entryPoint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.workingDirectory = software.amazon.jsii.Kernel.get(this, "workingDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.command = builder.command;
                this.entryPoint = builder.entryPoint;
                this.workingDirectory = builder.workingDirectory;
            }

            @Override
            public final java.util.List<java.lang.String> getCommand() {
                return this.command;
            }

            @Override
            public final java.util.List<java.lang.String> getEntryPoint() {
                return this.entryPoint;
            }

            @Override
            public final java.lang.String getWorkingDirectory() {
                return this.workingDirectory;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCommand() != null) {
                    data.set("command", om.valueToTree(this.getCommand()));
                }
                if (this.getEntryPoint() != null) {
                    data.set("entryPoint", om.valueToTree(this.getEntryPoint()));
                }
                if (this.getWorkingDirectory() != null) {
                    data.set("workingDirectory", om.valueToTree(this.getWorkingDirectory()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.ImageConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImageConfigProperty.Jsii$Proxy that = (ImageConfigProperty.Jsii$Proxy) o;

                if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
                if (this.entryPoint != null ? !this.entryPoint.equals(that.entryPoint) : that.entryPoint != null) return false;
                return this.workingDirectory != null ? this.workingDirectory.equals(that.workingDirectory) : that.workingDirectory == null;
            }

            @Override
            public final int hashCode() {
                int result = this.command != null ? this.command.hashCode() : 0;
                result = 31 * result + (this.entryPoint != null ? this.entryPoint.hashCode() : 0);
                result = 31 * result + (this.workingDirectory != null ? this.workingDirectory.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * IoTRuleEventProperty ioTRuleEventProperty = IoTRuleEventProperty.builder()
     *         .sql("sql")
     *         // the properties below are optional
     *         .awsIotSqlVersion("awsIotSqlVersion")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.IoTRuleEventProperty")
    @software.amazon.jsii.Jsii.Proxy(IoTRuleEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IoTRuleEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.IoTRuleEventProperty.Sql`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSql();

        /**
         * `CfnFunction.IoTRuleEventProperty.AwsIotSqlVersion`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAwsIotSqlVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IoTRuleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IoTRuleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IoTRuleEventProperty> {
            java.lang.String sql;
            java.lang.String awsIotSqlVersion;

            /**
             * Sets the value of {@link IoTRuleEventProperty#getSql}
             * @param sql `CfnFunction.IoTRuleEventProperty.Sql`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sql(java.lang.String sql) {
                this.sql = sql;
                return this;
            }

            /**
             * Sets the value of {@link IoTRuleEventProperty#getAwsIotSqlVersion}
             * @param awsIotSqlVersion `CfnFunction.IoTRuleEventProperty.AwsIotSqlVersion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsIotSqlVersion(java.lang.String awsIotSqlVersion) {
                this.awsIotSqlVersion = awsIotSqlVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IoTRuleEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IoTRuleEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IoTRuleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IoTRuleEventProperty {
            private final java.lang.String sql;
            private final java.lang.String awsIotSqlVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sql = software.amazon.jsii.Kernel.get(this, "sql", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.awsIotSqlVersion = software.amazon.jsii.Kernel.get(this, "awsIotSqlVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sql = java.util.Objects.requireNonNull(builder.sql, "sql is required");
                this.awsIotSqlVersion = builder.awsIotSqlVersion;
            }

            @Override
            public final java.lang.String getSql() {
                return this.sql;
            }

            @Override
            public final java.lang.String getAwsIotSqlVersion() {
                return this.awsIotSqlVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sql", om.valueToTree(this.getSql()));
                if (this.getAwsIotSqlVersion() != null) {
                    data.set("awsIotSqlVersion", om.valueToTree(this.getAwsIotSqlVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.IoTRuleEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IoTRuleEventProperty.Jsii$Proxy that = (IoTRuleEventProperty.Jsii$Proxy) o;

                if (!sql.equals(that.sql)) return false;
                return this.awsIotSqlVersion != null ? this.awsIotSqlVersion.equals(that.awsIotSqlVersion) : that.awsIotSqlVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sql.hashCode();
                result = 31 * result + (this.awsIotSqlVersion != null ? this.awsIotSqlVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * KeySAMPTProperty keySAMPTProperty = KeySAMPTProperty.builder()
     *         .keyId("keyId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.KeySAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(KeySAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KeySAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.KeySAMPTProperty.KeyId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKeyId();

        /**
         * @return a {@link Builder} of {@link KeySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KeySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KeySAMPTProperty> {
            java.lang.String keyId;

            /**
             * Sets the value of {@link KeySAMPTProperty#getKeyId}
             * @param keyId `CfnFunction.KeySAMPTProperty.KeyId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyId(java.lang.String keyId) {
                this.keyId = keyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeySAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KeySAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KeySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeySAMPTProperty {
            private final java.lang.String keyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.keyId = software.amazon.jsii.Kernel.get(this, "keyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.keyId = java.util.Objects.requireNonNull(builder.keyId, "keyId is required");
            }

            @Override
            public final java.lang.String getKeyId() {
                return this.keyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("keyId", om.valueToTree(this.getKeyId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.KeySAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KeySAMPTProperty.Jsii$Proxy that = (KeySAMPTProperty.Jsii$Proxy) o;

                return this.keyId.equals(that.keyId);
            }

            @Override
            public final int hashCode() {
                int result = this.keyId.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * KinesisEventProperty kinesisEventProperty = KinesisEventProperty.builder()
     *         .startingPosition("startingPosition")
     *         .stream("stream")
     *         // the properties below are optional
     *         .batchSize(123)
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.KinesisEventProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.KinesisEventProperty.StartingPosition`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStartingPosition();

        /**
         * `CfnFunction.KinesisEventProperty.Stream`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStream();

        /**
         * `CfnFunction.KinesisEventProperty.BatchSize`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBatchSize() {
            return null;
        }

        /**
         * `CfnFunction.KinesisEventProperty.Enabled`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KinesisEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisEventProperty> {
            java.lang.String startingPosition;
            java.lang.String stream;
            java.lang.Number batchSize;
            java.lang.Object enabled;

            /**
             * Sets the value of {@link KinesisEventProperty#getStartingPosition}
             * @param startingPosition `CfnFunction.KinesisEventProperty.StartingPosition`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startingPosition(java.lang.String startingPosition) {
                this.startingPosition = startingPosition;
                return this;
            }

            /**
             * Sets the value of {@link KinesisEventProperty#getStream}
             * @param stream `CfnFunction.KinesisEventProperty.Stream`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stream(java.lang.String stream) {
                this.stream = stream;
                return this;
            }

            /**
             * Sets the value of {@link KinesisEventProperty#getBatchSize}
             * @param batchSize `CfnFunction.KinesisEventProperty.BatchSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchSize(java.lang.Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            /**
             * Sets the value of {@link KinesisEventProperty#getEnabled}
             * @param enabled `CfnFunction.KinesisEventProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link KinesisEventProperty#getEnabled}
             * @param enabled `CfnFunction.KinesisEventProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisEventProperty {
            private final java.lang.String startingPosition;
            private final java.lang.String stream;
            private final java.lang.Number batchSize;
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.startingPosition = software.amazon.jsii.Kernel.get(this, "startingPosition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stream = software.amazon.jsii.Kernel.get(this, "stream", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.batchSize = software.amazon.jsii.Kernel.get(this, "batchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.startingPosition = java.util.Objects.requireNonNull(builder.startingPosition, "startingPosition is required");
                this.stream = java.util.Objects.requireNonNull(builder.stream, "stream is required");
                this.batchSize = builder.batchSize;
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.String getStartingPosition() {
                return this.startingPosition;
            }

            @Override
            public final java.lang.String getStream() {
                return this.stream;
            }

            @Override
            public final java.lang.Number getBatchSize() {
                return this.batchSize;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("startingPosition", om.valueToTree(this.getStartingPosition()));
                data.set("stream", om.valueToTree(this.getStream()));
                if (this.getBatchSize() != null) {
                    data.set("batchSize", om.valueToTree(this.getBatchSize()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.KinesisEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisEventProperty.Jsii$Proxy that = (KinesisEventProperty.Jsii$Proxy) o;

                if (!startingPosition.equals(that.startingPosition)) return false;
                if (!stream.equals(that.stream)) return false;
                if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.startingPosition.hashCode();
                result = 31 * result + (this.stream.hashCode());
                result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * LogGroupSAMPTProperty logGroupSAMPTProperty = LogGroupSAMPTProperty.builder()
     *         .logGroupName("logGroupName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.LogGroupSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(LogGroupSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogGroupSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.LogGroupSAMPTProperty.LogGroupName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogGroupName();

        /**
         * @return a {@link Builder} of {@link LogGroupSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogGroupSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogGroupSAMPTProperty> {
            java.lang.String logGroupName;

            /**
             * Sets the value of {@link LogGroupSAMPTProperty#getLogGroupName}
             * @param logGroupName `CfnFunction.LogGroupSAMPTProperty.LogGroupName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroupName(java.lang.String logGroupName) {
                this.logGroupName = logGroupName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogGroupSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogGroupSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogGroupSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogGroupSAMPTProperty {
            private final java.lang.String logGroupName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logGroupName = software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logGroupName = java.util.Objects.requireNonNull(builder.logGroupName, "logGroupName is required");
            }

            @Override
            public final java.lang.String getLogGroupName() {
                return this.logGroupName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logGroupName", om.valueToTree(this.getLogGroupName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.LogGroupSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogGroupSAMPTProperty.Jsii$Proxy that = (LogGroupSAMPTProperty.Jsii$Proxy) o;

                return this.logGroupName.equals(that.logGroupName);
            }

            @Override
            public final int hashCode() {
                int result = this.logGroupName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * ProvisionedConcurrencyConfigProperty provisionedConcurrencyConfigProperty = ProvisionedConcurrencyConfigProperty.builder()
     *         .provisionedConcurrentExecutions("provisionedConcurrentExecutions")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.ProvisionedConcurrencyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ProvisionedConcurrencyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProvisionedConcurrencyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.ProvisionedConcurrencyConfigProperty.ProvisionedConcurrentExecutions`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProvisionedConcurrentExecutions();

        /**
         * @return a {@link Builder} of {@link ProvisionedConcurrencyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProvisionedConcurrencyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProvisionedConcurrencyConfigProperty> {
            java.lang.String provisionedConcurrentExecutions;

            /**
             * Sets the value of {@link ProvisionedConcurrencyConfigProperty#getProvisionedConcurrentExecutions}
             * @param provisionedConcurrentExecutions `CfnFunction.ProvisionedConcurrencyConfigProperty.ProvisionedConcurrentExecutions`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisionedConcurrentExecutions(java.lang.String provisionedConcurrentExecutions) {
                this.provisionedConcurrentExecutions = provisionedConcurrentExecutions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProvisionedConcurrencyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProvisionedConcurrencyConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProvisionedConcurrencyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProvisionedConcurrencyConfigProperty {
            private final java.lang.String provisionedConcurrentExecutions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.provisionedConcurrentExecutions = software.amazon.jsii.Kernel.get(this, "provisionedConcurrentExecutions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.provisionedConcurrentExecutions = java.util.Objects.requireNonNull(builder.provisionedConcurrentExecutions, "provisionedConcurrentExecutions is required");
            }

            @Override
            public final java.lang.String getProvisionedConcurrentExecutions() {
                return this.provisionedConcurrentExecutions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("provisionedConcurrentExecutions", om.valueToTree(this.getProvisionedConcurrentExecutions()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.ProvisionedConcurrencyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProvisionedConcurrencyConfigProperty.Jsii$Proxy that = (ProvisionedConcurrencyConfigProperty.Jsii$Proxy) o;

                return this.provisionedConcurrentExecutions.equals(that.provisionedConcurrentExecutions);
            }

            @Override
            public final int hashCode() {
                int result = this.provisionedConcurrentExecutions.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * QueueSAMPTProperty queueSAMPTProperty = QueueSAMPTProperty.builder()
     *         .queueName("queueName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.QueueSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(QueueSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueueSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.QueueSAMPTProperty.QueueName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getQueueName();

        /**
         * @return a {@link Builder} of {@link QueueSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueueSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QueueSAMPTProperty> {
            java.lang.String queueName;

            /**
             * Sets the value of {@link QueueSAMPTProperty#getQueueName}
             * @param queueName `CfnFunction.QueueSAMPTProperty.QueueName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queueName(java.lang.String queueName) {
                this.queueName = queueName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueueSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QueueSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QueueSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueueSAMPTProperty {
            private final java.lang.String queueName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.queueName = software.amazon.jsii.Kernel.get(this, "queueName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.queueName = java.util.Objects.requireNonNull(builder.queueName, "queueName is required");
            }

            @Override
            public final java.lang.String getQueueName() {
                return this.queueName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("queueName", om.valueToTree(this.getQueueName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.QueueSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueueSAMPTProperty.Jsii$Proxy that = (QueueSAMPTProperty.Jsii$Proxy) o;

                return this.queueName.equals(that.queueName);
            }

            @Override
            public final int hashCode() {
                int result = this.queueName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * S3EventProperty s3EventProperty = S3EventProperty.builder()
     *         .bucket("bucket")
     *         .events("events")
     *         // the properties below are optional
     *         .filter(S3NotificationFilterProperty.builder()
     *                 .s3Key(S3KeyFilterProperty.builder()
     *                         .rules(List.of(S3KeyFilterRuleProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.S3EventProperty")
    @software.amazon.jsii.Jsii.Proxy(S3EventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3EventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.S3EventProperty.Bucket`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * `CfnFunction.S3EventProperty.Events`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEvents();

        /**
         * `CfnFunction.S3EventProperty.Filter`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3EventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3EventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3EventProperty> {
            java.lang.String bucket;
            java.lang.Object events;
            java.lang.Object filter;

            /**
             * Sets the value of {@link S3EventProperty#getBucket}
             * @param bucket `CfnFunction.S3EventProperty.Bucket`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3EventProperty#getEvents}
             * @param events `CfnFunction.S3EventProperty.Events`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder events(java.lang.String events) {
                this.events = events;
                return this;
            }

            /**
             * Sets the value of {@link S3EventProperty#getEvents}
             * @param events `CfnFunction.S3EventProperty.Events`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder events(software.amazon.awscdk.core.IResolvable events) {
                this.events = events;
                return this;
            }

            /**
             * Sets the value of {@link S3EventProperty#getEvents}
             * @param events `CfnFunction.S3EventProperty.Events`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder events(java.util.List<java.lang.String> events) {
                this.events = events;
                return this;
            }

            /**
             * Sets the value of {@link S3EventProperty#getFilter}
             * @param filter `CfnFunction.S3EventProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.core.IResolvable filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link S3EventProperty#getFilter}
             * @param filter `CfnFunction.S3EventProperty.Filter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.services.sam.CfnFunction.S3NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3EventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3EventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3EventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3EventProperty {
            private final java.lang.String bucket;
            private final java.lang.Object events;
            private final java.lang.Object filter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.events = software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.filter = software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.events = java.util.Objects.requireNonNull(builder.events, "events is required");
                this.filter = builder.filter;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.Object getEvents() {
                return this.events;
            }

            @Override
            public final java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                data.set("events", om.valueToTree(this.getEvents()));
                if (this.getFilter() != null) {
                    data.set("filter", om.valueToTree(this.getFilter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.S3EventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3EventProperty.Jsii$Proxy that = (S3EventProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (!events.equals(that.events)) return false;
                return this.filter != null ? this.filter.equals(that.filter) : that.filter == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.events.hashCode());
                result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * S3KeyFilterProperty s3KeyFilterProperty = S3KeyFilterProperty.builder()
     *         .rules(List.of(S3KeyFilterRuleProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.S3KeyFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(S3KeyFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3KeyFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.S3KeyFilterProperty.Rules`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link S3KeyFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3KeyFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3KeyFilterProperty> {
            java.lang.Object rules;

            /**
             * Sets the value of {@link S3KeyFilterProperty#getRules}
             * @param rules `CfnFunction.S3KeyFilterProperty.Rules`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(software.amazon.awscdk.core.IResolvable rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of {@link S3KeyFilterProperty#getRules}
             * @param rules `CfnFunction.S3KeyFilterProperty.Rules`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(java.util.List<? extends java.lang.Object> rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3KeyFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3KeyFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3KeyFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3KeyFilterProperty {
            private final java.lang.Object rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rules = java.util.Objects.requireNonNull(builder.rules, "rules is required");
            }

            @Override
            public final java.lang.Object getRules() {
                return this.rules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("rules", om.valueToTree(this.getRules()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.S3KeyFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3KeyFilterProperty.Jsii$Proxy that = (S3KeyFilterProperty.Jsii$Proxy) o;

                return this.rules.equals(that.rules);
            }

            @Override
            public final int hashCode() {
                int result = this.rules.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * S3KeyFilterRuleProperty s3KeyFilterRuleProperty = S3KeyFilterRuleProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.S3KeyFilterRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(S3KeyFilterRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3KeyFilterRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.S3KeyFilterRuleProperty.Name`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * `CfnFunction.S3KeyFilterRuleProperty.Value`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link S3KeyFilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3KeyFilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3KeyFilterRuleProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link S3KeyFilterRuleProperty#getName}
             * @param name `CfnFunction.S3KeyFilterRuleProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link S3KeyFilterRuleProperty#getValue}
             * @param value `CfnFunction.S3KeyFilterRuleProperty.Value`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3KeyFilterRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3KeyFilterRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3KeyFilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3KeyFilterRuleProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.S3KeyFilterRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3KeyFilterRuleProperty.Jsii$Proxy that = (S3KeyFilterRuleProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * S3LocationProperty s3LocationProperty = S3LocationProperty.builder()
     *         .bucket("bucket")
     *         .key("key")
     *         // the properties below are optional
     *         .version(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.S3LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.S3LocationProperty.Bucket`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * `CfnFunction.S3LocationProperty.Key`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * `CfnFunction.S3LocationProperty.Version`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LocationProperty> {
            java.lang.String bucket;
            java.lang.String key;
            java.lang.Number version;

            /**
             * Sets the value of {@link S3LocationProperty#getBucket}
             * @param bucket `CfnFunction.S3LocationProperty.Bucket`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getKey}
             * @param key `CfnFunction.S3LocationProperty.Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getVersion}
             * @param version `CfnFunction.S3LocationProperty.Version`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.Number version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String key;
            private final java.lang.Number version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.Number getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                data.set("key", om.valueToTree(this.getKey()));
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.S3LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LocationProperty.Jsii$Proxy that = (S3LocationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (!key.equals(that.key)) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.key.hashCode());
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * S3NotificationFilterProperty s3NotificationFilterProperty = S3NotificationFilterProperty.builder()
     *         .s3Key(S3KeyFilterProperty.builder()
     *                 .rules(List.of(S3KeyFilterRuleProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.S3NotificationFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(S3NotificationFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3NotificationFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.S3NotificationFilterProperty.S3Key`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Key();

        /**
         * @return a {@link Builder} of {@link S3NotificationFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3NotificationFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3NotificationFilterProperty> {
            java.lang.Object s3Key;

            /**
             * Sets the value of {@link S3NotificationFilterProperty#getS3Key}
             * @param s3Key `CfnFunction.S3NotificationFilterProperty.S3Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Key(software.amazon.awscdk.core.IResolvable s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            /**
             * Sets the value of {@link S3NotificationFilterProperty#getS3Key}
             * @param s3Key `CfnFunction.S3NotificationFilterProperty.S3Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Key(software.amazon.awscdk.services.sam.CfnFunction.S3KeyFilterProperty s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3NotificationFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3NotificationFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3NotificationFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3NotificationFilterProperty {
            private final java.lang.Object s3Key;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Key = software.amazon.jsii.Kernel.get(this, "s3Key", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Key = java.util.Objects.requireNonNull(builder.s3Key, "s3Key is required");
            }

            @Override
            public final java.lang.Object getS3Key() {
                return this.s3Key;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Key", om.valueToTree(this.getS3Key()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.S3NotificationFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3NotificationFilterProperty.Jsii$Proxy that = (S3NotificationFilterProperty.Jsii$Proxy) o;

                return this.s3Key.equals(that.s3Key);
            }

            @Override
            public final int hashCode() {
                int result = this.s3Key.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * SAMPolicyTemplateProperty sAMPolicyTemplateProperty = SAMPolicyTemplateProperty.builder()
     *         .amiDescribePolicy(EmptySAMPTProperty.builder().build())
     *         .cloudFormationDescribeStacksPolicy(EmptySAMPTProperty.builder().build())
     *         .cloudWatchPutMetricPolicy(EmptySAMPTProperty.builder().build())
     *         .dynamoDbCrudPolicy(TableSAMPTProperty.builder()
     *                 .tableName("tableName")
     *                 .build())
     *         .dynamoDbReadPolicy(TableSAMPTProperty.builder()
     *                 .tableName("tableName")
     *                 .build())
     *         .dynamoDbStreamReadPolicy(TableStreamSAMPTProperty.builder()
     *                 .streamName("streamName")
     *                 .tableName("tableName")
     *                 .build())
     *         .ec2DescribePolicy(EmptySAMPTProperty.builder().build())
     *         .elasticsearchHttpPostPolicy(DomainSAMPTProperty.builder()
     *                 .domainName("domainName")
     *                 .build())
     *         .filterLogEventsPolicy(LogGroupSAMPTProperty.builder()
     *                 .logGroupName("logGroupName")
     *                 .build())
     *         .kinesisCrudPolicy(StreamSAMPTProperty.builder()
     *                 .streamName("streamName")
     *                 .build())
     *         .kinesisStreamReadPolicy(StreamSAMPTProperty.builder()
     *                 .streamName("streamName")
     *                 .build())
     *         .kmsDecryptPolicy(KeySAMPTProperty.builder()
     *                 .keyId("keyId")
     *                 .build())
     *         .lambdaInvokePolicy(FunctionSAMPTProperty.builder()
     *                 .functionName("functionName")
     *                 .build())
     *         .rekognitionDetectOnlyPolicy(EmptySAMPTProperty.builder().build())
     *         .rekognitionLabelsPolicy(EmptySAMPTProperty.builder().build())
     *         .rekognitionNoDataAccessPolicy(CollectionSAMPTProperty.builder()
     *                 .collectionId("collectionId")
     *                 .build())
     *         .rekognitionReadPolicy(CollectionSAMPTProperty.builder()
     *                 .collectionId("collectionId")
     *                 .build())
     *         .rekognitionWriteOnlyAccessPolicy(CollectionSAMPTProperty.builder()
     *                 .collectionId("collectionId")
     *                 .build())
     *         .s3CrudPolicy(BucketSAMPTProperty.builder()
     *                 .bucketName("bucketName")
     *                 .build())
     *         .s3ReadPolicy(BucketSAMPTProperty.builder()
     *                 .bucketName("bucketName")
     *                 .build())
     *         .sesBulkTemplatedCrudPolicy(IdentitySAMPTProperty.builder()
     *                 .identityName("identityName")
     *                 .build())
     *         .sesCrudPolicy(IdentitySAMPTProperty.builder()
     *                 .identityName("identityName")
     *                 .build())
     *         .sesEmailTemplateCrudPolicy(EmptySAMPTProperty.builder().build())
     *         .sesSendBouncePolicy(IdentitySAMPTProperty.builder()
     *                 .identityName("identityName")
     *                 .build())
     *         .snsCrudPolicy(TopicSAMPTProperty.builder()
     *                 .topicName("topicName")
     *                 .build())
     *         .snsPublishMessagePolicy(TopicSAMPTProperty.builder()
     *                 .topicName("topicName")
     *                 .build())
     *         .sqsPollerPolicy(QueueSAMPTProperty.builder()
     *                 .queueName("queueName")
     *                 .build())
     *         .sqsSendMessagePolicy(QueueSAMPTProperty.builder()
     *                 .queueName("queueName")
     *                 .build())
     *         .stepFunctionsExecutionPolicy(StateMachineSAMPTProperty.builder()
     *                 .stateMachineName("stateMachineName")
     *                 .build())
     *         .vpcAccessPolicy(EmptySAMPTProperty.builder().build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.SAMPolicyTemplateProperty")
    @software.amazon.jsii.Jsii.Proxy(SAMPolicyTemplateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SAMPolicyTemplateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.AMIDescribePolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAmiDescribePolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.CloudFormationDescribeStacksPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudFormationDescribeStacksPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.CloudWatchPutMetricPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchPutMetricPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.DynamoDBCrudPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDbCrudPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.DynamoDBReadPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDbReadPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.DynamoDBStreamReadPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDbStreamReadPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.EC2DescribePolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEc2DescribePolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.ElasticsearchHttpPostPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getElasticsearchHttpPostPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.FilterLogEventsPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilterLogEventsPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.KinesisCrudPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisCrudPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.KinesisStreamReadPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisStreamReadPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.KMSDecryptPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKmsDecryptPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.LambdaInvokePolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaInvokePolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionDetectOnlyPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRekognitionDetectOnlyPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionLabelsPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRekognitionLabelsPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionNoDataAccessPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRekognitionNoDataAccessPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionReadPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRekognitionReadPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionWriteOnlyAccessPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRekognitionWriteOnlyAccessPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.S3CrudPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3CrudPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.S3ReadPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3ReadPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESBulkTemplatedCrudPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSesBulkTemplatedCrudPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESCrudPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSesCrudPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESEmailTemplateCrudPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSesEmailTemplateCrudPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESSendBouncePolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSesSendBouncePolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SNSCrudPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSnsCrudPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SNSPublishMessagePolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSnsPublishMessagePolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SQSPollerPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSqsPollerPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SQSSendMessagePolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSqsSendMessagePolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.StepFunctionsExecutionPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStepFunctionsExecutionPolicy() {
            return null;
        }

        /**
         * `CfnFunction.SAMPolicyTemplateProperty.VPCAccessPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcAccessPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SAMPolicyTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SAMPolicyTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SAMPolicyTemplateProperty> {
            java.lang.Object amiDescribePolicy;
            java.lang.Object cloudFormationDescribeStacksPolicy;
            java.lang.Object cloudWatchPutMetricPolicy;
            java.lang.Object dynamoDbCrudPolicy;
            java.lang.Object dynamoDbReadPolicy;
            java.lang.Object dynamoDbStreamReadPolicy;
            java.lang.Object ec2DescribePolicy;
            java.lang.Object elasticsearchHttpPostPolicy;
            java.lang.Object filterLogEventsPolicy;
            java.lang.Object kinesisCrudPolicy;
            java.lang.Object kinesisStreamReadPolicy;
            java.lang.Object kmsDecryptPolicy;
            java.lang.Object lambdaInvokePolicy;
            java.lang.Object rekognitionDetectOnlyPolicy;
            java.lang.Object rekognitionLabelsPolicy;
            java.lang.Object rekognitionNoDataAccessPolicy;
            java.lang.Object rekognitionReadPolicy;
            java.lang.Object rekognitionWriteOnlyAccessPolicy;
            java.lang.Object s3CrudPolicy;
            java.lang.Object s3ReadPolicy;
            java.lang.Object sesBulkTemplatedCrudPolicy;
            java.lang.Object sesCrudPolicy;
            java.lang.Object sesEmailTemplateCrudPolicy;
            java.lang.Object sesSendBouncePolicy;
            java.lang.Object snsCrudPolicy;
            java.lang.Object snsPublishMessagePolicy;
            java.lang.Object sqsPollerPolicy;
            java.lang.Object sqsSendMessagePolicy;
            java.lang.Object stepFunctionsExecutionPolicy;
            java.lang.Object vpcAccessPolicy;

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getAmiDescribePolicy}
             * @param amiDescribePolicy `CfnFunction.SAMPolicyTemplateProperty.AMIDescribePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amiDescribePolicy(software.amazon.awscdk.core.IResolvable amiDescribePolicy) {
                this.amiDescribePolicy = amiDescribePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getAmiDescribePolicy}
             * @param amiDescribePolicy `CfnFunction.SAMPolicyTemplateProperty.AMIDescribePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amiDescribePolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty amiDescribePolicy) {
                this.amiDescribePolicy = amiDescribePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getCloudFormationDescribeStacksPolicy}
             * @param cloudFormationDescribeStacksPolicy `CfnFunction.SAMPolicyTemplateProperty.CloudFormationDescribeStacksPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudFormationDescribeStacksPolicy(software.amazon.awscdk.core.IResolvable cloudFormationDescribeStacksPolicy) {
                this.cloudFormationDescribeStacksPolicy = cloudFormationDescribeStacksPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getCloudFormationDescribeStacksPolicy}
             * @param cloudFormationDescribeStacksPolicy `CfnFunction.SAMPolicyTemplateProperty.CloudFormationDescribeStacksPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudFormationDescribeStacksPolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty cloudFormationDescribeStacksPolicy) {
                this.cloudFormationDescribeStacksPolicy = cloudFormationDescribeStacksPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getCloudWatchPutMetricPolicy}
             * @param cloudWatchPutMetricPolicy `CfnFunction.SAMPolicyTemplateProperty.CloudWatchPutMetricPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchPutMetricPolicy(software.amazon.awscdk.core.IResolvable cloudWatchPutMetricPolicy) {
                this.cloudWatchPutMetricPolicy = cloudWatchPutMetricPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getCloudWatchPutMetricPolicy}
             * @param cloudWatchPutMetricPolicy `CfnFunction.SAMPolicyTemplateProperty.CloudWatchPutMetricPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchPutMetricPolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty cloudWatchPutMetricPolicy) {
                this.cloudWatchPutMetricPolicy = cloudWatchPutMetricPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getDynamoDbCrudPolicy}
             * @param dynamoDbCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.DynamoDBCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDbCrudPolicy(software.amazon.awscdk.core.IResolvable dynamoDbCrudPolicy) {
                this.dynamoDbCrudPolicy = dynamoDbCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getDynamoDbCrudPolicy}
             * @param dynamoDbCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.DynamoDBCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDbCrudPolicy(software.amazon.awscdk.services.sam.CfnFunction.TableSAMPTProperty dynamoDbCrudPolicy) {
                this.dynamoDbCrudPolicy = dynamoDbCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getDynamoDbReadPolicy}
             * @param dynamoDbReadPolicy `CfnFunction.SAMPolicyTemplateProperty.DynamoDBReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDbReadPolicy(software.amazon.awscdk.core.IResolvable dynamoDbReadPolicy) {
                this.dynamoDbReadPolicy = dynamoDbReadPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getDynamoDbReadPolicy}
             * @param dynamoDbReadPolicy `CfnFunction.SAMPolicyTemplateProperty.DynamoDBReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDbReadPolicy(software.amazon.awscdk.services.sam.CfnFunction.TableSAMPTProperty dynamoDbReadPolicy) {
                this.dynamoDbReadPolicy = dynamoDbReadPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getDynamoDbStreamReadPolicy}
             * @param dynamoDbStreamReadPolicy `CfnFunction.SAMPolicyTemplateProperty.DynamoDBStreamReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDbStreamReadPolicy(software.amazon.awscdk.core.IResolvable dynamoDbStreamReadPolicy) {
                this.dynamoDbStreamReadPolicy = dynamoDbStreamReadPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getDynamoDbStreamReadPolicy}
             * @param dynamoDbStreamReadPolicy `CfnFunction.SAMPolicyTemplateProperty.DynamoDBStreamReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDbStreamReadPolicy(software.amazon.awscdk.services.sam.CfnFunction.TableStreamSAMPTProperty dynamoDbStreamReadPolicy) {
                this.dynamoDbStreamReadPolicy = dynamoDbStreamReadPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getEc2DescribePolicy}
             * @param ec2DescribePolicy `CfnFunction.SAMPolicyTemplateProperty.EC2DescribePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2DescribePolicy(software.amazon.awscdk.core.IResolvable ec2DescribePolicy) {
                this.ec2DescribePolicy = ec2DescribePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getEc2DescribePolicy}
             * @param ec2DescribePolicy `CfnFunction.SAMPolicyTemplateProperty.EC2DescribePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2DescribePolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty ec2DescribePolicy) {
                this.ec2DescribePolicy = ec2DescribePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getElasticsearchHttpPostPolicy}
             * @param elasticsearchHttpPostPolicy `CfnFunction.SAMPolicyTemplateProperty.ElasticsearchHttpPostPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elasticsearchHttpPostPolicy(software.amazon.awscdk.core.IResolvable elasticsearchHttpPostPolicy) {
                this.elasticsearchHttpPostPolicy = elasticsearchHttpPostPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getElasticsearchHttpPostPolicy}
             * @param elasticsearchHttpPostPolicy `CfnFunction.SAMPolicyTemplateProperty.ElasticsearchHttpPostPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elasticsearchHttpPostPolicy(software.amazon.awscdk.services.sam.CfnFunction.DomainSAMPTProperty elasticsearchHttpPostPolicy) {
                this.elasticsearchHttpPostPolicy = elasticsearchHttpPostPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getFilterLogEventsPolicy}
             * @param filterLogEventsPolicy `CfnFunction.SAMPolicyTemplateProperty.FilterLogEventsPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterLogEventsPolicy(software.amazon.awscdk.core.IResolvable filterLogEventsPolicy) {
                this.filterLogEventsPolicy = filterLogEventsPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getFilterLogEventsPolicy}
             * @param filterLogEventsPolicy `CfnFunction.SAMPolicyTemplateProperty.FilterLogEventsPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterLogEventsPolicy(software.amazon.awscdk.services.sam.CfnFunction.LogGroupSAMPTProperty filterLogEventsPolicy) {
                this.filterLogEventsPolicy = filterLogEventsPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getKinesisCrudPolicy}
             * @param kinesisCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.KinesisCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisCrudPolicy(software.amazon.awscdk.core.IResolvable kinesisCrudPolicy) {
                this.kinesisCrudPolicy = kinesisCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getKinesisCrudPolicy}
             * @param kinesisCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.KinesisCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisCrudPolicy(software.amazon.awscdk.services.sam.CfnFunction.StreamSAMPTProperty kinesisCrudPolicy) {
                this.kinesisCrudPolicy = kinesisCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getKinesisStreamReadPolicy}
             * @param kinesisStreamReadPolicy `CfnFunction.SAMPolicyTemplateProperty.KinesisStreamReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisStreamReadPolicy(software.amazon.awscdk.core.IResolvable kinesisStreamReadPolicy) {
                this.kinesisStreamReadPolicy = kinesisStreamReadPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getKinesisStreamReadPolicy}
             * @param kinesisStreamReadPolicy `CfnFunction.SAMPolicyTemplateProperty.KinesisStreamReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisStreamReadPolicy(software.amazon.awscdk.services.sam.CfnFunction.StreamSAMPTProperty kinesisStreamReadPolicy) {
                this.kinesisStreamReadPolicy = kinesisStreamReadPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getKmsDecryptPolicy}
             * @param kmsDecryptPolicy `CfnFunction.SAMPolicyTemplateProperty.KMSDecryptPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsDecryptPolicy(software.amazon.awscdk.core.IResolvable kmsDecryptPolicy) {
                this.kmsDecryptPolicy = kmsDecryptPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getKmsDecryptPolicy}
             * @param kmsDecryptPolicy `CfnFunction.SAMPolicyTemplateProperty.KMSDecryptPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsDecryptPolicy(software.amazon.awscdk.services.sam.CfnFunction.KeySAMPTProperty kmsDecryptPolicy) {
                this.kmsDecryptPolicy = kmsDecryptPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getLambdaInvokePolicy}
             * @param lambdaInvokePolicy `CfnFunction.SAMPolicyTemplateProperty.LambdaInvokePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaInvokePolicy(software.amazon.awscdk.core.IResolvable lambdaInvokePolicy) {
                this.lambdaInvokePolicy = lambdaInvokePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getLambdaInvokePolicy}
             * @param lambdaInvokePolicy `CfnFunction.SAMPolicyTemplateProperty.LambdaInvokePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaInvokePolicy(software.amazon.awscdk.services.sam.CfnFunction.FunctionSAMPTProperty lambdaInvokePolicy) {
                this.lambdaInvokePolicy = lambdaInvokePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getRekognitionDetectOnlyPolicy}
             * @param rekognitionDetectOnlyPolicy `CfnFunction.SAMPolicyTemplateProperty.RekognitionDetectOnlyPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rekognitionDetectOnlyPolicy(software.amazon.awscdk.core.IResolvable rekognitionDetectOnlyPolicy) {
                this.rekognitionDetectOnlyPolicy = rekognitionDetectOnlyPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getRekognitionDetectOnlyPolicy}
             * @param rekognitionDetectOnlyPolicy `CfnFunction.SAMPolicyTemplateProperty.RekognitionDetectOnlyPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rekognitionDetectOnlyPolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty rekognitionDetectOnlyPolicy) {
                this.rekognitionDetectOnlyPolicy = rekognitionDetectOnlyPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getRekognitionLabelsPolicy}
             * @param rekognitionLabelsPolicy `CfnFunction.SAMPolicyTemplateProperty.RekognitionLabelsPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rekognitionLabelsPolicy(software.amazon.awscdk.core.IResolvable rekognitionLabelsPolicy) {
                this.rekognitionLabelsPolicy = rekognitionLabelsPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getRekognitionLabelsPolicy}
             * @param rekognitionLabelsPolicy `CfnFunction.SAMPolicyTemplateProperty.RekognitionLabelsPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rekognitionLabelsPolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty rekognitionLabelsPolicy) {
                this.rekognitionLabelsPolicy = rekognitionLabelsPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getRekognitionNoDataAccessPolicy}
             * @param rekognitionNoDataAccessPolicy `CfnFunction.SAMPolicyTemplateProperty.RekognitionNoDataAccessPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rekognitionNoDataAccessPolicy(software.amazon.awscdk.core.IResolvable rekognitionNoDataAccessPolicy) {
                this.rekognitionNoDataAccessPolicy = rekognitionNoDataAccessPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getRekognitionNoDataAccessPolicy}
             * @param rekognitionNoDataAccessPolicy `CfnFunction.SAMPolicyTemplateProperty.RekognitionNoDataAccessPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rekognitionNoDataAccessPolicy(software.amazon.awscdk.services.sam.CfnFunction.CollectionSAMPTProperty rekognitionNoDataAccessPolicy) {
                this.rekognitionNoDataAccessPolicy = rekognitionNoDataAccessPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getRekognitionReadPolicy}
             * @param rekognitionReadPolicy `CfnFunction.SAMPolicyTemplateProperty.RekognitionReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rekognitionReadPolicy(software.amazon.awscdk.core.IResolvable rekognitionReadPolicy) {
                this.rekognitionReadPolicy = rekognitionReadPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getRekognitionReadPolicy}
             * @param rekognitionReadPolicy `CfnFunction.SAMPolicyTemplateProperty.RekognitionReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rekognitionReadPolicy(software.amazon.awscdk.services.sam.CfnFunction.CollectionSAMPTProperty rekognitionReadPolicy) {
                this.rekognitionReadPolicy = rekognitionReadPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getRekognitionWriteOnlyAccessPolicy}
             * @param rekognitionWriteOnlyAccessPolicy `CfnFunction.SAMPolicyTemplateProperty.RekognitionWriteOnlyAccessPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rekognitionWriteOnlyAccessPolicy(software.amazon.awscdk.core.IResolvable rekognitionWriteOnlyAccessPolicy) {
                this.rekognitionWriteOnlyAccessPolicy = rekognitionWriteOnlyAccessPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getRekognitionWriteOnlyAccessPolicy}
             * @param rekognitionWriteOnlyAccessPolicy `CfnFunction.SAMPolicyTemplateProperty.RekognitionWriteOnlyAccessPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rekognitionWriteOnlyAccessPolicy(software.amazon.awscdk.services.sam.CfnFunction.CollectionSAMPTProperty rekognitionWriteOnlyAccessPolicy) {
                this.rekognitionWriteOnlyAccessPolicy = rekognitionWriteOnlyAccessPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getS3CrudPolicy}
             * @param s3CrudPolicy `CfnFunction.SAMPolicyTemplateProperty.S3CrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3CrudPolicy(software.amazon.awscdk.core.IResolvable s3CrudPolicy) {
                this.s3CrudPolicy = s3CrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getS3CrudPolicy}
             * @param s3CrudPolicy `CfnFunction.SAMPolicyTemplateProperty.S3CrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3CrudPolicy(software.amazon.awscdk.services.sam.CfnFunction.BucketSAMPTProperty s3CrudPolicy) {
                this.s3CrudPolicy = s3CrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getS3ReadPolicy}
             * @param s3ReadPolicy `CfnFunction.SAMPolicyTemplateProperty.S3ReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ReadPolicy(software.amazon.awscdk.core.IResolvable s3ReadPolicy) {
                this.s3ReadPolicy = s3ReadPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getS3ReadPolicy}
             * @param s3ReadPolicy `CfnFunction.SAMPolicyTemplateProperty.S3ReadPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ReadPolicy(software.amazon.awscdk.services.sam.CfnFunction.BucketSAMPTProperty s3ReadPolicy) {
                this.s3ReadPolicy = s3ReadPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSesBulkTemplatedCrudPolicy}
             * @param sesBulkTemplatedCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.SESBulkTemplatedCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sesBulkTemplatedCrudPolicy(software.amazon.awscdk.core.IResolvable sesBulkTemplatedCrudPolicy) {
                this.sesBulkTemplatedCrudPolicy = sesBulkTemplatedCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSesBulkTemplatedCrudPolicy}
             * @param sesBulkTemplatedCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.SESBulkTemplatedCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sesBulkTemplatedCrudPolicy(software.amazon.awscdk.services.sam.CfnFunction.IdentitySAMPTProperty sesBulkTemplatedCrudPolicy) {
                this.sesBulkTemplatedCrudPolicy = sesBulkTemplatedCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSesCrudPolicy}
             * @param sesCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.SESCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sesCrudPolicy(software.amazon.awscdk.core.IResolvable sesCrudPolicy) {
                this.sesCrudPolicy = sesCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSesCrudPolicy}
             * @param sesCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.SESCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sesCrudPolicy(software.amazon.awscdk.services.sam.CfnFunction.IdentitySAMPTProperty sesCrudPolicy) {
                this.sesCrudPolicy = sesCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSesEmailTemplateCrudPolicy}
             * @param sesEmailTemplateCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.SESEmailTemplateCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sesEmailTemplateCrudPolicy(software.amazon.awscdk.core.IResolvable sesEmailTemplateCrudPolicy) {
                this.sesEmailTemplateCrudPolicy = sesEmailTemplateCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSesEmailTemplateCrudPolicy}
             * @param sesEmailTemplateCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.SESEmailTemplateCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sesEmailTemplateCrudPolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty sesEmailTemplateCrudPolicy) {
                this.sesEmailTemplateCrudPolicy = sesEmailTemplateCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSesSendBouncePolicy}
             * @param sesSendBouncePolicy `CfnFunction.SAMPolicyTemplateProperty.SESSendBouncePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sesSendBouncePolicy(software.amazon.awscdk.core.IResolvable sesSendBouncePolicy) {
                this.sesSendBouncePolicy = sesSendBouncePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSesSendBouncePolicy}
             * @param sesSendBouncePolicy `CfnFunction.SAMPolicyTemplateProperty.SESSendBouncePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sesSendBouncePolicy(software.amazon.awscdk.services.sam.CfnFunction.IdentitySAMPTProperty sesSendBouncePolicy) {
                this.sesSendBouncePolicy = sesSendBouncePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSnsCrudPolicy}
             * @param snsCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.SNSCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsCrudPolicy(software.amazon.awscdk.core.IResolvable snsCrudPolicy) {
                this.snsCrudPolicy = snsCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSnsCrudPolicy}
             * @param snsCrudPolicy `CfnFunction.SAMPolicyTemplateProperty.SNSCrudPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsCrudPolicy(software.amazon.awscdk.services.sam.CfnFunction.TopicSAMPTProperty snsCrudPolicy) {
                this.snsCrudPolicy = snsCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSnsPublishMessagePolicy}
             * @param snsPublishMessagePolicy `CfnFunction.SAMPolicyTemplateProperty.SNSPublishMessagePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsPublishMessagePolicy(software.amazon.awscdk.core.IResolvable snsPublishMessagePolicy) {
                this.snsPublishMessagePolicy = snsPublishMessagePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSnsPublishMessagePolicy}
             * @param snsPublishMessagePolicy `CfnFunction.SAMPolicyTemplateProperty.SNSPublishMessagePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsPublishMessagePolicy(software.amazon.awscdk.services.sam.CfnFunction.TopicSAMPTProperty snsPublishMessagePolicy) {
                this.snsPublishMessagePolicy = snsPublishMessagePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSqsPollerPolicy}
             * @param sqsPollerPolicy `CfnFunction.SAMPolicyTemplateProperty.SQSPollerPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqsPollerPolicy(software.amazon.awscdk.core.IResolvable sqsPollerPolicy) {
                this.sqsPollerPolicy = sqsPollerPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSqsPollerPolicy}
             * @param sqsPollerPolicy `CfnFunction.SAMPolicyTemplateProperty.SQSPollerPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqsPollerPolicy(software.amazon.awscdk.services.sam.CfnFunction.QueueSAMPTProperty sqsPollerPolicy) {
                this.sqsPollerPolicy = sqsPollerPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSqsSendMessagePolicy}
             * @param sqsSendMessagePolicy `CfnFunction.SAMPolicyTemplateProperty.SQSSendMessagePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqsSendMessagePolicy(software.amazon.awscdk.core.IResolvable sqsSendMessagePolicy) {
                this.sqsSendMessagePolicy = sqsSendMessagePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSqsSendMessagePolicy}
             * @param sqsSendMessagePolicy `CfnFunction.SAMPolicyTemplateProperty.SQSSendMessagePolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqsSendMessagePolicy(software.amazon.awscdk.services.sam.CfnFunction.QueueSAMPTProperty sqsSendMessagePolicy) {
                this.sqsSendMessagePolicy = sqsSendMessagePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getStepFunctionsExecutionPolicy}
             * @param stepFunctionsExecutionPolicy `CfnFunction.SAMPolicyTemplateProperty.StepFunctionsExecutionPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stepFunctionsExecutionPolicy(software.amazon.awscdk.core.IResolvable stepFunctionsExecutionPolicy) {
                this.stepFunctionsExecutionPolicy = stepFunctionsExecutionPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getStepFunctionsExecutionPolicy}
             * @param stepFunctionsExecutionPolicy `CfnFunction.SAMPolicyTemplateProperty.StepFunctionsExecutionPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stepFunctionsExecutionPolicy(software.amazon.awscdk.services.sam.CfnFunction.StateMachineSAMPTProperty stepFunctionsExecutionPolicy) {
                this.stepFunctionsExecutionPolicy = stepFunctionsExecutionPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getVpcAccessPolicy}
             * @param vpcAccessPolicy `CfnFunction.SAMPolicyTemplateProperty.VPCAccessPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcAccessPolicy(software.amazon.awscdk.core.IResolvable vpcAccessPolicy) {
                this.vpcAccessPolicy = vpcAccessPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getVpcAccessPolicy}
             * @param vpcAccessPolicy `CfnFunction.SAMPolicyTemplateProperty.VPCAccessPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcAccessPolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty vpcAccessPolicy) {
                this.vpcAccessPolicy = vpcAccessPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SAMPolicyTemplateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SAMPolicyTemplateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SAMPolicyTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SAMPolicyTemplateProperty {
            private final java.lang.Object amiDescribePolicy;
            private final java.lang.Object cloudFormationDescribeStacksPolicy;
            private final java.lang.Object cloudWatchPutMetricPolicy;
            private final java.lang.Object dynamoDbCrudPolicy;
            private final java.lang.Object dynamoDbReadPolicy;
            private final java.lang.Object dynamoDbStreamReadPolicy;
            private final java.lang.Object ec2DescribePolicy;
            private final java.lang.Object elasticsearchHttpPostPolicy;
            private final java.lang.Object filterLogEventsPolicy;
            private final java.lang.Object kinesisCrudPolicy;
            private final java.lang.Object kinesisStreamReadPolicy;
            private final java.lang.Object kmsDecryptPolicy;
            private final java.lang.Object lambdaInvokePolicy;
            private final java.lang.Object rekognitionDetectOnlyPolicy;
            private final java.lang.Object rekognitionLabelsPolicy;
            private final java.lang.Object rekognitionNoDataAccessPolicy;
            private final java.lang.Object rekognitionReadPolicy;
            private final java.lang.Object rekognitionWriteOnlyAccessPolicy;
            private final java.lang.Object s3CrudPolicy;
            private final java.lang.Object s3ReadPolicy;
            private final java.lang.Object sesBulkTemplatedCrudPolicy;
            private final java.lang.Object sesCrudPolicy;
            private final java.lang.Object sesEmailTemplateCrudPolicy;
            private final java.lang.Object sesSendBouncePolicy;
            private final java.lang.Object snsCrudPolicy;
            private final java.lang.Object snsPublishMessagePolicy;
            private final java.lang.Object sqsPollerPolicy;
            private final java.lang.Object sqsSendMessagePolicy;
            private final java.lang.Object stepFunctionsExecutionPolicy;
            private final java.lang.Object vpcAccessPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.amiDescribePolicy = software.amazon.jsii.Kernel.get(this, "amiDescribePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudFormationDescribeStacksPolicy = software.amazon.jsii.Kernel.get(this, "cloudFormationDescribeStacksPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudWatchPutMetricPolicy = software.amazon.jsii.Kernel.get(this, "cloudWatchPutMetricPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynamoDbCrudPolicy = software.amazon.jsii.Kernel.get(this, "dynamoDbCrudPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynamoDbReadPolicy = software.amazon.jsii.Kernel.get(this, "dynamoDbReadPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynamoDbStreamReadPolicy = software.amazon.jsii.Kernel.get(this, "dynamoDbStreamReadPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ec2DescribePolicy = software.amazon.jsii.Kernel.get(this, "ec2DescribePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.elasticsearchHttpPostPolicy = software.amazon.jsii.Kernel.get(this, "elasticsearchHttpPostPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.filterLogEventsPolicy = software.amazon.jsii.Kernel.get(this, "filterLogEventsPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kinesisCrudPolicy = software.amazon.jsii.Kernel.get(this, "kinesisCrudPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kinesisStreamReadPolicy = software.amazon.jsii.Kernel.get(this, "kinesisStreamReadPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kmsDecryptPolicy = software.amazon.jsii.Kernel.get(this, "kmsDecryptPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambdaInvokePolicy = software.amazon.jsii.Kernel.get(this, "lambdaInvokePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rekognitionDetectOnlyPolicy = software.amazon.jsii.Kernel.get(this, "rekognitionDetectOnlyPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rekognitionLabelsPolicy = software.amazon.jsii.Kernel.get(this, "rekognitionLabelsPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rekognitionNoDataAccessPolicy = software.amazon.jsii.Kernel.get(this, "rekognitionNoDataAccessPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rekognitionReadPolicy = software.amazon.jsii.Kernel.get(this, "rekognitionReadPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rekognitionWriteOnlyAccessPolicy = software.amazon.jsii.Kernel.get(this, "rekognitionWriteOnlyAccessPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3CrudPolicy = software.amazon.jsii.Kernel.get(this, "s3CrudPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3ReadPolicy = software.amazon.jsii.Kernel.get(this, "s3ReadPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sesBulkTemplatedCrudPolicy = software.amazon.jsii.Kernel.get(this, "sesBulkTemplatedCrudPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sesCrudPolicy = software.amazon.jsii.Kernel.get(this, "sesCrudPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sesEmailTemplateCrudPolicy = software.amazon.jsii.Kernel.get(this, "sesEmailTemplateCrudPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sesSendBouncePolicy = software.amazon.jsii.Kernel.get(this, "sesSendBouncePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.snsCrudPolicy = software.amazon.jsii.Kernel.get(this, "snsCrudPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.snsPublishMessagePolicy = software.amazon.jsii.Kernel.get(this, "snsPublishMessagePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sqsPollerPolicy = software.amazon.jsii.Kernel.get(this, "sqsPollerPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sqsSendMessagePolicy = software.amazon.jsii.Kernel.get(this, "sqsSendMessagePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stepFunctionsExecutionPolicy = software.amazon.jsii.Kernel.get(this, "stepFunctionsExecutionPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpcAccessPolicy = software.amazon.jsii.Kernel.get(this, "vpcAccessPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.amiDescribePolicy = builder.amiDescribePolicy;
                this.cloudFormationDescribeStacksPolicy = builder.cloudFormationDescribeStacksPolicy;
                this.cloudWatchPutMetricPolicy = builder.cloudWatchPutMetricPolicy;
                this.dynamoDbCrudPolicy = builder.dynamoDbCrudPolicy;
                this.dynamoDbReadPolicy = builder.dynamoDbReadPolicy;
                this.dynamoDbStreamReadPolicy = builder.dynamoDbStreamReadPolicy;
                this.ec2DescribePolicy = builder.ec2DescribePolicy;
                this.elasticsearchHttpPostPolicy = builder.elasticsearchHttpPostPolicy;
                this.filterLogEventsPolicy = builder.filterLogEventsPolicy;
                this.kinesisCrudPolicy = builder.kinesisCrudPolicy;
                this.kinesisStreamReadPolicy = builder.kinesisStreamReadPolicy;
                this.kmsDecryptPolicy = builder.kmsDecryptPolicy;
                this.lambdaInvokePolicy = builder.lambdaInvokePolicy;
                this.rekognitionDetectOnlyPolicy = builder.rekognitionDetectOnlyPolicy;
                this.rekognitionLabelsPolicy = builder.rekognitionLabelsPolicy;
                this.rekognitionNoDataAccessPolicy = builder.rekognitionNoDataAccessPolicy;
                this.rekognitionReadPolicy = builder.rekognitionReadPolicy;
                this.rekognitionWriteOnlyAccessPolicy = builder.rekognitionWriteOnlyAccessPolicy;
                this.s3CrudPolicy = builder.s3CrudPolicy;
                this.s3ReadPolicy = builder.s3ReadPolicy;
                this.sesBulkTemplatedCrudPolicy = builder.sesBulkTemplatedCrudPolicy;
                this.sesCrudPolicy = builder.sesCrudPolicy;
                this.sesEmailTemplateCrudPolicy = builder.sesEmailTemplateCrudPolicy;
                this.sesSendBouncePolicy = builder.sesSendBouncePolicy;
                this.snsCrudPolicy = builder.snsCrudPolicy;
                this.snsPublishMessagePolicy = builder.snsPublishMessagePolicy;
                this.sqsPollerPolicy = builder.sqsPollerPolicy;
                this.sqsSendMessagePolicy = builder.sqsSendMessagePolicy;
                this.stepFunctionsExecutionPolicy = builder.stepFunctionsExecutionPolicy;
                this.vpcAccessPolicy = builder.vpcAccessPolicy;
            }

            @Override
            public final java.lang.Object getAmiDescribePolicy() {
                return this.amiDescribePolicy;
            }

            @Override
            public final java.lang.Object getCloudFormationDescribeStacksPolicy() {
                return this.cloudFormationDescribeStacksPolicy;
            }

            @Override
            public final java.lang.Object getCloudWatchPutMetricPolicy() {
                return this.cloudWatchPutMetricPolicy;
            }

            @Override
            public final java.lang.Object getDynamoDbCrudPolicy() {
                return this.dynamoDbCrudPolicy;
            }

            @Override
            public final java.lang.Object getDynamoDbReadPolicy() {
                return this.dynamoDbReadPolicy;
            }

            @Override
            public final java.lang.Object getDynamoDbStreamReadPolicy() {
                return this.dynamoDbStreamReadPolicy;
            }

            @Override
            public final java.lang.Object getEc2DescribePolicy() {
                return this.ec2DescribePolicy;
            }

            @Override
            public final java.lang.Object getElasticsearchHttpPostPolicy() {
                return this.elasticsearchHttpPostPolicy;
            }

            @Override
            public final java.lang.Object getFilterLogEventsPolicy() {
                return this.filterLogEventsPolicy;
            }

            @Override
            public final java.lang.Object getKinesisCrudPolicy() {
                return this.kinesisCrudPolicy;
            }

            @Override
            public final java.lang.Object getKinesisStreamReadPolicy() {
                return this.kinesisStreamReadPolicy;
            }

            @Override
            public final java.lang.Object getKmsDecryptPolicy() {
                return this.kmsDecryptPolicy;
            }

            @Override
            public final java.lang.Object getLambdaInvokePolicy() {
                return this.lambdaInvokePolicy;
            }

            @Override
            public final java.lang.Object getRekognitionDetectOnlyPolicy() {
                return this.rekognitionDetectOnlyPolicy;
            }

            @Override
            public final java.lang.Object getRekognitionLabelsPolicy() {
                return this.rekognitionLabelsPolicy;
            }

            @Override
            public final java.lang.Object getRekognitionNoDataAccessPolicy() {
                return this.rekognitionNoDataAccessPolicy;
            }

            @Override
            public final java.lang.Object getRekognitionReadPolicy() {
                return this.rekognitionReadPolicy;
            }

            @Override
            public final java.lang.Object getRekognitionWriteOnlyAccessPolicy() {
                return this.rekognitionWriteOnlyAccessPolicy;
            }

            @Override
            public final java.lang.Object getS3CrudPolicy() {
                return this.s3CrudPolicy;
            }

            @Override
            public final java.lang.Object getS3ReadPolicy() {
                return this.s3ReadPolicy;
            }

            @Override
            public final java.lang.Object getSesBulkTemplatedCrudPolicy() {
                return this.sesBulkTemplatedCrudPolicy;
            }

            @Override
            public final java.lang.Object getSesCrudPolicy() {
                return this.sesCrudPolicy;
            }

            @Override
            public final java.lang.Object getSesEmailTemplateCrudPolicy() {
                return this.sesEmailTemplateCrudPolicy;
            }

            @Override
            public final java.lang.Object getSesSendBouncePolicy() {
                return this.sesSendBouncePolicy;
            }

            @Override
            public final java.lang.Object getSnsCrudPolicy() {
                return this.snsCrudPolicy;
            }

            @Override
            public final java.lang.Object getSnsPublishMessagePolicy() {
                return this.snsPublishMessagePolicy;
            }

            @Override
            public final java.lang.Object getSqsPollerPolicy() {
                return this.sqsPollerPolicy;
            }

            @Override
            public final java.lang.Object getSqsSendMessagePolicy() {
                return this.sqsSendMessagePolicy;
            }

            @Override
            public final java.lang.Object getStepFunctionsExecutionPolicy() {
                return this.stepFunctionsExecutionPolicy;
            }

            @Override
            public final java.lang.Object getVpcAccessPolicy() {
                return this.vpcAccessPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAmiDescribePolicy() != null) {
                    data.set("amiDescribePolicy", om.valueToTree(this.getAmiDescribePolicy()));
                }
                if (this.getCloudFormationDescribeStacksPolicy() != null) {
                    data.set("cloudFormationDescribeStacksPolicy", om.valueToTree(this.getCloudFormationDescribeStacksPolicy()));
                }
                if (this.getCloudWatchPutMetricPolicy() != null) {
                    data.set("cloudWatchPutMetricPolicy", om.valueToTree(this.getCloudWatchPutMetricPolicy()));
                }
                if (this.getDynamoDbCrudPolicy() != null) {
                    data.set("dynamoDbCrudPolicy", om.valueToTree(this.getDynamoDbCrudPolicy()));
                }
                if (this.getDynamoDbReadPolicy() != null) {
                    data.set("dynamoDbReadPolicy", om.valueToTree(this.getDynamoDbReadPolicy()));
                }
                if (this.getDynamoDbStreamReadPolicy() != null) {
                    data.set("dynamoDbStreamReadPolicy", om.valueToTree(this.getDynamoDbStreamReadPolicy()));
                }
                if (this.getEc2DescribePolicy() != null) {
                    data.set("ec2DescribePolicy", om.valueToTree(this.getEc2DescribePolicy()));
                }
                if (this.getElasticsearchHttpPostPolicy() != null) {
                    data.set("elasticsearchHttpPostPolicy", om.valueToTree(this.getElasticsearchHttpPostPolicy()));
                }
                if (this.getFilterLogEventsPolicy() != null) {
                    data.set("filterLogEventsPolicy", om.valueToTree(this.getFilterLogEventsPolicy()));
                }
                if (this.getKinesisCrudPolicy() != null) {
                    data.set("kinesisCrudPolicy", om.valueToTree(this.getKinesisCrudPolicy()));
                }
                if (this.getKinesisStreamReadPolicy() != null) {
                    data.set("kinesisStreamReadPolicy", om.valueToTree(this.getKinesisStreamReadPolicy()));
                }
                if (this.getKmsDecryptPolicy() != null) {
                    data.set("kmsDecryptPolicy", om.valueToTree(this.getKmsDecryptPolicy()));
                }
                if (this.getLambdaInvokePolicy() != null) {
                    data.set("lambdaInvokePolicy", om.valueToTree(this.getLambdaInvokePolicy()));
                }
                if (this.getRekognitionDetectOnlyPolicy() != null) {
                    data.set("rekognitionDetectOnlyPolicy", om.valueToTree(this.getRekognitionDetectOnlyPolicy()));
                }
                if (this.getRekognitionLabelsPolicy() != null) {
                    data.set("rekognitionLabelsPolicy", om.valueToTree(this.getRekognitionLabelsPolicy()));
                }
                if (this.getRekognitionNoDataAccessPolicy() != null) {
                    data.set("rekognitionNoDataAccessPolicy", om.valueToTree(this.getRekognitionNoDataAccessPolicy()));
                }
                if (this.getRekognitionReadPolicy() != null) {
                    data.set("rekognitionReadPolicy", om.valueToTree(this.getRekognitionReadPolicy()));
                }
                if (this.getRekognitionWriteOnlyAccessPolicy() != null) {
                    data.set("rekognitionWriteOnlyAccessPolicy", om.valueToTree(this.getRekognitionWriteOnlyAccessPolicy()));
                }
                if (this.getS3CrudPolicy() != null) {
                    data.set("s3CrudPolicy", om.valueToTree(this.getS3CrudPolicy()));
                }
                if (this.getS3ReadPolicy() != null) {
                    data.set("s3ReadPolicy", om.valueToTree(this.getS3ReadPolicy()));
                }
                if (this.getSesBulkTemplatedCrudPolicy() != null) {
                    data.set("sesBulkTemplatedCrudPolicy", om.valueToTree(this.getSesBulkTemplatedCrudPolicy()));
                }
                if (this.getSesCrudPolicy() != null) {
                    data.set("sesCrudPolicy", om.valueToTree(this.getSesCrudPolicy()));
                }
                if (this.getSesEmailTemplateCrudPolicy() != null) {
                    data.set("sesEmailTemplateCrudPolicy", om.valueToTree(this.getSesEmailTemplateCrudPolicy()));
                }
                if (this.getSesSendBouncePolicy() != null) {
                    data.set("sesSendBouncePolicy", om.valueToTree(this.getSesSendBouncePolicy()));
                }
                if (this.getSnsCrudPolicy() != null) {
                    data.set("snsCrudPolicy", om.valueToTree(this.getSnsCrudPolicy()));
                }
                if (this.getSnsPublishMessagePolicy() != null) {
                    data.set("snsPublishMessagePolicy", om.valueToTree(this.getSnsPublishMessagePolicy()));
                }
                if (this.getSqsPollerPolicy() != null) {
                    data.set("sqsPollerPolicy", om.valueToTree(this.getSqsPollerPolicy()));
                }
                if (this.getSqsSendMessagePolicy() != null) {
                    data.set("sqsSendMessagePolicy", om.valueToTree(this.getSqsSendMessagePolicy()));
                }
                if (this.getStepFunctionsExecutionPolicy() != null) {
                    data.set("stepFunctionsExecutionPolicy", om.valueToTree(this.getStepFunctionsExecutionPolicy()));
                }
                if (this.getVpcAccessPolicy() != null) {
                    data.set("vpcAccessPolicy", om.valueToTree(this.getVpcAccessPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.SAMPolicyTemplateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SAMPolicyTemplateProperty.Jsii$Proxy that = (SAMPolicyTemplateProperty.Jsii$Proxy) o;

                if (this.amiDescribePolicy != null ? !this.amiDescribePolicy.equals(that.amiDescribePolicy) : that.amiDescribePolicy != null) return false;
                if (this.cloudFormationDescribeStacksPolicy != null ? !this.cloudFormationDescribeStacksPolicy.equals(that.cloudFormationDescribeStacksPolicy) : that.cloudFormationDescribeStacksPolicy != null) return false;
                if (this.cloudWatchPutMetricPolicy != null ? !this.cloudWatchPutMetricPolicy.equals(that.cloudWatchPutMetricPolicy) : that.cloudWatchPutMetricPolicy != null) return false;
                if (this.dynamoDbCrudPolicy != null ? !this.dynamoDbCrudPolicy.equals(that.dynamoDbCrudPolicy) : that.dynamoDbCrudPolicy != null) return false;
                if (this.dynamoDbReadPolicy != null ? !this.dynamoDbReadPolicy.equals(that.dynamoDbReadPolicy) : that.dynamoDbReadPolicy != null) return false;
                if (this.dynamoDbStreamReadPolicy != null ? !this.dynamoDbStreamReadPolicy.equals(that.dynamoDbStreamReadPolicy) : that.dynamoDbStreamReadPolicy != null) return false;
                if (this.ec2DescribePolicy != null ? !this.ec2DescribePolicy.equals(that.ec2DescribePolicy) : that.ec2DescribePolicy != null) return false;
                if (this.elasticsearchHttpPostPolicy != null ? !this.elasticsearchHttpPostPolicy.equals(that.elasticsearchHttpPostPolicy) : that.elasticsearchHttpPostPolicy != null) return false;
                if (this.filterLogEventsPolicy != null ? !this.filterLogEventsPolicy.equals(that.filterLogEventsPolicy) : that.filterLogEventsPolicy != null) return false;
                if (this.kinesisCrudPolicy != null ? !this.kinesisCrudPolicy.equals(that.kinesisCrudPolicy) : that.kinesisCrudPolicy != null) return false;
                if (this.kinesisStreamReadPolicy != null ? !this.kinesisStreamReadPolicy.equals(that.kinesisStreamReadPolicy) : that.kinesisStreamReadPolicy != null) return false;
                if (this.kmsDecryptPolicy != null ? !this.kmsDecryptPolicy.equals(that.kmsDecryptPolicy) : that.kmsDecryptPolicy != null) return false;
                if (this.lambdaInvokePolicy != null ? !this.lambdaInvokePolicy.equals(that.lambdaInvokePolicy) : that.lambdaInvokePolicy != null) return false;
                if (this.rekognitionDetectOnlyPolicy != null ? !this.rekognitionDetectOnlyPolicy.equals(that.rekognitionDetectOnlyPolicy) : that.rekognitionDetectOnlyPolicy != null) return false;
                if (this.rekognitionLabelsPolicy != null ? !this.rekognitionLabelsPolicy.equals(that.rekognitionLabelsPolicy) : that.rekognitionLabelsPolicy != null) return false;
                if (this.rekognitionNoDataAccessPolicy != null ? !this.rekognitionNoDataAccessPolicy.equals(that.rekognitionNoDataAccessPolicy) : that.rekognitionNoDataAccessPolicy != null) return false;
                if (this.rekognitionReadPolicy != null ? !this.rekognitionReadPolicy.equals(that.rekognitionReadPolicy) : that.rekognitionReadPolicy != null) return false;
                if (this.rekognitionWriteOnlyAccessPolicy != null ? !this.rekognitionWriteOnlyAccessPolicy.equals(that.rekognitionWriteOnlyAccessPolicy) : that.rekognitionWriteOnlyAccessPolicy != null) return false;
                if (this.s3CrudPolicy != null ? !this.s3CrudPolicy.equals(that.s3CrudPolicy) : that.s3CrudPolicy != null) return false;
                if (this.s3ReadPolicy != null ? !this.s3ReadPolicy.equals(that.s3ReadPolicy) : that.s3ReadPolicy != null) return false;
                if (this.sesBulkTemplatedCrudPolicy != null ? !this.sesBulkTemplatedCrudPolicy.equals(that.sesBulkTemplatedCrudPolicy) : that.sesBulkTemplatedCrudPolicy != null) return false;
                if (this.sesCrudPolicy != null ? !this.sesCrudPolicy.equals(that.sesCrudPolicy) : that.sesCrudPolicy != null) return false;
                if (this.sesEmailTemplateCrudPolicy != null ? !this.sesEmailTemplateCrudPolicy.equals(that.sesEmailTemplateCrudPolicy) : that.sesEmailTemplateCrudPolicy != null) return false;
                if (this.sesSendBouncePolicy != null ? !this.sesSendBouncePolicy.equals(that.sesSendBouncePolicy) : that.sesSendBouncePolicy != null) return false;
                if (this.snsCrudPolicy != null ? !this.snsCrudPolicy.equals(that.snsCrudPolicy) : that.snsCrudPolicy != null) return false;
                if (this.snsPublishMessagePolicy != null ? !this.snsPublishMessagePolicy.equals(that.snsPublishMessagePolicy) : that.snsPublishMessagePolicy != null) return false;
                if (this.sqsPollerPolicy != null ? !this.sqsPollerPolicy.equals(that.sqsPollerPolicy) : that.sqsPollerPolicy != null) return false;
                if (this.sqsSendMessagePolicy != null ? !this.sqsSendMessagePolicy.equals(that.sqsSendMessagePolicy) : that.sqsSendMessagePolicy != null) return false;
                if (this.stepFunctionsExecutionPolicy != null ? !this.stepFunctionsExecutionPolicy.equals(that.stepFunctionsExecutionPolicy) : that.stepFunctionsExecutionPolicy != null) return false;
                return this.vpcAccessPolicy != null ? this.vpcAccessPolicy.equals(that.vpcAccessPolicy) : that.vpcAccessPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.amiDescribePolicy != null ? this.amiDescribePolicy.hashCode() : 0;
                result = 31 * result + (this.cloudFormationDescribeStacksPolicy != null ? this.cloudFormationDescribeStacksPolicy.hashCode() : 0);
                result = 31 * result + (this.cloudWatchPutMetricPolicy != null ? this.cloudWatchPutMetricPolicy.hashCode() : 0);
                result = 31 * result + (this.dynamoDbCrudPolicy != null ? this.dynamoDbCrudPolicy.hashCode() : 0);
                result = 31 * result + (this.dynamoDbReadPolicy != null ? this.dynamoDbReadPolicy.hashCode() : 0);
                result = 31 * result + (this.dynamoDbStreamReadPolicy != null ? this.dynamoDbStreamReadPolicy.hashCode() : 0);
                result = 31 * result + (this.ec2DescribePolicy != null ? this.ec2DescribePolicy.hashCode() : 0);
                result = 31 * result + (this.elasticsearchHttpPostPolicy != null ? this.elasticsearchHttpPostPolicy.hashCode() : 0);
                result = 31 * result + (this.filterLogEventsPolicy != null ? this.filterLogEventsPolicy.hashCode() : 0);
                result = 31 * result + (this.kinesisCrudPolicy != null ? this.kinesisCrudPolicy.hashCode() : 0);
                result = 31 * result + (this.kinesisStreamReadPolicy != null ? this.kinesisStreamReadPolicy.hashCode() : 0);
                result = 31 * result + (this.kmsDecryptPolicy != null ? this.kmsDecryptPolicy.hashCode() : 0);
                result = 31 * result + (this.lambdaInvokePolicy != null ? this.lambdaInvokePolicy.hashCode() : 0);
                result = 31 * result + (this.rekognitionDetectOnlyPolicy != null ? this.rekognitionDetectOnlyPolicy.hashCode() : 0);
                result = 31 * result + (this.rekognitionLabelsPolicy != null ? this.rekognitionLabelsPolicy.hashCode() : 0);
                result = 31 * result + (this.rekognitionNoDataAccessPolicy != null ? this.rekognitionNoDataAccessPolicy.hashCode() : 0);
                result = 31 * result + (this.rekognitionReadPolicy != null ? this.rekognitionReadPolicy.hashCode() : 0);
                result = 31 * result + (this.rekognitionWriteOnlyAccessPolicy != null ? this.rekognitionWriteOnlyAccessPolicy.hashCode() : 0);
                result = 31 * result + (this.s3CrudPolicy != null ? this.s3CrudPolicy.hashCode() : 0);
                result = 31 * result + (this.s3ReadPolicy != null ? this.s3ReadPolicy.hashCode() : 0);
                result = 31 * result + (this.sesBulkTemplatedCrudPolicy != null ? this.sesBulkTemplatedCrudPolicy.hashCode() : 0);
                result = 31 * result + (this.sesCrudPolicy != null ? this.sesCrudPolicy.hashCode() : 0);
                result = 31 * result + (this.sesEmailTemplateCrudPolicy != null ? this.sesEmailTemplateCrudPolicy.hashCode() : 0);
                result = 31 * result + (this.sesSendBouncePolicy != null ? this.sesSendBouncePolicy.hashCode() : 0);
                result = 31 * result + (this.snsCrudPolicy != null ? this.snsCrudPolicy.hashCode() : 0);
                result = 31 * result + (this.snsPublishMessagePolicy != null ? this.snsPublishMessagePolicy.hashCode() : 0);
                result = 31 * result + (this.sqsPollerPolicy != null ? this.sqsPollerPolicy.hashCode() : 0);
                result = 31 * result + (this.sqsSendMessagePolicy != null ? this.sqsSendMessagePolicy.hashCode() : 0);
                result = 31 * result + (this.stepFunctionsExecutionPolicy != null ? this.stepFunctionsExecutionPolicy.hashCode() : 0);
                result = 31 * result + (this.vpcAccessPolicy != null ? this.vpcAccessPolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * SNSEventProperty sNSEventProperty = SNSEventProperty.builder()
     *         .topic("topic")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.SNSEventProperty")
    @software.amazon.jsii.Jsii.Proxy(SNSEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SNSEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.SNSEventProperty.Topic`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTopic();

        /**
         * @return a {@link Builder} of {@link SNSEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SNSEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SNSEventProperty> {
            java.lang.String topic;

            /**
             * Sets the value of {@link SNSEventProperty#getTopic}
             * @param topic `CfnFunction.SNSEventProperty.Topic`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topic(java.lang.String topic) {
                this.topic = topic;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SNSEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SNSEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SNSEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SNSEventProperty {
            private final java.lang.String topic;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.topic = software.amazon.jsii.Kernel.get(this, "topic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.topic = java.util.Objects.requireNonNull(builder.topic, "topic is required");
            }

            @Override
            public final java.lang.String getTopic() {
                return this.topic;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("topic", om.valueToTree(this.getTopic()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.SNSEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SNSEventProperty.Jsii$Proxy that = (SNSEventProperty.Jsii$Proxy) o;

                return this.topic.equals(that.topic);
            }

            @Override
            public final int hashCode() {
                int result = this.topic.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * SQSEventProperty sQSEventProperty = SQSEventProperty.builder()
     *         .queue("queue")
     *         // the properties below are optional
     *         .batchSize(123)
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.SQSEventProperty")
    @software.amazon.jsii.Jsii.Proxy(SQSEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SQSEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.SQSEventProperty.Queue`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getQueue();

        /**
         * `CfnFunction.SQSEventProperty.BatchSize`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBatchSize() {
            return null;
        }

        /**
         * `CfnFunction.SQSEventProperty.Enabled`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SQSEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SQSEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SQSEventProperty> {
            java.lang.String queue;
            java.lang.Number batchSize;
            java.lang.Object enabled;

            /**
             * Sets the value of {@link SQSEventProperty#getQueue}
             * @param queue `CfnFunction.SQSEventProperty.Queue`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queue(java.lang.String queue) {
                this.queue = queue;
                return this;
            }

            /**
             * Sets the value of {@link SQSEventProperty#getBatchSize}
             * @param batchSize `CfnFunction.SQSEventProperty.BatchSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchSize(java.lang.Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            /**
             * Sets the value of {@link SQSEventProperty#getEnabled}
             * @param enabled `CfnFunction.SQSEventProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link SQSEventProperty#getEnabled}
             * @param enabled `CfnFunction.SQSEventProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SQSEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SQSEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SQSEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SQSEventProperty {
            private final java.lang.String queue;
            private final java.lang.Number batchSize;
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.queue = software.amazon.jsii.Kernel.get(this, "queue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.batchSize = software.amazon.jsii.Kernel.get(this, "batchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.queue = java.util.Objects.requireNonNull(builder.queue, "queue is required");
                this.batchSize = builder.batchSize;
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.String getQueue() {
                return this.queue;
            }

            @Override
            public final java.lang.Number getBatchSize() {
                return this.batchSize;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("queue", om.valueToTree(this.getQueue()));
                if (this.getBatchSize() != null) {
                    data.set("batchSize", om.valueToTree(this.getBatchSize()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.SQSEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SQSEventProperty.Jsii$Proxy that = (SQSEventProperty.Jsii$Proxy) o;

                if (!queue.equals(that.queue)) return false;
                if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.queue.hashCode();
                result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * ScheduleEventProperty scheduleEventProperty = ScheduleEventProperty.builder()
     *         .schedule("schedule")
     *         // the properties below are optional
     *         .input("input")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.ScheduleEventProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduleEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduleEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.ScheduleEventProperty.Schedule`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSchedule();

        /**
         * `CfnFunction.ScheduleEventProperty.Input`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInput() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduleEventProperty> {
            java.lang.String schedule;
            java.lang.String input;

            /**
             * Sets the value of {@link ScheduleEventProperty#getSchedule}
             * @param schedule `CfnFunction.ScheduleEventProperty.Schedule`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schedule(java.lang.String schedule) {
                this.schedule = schedule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleEventProperty#getInput}
             * @param input `CfnFunction.ScheduleEventProperty.Input`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder input(java.lang.String input) {
                this.input = input;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduleEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleEventProperty {
            private final java.lang.String schedule;
            private final java.lang.String input;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.schedule = java.util.Objects.requireNonNull(builder.schedule, "schedule is required");
                this.input = builder.input;
            }

            @Override
            public final java.lang.String getSchedule() {
                return this.schedule;
            }

            @Override
            public final java.lang.String getInput() {
                return this.input;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("schedule", om.valueToTree(this.getSchedule()));
                if (this.getInput() != null) {
                    data.set("input", om.valueToTree(this.getInput()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.ScheduleEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduleEventProperty.Jsii$Proxy that = (ScheduleEventProperty.Jsii$Proxy) o;

                if (!schedule.equals(that.schedule)) return false;
                return this.input != null ? this.input.equals(that.input) : that.input == null;
            }

            @Override
            public final int hashCode() {
                int result = this.schedule.hashCode();
                result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * StateMachineSAMPTProperty stateMachineSAMPTProperty = StateMachineSAMPTProperty.builder()
     *         .stateMachineName("stateMachineName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.StateMachineSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(StateMachineSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StateMachineSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.StateMachineSAMPTProperty.StateMachineName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStateMachineName();

        /**
         * @return a {@link Builder} of {@link StateMachineSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StateMachineSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StateMachineSAMPTProperty> {
            java.lang.String stateMachineName;

            /**
             * Sets the value of {@link StateMachineSAMPTProperty#getStateMachineName}
             * @param stateMachineName `CfnFunction.StateMachineSAMPTProperty.StateMachineName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stateMachineName(java.lang.String stateMachineName) {
                this.stateMachineName = stateMachineName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StateMachineSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StateMachineSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StateMachineSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StateMachineSAMPTProperty {
            private final java.lang.String stateMachineName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.stateMachineName = software.amazon.jsii.Kernel.get(this, "stateMachineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.stateMachineName = java.util.Objects.requireNonNull(builder.stateMachineName, "stateMachineName is required");
            }

            @Override
            public final java.lang.String getStateMachineName() {
                return this.stateMachineName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("stateMachineName", om.valueToTree(this.getStateMachineName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.StateMachineSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StateMachineSAMPTProperty.Jsii$Proxy that = (StateMachineSAMPTProperty.Jsii$Proxy) o;

                return this.stateMachineName.equals(that.stateMachineName);
            }

            @Override
            public final int hashCode() {
                int result = this.stateMachineName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * StreamSAMPTProperty streamSAMPTProperty = StreamSAMPTProperty.builder()
     *         .streamName("streamName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.StreamSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(StreamSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StreamSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.StreamSAMPTProperty.StreamName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStreamName();

        /**
         * @return a {@link Builder} of {@link StreamSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StreamSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StreamSAMPTProperty> {
            java.lang.String streamName;

            /**
             * Sets the value of {@link StreamSAMPTProperty#getStreamName}
             * @param streamName `CfnFunction.StreamSAMPTProperty.StreamName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamName(java.lang.String streamName) {
                this.streamName = streamName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StreamSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StreamSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamSAMPTProperty {
            private final java.lang.String streamName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.streamName = software.amazon.jsii.Kernel.get(this, "streamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.streamName = java.util.Objects.requireNonNull(builder.streamName, "streamName is required");
            }

            @Override
            public final java.lang.String getStreamName() {
                return this.streamName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("streamName", om.valueToTree(this.getStreamName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.StreamSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StreamSAMPTProperty.Jsii$Proxy that = (StreamSAMPTProperty.Jsii$Proxy) o;

                return this.streamName.equals(that.streamName);
            }

            @Override
            public final int hashCode() {
                int result = this.streamName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * TableSAMPTProperty tableSAMPTProperty = TableSAMPTProperty.builder()
     *         .tableName("tableName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.TableSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(TableSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TableSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.TableSAMPTProperty.TableName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * @return a {@link Builder} of {@link TableSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TableSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TableSAMPTProperty> {
            java.lang.String tableName;

            /**
             * Sets the value of {@link TableSAMPTProperty#getTableName}
             * @param tableName `CfnFunction.TableSAMPTProperty.TableName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TableSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TableSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TableSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableSAMPTProperty {
            private final java.lang.String tableName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("tableName", om.valueToTree(this.getTableName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.TableSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TableSAMPTProperty.Jsii$Proxy that = (TableSAMPTProperty.Jsii$Proxy) o;

                return this.tableName.equals(that.tableName);
            }

            @Override
            public final int hashCode() {
                int result = this.tableName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * TableStreamSAMPTProperty tableStreamSAMPTProperty = TableStreamSAMPTProperty.builder()
     *         .streamName("streamName")
     *         .tableName("tableName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.TableStreamSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(TableStreamSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TableStreamSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.TableStreamSAMPTProperty.StreamName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStreamName();

        /**
         * `CfnFunction.TableStreamSAMPTProperty.TableName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * @return a {@link Builder} of {@link TableStreamSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TableStreamSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TableStreamSAMPTProperty> {
            java.lang.String streamName;
            java.lang.String tableName;

            /**
             * Sets the value of {@link TableStreamSAMPTProperty#getStreamName}
             * @param streamName `CfnFunction.TableStreamSAMPTProperty.StreamName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamName(java.lang.String streamName) {
                this.streamName = streamName;
                return this;
            }

            /**
             * Sets the value of {@link TableStreamSAMPTProperty#getTableName}
             * @param tableName `CfnFunction.TableStreamSAMPTProperty.TableName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TableStreamSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TableStreamSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TableStreamSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableStreamSAMPTProperty {
            private final java.lang.String streamName;
            private final java.lang.String tableName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.streamName = software.amazon.jsii.Kernel.get(this, "streamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.streamName = java.util.Objects.requireNonNull(builder.streamName, "streamName is required");
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
            }

            @Override
            public final java.lang.String getStreamName() {
                return this.streamName;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("streamName", om.valueToTree(this.getStreamName()));
                data.set("tableName", om.valueToTree(this.getTableName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.TableStreamSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TableStreamSAMPTProperty.Jsii$Proxy that = (TableStreamSAMPTProperty.Jsii$Proxy) o;

                if (!streamName.equals(that.streamName)) return false;
                return this.tableName.equals(that.tableName);
            }

            @Override
            public final int hashCode() {
                int result = this.streamName.hashCode();
                result = 31 * result + (this.tableName.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * TopicSAMPTProperty topicSAMPTProperty = TopicSAMPTProperty.builder()
     *         .topicName("topicName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.TopicSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(TopicSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.TopicSAMPTProperty.TopicName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTopicName();

        /**
         * @return a {@link Builder} of {@link TopicSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TopicSAMPTProperty> {
            java.lang.String topicName;

            /**
             * Sets the value of {@link TopicSAMPTProperty#getTopicName}
             * @param topicName `CfnFunction.TopicSAMPTProperty.TopicName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicName(java.lang.String topicName) {
                this.topicName = topicName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TopicSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TopicSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicSAMPTProperty {
            private final java.lang.String topicName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.topicName = software.amazon.jsii.Kernel.get(this, "topicName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.topicName = java.util.Objects.requireNonNull(builder.topicName, "topicName is required");
            }

            @Override
            public final java.lang.String getTopicName() {
                return this.topicName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("topicName", om.valueToTree(this.getTopicName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.TopicSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicSAMPTProperty.Jsii$Proxy that = (TopicSAMPTProperty.Jsii$Proxy) o;

                return this.topicName.equals(that.topicName);
            }

            @Override
            public final int hashCode() {
                int result = this.topicName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * VpcConfigProperty vpcConfigProperty = VpcConfigProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnetIds(List.of("subnetIds"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnFunction.VpcConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFunction.VpcConfigProperty.SecurityGroupIds`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIds();

        /**
         * `CfnFunction.VpcConfigProperty.SubnetIds`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds();

        /**
         * @return a {@link Builder} of {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcConfigProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnetIds;

            /**
             * Sets the value of {@link VpcConfigProperty#getSecurityGroupIds}
             * @param securityGroupIds `CfnFunction.VpcConfigProperty.SecurityGroupIds`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VpcConfigProperty#getSubnetIds}
             * @param subnetIds `CfnFunction.VpcConfigProperty.SubnetIds`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConfigProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnetIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = java.util.Objects.requireNonNull(builder.securityGroupIds, "securityGroupIds is required");
                this.subnetIds = java.util.Objects.requireNonNull(builder.subnetIds, "subnetIds is required");
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                data.set("subnetIds", om.valueToTree(this.getSubnetIds()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnFunction.VpcConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcConfigProperty.Jsii$Proxy that = (VpcConfigProperty.Jsii$Proxy) o;

                if (!securityGroupIds.equals(that.securityGroupIds)) return false;
                return this.subnetIds.equals(that.subnetIds);
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds.hashCode();
                result = 31 * result + (this.subnetIds.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sam.CfnFunction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sam.CfnFunction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.sam.CfnFunctionProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * `AWS::Serverless::Function.Architectures`.
         * <p>
         * @return {@code this}
         * @param architectures `AWS::Serverless::Function.Architectures`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder architectures(final java.util.List<java.lang.String> architectures) {
            this.props().architectures(architectures);
            return this;
        }

        /**
         * `AWS::Serverless::Function.AssumeRolePolicyDocument`.
         * <p>
         * @return {@code this}
         * @param assumeRolePolicyDocument `AWS::Serverless::Function.AssumeRolePolicyDocument`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumeRolePolicyDocument(final java.lang.Object assumeRolePolicyDocument) {
            this.props().assumeRolePolicyDocument(assumeRolePolicyDocument);
            return this;
        }

        /**
         * `AWS::Serverless::Function.AutoPublishAlias`.
         * <p>
         * @return {@code this}
         * @param autoPublishAlias `AWS::Serverless::Function.AutoPublishAlias`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoPublishAlias(final java.lang.String autoPublishAlias) {
            this.props().autoPublishAlias(autoPublishAlias);
            return this;
        }

        /**
         * `AWS::Serverless::Function.AutoPublishCodeSha256`.
         * <p>
         * @return {@code this}
         * @param autoPublishCodeSha256 `AWS::Serverless::Function.AutoPublishCodeSha256`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoPublishCodeSha256(final java.lang.String autoPublishCodeSha256) {
            this.props().autoPublishCodeSha256(autoPublishCodeSha256);
            return this;
        }

        /**
         * `AWS::Serverless::Function.CodeSigningConfigArn`.
         * <p>
         * @return {@code this}
         * @param codeSigningConfigArn `AWS::Serverless::Function.CodeSigningConfigArn`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeSigningConfigArn(final java.lang.String codeSigningConfigArn) {
            this.props().codeSigningConfigArn(codeSigningConfigArn);
            return this;
        }

        /**
         * `AWS::Serverless::Function.CodeUri`.
         * <p>
         * @return {@code this}
         * @param codeUri `AWS::Serverless::Function.CodeUri`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeUri(final java.lang.String codeUri) {
            this.props().codeUri(codeUri);
            return this;
        }
        /**
         * `AWS::Serverless::Function.CodeUri`.
         * <p>
         * @return {@code this}
         * @param codeUri `AWS::Serverless::Function.CodeUri`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeUri(final software.amazon.awscdk.core.IResolvable codeUri) {
            this.props().codeUri(codeUri);
            return this;
        }
        /**
         * `AWS::Serverless::Function.CodeUri`.
         * <p>
         * @return {@code this}
         * @param codeUri `AWS::Serverless::Function.CodeUri`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeUri(final software.amazon.awscdk.services.sam.CfnFunction.S3LocationProperty codeUri) {
            this.props().codeUri(codeUri);
            return this;
        }

        /**
         * `AWS::Serverless::Function.DeadLetterQueue`.
         * <p>
         * @return {@code this}
         * @param deadLetterQueue `AWS::Serverless::Function.DeadLetterQueue`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.core.IResolvable deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }
        /**
         * `AWS::Serverless::Function.DeadLetterQueue`.
         * <p>
         * @return {@code this}
         * @param deadLetterQueue `AWS::Serverless::Function.DeadLetterQueue`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sam.CfnFunction.DeadLetterQueueProperty deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * `AWS::Serverless::Function.DeploymentPreference`.
         * <p>
         * @return {@code this}
         * @param deploymentPreference `AWS::Serverless::Function.DeploymentPreference`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentPreference(final software.amazon.awscdk.core.IResolvable deploymentPreference) {
            this.props().deploymentPreference(deploymentPreference);
            return this;
        }
        /**
         * `AWS::Serverless::Function.DeploymentPreference`.
         * <p>
         * @return {@code this}
         * @param deploymentPreference `AWS::Serverless::Function.DeploymentPreference`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentPreference(final software.amazon.awscdk.services.sam.CfnFunction.DeploymentPreferenceProperty deploymentPreference) {
            this.props().deploymentPreference(deploymentPreference);
            return this;
        }

        /**
         * `AWS::Serverless::Function.Description`.
         * <p>
         * @return {@code this}
         * @param description `AWS::Serverless::Function.Description`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * `AWS::Serverless::Function.Environment`.
         * <p>
         * @return {@code this}
         * @param environment `AWS::Serverless::Function.Environment`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final software.amazon.awscdk.core.IResolvable environment) {
            this.props().environment(environment);
            return this;
        }
        /**
         * `AWS::Serverless::Function.Environment`.
         * <p>
         * @return {@code this}
         * @param environment `AWS::Serverless::Function.Environment`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final software.amazon.awscdk.services.sam.CfnFunction.FunctionEnvironmentProperty environment) {
            this.props().environment(environment);
            return this;
        }

        /**
         * `AWS::Serverless::Function.EventInvokeConfig`.
         * <p>
         * @return {@code this}
         * @param eventInvokeConfig `AWS::Serverless::Function.EventInvokeConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventInvokeConfig(final software.amazon.awscdk.core.IResolvable eventInvokeConfig) {
            this.props().eventInvokeConfig(eventInvokeConfig);
            return this;
        }
        /**
         * `AWS::Serverless::Function.EventInvokeConfig`.
         * <p>
         * @return {@code this}
         * @param eventInvokeConfig `AWS::Serverless::Function.EventInvokeConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventInvokeConfig(final software.amazon.awscdk.services.sam.CfnFunction.EventInvokeConfigProperty eventInvokeConfig) {
            this.props().eventInvokeConfig(eventInvokeConfig);
            return this;
        }

        /**
         * `AWS::Serverless::Function.Events`.
         * <p>
         * @return {@code this}
         * @param events `AWS::Serverless::Function.Events`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(final software.amazon.awscdk.core.IResolvable events) {
            this.props().events(events);
            return this;
        }
        /**
         * `AWS::Serverless::Function.Events`.
         * <p>
         * @return {@code this}
         * @param events `AWS::Serverless::Function.Events`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(final java.util.Map<java.lang.String, ? extends java.lang.Object> events) {
            this.props().events(events);
            return this;
        }

        /**
         * `AWS::Serverless::Function.FileSystemConfigs`.
         * <p>
         * @return {@code this}
         * @param fileSystemConfigs `AWS::Serverless::Function.FileSystemConfigs`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemConfigs(final software.amazon.awscdk.core.IResolvable fileSystemConfigs) {
            this.props().fileSystemConfigs(fileSystemConfigs);
            return this;
        }
        /**
         * `AWS::Serverless::Function.FileSystemConfigs`.
         * <p>
         * @return {@code this}
         * @param fileSystemConfigs `AWS::Serverless::Function.FileSystemConfigs`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemConfigs(final java.util.List<? extends java.lang.Object> fileSystemConfigs) {
            this.props().fileSystemConfigs(fileSystemConfigs);
            return this;
        }

        /**
         * `AWS::Serverless::Function.FunctionName`.
         * <p>
         * @return {@code this}
         * @param functionName `AWS::Serverless::Function.FunctionName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(final java.lang.String functionName) {
            this.props().functionName(functionName);
            return this;
        }

        /**
         * `AWS::Serverless::Function.Handler`.
         * <p>
         * @return {@code this}
         * @param handler `AWS::Serverless::Function.Handler`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder handler(final java.lang.String handler) {
            this.props().handler(handler);
            return this;
        }

        /**
         * `AWS::Serverless::Function.ImageConfig`.
         * <p>
         * @return {@code this}
         * @param imageConfig `AWS::Serverless::Function.ImageConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageConfig(final software.amazon.awscdk.core.IResolvable imageConfig) {
            this.props().imageConfig(imageConfig);
            return this;
        }
        /**
         * `AWS::Serverless::Function.ImageConfig`.
         * <p>
         * @return {@code this}
         * @param imageConfig `AWS::Serverless::Function.ImageConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageConfig(final software.amazon.awscdk.services.sam.CfnFunction.ImageConfigProperty imageConfig) {
            this.props().imageConfig(imageConfig);
            return this;
        }

        /**
         * `AWS::Serverless::Function.ImageUri`.
         * <p>
         * @return {@code this}
         * @param imageUri `AWS::Serverless::Function.ImageUri`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageUri(final java.lang.String imageUri) {
            this.props().imageUri(imageUri);
            return this;
        }

        /**
         * `AWS::Serverless::Function.InlineCode`.
         * <p>
         * @return {@code this}
         * @param inlineCode `AWS::Serverless::Function.InlineCode`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inlineCode(final java.lang.String inlineCode) {
            this.props().inlineCode(inlineCode);
            return this;
        }

        /**
         * `AWS::Serverless::Function.KmsKeyArn`.
         * <p>
         * @return {@code this}
         * @param kmsKeyArn `AWS::Serverless::Function.KmsKeyArn`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyArn(final java.lang.String kmsKeyArn) {
            this.props().kmsKeyArn(kmsKeyArn);
            return this;
        }

        /**
         * `AWS::Serverless::Function.Layers`.
         * <p>
         * @return {@code this}
         * @param layers `AWS::Serverless::Function.Layers`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder layers(final java.util.List<java.lang.String> layers) {
            this.props().layers(layers);
            return this;
        }

        /**
         * `AWS::Serverless::Function.MemorySize`.
         * <p>
         * @return {@code this}
         * @param memorySize `AWS::Serverless::Function.MemorySize`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memorySize(final java.lang.Number memorySize) {
            this.props().memorySize(memorySize);
            return this;
        }

        /**
         * `AWS::Serverless::Function.PackageType`.
         * <p>
         * @return {@code this}
         * @param packageType `AWS::Serverless::Function.PackageType`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packageType(final java.lang.String packageType) {
            this.props().packageType(packageType);
            return this;
        }

        /**
         * `AWS::Serverless::Function.PermissionsBoundary`.
         * <p>
         * @return {@code this}
         * @param permissionsBoundary `AWS::Serverless::Function.PermissionsBoundary`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsBoundary(final java.lang.String permissionsBoundary) {
            this.props().permissionsBoundary(permissionsBoundary);
            return this;
        }

        /**
         * `AWS::Serverless::Function.Policies`.
         * <p>
         * @return {@code this}
         * @param policies `AWS::Serverless::Function.Policies`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(final java.lang.String policies) {
            this.props().policies(policies);
            return this;
        }
        /**
         * `AWS::Serverless::Function.Policies`.
         * <p>
         * @return {@code this}
         * @param policies `AWS::Serverless::Function.Policies`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(final software.amazon.awscdk.core.IResolvable policies) {
            this.props().policies(policies);
            return this;
        }
        /**
         * `AWS::Serverless::Function.Policies`.
         * <p>
         * @return {@code this}
         * @param policies `AWS::Serverless::Function.Policies`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(final software.amazon.awscdk.services.sam.CfnFunction.IAMPolicyDocumentProperty policies) {
            this.props().policies(policies);
            return this;
        }
        /**
         * `AWS::Serverless::Function.Policies`.
         * <p>
         * @return {@code this}
         * @param policies `AWS::Serverless::Function.Policies`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(final java.util.List<? extends java.lang.Object> policies) {
            this.props().policies(policies);
            return this;
        }

        /**
         * `AWS::Serverless::Function.ProvisionedConcurrencyConfig`.
         * <p>
         * @return {@code this}
         * @param provisionedConcurrencyConfig `AWS::Serverless::Function.ProvisionedConcurrencyConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedConcurrencyConfig(final software.amazon.awscdk.core.IResolvable provisionedConcurrencyConfig) {
            this.props().provisionedConcurrencyConfig(provisionedConcurrencyConfig);
            return this;
        }
        /**
         * `AWS::Serverless::Function.ProvisionedConcurrencyConfig`.
         * <p>
         * @return {@code this}
         * @param provisionedConcurrencyConfig `AWS::Serverless::Function.ProvisionedConcurrencyConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedConcurrencyConfig(final software.amazon.awscdk.services.sam.CfnFunction.ProvisionedConcurrencyConfigProperty provisionedConcurrencyConfig) {
            this.props().provisionedConcurrencyConfig(provisionedConcurrencyConfig);
            return this;
        }

        /**
         * `AWS::Serverless::Function.ReservedConcurrentExecutions`.
         * <p>
         * @return {@code this}
         * @param reservedConcurrentExecutions `AWS::Serverless::Function.ReservedConcurrentExecutions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reservedConcurrentExecutions(final java.lang.Number reservedConcurrentExecutions) {
            this.props().reservedConcurrentExecutions(reservedConcurrentExecutions);
            return this;
        }

        /**
         * `AWS::Serverless::Function.Role`.
         * <p>
         * @return {@code this}
         * @param role `AWS::Serverless::Function.Role`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final java.lang.String role) {
            this.props().role(role);
            return this;
        }

        /**
         * `AWS::Serverless::Function.Runtime`.
         * <p>
         * @return {@code this}
         * @param runtime `AWS::Serverless::Function.Runtime`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtime(final java.lang.String runtime) {
            this.props().runtime(runtime);
            return this;
        }

        /**
         * `AWS::Serverless::Function.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::Serverless::Function.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * `AWS::Serverless::Function.Timeout`.
         * <p>
         * @return {@code this}
         * @param timeout `AWS::Serverless::Function.Timeout`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final java.lang.Number timeout) {
            this.props().timeout(timeout);
            return this;
        }

        /**
         * `AWS::Serverless::Function.Tracing`.
         * <p>
         * @return {@code this}
         * @param tracing `AWS::Serverless::Function.Tracing`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracing(final java.lang.String tracing) {
            this.props().tracing(tracing);
            return this;
        }

        /**
         * `AWS::Serverless::Function.VersionDescription`.
         * <p>
         * @return {@code this}
         * @param versionDescription `AWS::Serverless::Function.VersionDescription`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionDescription(final java.lang.String versionDescription) {
            this.props().versionDescription(versionDescription);
            return this;
        }

        /**
         * `AWS::Serverless::Function.VpcConfig`.
         * <p>
         * @return {@code this}
         * @param vpcConfig `AWS::Serverless::Function.VpcConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.core.IResolvable vpcConfig) {
            this.props().vpcConfig(vpcConfig);
            return this;
        }
        /**
         * `AWS::Serverless::Function.VpcConfig`.
         * <p>
         * @return {@code this}
         * @param vpcConfig `AWS::Serverless::Function.VpcConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.services.sam.CfnFunction.VpcConfigProperty vpcConfig) {
            this.props().vpcConfig(vpcConfig);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sam.CfnFunction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sam.CfnFunction build() {
            return new software.amazon.awscdk.services.sam.CfnFunction(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.sam.CfnFunctionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.sam.CfnFunctionProps.Builder();
            }
            return this.props;
        }
    }
}
