package software.amazon.awscdk.services.sam;

/**
 * A CloudFormation `AWS::Serverless::HttpApi`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sam.*;
 * Object authorizers;
 * Object definitionBody;
 * CfnHttpApi cfnHttpApi = CfnHttpApi.Builder.create(this, "MyCfnHttpApi")
 *         .accessLogSetting(AccessLogSettingProperty.builder()
 *                 .destinationArn("destinationArn")
 *                 .format("format")
 *                 .build())
 *         .auth(HttpApiAuthProperty.builder()
 *                 .authorizers(authorizers)
 *                 .defaultAuthorizer("defaultAuthorizer")
 *                 .build())
 *         .corsConfiguration(false)
 *         .defaultRouteSettings(RouteSettingsProperty.builder()
 *                 .dataTraceEnabled(false)
 *                 .detailedMetricsEnabled(false)
 *                 .loggingLevel("loggingLevel")
 *                 .throttlingBurstLimit(123)
 *                 .throttlingRateLimit(123)
 *                 .build())
 *         .definitionBody(definitionBody)
 *         .definitionUri("definitionUri")
 *         .description("description")
 *         .disableExecuteApiEndpoint(false)
 *         .domain(HttpApiDomainConfigurationProperty.builder()
 *                 .certificateArn("certificateArn")
 *                 .domainName("domainName")
 *                 // the properties below are optional
 *                 .basePath("basePath")
 *                 .endpointConfiguration("endpointConfiguration")
 *                 .mutualTlsAuthentication(MutualTlsAuthenticationProperty.builder()
 *                         .truststoreUri("truststoreUri")
 *                         .truststoreVersion(false)
 *                         .build())
 *                 .route53(Route53ConfigurationProperty.builder()
 *                         .distributedDomainName("distributedDomainName")
 *                         .evaluateTargetHealth(false)
 *                         .hostedZoneId("hostedZoneId")
 *                         .hostedZoneName("hostedZoneName")
 *                         .ipV6(false)
 *                         .build())
 *                 .securityPolicy("securityPolicy")
 *                 .build())
 *         .failOnWarnings(false)
 *         .routeSettings(RouteSettingsProperty.builder()
 *                 .dataTraceEnabled(false)
 *                 .detailedMetricsEnabled(false)
 *                 .loggingLevel("loggingLevel")
 *                 .throttlingBurstLimit(123)
 *                 .throttlingRateLimit(123)
 *                 .build())
 *         .stageName("stageName")
 *         .stageVariables(Map.of(
 *                 "stageVariablesKey", "stageVariables"))
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-07-15T22:15:00.295Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnHttpApi")
public class CfnHttpApi extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnHttpApi(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnHttpApi(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnHttpApi.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        REQUIRED_TRANSFORM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnHttpApi.class, "REQUIRED_TRANSFORM", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Serverless::HttpApi`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnHttpApi(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnHttpApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::Serverless::HttpApi`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnHttpApi(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The `Transform` a template must use in order to use this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String REQUIRED_TRANSFORM;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::Serverless::HttpApi.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * `AWS::Serverless::HttpApi.DefinitionBody`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDefinitionBody() {
        return software.amazon.jsii.Kernel.get(this, "definitionBody", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::HttpApi.DefinitionBody`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionBody(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "definitionBody", java.util.Objects.requireNonNull(value, "definitionBody is required"));
    }

    /**
     * `AWS::Serverless::HttpApi.AccessLogSetting`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAccessLogSetting() {
        return software.amazon.jsii.Kernel.get(this, "accessLogSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::HttpApi.AccessLogSetting`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessLogSetting(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "accessLogSetting", value);
    }

    /**
     * `AWS::Serverless::HttpApi.AccessLogSetting`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessLogSetting(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnHttpApi.AccessLogSettingProperty value) {
        software.amazon.jsii.Kernel.set(this, "accessLogSetting", value);
    }

    /**
     * `AWS::Serverless::HttpApi.Auth`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAuth() {
        return software.amazon.jsii.Kernel.get(this, "auth", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::HttpApi.Auth`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuth(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "auth", value);
    }

    /**
     * `AWS::Serverless::HttpApi.Auth`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuth(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnHttpApi.HttpApiAuthProperty value) {
        software.amazon.jsii.Kernel.set(this, "auth", value);
    }

    /**
     * `AWS::Serverless::HttpApi.CorsConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCorsConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "corsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::HttpApi.CorsConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCorsConfiguration(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "corsConfiguration", value);
    }

    /**
     * `AWS::Serverless::HttpApi.CorsConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCorsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "corsConfiguration", value);
    }

    /**
     * `AWS::Serverless::HttpApi.CorsConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCorsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnHttpApi.CorsConfigurationObjectProperty value) {
        software.amazon.jsii.Kernel.set(this, "corsConfiguration", value);
    }

    /**
     * `AWS::Serverless::HttpApi.DefaultRouteSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefaultRouteSettings() {
        return software.amazon.jsii.Kernel.get(this, "defaultRouteSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::HttpApi.DefaultRouteSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultRouteSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "defaultRouteSettings", value);
    }

    /**
     * `AWS::Serverless::HttpApi.DefaultRouteSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultRouteSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnHttpApi.RouteSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "defaultRouteSettings", value);
    }

    /**
     * `AWS::Serverless::HttpApi.DefinitionUri`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefinitionUri() {
        return software.amazon.jsii.Kernel.get(this, "definitionUri", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::HttpApi.DefinitionUri`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionUri(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "definitionUri", value);
    }

    /**
     * `AWS::Serverless::HttpApi.DefinitionUri`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionUri(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "definitionUri", value);
    }

    /**
     * `AWS::Serverless::HttpApi.DefinitionUri`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionUri(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnHttpApi.S3LocationProperty value) {
        software.amazon.jsii.Kernel.set(this, "definitionUri", value);
    }

    /**
     * `AWS::Serverless::HttpApi.Description`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Serverless::HttpApi.Description`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * `AWS::Serverless::HttpApi.DisableExecuteApiEndpoint`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDisableExecuteApiEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "disableExecuteApiEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::HttpApi.DisableExecuteApiEndpoint`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisableExecuteApiEndpoint(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "disableExecuteApiEndpoint", value);
    }

    /**
     * `AWS::Serverless::HttpApi.DisableExecuteApiEndpoint`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisableExecuteApiEndpoint(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "disableExecuteApiEndpoint", value);
    }

    /**
     * `AWS::Serverless::HttpApi.Domain`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDomain() {
        return software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::HttpApi.Domain`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomain(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "domain", value);
    }

    /**
     * `AWS::Serverless::HttpApi.Domain`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomain(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnHttpApi.HttpApiDomainConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "domain", value);
    }

    /**
     * `AWS::Serverless::HttpApi.FailOnWarnings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFailOnWarnings() {
        return software.amazon.jsii.Kernel.get(this, "failOnWarnings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::HttpApi.FailOnWarnings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFailOnWarnings(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "failOnWarnings", value);
    }

    /**
     * `AWS::Serverless::HttpApi.FailOnWarnings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFailOnWarnings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "failOnWarnings", value);
    }

    /**
     * `AWS::Serverless::HttpApi.RouteSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRouteSettings() {
        return software.amazon.jsii.Kernel.get(this, "routeSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::HttpApi.RouteSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRouteSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "routeSettings", value);
    }

    /**
     * `AWS::Serverless::HttpApi.RouteSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRouteSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnHttpApi.RouteSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "routeSettings", value);
    }

    /**
     * `AWS::Serverless::HttpApi.StageName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStageName() {
        return software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Serverless::HttpApi.StageName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStageName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "stageName", value);
    }

    /**
     * `AWS::Serverless::HttpApi.StageVariables`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStageVariables() {
        return software.amazon.jsii.Kernel.get(this, "stageVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Serverless::HttpApi.StageVariables`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStageVariables(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "stageVariables", value);
    }

    /**
     * `AWS::Serverless::HttpApi.StageVariables`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStageVariables(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "stageVariables", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * AccessLogSettingProperty accessLogSettingProperty = AccessLogSettingProperty.builder()
     *         .destinationArn("destinationArn")
     *         .format("format")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnHttpApi.AccessLogSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessLogSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccessLogSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnHttpApi.AccessLogSettingProperty.DestinationArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationArn() {
            return null;
        }

        /**
         * `CfnHttpApi.AccessLogSettingProperty.Format`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccessLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccessLogSettingProperty> {
            java.lang.String destinationArn;
            java.lang.String format;

            /**
             * Sets the value of {@link AccessLogSettingProperty#getDestinationArn}
             * @param destinationArn `CfnHttpApi.AccessLogSettingProperty.DestinationArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationArn(java.lang.String destinationArn) {
                this.destinationArn = destinationArn;
                return this;
            }

            /**
             * Sets the value of {@link AccessLogSettingProperty#getFormat}
             * @param format `CfnHttpApi.AccessLogSettingProperty.Format`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessLogSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccessLogSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccessLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessLogSettingProperty {
            private final java.lang.String destinationArn;
            private final java.lang.String format;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationArn = software.amazon.jsii.Kernel.get(this, "destinationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationArn = builder.destinationArn;
                this.format = builder.format;
            }

            @Override
            public final java.lang.String getDestinationArn() {
                return this.destinationArn;
            }

            @Override
            public final java.lang.String getFormat() {
                return this.format;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestinationArn() != null) {
                    data.set("destinationArn", om.valueToTree(this.getDestinationArn()));
                }
                if (this.getFormat() != null) {
                    data.set("format", om.valueToTree(this.getFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnHttpApi.AccessLogSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessLogSettingProperty.Jsii$Proxy that = (AccessLogSettingProperty.Jsii$Proxy) o;

                if (this.destinationArn != null ? !this.destinationArn.equals(that.destinationArn) : that.destinationArn != null) return false;
                return this.format != null ? this.format.equals(that.format) : that.format == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationArn != null ? this.destinationArn.hashCode() : 0;
                result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * CorsConfigurationObjectProperty corsConfigurationObjectProperty = CorsConfigurationObjectProperty.builder()
     *         .allowCredentials(false)
     *         .allowHeaders("allowHeaders")
     *         .allowMethods("allowMethods")
     *         .allowOrigin("allowOrigin")
     *         .exposeHeaders(List.of("exposeHeaders"))
     *         .maxAge("maxAge")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnHttpApi.CorsConfigurationObjectProperty")
    @software.amazon.jsii.Jsii.Proxy(CorsConfigurationObjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CorsConfigurationObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnHttpApi.CorsConfigurationObjectProperty.AllowCredentials`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowCredentials() {
            return null;
        }

        /**
         * `CfnHttpApi.CorsConfigurationObjectProperty.AllowHeaders`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllowHeaders() {
            return null;
        }

        /**
         * `CfnHttpApi.CorsConfigurationObjectProperty.AllowMethods`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllowMethods() {
            return null;
        }

        /**
         * `CfnHttpApi.CorsConfigurationObjectProperty.AllowOrigin`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllowOrigin() {
            return null;
        }

        /**
         * `CfnHttpApi.CorsConfigurationObjectProperty.ExposeHeaders`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExposeHeaders() {
            return null;
        }

        /**
         * `CfnHttpApi.CorsConfigurationObjectProperty.MaxAge`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaxAge() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CorsConfigurationObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CorsConfigurationObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CorsConfigurationObjectProperty> {
            java.lang.Object allowCredentials;
            java.lang.String allowHeaders;
            java.lang.String allowMethods;
            java.lang.String allowOrigin;
            java.util.List<java.lang.String> exposeHeaders;
            java.lang.String maxAge;

            /**
             * Sets the value of {@link CorsConfigurationObjectProperty#getAllowCredentials}
             * @param allowCredentials `CfnHttpApi.CorsConfigurationObjectProperty.AllowCredentials`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowCredentials(java.lang.Boolean allowCredentials) {
                this.allowCredentials = allowCredentials;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigurationObjectProperty#getAllowCredentials}
             * @param allowCredentials `CfnHttpApi.CorsConfigurationObjectProperty.AllowCredentials`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowCredentials(software.amazon.awscdk.core.IResolvable allowCredentials) {
                this.allowCredentials = allowCredentials;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigurationObjectProperty#getAllowHeaders}
             * @param allowHeaders `CfnHttpApi.CorsConfigurationObjectProperty.AllowHeaders`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowHeaders(java.lang.String allowHeaders) {
                this.allowHeaders = allowHeaders;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigurationObjectProperty#getAllowMethods}
             * @param allowMethods `CfnHttpApi.CorsConfigurationObjectProperty.AllowMethods`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowMethods(java.lang.String allowMethods) {
                this.allowMethods = allowMethods;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigurationObjectProperty#getAllowOrigin}
             * @param allowOrigin `CfnHttpApi.CorsConfigurationObjectProperty.AllowOrigin`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowOrigin(java.lang.String allowOrigin) {
                this.allowOrigin = allowOrigin;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigurationObjectProperty#getExposeHeaders}
             * @param exposeHeaders `CfnHttpApi.CorsConfigurationObjectProperty.ExposeHeaders`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exposeHeaders(java.util.List<java.lang.String> exposeHeaders) {
                this.exposeHeaders = exposeHeaders;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigurationObjectProperty#getMaxAge}
             * @param maxAge `CfnHttpApi.CorsConfigurationObjectProperty.MaxAge`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxAge(java.lang.String maxAge) {
                this.maxAge = maxAge;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CorsConfigurationObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CorsConfigurationObjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CorsConfigurationObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CorsConfigurationObjectProperty {
            private final java.lang.Object allowCredentials;
            private final java.lang.String allowHeaders;
            private final java.lang.String allowMethods;
            private final java.lang.String allowOrigin;
            private final java.util.List<java.lang.String> exposeHeaders;
            private final java.lang.String maxAge;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowCredentials = software.amazon.jsii.Kernel.get(this, "allowCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.allowHeaders = software.amazon.jsii.Kernel.get(this, "allowHeaders", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.allowMethods = software.amazon.jsii.Kernel.get(this, "allowMethods", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.allowOrigin = software.amazon.jsii.Kernel.get(this, "allowOrigin", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.exposeHeaders = software.amazon.jsii.Kernel.get(this, "exposeHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.maxAge = software.amazon.jsii.Kernel.get(this, "maxAge", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowCredentials = builder.allowCredentials;
                this.allowHeaders = builder.allowHeaders;
                this.allowMethods = builder.allowMethods;
                this.allowOrigin = builder.allowOrigin;
                this.exposeHeaders = builder.exposeHeaders;
                this.maxAge = builder.maxAge;
            }

            @Override
            public final java.lang.Object getAllowCredentials() {
                return this.allowCredentials;
            }

            @Override
            public final java.lang.String getAllowHeaders() {
                return this.allowHeaders;
            }

            @Override
            public final java.lang.String getAllowMethods() {
                return this.allowMethods;
            }

            @Override
            public final java.lang.String getAllowOrigin() {
                return this.allowOrigin;
            }

            @Override
            public final java.util.List<java.lang.String> getExposeHeaders() {
                return this.exposeHeaders;
            }

            @Override
            public final java.lang.String getMaxAge() {
                return this.maxAge;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowCredentials() != null) {
                    data.set("allowCredentials", om.valueToTree(this.getAllowCredentials()));
                }
                if (this.getAllowHeaders() != null) {
                    data.set("allowHeaders", om.valueToTree(this.getAllowHeaders()));
                }
                if (this.getAllowMethods() != null) {
                    data.set("allowMethods", om.valueToTree(this.getAllowMethods()));
                }
                if (this.getAllowOrigin() != null) {
                    data.set("allowOrigin", om.valueToTree(this.getAllowOrigin()));
                }
                if (this.getExposeHeaders() != null) {
                    data.set("exposeHeaders", om.valueToTree(this.getExposeHeaders()));
                }
                if (this.getMaxAge() != null) {
                    data.set("maxAge", om.valueToTree(this.getMaxAge()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnHttpApi.CorsConfigurationObjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CorsConfigurationObjectProperty.Jsii$Proxy that = (CorsConfigurationObjectProperty.Jsii$Proxy) o;

                if (this.allowCredentials != null ? !this.allowCredentials.equals(that.allowCredentials) : that.allowCredentials != null) return false;
                if (this.allowHeaders != null ? !this.allowHeaders.equals(that.allowHeaders) : that.allowHeaders != null) return false;
                if (this.allowMethods != null ? !this.allowMethods.equals(that.allowMethods) : that.allowMethods != null) return false;
                if (this.allowOrigin != null ? !this.allowOrigin.equals(that.allowOrigin) : that.allowOrigin != null) return false;
                if (this.exposeHeaders != null ? !this.exposeHeaders.equals(that.exposeHeaders) : that.exposeHeaders != null) return false;
                return this.maxAge != null ? this.maxAge.equals(that.maxAge) : that.maxAge == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowCredentials != null ? this.allowCredentials.hashCode() : 0;
                result = 31 * result + (this.allowHeaders != null ? this.allowHeaders.hashCode() : 0);
                result = 31 * result + (this.allowMethods != null ? this.allowMethods.hashCode() : 0);
                result = 31 * result + (this.allowOrigin != null ? this.allowOrigin.hashCode() : 0);
                result = 31 * result + (this.exposeHeaders != null ? this.exposeHeaders.hashCode() : 0);
                result = 31 * result + (this.maxAge != null ? this.maxAge.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * Object authorizers;
     * HttpApiAuthProperty httpApiAuthProperty = HttpApiAuthProperty.builder()
     *         .authorizers(authorizers)
     *         .defaultAuthorizer("defaultAuthorizer")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnHttpApi.HttpApiAuthProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpApiAuthProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpApiAuthProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnHttpApi.HttpApiAuthProperty.Authorizers`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthorizers() {
            return null;
        }

        /**
         * `CfnHttpApi.HttpApiAuthProperty.DefaultAuthorizer`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultAuthorizer() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpApiAuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpApiAuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpApiAuthProperty> {
            java.lang.Object authorizers;
            java.lang.String defaultAuthorizer;

            /**
             * Sets the value of {@link HttpApiAuthProperty#getAuthorizers}
             * @param authorizers `CfnHttpApi.HttpApiAuthProperty.Authorizers`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizers(java.lang.Object authorizers) {
                this.authorizers = authorizers;
                return this;
            }

            /**
             * Sets the value of {@link HttpApiAuthProperty#getDefaultAuthorizer}
             * @param defaultAuthorizer `CfnHttpApi.HttpApiAuthProperty.DefaultAuthorizer`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultAuthorizer(java.lang.String defaultAuthorizer) {
                this.defaultAuthorizer = defaultAuthorizer;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpApiAuthProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpApiAuthProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpApiAuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpApiAuthProperty {
            private final java.lang.Object authorizers;
            private final java.lang.String defaultAuthorizer;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authorizers = software.amazon.jsii.Kernel.get(this, "authorizers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultAuthorizer = software.amazon.jsii.Kernel.get(this, "defaultAuthorizer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authorizers = builder.authorizers;
                this.defaultAuthorizer = builder.defaultAuthorizer;
            }

            @Override
            public final java.lang.Object getAuthorizers() {
                return this.authorizers;
            }

            @Override
            public final java.lang.String getDefaultAuthorizer() {
                return this.defaultAuthorizer;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthorizers() != null) {
                    data.set("authorizers", om.valueToTree(this.getAuthorizers()));
                }
                if (this.getDefaultAuthorizer() != null) {
                    data.set("defaultAuthorizer", om.valueToTree(this.getDefaultAuthorizer()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnHttpApi.HttpApiAuthProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpApiAuthProperty.Jsii$Proxy that = (HttpApiAuthProperty.Jsii$Proxy) o;

                if (this.authorizers != null ? !this.authorizers.equals(that.authorizers) : that.authorizers != null) return false;
                return this.defaultAuthorizer != null ? this.defaultAuthorizer.equals(that.defaultAuthorizer) : that.defaultAuthorizer == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authorizers != null ? this.authorizers.hashCode() : 0;
                result = 31 * result + (this.defaultAuthorizer != null ? this.defaultAuthorizer.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * HttpApiDomainConfigurationProperty httpApiDomainConfigurationProperty = HttpApiDomainConfigurationProperty.builder()
     *         .certificateArn("certificateArn")
     *         .domainName("domainName")
     *         // the properties below are optional
     *         .basePath("basePath")
     *         .endpointConfiguration("endpointConfiguration")
     *         .mutualTlsAuthentication(MutualTlsAuthenticationProperty.builder()
     *                 .truststoreUri("truststoreUri")
     *                 .truststoreVersion(false)
     *                 .build())
     *         .route53(Route53ConfigurationProperty.builder()
     *                 .distributedDomainName("distributedDomainName")
     *                 .evaluateTargetHealth(false)
     *                 .hostedZoneId("hostedZoneId")
     *                 .hostedZoneName("hostedZoneName")
     *                 .ipV6(false)
     *                 .build())
     *         .securityPolicy("securityPolicy")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnHttpApi.HttpApiDomainConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpApiDomainConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpApiDomainConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnHttpApi.HttpApiDomainConfigurationProperty.CertificateArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCertificateArn();

        /**
         * `CfnHttpApi.HttpApiDomainConfigurationProperty.DomainName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

        /**
         * `CfnHttpApi.HttpApiDomainConfigurationProperty.BasePath`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBasePath() {
            return null;
        }

        /**
         * `CfnHttpApi.HttpApiDomainConfigurationProperty.EndpointConfiguration`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEndpointConfiguration() {
            return null;
        }

        /**
         * `CfnHttpApi.HttpApiDomainConfigurationProperty.MutualTlsAuthentication`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMutualTlsAuthentication() {
            return null;
        }

        /**
         * `CfnHttpApi.HttpApiDomainConfigurationProperty.Route53`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRoute53() {
            return null;
        }

        /**
         * `CfnHttpApi.HttpApiDomainConfigurationProperty.SecurityPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecurityPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpApiDomainConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpApiDomainConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpApiDomainConfigurationProperty> {
            java.lang.String certificateArn;
            java.lang.String domainName;
            java.lang.String basePath;
            java.lang.String endpointConfiguration;
            java.lang.Object mutualTlsAuthentication;
            java.lang.Object route53;
            java.lang.String securityPolicy;

            /**
             * Sets the value of {@link HttpApiDomainConfigurationProperty#getCertificateArn}
             * @param certificateArn `CfnHttpApi.HttpApiDomainConfigurationProperty.CertificateArn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateArn(java.lang.String certificateArn) {
                this.certificateArn = certificateArn;
                return this;
            }

            /**
             * Sets the value of {@link HttpApiDomainConfigurationProperty#getDomainName}
             * @param domainName `CfnHttpApi.HttpApiDomainConfigurationProperty.DomainName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainName(java.lang.String domainName) {
                this.domainName = domainName;
                return this;
            }

            /**
             * Sets the value of {@link HttpApiDomainConfigurationProperty#getBasePath}
             * @param basePath `CfnHttpApi.HttpApiDomainConfigurationProperty.BasePath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basePath(java.lang.String basePath) {
                this.basePath = basePath;
                return this;
            }

            /**
             * Sets the value of {@link HttpApiDomainConfigurationProperty#getEndpointConfiguration}
             * @param endpointConfiguration `CfnHttpApi.HttpApiDomainConfigurationProperty.EndpointConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointConfiguration(java.lang.String endpointConfiguration) {
                this.endpointConfiguration = endpointConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link HttpApiDomainConfigurationProperty#getMutualTlsAuthentication}
             * @param mutualTlsAuthentication `CfnHttpApi.HttpApiDomainConfigurationProperty.MutualTlsAuthentication`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mutualTlsAuthentication(software.amazon.awscdk.core.IResolvable mutualTlsAuthentication) {
                this.mutualTlsAuthentication = mutualTlsAuthentication;
                return this;
            }

            /**
             * Sets the value of {@link HttpApiDomainConfigurationProperty#getMutualTlsAuthentication}
             * @param mutualTlsAuthentication `CfnHttpApi.HttpApiDomainConfigurationProperty.MutualTlsAuthentication`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mutualTlsAuthentication(software.amazon.awscdk.services.sam.CfnHttpApi.MutualTlsAuthenticationProperty mutualTlsAuthentication) {
                this.mutualTlsAuthentication = mutualTlsAuthentication;
                return this;
            }

            /**
             * Sets the value of {@link HttpApiDomainConfigurationProperty#getRoute53}
             * @param route53 `CfnHttpApi.HttpApiDomainConfigurationProperty.Route53`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder route53(software.amazon.awscdk.core.IResolvable route53) {
                this.route53 = route53;
                return this;
            }

            /**
             * Sets the value of {@link HttpApiDomainConfigurationProperty#getRoute53}
             * @param route53 `CfnHttpApi.HttpApiDomainConfigurationProperty.Route53`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder route53(software.amazon.awscdk.services.sam.CfnHttpApi.Route53ConfigurationProperty route53) {
                this.route53 = route53;
                return this;
            }

            /**
             * Sets the value of {@link HttpApiDomainConfigurationProperty#getSecurityPolicy}
             * @param securityPolicy `CfnHttpApi.HttpApiDomainConfigurationProperty.SecurityPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityPolicy(java.lang.String securityPolicy) {
                this.securityPolicy = securityPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpApiDomainConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpApiDomainConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpApiDomainConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpApiDomainConfigurationProperty {
            private final java.lang.String certificateArn;
            private final java.lang.String domainName;
            private final java.lang.String basePath;
            private final java.lang.String endpointConfiguration;
            private final java.lang.Object mutualTlsAuthentication;
            private final java.lang.Object route53;
            private final java.lang.String securityPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateArn = software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.basePath = software.amazon.jsii.Kernel.get(this, "basePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endpointConfiguration = software.amazon.jsii.Kernel.get(this, "endpointConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mutualTlsAuthentication = software.amazon.jsii.Kernel.get(this, "mutualTlsAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.route53 = software.amazon.jsii.Kernel.get(this, "route53", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.securityPolicy = software.amazon.jsii.Kernel.get(this, "securityPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateArn = java.util.Objects.requireNonNull(builder.certificateArn, "certificateArn is required");
                this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
                this.basePath = builder.basePath;
                this.endpointConfiguration = builder.endpointConfiguration;
                this.mutualTlsAuthentication = builder.mutualTlsAuthentication;
                this.route53 = builder.route53;
                this.securityPolicy = builder.securityPolicy;
            }

            @Override
            public final java.lang.String getCertificateArn() {
                return this.certificateArn;
            }

            @Override
            public final java.lang.String getDomainName() {
                return this.domainName;
            }

            @Override
            public final java.lang.String getBasePath() {
                return this.basePath;
            }

            @Override
            public final java.lang.String getEndpointConfiguration() {
                return this.endpointConfiguration;
            }

            @Override
            public final java.lang.Object getMutualTlsAuthentication() {
                return this.mutualTlsAuthentication;
            }

            @Override
            public final java.lang.Object getRoute53() {
                return this.route53;
            }

            @Override
            public final java.lang.String getSecurityPolicy() {
                return this.securityPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("certificateArn", om.valueToTree(this.getCertificateArn()));
                data.set("domainName", om.valueToTree(this.getDomainName()));
                if (this.getBasePath() != null) {
                    data.set("basePath", om.valueToTree(this.getBasePath()));
                }
                if (this.getEndpointConfiguration() != null) {
                    data.set("endpointConfiguration", om.valueToTree(this.getEndpointConfiguration()));
                }
                if (this.getMutualTlsAuthentication() != null) {
                    data.set("mutualTlsAuthentication", om.valueToTree(this.getMutualTlsAuthentication()));
                }
                if (this.getRoute53() != null) {
                    data.set("route53", om.valueToTree(this.getRoute53()));
                }
                if (this.getSecurityPolicy() != null) {
                    data.set("securityPolicy", om.valueToTree(this.getSecurityPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnHttpApi.HttpApiDomainConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpApiDomainConfigurationProperty.Jsii$Proxy that = (HttpApiDomainConfigurationProperty.Jsii$Proxy) o;

                if (!certificateArn.equals(that.certificateArn)) return false;
                if (!domainName.equals(that.domainName)) return false;
                if (this.basePath != null ? !this.basePath.equals(that.basePath) : that.basePath != null) return false;
                if (this.endpointConfiguration != null ? !this.endpointConfiguration.equals(that.endpointConfiguration) : that.endpointConfiguration != null) return false;
                if (this.mutualTlsAuthentication != null ? !this.mutualTlsAuthentication.equals(that.mutualTlsAuthentication) : that.mutualTlsAuthentication != null) return false;
                if (this.route53 != null ? !this.route53.equals(that.route53) : that.route53 != null) return false;
                return this.securityPolicy != null ? this.securityPolicy.equals(that.securityPolicy) : that.securityPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.certificateArn.hashCode();
                result = 31 * result + (this.domainName.hashCode());
                result = 31 * result + (this.basePath != null ? this.basePath.hashCode() : 0);
                result = 31 * result + (this.endpointConfiguration != null ? this.endpointConfiguration.hashCode() : 0);
                result = 31 * result + (this.mutualTlsAuthentication != null ? this.mutualTlsAuthentication.hashCode() : 0);
                result = 31 * result + (this.route53 != null ? this.route53.hashCode() : 0);
                result = 31 * result + (this.securityPolicy != null ? this.securityPolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * MutualTlsAuthenticationProperty mutualTlsAuthenticationProperty = MutualTlsAuthenticationProperty.builder()
     *         .truststoreUri("truststoreUri")
     *         .truststoreVersion(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnHttpApi.MutualTlsAuthenticationProperty")
    @software.amazon.jsii.Jsii.Proxy(MutualTlsAuthenticationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MutualTlsAuthenticationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnHttpApi.MutualTlsAuthenticationProperty.TruststoreUri`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTruststoreUri() {
            return null;
        }

        /**
         * `CfnHttpApi.MutualTlsAuthenticationProperty.TruststoreVersion`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTruststoreVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MutualTlsAuthenticationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MutualTlsAuthenticationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MutualTlsAuthenticationProperty> {
            java.lang.String truststoreUri;
            java.lang.Object truststoreVersion;

            /**
             * Sets the value of {@link MutualTlsAuthenticationProperty#getTruststoreUri}
             * @param truststoreUri `CfnHttpApi.MutualTlsAuthenticationProperty.TruststoreUri`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder truststoreUri(java.lang.String truststoreUri) {
                this.truststoreUri = truststoreUri;
                return this;
            }

            /**
             * Sets the value of {@link MutualTlsAuthenticationProperty#getTruststoreVersion}
             * @param truststoreVersion `CfnHttpApi.MutualTlsAuthenticationProperty.TruststoreVersion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder truststoreVersion(java.lang.Boolean truststoreVersion) {
                this.truststoreVersion = truststoreVersion;
                return this;
            }

            /**
             * Sets the value of {@link MutualTlsAuthenticationProperty#getTruststoreVersion}
             * @param truststoreVersion `CfnHttpApi.MutualTlsAuthenticationProperty.TruststoreVersion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder truststoreVersion(software.amazon.awscdk.core.IResolvable truststoreVersion) {
                this.truststoreVersion = truststoreVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MutualTlsAuthenticationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MutualTlsAuthenticationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MutualTlsAuthenticationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MutualTlsAuthenticationProperty {
            private final java.lang.String truststoreUri;
            private final java.lang.Object truststoreVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.truststoreUri = software.amazon.jsii.Kernel.get(this, "truststoreUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.truststoreVersion = software.amazon.jsii.Kernel.get(this, "truststoreVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.truststoreUri = builder.truststoreUri;
                this.truststoreVersion = builder.truststoreVersion;
            }

            @Override
            public final java.lang.String getTruststoreUri() {
                return this.truststoreUri;
            }

            @Override
            public final java.lang.Object getTruststoreVersion() {
                return this.truststoreVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTruststoreUri() != null) {
                    data.set("truststoreUri", om.valueToTree(this.getTruststoreUri()));
                }
                if (this.getTruststoreVersion() != null) {
                    data.set("truststoreVersion", om.valueToTree(this.getTruststoreVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnHttpApi.MutualTlsAuthenticationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MutualTlsAuthenticationProperty.Jsii$Proxy that = (MutualTlsAuthenticationProperty.Jsii$Proxy) o;

                if (this.truststoreUri != null ? !this.truststoreUri.equals(that.truststoreUri) : that.truststoreUri != null) return false;
                return this.truststoreVersion != null ? this.truststoreVersion.equals(that.truststoreVersion) : that.truststoreVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.truststoreUri != null ? this.truststoreUri.hashCode() : 0;
                result = 31 * result + (this.truststoreVersion != null ? this.truststoreVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * Route53ConfigurationProperty route53ConfigurationProperty = Route53ConfigurationProperty.builder()
     *         .distributedDomainName("distributedDomainName")
     *         .evaluateTargetHealth(false)
     *         .hostedZoneId("hostedZoneId")
     *         .hostedZoneName("hostedZoneName")
     *         .ipV6(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnHttpApi.Route53ConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(Route53ConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Route53ConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnHttpApi.Route53ConfigurationProperty.DistributedDomainName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDistributedDomainName() {
            return null;
        }

        /**
         * `CfnHttpApi.Route53ConfigurationProperty.EvaluateTargetHealth`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEvaluateTargetHealth() {
            return null;
        }

        /**
         * `CfnHttpApi.Route53ConfigurationProperty.HostedZoneId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostedZoneId() {
            return null;
        }

        /**
         * `CfnHttpApi.Route53ConfigurationProperty.HostedZoneName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostedZoneName() {
            return null;
        }

        /**
         * `CfnHttpApi.Route53ConfigurationProperty.IpV6`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIpV6() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Route53ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Route53ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Route53ConfigurationProperty> {
            java.lang.String distributedDomainName;
            java.lang.Object evaluateTargetHealth;
            java.lang.String hostedZoneId;
            java.lang.String hostedZoneName;
            java.lang.Object ipV6;

            /**
             * Sets the value of {@link Route53ConfigurationProperty#getDistributedDomainName}
             * @param distributedDomainName `CfnHttpApi.Route53ConfigurationProperty.DistributedDomainName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder distributedDomainName(java.lang.String distributedDomainName) {
                this.distributedDomainName = distributedDomainName;
                return this;
            }

            /**
             * Sets the value of {@link Route53ConfigurationProperty#getEvaluateTargetHealth}
             * @param evaluateTargetHealth `CfnHttpApi.Route53ConfigurationProperty.EvaluateTargetHealth`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluateTargetHealth(java.lang.Boolean evaluateTargetHealth) {
                this.evaluateTargetHealth = evaluateTargetHealth;
                return this;
            }

            /**
             * Sets the value of {@link Route53ConfigurationProperty#getEvaluateTargetHealth}
             * @param evaluateTargetHealth `CfnHttpApi.Route53ConfigurationProperty.EvaluateTargetHealth`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluateTargetHealth(software.amazon.awscdk.core.IResolvable evaluateTargetHealth) {
                this.evaluateTargetHealth = evaluateTargetHealth;
                return this;
            }

            /**
             * Sets the value of {@link Route53ConfigurationProperty#getHostedZoneId}
             * @param hostedZoneId `CfnHttpApi.Route53ConfigurationProperty.HostedZoneId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostedZoneId(java.lang.String hostedZoneId) {
                this.hostedZoneId = hostedZoneId;
                return this;
            }

            /**
             * Sets the value of {@link Route53ConfigurationProperty#getHostedZoneName}
             * @param hostedZoneName `CfnHttpApi.Route53ConfigurationProperty.HostedZoneName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostedZoneName(java.lang.String hostedZoneName) {
                this.hostedZoneName = hostedZoneName;
                return this;
            }

            /**
             * Sets the value of {@link Route53ConfigurationProperty#getIpV6}
             * @param ipV6 `CfnHttpApi.Route53ConfigurationProperty.IpV6`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipV6(java.lang.Boolean ipV6) {
                this.ipV6 = ipV6;
                return this;
            }

            /**
             * Sets the value of {@link Route53ConfigurationProperty#getIpV6}
             * @param ipV6 `CfnHttpApi.Route53ConfigurationProperty.IpV6`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipV6(software.amazon.awscdk.core.IResolvable ipV6) {
                this.ipV6 = ipV6;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Route53ConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Route53ConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Route53ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Route53ConfigurationProperty {
            private final java.lang.String distributedDomainName;
            private final java.lang.Object evaluateTargetHealth;
            private final java.lang.String hostedZoneId;
            private final java.lang.String hostedZoneName;
            private final java.lang.Object ipV6;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.distributedDomainName = software.amazon.jsii.Kernel.get(this, "distributedDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.evaluateTargetHealth = software.amazon.jsii.Kernel.get(this, "evaluateTargetHealth", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hostedZoneId = software.amazon.jsii.Kernel.get(this, "hostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostedZoneName = software.amazon.jsii.Kernel.get(this, "hostedZoneName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ipV6 = software.amazon.jsii.Kernel.get(this, "ipV6", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.distributedDomainName = builder.distributedDomainName;
                this.evaluateTargetHealth = builder.evaluateTargetHealth;
                this.hostedZoneId = builder.hostedZoneId;
                this.hostedZoneName = builder.hostedZoneName;
                this.ipV6 = builder.ipV6;
            }

            @Override
            public final java.lang.String getDistributedDomainName() {
                return this.distributedDomainName;
            }

            @Override
            public final java.lang.Object getEvaluateTargetHealth() {
                return this.evaluateTargetHealth;
            }

            @Override
            public final java.lang.String getHostedZoneId() {
                return this.hostedZoneId;
            }

            @Override
            public final java.lang.String getHostedZoneName() {
                return this.hostedZoneName;
            }

            @Override
            public final java.lang.Object getIpV6() {
                return this.ipV6;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDistributedDomainName() != null) {
                    data.set("distributedDomainName", om.valueToTree(this.getDistributedDomainName()));
                }
                if (this.getEvaluateTargetHealth() != null) {
                    data.set("evaluateTargetHealth", om.valueToTree(this.getEvaluateTargetHealth()));
                }
                if (this.getHostedZoneId() != null) {
                    data.set("hostedZoneId", om.valueToTree(this.getHostedZoneId()));
                }
                if (this.getHostedZoneName() != null) {
                    data.set("hostedZoneName", om.valueToTree(this.getHostedZoneName()));
                }
                if (this.getIpV6() != null) {
                    data.set("ipV6", om.valueToTree(this.getIpV6()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnHttpApi.Route53ConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Route53ConfigurationProperty.Jsii$Proxy that = (Route53ConfigurationProperty.Jsii$Proxy) o;

                if (this.distributedDomainName != null ? !this.distributedDomainName.equals(that.distributedDomainName) : that.distributedDomainName != null) return false;
                if (this.evaluateTargetHealth != null ? !this.evaluateTargetHealth.equals(that.evaluateTargetHealth) : that.evaluateTargetHealth != null) return false;
                if (this.hostedZoneId != null ? !this.hostedZoneId.equals(that.hostedZoneId) : that.hostedZoneId != null) return false;
                if (this.hostedZoneName != null ? !this.hostedZoneName.equals(that.hostedZoneName) : that.hostedZoneName != null) return false;
                return this.ipV6 != null ? this.ipV6.equals(that.ipV6) : that.ipV6 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.distributedDomainName != null ? this.distributedDomainName.hashCode() : 0;
                result = 31 * result + (this.evaluateTargetHealth != null ? this.evaluateTargetHealth.hashCode() : 0);
                result = 31 * result + (this.hostedZoneId != null ? this.hostedZoneId.hashCode() : 0);
                result = 31 * result + (this.hostedZoneName != null ? this.hostedZoneName.hashCode() : 0);
                result = 31 * result + (this.ipV6 != null ? this.ipV6.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * RouteSettingsProperty routeSettingsProperty = RouteSettingsProperty.builder()
     *         .dataTraceEnabled(false)
     *         .detailedMetricsEnabled(false)
     *         .loggingLevel("loggingLevel")
     *         .throttlingBurstLimit(123)
     *         .throttlingRateLimit(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnHttpApi.RouteSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(RouteSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RouteSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnHttpApi.RouteSettingsProperty.DataTraceEnabled`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataTraceEnabled() {
            return null;
        }

        /**
         * `CfnHttpApi.RouteSettingsProperty.DetailedMetricsEnabled`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDetailedMetricsEnabled() {
            return null;
        }

        /**
         * `CfnHttpApi.RouteSettingsProperty.LoggingLevel`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLoggingLevel() {
            return null;
        }

        /**
         * `CfnHttpApi.RouteSettingsProperty.ThrottlingBurstLimit`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThrottlingBurstLimit() {
            return null;
        }

        /**
         * `CfnHttpApi.RouteSettingsProperty.ThrottlingRateLimit`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThrottlingRateLimit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RouteSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RouteSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RouteSettingsProperty> {
            java.lang.Object dataTraceEnabled;
            java.lang.Object detailedMetricsEnabled;
            java.lang.String loggingLevel;
            java.lang.Number throttlingBurstLimit;
            java.lang.Number throttlingRateLimit;

            /**
             * Sets the value of {@link RouteSettingsProperty#getDataTraceEnabled}
             * @param dataTraceEnabled `CfnHttpApi.RouteSettingsProperty.DataTraceEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTraceEnabled(java.lang.Boolean dataTraceEnabled) {
                this.dataTraceEnabled = dataTraceEnabled;
                return this;
            }

            /**
             * Sets the value of {@link RouteSettingsProperty#getDataTraceEnabled}
             * @param dataTraceEnabled `CfnHttpApi.RouteSettingsProperty.DataTraceEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTraceEnabled(software.amazon.awscdk.core.IResolvable dataTraceEnabled) {
                this.dataTraceEnabled = dataTraceEnabled;
                return this;
            }

            /**
             * Sets the value of {@link RouteSettingsProperty#getDetailedMetricsEnabled}
             * @param detailedMetricsEnabled `CfnHttpApi.RouteSettingsProperty.DetailedMetricsEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder detailedMetricsEnabled(java.lang.Boolean detailedMetricsEnabled) {
                this.detailedMetricsEnabled = detailedMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link RouteSettingsProperty#getDetailedMetricsEnabled}
             * @param detailedMetricsEnabled `CfnHttpApi.RouteSettingsProperty.DetailedMetricsEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder detailedMetricsEnabled(software.amazon.awscdk.core.IResolvable detailedMetricsEnabled) {
                this.detailedMetricsEnabled = detailedMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link RouteSettingsProperty#getLoggingLevel}
             * @param loggingLevel `CfnHttpApi.RouteSettingsProperty.LoggingLevel`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loggingLevel(java.lang.String loggingLevel) {
                this.loggingLevel = loggingLevel;
                return this;
            }

            /**
             * Sets the value of {@link RouteSettingsProperty#getThrottlingBurstLimit}
             * @param throttlingBurstLimit `CfnHttpApi.RouteSettingsProperty.ThrottlingBurstLimit`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throttlingBurstLimit(java.lang.Number throttlingBurstLimit) {
                this.throttlingBurstLimit = throttlingBurstLimit;
                return this;
            }

            /**
             * Sets the value of {@link RouteSettingsProperty#getThrottlingRateLimit}
             * @param throttlingRateLimit `CfnHttpApi.RouteSettingsProperty.ThrottlingRateLimit`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throttlingRateLimit(java.lang.Number throttlingRateLimit) {
                this.throttlingRateLimit = throttlingRateLimit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RouteSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RouteSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RouteSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RouteSettingsProperty {
            private final java.lang.Object dataTraceEnabled;
            private final java.lang.Object detailedMetricsEnabled;
            private final java.lang.String loggingLevel;
            private final java.lang.Number throttlingBurstLimit;
            private final java.lang.Number throttlingRateLimit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataTraceEnabled = software.amazon.jsii.Kernel.get(this, "dataTraceEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.detailedMetricsEnabled = software.amazon.jsii.Kernel.get(this, "detailedMetricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.loggingLevel = software.amazon.jsii.Kernel.get(this, "loggingLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.throttlingBurstLimit = software.amazon.jsii.Kernel.get(this, "throttlingBurstLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.throttlingRateLimit = software.amazon.jsii.Kernel.get(this, "throttlingRateLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataTraceEnabled = builder.dataTraceEnabled;
                this.detailedMetricsEnabled = builder.detailedMetricsEnabled;
                this.loggingLevel = builder.loggingLevel;
                this.throttlingBurstLimit = builder.throttlingBurstLimit;
                this.throttlingRateLimit = builder.throttlingRateLimit;
            }

            @Override
            public final java.lang.Object getDataTraceEnabled() {
                return this.dataTraceEnabled;
            }

            @Override
            public final java.lang.Object getDetailedMetricsEnabled() {
                return this.detailedMetricsEnabled;
            }

            @Override
            public final java.lang.String getLoggingLevel() {
                return this.loggingLevel;
            }

            @Override
            public final java.lang.Number getThrottlingBurstLimit() {
                return this.throttlingBurstLimit;
            }

            @Override
            public final java.lang.Number getThrottlingRateLimit() {
                return this.throttlingRateLimit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDataTraceEnabled() != null) {
                    data.set("dataTraceEnabled", om.valueToTree(this.getDataTraceEnabled()));
                }
                if (this.getDetailedMetricsEnabled() != null) {
                    data.set("detailedMetricsEnabled", om.valueToTree(this.getDetailedMetricsEnabled()));
                }
                if (this.getLoggingLevel() != null) {
                    data.set("loggingLevel", om.valueToTree(this.getLoggingLevel()));
                }
                if (this.getThrottlingBurstLimit() != null) {
                    data.set("throttlingBurstLimit", om.valueToTree(this.getThrottlingBurstLimit()));
                }
                if (this.getThrottlingRateLimit() != null) {
                    data.set("throttlingRateLimit", om.valueToTree(this.getThrottlingRateLimit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnHttpApi.RouteSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RouteSettingsProperty.Jsii$Proxy that = (RouteSettingsProperty.Jsii$Proxy) o;

                if (this.dataTraceEnabled != null ? !this.dataTraceEnabled.equals(that.dataTraceEnabled) : that.dataTraceEnabled != null) return false;
                if (this.detailedMetricsEnabled != null ? !this.detailedMetricsEnabled.equals(that.detailedMetricsEnabled) : that.detailedMetricsEnabled != null) return false;
                if (this.loggingLevel != null ? !this.loggingLevel.equals(that.loggingLevel) : that.loggingLevel != null) return false;
                if (this.throttlingBurstLimit != null ? !this.throttlingBurstLimit.equals(that.throttlingBurstLimit) : that.throttlingBurstLimit != null) return false;
                return this.throttlingRateLimit != null ? this.throttlingRateLimit.equals(that.throttlingRateLimit) : that.throttlingRateLimit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataTraceEnabled != null ? this.dataTraceEnabled.hashCode() : 0;
                result = 31 * result + (this.detailedMetricsEnabled != null ? this.detailedMetricsEnabled.hashCode() : 0);
                result = 31 * result + (this.loggingLevel != null ? this.loggingLevel.hashCode() : 0);
                result = 31 * result + (this.throttlingBurstLimit != null ? this.throttlingBurstLimit.hashCode() : 0);
                result = 31 * result + (this.throttlingRateLimit != null ? this.throttlingRateLimit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * S3LocationProperty s3LocationProperty = S3LocationProperty.builder()
     *         .bucket("bucket")
     *         .key("key")
     *         .version(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnHttpApi.S3LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnHttpApi.S3LocationProperty.Bucket`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * `CfnHttpApi.S3LocationProperty.Key`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * `CfnHttpApi.S3LocationProperty.Version`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getVersion();

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LocationProperty> {
            java.lang.String bucket;
            java.lang.String key;
            java.lang.Number version;

            /**
             * Sets the value of {@link S3LocationProperty#getBucket}
             * @param bucket `CfnHttpApi.S3LocationProperty.Bucket`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getKey}
             * @param key `CfnHttpApi.S3LocationProperty.Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getVersion}
             * @param version `CfnHttpApi.S3LocationProperty.Version`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.Number version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String key;
            private final java.lang.Number version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.Number getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                data.set("key", om.valueToTree(this.getKey()));
                data.set("version", om.valueToTree(this.getVersion()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnHttpApi.S3LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LocationProperty.Jsii$Proxy that = (S3LocationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (!key.equals(that.key)) return false;
                return this.version.equals(that.version);
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.key.hashCode());
                result = 31 * result + (this.version.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sam.CfnHttpApi}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sam.CfnHttpApi> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.sam.CfnHttpApiProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * `AWS::Serverless::HttpApi.AccessLogSetting`.
         * <p>
         * @return {@code this}
         * @param accessLogSetting `AWS::Serverless::HttpApi.AccessLogSetting`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLogSetting(final software.amazon.awscdk.core.IResolvable accessLogSetting) {
            this.props().accessLogSetting(accessLogSetting);
            return this;
        }
        /**
         * `AWS::Serverless::HttpApi.AccessLogSetting`.
         * <p>
         * @return {@code this}
         * @param accessLogSetting `AWS::Serverless::HttpApi.AccessLogSetting`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLogSetting(final software.amazon.awscdk.services.sam.CfnHttpApi.AccessLogSettingProperty accessLogSetting) {
            this.props().accessLogSetting(accessLogSetting);
            return this;
        }

        /**
         * `AWS::Serverless::HttpApi.Auth`.
         * <p>
         * @return {@code this}
         * @param auth `AWS::Serverless::HttpApi.Auth`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder auth(final software.amazon.awscdk.core.IResolvable auth) {
            this.props().auth(auth);
            return this;
        }
        /**
         * `AWS::Serverless::HttpApi.Auth`.
         * <p>
         * @return {@code this}
         * @param auth `AWS::Serverless::HttpApi.Auth`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder auth(final software.amazon.awscdk.services.sam.CfnHttpApi.HttpApiAuthProperty auth) {
            this.props().auth(auth);
            return this;
        }

        /**
         * `AWS::Serverless::HttpApi.CorsConfiguration`.
         * <p>
         * @return {@code this}
         * @param corsConfiguration `AWS::Serverless::HttpApi.CorsConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsConfiguration(final java.lang.Boolean corsConfiguration) {
            this.props().corsConfiguration(corsConfiguration);
            return this;
        }
        /**
         * `AWS::Serverless::HttpApi.CorsConfiguration`.
         * <p>
         * @return {@code this}
         * @param corsConfiguration `AWS::Serverless::HttpApi.CorsConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsConfiguration(final software.amazon.awscdk.core.IResolvable corsConfiguration) {
            this.props().corsConfiguration(corsConfiguration);
            return this;
        }
        /**
         * `AWS::Serverless::HttpApi.CorsConfiguration`.
         * <p>
         * @return {@code this}
         * @param corsConfiguration `AWS::Serverless::HttpApi.CorsConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsConfiguration(final software.amazon.awscdk.services.sam.CfnHttpApi.CorsConfigurationObjectProperty corsConfiguration) {
            this.props().corsConfiguration(corsConfiguration);
            return this;
        }

        /**
         * `AWS::Serverless::HttpApi.DefaultRouteSettings`.
         * <p>
         * @return {@code this}
         * @param defaultRouteSettings `AWS::Serverless::HttpApi.DefaultRouteSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRouteSettings(final software.amazon.awscdk.core.IResolvable defaultRouteSettings) {
            this.props().defaultRouteSettings(defaultRouteSettings);
            return this;
        }
        /**
         * `AWS::Serverless::HttpApi.DefaultRouteSettings`.
         * <p>
         * @return {@code this}
         * @param defaultRouteSettings `AWS::Serverless::HttpApi.DefaultRouteSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRouteSettings(final software.amazon.awscdk.services.sam.CfnHttpApi.RouteSettingsProperty defaultRouteSettings) {
            this.props().defaultRouteSettings(defaultRouteSettings);
            return this;
        }

        /**
         * `AWS::Serverless::HttpApi.DefinitionBody`.
         * <p>
         * @return {@code this}
         * @param definitionBody `AWS::Serverless::HttpApi.DefinitionBody`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionBody(final java.lang.Object definitionBody) {
            this.props().definitionBody(definitionBody);
            return this;
        }

        /**
         * `AWS::Serverless::HttpApi.DefinitionUri`.
         * <p>
         * @return {@code this}
         * @param definitionUri `AWS::Serverless::HttpApi.DefinitionUri`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionUri(final java.lang.String definitionUri) {
            this.props().definitionUri(definitionUri);
            return this;
        }
        /**
         * `AWS::Serverless::HttpApi.DefinitionUri`.
         * <p>
         * @return {@code this}
         * @param definitionUri `AWS::Serverless::HttpApi.DefinitionUri`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionUri(final software.amazon.awscdk.core.IResolvable definitionUri) {
            this.props().definitionUri(definitionUri);
            return this;
        }
        /**
         * `AWS::Serverless::HttpApi.DefinitionUri`.
         * <p>
         * @return {@code this}
         * @param definitionUri `AWS::Serverless::HttpApi.DefinitionUri`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionUri(final software.amazon.awscdk.services.sam.CfnHttpApi.S3LocationProperty definitionUri) {
            this.props().definitionUri(definitionUri);
            return this;
        }

        /**
         * `AWS::Serverless::HttpApi.Description`.
         * <p>
         * @return {@code this}
         * @param description `AWS::Serverless::HttpApi.Description`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * `AWS::Serverless::HttpApi.DisableExecuteApiEndpoint`.
         * <p>
         * @return {@code this}
         * @param disableExecuteApiEndpoint `AWS::Serverless::HttpApi.DisableExecuteApiEndpoint`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableExecuteApiEndpoint(final java.lang.Boolean disableExecuteApiEndpoint) {
            this.props().disableExecuteApiEndpoint(disableExecuteApiEndpoint);
            return this;
        }
        /**
         * `AWS::Serverless::HttpApi.DisableExecuteApiEndpoint`.
         * <p>
         * @return {@code this}
         * @param disableExecuteApiEndpoint `AWS::Serverless::HttpApi.DisableExecuteApiEndpoint`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableExecuteApiEndpoint(final software.amazon.awscdk.core.IResolvable disableExecuteApiEndpoint) {
            this.props().disableExecuteApiEndpoint(disableExecuteApiEndpoint);
            return this;
        }

        /**
         * `AWS::Serverless::HttpApi.Domain`.
         * <p>
         * @return {@code this}
         * @param domain `AWS::Serverless::HttpApi.Domain`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(final software.amazon.awscdk.core.IResolvable domain) {
            this.props().domain(domain);
            return this;
        }
        /**
         * `AWS::Serverless::HttpApi.Domain`.
         * <p>
         * @return {@code this}
         * @param domain `AWS::Serverless::HttpApi.Domain`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(final software.amazon.awscdk.services.sam.CfnHttpApi.HttpApiDomainConfigurationProperty domain) {
            this.props().domain(domain);
            return this;
        }

        /**
         * `AWS::Serverless::HttpApi.FailOnWarnings`.
         * <p>
         * @return {@code this}
         * @param failOnWarnings `AWS::Serverless::HttpApi.FailOnWarnings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(final java.lang.Boolean failOnWarnings) {
            this.props().failOnWarnings(failOnWarnings);
            return this;
        }
        /**
         * `AWS::Serverless::HttpApi.FailOnWarnings`.
         * <p>
         * @return {@code this}
         * @param failOnWarnings `AWS::Serverless::HttpApi.FailOnWarnings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(final software.amazon.awscdk.core.IResolvable failOnWarnings) {
            this.props().failOnWarnings(failOnWarnings);
            return this;
        }

        /**
         * `AWS::Serverless::HttpApi.RouteSettings`.
         * <p>
         * @return {@code this}
         * @param routeSettings `AWS::Serverless::HttpApi.RouteSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeSettings(final software.amazon.awscdk.core.IResolvable routeSettings) {
            this.props().routeSettings(routeSettings);
            return this;
        }
        /**
         * `AWS::Serverless::HttpApi.RouteSettings`.
         * <p>
         * @return {@code this}
         * @param routeSettings `AWS::Serverless::HttpApi.RouteSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeSettings(final software.amazon.awscdk.services.sam.CfnHttpApi.RouteSettingsProperty routeSettings) {
            this.props().routeSettings(routeSettings);
            return this;
        }

        /**
         * `AWS::Serverless::HttpApi.StageName`.
         * <p>
         * @return {@code this}
         * @param stageName `AWS::Serverless::HttpApi.StageName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageName(final java.lang.String stageName) {
            this.props().stageName(stageName);
            return this;
        }

        /**
         * `AWS::Serverless::HttpApi.StageVariables`.
         * <p>
         * @return {@code this}
         * @param stageVariables `AWS::Serverless::HttpApi.StageVariables`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageVariables(final software.amazon.awscdk.core.IResolvable stageVariables) {
            this.props().stageVariables(stageVariables);
            return this;
        }
        /**
         * `AWS::Serverless::HttpApi.StageVariables`.
         * <p>
         * @return {@code this}
         * @param stageVariables `AWS::Serverless::HttpApi.StageVariables`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageVariables(final java.util.Map<java.lang.String, java.lang.String> stageVariables) {
            this.props().stageVariables(stageVariables);
            return this;
        }

        /**
         * `AWS::Serverless::HttpApi.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::Serverless::HttpApi.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sam.CfnHttpApi}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sam.CfnHttpApi build() {
            return new software.amazon.awscdk.services.sam.CfnHttpApi(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.sam.CfnHttpApiProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.sam.CfnHttpApiProps.Builder();
            }
            return this.props;
        }
    }
}
