/**
 * <h2>AWS Serverless Application Model Construct Library</h2>
 * <!-- raw HTML omitted -->
 * <hr />
 * <p><img src="https://img.shields.io/badge/stability-Experimental-important.svg?style=for-the-badge" alt="Stability: Experimental" /></p>
 * <blockquote>
 * <p><strong>This is a <em>developer preview</em> (public beta) module. Releases might lack important features and might have
 * future breaking changes.</strong></p>
 * <p>This API is still under active development and subject to non-backward
 * compatible changes or removal in any future version. Use of the API is not recommended in production
 * environments. Experimental APIs are not subject to the Semantic Versioning model.</p>
 * </blockquote>
 * <hr />
 * <!-- raw HTML omitted -->
 * <p>This module includes low-level constructs that synthesize into <code>AWS::Serverless</code> resources.</p>
 * <pre><code class="language-ts">// This example is in TypeScript, examples in Java are coming soon.
 * const sam = require('@aws-cdk/aws-sam');
 * </code></pre>
 * <h3>Related</h3>
 * <p>The following AWS CDK modules include constructs that can be used to work with Amazon API Gateway and AWS Lambda:</p>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/cdk/api/latest/docs/aws-lambda-readme.html">aws-lambda</a>: define AWS Lambda functions</li>
 * <li><a href="https://docs.aws.amazon.com/cdk/api/latest/docs/aws-lambda-event-sources-readme.html">aws-lambda-event-sources</a>: classes that allow using various AWS services as event sources for AWS Lambda functions</li>
 * <li><a href="https://docs.aws.amazon.com/cdk/api/latest/docs/aws-apigateway-readme.html">aws-apigateway</a>: define APIs through Amazon API Gateway</li>
 * <li><a href="https://docs.aws.amazon.com/cdk/api/latest/docs/aws-codedeploy-readme.html#lambda-applications">aws-codedeploy</a>: define AWS Lambda deployment with traffic shifting support</li>
 * </ul>
 * 
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.sam;
