/**
 * <h2>AWS Serverless Application Model Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="Stability: Experimental" src="https://img.shields.io/badge/stability-Experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * <strong>This is a <em>developer preview</em> (public beta) module.</strong>
 * <p>
 * All classes with the <code>Cfn</code> prefix in this module (<a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib">CFN Resources</a>)
 * are auto-generated from CloudFormation. They are stable and safe to use.
 * <p>
 * However, all other classes, i.e., higher level constructs, are under active development and subject to non-backward
 * compatible changes or removal in any future version. These are not subject to the <a href="https://semver.org/">Semantic Versioning</a> model.
 * This means that while you may use them, you may need to update your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module includes low-level constructs that synthesize into <code>AWS::Serverless</code> resources.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Object sam = require("&#64;aws-cdk/aws-sam");
 * </pre></blockquote>
 * <p>
 * <h3>Related</h3>
 * <p>
 * The following AWS CDK modules include constructs that can be used to work with Amazon API Gateway and AWS Lambda:
 * <p>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/cdk/api/latest/docs/aws-lambda-readme.html">aws-lambda</a>: define AWS Lambda functions</li>
 * <li><a href="https://docs.aws.amazon.com/cdk/api/latest/docs/aws-lambda-event-sources-readme.html">aws-lambda-event-sources</a>: classes that allow using various AWS services as event sources for AWS Lambda functions</li>
 * <li><a href="https://docs.aws.amazon.com/cdk/api/latest/docs/aws-apigateway-readme.html">aws-apigateway</a>: define APIs through Amazon API Gateway</li>
 * <li><a href="https://docs.aws.amazon.com/cdk/api/latest/docs/aws-codedeploy-readme.html#lambda-applications">aws-codedeploy</a>: define AWS Lambda deployment with traffic shifting support</li>
 * </ul>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.sam;
