package software.amazon.awscdk.services.sam;

/**
 * A CloudFormation `AWS::Serverless::Api`.
 * <p>
 * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.5.0 (build 46538f8)", date = "2020-05-20T13:23:08.550Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnApi")
public class CfnApi extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnApi(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApi(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnApi.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
        REQUIRED_TRANSFORM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnApi.class, "REQUIRED_TRANSFORM", java.lang.String.class);
    }

    /**
     * Create a new `AWS::Serverless::Api`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnApi(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sam.CfnApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A factory method that creates a new instance of this class from an object containing the CloudFormation properties of this resource.
     * <p>
     * Used in the &#64;aws-cdk/cloudformation-include module.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param resourceAttributes This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sam.CfnApi fromCloudFormation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.Object resourceAttributes, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FromCloudFormationOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.sam.CfnApi.class, "fromCloudFormation", software.amazon.awscdk.services.sam.CfnApi.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), resourceAttributes, java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The `Transform` a template must use in order to use this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String REQUIRED_TRANSFORM;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::Serverless::Api.DefinitionBody`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDefinitionBody() {
        return this.jsiiGet("definitionBody", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Api.DefinitionBody`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDefinitionBody(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        this.jsiiSet("definitionBody", java.util.Objects.requireNonNull(value, "definitionBody is required"));
    }

    /**
     * `AWS::Serverless::Api.StageName`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getStageName() {
        return this.jsiiGet("stageName", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Api.StageName`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setStageName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("stageName", java.util.Objects.requireNonNull(value, "stageName is required"));
    }

    /**
     * `AWS::Serverless::Api.AccessLogSetting`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAccessLogSetting() {
        return this.jsiiGet("accessLogSetting", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Api.AccessLogSetting`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAccessLogSetting(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("accessLogSetting", value);
    }

    /**
     * `AWS::Serverless::Api.AccessLogSetting`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAccessLogSetting(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnApi.AccessLogSettingProperty value) {
        this.jsiiSet("accessLogSetting", value);
    }

    /**
     * `AWS::Serverless::Api.Auth`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAuth() {
        return this.jsiiGet("auth", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Api.Auth`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAuth(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("auth", value);
    }

    /**
     * `AWS::Serverless::Api.Auth`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAuth(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnApi.AuthProperty value) {
        this.jsiiSet("auth", value);
    }

    /**
     * `AWS::Serverless::Api.BinaryMediaTypes`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBinaryMediaTypes() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("binaryMediaTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::Serverless::Api.BinaryMediaTypes`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setBinaryMediaTypes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("binaryMediaTypes", value);
    }

    /**
     * `AWS::Serverless::Api.CacheClusterEnabled`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCacheClusterEnabled() {
        return this.jsiiGet("cacheClusterEnabled", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Api.CacheClusterEnabled`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCacheClusterEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        this.jsiiSet("cacheClusterEnabled", value);
    }

    /**
     * `AWS::Serverless::Api.CacheClusterEnabled`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCacheClusterEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("cacheClusterEnabled", value);
    }

    /**
     * `AWS::Serverless::Api.CacheClusterSize`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getCacheClusterSize() {
        return this.jsiiGet("cacheClusterSize", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Api.CacheClusterSize`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCacheClusterSize(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("cacheClusterSize", value);
    }

    /**
     * `AWS::Serverless::Api.Cors`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCors() {
        return this.jsiiGet("cors", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Api.Cors`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCors(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("cors", value);
    }

    /**
     * `AWS::Serverless::Api.Cors`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("cors", value);
    }

    /**
     * `AWS::Serverless::Api.Cors`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnApi.CorsConfigurationProperty value) {
        this.jsiiSet("cors", value);
    }

    /**
     * `AWS::Serverless::Api.DefinitionUri`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefinitionUri() {
        return this.jsiiGet("definitionUri", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Api.DefinitionUri`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDefinitionUri(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("definitionUri", value);
    }

    /**
     * `AWS::Serverless::Api.DefinitionUri`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDefinitionUri(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("definitionUri", value);
    }

    /**
     * `AWS::Serverless::Api.DefinitionUri`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDefinitionUri(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnApi.S3LocationProperty value) {
        this.jsiiSet("definitionUri", value);
    }

    /**
     * `AWS::Serverless::Api.EndpointConfiguration`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndpointConfiguration() {
        return this.jsiiGet("endpointConfiguration", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Api.EndpointConfiguration`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEndpointConfiguration(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("endpointConfiguration", value);
    }

    /**
     * `AWS::Serverless::Api.MethodSettings`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMethodSettings() {
        return this.jsiiGet("methodSettings", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Api.MethodSettings`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMethodSettings(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("methodSettings", value);
    }

    /**
     * `AWS::Serverless::Api.MethodSettings`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMethodSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("methodSettings", value);
    }

    /**
     * `AWS::Serverless::Api.Name`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return this.jsiiGet("name", java.lang.String.class);
    }

    /**
     * `AWS::Serverless::Api.Name`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("name", value);
    }

    /**
     * `AWS::Serverless::Api.TracingEnabled`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTracingEnabled() {
        return this.jsiiGet("tracingEnabled", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Api.TracingEnabled`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTracingEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        this.jsiiSet("tracingEnabled", value);
    }

    /**
     * `AWS::Serverless::Api.TracingEnabled`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTracingEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("tracingEnabled", value);
    }

    /**
     * `AWS::Serverless::Api.Variables`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVariables() {
        return this.jsiiGet("variables", java.lang.Object.class);
    }

    /**
     * `AWS::Serverless::Api.Variables`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVariables(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("variables", value);
    }

    /**
     * `AWS::Serverless::Api.Variables`.
     * <p>
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVariables(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        this.jsiiSet("variables", value);
    }
    /**
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnApi.AccessLogSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessLogSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AccessLogSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApi.AccessLogSettingProperty.DestinationArn`.
         * <p>
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-destinationarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationArn() {
            return null;
        }

        /**
         * `CfnApi.AccessLogSettingProperty.Format`.
         * <p>
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-format
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccessLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String destinationArn;
            private java.lang.String format;

            /**
             * Sets the value of {@link AccessLogSettingProperty#getDestinationArn}
             * @param destinationArn `CfnApi.AccessLogSettingProperty.DestinationArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder destinationArn(java.lang.String destinationArn) {
                this.destinationArn = destinationArn;
                return this;
            }

            /**
             * Sets the value of {@link AccessLogSettingProperty#getFormat}
             * @param format `CfnApi.AccessLogSettingProperty.Format`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessLogSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AccessLogSettingProperty build() {
                return new Jsii$Proxy(destinationArn, format);
            }
        }

        /**
         * An implementation for {@link AccessLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessLogSettingProperty {
            private final java.lang.String destinationArn;
            private final java.lang.String format;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationArn = this.jsiiGet("destinationArn", java.lang.String.class);
                this.format = this.jsiiGet("format", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String destinationArn, final java.lang.String format) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationArn = destinationArn;
                this.format = format;
            }

            @Override
            public java.lang.String getDestinationArn() {
                return this.destinationArn;
            }

            @Override
            public java.lang.String getFormat() {
                return this.format;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestinationArn() != null) {
                    data.set("destinationArn", om.valueToTree(this.getDestinationArn()));
                }
                if (this.getFormat() != null) {
                    data.set("format", om.valueToTree(this.getFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnApi.AccessLogSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessLogSettingProperty.Jsii$Proxy that = (AccessLogSettingProperty.Jsii$Proxy) o;

                if (this.destinationArn != null ? !this.destinationArn.equals(that.destinationArn) : that.destinationArn != null) return false;
                return this.format != null ? this.format.equals(that.format) : that.format == null;
            }

            @Override
            public int hashCode() {
                int result = this.destinationArn != null ? this.destinationArn.hashCode() : 0;
                result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api-auth-object
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnApi.AuthProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AuthProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApi.AuthProperty.Authorizers`.
         * <p>
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api-auth-object
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthorizers() {
            return null;
        }

        /**
         * `CfnApi.AuthProperty.DefaultAuthorizer`.
         * <p>
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api-auth-object
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultAuthorizer() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object authorizers;
            private java.lang.String defaultAuthorizer;

            /**
             * Sets the value of {@link AuthProperty#getAuthorizers}
             * @param authorizers `CfnApi.AuthProperty.Authorizers`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder authorizers(java.lang.Object authorizers) {
                this.authorizers = authorizers;
                return this;
            }

            /**
             * Sets the value of {@link AuthProperty#getDefaultAuthorizer}
             * @param defaultAuthorizer `CfnApi.AuthProperty.DefaultAuthorizer`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder defaultAuthorizer(java.lang.String defaultAuthorizer) {
                this.defaultAuthorizer = defaultAuthorizer;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AuthProperty build() {
                return new Jsii$Proxy(authorizers, defaultAuthorizer);
            }
        }

        /**
         * An implementation for {@link AuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthProperty {
            private final java.lang.Object authorizers;
            private final java.lang.String defaultAuthorizer;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authorizers = this.jsiiGet("authorizers", java.lang.Object.class);
                this.defaultAuthorizer = this.jsiiGet("defaultAuthorizer", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object authorizers, final java.lang.String defaultAuthorizer) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authorizers = authorizers;
                this.defaultAuthorizer = defaultAuthorizer;
            }

            @Override
            public java.lang.Object getAuthorizers() {
                return this.authorizers;
            }

            @Override
            public java.lang.String getDefaultAuthorizer() {
                return this.defaultAuthorizer;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthorizers() != null) {
                    data.set("authorizers", om.valueToTree(this.getAuthorizers()));
                }
                if (this.getDefaultAuthorizer() != null) {
                    data.set("defaultAuthorizer", om.valueToTree(this.getDefaultAuthorizer()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnApi.AuthProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthProperty.Jsii$Proxy that = (AuthProperty.Jsii$Proxy) o;

                if (this.authorizers != null ? !this.authorizers.equals(that.authorizers) : that.authorizers != null) return false;
                return this.defaultAuthorizer != null ? this.defaultAuthorizer.equals(that.defaultAuthorizer) : that.defaultAuthorizer == null;
            }

            @Override
            public int hashCode() {
                int result = this.authorizers != null ? this.authorizers.hashCode() : 0;
                result = 31 * result + (this.defaultAuthorizer != null ? this.defaultAuthorizer.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnApi.CorsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CorsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CorsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApi.CorsConfigurationProperty.AllowOrigin`.
         * <p>
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getAllowOrigin();

        /**
         * `CfnApi.CorsConfigurationProperty.AllowCredentials`.
         * <p>
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowCredentials() {
            return null;
        }

        /**
         * `CfnApi.CorsConfigurationProperty.AllowHeaders`.
         * <p>
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllowHeaders() {
            return null;
        }

        /**
         * `CfnApi.CorsConfigurationProperty.AllowMethods`.
         * <p>
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllowMethods() {
            return null;
        }

        /**
         * `CfnApi.CorsConfigurationProperty.MaxAge`.
         * <p>
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaxAge() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CorsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CorsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String allowOrigin;
            private java.lang.Object allowCredentials;
            private java.lang.String allowHeaders;
            private java.lang.String allowMethods;
            private java.lang.String maxAge;

            /**
             * Sets the value of {@link CorsConfigurationProperty#getAllowOrigin}
             * @param allowOrigin `CfnApi.CorsConfigurationProperty.AllowOrigin`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder allowOrigin(java.lang.String allowOrigin) {
                this.allowOrigin = allowOrigin;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigurationProperty#getAllowCredentials}
             * @param allowCredentials `CfnApi.CorsConfigurationProperty.AllowCredentials`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder allowCredentials(java.lang.Boolean allowCredentials) {
                this.allowCredentials = allowCredentials;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigurationProperty#getAllowCredentials}
             * @param allowCredentials `CfnApi.CorsConfigurationProperty.AllowCredentials`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder allowCredentials(software.amazon.awscdk.core.IResolvable allowCredentials) {
                this.allowCredentials = allowCredentials;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigurationProperty#getAllowHeaders}
             * @param allowHeaders `CfnApi.CorsConfigurationProperty.AllowHeaders`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder allowHeaders(java.lang.String allowHeaders) {
                this.allowHeaders = allowHeaders;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigurationProperty#getAllowMethods}
             * @param allowMethods `CfnApi.CorsConfigurationProperty.AllowMethods`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder allowMethods(java.lang.String allowMethods) {
                this.allowMethods = allowMethods;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigurationProperty#getMaxAge}
             * @param maxAge `CfnApi.CorsConfigurationProperty.MaxAge`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder maxAge(java.lang.String maxAge) {
                this.maxAge = maxAge;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CorsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CorsConfigurationProperty build() {
                return new Jsii$Proxy(allowOrigin, allowCredentials, allowHeaders, allowMethods, maxAge);
            }
        }

        /**
         * An implementation for {@link CorsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CorsConfigurationProperty {
            private final java.lang.String allowOrigin;
            private final java.lang.Object allowCredentials;
            private final java.lang.String allowHeaders;
            private final java.lang.String allowMethods;
            private final java.lang.String maxAge;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowOrigin = this.jsiiGet("allowOrigin", java.lang.String.class);
                this.allowCredentials = this.jsiiGet("allowCredentials", java.lang.Object.class);
                this.allowHeaders = this.jsiiGet("allowHeaders", java.lang.String.class);
                this.allowMethods = this.jsiiGet("allowMethods", java.lang.String.class);
                this.maxAge = this.jsiiGet("maxAge", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String allowOrigin, final java.lang.Object allowCredentials, final java.lang.String allowHeaders, final java.lang.String allowMethods, final java.lang.String maxAge) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowOrigin = java.util.Objects.requireNonNull(allowOrigin, "allowOrigin is required");
                this.allowCredentials = allowCredentials;
                this.allowHeaders = allowHeaders;
                this.allowMethods = allowMethods;
                this.maxAge = maxAge;
            }

            @Override
            public java.lang.String getAllowOrigin() {
                return this.allowOrigin;
            }

            @Override
            public java.lang.Object getAllowCredentials() {
                return this.allowCredentials;
            }

            @Override
            public java.lang.String getAllowHeaders() {
                return this.allowHeaders;
            }

            @Override
            public java.lang.String getAllowMethods() {
                return this.allowMethods;
            }

            @Override
            public java.lang.String getMaxAge() {
                return this.maxAge;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("allowOrigin", om.valueToTree(this.getAllowOrigin()));
                if (this.getAllowCredentials() != null) {
                    data.set("allowCredentials", om.valueToTree(this.getAllowCredentials()));
                }
                if (this.getAllowHeaders() != null) {
                    data.set("allowHeaders", om.valueToTree(this.getAllowHeaders()));
                }
                if (this.getAllowMethods() != null) {
                    data.set("allowMethods", om.valueToTree(this.getAllowMethods()));
                }
                if (this.getMaxAge() != null) {
                    data.set("maxAge", om.valueToTree(this.getMaxAge()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnApi.CorsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CorsConfigurationProperty.Jsii$Proxy that = (CorsConfigurationProperty.Jsii$Proxy) o;

                if (!allowOrigin.equals(that.allowOrigin)) return false;
                if (this.allowCredentials != null ? !this.allowCredentials.equals(that.allowCredentials) : that.allowCredentials != null) return false;
                if (this.allowHeaders != null ? !this.allowHeaders.equals(that.allowHeaders) : that.allowHeaders != null) return false;
                if (this.allowMethods != null ? !this.allowMethods.equals(that.allowMethods) : that.allowMethods != null) return false;
                return this.maxAge != null ? this.maxAge.equals(that.maxAge) : that.maxAge == null;
            }

            @Override
            public int hashCode() {
                int result = this.allowOrigin.hashCode();
                result = 31 * result + (this.allowCredentials != null ? this.allowCredentials.hashCode() : 0);
                result = 31 * result + (this.allowHeaders != null ? this.allowHeaders.hashCode() : 0);
                result = 31 * result + (this.allowMethods != null ? this.allowMethods.hashCode() : 0);
                result = 31 * result + (this.maxAge != null ? this.maxAge.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3-location-object
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sam.$Module.class, fqn = "@aws-cdk/aws-sam.CfnApi.S3LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApi.S3LocationProperty.Bucket`.
         * <p>
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * `CfnApi.S3LocationProperty.Key`.
         * <p>
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * `CfnApi.S3LocationProperty.Version`.
         * <p>
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.Number getVersion();

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String bucket;
            private java.lang.String key;
            private java.lang.Number version;

            /**
             * Sets the value of {@link S3LocationProperty#getBucket}
             * @param bucket `CfnApi.S3LocationProperty.Bucket`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getKey}
             * @param key `CfnApi.S3LocationProperty.Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getVersion}
             * @param version `CfnApi.S3LocationProperty.Version`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder version(java.lang.Number version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public S3LocationProperty build() {
                return new Jsii$Proxy(bucket, key, version);
            }
        }

        /**
         * An implementation for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String key;
            private final java.lang.Number version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = this.jsiiGet("bucket", java.lang.String.class);
                this.key = this.jsiiGet("key", java.lang.String.class);
                this.version = this.jsiiGet("version", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String bucket, final java.lang.String key, final java.lang.Number version) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(bucket, "bucket is required");
                this.key = java.util.Objects.requireNonNull(key, "key is required");
                this.version = java.util.Objects.requireNonNull(version, "version is required");
            }

            @Override
            public java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public java.lang.String getKey() {
                return this.key;
            }

            @Override
            public java.lang.Number getVersion() {
                return this.version;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                data.set("key", om.valueToTree(this.getKey()));
                data.set("version", om.valueToTree(this.getVersion()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-sam.CfnApi.S3LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LocationProperty.Jsii$Proxy that = (S3LocationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (!key.equals(that.key)) return false;
                return this.version.equals(that.version);
            }

            @Override
            public int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.key.hashCode());
                result = 31 * result + (this.version.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sam.CfnApi}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sam.CfnApiProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sam.CfnApiProps.Builder();
        }

        /**
         * `AWS::Serverless::Api.StageName`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param stageName `AWS::Serverless::Api.StageName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder stageName(final java.lang.String stageName) {
            this.props.stageName(stageName);
            return this;
        }

        /**
         * `AWS::Serverless::Api.AccessLogSetting`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param accessLogSetting `AWS::Serverless::Api.AccessLogSetting`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder accessLogSetting(final software.amazon.awscdk.core.IResolvable accessLogSetting) {
            this.props.accessLogSetting(accessLogSetting);
            return this;
        }
        /**
         * `AWS::Serverless::Api.AccessLogSetting`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param accessLogSetting `AWS::Serverless::Api.AccessLogSetting`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder accessLogSetting(final software.amazon.awscdk.services.sam.CfnApi.AccessLogSettingProperty accessLogSetting) {
            this.props.accessLogSetting(accessLogSetting);
            return this;
        }

        /**
         * `AWS::Serverless::Api.Auth`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param auth `AWS::Serverless::Api.Auth`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder auth(final software.amazon.awscdk.core.IResolvable auth) {
            this.props.auth(auth);
            return this;
        }
        /**
         * `AWS::Serverless::Api.Auth`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param auth `AWS::Serverless::Api.Auth`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder auth(final software.amazon.awscdk.services.sam.CfnApi.AuthProperty auth) {
            this.props.auth(auth);
            return this;
        }

        /**
         * `AWS::Serverless::Api.BinaryMediaTypes`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param binaryMediaTypes `AWS::Serverless::Api.BinaryMediaTypes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder binaryMediaTypes(final java.util.List<java.lang.String> binaryMediaTypes) {
            this.props.binaryMediaTypes(binaryMediaTypes);
            return this;
        }

        /**
         * `AWS::Serverless::Api.CacheClusterEnabled`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param cacheClusterEnabled `AWS::Serverless::Api.CacheClusterEnabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cacheClusterEnabled(final java.lang.Boolean cacheClusterEnabled) {
            this.props.cacheClusterEnabled(cacheClusterEnabled);
            return this;
        }
        /**
         * `AWS::Serverless::Api.CacheClusterEnabled`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param cacheClusterEnabled `AWS::Serverless::Api.CacheClusterEnabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cacheClusterEnabled(final software.amazon.awscdk.core.IResolvable cacheClusterEnabled) {
            this.props.cacheClusterEnabled(cacheClusterEnabled);
            return this;
        }

        /**
         * `AWS::Serverless::Api.CacheClusterSize`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param cacheClusterSize `AWS::Serverless::Api.CacheClusterSize`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cacheClusterSize(final java.lang.String cacheClusterSize) {
            this.props.cacheClusterSize(cacheClusterSize);
            return this;
        }

        /**
         * `AWS::Serverless::Api.Cors`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param cors `AWS::Serverless::Api.Cors`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cors(final java.lang.String cors) {
            this.props.cors(cors);
            return this;
        }
        /**
         * `AWS::Serverless::Api.Cors`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param cors `AWS::Serverless::Api.Cors`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cors(final software.amazon.awscdk.core.IResolvable cors) {
            this.props.cors(cors);
            return this;
        }
        /**
         * `AWS::Serverless::Api.Cors`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param cors `AWS::Serverless::Api.Cors`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cors(final software.amazon.awscdk.services.sam.CfnApi.CorsConfigurationProperty cors) {
            this.props.cors(cors);
            return this;
        }

        /**
         * `AWS::Serverless::Api.DefinitionBody`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param definitionBody `AWS::Serverless::Api.DefinitionBody`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder definitionBody(final java.lang.Object definitionBody) {
            this.props.definitionBody(definitionBody);
            return this;
        }

        /**
         * `AWS::Serverless::Api.DefinitionUri`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param definitionUri `AWS::Serverless::Api.DefinitionUri`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder definitionUri(final java.lang.String definitionUri) {
            this.props.definitionUri(definitionUri);
            return this;
        }
        /**
         * `AWS::Serverless::Api.DefinitionUri`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param definitionUri `AWS::Serverless::Api.DefinitionUri`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder definitionUri(final software.amazon.awscdk.core.IResolvable definitionUri) {
            this.props.definitionUri(definitionUri);
            return this;
        }
        /**
         * `AWS::Serverless::Api.DefinitionUri`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param definitionUri `AWS::Serverless::Api.DefinitionUri`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder definitionUri(final software.amazon.awscdk.services.sam.CfnApi.S3LocationProperty definitionUri) {
            this.props.definitionUri(definitionUri);
            return this;
        }

        /**
         * `AWS::Serverless::Api.EndpointConfiguration`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param endpointConfiguration `AWS::Serverless::Api.EndpointConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder endpointConfiguration(final java.lang.String endpointConfiguration) {
            this.props.endpointConfiguration(endpointConfiguration);
            return this;
        }

        /**
         * `AWS::Serverless::Api.MethodSettings`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param methodSettings `AWS::Serverless::Api.MethodSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder methodSettings(final java.util.List<java.lang.Object> methodSettings) {
            this.props.methodSettings(methodSettings);
            return this;
        }
        /**
         * `AWS::Serverless::Api.MethodSettings`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param methodSettings `AWS::Serverless::Api.MethodSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder methodSettings(final software.amazon.awscdk.core.IResolvable methodSettings) {
            this.props.methodSettings(methodSettings);
            return this;
        }

        /**
         * `AWS::Serverless::Api.Name`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param name `AWS::Serverless::Api.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * `AWS::Serverless::Api.TracingEnabled`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param tracingEnabled `AWS::Serverless::Api.TracingEnabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tracingEnabled(final java.lang.Boolean tracingEnabled) {
            this.props.tracingEnabled(tracingEnabled);
            return this;
        }
        /**
         * `AWS::Serverless::Api.TracingEnabled`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param tracingEnabled `AWS::Serverless::Api.TracingEnabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tracingEnabled(final software.amazon.awscdk.core.IResolvable tracingEnabled) {
            this.props.tracingEnabled(tracingEnabled);
            return this;
        }

        /**
         * `AWS::Serverless::Api.Variables`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param variables `AWS::Serverless::Api.Variables`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder variables(final software.amazon.awscdk.core.IResolvable variables) {
            this.props.variables(variables);
            return this;
        }
        /**
         * `AWS::Serverless::Api.Variables`.
         * <p>
         * @return {@code this}
         * @see https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
         * @param variables `AWS::Serverless::Api.Variables`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder variables(final java.util.Map<java.lang.String, java.lang.String> variables) {
            this.props.variables(variables);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sam.CfnApi}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.sam.CfnApi build() {
            return new software.amazon.awscdk.services.sam.CfnApi(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
