/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.servicecatalog;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.Token;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnCloudFormationProductProps
extends JsiiSerializable {
    public String getName();

    public String getOwner();

    public Object getProvisioningArtifactParameters();

    public String getAcceptLanguage();

    public String getDescription();

    public String getDistributor();

    public String getSupportDescription();

    public String getSupportEmail();

    public String getSupportUrl();

    public List<CfnTag> getTags();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _name;
        private String _owner;
        private Object _provisioningArtifactParameters;
        @Nullable
        private String _acceptLanguage;
        @Nullable
        private String _description;
        @Nullable
        private String _distributor;
        @Nullable
        private String _supportDescription;
        @Nullable
        private String _supportEmail;
        @Nullable
        private String _supportUrl;
        @Nullable
        private List<CfnTag> _tags;

        public Builder withName(String value) {
            this._name = Objects.requireNonNull(value, "name is required");
            return this;
        }

        public Builder withOwner(String value) {
            this._owner = Objects.requireNonNull(value, "owner is required");
            return this;
        }

        public Builder withProvisioningArtifactParameters(Token value) {
            this._provisioningArtifactParameters = Objects.requireNonNull(value, "provisioningArtifactParameters is required");
            return this;
        }

        public Builder withProvisioningArtifactParameters(List<Object> value) {
            this._provisioningArtifactParameters = Objects.requireNonNull(value, "provisioningArtifactParameters is required");
            return this;
        }

        public Builder withAcceptLanguage(@Nullable String value) {
            this._acceptLanguage = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withDistributor(@Nullable String value) {
            this._distributor = value;
            return this;
        }

        public Builder withSupportDescription(@Nullable String value) {
            this._supportDescription = value;
            return this;
        }

        public Builder withSupportEmail(@Nullable String value) {
            this._supportEmail = value;
            return this;
        }

        public Builder withSupportUrl(@Nullable String value) {
            this._supportUrl = value;
            return this;
        }

        public Builder withTags(@Nullable List<CfnTag> value) {
            this._tags = value;
            return this;
        }

        public CfnCloudFormationProductProps build() {
            return new CfnCloudFormationProductProps(){
                private final String $name;
                private final String $owner;
                private final Object $provisioningArtifactParameters;
                @Nullable
                private final String $acceptLanguage;
                @Nullable
                private final String $description;
                @Nullable
                private final String $distributor;
                @Nullable
                private final String $supportDescription;
                @Nullable
                private final String $supportEmail;
                @Nullable
                private final String $supportUrl;
                @Nullable
                private final List<CfnTag> $tags;
                {
                    this.$name = Objects.requireNonNull(_name, "name is required");
                    this.$owner = Objects.requireNonNull(_owner, "owner is required");
                    this.$provisioningArtifactParameters = Objects.requireNonNull(_provisioningArtifactParameters, "provisioningArtifactParameters is required");
                    this.$acceptLanguage = _acceptLanguage;
                    this.$description = _description;
                    this.$distributor = _distributor;
                    this.$supportDescription = _supportDescription;
                    this.$supportEmail = _supportEmail;
                    this.$supportUrl = _supportUrl;
                    this.$tags = _tags;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                @Override
                public String getOwner() {
                    return this.$owner;
                }

                @Override
                public Object getProvisioningArtifactParameters() {
                    return this.$provisioningArtifactParameters;
                }

                @Override
                public String getAcceptLanguage() {
                    return this.$acceptLanguage;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public String getDistributor() {
                    return this.$distributor;
                }

                @Override
                public String getSupportDescription() {
                    return this.$supportDescription;
                }

                @Override
                public String getSupportEmail() {
                    return this.$supportEmail;
                }

                @Override
                public String getSupportUrl() {
                    return this.$supportUrl;
                }

                @Override
                public List<CfnTag> getTags() {
                    return this.$tags;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("name", om.valueToTree((Object)this.getName()));
                    obj.set("owner", om.valueToTree((Object)this.getOwner()));
                    obj.set("provisioningArtifactParameters", om.valueToTree(this.getProvisioningArtifactParameters()));
                    if (this.getAcceptLanguage() != null) {
                        obj.set("acceptLanguage", om.valueToTree((Object)this.getAcceptLanguage()));
                    }
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree((Object)this.getDescription()));
                    }
                    if (this.getDistributor() != null) {
                        obj.set("distributor", om.valueToTree((Object)this.getDistributor()));
                    }
                    if (this.getSupportDescription() != null) {
                        obj.set("supportDescription", om.valueToTree((Object)this.getSupportDescription()));
                    }
                    if (this.getSupportEmail() != null) {
                        obj.set("supportEmail", om.valueToTree((Object)this.getSupportEmail()));
                    }
                    if (this.getSupportUrl() != null) {
                        obj.set("supportUrl", om.valueToTree((Object)this.getSupportUrl()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    return obj;
                }
            };
        }
    }
}

