package software.amazon.awscdk.services.servicecatalog.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html
 */
public interface AcceptedPortfolioShareResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ``AWS::ServiceCatalog::AcceptedPortfolioShare.PortfolioId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-portfolioid
     */
    java.lang.Object getPortfolioId();
    /**
     * ``AWS::ServiceCatalog::AcceptedPortfolioShare.PortfolioId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-portfolioid
     */
    void setPortfolioId(final java.lang.String value);
    /**
     * ``AWS::ServiceCatalog::AcceptedPortfolioShare.PortfolioId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-portfolioid
     */
    void setPortfolioId(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ServiceCatalog::AcceptedPortfolioShare.AcceptLanguage``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-acceptlanguage
     */
    java.lang.Object getAcceptLanguage();
    /**
     * ``AWS::ServiceCatalog::AcceptedPortfolioShare.AcceptLanguage``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-acceptlanguage
     */
    void setAcceptLanguage(final java.lang.String value);
    /**
     * ``AWS::ServiceCatalog::AcceptedPortfolioShare.AcceptLanguage``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-acceptlanguage
     */
    void setAcceptLanguage(final software.amazon.awscdk.Token value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link AcceptedPortfolioShareResourceProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * ``AWS::ServiceCatalog::AcceptedPortfolioShare.PortfolioId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-portfolioid
         */
        public Build withPortfolioId(final java.lang.String value) {
            return new FullBuilder().withPortfolioId(value);
        }
        /**
         * ``AWS::ServiceCatalog::AcceptedPortfolioShare.PortfolioId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-portfolioid
         */
        public Build withPortfolioId(final software.amazon.awscdk.Token value) {
            return new FullBuilder().withPortfolioId(value);
        }

        public interface Build {
            /**
             * @return a new {@link AcceptedPortfolioShareResourceProps} object, initialized with the values set on this builder.
             */
            AcceptedPortfolioShareResourceProps build();
            /**
             * ``AWS::ServiceCatalog::AcceptedPortfolioShare.AcceptLanguage``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-acceptlanguage
             */
            Build withAcceptLanguage(final java.lang.String value);
            /**
             * ``AWS::ServiceCatalog::AcceptedPortfolioShare.AcceptLanguage``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-acceptlanguage
             */
            Build withAcceptLanguage(final software.amazon.awscdk.Token value);
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``AWS::ServiceCatalog::AcceptedPortfolioShare.PortfolioId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-portfolioid
             */
            public Build withPortfolioId(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "AcceptedPortfolioShareResourceProps#portfolioId is required");
                this.instance._portfolioId = value;
                return this;
            }
            /**
             * ``AWS::ServiceCatalog::AcceptedPortfolioShare.PortfolioId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-portfolioid
             */
            public Build withPortfolioId(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "AcceptedPortfolioShareResourceProps#portfolioId is required");
                this.instance._portfolioId = value;
                return this;
            }
            /**
             * ``AWS::ServiceCatalog::AcceptedPortfolioShare.AcceptLanguage``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-acceptlanguage
             */
            public Build withAcceptLanguage(final java.lang.String value) {
                this.instance._acceptLanguage = value;
                return this;
            }
            /**
             * ``AWS::ServiceCatalog::AcceptedPortfolioShare.AcceptLanguage``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-acceptlanguage
             */
            public Build withAcceptLanguage(final software.amazon.awscdk.Token value) {
                this.instance._acceptLanguage = value;
                return this;
            }
            public AcceptedPortfolioShareResourceProps build() {
                AcceptedPortfolioShareResourceProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link AcceptedPortfolioShareResourceProps}.
     */
    final class Jsii$Pojo implements AcceptedPortfolioShareResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _portfolioId;

        public java.lang.Object getPortfolioId() {
            return this._portfolioId;
        }
        public void setPortfolioId(final java.lang.String value) {
            this._portfolioId = value;
        }
        public void setPortfolioId(final software.amazon.awscdk.Token value) {
            this._portfolioId = value;
        }

        protected java.lang.Object _acceptLanguage;

        public java.lang.Object getAcceptLanguage() {
            return this._acceptLanguage;
        }
        public void setAcceptLanguage(final java.lang.String value) {
            this._acceptLanguage = value;
        }
        public void setAcceptLanguage(final software.amazon.awscdk.Token value) {
            this._acceptLanguage = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.servicecatalog.cloudformation.AcceptedPortfolioShareResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * ``AWS::ServiceCatalog::AcceptedPortfolioShare.PortfolioId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-portfolioid
         */
        public java.lang.Object getPortfolioId() {
            return this.jsiiGet("portfolioId", java.lang.Object.class);
        }
        /**
         * ``AWS::ServiceCatalog::AcceptedPortfolioShare.PortfolioId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-portfolioid
         */
        public void setPortfolioId(final java.lang.String value) {
            this.jsiiSet("portfolioId", java.util.Objects.requireNonNull(value, "portfolioId is required"));
        }
        /**
         * ``AWS::ServiceCatalog::AcceptedPortfolioShare.PortfolioId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-portfolioid
         */
        public void setPortfolioId(final software.amazon.awscdk.Token value) {
            this.jsiiSet("portfolioId", java.util.Objects.requireNonNull(value, "portfolioId is required"));
        }
        /**
         * ``AWS::ServiceCatalog::AcceptedPortfolioShare.AcceptLanguage``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-acceptlanguage
         */
        @javax.annotation.Nullable
        public java.lang.Object getAcceptLanguage() {
            return this.jsiiGet("acceptLanguage", java.lang.Object.class);
        }
        /**
         * ``AWS::ServiceCatalog::AcceptedPortfolioShare.AcceptLanguage``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-acceptlanguage
         */
        public void setAcceptLanguage(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("acceptLanguage", value);
        }
        /**
         * ``AWS::ServiceCatalog::AcceptedPortfolioShare.AcceptLanguage``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-acceptlanguage
         */
        public void setAcceptLanguage(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("acceptLanguage", value);
        }
    }
}
