package software.amazon.awscdk.services.servicecatalog.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.cloudformation.CloudFormationProductResource")
public class CloudFormationProductResource extends software.amazon.awscdk.Resource {
    protected CloudFormationProductResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.servicecatalog.cloudformation.CloudFormationProductResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ServiceCatalog::CloudFormationProduct``.
     * @param parent the ``cdk.Construct`` this ``CloudFormationProductResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``CloudFormationProductResource``
     */
    public CloudFormationProductResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.servicecatalog.cloudformation.CloudFormationProductResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @cloudformation_attribute ProductName
     */
    public software.amazon.awscdk.services.servicecatalog.CloudFormationProductProductName getCloudFormationProductProductName() {
        return this.jsiiGet("cloudFormationProductProductName", software.amazon.awscdk.services.servicecatalog.CloudFormationProductProductName.class);
    }
    /**
     * @cloudformation_attribute ProvisioningArtifactIds
     */
    public software.amazon.awscdk.services.servicecatalog.CloudFormationProductProvisioningArtifactIds getCloudFormationProductProvisioningArtifactIds() {
        return this.jsiiGet("cloudFormationProductProvisioningArtifactIds", software.amazon.awscdk.services.servicecatalog.CloudFormationProductProvisioningArtifactIds.class);
    }
    /**
     * @cloudformation_attribute ProvisioningArtifactNames
     */
    public software.amazon.awscdk.services.servicecatalog.CloudFormationProductProvisioningArtifactNames getCloudFormationProductProvisioningArtifactNames() {
        return this.jsiiGet("cloudFormationProductProvisioningArtifactNames", software.amazon.awscdk.services.servicecatalog.CloudFormationProductProvisioningArtifactNames.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html
     */
    public static interface ProvisioningArtifactPropertiesProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-description
         */
        java.lang.Object getDescription();
        /**
         * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-description
         */
        void setDescription(final java.lang.String value);
        /**
         * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-description
         */
        void setDescription(final software.amazon.awscdk.Token value);
        /**
         * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Info``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-info
         */
        java.lang.Object getInfo();
        /**
         * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Info``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-info
         */
        void setInfo(final com.fasterxml.jackson.databind.node.ObjectNode value);
        /**
         * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Info``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-info
         */
        void setInfo(final software.amazon.awscdk.Token value);
        /**
         * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-name
         */
        java.lang.Object getName();
        /**
         * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-name
         */
        void setName(final java.lang.String value);
        /**
         * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-name
         */
        void setName(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link ProvisioningArtifactPropertiesProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Info``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-info
             */
            public Build withInfo(final com.fasterxml.jackson.databind.node.ObjectNode value) {
                return new FullBuilder().withInfo(value);
            }
            /**
             * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Info``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-info
             */
            public Build withInfo(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withInfo(value);
            }

            public interface Build {
                /**
                 * @return a new {@link ProvisioningArtifactPropertiesProperty} object, initialized with the values set on this builder.
                 */
                ProvisioningArtifactPropertiesProperty build();
                /**
                 * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Description``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-description
                 */
                Build withDescription(final java.lang.String value);
                /**
                 * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Description``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-description
                 */
                Build withDescription(final software.amazon.awscdk.Token value);
                /**
                 * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Name``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-name
                 */
                Build withName(final java.lang.String value);
                /**
                 * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Name``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-name
                 */
                Build withName(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Description``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-description
                 */
                public Build withDescription(final java.lang.String value) {
                    this.instance._description = value;
                    return this;
                }
                /**
                 * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Description``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-description
                 */
                public Build withDescription(final software.amazon.awscdk.Token value) {
                    this.instance._description = value;
                    return this;
                }
                /**
                 * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Info``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-info
                 */
                public Build withInfo(final com.fasterxml.jackson.databind.node.ObjectNode value) {
                    java.util.Objects.requireNonNull(value, "ProvisioningArtifactPropertiesProperty#info is required");
                    this.instance._info = value;
                    return this;
                }
                /**
                 * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Info``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-info
                 */
                public Build withInfo(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "ProvisioningArtifactPropertiesProperty#info is required");
                    this.instance._info = value;
                    return this;
                }
                /**
                 * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Name``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-name
                 */
                public Build withName(final java.lang.String value) {
                    this.instance._name = value;
                    return this;
                }
                /**
                 * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Name``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-name
                 */
                public Build withName(final software.amazon.awscdk.Token value) {
                    this.instance._name = value;
                    return this;
                }
                public ProvisioningArtifactPropertiesProperty build() {
                    ProvisioningArtifactPropertiesProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link ProvisioningArtifactPropertiesProperty}.
         */
        final class Jsii$Pojo implements ProvisioningArtifactPropertiesProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _description;

            public java.lang.Object getDescription() {
                return this._description;
            }
            public void setDescription(final java.lang.String value) {
                this._description = value;
            }
            public void setDescription(final software.amazon.awscdk.Token value) {
                this._description = value;
            }

            protected java.lang.Object _info;

            public java.lang.Object getInfo() {
                return this._info;
            }
            public void setInfo(final com.fasterxml.jackson.databind.node.ObjectNode value) {
                this._info = value;
            }
            public void setInfo(final software.amazon.awscdk.Token value) {
                this._info = value;
            }

            protected java.lang.Object _name;

            public java.lang.Object getName() {
                return this._name;
            }
            public void setName(final java.lang.String value) {
                this._name = value;
            }
            public void setName(final software.amazon.awscdk.Token value) {
                this._name = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.servicecatalog.cloudformation.CloudFormationProductResource.ProvisioningArtifactPropertiesProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-description
             */
            @javax.annotation.Nullable
            public java.lang.Object getDescription() {
                return this.jsiiGet("description", java.lang.Object.class);
            }
            /**
             * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-description
             */
            public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("description", value);
            }
            /**
             * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-description
             */
            public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("description", value);
            }
            /**
             * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Info``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-info
             */
            public java.lang.Object getInfo() {
                return this.jsiiGet("info", java.lang.Object.class);
            }
            /**
             * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Info``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-info
             */
            public void setInfo(final com.fasterxml.jackson.databind.node.ObjectNode value) {
                this.jsiiSet("info", java.util.Objects.requireNonNull(value, "info is required"));
            }
            /**
             * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Info``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-info
             */
            public void setInfo(final software.amazon.awscdk.Token value) {
                this.jsiiSet("info", java.util.Objects.requireNonNull(value, "info is required"));
            }
            /**
             * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-name
             */
            @javax.annotation.Nullable
            public java.lang.Object getName() {
                return this.jsiiGet("name", java.lang.Object.class);
            }
            /**
             * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-name
             */
            public void setName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("name", value);
            }
            /**
             * ``CloudFormationProductResource.ProvisioningArtifactPropertiesProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-name
             */
            public void setName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("name", value);
            }
        }
    }
}
