package software.amazon.awscdk.services.servicecatalog.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.cloudformation.CloudFormationProvisionedProductResource")
public class CloudFormationProvisionedProductResource extends software.amazon.awscdk.Resource {
    protected CloudFormationProvisionedProductResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.servicecatalog.cloudformation.CloudFormationProvisionedProductResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ServiceCatalog::CloudFormationProvisionedProduct``.
     * @param parent the ``cdk.Construct`` this ``CloudFormationProvisionedProductResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``CloudFormationProvisionedProductResource``
     */
    public CloudFormationProvisionedProductResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.servicecatalog.cloudformation.CloudFormationProvisionedProductResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(properties)).toArray());
    }
    /**
     * Creates a new ``AWS::ServiceCatalog::CloudFormationProvisionedProduct``.
     * @param parent the ``cdk.Construct`` this ``CloudFormationProvisionedProductResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     */
    public CloudFormationProvisionedProductResource(final software.amazon.awscdk.Construct parent, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @cloudformation_attribute CloudformationStackArn
     */
    public software.amazon.awscdk.services.servicecatalog.CloudFormationProvisionedProductCloudformationStackArn getCloudFormationProvisionedProductCloudformationStackArn() {
        return this.jsiiGet("cloudFormationProvisionedProductCloudformationStackArn", software.amazon.awscdk.services.servicecatalog.CloudFormationProvisionedProductCloudformationStackArn.class);
    }
    /**
     * @cloudformation_attribute RecordId
     */
    public software.amazon.awscdk.services.servicecatalog.CloudFormationProvisionedProductRecordId getCloudFormationProvisionedProductRecordId() {
        return this.jsiiGet("cloudFormationProvisionedProductRecordId", software.amazon.awscdk.services.servicecatalog.CloudFormationProvisionedProductRecordId.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningparameter.html
     */
    public static interface ProvisioningParameterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CloudFormationProvisionedProductResource.ProvisioningParameterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningparameter.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningparameter-key
         */
        java.lang.Object getKey();
        /**
         * ``CloudFormationProvisionedProductResource.ProvisioningParameterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningparameter.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningparameter-key
         */
        void setKey(final java.lang.String value);
        /**
         * ``CloudFormationProvisionedProductResource.ProvisioningParameterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningparameter.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningparameter-key
         */
        void setKey(final software.amazon.awscdk.Token value);
        /**
         * ``CloudFormationProvisionedProductResource.ProvisioningParameterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningparameter.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningparameter-value
         */
        java.lang.Object getValue();
        /**
         * ``CloudFormationProvisionedProductResource.ProvisioningParameterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningparameter.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningparameter-value
         */
        void setValue(final java.lang.String value);
        /**
         * ``CloudFormationProvisionedProductResource.ProvisioningParameterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningparameter.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningparameter-value
         */
        void setValue(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link ProvisioningParameterProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``CloudFormationProvisionedProductResource.ProvisioningParameterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningparameter.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningparameter-key
             */
            public Builder withKey(final java.lang.String value) {
                this.instance._key = value;
                return this;
            }
            /**
             * ``CloudFormationProvisionedProductResource.ProvisioningParameterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningparameter.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningparameter-key
             */
            public Builder withKey(final software.amazon.awscdk.Token value) {
                this.instance._key = value;
                return this;
            }
            /**
             * ``CloudFormationProvisionedProductResource.ProvisioningParameterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningparameter.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningparameter-value
             */
            public Builder withValue(final java.lang.String value) {
                this.instance._value = value;
                return this;
            }
            /**
             * ``CloudFormationProvisionedProductResource.ProvisioningParameterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningparameter.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningparameter-value
             */
            public Builder withValue(final software.amazon.awscdk.Token value) {
                this.instance._value = value;
                return this;
            }
            public ProvisioningParameterProperty build() {
                ProvisioningParameterProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link ProvisioningParameterProperty}.
         */
        final class Jsii$Pojo implements ProvisioningParameterProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _key;

            public java.lang.Object getKey() {
                return this._key;
            }
            public void setKey(final java.lang.String value) {
                this._key = value;
            }
            public void setKey(final software.amazon.awscdk.Token value) {
                this._key = value;
            }

            protected java.lang.Object _value;

            public java.lang.Object getValue() {
                return this._value;
            }
            public void setValue(final java.lang.String value) {
                this._value = value;
            }
            public void setValue(final software.amazon.awscdk.Token value) {
                this._value = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.servicecatalog.cloudformation.CloudFormationProvisionedProductResource.ProvisioningParameterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``CloudFormationProvisionedProductResource.ProvisioningParameterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningparameter.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningparameter-key
             */
            @javax.annotation.Nullable
            public java.lang.Object getKey() {
                return this.jsiiGet("key", java.lang.Object.class);
            }
            /**
             * ``CloudFormationProvisionedProductResource.ProvisioningParameterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningparameter.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningparameter-key
             */
            public void setKey(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("key", value);
            }
            /**
             * ``CloudFormationProvisionedProductResource.ProvisioningParameterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningparameter.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningparameter-key
             */
            public void setKey(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("key", value);
            }
            /**
             * ``CloudFormationProvisionedProductResource.ProvisioningParameterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningparameter.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningparameter-value
             */
            @javax.annotation.Nullable
            public java.lang.Object getValue() {
                return this.jsiiGet("value", java.lang.Object.class);
            }
            /**
             * ``CloudFormationProvisionedProductResource.ProvisioningParameterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningparameter.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningparameter-value
             */
            public void setValue(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("value", value);
            }
            /**
             * ``CloudFormationProvisionedProductResource.ProvisioningParameterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningparameter.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningparameter-value
             */
            public void setValue(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("value", value);
            }
        }
    }
}
