package software.amazon.awscdk.services.servicecatalog;

/**
 * Properties for defining a `AWS::ServiceCatalog::PortfolioProductAssociation`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioproductassociation.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-09-30T08:30:44.175Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnPortfolioProductAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::ServiceCatalog::PortfolioProductAssociation.PortfolioId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioproductassociation.html#cfn-servicecatalog-portfolioproductassociation-portfolioid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getPortfolioId();

    /**
     * `AWS::ServiceCatalog::PortfolioProductAssociation.ProductId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioproductassociation.html#cfn-servicecatalog-portfolioproductassociation-productid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getProductId();

    /**
     * `AWS::ServiceCatalog::PortfolioProductAssociation.AcceptLanguage`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioproductassociation.html#cfn-servicecatalog-portfolioproductassociation-acceptlanguage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getAcceptLanguage();

    /**
     * `AWS::ServiceCatalog::PortfolioProductAssociation.SourcePortfolioId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioproductassociation.html#cfn-servicecatalog-portfolioproductassociation-sourceportfolioid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getSourcePortfolioId();

    /**
     * @return a {@link Builder} of {@link CfnPortfolioProductAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPortfolioProductAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String portfolioId;
        private java.lang.String productId;
        private java.lang.String acceptLanguage;
        private java.lang.String sourcePortfolioId;

        /**
         * Sets the value of PortfolioId
         * @param portfolioId `AWS::ServiceCatalog::PortfolioProductAssociation.PortfolioId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder portfolioId(java.lang.String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        /**
         * Sets the value of ProductId
         * @param productId `AWS::ServiceCatalog::PortfolioProductAssociation.ProductId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder productId(java.lang.String productId) {
            this.productId = productId;
            return this;
        }

        /**
         * Sets the value of AcceptLanguage
         * @param acceptLanguage `AWS::ServiceCatalog::PortfolioProductAssociation.AcceptLanguage`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder acceptLanguage(java.lang.String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        /**
         * Sets the value of SourcePortfolioId
         * @param sourcePortfolioId `AWS::ServiceCatalog::PortfolioProductAssociation.SourcePortfolioId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sourcePortfolioId(java.lang.String sourcePortfolioId) {
            this.sourcePortfolioId = sourcePortfolioId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPortfolioProductAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnPortfolioProductAssociationProps build() {
            return new Jsii$Proxy(portfolioId, productId, acceptLanguage, sourcePortfolioId);
        }
    }

    /**
     * An implementation for {@link CfnPortfolioProductAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPortfolioProductAssociationProps {
        private final java.lang.String portfolioId;
        private final java.lang.String productId;
        private final java.lang.String acceptLanguage;
        private final java.lang.String sourcePortfolioId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.portfolioId = this.jsiiGet("portfolioId", java.lang.String.class);
            this.productId = this.jsiiGet("productId", java.lang.String.class);
            this.acceptLanguage = this.jsiiGet("acceptLanguage", java.lang.String.class);
            this.sourcePortfolioId = this.jsiiGet("sourcePortfolioId", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String portfolioId, java.lang.String productId, java.lang.String acceptLanguage, java.lang.String sourcePortfolioId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.portfolioId = java.util.Objects.requireNonNull(portfolioId, "portfolioId is required");
            this.productId = java.util.Objects.requireNonNull(productId, "productId is required");
            this.acceptLanguage = acceptLanguage;
            this.sourcePortfolioId = sourcePortfolioId;
        }

        @Override
        public java.lang.String getPortfolioId() {
            return this.portfolioId;
        }

        @Override
        public java.lang.String getProductId() {
            return this.productId;
        }

        @Override
        public java.lang.String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public java.lang.String getSourcePortfolioId() {
            return this.sourcePortfolioId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("portfolioId", om.valueToTree(this.getPortfolioId()));
            obj.set("productId", om.valueToTree(this.getProductId()));
            if (this.getAcceptLanguage() != null) {
                obj.set("acceptLanguage", om.valueToTree(this.getAcceptLanguage()));
            }
            if (this.getSourcePortfolioId() != null) {
                obj.set("sourcePortfolioId", om.valueToTree(this.getSourcePortfolioId()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPortfolioProductAssociationProps.Jsii$Proxy that = (CfnPortfolioProductAssociationProps.Jsii$Proxy) o;

            if (!portfolioId.equals(that.portfolioId)) return false;
            if (!productId.equals(that.productId)) return false;
            if (this.acceptLanguage != null ? !this.acceptLanguage.equals(that.acceptLanguage) : that.acceptLanguage != null) return false;
            return this.sourcePortfolioId != null ? this.sourcePortfolioId.equals(that.sourcePortfolioId) : that.sourcePortfolioId == null;
        }

        @Override
        public int hashCode() {
            int result = this.portfolioId.hashCode();
            result = 31 * result + (this.productId.hashCode());
            result = 31 * result + (this.acceptLanguage != null ? this.acceptLanguage.hashCode() : 0);
            result = 31 * result + (this.sourcePortfolioId != null ? this.sourcePortfolioId.hashCode() : 0);
            return result;
        }
    }
}
