package software.amazon.awscdk.services.servicecatalog;

/**
 * (experimental) Properties for a Cloudformation Product.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-07-09T19:17:58.078Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.CloudFormationProductProps")
@software.amazon.jsii.Jsii.Proxy(CloudFormationProductProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CloudFormationProductProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The owner of the product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getOwner();

    /**
     * (experimental) The name of the product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getProductName();

    /**
     * (experimental) The configuration of the product version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion> getProductVersions();

    /**
     * (experimental) The language code.
     * <p>
     * Default: - No accept language provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.AcceptLanguage getAcceptLanguage() {
        return null;
    }

    /**
     * (experimental) The description of the product.
     * <p>
     * Default: - No description provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * (experimental) The distributor of the product.
     * <p>
     * Default: - No distributor provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDistributor() {
        return null;
    }

    /**
     * (experimental) Whether to give provisioning artifacts a new unique identifier when the product attributes or provisioning artifacts is updated.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReplaceProductVersionIds() {
        return null;
    }

    /**
     * (experimental) The support information about the product.
     * <p>
     * Default: - No support description provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getSupportDescription() {
        return null;
    }

    /**
     * (experimental) The contact email for product support.
     * <p>
     * Default: - No support email provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getSupportEmail() {
        return null;
    }

    /**
     * (experimental) The contact URL for product support.
     * <p>
     * Default: - No support URL provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getSupportUrl() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CloudFormationProductProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CloudFormationProductProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CloudFormationProductProps> {
        private java.lang.String owner;
        private java.lang.String productName;
        private java.util.List<software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion> productVersions;
        private software.amazon.awscdk.services.servicecatalog.AcceptLanguage acceptLanguage;
        private java.lang.String description;
        private java.lang.String distributor;
        private java.lang.Boolean replaceProductVersionIds;
        private java.lang.String supportDescription;
        private java.lang.String supportEmail;
        private java.lang.String supportUrl;

        /**
         * Sets the value of {@link CloudFormationProductProps#getOwner}
         * @param owner The owner of the product. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder owner(java.lang.String owner) {
            this.owner = owner;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationProductProps#getProductName}
         * @param productName The name of the product. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder productName(java.lang.String productName) {
            this.productName = productName;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationProductProps#getProductVersions}
         * @param productVersions The configuration of the product version. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder productVersions(java.util.List<? extends software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion> productVersions) {
            this.productVersions = (java.util.List<software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion>)productVersions;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationProductProps#getAcceptLanguage}
         * @param acceptLanguage The language code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder acceptLanguage(software.amazon.awscdk.services.servicecatalog.AcceptLanguage acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationProductProps#getDescription}
         * @param description The description of the product.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationProductProps#getDistributor}
         * @param distributor The distributor of the product.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder distributor(java.lang.String distributor) {
            this.distributor = distributor;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationProductProps#getReplaceProductVersionIds}
         * @param replaceProductVersionIds Whether to give provisioning artifacts a new unique identifier when the product attributes or provisioning artifacts is updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder replaceProductVersionIds(java.lang.Boolean replaceProductVersionIds) {
            this.replaceProductVersionIds = replaceProductVersionIds;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationProductProps#getSupportDescription}
         * @param supportDescription The support information about the product.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder supportDescription(java.lang.String supportDescription) {
            this.supportDescription = supportDescription;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationProductProps#getSupportEmail}
         * @param supportEmail The contact email for product support.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder supportEmail(java.lang.String supportEmail) {
            this.supportEmail = supportEmail;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationProductProps#getSupportUrl}
         * @param supportUrl The contact URL for product support.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder supportUrl(java.lang.String supportUrl) {
            this.supportUrl = supportUrl;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CloudFormationProductProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CloudFormationProductProps build() {
            return new Jsii$Proxy(owner, productName, productVersions, acceptLanguage, description, distributor, replaceProductVersionIds, supportDescription, supportEmail, supportUrl);
        }
    }

    /**
     * An implementation for {@link CloudFormationProductProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudFormationProductProps {
        private final java.lang.String owner;
        private final java.lang.String productName;
        private final java.util.List<software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion> productVersions;
        private final software.amazon.awscdk.services.servicecatalog.AcceptLanguage acceptLanguage;
        private final java.lang.String description;
        private final java.lang.String distributor;
        private final java.lang.Boolean replaceProductVersionIds;
        private final java.lang.String supportDescription;
        private final java.lang.String supportEmail;
        private final java.lang.String supportUrl;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.owner = software.amazon.jsii.Kernel.get(this, "owner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.productName = software.amazon.jsii.Kernel.get(this, "productName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.productVersions = software.amazon.jsii.Kernel.get(this, "productVersions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion.class)));
            this.acceptLanguage = software.amazon.jsii.Kernel.get(this, "acceptLanguage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalog.AcceptLanguage.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.distributor = software.amazon.jsii.Kernel.get(this, "distributor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.replaceProductVersionIds = software.amazon.jsii.Kernel.get(this, "replaceProductVersionIds", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.supportDescription = software.amazon.jsii.Kernel.get(this, "supportDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.supportEmail = software.amazon.jsii.Kernel.get(this, "supportEmail", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.supportUrl = software.amazon.jsii.Kernel.get(this, "supportUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.lang.String owner, final java.lang.String productName, final java.util.List<? extends software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion> productVersions, final software.amazon.awscdk.services.servicecatalog.AcceptLanguage acceptLanguage, final java.lang.String description, final java.lang.String distributor, final java.lang.Boolean replaceProductVersionIds, final java.lang.String supportDescription, final java.lang.String supportEmail, final java.lang.String supportUrl) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.owner = java.util.Objects.requireNonNull(owner, "owner is required");
            this.productName = java.util.Objects.requireNonNull(productName, "productName is required");
            this.productVersions = (java.util.List<software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion>)java.util.Objects.requireNonNull(productVersions, "productVersions is required");
            this.acceptLanguage = acceptLanguage;
            this.description = description;
            this.distributor = distributor;
            this.replaceProductVersionIds = replaceProductVersionIds;
            this.supportDescription = supportDescription;
            this.supportEmail = supportEmail;
            this.supportUrl = supportUrl;
        }

        @Override
        public final java.lang.String getOwner() {
            return this.owner;
        }

        @Override
        public final java.lang.String getProductName() {
            return this.productName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion> getProductVersions() {
            return this.productVersions;
        }

        @Override
        public final software.amazon.awscdk.services.servicecatalog.AcceptLanguage getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDistributor() {
            return this.distributor;
        }

        @Override
        public final java.lang.Boolean getReplaceProductVersionIds() {
            return this.replaceProductVersionIds;
        }

        @Override
        public final java.lang.String getSupportDescription() {
            return this.supportDescription;
        }

        @Override
        public final java.lang.String getSupportEmail() {
            return this.supportEmail;
        }

        @Override
        public final java.lang.String getSupportUrl() {
            return this.supportUrl;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("owner", om.valueToTree(this.getOwner()));
            data.set("productName", om.valueToTree(this.getProductName()));
            data.set("productVersions", om.valueToTree(this.getProductVersions()));
            if (this.getAcceptLanguage() != null) {
                data.set("acceptLanguage", om.valueToTree(this.getAcceptLanguage()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDistributor() != null) {
                data.set("distributor", om.valueToTree(this.getDistributor()));
            }
            if (this.getReplaceProductVersionIds() != null) {
                data.set("replaceProductVersionIds", om.valueToTree(this.getReplaceProductVersionIds()));
            }
            if (this.getSupportDescription() != null) {
                data.set("supportDescription", om.valueToTree(this.getSupportDescription()));
            }
            if (this.getSupportEmail() != null) {
                data.set("supportEmail", om.valueToTree(this.getSupportEmail()));
            }
            if (this.getSupportUrl() != null) {
                data.set("supportUrl", om.valueToTree(this.getSupportUrl()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicecatalog.CloudFormationProductProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CloudFormationProductProps.Jsii$Proxy that = (CloudFormationProductProps.Jsii$Proxy) o;

            if (!owner.equals(that.owner)) return false;
            if (!productName.equals(that.productName)) return false;
            if (!productVersions.equals(that.productVersions)) return false;
            if (this.acceptLanguage != null ? !this.acceptLanguage.equals(that.acceptLanguage) : that.acceptLanguage != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.distributor != null ? !this.distributor.equals(that.distributor) : that.distributor != null) return false;
            if (this.replaceProductVersionIds != null ? !this.replaceProductVersionIds.equals(that.replaceProductVersionIds) : that.replaceProductVersionIds != null) return false;
            if (this.supportDescription != null ? !this.supportDescription.equals(that.supportDescription) : that.supportDescription != null) return false;
            if (this.supportEmail != null ? !this.supportEmail.equals(that.supportEmail) : that.supportEmail != null) return false;
            return this.supportUrl != null ? this.supportUrl.equals(that.supportUrl) : that.supportUrl == null;
        }

        @Override
        public final int hashCode() {
            int result = this.owner.hashCode();
            result = 31 * result + (this.productName.hashCode());
            result = 31 * result + (this.productVersions.hashCode());
            result = 31 * result + (this.acceptLanguage != null ? this.acceptLanguage.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.distributor != null ? this.distributor.hashCode() : 0);
            result = 31 * result + (this.replaceProductVersionIds != null ? this.replaceProductVersionIds.hashCode() : 0);
            result = 31 * result + (this.supportDescription != null ? this.supportDescription.hashCode() : 0);
            result = 31 * result + (this.supportEmail != null ? this.supportEmail.hashCode() : 0);
            result = 31 * result + (this.supportUrl != null ? this.supportUrl.hashCode() : 0);
            return result;
        }
    }
}
