/**
 * <h1>AWS Service Catalog Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * All classes with the <code>Cfn</code> prefix in this module (<a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib">CFN Resources</a>) are always stable and safe to use.
 * <p>
 * </blockquote>
 * <p>
 * <img alt="cdk-constructs: Experimental" src="https://img.shields.io/badge/cdk--constructs-experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * The APIs of higher level constructs in this module are experimental and under active development.
 * They are subject to non-backward compatible changes or removal in any future version. These are
 * not subject to the <a href="https://semver.org/">Semantic Versioning</a> model and breaking changes will be
 * announced in the release notes. This means that while you may use them, you may need to update
 * your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * <a href="https://docs.aws.amazon.com/servicecatalog/latest/dg/what-is-service-catalog.html">AWS Service Catalog</a>
 * enables organizations to create and manage catalogs of products for their end users that are approved for use on AWS.
 * <p>
 * <h2>Table Of Contents</h2>
 * <p>
 * <ul>
 * <li><a href="#portfolio">Portfolio</a>
 * <p>
 * <ul>
 * <li><a href="#granting-access-to-a-portfolio">Granting access to a portfolio</a></li>
 * <li><a href="#sharing-a-portfolio-with-another-aws-account">Sharing a portfolio with another AWS account</a></li>
 * </ul></li>
 * <li><a href="#product">Product</a>
 * <p>
 * <ul>
 * <li><a href="#adding-a-product-to-a-portfolio">Adding a product to a portfolio</a></li>
 * </ul></li>
 * <li><a href="#tag-options">TagOptions</a></li>
 * <li><a href="#constraints">Constraints</a>
 * <p>
 * <ul>
 * <li><a href="#tag-update-constraint">Tag update constraint</a></li>
 * <li><a href="#notify-on-stack-events">Notify on stack events</a></li>
 * <li><a href="#cloudformation-parameters-constraint">CloudFormation parameters constraint</a></li>
 * <li><a href="#set-launch-role">Set launch role</a></li>
 * <li><a href="#deploy-with-stacksets">Deploy with StackSets</a></li>
 * </ul></li>
 * </ul>
 * <p>
 * The <code>&#64;aws-cdk/aws-servicecatalog</code> package contains resources that enable users to automate governance and management of their AWS resources at scale.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.servicecatalog.*;
 * </pre></blockquote>
 * <p>
 * <h2>Portfolio</h2>
 * <p>
 * AWS Service Catalog portfolios allow admins to manage products that their end users have access to.
 * Using the CDK, a new portfolio can be created with the <code>Portfolio</code> construct:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Portfolio.Builder.create(this, "MyFirstPortfolio")
 *         .displayName("MyFirstPortfolio")
 *         .providerName("MyTeam")
 *         .build();
 * </pre></blockquote>
 * <p>
 * You can also specify properties such as <code>description</code> and <code>acceptLanguage</code>
 * to help better catalog and manage your portfolios.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Portfolio.Builder.create(this, "MyFirstPortfolio")
 *         .displayName("MyFirstPortfolio")
 *         .providerName("MyTeam")
 *         .description("Portfolio for a project")
 *         .messageLanguage(servicecatalog.MessageLanguage.getEN())
 *         .build();
 * </pre></blockquote>
 * <p>
 * Read more at <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/catalogs_portfolios.html">Creating and Managing Portfolios</a>.
 * <p>
 * A portfolio that has been created outside the stack can be imported into your CDK app.
 * Portfolios can be imported by their ARN via the <code>Portfolio.fromPortfolioArn()</code> API:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Object portfolio = servicecatalog.Portfolio.fromPortfolioArn(this, "MyImportedPortfolio", "arn:aws:catalog:region:account-id:portfolio/port-abcdefghi");
 * </pre></blockquote>
 * <p>
 * <h3>Granting access to a portfolio</h3>
 * <p>
 * You can manage end user access to a portfolio by granting permissions to <code>IAM</code> entities like a user, group, or role.
 * Once resources are deployed end users will be able to access them via the console or service catalog CLI.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.iam.*;
 * 
 * 
 * User user = new User(this, "MyUser");
 * portfolio.giveAccessToUser(user);
 * 
 * Role role = new Role(this, "MyRole", new RoleProps()
 *         .assumedBy(new AccountRootPrincipal()));
 * portfolio.giveAccessToRole(role);
 * 
 * Group group = new Group(this, "MyGroup");
 * portfolio.giveAccessToGroup(group);
 * </pre></blockquote>
 * <p>
 * <h3>Sharing a portfolio with another AWS account</h3>
 * <p>
 * A portfolio can be programatically shared with other accounts so that specified users can also access it:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * portfolio.shareWithAccount("012345678901");
 * </pre></blockquote>
 * <p>
 * <h2>Product</h2>
 * <p>
 * Products are the resources you are allowing end users to provision and utilize.
 * The CDK currently only supports adding products of type Cloudformation product.
 * Using the CDK, a new Product can be created with the <code>CloudFormationProduct</code> construct.
 * <code>CloudFormationTemplate.fromUrl</code> can be utilized to create a Product using a Cloudformation template directly from an URL:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Object product = CloudFormationProduct.Builder.create(this, "MyFirstProduct")
 *         .productName("My Product")
 *         .owner("Product Owner")
 *         .productVersions(List.of(Map.of(
 *                 "productVersionName", "v1",
 *                 "cloudFormationTemplate", servicecatalog.CloudFormationTemplate.fromUrl("https://raw.githubusercontent.com/awslabs/aws-cloudformation-templates/master/aws/services/ServiceCatalog/Product.yaml"))))
 *         .build();
 * </pre></blockquote>
 * <p>
 * A <code>CloudFormationProduct</code> can also be created using a Cloudformation template from an Asset.
 * Assets are files that are uploaded to an S3 Bucket before deployment.
 * <code>CloudFormationTemplate.fromAsset</code> can be utilized to create a Product by passing the path to a local template file on your disk:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * import path.*;
 * 
 * 
 * Object product = CloudFormationProduct.Builder.create(this, "MyFirstProduct")
 *         .productName("My Product")
 *         .owner("Product Owner")
 *         .productVersions(List.of(Map.of(
 *                 "productVersionName", "v1",
 *                 "cloudFormationTemplate", servicecatalog.CloudFormationTemplate.fromUrl("https://raw.githubusercontent.com/awslabs/aws-cloudformation-templates/master/aws/services/ServiceCatalog/Product.yaml")), Map.of(
 *                 "productVersionName", "v2",
 *                 "cloudFormationTemplate", servicecatalog.CloudFormationTemplate.fromAsset(path.join(__dirname, "development-environment.template.json")))))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Adding a product to a portfolio</h3>
 * <p>
 * You add products to a portfolio to manage your resources at scale.  After adding a product to a portfolio,
 * it creates a portfolio-product association, and will become visible from the portfolio side in both the console and service catalog CLI.
 * A product can be added to multiple portfolios depending on your resource and organizational needs.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * portfolio.addProduct(product);
 * </pre></blockquote>
 * <p>
 * <h2>Tag Options</h2>
 * <p>
 * TagOptions allow administrators to easily manage tags on provisioned products by creating a selection of tags for end users to choose from.
 * For example, an end user can choose an <code>ec2</code> for the instance type size.
 * TagOptions are created by specifying a key with a selection of values.
 * At the moment, TagOptions can only be disabled in the console.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * TagOptions tagOptions = TagOptions.Builder.create()Map.of(
 *         "ec2InstanceType", List.of("A1", "M4"),
 *         "ec2InstanceSize", List.of("medium", "large"));
 * portfolio.associateTagOptions(tagOptions);
 * </pre></blockquote>
 * <p>
 * <h2>Constraints</h2>
 * <p>
 * Constraints define governance mechanisms that allow you to manage permissions, notifications, and options related to actions end users can perform on products,
 * Constraints are applied on a portfolio-product association.
 * Using the CDK, if you do not explicitly associate a product to a portfolio and add a constraint, it will automatically add an association for you.
 * <p>
 * There are rules around plurariliites of constraints for a portfolio and product.
 * For example, you can only have a single "tag update" constraint applied to a portfolio-product association.
 * If a misconfigured constraint is added, <code>synth</code> will fail with an error message.
 * <p>
 * Read more at <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/constraints.html">Service Catalog Constraints</a>.
 * <p>
 * <h3>Tag update constraint</h3>
 * <p>
 * Tag update constraints allow or disallow end users to update tags on resources associated with an AWS Service Catalog product upon provisioning.
 * By default, tag updating is not permitted.
 * If tag updating is allowed, then new tags associated with the product or portfolio will be applied to provisioned resources during a provisioned product update.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * portfolio.addProduct(product);
 * 
 * portfolio.constrainTagUpdates(product);
 * </pre></blockquote>
 * <p>
 * If you want to disable this feature later on, you can update it by setting the "allow" parameter to <code>false</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * // to disable tag updates:
 * portfolio.constrainTagUpdates(product, new TagUpdateConstraintOptions()
 *         .allow(false));
 * </pre></blockquote>
 * <p>
 * <h3>Notify on stack events</h3>
 * <p>
 * Allows users to subscribe an AWS <code>SNS</code> topic to the stack events of the product.
 * When an end user provisions a product it creates a product stack that notifies the subscribed topic on creation, edit, and delete events.
 * An individual <code>SNS</code> topic may only be subscribed once to a portfolio-product association.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.sns.*;
 * 
 * 
 * Topic topic1 = new Topic(this, "MyTopic1");
 * portfolio.notifyOnStackEvents(product, topic1);
 * 
 * Topic topic2 = new Topic(this, "MyTopic2");
 * portfolio.notifyOnStackEvents(product, topic2, new CommonConstraintOptions()
 *         .description("description for this topic2"));
 * </pre></blockquote>
 * <p>
 * <h3>CloudFormation parameters constraint</h3>
 * <p>
 * CloudFormation parameters constraints allow you to configure the that are available to end users when they launch a product via defined rules.
 * A rule consists of one or more assertions that narrow the allowable values for parameters in a product.
 * You can configure multiple parameter constraints to govern the different parameters and parameter options in your products.
 * For example, a rule might define the various instance types that users can choose from when launching a stack that includes EC2 instances.
 * A parameter rule has an optional <code>condition</code> field that allows ability to configure when rules are applied.
 * If a <code>condition</code> is specified, all the assertions will be applied if the condition evalutates to true.
 * For information on rule-specific intrinsic functions to define rule conditions and assertions,
 * see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-rules.html">AWS Rule Functions</a>.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.core.*;
 * 
 * 
 * portfolio.constrainCloudFormationParameters(product, new CloudFormationRuleConstraintOptions()
 *         .rule(new TemplateRule()
 *                 .ruleName("testInstanceType")
 *                 .condition(cdk.Fn.conditionEquals(cdk.Fn.ref("Environment"), "test"))
 *                 .assertions(List.of(new TemplateRuleAssertion()
 *                         .assert(cdk.Fn.conditionContains(List.of("t2.micro", "t2.small"), cdk.Fn.ref("InstanceType")))
 *                         .description("For test environment, the instance type should be small")))));
 * </pre></blockquote>
 * <p>
 * <h3>Set launch role</h3>
 * <p>
 * Allows you to configure a specific AWS <code>IAM</code> role that a user must assume when launching a product.
 * By setting this launch role, you can control what policies and privileges end users can have.
 * The launch role must be assumed by the service catalog principal.
 * You can only have one launch role set for a portfolio-product association, and you cannot set a launch role if a StackSets deployment has been configured.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.iam.*;
 * 
 * 
 * Role launchRole = new Role(this, "LaunchRole", new RoleProps()
 *         .assumedBy(new ServicePrincipal("servicecatalog.amazonaws.com")));
 * 
 * portfolio.setLaunchRole(product, launchRole);
 * </pre></blockquote>
 * <p>
 * See <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/constraints-launch.html">Launch Constraint</a> documentation
 * to understand permissions roles need.
 * <p>
 * <h3>Deploy with StackSets</h3>
 * <p>
 * A StackSets deployment constraint allows you to configure product deployment options using
 * <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/using-stacksets.html">AWS CloudFormation StackSets</a>.
 * You can specify multiple accounts and regions for the product launch following StackSets conventions.
 * There is an additional field <code>allowStackSetInstanceOperations</code> that configures ability for end users to create, edit, or delete the stacks.
 * By default, this field is set to <code>false</code>.
 * End users can manage those accounts and determine where products deploy and the order of deployment.
 * You can only define one StackSets deployment configuration per portfolio-product association,
 * and you cannot both set a launch role and StackSets deployment configuration for an assocation.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.iam.*;
 * 
 * 
 * Role adminRole = new Role(this, "AdminRole", new RoleProps()
 *         .assumedBy(new AccountRootPrincipal()));
 * 
 * portfolio.deployWithStackSets(product, new StackSetsConstraintOptions()
 *         .accounts(List.of("012345678901", "012345678902", "012345678903"))
 *         .regions(List.of("us-west-1", "us-east-1", "us-west-2", "us-east-1"))
 *         .adminRole(adminRole)
 *         .executionRoleName("SCStackSetExecutionRole")// Name of role deployed in end users accounts.
 *         .allowStackSetInstanceOperations(true));
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.servicecatalog;
