package software.amazon.awscdk.services.servicecatalog;

/**
 * Properties for defining a `AWS::ServiceCatalog::ResourceUpdateConstraint`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.servicecatalog.*;
 * CfnResourceUpdateConstraintProps cfnResourceUpdateConstraintProps = CfnResourceUpdateConstraintProps.builder()
 *         .portfolioId("portfolioId")
 *         .productId("productId")
 *         .tagUpdateOnProvisionedProduct("tagUpdateOnProvisionedProduct")
 *         // the properties below are optional
 *         .acceptLanguage("acceptLanguage")
 *         .description("description")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-15T10:03:45.280Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.CfnResourceUpdateConstraintProps")
@software.amazon.jsii.Jsii.Proxy(CfnResourceUpdateConstraintProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnResourceUpdateConstraintProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::ServiceCatalog::ResourceUpdateConstraint.AcceptLanguage`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAcceptLanguage() {
        return null;
    }

    /**
     * `AWS::ServiceCatalog::ResourceUpdateConstraint.Description`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * `AWS::ServiceCatalog::ResourceUpdateConstraint.PortfolioId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPortfolioId();

    /**
     * `AWS::ServiceCatalog::ResourceUpdateConstraint.ProductId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProductId();

    /**
     * `AWS::ServiceCatalog::ResourceUpdateConstraint.TagUpdateOnProvisionedProduct`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTagUpdateOnProvisionedProduct();

    /**
     * @return a {@link Builder} of {@link CfnResourceUpdateConstraintProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResourceUpdateConstraintProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnResourceUpdateConstraintProps> {
        java.lang.String acceptLanguage;
        java.lang.String description;
        java.lang.String portfolioId;
        java.lang.String productId;
        java.lang.String tagUpdateOnProvisionedProduct;

        /**
         * Sets the value of {@link CfnResourceUpdateConstraintProps#getAcceptLanguage}
         * @param acceptLanguage `AWS::ServiceCatalog::ResourceUpdateConstraint.AcceptLanguage`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceptLanguage(java.lang.String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceUpdateConstraintProps#getDescription}
         * @param description `AWS::ServiceCatalog::ResourceUpdateConstraint.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceUpdateConstraintProps#getPortfolioId}
         * @param portfolioId `AWS::ServiceCatalog::ResourceUpdateConstraint.PortfolioId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portfolioId(java.lang.String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceUpdateConstraintProps#getProductId}
         * @param productId `AWS::ServiceCatalog::ResourceUpdateConstraint.ProductId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productId(java.lang.String productId) {
            this.productId = productId;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceUpdateConstraintProps#getTagUpdateOnProvisionedProduct}
         * @param tagUpdateOnProvisionedProduct `AWS::ServiceCatalog::ResourceUpdateConstraint.TagUpdateOnProvisionedProduct`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagUpdateOnProvisionedProduct(java.lang.String tagUpdateOnProvisionedProduct) {
            this.tagUpdateOnProvisionedProduct = tagUpdateOnProvisionedProduct;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResourceUpdateConstraintProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnResourceUpdateConstraintProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnResourceUpdateConstraintProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResourceUpdateConstraintProps {
        private final java.lang.String acceptLanguage;
        private final java.lang.String description;
        private final java.lang.String portfolioId;
        private final java.lang.String productId;
        private final java.lang.String tagUpdateOnProvisionedProduct;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.acceptLanguage = software.amazon.jsii.Kernel.get(this, "acceptLanguage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.portfolioId = software.amazon.jsii.Kernel.get(this, "portfolioId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.productId = software.amazon.jsii.Kernel.get(this, "productId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tagUpdateOnProvisionedProduct = software.amazon.jsii.Kernel.get(this, "tagUpdateOnProvisionedProduct", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.acceptLanguage = builder.acceptLanguage;
            this.description = builder.description;
            this.portfolioId = java.util.Objects.requireNonNull(builder.portfolioId, "portfolioId is required");
            this.productId = java.util.Objects.requireNonNull(builder.productId, "productId is required");
            this.tagUpdateOnProvisionedProduct = java.util.Objects.requireNonNull(builder.tagUpdateOnProvisionedProduct, "tagUpdateOnProvisionedProduct is required");
        }

        @Override
        public final java.lang.String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getPortfolioId() {
            return this.portfolioId;
        }

        @Override
        public final java.lang.String getProductId() {
            return this.productId;
        }

        @Override
        public final java.lang.String getTagUpdateOnProvisionedProduct() {
            return this.tagUpdateOnProvisionedProduct;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAcceptLanguage() != null) {
                data.set("acceptLanguage", om.valueToTree(this.getAcceptLanguage()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            data.set("portfolioId", om.valueToTree(this.getPortfolioId()));
            data.set("productId", om.valueToTree(this.getProductId()));
            data.set("tagUpdateOnProvisionedProduct", om.valueToTree(this.getTagUpdateOnProvisionedProduct()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicecatalog.CfnResourceUpdateConstraintProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResourceUpdateConstraintProps.Jsii$Proxy that = (CfnResourceUpdateConstraintProps.Jsii$Proxy) o;

            if (this.acceptLanguage != null ? !this.acceptLanguage.equals(that.acceptLanguage) : that.acceptLanguage != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (!portfolioId.equals(that.portfolioId)) return false;
            if (!productId.equals(that.productId)) return false;
            return this.tagUpdateOnProvisionedProduct.equals(that.tagUpdateOnProvisionedProduct);
        }

        @Override
        public final int hashCode() {
            int result = this.acceptLanguage != null ? this.acceptLanguage.hashCode() : 0;
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.portfolioId.hashCode());
            result = 31 * result + (this.productId.hashCode());
            result = 31 * result + (this.tagUpdateOnProvisionedProduct.hashCode());
            return result;
        }
    }
}
