package software.amazon.awscdk.services.servicecatalog;

/**
 * Properties for defining a `AWS::ServiceCatalog::StackSetConstraint`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.servicecatalog.*;
 * CfnStackSetConstraintProps cfnStackSetConstraintProps = CfnStackSetConstraintProps.builder()
 *         .accountList(List.of("accountList"))
 *         .adminRole("adminRole")
 *         .description("description")
 *         .executionRole("executionRole")
 *         .portfolioId("portfolioId")
 *         .productId("productId")
 *         .regionList(List.of("regionList"))
 *         .stackInstanceControl("stackInstanceControl")
 *         // the properties below are optional
 *         .acceptLanguage("acceptLanguage")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-15T10:03:45.282Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.CfnStackSetConstraintProps")
@software.amazon.jsii.Jsii.Proxy(CfnStackSetConstraintProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStackSetConstraintProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::ServiceCatalog::StackSetConstraint.AcceptLanguage`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAcceptLanguage() {
        return null;
    }

    /**
     * `AWS::ServiceCatalog::StackSetConstraint.AccountList`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAccountList();

    /**
     * `AWS::ServiceCatalog::StackSetConstraint.AdminRole`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAdminRole();

    /**
     * `AWS::ServiceCatalog::StackSetConstraint.Description`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDescription();

    /**
     * `AWS::ServiceCatalog::StackSetConstraint.ExecutionRole`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExecutionRole();

    /**
     * `AWS::ServiceCatalog::StackSetConstraint.PortfolioId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPortfolioId();

    /**
     * `AWS::ServiceCatalog::StackSetConstraint.ProductId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProductId();

    /**
     * `AWS::ServiceCatalog::StackSetConstraint.RegionList`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getRegionList();

    /**
     * `AWS::ServiceCatalog::StackSetConstraint.StackInstanceControl`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStackInstanceControl();

    /**
     * @return a {@link Builder} of {@link CfnStackSetConstraintProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStackSetConstraintProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStackSetConstraintProps> {
        java.lang.String acceptLanguage;
        java.util.List<java.lang.String> accountList;
        java.lang.String adminRole;
        java.lang.String description;
        java.lang.String executionRole;
        java.lang.String portfolioId;
        java.lang.String productId;
        java.util.List<java.lang.String> regionList;
        java.lang.String stackInstanceControl;

        /**
         * Sets the value of {@link CfnStackSetConstraintProps#getAcceptLanguage}
         * @param acceptLanguage `AWS::ServiceCatalog::StackSetConstraint.AcceptLanguage`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceptLanguage(java.lang.String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetConstraintProps#getAccountList}
         * @param accountList `AWS::ServiceCatalog::StackSetConstraint.AccountList`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountList(java.util.List<java.lang.String> accountList) {
            this.accountList = accountList;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetConstraintProps#getAdminRole}
         * @param adminRole `AWS::ServiceCatalog::StackSetConstraint.AdminRole`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminRole(java.lang.String adminRole) {
            this.adminRole = adminRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetConstraintProps#getDescription}
         * @param description `AWS::ServiceCatalog::StackSetConstraint.Description`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetConstraintProps#getExecutionRole}
         * @param executionRole `AWS::ServiceCatalog::StackSetConstraint.ExecutionRole`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(java.lang.String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetConstraintProps#getPortfolioId}
         * @param portfolioId `AWS::ServiceCatalog::StackSetConstraint.PortfolioId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portfolioId(java.lang.String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetConstraintProps#getProductId}
         * @param productId `AWS::ServiceCatalog::StackSetConstraint.ProductId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productId(java.lang.String productId) {
            this.productId = productId;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetConstraintProps#getRegionList}
         * @param regionList `AWS::ServiceCatalog::StackSetConstraint.RegionList`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regionList(java.util.List<java.lang.String> regionList) {
            this.regionList = regionList;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetConstraintProps#getStackInstanceControl}
         * @param stackInstanceControl `AWS::ServiceCatalog::StackSetConstraint.StackInstanceControl`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackInstanceControl(java.lang.String stackInstanceControl) {
            this.stackInstanceControl = stackInstanceControl;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStackSetConstraintProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStackSetConstraintProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStackSetConstraintProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStackSetConstraintProps {
        private final java.lang.String acceptLanguage;
        private final java.util.List<java.lang.String> accountList;
        private final java.lang.String adminRole;
        private final java.lang.String description;
        private final java.lang.String executionRole;
        private final java.lang.String portfolioId;
        private final java.lang.String productId;
        private final java.util.List<java.lang.String> regionList;
        private final java.lang.String stackInstanceControl;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.acceptLanguage = software.amazon.jsii.Kernel.get(this, "acceptLanguage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accountList = software.amazon.jsii.Kernel.get(this, "accountList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.adminRole = software.amazon.jsii.Kernel.get(this, "adminRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.portfolioId = software.amazon.jsii.Kernel.get(this, "portfolioId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.productId = software.amazon.jsii.Kernel.get(this, "productId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.regionList = software.amazon.jsii.Kernel.get(this, "regionList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.stackInstanceControl = software.amazon.jsii.Kernel.get(this, "stackInstanceControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.acceptLanguage = builder.acceptLanguage;
            this.accountList = java.util.Objects.requireNonNull(builder.accountList, "accountList is required");
            this.adminRole = java.util.Objects.requireNonNull(builder.adminRole, "adminRole is required");
            this.description = java.util.Objects.requireNonNull(builder.description, "description is required");
            this.executionRole = java.util.Objects.requireNonNull(builder.executionRole, "executionRole is required");
            this.portfolioId = java.util.Objects.requireNonNull(builder.portfolioId, "portfolioId is required");
            this.productId = java.util.Objects.requireNonNull(builder.productId, "productId is required");
            this.regionList = java.util.Objects.requireNonNull(builder.regionList, "regionList is required");
            this.stackInstanceControl = java.util.Objects.requireNonNull(builder.stackInstanceControl, "stackInstanceControl is required");
        }

        @Override
        public final java.lang.String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final java.util.List<java.lang.String> getAccountList() {
            return this.accountList;
        }

        @Override
        public final java.lang.String getAdminRole() {
            return this.adminRole;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getExecutionRole() {
            return this.executionRole;
        }

        @Override
        public final java.lang.String getPortfolioId() {
            return this.portfolioId;
        }

        @Override
        public final java.lang.String getProductId() {
            return this.productId;
        }

        @Override
        public final java.util.List<java.lang.String> getRegionList() {
            return this.regionList;
        }

        @Override
        public final java.lang.String getStackInstanceControl() {
            return this.stackInstanceControl;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAcceptLanguage() != null) {
                data.set("acceptLanguage", om.valueToTree(this.getAcceptLanguage()));
            }
            data.set("accountList", om.valueToTree(this.getAccountList()));
            data.set("adminRole", om.valueToTree(this.getAdminRole()));
            data.set("description", om.valueToTree(this.getDescription()));
            data.set("executionRole", om.valueToTree(this.getExecutionRole()));
            data.set("portfolioId", om.valueToTree(this.getPortfolioId()));
            data.set("productId", om.valueToTree(this.getProductId()));
            data.set("regionList", om.valueToTree(this.getRegionList()));
            data.set("stackInstanceControl", om.valueToTree(this.getStackInstanceControl()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicecatalog.CfnStackSetConstraintProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStackSetConstraintProps.Jsii$Proxy that = (CfnStackSetConstraintProps.Jsii$Proxy) o;

            if (this.acceptLanguage != null ? !this.acceptLanguage.equals(that.acceptLanguage) : that.acceptLanguage != null) return false;
            if (!accountList.equals(that.accountList)) return false;
            if (!adminRole.equals(that.adminRole)) return false;
            if (!description.equals(that.description)) return false;
            if (!executionRole.equals(that.executionRole)) return false;
            if (!portfolioId.equals(that.portfolioId)) return false;
            if (!productId.equals(that.productId)) return false;
            if (!regionList.equals(that.regionList)) return false;
            return this.stackInstanceControl.equals(that.stackInstanceControl);
        }

        @Override
        public final int hashCode() {
            int result = this.acceptLanguage != null ? this.acceptLanguage.hashCode() : 0;
            result = 31 * result + (this.accountList.hashCode());
            result = 31 * result + (this.adminRole.hashCode());
            result = 31 * result + (this.description.hashCode());
            result = 31 * result + (this.executionRole.hashCode());
            result = 31 * result + (this.portfolioId.hashCode());
            result = 31 * result + (this.productId.hashCode());
            result = 31 * result + (this.regionList.hashCode());
            result = 31 * result + (this.stackInstanceControl.hashCode());
            return result;
        }
    }
}
