package software.amazon.awscdk.services.servicecatalog;

/**
 * (experimental) A Service Catalog Cloudformation Product.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import path.*;
 * CloudFormationProduct product = CloudFormationProduct.Builder.create(this, "Product")
 *         .productName("My Product")
 *         .owner("Product Owner")
 *         .productVersions(List.of(CloudFormationProductVersion.builder()
 *                 .productVersionName("v1")
 *                 .cloudFormationTemplate(CloudFormationTemplate.fromUrl("https://raw.githubusercontent.com/awslabs/aws-cloudformation-templates/master/aws/services/ServiceCatalog/Product.yaml"))
 *                 .build(), CloudFormationProductVersion.builder()
 *                 .productVersionName("v2")
 *                 .cloudFormationTemplate(CloudFormationTemplate.fromAsset(join(__dirname, "development-environment.template.json")))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-10T02:24:10.199Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.CloudFormationProduct")
public class CloudFormationProduct extends software.amazon.awscdk.services.servicecatalog.Product {

    protected CloudFormationProduct(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudFormationProduct(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public CloudFormationProduct(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.CloudFormationProductProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) The ARN of the product.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getProductArn() {
        return software.amazon.jsii.Kernel.get(this, "productArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The id of the product.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getProductId() {
        return software.amazon.jsii.Kernel.get(this, "productId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.servicecatalog.CloudFormationProduct}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.servicecatalog.CloudFormationProduct> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.servicecatalog.CloudFormationProductProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.servicecatalog.CloudFormationProductProps.Builder();
        }

        /**
         * (experimental) The owner of the product.
         * <p>
         * @return {@code this}
         * @param owner The owner of the product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder owner(final java.lang.String owner) {
            this.props.owner(owner);
            return this;
        }

        /**
         * (experimental) The name of the product.
         * <p>
         * @return {@code this}
         * @param productName The name of the product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder productName(final java.lang.String productName) {
            this.props.productName(productName);
            return this;
        }

        /**
         * (experimental) The configuration of the product version.
         * <p>
         * @return {@code this}
         * @param productVersions The configuration of the product version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder productVersions(final java.util.List<? extends software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion> productVersions) {
            this.props.productVersions(productVersions);
            return this;
        }

        /**
         * (experimental) The description of the product.
         * <p>
         * Default: - No description provided
         * <p>
         * @return {@code this}
         * @param description The description of the product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * (experimental) The distributor of the product.
         * <p>
         * Default: - No distributor provided
         * <p>
         * @return {@code this}
         * @param distributor The distributor of the product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder distributor(final java.lang.String distributor) {
            this.props.distributor(distributor);
            return this;
        }

        /**
         * (experimental) The language code.
         * <p>
         * Controls language for logging and errors.
         * <p>
         * Default: - English
         * <p>
         * @return {@code this}
         * @param messageLanguage The language code. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder messageLanguage(final software.amazon.awscdk.services.servicecatalog.MessageLanguage messageLanguage) {
            this.props.messageLanguage(messageLanguage);
            return this;
        }

        /**
         * (experimental) Whether to give provisioning artifacts a new unique identifier when the product attributes or provisioning artifacts is updated.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param replaceProductVersionIds Whether to give provisioning artifacts a new unique identifier when the product attributes or provisioning artifacts is updated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder replaceProductVersionIds(final java.lang.Boolean replaceProductVersionIds) {
            this.props.replaceProductVersionIds(replaceProductVersionIds);
            return this;
        }

        /**
         * (experimental) The support information about the product.
         * <p>
         * Default: - No support description provided
         * <p>
         * @return {@code this}
         * @param supportDescription The support information about the product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder supportDescription(final java.lang.String supportDescription) {
            this.props.supportDescription(supportDescription);
            return this;
        }

        /**
         * (experimental) The contact email for product support.
         * <p>
         * Default: - No support email provided
         * <p>
         * @return {@code this}
         * @param supportEmail The contact email for product support. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder supportEmail(final java.lang.String supportEmail) {
            this.props.supportEmail(supportEmail);
            return this;
        }

        /**
         * (experimental) The contact URL for product support.
         * <p>
         * Default: - No support URL provided
         * <p>
         * @return {@code this}
         * @param supportUrl The contact URL for product support. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder supportUrl(final java.lang.String supportUrl) {
            this.props.supportUrl(supportUrl);
            return this;
        }

        /**
         * (experimental) TagOptions associated directly to a product.
         * <p>
         * Default: - No tagOptions provided
         * <p>
         * @return {@code this}
         * @param tagOptions TagOptions associated directly to a product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tagOptions(final software.amazon.awscdk.services.servicecatalog.TagOptions tagOptions) {
            this.props.tagOptions(tagOptions);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.servicecatalog.CloudFormationProduct}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.servicecatalog.CloudFormationProduct build() {
            return new software.amazon.awscdk.services.servicecatalog.CloudFormationProduct(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
