package software.amazon.awscdk.services.servicecatalog;

/**
 * (experimental) Properties for a Portfolio.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Portfolio.Builder.create(this, "Portfolio")
 *         .displayName("MyPortfolio")
 *         .providerName("MyTeam")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:14:07.376Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.PortfolioProps")
@software.amazon.jsii.Jsii.Proxy(PortfolioProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface PortfolioProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The name of the portfolio.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getDisplayName();

    /**
     * (experimental) The provider name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getProviderName();

    /**
     * (experimental) Description for portfolio.
     * <p>
     * Default: - No description provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * (experimental) The message language.
     * <p>
     * Controls language for
     * status logging and errors.
     * <p>
     * Default: - English
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.MessageLanguage getMessageLanguage() {
        return null;
    }

    /**
     * (experimental) TagOptions associated directly to a portfolio.
     * <p>
     * Default: - No tagOptions provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.TagOptions getTagOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PortfolioProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PortfolioProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<PortfolioProps> {
        java.lang.String displayName;
        java.lang.String providerName;
        java.lang.String description;
        software.amazon.awscdk.services.servicecatalog.MessageLanguage messageLanguage;
        software.amazon.awscdk.services.servicecatalog.TagOptions tagOptions;

        /**
         * Sets the value of {@link PortfolioProps#getDisplayName}
         * @param displayName The name of the portfolio. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link PortfolioProps#getProviderName}
         * @param providerName The provider name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder providerName(java.lang.String providerName) {
            this.providerName = providerName;
            return this;
        }

        /**
         * Sets the value of {@link PortfolioProps#getDescription}
         * @param description Description for portfolio.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link PortfolioProps#getMessageLanguage}
         * @param messageLanguage The message language.
         *                        Controls language for
         *                        status logging and errors.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder messageLanguage(software.amazon.awscdk.services.servicecatalog.MessageLanguage messageLanguage) {
            this.messageLanguage = messageLanguage;
            return this;
        }

        /**
         * Sets the value of {@link PortfolioProps#getTagOptions}
         * @param tagOptions TagOptions associated directly to a portfolio.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tagOptions(software.amazon.awscdk.services.servicecatalog.TagOptions tagOptions) {
            this.tagOptions = tagOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PortfolioProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public PortfolioProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PortfolioProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PortfolioProps {
        private final java.lang.String displayName;
        private final java.lang.String providerName;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.servicecatalog.MessageLanguage messageLanguage;
        private final software.amazon.awscdk.services.servicecatalog.TagOptions tagOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.providerName = software.amazon.jsii.Kernel.get(this, "providerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.messageLanguage = software.amazon.jsii.Kernel.get(this, "messageLanguage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalog.MessageLanguage.class));
            this.tagOptions = software.amazon.jsii.Kernel.get(this, "tagOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalog.TagOptions.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.displayName = java.util.Objects.requireNonNull(builder.displayName, "displayName is required");
            this.providerName = java.util.Objects.requireNonNull(builder.providerName, "providerName is required");
            this.description = builder.description;
            this.messageLanguage = builder.messageLanguage;
            this.tagOptions = builder.tagOptions;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.String getProviderName() {
            return this.providerName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.servicecatalog.MessageLanguage getMessageLanguage() {
            return this.messageLanguage;
        }

        @Override
        public final software.amazon.awscdk.services.servicecatalog.TagOptions getTagOptions() {
            return this.tagOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("displayName", om.valueToTree(this.getDisplayName()));
            data.set("providerName", om.valueToTree(this.getProviderName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getMessageLanguage() != null) {
                data.set("messageLanguage", om.valueToTree(this.getMessageLanguage()));
            }
            if (this.getTagOptions() != null) {
                data.set("tagOptions", om.valueToTree(this.getTagOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicecatalog.PortfolioProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PortfolioProps.Jsii$Proxy that = (PortfolioProps.Jsii$Proxy) o;

            if (!displayName.equals(that.displayName)) return false;
            if (!providerName.equals(that.providerName)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.messageLanguage != null ? !this.messageLanguage.equals(that.messageLanguage) : that.messageLanguage != null) return false;
            return this.tagOptions != null ? this.tagOptions.equals(that.tagOptions) : that.tagOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.displayName.hashCode();
            result = 31 * result + (this.providerName.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.messageLanguage != null ? this.messageLanguage.hashCode() : 0);
            result = 31 * result + (this.tagOptions != null ? this.tagOptions.hashCode() : 0);
            return result;
        }
    }
}
