package software.amazon.awscdk.services.servicecatalog;

/**
 * Properties for defining a `CfnAcceptedPortfolioShare`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.servicecatalog.*;
 * CfnAcceptedPortfolioShareProps cfnAcceptedPortfolioShareProps = CfnAcceptedPortfolioShareProps.builder()
 *         .portfolioId("portfolioId")
 *         // the properties below are optional
 *         .acceptLanguage("acceptLanguage")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-05-27T16:28:00.246Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.CfnAcceptedPortfolioShareProps")
@software.amazon.jsii.Jsii.Proxy(CfnAcceptedPortfolioShareProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAcceptedPortfolioShareProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The portfolio identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPortfolioId();

    /**
     * The language code.
     * <p>
     * <ul>
     * <li><code>en</code> - English (default)</li>
     * <li><code>jp</code> - Japanese</li>
     * <li><code>zh</code> - Chinese</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAcceptLanguage() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAcceptedPortfolioShareProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAcceptedPortfolioShareProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAcceptedPortfolioShareProps> {
        java.lang.String portfolioId;
        java.lang.String acceptLanguage;

        /**
         * Sets the value of {@link CfnAcceptedPortfolioShareProps#getPortfolioId}
         * @param portfolioId The portfolio identifier. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portfolioId(java.lang.String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAcceptedPortfolioShareProps#getAcceptLanguage}
         * @param acceptLanguage The language code.
         *                       <ul>
         *                       <li><code>en</code> - English (default)</li>
         *                       <li><code>jp</code> - Japanese</li>
         *                       <li><code>zh</code> - Chinese</li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceptLanguage(java.lang.String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAcceptedPortfolioShareProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAcceptedPortfolioShareProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAcceptedPortfolioShareProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAcceptedPortfolioShareProps {
        private final java.lang.String portfolioId;
        private final java.lang.String acceptLanguage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.portfolioId = software.amazon.jsii.Kernel.get(this, "portfolioId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.acceptLanguage = software.amazon.jsii.Kernel.get(this, "acceptLanguage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.portfolioId = java.util.Objects.requireNonNull(builder.portfolioId, "portfolioId is required");
            this.acceptLanguage = builder.acceptLanguage;
        }

        @Override
        public final java.lang.String getPortfolioId() {
            return this.portfolioId;
        }

        @Override
        public final java.lang.String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("portfolioId", om.valueToTree(this.getPortfolioId()));
            if (this.getAcceptLanguage() != null) {
                data.set("acceptLanguage", om.valueToTree(this.getAcceptLanguage()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicecatalog.CfnAcceptedPortfolioShareProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAcceptedPortfolioShareProps.Jsii$Proxy that = (CfnAcceptedPortfolioShareProps.Jsii$Proxy) o;

            if (!portfolioId.equals(that.portfolioId)) return false;
            return this.acceptLanguage != null ? this.acceptLanguage.equals(that.acceptLanguage) : that.acceptLanguage == null;
        }

        @Override
        public final int hashCode() {
            int result = this.portfolioId.hashCode();
            result = 31 * result + (this.acceptLanguage != null ? this.acceptLanguage.hashCode() : 0);
            return result;
        }
    }
}
