package software.amazon.awscdk.services.servicecatalog;

/**
 * Properties for defining a `CfnCloudFormationProvisionedProduct`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.servicecatalog.*;
 * CfnCloudFormationProvisionedProductProps cfnCloudFormationProvisionedProductProps = CfnCloudFormationProvisionedProductProps.builder()
 *         .acceptLanguage("acceptLanguage")
 *         .notificationArns(List.of("notificationArns"))
 *         .pathId("pathId")
 *         .pathName("pathName")
 *         .productId("productId")
 *         .productName("productName")
 *         .provisionedProductName("provisionedProductName")
 *         .provisioningArtifactId("provisioningArtifactId")
 *         .provisioningArtifactName("provisioningArtifactName")
 *         .provisioningParameters(List.of(ProvisioningParameterProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .provisioningPreferences(ProvisioningPreferencesProperty.builder()
 *                 .stackSetAccounts(List.of("stackSetAccounts"))
 *                 .stackSetFailureToleranceCount(123)
 *                 .stackSetFailureTolerancePercentage(123)
 *                 .stackSetMaxConcurrencyCount(123)
 *                 .stackSetMaxConcurrencyPercentage(123)
 *                 .stackSetOperationType("stackSetOperationType")
 *                 .stackSetRegions(List.of("stackSetRegions"))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.62.0 (build 293ac17)", date = "2022-07-29T14:47:25.546Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.CfnCloudFormationProvisionedProductProps")
@software.amazon.jsii.Jsii.Proxy(CfnCloudFormationProvisionedProductProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCloudFormationProvisionedProductProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The language code.
     * <p>
     * <ul>
     * <li><code>en</code> - English (default)</li>
     * <li><code>jp</code> - Japanese</li>
     * <li><code>zh</code> - Chinese</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAcceptLanguage() {
        return null;
    }

    /**
     * Passed to AWS CloudFormation .
     * <p>
     * The SNS topic ARNs to which to publish stack-related events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotificationArns() {
        return null;
    }

    /**
     * The path identifier of the product.
     * <p>
     * This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <a href="https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListLaunchPaths.html">ListLaunchPaths</a> .
     * <p>
     * <blockquote>
     * <p>
     * You must provide the name or ID, but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPathId() {
        return null;
    }

    /**
     * The name of the path.
     * <p>
     * This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <a href="https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListLaunchPaths.html">ListLaunchPaths</a> .
     * <p>
     * <blockquote>
     * <p>
     * You must provide the name or ID, but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPathName() {
        return null;
    }

    /**
     * The product identifier.
     * <p>
     * <blockquote>
     * <p>
     * You must specify either the ID or the name of the product, but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProductId() {
        return null;
    }

    /**
     * A user-friendly name for the provisioned product.
     * <p>
     * This value must be unique for the AWS account and cannot be updated after the product is provisioned.
     * <p>
     * Each time a stack is created or updated, if <code>ProductName</code> is provided it will successfully resolve to <code>ProductId</code> as long as only one product exists in the account or Region with that <code>ProductName</code> .
     * <p>
     * <blockquote>
     * <p>
     * You must specify either the name or the ID of the product, but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProductName() {
        return null;
    }

    /**
     * A user-friendly name for the provisioned product.
     * <p>
     * This value must be unique for the AWS account and cannot be updated after the product is provisioned.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProvisionedProductName() {
        return null;
    }

    /**
     * The identifier of the provisioning artifact (also known as a version).
     * <p>
     * <blockquote>
     * <p>
     * You must specify either the ID or the name of the provisioning artifact, but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProvisioningArtifactId() {
        return null;
    }

    /**
     * The name of the provisioning artifact (also known as a version) for the product.
     * <p>
     * This name must be unique for the product.
     * <p>
     * <blockquote>
     * <p>
     * You must specify either the name or the ID of the provisioning artifact, but not both. You must also specify either the name or the ID of the product, but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProvisioningArtifactName() {
        return null;
    }

    /**
     * Parameters specified by the administrator that are required for provisioning the product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProvisioningParameters() {
        return null;
    }

    /**
     * StackSet preferences that are required for provisioning the product or updating a provisioned product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProvisioningPreferences() {
        return null;
    }

    /**
     * One or more tags.
     * <p>
     * <blockquote>
     * <p>
     * Requires the provisioned product to have an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-resourceupdateconstraint.html">ResourceUpdateConstraint</a> resource with <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates. If <code>RESOURCE_UPDATE</code> constraint is not present, tags updates are ignored.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCloudFormationProvisionedProductProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCloudFormationProvisionedProductProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCloudFormationProvisionedProductProps> {
        java.lang.String acceptLanguage;
        java.util.List<java.lang.String> notificationArns;
        java.lang.String pathId;
        java.lang.String pathName;
        java.lang.String productId;
        java.lang.String productName;
        java.lang.String provisionedProductName;
        java.lang.String provisioningArtifactId;
        java.lang.String provisioningArtifactName;
        java.lang.Object provisioningParameters;
        java.lang.Object provisioningPreferences;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnCloudFormationProvisionedProductProps#getAcceptLanguage}
         * @param acceptLanguage The language code.
         *                       <ul>
         *                       <li><code>en</code> - English (default)</li>
         *                       <li><code>jp</code> - Japanese</li>
         *                       <li><code>zh</code> - Chinese</li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceptLanguage(java.lang.String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudFormationProvisionedProductProps#getNotificationArns}
         * @param notificationArns Passed to AWS CloudFormation .
         *                         The SNS topic ARNs to which to publish stack-related events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationArns(java.util.List<java.lang.String> notificationArns) {
            this.notificationArns = notificationArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudFormationProvisionedProductProps#getPathId}
         * @param pathId The path identifier of the product.
         *               This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <a href="https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListLaunchPaths.html">ListLaunchPaths</a> .
         *               <p>
         *               <blockquote>
         *               <p>
         *               You must provide the name or ID, but not both.
         *               <p>
         *               </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathId(java.lang.String pathId) {
            this.pathId = pathId;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudFormationProvisionedProductProps#getPathName}
         * @param pathName The name of the path.
         *                 This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <a href="https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListLaunchPaths.html">ListLaunchPaths</a> .
         *                 <p>
         *                 <blockquote>
         *                 <p>
         *                 You must provide the name or ID, but not both.
         *                 <p>
         *                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathName(java.lang.String pathName) {
            this.pathName = pathName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudFormationProvisionedProductProps#getProductId}
         * @param productId The product identifier.
         *                  <blockquote>
         *                  <p>
         *                  You must specify either the ID or the name of the product, but not both.
         *                  <p>
         *                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productId(java.lang.String productId) {
            this.productId = productId;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudFormationProvisionedProductProps#getProductName}
         * @param productName A user-friendly name for the provisioned product.
         *                    This value must be unique for the AWS account and cannot be updated after the product is provisioned.
         *                    <p>
         *                    Each time a stack is created or updated, if <code>ProductName</code> is provided it will successfully resolve to <code>ProductId</code> as long as only one product exists in the account or Region with that <code>ProductName</code> .
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    You must specify either the name or the ID of the product, but not both.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productName(java.lang.String productName) {
            this.productName = productName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudFormationProvisionedProductProps#getProvisionedProductName}
         * @param provisionedProductName A user-friendly name for the provisioned product.
         *                               This value must be unique for the AWS account and cannot be updated after the product is provisioned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedProductName(java.lang.String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudFormationProvisionedProductProps#getProvisioningArtifactId}
         * @param provisioningArtifactId The identifier of the provisioning artifact (also known as a version).
         *                               <blockquote>
         *                               <p>
         *                               You must specify either the ID or the name of the provisioning artifact, but not both.
         *                               <p>
         *                               </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisioningArtifactId(java.lang.String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudFormationProvisionedProductProps#getProvisioningArtifactName}
         * @param provisioningArtifactName The name of the provisioning artifact (also known as a version) for the product.
         *                                 This name must be unique for the product.
         *                                 <p>
         *                                 <blockquote>
         *                                 <p>
         *                                 You must specify either the name or the ID of the provisioning artifact, but not both. You must also specify either the name or the ID of the product, but not both.
         *                                 <p>
         *                                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisioningArtifactName(java.lang.String provisioningArtifactName) {
            this.provisioningArtifactName = provisioningArtifactName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudFormationProvisionedProductProps#getProvisioningParameters}
         * @param provisioningParameters Parameters specified by the administrator that are required for provisioning the product.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisioningParameters(software.amazon.awscdk.core.IResolvable provisioningParameters) {
            this.provisioningParameters = provisioningParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudFormationProvisionedProductProps#getProvisioningParameters}
         * @param provisioningParameters Parameters specified by the administrator that are required for provisioning the product.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisioningParameters(java.util.List<? extends java.lang.Object> provisioningParameters) {
            this.provisioningParameters = provisioningParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudFormationProvisionedProductProps#getProvisioningPreferences}
         * @param provisioningPreferences StackSet preferences that are required for provisioning the product or updating a provisioned product.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisioningPreferences(software.amazon.awscdk.core.IResolvable provisioningPreferences) {
            this.provisioningPreferences = provisioningPreferences;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudFormationProvisionedProductProps#getProvisioningPreferences}
         * @param provisioningPreferences StackSet preferences that are required for provisioning the product or updating a provisioned product.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisioningPreferences(software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProvisionedProduct.ProvisioningPreferencesProperty provisioningPreferences) {
            this.provisioningPreferences = provisioningPreferences;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudFormationProvisionedProductProps#getTags}
         * @param tags One or more tags.
         *             <blockquote>
         *             <p>
         *             Requires the provisioned product to have an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-resourceupdateconstraint.html">ResourceUpdateConstraint</a> resource with <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates. If <code>RESOURCE_UPDATE</code> constraint is not present, tags updates are ignored.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCloudFormationProvisionedProductProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCloudFormationProvisionedProductProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCloudFormationProvisionedProductProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCloudFormationProvisionedProductProps {
        private final java.lang.String acceptLanguage;
        private final java.util.List<java.lang.String> notificationArns;
        private final java.lang.String pathId;
        private final java.lang.String pathName;
        private final java.lang.String productId;
        private final java.lang.String productName;
        private final java.lang.String provisionedProductName;
        private final java.lang.String provisioningArtifactId;
        private final java.lang.String provisioningArtifactName;
        private final java.lang.Object provisioningParameters;
        private final java.lang.Object provisioningPreferences;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.acceptLanguage = software.amazon.jsii.Kernel.get(this, "acceptLanguage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.notificationArns = software.amazon.jsii.Kernel.get(this, "notificationArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.pathId = software.amazon.jsii.Kernel.get(this, "pathId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pathName = software.amazon.jsii.Kernel.get(this, "pathName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.productId = software.amazon.jsii.Kernel.get(this, "productId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.productName = software.amazon.jsii.Kernel.get(this, "productName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.provisionedProductName = software.amazon.jsii.Kernel.get(this, "provisionedProductName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.provisioningArtifactId = software.amazon.jsii.Kernel.get(this, "provisioningArtifactId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.provisioningArtifactName = software.amazon.jsii.Kernel.get(this, "provisioningArtifactName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.provisioningParameters = software.amazon.jsii.Kernel.get(this, "provisioningParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.provisioningPreferences = software.amazon.jsii.Kernel.get(this, "provisioningPreferences", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.acceptLanguage = builder.acceptLanguage;
            this.notificationArns = builder.notificationArns;
            this.pathId = builder.pathId;
            this.pathName = builder.pathName;
            this.productId = builder.productId;
            this.productName = builder.productName;
            this.provisionedProductName = builder.provisionedProductName;
            this.provisioningArtifactId = builder.provisioningArtifactId;
            this.provisioningArtifactName = builder.provisioningArtifactName;
            this.provisioningParameters = builder.provisioningParameters;
            this.provisioningPreferences = builder.provisioningPreferences;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final java.util.List<java.lang.String> getNotificationArns() {
            return this.notificationArns;
        }

        @Override
        public final java.lang.String getPathId() {
            return this.pathId;
        }

        @Override
        public final java.lang.String getPathName() {
            return this.pathName;
        }

        @Override
        public final java.lang.String getProductId() {
            return this.productId;
        }

        @Override
        public final java.lang.String getProductName() {
            return this.productName;
        }

        @Override
        public final java.lang.String getProvisionedProductName() {
            return this.provisionedProductName;
        }

        @Override
        public final java.lang.String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        @Override
        public final java.lang.String getProvisioningArtifactName() {
            return this.provisioningArtifactName;
        }

        @Override
        public final java.lang.Object getProvisioningParameters() {
            return this.provisioningParameters;
        }

        @Override
        public final java.lang.Object getProvisioningPreferences() {
            return this.provisioningPreferences;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAcceptLanguage() != null) {
                data.set("acceptLanguage", om.valueToTree(this.getAcceptLanguage()));
            }
            if (this.getNotificationArns() != null) {
                data.set("notificationArns", om.valueToTree(this.getNotificationArns()));
            }
            if (this.getPathId() != null) {
                data.set("pathId", om.valueToTree(this.getPathId()));
            }
            if (this.getPathName() != null) {
                data.set("pathName", om.valueToTree(this.getPathName()));
            }
            if (this.getProductId() != null) {
                data.set("productId", om.valueToTree(this.getProductId()));
            }
            if (this.getProductName() != null) {
                data.set("productName", om.valueToTree(this.getProductName()));
            }
            if (this.getProvisionedProductName() != null) {
                data.set("provisionedProductName", om.valueToTree(this.getProvisionedProductName()));
            }
            if (this.getProvisioningArtifactId() != null) {
                data.set("provisioningArtifactId", om.valueToTree(this.getProvisioningArtifactId()));
            }
            if (this.getProvisioningArtifactName() != null) {
                data.set("provisioningArtifactName", om.valueToTree(this.getProvisioningArtifactName()));
            }
            if (this.getProvisioningParameters() != null) {
                data.set("provisioningParameters", om.valueToTree(this.getProvisioningParameters()));
            }
            if (this.getProvisioningPreferences() != null) {
                data.set("provisioningPreferences", om.valueToTree(this.getProvisioningPreferences()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicecatalog.CfnCloudFormationProvisionedProductProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCloudFormationProvisionedProductProps.Jsii$Proxy that = (CfnCloudFormationProvisionedProductProps.Jsii$Proxy) o;

            if (this.acceptLanguage != null ? !this.acceptLanguage.equals(that.acceptLanguage) : that.acceptLanguage != null) return false;
            if (this.notificationArns != null ? !this.notificationArns.equals(that.notificationArns) : that.notificationArns != null) return false;
            if (this.pathId != null ? !this.pathId.equals(that.pathId) : that.pathId != null) return false;
            if (this.pathName != null ? !this.pathName.equals(that.pathName) : that.pathName != null) return false;
            if (this.productId != null ? !this.productId.equals(that.productId) : that.productId != null) return false;
            if (this.productName != null ? !this.productName.equals(that.productName) : that.productName != null) return false;
            if (this.provisionedProductName != null ? !this.provisionedProductName.equals(that.provisionedProductName) : that.provisionedProductName != null) return false;
            if (this.provisioningArtifactId != null ? !this.provisioningArtifactId.equals(that.provisioningArtifactId) : that.provisioningArtifactId != null) return false;
            if (this.provisioningArtifactName != null ? !this.provisioningArtifactName.equals(that.provisioningArtifactName) : that.provisioningArtifactName != null) return false;
            if (this.provisioningParameters != null ? !this.provisioningParameters.equals(that.provisioningParameters) : that.provisioningParameters != null) return false;
            if (this.provisioningPreferences != null ? !this.provisioningPreferences.equals(that.provisioningPreferences) : that.provisioningPreferences != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.acceptLanguage != null ? this.acceptLanguage.hashCode() : 0;
            result = 31 * result + (this.notificationArns != null ? this.notificationArns.hashCode() : 0);
            result = 31 * result + (this.pathId != null ? this.pathId.hashCode() : 0);
            result = 31 * result + (this.pathName != null ? this.pathName.hashCode() : 0);
            result = 31 * result + (this.productId != null ? this.productId.hashCode() : 0);
            result = 31 * result + (this.productName != null ? this.productName.hashCode() : 0);
            result = 31 * result + (this.provisionedProductName != null ? this.provisionedProductName.hashCode() : 0);
            result = 31 * result + (this.provisioningArtifactId != null ? this.provisioningArtifactId.hashCode() : 0);
            result = 31 * result + (this.provisioningArtifactName != null ? this.provisioningArtifactName.hashCode() : 0);
            result = 31 * result + (this.provisioningParameters != null ? this.provisioningParameters.hashCode() : 0);
            result = 31 * result + (this.provisioningPreferences != null ? this.provisioningPreferences.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
