package software.amazon.awscdk.services.servicecatalog;

/**
 * Properties for defining a `CfnServiceActionAssociation`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.servicecatalog.*;
 * CfnServiceActionAssociationProps cfnServiceActionAssociationProps = CfnServiceActionAssociationProps.builder()
 *         .productId("productId")
 *         .provisioningArtifactId("provisioningArtifactId")
 *         .serviceActionId("serviceActionId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-21T22:31:03.654Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.CfnServiceActionAssociationProps")
@software.amazon.jsii.Jsii.Proxy(CfnServiceActionAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnServiceActionAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The product identifier.
     * <p>
     * For example, <code>prod-abcdzk7xy33qa</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProductId();

    /**
     * The identifier of the provisioning artifact.
     * <p>
     * For example, <code>pa-4abcdjnxjj6ne</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProvisioningArtifactId();

    /**
     * The self-service action identifier.
     * <p>
     * For example, <code>act-fs7abcd89wxyz</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceActionId();

    /**
     * @return a {@link Builder} of {@link CfnServiceActionAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnServiceActionAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnServiceActionAssociationProps> {
        java.lang.String productId;
        java.lang.String provisioningArtifactId;
        java.lang.String serviceActionId;

        /**
         * Sets the value of {@link CfnServiceActionAssociationProps#getProductId}
         * @param productId The product identifier. This parameter is required.
         *                  For example, <code>prod-abcdzk7xy33qa</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productId(java.lang.String productId) {
            this.productId = productId;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceActionAssociationProps#getProvisioningArtifactId}
         * @param provisioningArtifactId The identifier of the provisioning artifact. This parameter is required.
         *                               For example, <code>pa-4abcdjnxjj6ne</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisioningArtifactId(java.lang.String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceActionAssociationProps#getServiceActionId}
         * @param serviceActionId The self-service action identifier. This parameter is required.
         *                        For example, <code>act-fs7abcd89wxyz</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceActionId(java.lang.String serviceActionId) {
            this.serviceActionId = serviceActionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnServiceActionAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnServiceActionAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnServiceActionAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnServiceActionAssociationProps {
        private final java.lang.String productId;
        private final java.lang.String provisioningArtifactId;
        private final java.lang.String serviceActionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.productId = software.amazon.jsii.Kernel.get(this, "productId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.provisioningArtifactId = software.amazon.jsii.Kernel.get(this, "provisioningArtifactId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceActionId = software.amazon.jsii.Kernel.get(this, "serviceActionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.productId = java.util.Objects.requireNonNull(builder.productId, "productId is required");
            this.provisioningArtifactId = java.util.Objects.requireNonNull(builder.provisioningArtifactId, "provisioningArtifactId is required");
            this.serviceActionId = java.util.Objects.requireNonNull(builder.serviceActionId, "serviceActionId is required");
        }

        @Override
        public final java.lang.String getProductId() {
            return this.productId;
        }

        @Override
        public final java.lang.String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        @Override
        public final java.lang.String getServiceActionId() {
            return this.serviceActionId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("productId", om.valueToTree(this.getProductId()));
            data.set("provisioningArtifactId", om.valueToTree(this.getProvisioningArtifactId()));
            data.set("serviceActionId", om.valueToTree(this.getServiceActionId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicecatalog.CfnServiceActionAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnServiceActionAssociationProps.Jsii$Proxy that = (CfnServiceActionAssociationProps.Jsii$Proxy) o;

            if (!productId.equals(that.productId)) return false;
            if (!provisioningArtifactId.equals(that.provisioningArtifactId)) return false;
            return this.serviceActionId.equals(that.serviceActionId);
        }

        @Override
        public final int hashCode() {
            int result = this.productId.hashCode();
            result = 31 * result + (this.provisioningArtifactId.hashCode());
            result = 31 * result + (this.serviceActionId.hashCode());
            return result;
        }
    }
}
