package software.amazon.awscdk.services.servicecatalog;

/**
 * A Service Catalog portfolio.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Portfolio.Builder.create(this, "Portfolio")
 *         .displayName("MyPortfolio")
 *         .providerName("MyTeam")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-28T18:14:38.777Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.Portfolio")
public class Portfolio extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.servicecatalog.IPortfolio {

    protected Portfolio(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Portfolio(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Portfolio(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.PortfolioProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a Portfolio construct that represents an external portfolio.
     * <p>
     * @param scope The parent creating construct (usually `this`). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param portfolioArn the Amazon Resource Name of the existing portfolio. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IPortfolio fromPortfolioArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String portfolioArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.servicecatalog.Portfolio.class, "fromPortfolioArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalog.IPortfolio.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(portfolioArn, "portfolioArn is required") });
    }

    /**
     * Associate portfolio with the given product.
     * <p>
     * @param product This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addProduct(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product) {
        software.amazon.jsii.Kernel.call(this, "addProduct", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required") });
    }

    /**
     * Associate Tag Options.
     * <p>
     * A TagOption is a key-value pair managed in AWS Service Catalog.
     * It is not an AWS tag, but serves as a template for creating an AWS tag based on the TagOption.
     * <p>
     * @param tagOptions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void associateTagOptions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.TagOptions tagOptions) {
        software.amazon.jsii.Kernel.call(this, "associateTagOptions", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(tagOptions, "tagOptions is required") });
    }

    /**
     * Set provisioning rules for the product.
     * <p>
     * @param product This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void constrainCloudFormationParameters(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.CloudFormationRuleConstraintOptions options) {
        software.amazon.jsii.Kernel.call(this, "constrainCloudFormationParameters", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Add a Resource Update Constraint.
     * <p>
     * @param product This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void constrainTagUpdates(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.TagUpdateConstraintOptions options) {
        software.amazon.jsii.Kernel.call(this, "constrainTagUpdates", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), options });
    }

    /**
     * Add a Resource Update Constraint.
     * <p>
     * @param product This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void constrainTagUpdates(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product) {
        software.amazon.jsii.Kernel.call(this, "constrainTagUpdates", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required") });
    }

    /**
     * Configure deployment options using AWS Cloudformation StackSets.
     * <p>
     * @param product This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void deployWithStackSets(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.StackSetsConstraintOptions options) {
        software.amazon.jsii.Kernel.call(this, "deployWithStackSets", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Create a unique id based off the L1 CfnPortfolio or the arn of an imported portfolio.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.String generateUniqueHash(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.Kernel.call(this, "generateUniqueHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Associate portfolio with an IAM Group.
     * <p>
     * @param group This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void giveAccessToGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGroup group) {
        software.amazon.jsii.Kernel.call(this, "giveAccessToGroup", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(group, "group is required") });
    }

    /**
     * Associate portfolio with an IAM Role.
     * <p>
     * @param role This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void giveAccessToRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole role) {
        software.amazon.jsii.Kernel.call(this, "giveAccessToRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(role, "role is required") });
    }

    /**
     * Associate portfolio with an IAM User.
     * <p>
     * @param user This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void giveAccessToUser(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IUser user) {
        software.amazon.jsii.Kernel.call(this, "giveAccessToUser", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(user, "user is required") });
    }

    /**
     * Add notifications for supplied topics on the provisioned product.
     * <p>
     * @param product This parameter is required.
     * @param topic This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void notifyOnStackEvents(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic topic, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.CommonConstraintOptions options) {
        software.amazon.jsii.Kernel.call(this, "notifyOnStackEvents", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(topic, "topic is required"), options });
    }

    /**
     * Add notifications for supplied topics on the provisioned product.
     * <p>
     * @param product This parameter is required.
     * @param topic This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void notifyOnStackEvents(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic topic) {
        software.amazon.jsii.Kernel.call(this, "notifyOnStackEvents", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(topic, "topic is required") });
    }

    /**
     * Force users to assume a certain role when launching a product.
     * <p>
     * This sets the launch role using the role arn which is tied to the account this role exists in.
     * This is useful if you will be provisioning products from the account where this role exists.
     * If you intend to share the portfolio across accounts, use a local launch role.
     * <p>
     * @param product This parameter is required.
     * @param launchRole This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void setLaunchRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole launchRole, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.CommonConstraintOptions options) {
        software.amazon.jsii.Kernel.call(this, "setLaunchRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(launchRole, "launchRole is required"), options });
    }

    /**
     * Force users to assume a certain role when launching a product.
     * <p>
     * This sets the launch role using the role arn which is tied to the account this role exists in.
     * This is useful if you will be provisioning products from the account where this role exists.
     * If you intend to share the portfolio across accounts, use a local launch role.
     * <p>
     * @param product This parameter is required.
     * @param launchRole This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void setLaunchRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole launchRole) {
        software.amazon.jsii.Kernel.call(this, "setLaunchRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(launchRole, "launchRole is required") });
    }

    /**
     * Force users to assume a certain role when launching a product.
     * <p>
     * The role name will be referenced by in the local account and must be set explicitly.
     * This is useful when sharing the portfolio with multiple accounts.
     * <p>
     * @param product This parameter is required.
     * @param launchRole This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void setLocalLaunchRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole launchRole, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.CommonConstraintOptions options) {
        software.amazon.jsii.Kernel.call(this, "setLocalLaunchRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(launchRole, "launchRole is required"), options });
    }

    /**
     * Force users to assume a certain role when launching a product.
     * <p>
     * The role name will be referenced by in the local account and must be set explicitly.
     * This is useful when sharing the portfolio with multiple accounts.
     * <p>
     * @param product This parameter is required.
     * @param launchRole This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void setLocalLaunchRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole launchRole) {
        software.amazon.jsii.Kernel.call(this, "setLocalLaunchRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(launchRole, "launchRole is required") });
    }

    /**
     * Force users to assume a certain role when launching a product.
     * <p>
     * The role will be referenced by name in the local account instead of a static role arn.
     * A role with this name will automatically be created and assumable by Service Catalog in this account.
     * This is useful when sharing the portfolio with multiple accounts.
     * <p>
     * @param product This parameter is required.
     * @param launchRoleName This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole setLocalLaunchRoleName(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull java.lang.String launchRoleName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.CommonConstraintOptions options) {
        return software.amazon.jsii.Kernel.call(this, "setLocalLaunchRoleName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class), new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(launchRoleName, "launchRoleName is required"), options });
    }

    /**
     * Force users to assume a certain role when launching a product.
     * <p>
     * The role will be referenced by name in the local account instead of a static role arn.
     * A role with this name will automatically be created and assumable by Service Catalog in this account.
     * This is useful when sharing the portfolio with multiple accounts.
     * <p>
     * @param product This parameter is required.
     * @param launchRoleName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole setLocalLaunchRoleName(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull java.lang.String launchRoleName) {
        return software.amazon.jsii.Kernel.call(this, "setLocalLaunchRoleName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class), new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(launchRoleName, "launchRoleName is required") });
    }

    /**
     * Initiate a portfolio share with another account.
     * <p>
     * @param accountId This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void shareWithAccount(final @org.jetbrains.annotations.NotNull java.lang.String accountId, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.PortfolioShareOptions options) {
        software.amazon.jsii.Kernel.call(this, "shareWithAccount", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(accountId, "accountId is required"), options });
    }

    /**
     * Initiate a portfolio share with another account.
     * <p>
     * @param accountId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void shareWithAccount(final @org.jetbrains.annotations.NotNull java.lang.String accountId) {
        software.amazon.jsii.Kernel.call(this, "shareWithAccount", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(accountId, "accountId is required") });
    }

    /**
     * The ARN of the portfolio.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPortfolioArn() {
        return software.amazon.jsii.Kernel.get(this, "portfolioArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the portfolio.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPortfolioId() {
        return software.amazon.jsii.Kernel.get(this, "portfolioId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.servicecatalog.Portfolio}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.servicecatalog.Portfolio> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.servicecatalog.PortfolioProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.servicecatalog.PortfolioProps.Builder();
        }

        /**
         * The name of the portfolio.
         * <p>
         * @return {@code this}
         * @param displayName The name of the portfolio. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(final java.lang.String displayName) {
            this.props.displayName(displayName);
            return this;
        }

        /**
         * The provider name.
         * <p>
         * @return {@code this}
         * @param providerName The provider name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder providerName(final java.lang.String providerName) {
            this.props.providerName(providerName);
            return this;
        }

        /**
         * Description for portfolio.
         * <p>
         * Default: - No description provided
         * <p>
         * @return {@code this}
         * @param description Description for portfolio. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The message language.
         * <p>
         * Controls language for
         * status logging and errors.
         * <p>
         * Default: - English
         * <p>
         * @return {@code this}
         * @param messageLanguage The message language. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageLanguage(final software.amazon.awscdk.services.servicecatalog.MessageLanguage messageLanguage) {
            this.props.messageLanguage(messageLanguage);
            return this;
        }

        /**
         * TagOptions associated directly to a portfolio.
         * <p>
         * Default: - No tagOptions provided
         * <p>
         * @return {@code this}
         * @param tagOptions TagOptions associated directly to a portfolio. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagOptions(final software.amazon.awscdk.services.servicecatalog.TagOptions tagOptions) {
            this.props.tagOptions(tagOptions);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.servicecatalog.Portfolio}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.servicecatalog.Portfolio build() {
            return new software.amazon.awscdk.services.servicecatalog.Portfolio(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
