package software.amazon.awscdk.services.servicecatalog;

/**
 * A CloudFormation `AWS::ServiceCatalog::CloudFormationProvisionedProduct`.
 * <p>
 * Provisions the specified product.
 * <p>
 * A provisioned product is a resourced instance of a product. For example, provisioning a product based on a AWS CloudFormation template launches a AWS CloudFormation stack and its underlying resources. You can check the status of this request using <a href="https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeRecord.html">DescribeRecord</a> .
 * <p>
 * If the request contains a tag key with an empty list of values, there is a tag conflict for that key. Do not include conflicted keys as tags, or this causes the error "Parameter validation failed: Missing required parameter in Tags[ <em>N</em> ]: <em>Value</em> ".
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.servicecatalog.*;
 * CfnCloudFormationProvisionedProduct cfnCloudFormationProvisionedProduct = CfnCloudFormationProvisionedProduct.Builder.create(this, "MyCfnCloudFormationProvisionedProduct")
 *         .acceptLanguage("acceptLanguage")
 *         .notificationArns(List.of("notificationArns"))
 *         .pathId("pathId")
 *         .pathName("pathName")
 *         .productId("productId")
 *         .productName("productName")
 *         .provisionedProductName("provisionedProductName")
 *         .provisioningArtifactId("provisioningArtifactId")
 *         .provisioningArtifactName("provisioningArtifactName")
 *         .provisioningParameters(List.of(ProvisioningParameterProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .provisioningPreferences(ProvisioningPreferencesProperty.builder()
 *                 .stackSetAccounts(List.of("stackSetAccounts"))
 *                 .stackSetFailureToleranceCount(123)
 *                 .stackSetFailureTolerancePercentage(123)
 *                 .stackSetMaxConcurrencyCount(123)
 *                 .stackSetMaxConcurrencyPercentage(123)
 *                 .stackSetOperationType("stackSetOperationType")
 *                 .stackSetRegions(List.of("stackSetRegions"))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-23T19:56:56.788Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.CfnCloudFormationProvisionedProduct")
public class CfnCloudFormationProvisionedProduct extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnCloudFormationProvisionedProduct(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCloudFormationProvisionedProduct(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProvisionedProduct.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ServiceCatalog::CloudFormationProvisionedProduct`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCloudFormationProvisionedProduct(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProvisionedProductProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::ServiceCatalog::CloudFormationProvisionedProduct`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCloudFormationProvisionedProduct(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the CloudFormation stack, such as `arn:aws:cloudformation:eu-west-1:123456789012:stack/SC-499278721343-pp-hfyszaotincww/8f3df460-346a-11e8-9444-503abe701c29` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCloudformationStackArn() {
        return software.amazon.jsii.Kernel.get(this, "attrCloudformationStackArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The output of the product you are provisioning.
     * <p>
     * For example, the DNS of an EC2 instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable getAttrOutputs() {
        return software.amazon.jsii.Kernel.get(this, "attrOutputs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IResolvable.class));
    }

    /**
     * The ID of the provisioned product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrProvisionedProductId() {
        return software.amazon.jsii.Kernel.get(this, "attrProvisionedProductId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the record, such as `rec-rjeatvy434trk` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRecordId() {
        return software.amazon.jsii.Kernel.get(this, "attrRecordId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * One or more tags.
     * <p>
     * <blockquote>
     * <p>
     * Requires the provisioned product to have an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-resourceupdateconstraint.html">ResourceUpdateConstraint</a> resource with <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates. If <code>RESOURCE_UPDATE</code> constraint is not present, tags updates are ignored.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The language code.
     * <p>
     * <ul>
     * <li><code>en</code> - English (default)</li>
     * <li><code>jp</code> - Japanese</li>
     * <li><code>zh</code> - Chinese</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAcceptLanguage() {
        return software.amazon.jsii.Kernel.get(this, "acceptLanguage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The language code.
     * <p>
     * <ul>
     * <li><code>en</code> - English (default)</li>
     * <li><code>jp</code> - Japanese</li>
     * <li><code>zh</code> - Chinese</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAcceptLanguage(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "acceptLanguage", value);
    }

    /**
     * Passed to AWS CloudFormation .
     * <p>
     * The SNS topic ARNs to which to publish stack-related events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotificationArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "notificationArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Passed to AWS CloudFormation .
     * <p>
     * The SNS topic ARNs to which to publish stack-related events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "notificationArns", value);
    }

    /**
     * The path identifier of the product.
     * <p>
     * This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <a href="https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListLaunchPaths.html">ListLaunchPaths</a> .
     * <p>
     * <blockquote>
     * <p>
     * You must provide the name or ID, but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPathId() {
        return software.amazon.jsii.Kernel.get(this, "pathId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The path identifier of the product.
     * <p>
     * This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <a href="https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListLaunchPaths.html">ListLaunchPaths</a> .
     * <p>
     * <blockquote>
     * <p>
     * You must provide the name or ID, but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPathId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "pathId", value);
    }

    /**
     * The name of the path.
     * <p>
     * This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <a href="https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListLaunchPaths.html">ListLaunchPaths</a> .
     * <p>
     * <blockquote>
     * <p>
     * You must provide the name or ID, but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPathName() {
        return software.amazon.jsii.Kernel.get(this, "pathName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the path.
     * <p>
     * This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <a href="https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListLaunchPaths.html">ListLaunchPaths</a> .
     * <p>
     * <blockquote>
     * <p>
     * You must provide the name or ID, but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPathName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "pathName", value);
    }

    /**
     * The product identifier.
     * <p>
     * <blockquote>
     * <p>
     * You must specify either the ID or the name of the product, but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getProductId() {
        return software.amazon.jsii.Kernel.get(this, "productId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The product identifier.
     * <p>
     * <blockquote>
     * <p>
     * You must specify either the ID or the name of the product, but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProductId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "productId", value);
    }

    /**
     * A user-friendly name for the provisioned product.
     * <p>
     * This value must be unique for the AWS account and cannot be updated after the product is provisioned.
     * <p>
     * Each time a stack is created or updated, if <code>ProductName</code> is provided it will successfully resolve to <code>ProductId</code> as long as only one product exists in the account or Region with that <code>ProductName</code> .
     * <p>
     * <blockquote>
     * <p>
     * You must specify either the name or the ID of the product, but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getProductName() {
        return software.amazon.jsii.Kernel.get(this, "productName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A user-friendly name for the provisioned product.
     * <p>
     * This value must be unique for the AWS account and cannot be updated after the product is provisioned.
     * <p>
     * Each time a stack is created or updated, if <code>ProductName</code> is provided it will successfully resolve to <code>ProductId</code> as long as only one product exists in the account or Region with that <code>ProductName</code> .
     * <p>
     * <blockquote>
     * <p>
     * You must specify either the name or the ID of the product, but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProductName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "productName", value);
    }

    /**
     * A user-friendly name for the provisioned product.
     * <p>
     * This value must be unique for the AWS account and cannot be updated after the product is provisioned.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getProvisionedProductName() {
        return software.amazon.jsii.Kernel.get(this, "provisionedProductName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A user-friendly name for the provisioned product.
     * <p>
     * This value must be unique for the AWS account and cannot be updated after the product is provisioned.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisionedProductName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "provisionedProductName", value);
    }

    /**
     * The identifier of the provisioning artifact (also known as a version).
     * <p>
     * <blockquote>
     * <p>
     * You must specify either the ID or the name of the provisioning artifact, but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getProvisioningArtifactId() {
        return software.amazon.jsii.Kernel.get(this, "provisioningArtifactId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the provisioning artifact (also known as a version).
     * <p>
     * <blockquote>
     * <p>
     * You must specify either the ID or the name of the provisioning artifact, but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisioningArtifactId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "provisioningArtifactId", value);
    }

    /**
     * The name of the provisioning artifact (also known as a version) for the product.
     * <p>
     * This name must be unique for the product.
     * <p>
     * <blockquote>
     * <p>
     * You must specify either the name or the ID of the provisioning artifact, but not both. You must also specify either the name or the ID of the product, but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getProvisioningArtifactName() {
        return software.amazon.jsii.Kernel.get(this, "provisioningArtifactName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the provisioning artifact (also known as a version) for the product.
     * <p>
     * This name must be unique for the product.
     * <p>
     * <blockquote>
     * <p>
     * You must specify either the name or the ID of the provisioning artifact, but not both. You must also specify either the name or the ID of the product, but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisioningArtifactName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "provisioningArtifactName", value);
    }

    /**
     * Parameters specified by the administrator that are required for provisioning the product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getProvisioningParameters() {
        return software.amazon.jsii.Kernel.get(this, "provisioningParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Parameters specified by the administrator that are required for provisioning the product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisioningParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "provisioningParameters", value);
    }

    /**
     * Parameters specified by the administrator that are required for provisioning the product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisioningParameters(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProvisionedProduct.ProvisioningParameterProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProvisionedProduct.ProvisioningParameterProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "provisioningParameters", value);
    }

    /**
     * StackSet preferences that are required for provisioning the product or updating a provisioned product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getProvisioningPreferences() {
        return software.amazon.jsii.Kernel.get(this, "provisioningPreferences", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * StackSet preferences that are required for provisioning the product or updating a provisioned product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisioningPreferences(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "provisioningPreferences", value);
    }

    /**
     * StackSet preferences that are required for provisioning the product or updating a provisioned product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisioningPreferences(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProvisionedProduct.ProvisioningPreferencesProperty value) {
        software.amazon.jsii.Kernel.set(this, "provisioningPreferences", value);
    }
    /**
     * Information about a parameter used to provision a product.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.servicecatalog.*;
     * ProvisioningParameterProperty provisioningParameterProperty = ProvisioningParameterProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.CfnCloudFormationProvisionedProduct.ProvisioningParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(ProvisioningParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProvisioningParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The parameter key.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The parameter value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link ProvisioningParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProvisioningParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProvisioningParameterProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link ProvisioningParameterProperty#getKey}
             * @param key The parameter key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link ProvisioningParameterProperty#getValue}
             * @param value The parameter value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProvisioningParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProvisioningParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProvisioningParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProvisioningParameterProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicecatalog.CfnCloudFormationProvisionedProduct.ProvisioningParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProvisioningParameterProperty.Jsii$Proxy that = (ProvisioningParameterProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The user-defined preferences that will be applied when updating a provisioned product.
     * <p>
     * Not all preferences are applicable to all provisioned product type
     * <p>
     * One or more AWS accounts that will have access to the provisioned product.
     * <p>
     * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
     * <p>
     * The AWS accounts specified should be within the list of accounts in the <code>STACKSET</code> constraint. To get the list of accounts in the <code>STACKSET</code> constraint, use the <code>DescribeProvisioningParameters</code> operation.
     * <p>
     * If no values are specified, the default value is all accounts from the <code>STACKSET</code> constraint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.servicecatalog.*;
     * ProvisioningPreferencesProperty provisioningPreferencesProperty = ProvisioningPreferencesProperty.builder()
     *         .stackSetAccounts(List.of("stackSetAccounts"))
     *         .stackSetFailureToleranceCount(123)
     *         .stackSetFailureTolerancePercentage(123)
     *         .stackSetMaxConcurrencyCount(123)
     *         .stackSetMaxConcurrencyPercentage(123)
     *         .stackSetOperationType("stackSetOperationType")
     *         .stackSetRegions(List.of("stackSetRegions"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.CfnCloudFormationProvisionedProduct.ProvisioningPreferencesProperty")
    @software.amazon.jsii.Jsii.Proxy(ProvisioningPreferencesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProvisioningPreferencesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * One or more AWS accounts where the provisioned product will be available.
         * <p>
         * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * <p>
         * The specified accounts should be within the list of accounts from the <code>STACKSET</code> constraint. To get the list of accounts in the <code>STACKSET</code> constraint, use the <code>DescribeProvisioningParameters</code> operation.
         * <p>
         * If no values are specified, the default value is all acounts from the <code>STACKSET</code> constraint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStackSetAccounts() {
            return null;
        }

        /**
         * The number of accounts, per Region, for which this operation can fail before AWS Service Catalog stops the operation in that Region.
         * <p>
         * If the operation is stopped in a Region, AWS Service Catalog doesn't attempt the operation in any subsequent Regions.
         * <p>
         * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * <p>
         * Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or <code>StackSetFailureTolerancePercentage</code> , but not both.
         * <p>
         * The default value is <code>0</code> if no value is specified.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStackSetFailureToleranceCount() {
            return null;
        }

        /**
         * The percentage of accounts, per Region, for which this stack operation can fail before AWS Service Catalog stops the operation in that Region.
         * <p>
         * If the operation is stopped in a Region, AWS Service Catalog doesn't attempt the operation in any subsequent Regions.
         * <p>
         * When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number.
         * <p>
         * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * <p>
         * Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or <code>StackSetFailureTolerancePercentage</code> , but not both.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStackSetFailureTolerancePercentage() {
            return null;
        }

        /**
         * The maximum number of accounts in which to perform this operation at one time.
         * <p>
         * This is dependent on the value of <code>StackSetFailureToleranceCount</code> . <code>StackSetMaxConcurrentCount</code> is at most one more than the <code>StackSetFailureToleranceCount</code> .
         * <p>
         * Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
         * <p>
         * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * <p>
         * Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or <code>StackSetMaxConcurrentPercentage</code> , but not both.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStackSetMaxConcurrencyCount() {
            return null;
        }

        /**
         * The maximum percentage of accounts in which to perform this operation at one time.
         * <p>
         * When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, AWS Service Catalog sets the number as <code>1</code> instead.
         * <p>
         * Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
         * <p>
         * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * <p>
         * Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or <code>StackSetMaxConcurrentPercentage</code> , but not both.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStackSetMaxConcurrencyPercentage() {
            return null;
        }

        /**
         * Determines what action AWS Service Catalog performs to a stack set or a stack instance represented by the provisioned product.
         * <p>
         * The default value is <code>UPDATE</code> if nothing is specified.
         * <p>
         * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * <p>
         * <ul>
         * <li><strong>CREATE</strong> - Creates a new stack instance in the stack set represented by the provisioned product. In this case, only new stack instances are created based on accounts and Regions; if new ProductId or ProvisioningArtifactID are passed, they will be ignored.</li>
         * <li><strong>UPDATE</strong> - Updates the stack set represented by the provisioned product and also its stack instances.</li>
         * <li><strong>DELETE</strong> - Deletes a stack instance in the stack set represented by the provisioned product.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStackSetOperationType() {
            return null;
        }

        /**
         * One or more AWS Regions where the provisioned product will be available.
         * <p>
         * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         * <p>
         * The specified Regions should be within the list of Regions from the <code>STACKSET</code> constraint. To get the list of Regions in the <code>STACKSET</code> constraint, use the <code>DescribeProvisioningParameters</code> operation.
         * <p>
         * If no values are specified, the default value is all Regions from the <code>STACKSET</code> constraint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStackSetRegions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProvisioningPreferencesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProvisioningPreferencesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProvisioningPreferencesProperty> {
            java.util.List<java.lang.String> stackSetAccounts;
            java.lang.Number stackSetFailureToleranceCount;
            java.lang.Number stackSetFailureTolerancePercentage;
            java.lang.Number stackSetMaxConcurrencyCount;
            java.lang.Number stackSetMaxConcurrencyPercentage;
            java.lang.String stackSetOperationType;
            java.util.List<java.lang.String> stackSetRegions;

            /**
             * Sets the value of {@link ProvisioningPreferencesProperty#getStackSetAccounts}
             * @param stackSetAccounts One or more AWS accounts where the provisioned product will be available.
             *                         Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
             *                         <p>
             *                         The specified accounts should be within the list of accounts from the <code>STACKSET</code> constraint. To get the list of accounts in the <code>STACKSET</code> constraint, use the <code>DescribeProvisioningParameters</code> operation.
             *                         <p>
             *                         If no values are specified, the default value is all acounts from the <code>STACKSET</code> constraint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stackSetAccounts(java.util.List<java.lang.String> stackSetAccounts) {
                this.stackSetAccounts = stackSetAccounts;
                return this;
            }

            /**
             * Sets the value of {@link ProvisioningPreferencesProperty#getStackSetFailureToleranceCount}
             * @param stackSetFailureToleranceCount The number of accounts, per Region, for which this operation can fail before AWS Service Catalog stops the operation in that Region.
             *                                      If the operation is stopped in a Region, AWS Service Catalog doesn't attempt the operation in any subsequent Regions.
             *                                      <p>
             *                                      Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
             *                                      <p>
             *                                      Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or <code>StackSetFailureTolerancePercentage</code> , but not both.
             *                                      <p>
             *                                      The default value is <code>0</code> if no value is specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stackSetFailureToleranceCount(java.lang.Number stackSetFailureToleranceCount) {
                this.stackSetFailureToleranceCount = stackSetFailureToleranceCount;
                return this;
            }

            /**
             * Sets the value of {@link ProvisioningPreferencesProperty#getStackSetFailureTolerancePercentage}
             * @param stackSetFailureTolerancePercentage The percentage of accounts, per Region, for which this stack operation can fail before AWS Service Catalog stops the operation in that Region.
             *                                           If the operation is stopped in a Region, AWS Service Catalog doesn't attempt the operation in any subsequent Regions.
             *                                           <p>
             *                                           When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number.
             *                                           <p>
             *                                           Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
             *                                           <p>
             *                                           Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or <code>StackSetFailureTolerancePercentage</code> , but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stackSetFailureTolerancePercentage(java.lang.Number stackSetFailureTolerancePercentage) {
                this.stackSetFailureTolerancePercentage = stackSetFailureTolerancePercentage;
                return this;
            }

            /**
             * Sets the value of {@link ProvisioningPreferencesProperty#getStackSetMaxConcurrencyCount}
             * @param stackSetMaxConcurrencyCount The maximum number of accounts in which to perform this operation at one time.
             *                                    This is dependent on the value of <code>StackSetFailureToleranceCount</code> . <code>StackSetMaxConcurrentCount</code> is at most one more than the <code>StackSetFailureToleranceCount</code> .
             *                                    <p>
             *                                    Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
             *                                    <p>
             *                                    Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
             *                                    <p>
             *                                    Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or <code>StackSetMaxConcurrentPercentage</code> , but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stackSetMaxConcurrencyCount(java.lang.Number stackSetMaxConcurrencyCount) {
                this.stackSetMaxConcurrencyCount = stackSetMaxConcurrencyCount;
                return this;
            }

            /**
             * Sets the value of {@link ProvisioningPreferencesProperty#getStackSetMaxConcurrencyPercentage}
             * @param stackSetMaxConcurrencyPercentage The maximum percentage of accounts in which to perform this operation at one time.
             *                                         When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, AWS Service Catalog sets the number as <code>1</code> instead.
             *                                         <p>
             *                                         Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
             *                                         <p>
             *                                         Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
             *                                         <p>
             *                                         Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or <code>StackSetMaxConcurrentPercentage</code> , but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stackSetMaxConcurrencyPercentage(java.lang.Number stackSetMaxConcurrencyPercentage) {
                this.stackSetMaxConcurrencyPercentage = stackSetMaxConcurrencyPercentage;
                return this;
            }

            /**
             * Sets the value of {@link ProvisioningPreferencesProperty#getStackSetOperationType}
             * @param stackSetOperationType Determines what action AWS Service Catalog performs to a stack set or a stack instance represented by the provisioned product.
             *                              The default value is <code>UPDATE</code> if nothing is specified.
             *                              <p>
             *                              Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
             *                              <p>
             *                              <ul>
             *                              <li><strong>CREATE</strong> - Creates a new stack instance in the stack set represented by the provisioned product. In this case, only new stack instances are created based on accounts and Regions; if new ProductId or ProvisioningArtifactID are passed, they will be ignored.</li>
             *                              <li><strong>UPDATE</strong> - Updates the stack set represented by the provisioned product and also its stack instances.</li>
             *                              <li><strong>DELETE</strong> - Deletes a stack instance in the stack set represented by the provisioned product.</li>
             *                              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stackSetOperationType(java.lang.String stackSetOperationType) {
                this.stackSetOperationType = stackSetOperationType;
                return this;
            }

            /**
             * Sets the value of {@link ProvisioningPreferencesProperty#getStackSetRegions}
             * @param stackSetRegions One or more AWS Regions where the provisioned product will be available.
             *                        Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
             *                        <p>
             *                        The specified Regions should be within the list of Regions from the <code>STACKSET</code> constraint. To get the list of Regions in the <code>STACKSET</code> constraint, use the <code>DescribeProvisioningParameters</code> operation.
             *                        <p>
             *                        If no values are specified, the default value is all Regions from the <code>STACKSET</code> constraint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stackSetRegions(java.util.List<java.lang.String> stackSetRegions) {
                this.stackSetRegions = stackSetRegions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProvisioningPreferencesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProvisioningPreferencesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProvisioningPreferencesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProvisioningPreferencesProperty {
            private final java.util.List<java.lang.String> stackSetAccounts;
            private final java.lang.Number stackSetFailureToleranceCount;
            private final java.lang.Number stackSetFailureTolerancePercentage;
            private final java.lang.Number stackSetMaxConcurrencyCount;
            private final java.lang.Number stackSetMaxConcurrencyPercentage;
            private final java.lang.String stackSetOperationType;
            private final java.util.List<java.lang.String> stackSetRegions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.stackSetAccounts = software.amazon.jsii.Kernel.get(this, "stackSetAccounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.stackSetFailureToleranceCount = software.amazon.jsii.Kernel.get(this, "stackSetFailureToleranceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stackSetFailureTolerancePercentage = software.amazon.jsii.Kernel.get(this, "stackSetFailureTolerancePercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stackSetMaxConcurrencyCount = software.amazon.jsii.Kernel.get(this, "stackSetMaxConcurrencyCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stackSetMaxConcurrencyPercentage = software.amazon.jsii.Kernel.get(this, "stackSetMaxConcurrencyPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stackSetOperationType = software.amazon.jsii.Kernel.get(this, "stackSetOperationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stackSetRegions = software.amazon.jsii.Kernel.get(this, "stackSetRegions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.stackSetAccounts = builder.stackSetAccounts;
                this.stackSetFailureToleranceCount = builder.stackSetFailureToleranceCount;
                this.stackSetFailureTolerancePercentage = builder.stackSetFailureTolerancePercentage;
                this.stackSetMaxConcurrencyCount = builder.stackSetMaxConcurrencyCount;
                this.stackSetMaxConcurrencyPercentage = builder.stackSetMaxConcurrencyPercentage;
                this.stackSetOperationType = builder.stackSetOperationType;
                this.stackSetRegions = builder.stackSetRegions;
            }

            @Override
            public final java.util.List<java.lang.String> getStackSetAccounts() {
                return this.stackSetAccounts;
            }

            @Override
            public final java.lang.Number getStackSetFailureToleranceCount() {
                return this.stackSetFailureToleranceCount;
            }

            @Override
            public final java.lang.Number getStackSetFailureTolerancePercentage() {
                return this.stackSetFailureTolerancePercentage;
            }

            @Override
            public final java.lang.Number getStackSetMaxConcurrencyCount() {
                return this.stackSetMaxConcurrencyCount;
            }

            @Override
            public final java.lang.Number getStackSetMaxConcurrencyPercentage() {
                return this.stackSetMaxConcurrencyPercentage;
            }

            @Override
            public final java.lang.String getStackSetOperationType() {
                return this.stackSetOperationType;
            }

            @Override
            public final java.util.List<java.lang.String> getStackSetRegions() {
                return this.stackSetRegions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStackSetAccounts() != null) {
                    data.set("stackSetAccounts", om.valueToTree(this.getStackSetAccounts()));
                }
                if (this.getStackSetFailureToleranceCount() != null) {
                    data.set("stackSetFailureToleranceCount", om.valueToTree(this.getStackSetFailureToleranceCount()));
                }
                if (this.getStackSetFailureTolerancePercentage() != null) {
                    data.set("stackSetFailureTolerancePercentage", om.valueToTree(this.getStackSetFailureTolerancePercentage()));
                }
                if (this.getStackSetMaxConcurrencyCount() != null) {
                    data.set("stackSetMaxConcurrencyCount", om.valueToTree(this.getStackSetMaxConcurrencyCount()));
                }
                if (this.getStackSetMaxConcurrencyPercentage() != null) {
                    data.set("stackSetMaxConcurrencyPercentage", om.valueToTree(this.getStackSetMaxConcurrencyPercentage()));
                }
                if (this.getStackSetOperationType() != null) {
                    data.set("stackSetOperationType", om.valueToTree(this.getStackSetOperationType()));
                }
                if (this.getStackSetRegions() != null) {
                    data.set("stackSetRegions", om.valueToTree(this.getStackSetRegions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicecatalog.CfnCloudFormationProvisionedProduct.ProvisioningPreferencesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProvisioningPreferencesProperty.Jsii$Proxy that = (ProvisioningPreferencesProperty.Jsii$Proxy) o;

                if (this.stackSetAccounts != null ? !this.stackSetAccounts.equals(that.stackSetAccounts) : that.stackSetAccounts != null) return false;
                if (this.stackSetFailureToleranceCount != null ? !this.stackSetFailureToleranceCount.equals(that.stackSetFailureToleranceCount) : that.stackSetFailureToleranceCount != null) return false;
                if (this.stackSetFailureTolerancePercentage != null ? !this.stackSetFailureTolerancePercentage.equals(that.stackSetFailureTolerancePercentage) : that.stackSetFailureTolerancePercentage != null) return false;
                if (this.stackSetMaxConcurrencyCount != null ? !this.stackSetMaxConcurrencyCount.equals(that.stackSetMaxConcurrencyCount) : that.stackSetMaxConcurrencyCount != null) return false;
                if (this.stackSetMaxConcurrencyPercentage != null ? !this.stackSetMaxConcurrencyPercentage.equals(that.stackSetMaxConcurrencyPercentage) : that.stackSetMaxConcurrencyPercentage != null) return false;
                if (this.stackSetOperationType != null ? !this.stackSetOperationType.equals(that.stackSetOperationType) : that.stackSetOperationType != null) return false;
                return this.stackSetRegions != null ? this.stackSetRegions.equals(that.stackSetRegions) : that.stackSetRegions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.stackSetAccounts != null ? this.stackSetAccounts.hashCode() : 0;
                result = 31 * result + (this.stackSetFailureToleranceCount != null ? this.stackSetFailureToleranceCount.hashCode() : 0);
                result = 31 * result + (this.stackSetFailureTolerancePercentage != null ? this.stackSetFailureTolerancePercentage.hashCode() : 0);
                result = 31 * result + (this.stackSetMaxConcurrencyCount != null ? this.stackSetMaxConcurrencyCount.hashCode() : 0);
                result = 31 * result + (this.stackSetMaxConcurrencyPercentage != null ? this.stackSetMaxConcurrencyPercentage.hashCode() : 0);
                result = 31 * result + (this.stackSetOperationType != null ? this.stackSetOperationType.hashCode() : 0);
                result = 31 * result + (this.stackSetRegions != null ? this.stackSetRegions.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProvisionedProduct}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProvisionedProduct> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProvisionedProductProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The language code.
         * <p>
         * <ul>
         * <li><code>en</code> - English (default)</li>
         * <li><code>jp</code> - Japanese</li>
         * <li><code>zh</code> - Chinese</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param acceptLanguage The language code. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceptLanguage(final java.lang.String acceptLanguage) {
            this.props().acceptLanguage(acceptLanguage);
            return this;
        }

        /**
         * Passed to AWS CloudFormation .
         * <p>
         * The SNS topic ARNs to which to publish stack-related events.
         * <p>
         * @return {@code this}
         * @param notificationArns Passed to AWS CloudFormation . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationArns(final java.util.List<java.lang.String> notificationArns) {
            this.props().notificationArns(notificationArns);
            return this;
        }

        /**
         * The path identifier of the product.
         * <p>
         * This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <a href="https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListLaunchPaths.html">ListLaunchPaths</a> .
         * <p>
         * <blockquote>
         * <p>
         * You must provide the name or ID, but not both.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param pathId The path identifier of the product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathId(final java.lang.String pathId) {
            this.props().pathId(pathId);
            return this;
        }

        /**
         * The name of the path.
         * <p>
         * This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <a href="https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListLaunchPaths.html">ListLaunchPaths</a> .
         * <p>
         * <blockquote>
         * <p>
         * You must provide the name or ID, but not both.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param pathName The name of the path. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathName(final java.lang.String pathName) {
            this.props().pathName(pathName);
            return this;
        }

        /**
         * The product identifier.
         * <p>
         * <blockquote>
         * <p>
         * You must specify either the ID or the name of the product, but not both.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param productId The product identifier. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productId(final java.lang.String productId) {
            this.props().productId(productId);
            return this;
        }

        /**
         * A user-friendly name for the provisioned product.
         * <p>
         * This value must be unique for the AWS account and cannot be updated after the product is provisioned.
         * <p>
         * Each time a stack is created or updated, if <code>ProductName</code> is provided it will successfully resolve to <code>ProductId</code> as long as only one product exists in the account or Region with that <code>ProductName</code> .
         * <p>
         * <blockquote>
         * <p>
         * You must specify either the name or the ID of the product, but not both.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param productName A user-friendly name for the provisioned product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productName(final java.lang.String productName) {
            this.props().productName(productName);
            return this;
        }

        /**
         * A user-friendly name for the provisioned product.
         * <p>
         * This value must be unique for the AWS account and cannot be updated after the product is provisioned.
         * <p>
         * @return {@code this}
         * @param provisionedProductName A user-friendly name for the provisioned product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedProductName(final java.lang.String provisionedProductName) {
            this.props().provisionedProductName(provisionedProductName);
            return this;
        }

        /**
         * The identifier of the provisioning artifact (also known as a version).
         * <p>
         * <blockquote>
         * <p>
         * You must specify either the ID or the name of the provisioning artifact, but not both.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param provisioningArtifactId The identifier of the provisioning artifact (also known as a version). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisioningArtifactId(final java.lang.String provisioningArtifactId) {
            this.props().provisioningArtifactId(provisioningArtifactId);
            return this;
        }

        /**
         * The name of the provisioning artifact (also known as a version) for the product.
         * <p>
         * This name must be unique for the product.
         * <p>
         * <blockquote>
         * <p>
         * You must specify either the name or the ID of the provisioning artifact, but not both. You must also specify either the name or the ID of the product, but not both.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param provisioningArtifactName The name of the provisioning artifact (also known as a version) for the product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisioningArtifactName(final java.lang.String provisioningArtifactName) {
            this.props().provisioningArtifactName(provisioningArtifactName);
            return this;
        }

        /**
         * Parameters specified by the administrator that are required for provisioning the product.
         * <p>
         * @return {@code this}
         * @param provisioningParameters Parameters specified by the administrator that are required for provisioning the product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisioningParameters(final software.amazon.awscdk.core.IResolvable provisioningParameters) {
            this.props().provisioningParameters(provisioningParameters);
            return this;
        }
        /**
         * Parameters specified by the administrator that are required for provisioning the product.
         * <p>
         * @return {@code this}
         * @param provisioningParameters Parameters specified by the administrator that are required for provisioning the product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisioningParameters(final java.util.List<? extends java.lang.Object> provisioningParameters) {
            this.props().provisioningParameters(provisioningParameters);
            return this;
        }

        /**
         * StackSet preferences that are required for provisioning the product or updating a provisioned product.
         * <p>
         * @return {@code this}
         * @param provisioningPreferences StackSet preferences that are required for provisioning the product or updating a provisioned product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisioningPreferences(final software.amazon.awscdk.core.IResolvable provisioningPreferences) {
            this.props().provisioningPreferences(provisioningPreferences);
            return this;
        }
        /**
         * StackSet preferences that are required for provisioning the product or updating a provisioned product.
         * <p>
         * @return {@code this}
         * @param provisioningPreferences StackSet preferences that are required for provisioning the product or updating a provisioned product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisioningPreferences(final software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProvisionedProduct.ProvisioningPreferencesProperty provisioningPreferences) {
            this.props().provisioningPreferences(provisioningPreferences);
            return this;
        }

        /**
         * One or more tags.
         * <p>
         * <blockquote>
         * <p>
         * Requires the provisioned product to have an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-resourceupdateconstraint.html">ResourceUpdateConstraint</a> resource with <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates. If <code>RESOURCE_UPDATE</code> constraint is not present, tags updates are ignored.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param tags One or more tags. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProvisionedProduct}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProvisionedProduct build() {
            return new software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProvisionedProduct(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProvisionedProductProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProvisionedProductProps.Builder();
            }
            return this.props;
        }
    }
}
