package software.amazon.awscdk.services.servicecatalog;

/**
 * Properties for defining a `CfnStackSetConstraint`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.servicecatalog.*;
 * CfnStackSetConstraintProps cfnStackSetConstraintProps = CfnStackSetConstraintProps.builder()
 *         .accountList(List.of("accountList"))
 *         .adminRole("adminRole")
 *         .description("description")
 *         .executionRole("executionRole")
 *         .portfolioId("portfolioId")
 *         .productId("productId")
 *         .regionList(List.of("regionList"))
 *         .stackInstanceControl("stackInstanceControl")
 *         // the properties below are optional
 *         .acceptLanguage("acceptLanguage")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:44.150Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.CfnStackSetConstraintProps")
@software.amazon.jsii.Jsii.Proxy(CfnStackSetConstraintProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStackSetConstraintProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * One or more AWS accounts that will have access to the provisioned product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAccountList();

    /**
     * AdminRole ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAdminRole();

    /**
     * The description of the constraint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDescription();

    /**
     * ExecutionRole name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExecutionRole();

    /**
     * The portfolio identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPortfolioId();

    /**
     * The product identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProductId();

    /**
     * One or more AWS Regions where the provisioned product will be available.
     * <p>
     * Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
     * <p>
     * The specified Regions should be within the list of Regions from the <code>STACKSET</code> constraint. To get the list of Regions in the <code>STACKSET</code> constraint, use the <code>DescribeProvisioningParameters</code> operation.
     * <p>
     * If no values are specified, the default value is all Regions from the <code>STACKSET</code> constraint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getRegionList();

    /**
     * Permission to create, update, and delete stack instances.
     * <p>
     * Choose from ALLOWED and NOT_ALLOWED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStackInstanceControl();

    /**
     * The language code.
     * <p>
     * <ul>
     * <li><code>en</code> - English (default)</li>
     * <li><code>jp</code> - Japanese</li>
     * <li><code>zh</code> - Chinese</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAcceptLanguage() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStackSetConstraintProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStackSetConstraintProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStackSetConstraintProps> {
        java.util.List<java.lang.String> accountList;
        java.lang.String adminRole;
        java.lang.String description;
        java.lang.String executionRole;
        java.lang.String portfolioId;
        java.lang.String productId;
        java.util.List<java.lang.String> regionList;
        java.lang.String stackInstanceControl;
        java.lang.String acceptLanguage;

        /**
         * Sets the value of {@link CfnStackSetConstraintProps#getAccountList}
         * @param accountList One or more AWS accounts that will have access to the provisioned product. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountList(java.util.List<java.lang.String> accountList) {
            this.accountList = accountList;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetConstraintProps#getAdminRole}
         * @param adminRole AdminRole ARN. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminRole(java.lang.String adminRole) {
            this.adminRole = adminRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetConstraintProps#getDescription}
         * @param description The description of the constraint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetConstraintProps#getExecutionRole}
         * @param executionRole ExecutionRole name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(java.lang.String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetConstraintProps#getPortfolioId}
         * @param portfolioId The portfolio identifier. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portfolioId(java.lang.String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetConstraintProps#getProductId}
         * @param productId The product identifier. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productId(java.lang.String productId) {
            this.productId = productId;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetConstraintProps#getRegionList}
         * @param regionList One or more AWS Regions where the provisioned product will be available. This parameter is required.
         *                   Applicable only to a <code>CFN_STACKSET</code> provisioned product type.
         *                   <p>
         *                   The specified Regions should be within the list of Regions from the <code>STACKSET</code> constraint. To get the list of Regions in the <code>STACKSET</code> constraint, use the <code>DescribeProvisioningParameters</code> operation.
         *                   <p>
         *                   If no values are specified, the default value is all Regions from the <code>STACKSET</code> constraint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regionList(java.util.List<java.lang.String> regionList) {
            this.regionList = regionList;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetConstraintProps#getStackInstanceControl}
         * @param stackInstanceControl Permission to create, update, and delete stack instances. This parameter is required.
         *                             Choose from ALLOWED and NOT_ALLOWED.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackInstanceControl(java.lang.String stackInstanceControl) {
            this.stackInstanceControl = stackInstanceControl;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetConstraintProps#getAcceptLanguage}
         * @param acceptLanguage The language code.
         *                       <ul>
         *                       <li><code>en</code> - English (default)</li>
         *                       <li><code>jp</code> - Japanese</li>
         *                       <li><code>zh</code> - Chinese</li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceptLanguage(java.lang.String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStackSetConstraintProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStackSetConstraintProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStackSetConstraintProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStackSetConstraintProps {
        private final java.util.List<java.lang.String> accountList;
        private final java.lang.String adminRole;
        private final java.lang.String description;
        private final java.lang.String executionRole;
        private final java.lang.String portfolioId;
        private final java.lang.String productId;
        private final java.util.List<java.lang.String> regionList;
        private final java.lang.String stackInstanceControl;
        private final java.lang.String acceptLanguage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accountList = software.amazon.jsii.Kernel.get(this, "accountList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.adminRole = software.amazon.jsii.Kernel.get(this, "adminRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.portfolioId = software.amazon.jsii.Kernel.get(this, "portfolioId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.productId = software.amazon.jsii.Kernel.get(this, "productId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.regionList = software.amazon.jsii.Kernel.get(this, "regionList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.stackInstanceControl = software.amazon.jsii.Kernel.get(this, "stackInstanceControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.acceptLanguage = software.amazon.jsii.Kernel.get(this, "acceptLanguage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accountList = java.util.Objects.requireNonNull(builder.accountList, "accountList is required");
            this.adminRole = java.util.Objects.requireNonNull(builder.adminRole, "adminRole is required");
            this.description = java.util.Objects.requireNonNull(builder.description, "description is required");
            this.executionRole = java.util.Objects.requireNonNull(builder.executionRole, "executionRole is required");
            this.portfolioId = java.util.Objects.requireNonNull(builder.portfolioId, "portfolioId is required");
            this.productId = java.util.Objects.requireNonNull(builder.productId, "productId is required");
            this.regionList = java.util.Objects.requireNonNull(builder.regionList, "regionList is required");
            this.stackInstanceControl = java.util.Objects.requireNonNull(builder.stackInstanceControl, "stackInstanceControl is required");
            this.acceptLanguage = builder.acceptLanguage;
        }

        @Override
        public final java.util.List<java.lang.String> getAccountList() {
            return this.accountList;
        }

        @Override
        public final java.lang.String getAdminRole() {
            return this.adminRole;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getExecutionRole() {
            return this.executionRole;
        }

        @Override
        public final java.lang.String getPortfolioId() {
            return this.portfolioId;
        }

        @Override
        public final java.lang.String getProductId() {
            return this.productId;
        }

        @Override
        public final java.util.List<java.lang.String> getRegionList() {
            return this.regionList;
        }

        @Override
        public final java.lang.String getStackInstanceControl() {
            return this.stackInstanceControl;
        }

        @Override
        public final java.lang.String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accountList", om.valueToTree(this.getAccountList()));
            data.set("adminRole", om.valueToTree(this.getAdminRole()));
            data.set("description", om.valueToTree(this.getDescription()));
            data.set("executionRole", om.valueToTree(this.getExecutionRole()));
            data.set("portfolioId", om.valueToTree(this.getPortfolioId()));
            data.set("productId", om.valueToTree(this.getProductId()));
            data.set("regionList", om.valueToTree(this.getRegionList()));
            data.set("stackInstanceControl", om.valueToTree(this.getStackInstanceControl()));
            if (this.getAcceptLanguage() != null) {
                data.set("acceptLanguage", om.valueToTree(this.getAcceptLanguage()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicecatalog.CfnStackSetConstraintProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStackSetConstraintProps.Jsii$Proxy that = (CfnStackSetConstraintProps.Jsii$Proxy) o;

            if (!accountList.equals(that.accountList)) return false;
            if (!adminRole.equals(that.adminRole)) return false;
            if (!description.equals(that.description)) return false;
            if (!executionRole.equals(that.executionRole)) return false;
            if (!portfolioId.equals(that.portfolioId)) return false;
            if (!productId.equals(that.productId)) return false;
            if (!regionList.equals(that.regionList)) return false;
            if (!stackInstanceControl.equals(that.stackInstanceControl)) return false;
            return this.acceptLanguage != null ? this.acceptLanguage.equals(that.acceptLanguage) : that.acceptLanguage == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accountList.hashCode();
            result = 31 * result + (this.adminRole.hashCode());
            result = 31 * result + (this.description.hashCode());
            result = 31 * result + (this.executionRole.hashCode());
            result = 31 * result + (this.portfolioId.hashCode());
            result = 31 * result + (this.productId.hashCode());
            result = 31 * result + (this.regionList.hashCode());
            result = 31 * result + (this.stackInstanceControl.hashCode());
            result = 31 * result + (this.acceptLanguage != null ? this.acceptLanguage.hashCode() : 0);
            return result;
        }
    }
}
