package software.amazon.awscdk.services.servicecatalog;

/**
 * Defines a set of TagOptions, which are a list of key-value pairs managed in AWS Service Catalog.
 * <p>
 * It is not an AWS tag, but serves as a template for creating an AWS tag based on the TagOption.
 * See https://docs.aws.amazon.com/servicecatalog/latest/adminguide/tagoptions.html
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Portfolio portfolio;
 * CloudFormationProduct product;
 * TagOptions tagOptionsForPortfolio = TagOptions.Builder.create(this, "OrgTagOptions")
 *         .allowedValuesForTags(Map.of(
 *                 "Group", List.of("finance", "engineering", "marketing", "research"),
 *                 "CostCenter", List.of("01", "02", "03")))
 *         .build();
 * portfolio.associateTagOptions(tagOptionsForPortfolio);
 * TagOptions tagOptionsForProduct = TagOptions.Builder.create(this, "ProductTagOptions")
 *         .allowedValuesForTags(Map.of(
 *                 "Environment", List.of("dev", "alpha", "prod")))
 *         .build();
 * product.associateTagOptions(tagOptionsForProduct);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.73.0 (build 6faeda3)", date = "2023-01-25T18:29:03.940Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.TagOptions")
public class TagOptions extends software.amazon.awscdk.core.Resource {

    protected TagOptions(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TagOptions(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public TagOptions(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.TagOptionsProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.servicecatalog.TagOptions}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.servicecatalog.TagOptions> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.servicecatalog.TagOptionsProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.servicecatalog.TagOptionsProps.Builder();
        }

        /**
         * The values that are allowed to be set for specific tags.
         * <p>
         * The keys of the map represent the tag keys,
         * and the values of the map are a list of allowed values for that particular tag key.
         * <p>
         * @return {@code this}
         * @param allowedValuesForTags The values that are allowed to be set for specific tags. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedValuesForTags(final java.util.Map<java.lang.String, ? extends java.util.List<java.lang.String>> allowedValuesForTags) {
            this.props.allowedValuesForTags(allowedValuesForTags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.servicecatalog.TagOptions}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.servicecatalog.TagOptions build() {
            return new software.amazon.awscdk.services.servicecatalog.TagOptions(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
