package software.amazon.awscdk.services.servicecatalog;

/**
 * A Construct that contains a Service Catalog product stack with its previous deployments maintained.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.core.*;
 * public class S3BucketProduct extends ProductStack {
 *     public S3BucketProduct(Construct scope, String id) {
 *         super(scope, id);
 *         new Bucket(this, "BucketProductV2");
 *     }
 * }
 * ProductStackHistory productStackHistory = ProductStackHistory.Builder.create(this, "ProductStackHistory")
 *         .productStack(new S3BucketProduct(this, "S3BucketProduct"))
 *         .currentVersionName("v2")
 *         .currentVersionLocked(true)
 *         .build();
 * CloudFormationProduct product = CloudFormationProduct.Builder.create(this, "MyFirstProduct")
 *         .productName("My Product")
 *         .owner("Product Owner")
 *         .productVersions(List.of(productStackHistory.currentVersion()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-21T19:24:05.656Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.ProductStackHistory")
public class ProductStackHistory extends software.amazon.awscdk.core.Construct {

    protected ProductStackHistory(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ProductStackHistory(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ProductStackHistory(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.ProductStackHistoryProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Retains product stack template as a snapshot when deployed and retrieves a CloudFormationProductVersion for the current product version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion currentVersion() {
        return software.amazon.jsii.Kernel.call(this, "currentVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion.class));
    }

    /**
     * Retrieves a CloudFormationProductVersion from a previously deployed productVersionName.
     * <p>
     * @param productVersionName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion versionFromSnapshot(final @org.jetbrains.annotations.NotNull java.lang.String productVersionName) {
        return software.amazon.jsii.Kernel.call(this, "versionFromSnapshot", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion.class), new Object[] { java.util.Objects.requireNonNull(productVersionName, "productVersionName is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.servicecatalog.ProductStackHistory}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.servicecatalog.ProductStackHistory> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.servicecatalog.ProductStackHistoryProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.servicecatalog.ProductStackHistoryProps.Builder();
        }

        /**
         * If this is set to true, the ProductStack will not be overwritten if a snapshot is found for the currentVersionName.
         * <p>
         * @return {@code this}
         * @param currentVersionLocked If this is set to true, the ProductStack will not be overwritten if a snapshot is found for the currentVersionName. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder currentVersionLocked(final java.lang.Boolean currentVersionLocked) {
            this.props.currentVersionLocked(currentVersionLocked);
            return this;
        }

        /**
         * The current version name of the ProductStack.
         * <p>
         * @return {@code this}
         * @param currentVersionName The current version name of the ProductStack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder currentVersionName(final java.lang.String currentVersionName) {
            this.props.currentVersionName(currentVersionName);
            return this;
        }

        /**
         * The ProductStack whose history will be retained as a snapshot.
         * <p>
         * @return {@code this}
         * @param productStack The ProductStack whose history will be retained as a snapshot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productStack(final software.amazon.awscdk.services.servicecatalog.ProductStack productStack) {
            this.props.productStack(productStack);
            return this;
        }

        /**
         * The description of the product version.
         * <p>
         * Default: - No description provided
         * <p>
         * @return {@code this}
         * @param description The description of the product version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The directory where template snapshots will be stored.
         * <p>
         * Default: 'product-stack-snapshots'
         * <p>
         * @return {@code this}
         * @param directory The directory where template snapshots will be stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder directory(final java.lang.String directory) {
            this.props.directory(directory);
            return this;
        }

        /**
         * Whether the specified product template will be validated by CloudFormation.
         * <p>
         * If turned off, an invalid template configuration can be stored.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param validateTemplate Whether the specified product template will be validated by CloudFormation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validateTemplate(final java.lang.Boolean validateTemplate) {
            this.props.validateTemplate(validateTemplate);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.servicecatalog.ProductStackHistory}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.servicecatalog.ProductStackHistory build() {
            return new software.amazon.awscdk.services.servicecatalog.ProductStackHistory(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
