package software.amazon.awscdk.services.servicecatalog;

/**
 * A CloudFormation `AWS::ServiceCatalog::CloudFormationProduct`.
 * <p>
 * Specifies a product.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.servicecatalog.*;
 * Object info;
 * CfnCloudFormationProduct cfnCloudFormationProduct = CfnCloudFormationProduct.Builder.create(this, "MyCfnCloudFormationProduct")
 *         .name("name")
 *         .owner("owner")
 *         .provisioningArtifactParameters(List.of(ProvisioningArtifactPropertiesProperty.builder()
 *                 .info(info)
 *                 // the properties below are optional
 *                 .description("description")
 *                 .disableTemplateValidation(false)
 *                 .name("name")
 *                 .build()))
 *         // the properties below are optional
 *         .acceptLanguage("acceptLanguage")
 *         .description("description")
 *         .distributor("distributor")
 *         .replaceProvisioningArtifacts(false)
 *         .supportDescription("supportDescription")
 *         .supportEmail("supportEmail")
 *         .supportUrl("supportUrl")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-08T16:00:26.888Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.CfnCloudFormationProduct")
public class CfnCloudFormationProduct extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnCloudFormationProduct(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCloudFormationProduct(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProduct.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ServiceCatalog::CloudFormationProduct`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCloudFormationProduct(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProductProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The name of the product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrProductName() {
        return software.amazon.jsii.Kernel.get(this, "attrProductName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IDs of the provisioning artifacts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrProvisioningArtifactIds() {
        return software.amazon.jsii.Kernel.get(this, "attrProvisioningArtifactIds", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The names of the provisioning artifacts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrProvisioningArtifactNames() {
        return software.amazon.jsii.Kernel.get(this, "attrProvisioningArtifactNames", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * One or more tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The name of the product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The owner of the product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOwner() {
        return software.amazon.jsii.Kernel.get(this, "owner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The owner of the product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOwner(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "owner", java.util.Objects.requireNonNull(value, "owner is required"));
    }

    /**
     * The configuration of the provisioning artifact (also known as a version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getProvisioningArtifactParameters() {
        return software.amazon.jsii.Kernel.get(this, "provisioningArtifactParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of the provisioning artifact (also known as a version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisioningArtifactParameters(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "provisioningArtifactParameters", java.util.Objects.requireNonNull(value, "provisioningArtifactParameters is required"));
    }

    /**
     * The configuration of the provisioning artifact (also known as a version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisioningArtifactParameters(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProduct.ProvisioningArtifactPropertiesProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProduct.ProvisioningArtifactPropertiesProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "provisioningArtifactParameters", java.util.Objects.requireNonNull(value, "provisioningArtifactParameters is required"));
    }

    /**
     * The language code.
     * <p>
     * <ul>
     * <li><code>en</code> - English (default)</li>
     * <li><code>jp</code> - Japanese</li>
     * <li><code>zh</code> - Chinese</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAcceptLanguage() {
        return software.amazon.jsii.Kernel.get(this, "acceptLanguage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The language code.
     * <p>
     * <ul>
     * <li><code>en</code> - English (default)</li>
     * <li><code>jp</code> - Japanese</li>
     * <li><code>zh</code> - Chinese</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAcceptLanguage(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "acceptLanguage", value);
    }

    /**
     * The description of the product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The distributor of the product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDistributor() {
        return software.amazon.jsii.Kernel.get(this, "distributor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The distributor of the product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDistributor(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "distributor", value);
    }

    /**
     * This property is turned off by default.
     * <p>
     * If turned off, you can update provisioning artifacts or product attributes (such as description, distributor, name, owner, and more) and the associated provisioning artifacts will retain the same unique identifier. Provisioning artifacts are matched within the CloudFormationProduct resource, and only those that have been updated will be changed. Provisioning artifacts are matched by a combinaton of provisioning artifact template URL and name.
     * <p>
     * If turned on, provisioning artifacts will be given a new unique identifier when you update the product or provisioning artifacts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getReplaceProvisioningArtifacts() {
        return software.amazon.jsii.Kernel.get(this, "replaceProvisioningArtifacts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * This property is turned off by default.
     * <p>
     * If turned off, you can update provisioning artifacts or product attributes (such as description, distributor, name, owner, and more) and the associated provisioning artifacts will retain the same unique identifier. Provisioning artifacts are matched within the CloudFormationProduct resource, and only those that have been updated will be changed. Provisioning artifacts are matched by a combinaton of provisioning artifact template URL and name.
     * <p>
     * If turned on, provisioning artifacts will be given a new unique identifier when you update the product or provisioning artifacts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplaceProvisioningArtifacts(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "replaceProvisioningArtifacts", value);
    }

    /**
     * This property is turned off by default.
     * <p>
     * If turned off, you can update provisioning artifacts or product attributes (such as description, distributor, name, owner, and more) and the associated provisioning artifacts will retain the same unique identifier. Provisioning artifacts are matched within the CloudFormationProduct resource, and only those that have been updated will be changed. Provisioning artifacts are matched by a combinaton of provisioning artifact template URL and name.
     * <p>
     * If turned on, provisioning artifacts will be given a new unique identifier when you update the product or provisioning artifacts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplaceProvisioningArtifacts(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "replaceProvisioningArtifacts", value);
    }

    /**
     * The support information about the product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSupportDescription() {
        return software.amazon.jsii.Kernel.get(this, "supportDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The support information about the product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSupportDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "supportDescription", value);
    }

    /**
     * The contact email for product support.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSupportEmail() {
        return software.amazon.jsii.Kernel.get(this, "supportEmail", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The contact email for product support.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSupportEmail(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "supportEmail", value);
    }

    /**
     * The contact URL for product support.
     * <p>
     * <code>^https?:\/\//</code> / is the pattern used to validate SupportUrl.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSupportUrl() {
        return software.amazon.jsii.Kernel.get(this, "supportUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The contact URL for product support.
     * <p>
     * <code>^https?:\/\//</code> / is the pattern used to validate SupportUrl.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSupportUrl(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "supportUrl", value);
    }
    /**
     * Information about a provisioning artifact (also known as a version) for a product.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.servicecatalog.*;
     * Object info;
     * ProvisioningArtifactPropertiesProperty provisioningArtifactPropertiesProperty = ProvisioningArtifactPropertiesProperty.builder()
     *         .info(info)
     *         // the properties below are optional
     *         .description("description")
     *         .disableTemplateValidation(false)
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.CfnCloudFormationProduct.ProvisioningArtifactPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ProvisioningArtifactPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProvisioningArtifactPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specify the template source with one of the following options, but not both.
         * <p>
         * Keys accepted: [ <code>LoadTemplateFromURL</code> , <code>ImportFromPhysicalId</code> ]
         * <p>
         * The URL of the AWS CloudFormation template in Amazon S3 in JSON format. Specify the URL in JSON format as follows:
         * <p>
         * <code>"LoadTemplateFromURL": "https://s3.amazonaws.com/cf-templates-ozkq9d3hgiq2-us-east-1/..."</code>
         * <p>
         * <code>ImportFromPhysicalId</code> : The physical id of the resource that contains the template. Currently only supports AWS CloudFormation stack arn. Specify the physical id in JSON format as follows: <code>ImportFromPhysicalId: “arn:aws:cloudformation:[us-east-1]:[accountId]:stack/[StackName]/[resourceId]</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getInfo();

        /**
         * The description of the provisioning artifact, including how it differs from the previous provisioning artifact.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * If set to true, AWS Service Catalog stops validating the specified provisioning artifact even if it is invalid.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableTemplateValidation() {
            return null;
        }

        /**
         * The name of the provisioning artifact (for example, v1 v2beta).
         * <p>
         * No spaces are allowed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProvisioningArtifactPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProvisioningArtifactPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProvisioningArtifactPropertiesProperty> {
            java.lang.Object info;
            java.lang.String description;
            java.lang.Object disableTemplateValidation;
            java.lang.String name;

            /**
             * Sets the value of {@link ProvisioningArtifactPropertiesProperty#getInfo}
             * @param info Specify the template source with one of the following options, but not both. This parameter is required.
             *             Keys accepted: [ <code>LoadTemplateFromURL</code> , <code>ImportFromPhysicalId</code> ]
             *             <p>
             *             The URL of the AWS CloudFormation template in Amazon S3 in JSON format. Specify the URL in JSON format as follows:
             *             <p>
             *             <code>"LoadTemplateFromURL": "https://s3.amazonaws.com/cf-templates-ozkq9d3hgiq2-us-east-1/..."</code>
             *             <p>
             *             <code>ImportFromPhysicalId</code> : The physical id of the resource that contains the template. Currently only supports AWS CloudFormation stack arn. Specify the physical id in JSON format as follows: <code>ImportFromPhysicalId: “arn:aws:cloudformation:[us-east-1]:[accountId]:stack/[StackName]/[resourceId]</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder info(java.lang.Object info) {
                this.info = info;
                return this;
            }

            /**
             * Sets the value of {@link ProvisioningArtifactPropertiesProperty#getDescription}
             * @param description The description of the provisioning artifact, including how it differs from the previous provisioning artifact.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link ProvisioningArtifactPropertiesProperty#getDisableTemplateValidation}
             * @param disableTemplateValidation If set to true, AWS Service Catalog stops validating the specified provisioning artifact even if it is invalid.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableTemplateValidation(java.lang.Boolean disableTemplateValidation) {
                this.disableTemplateValidation = disableTemplateValidation;
                return this;
            }

            /**
             * Sets the value of {@link ProvisioningArtifactPropertiesProperty#getDisableTemplateValidation}
             * @param disableTemplateValidation If set to true, AWS Service Catalog stops validating the specified provisioning artifact even if it is invalid.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableTemplateValidation(software.amazon.awscdk.core.IResolvable disableTemplateValidation) {
                this.disableTemplateValidation = disableTemplateValidation;
                return this;
            }

            /**
             * Sets the value of {@link ProvisioningArtifactPropertiesProperty#getName}
             * @param name The name of the provisioning artifact (for example, v1 v2beta).
             *             No spaces are allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProvisioningArtifactPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProvisioningArtifactPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProvisioningArtifactPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProvisioningArtifactPropertiesProperty {
            private final java.lang.Object info;
            private final java.lang.String description;
            private final java.lang.Object disableTemplateValidation;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.info = software.amazon.jsii.Kernel.get(this, "info", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.disableTemplateValidation = software.amazon.jsii.Kernel.get(this, "disableTemplateValidation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.info = java.util.Objects.requireNonNull(builder.info, "info is required");
                this.description = builder.description;
                this.disableTemplateValidation = builder.disableTemplateValidation;
                this.name = builder.name;
            }

            @Override
            public final java.lang.Object getInfo() {
                return this.info;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getDisableTemplateValidation() {
                return this.disableTemplateValidation;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("info", om.valueToTree(this.getInfo()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getDisableTemplateValidation() != null) {
                    data.set("disableTemplateValidation", om.valueToTree(this.getDisableTemplateValidation()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicecatalog.CfnCloudFormationProduct.ProvisioningArtifactPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProvisioningArtifactPropertiesProperty.Jsii$Proxy that = (ProvisioningArtifactPropertiesProperty.Jsii$Proxy) o;

                if (!info.equals(that.info)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.disableTemplateValidation != null ? !this.disableTemplateValidation.equals(that.disableTemplateValidation) : that.disableTemplateValidation != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.info.hashCode();
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.disableTemplateValidation != null ? this.disableTemplateValidation.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProduct}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProduct> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProductProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProductProps.Builder();
        }

        /**
         * The name of the product.
         * <p>
         * @return {@code this}
         * @param name The name of the product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The owner of the product.
         * <p>
         * @return {@code this}
         * @param owner The owner of the product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder owner(final java.lang.String owner) {
            this.props.owner(owner);
            return this;
        }

        /**
         * The configuration of the provisioning artifact (also known as a version).
         * <p>
         * @return {@code this}
         * @param provisioningArtifactParameters The configuration of the provisioning artifact (also known as a version). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisioningArtifactParameters(final software.amazon.awscdk.core.IResolvable provisioningArtifactParameters) {
            this.props.provisioningArtifactParameters(provisioningArtifactParameters);
            return this;
        }
        /**
         * The configuration of the provisioning artifact (also known as a version).
         * <p>
         * @return {@code this}
         * @param provisioningArtifactParameters The configuration of the provisioning artifact (also known as a version). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisioningArtifactParameters(final java.util.List<? extends java.lang.Object> provisioningArtifactParameters) {
            this.props.provisioningArtifactParameters(provisioningArtifactParameters);
            return this;
        }

        /**
         * The language code.
         * <p>
         * <ul>
         * <li><code>en</code> - English (default)</li>
         * <li><code>jp</code> - Japanese</li>
         * <li><code>zh</code> - Chinese</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param acceptLanguage The language code. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceptLanguage(final java.lang.String acceptLanguage) {
            this.props.acceptLanguage(acceptLanguage);
            return this;
        }

        /**
         * The description of the product.
         * <p>
         * @return {@code this}
         * @param description The description of the product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The distributor of the product.
         * <p>
         * @return {@code this}
         * @param distributor The distributor of the product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributor(final java.lang.String distributor) {
            this.props.distributor(distributor);
            return this;
        }

        /**
         * This property is turned off by default.
         * <p>
         * If turned off, you can update provisioning artifacts or product attributes (such as description, distributor, name, owner, and more) and the associated provisioning artifacts will retain the same unique identifier. Provisioning artifacts are matched within the CloudFormationProduct resource, and only those that have been updated will be changed. Provisioning artifacts are matched by a combinaton of provisioning artifact template URL and name.
         * <p>
         * If turned on, provisioning artifacts will be given a new unique identifier when you update the product or provisioning artifacts.
         * <p>
         * @return {@code this}
         * @param replaceProvisioningArtifacts This property is turned off by default. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceProvisioningArtifacts(final java.lang.Boolean replaceProvisioningArtifacts) {
            this.props.replaceProvisioningArtifacts(replaceProvisioningArtifacts);
            return this;
        }
        /**
         * This property is turned off by default.
         * <p>
         * If turned off, you can update provisioning artifacts or product attributes (such as description, distributor, name, owner, and more) and the associated provisioning artifacts will retain the same unique identifier. Provisioning artifacts are matched within the CloudFormationProduct resource, and only those that have been updated will be changed. Provisioning artifacts are matched by a combinaton of provisioning artifact template URL and name.
         * <p>
         * If turned on, provisioning artifacts will be given a new unique identifier when you update the product or provisioning artifacts.
         * <p>
         * @return {@code this}
         * @param replaceProvisioningArtifacts This property is turned off by default. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceProvisioningArtifacts(final software.amazon.awscdk.core.IResolvable replaceProvisioningArtifacts) {
            this.props.replaceProvisioningArtifacts(replaceProvisioningArtifacts);
            return this;
        }

        /**
         * The support information about the product.
         * <p>
         * @return {@code this}
         * @param supportDescription The support information about the product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportDescription(final java.lang.String supportDescription) {
            this.props.supportDescription(supportDescription);
            return this;
        }

        /**
         * The contact email for product support.
         * <p>
         * @return {@code this}
         * @param supportEmail The contact email for product support. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportEmail(final java.lang.String supportEmail) {
            this.props.supportEmail(supportEmail);
            return this;
        }

        /**
         * The contact URL for product support.
         * <p>
         * <code>^https?:\/\//</code> / is the pattern used to validate SupportUrl.
         * <p>
         * @return {@code this}
         * @param supportUrl The contact URL for product support. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportUrl(final java.lang.String supportUrl) {
            this.props.supportUrl(supportUrl);
            return this;
        }

        /**
         * One or more tags.
         * <p>
         * @return {@code this}
         * @param tags One or more tags. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProduct}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProduct build() {
            return new software.amazon.awscdk.services.servicecatalog.CfnCloudFormationProduct(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
