package software.amazon.awscdk.services.servicecatalog;

/**
 * Properties of product version (also known as a provisioning artifact).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.servicecatalog.*;
 * CloudFormationTemplate cloudFormationTemplate;
 * CloudFormationProductVersion cloudFormationProductVersion = CloudFormationProductVersion.builder()
 *         .cloudFormationTemplate(cloudFormationTemplate)
 *         // the properties below are optional
 *         .description("description")
 *         .productVersionName("productVersionName")
 *         .validateTemplate(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-05-10T17:05:55.699Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.CloudFormationProductVersion")
@software.amazon.jsii.Jsii.Proxy(CloudFormationProductVersion.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CloudFormationProductVersion extends software.amazon.jsii.JsiiSerializable {

    /**
     * The S3 template that points to the provisioning version template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.CloudFormationTemplate getCloudFormationTemplate();

    /**
     * The description of the product version.
     * <p>
     * Default: - No description provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The name of the product version.
     * <p>
     * Default: - No product version name provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProductVersionName() {
        return null;
    }

    /**
     * Whether the specified product template will be validated by CloudFormation.
     * <p>
     * If turned off, an invalid template configuration can be stored.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getValidateTemplate() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CloudFormationProductVersion}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CloudFormationProductVersion}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CloudFormationProductVersion> {
        software.amazon.awscdk.services.servicecatalog.CloudFormationTemplate cloudFormationTemplate;
        java.lang.String description;
        java.lang.String productVersionName;
        java.lang.Boolean validateTemplate;

        /**
         * Sets the value of {@link CloudFormationProductVersion#getCloudFormationTemplate}
         * @param cloudFormationTemplate The S3 template that points to the provisioning version template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudFormationTemplate(software.amazon.awscdk.services.servicecatalog.CloudFormationTemplate cloudFormationTemplate) {
            this.cloudFormationTemplate = cloudFormationTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationProductVersion#getDescription}
         * @param description The description of the product version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationProductVersion#getProductVersionName}
         * @param productVersionName The name of the product version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productVersionName(java.lang.String productVersionName) {
            this.productVersionName = productVersionName;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationProductVersion#getValidateTemplate}
         * @param validateTemplate Whether the specified product template will be validated by CloudFormation.
         *                         If turned off, an invalid template configuration can be stored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validateTemplate(java.lang.Boolean validateTemplate) {
            this.validateTemplate = validateTemplate;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CloudFormationProductVersion}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CloudFormationProductVersion build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CloudFormationProductVersion}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudFormationProductVersion {
        private final software.amazon.awscdk.services.servicecatalog.CloudFormationTemplate cloudFormationTemplate;
        private final java.lang.String description;
        private final java.lang.String productVersionName;
        private final java.lang.Boolean validateTemplate;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cloudFormationTemplate = software.amazon.jsii.Kernel.get(this, "cloudFormationTemplate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalog.CloudFormationTemplate.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.productVersionName = software.amazon.jsii.Kernel.get(this, "productVersionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.validateTemplate = software.amazon.jsii.Kernel.get(this, "validateTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cloudFormationTemplate = java.util.Objects.requireNonNull(builder.cloudFormationTemplate, "cloudFormationTemplate is required");
            this.description = builder.description;
            this.productVersionName = builder.productVersionName;
            this.validateTemplate = builder.validateTemplate;
        }

        @Override
        public final software.amazon.awscdk.services.servicecatalog.CloudFormationTemplate getCloudFormationTemplate() {
            return this.cloudFormationTemplate;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getProductVersionName() {
            return this.productVersionName;
        }

        @Override
        public final java.lang.Boolean getValidateTemplate() {
            return this.validateTemplate;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cloudFormationTemplate", om.valueToTree(this.getCloudFormationTemplate()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getProductVersionName() != null) {
                data.set("productVersionName", om.valueToTree(this.getProductVersionName()));
            }
            if (this.getValidateTemplate() != null) {
                data.set("validateTemplate", om.valueToTree(this.getValidateTemplate()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicecatalog.CloudFormationProductVersion"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CloudFormationProductVersion.Jsii$Proxy that = (CloudFormationProductVersion.Jsii$Proxy) o;

            if (!cloudFormationTemplate.equals(that.cloudFormationTemplate)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.productVersionName != null ? !this.productVersionName.equals(that.productVersionName) : that.productVersionName != null) return false;
            return this.validateTemplate != null ? this.validateTemplate.equals(that.validateTemplate) : that.validateTemplate == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cloudFormationTemplate.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.productVersionName != null ? this.productVersionName.hashCode() : 0);
            result = 31 * result + (this.validateTemplate != null ? this.validateTemplate.hashCode() : 0);
            return result;
        }
    }
}
