package software.amazon.awscdk.services.servicecatalog;

/**
 * Properties for defining a `CfnLaunchRoleConstraint`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.servicecatalog.*;
 * CfnLaunchRoleConstraintProps cfnLaunchRoleConstraintProps = CfnLaunchRoleConstraintProps.builder()
 *         .portfolioId("portfolioId")
 *         .productId("productId")
 *         // the properties below are optional
 *         .acceptLanguage("acceptLanguage")
 *         .description("description")
 *         .localRoleName("localRoleName")
 *         .roleArn("roleArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-05-31T18:44:11.400Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.CfnLaunchRoleConstraintProps")
@software.amazon.jsii.Jsii.Proxy(CfnLaunchRoleConstraintProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLaunchRoleConstraintProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The portfolio identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPortfolioId();

    /**
     * The product identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProductId();

    /**
     * The language code.
     * <p>
     * <ul>
     * <li><code>jp</code> - Japanese</li>
     * <li><code>zh</code> - Chinese</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAcceptLanguage() {
        return null;
    }

    /**
     * The description of the constraint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * You are required to specify either the `RoleArn` or the `LocalRoleName` but can't use both.
     * <p>
     * If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the IAM role with that name in the account will be used. This allows launch-role constraints to be account-agnostic so the administrator can create fewer resources per shared account.
     * <p>
     * The given role name must exist in the account used to create the launch constraint and the account of the user who launches a product with this launch constraint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLocalRoleName() {
        return null;
    }

    /**
     * The ARN of the launch role.
     * <p>
     * You are required to specify <code>RoleArn</code> or <code>LocalRoleName</code> but can't use both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLaunchRoleConstraintProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLaunchRoleConstraintProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLaunchRoleConstraintProps> {
        java.lang.String portfolioId;
        java.lang.String productId;
        java.lang.String acceptLanguage;
        java.lang.String description;
        java.lang.String localRoleName;
        java.lang.String roleArn;

        /**
         * Sets the value of {@link CfnLaunchRoleConstraintProps#getPortfolioId}
         * @param portfolioId The portfolio identifier. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portfolioId(java.lang.String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchRoleConstraintProps#getProductId}
         * @param productId The product identifier. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productId(java.lang.String productId) {
            this.productId = productId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchRoleConstraintProps#getAcceptLanguage}
         * @param acceptLanguage The language code.
         *                       <ul>
         *                       <li><code>jp</code> - Japanese</li>
         *                       <li><code>zh</code> - Chinese</li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceptLanguage(java.lang.String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchRoleConstraintProps#getDescription}
         * @param description The description of the constraint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchRoleConstraintProps#getLocalRoleName}
         * @param localRoleName You are required to specify either the `RoleArn` or the `LocalRoleName` but can't use both.
         *                      If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the IAM role with that name in the account will be used. This allows launch-role constraints to be account-agnostic so the administrator can create fewer resources per shared account.
         *                      <p>
         *                      The given role name must exist in the account used to create the launch constraint and the account of the user who launches a product with this launch constraint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localRoleName(java.lang.String localRoleName) {
            this.localRoleName = localRoleName;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchRoleConstraintProps#getRoleArn}
         * @param roleArn The ARN of the launch role.
         *                You are required to specify <code>RoleArn</code> or <code>LocalRoleName</code> but can't use both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLaunchRoleConstraintProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLaunchRoleConstraintProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLaunchRoleConstraintProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLaunchRoleConstraintProps {
        private final java.lang.String portfolioId;
        private final java.lang.String productId;
        private final java.lang.String acceptLanguage;
        private final java.lang.String description;
        private final java.lang.String localRoleName;
        private final java.lang.String roleArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.portfolioId = software.amazon.jsii.Kernel.get(this, "portfolioId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.productId = software.amazon.jsii.Kernel.get(this, "productId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.acceptLanguage = software.amazon.jsii.Kernel.get(this, "acceptLanguage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.localRoleName = software.amazon.jsii.Kernel.get(this, "localRoleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.portfolioId = java.util.Objects.requireNonNull(builder.portfolioId, "portfolioId is required");
            this.productId = java.util.Objects.requireNonNull(builder.productId, "productId is required");
            this.acceptLanguage = builder.acceptLanguage;
            this.description = builder.description;
            this.localRoleName = builder.localRoleName;
            this.roleArn = builder.roleArn;
        }

        @Override
        public final java.lang.String getPortfolioId() {
            return this.portfolioId;
        }

        @Override
        public final java.lang.String getProductId() {
            return this.productId;
        }

        @Override
        public final java.lang.String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getLocalRoleName() {
            return this.localRoleName;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("portfolioId", om.valueToTree(this.getPortfolioId()));
            data.set("productId", om.valueToTree(this.getProductId()));
            if (this.getAcceptLanguage() != null) {
                data.set("acceptLanguage", om.valueToTree(this.getAcceptLanguage()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getLocalRoleName() != null) {
                data.set("localRoleName", om.valueToTree(this.getLocalRoleName()));
            }
            if (this.getRoleArn() != null) {
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicecatalog.CfnLaunchRoleConstraintProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLaunchRoleConstraintProps.Jsii$Proxy that = (CfnLaunchRoleConstraintProps.Jsii$Proxy) o;

            if (!portfolioId.equals(that.portfolioId)) return false;
            if (!productId.equals(that.productId)) return false;
            if (this.acceptLanguage != null ? !this.acceptLanguage.equals(that.acceptLanguage) : that.acceptLanguage != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.localRoleName != null ? !this.localRoleName.equals(that.localRoleName) : that.localRoleName != null) return false;
            return this.roleArn != null ? this.roleArn.equals(that.roleArn) : that.roleArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.portfolioId.hashCode();
            result = 31 * result + (this.productId.hashCode());
            result = 31 * result + (this.acceptLanguage != null ? this.acceptLanguage.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.localRoleName != null ? this.localRoleName.hashCode() : 0);
            result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
            return result;
        }
    }
}
