package software.amazon.awscdk.services.servicecatalog;

/**
 * A Service Catalog portfolio.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-05-31T18:44:11.453Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.IPortfolio")
@software.amazon.jsii.Jsii.Proxy(IPortfolio.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IPortfolio extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.IResource {

    /**
     * The ARN of the portfolio.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPortfolioArn();

    /**
     * The ID of the portfolio.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPortfolioId();

    /**
     * Associate portfolio with the given product.
     * <p>
     * @param product A service catalog produt. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addProduct(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product);

    /**
     * Associate Tag Options.
     * <p>
     * A TagOption is a key-value pair managed in AWS Service Catalog.
     * It is not an AWS tag, but serves as a template for creating an AWS tag based on the TagOption.
     * <p>
     * @param tagOptions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void associateTagOptions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.TagOptions tagOptions);

    /**
     * Set provisioning rules for the product.
     * <p>
     * @param product A service catalog product. This parameter is required.
     * @param options options for the constraint. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void constrainCloudFormationParameters(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.CloudFormationRuleConstraintOptions options);

    /**
     * Add a Resource Update Constraint.
     * <p>
     * @param product This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void constrainTagUpdates(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.TagUpdateConstraintOptions options);

    /**
     * Add a Resource Update Constraint.
     * <p>
     * @param product This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void constrainTagUpdates(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product);

    /**
     * Configure deployment options using AWS Cloudformation StackSets.
     * <p>
     * @param product A service catalog product. This parameter is required.
     * @param options Configuration options for the constraint. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void deployWithStackSets(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.StackSetsConstraintOptions options);

    /**
     * Associate portfolio with an IAM Group.
     * <p>
     * @param group an IAM Group. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void giveAccessToGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGroup group);

    /**
     * Associate portfolio with an IAM Role.
     * <p>
     * @param role an IAM role. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void giveAccessToRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole role);

    /**
     * Associate portfolio with an IAM User.
     * <p>
     * @param user an IAM user. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void giveAccessToUser(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IUser user);

    /**
     * Add notifications for supplied topics on the provisioned product.
     * <p>
     * @param product A service catalog product. This parameter is required.
     * @param topic A SNS Topic to receive notifications on events related to the provisioned product. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void notifyOnStackEvents(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic topic, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.CommonConstraintOptions options);

    /**
     * Add notifications for supplied topics on the provisioned product.
     * <p>
     * @param product A service catalog product. This parameter is required.
     * @param topic A SNS Topic to receive notifications on events related to the provisioned product. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void notifyOnStackEvents(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic topic);

    /**
     * Force users to assume a certain role when launching a product.
     * <p>
     * This sets the launch role using the role arn which is tied to the account this role exists in.
     * This is useful if you will be provisioning products from the account where this role exists.
     * If you intend to share the portfolio across accounts, use a local launch role.
     * <p>
     * @param product A service catalog product. This parameter is required.
     * @param launchRole The IAM role a user must assume when provisioning the product. This parameter is required.
     * @param options options for the constraint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void setLaunchRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole launchRole, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.CommonConstraintOptions options);

    /**
     * Force users to assume a certain role when launching a product.
     * <p>
     * This sets the launch role using the role arn which is tied to the account this role exists in.
     * This is useful if you will be provisioning products from the account where this role exists.
     * If you intend to share the portfolio across accounts, use a local launch role.
     * <p>
     * @param product A service catalog product. This parameter is required.
     * @param launchRole The IAM role a user must assume when provisioning the product. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void setLaunchRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole launchRole);

    /**
     * Force users to assume a certain role when launching a product.
     * <p>
     * The role name will be referenced by in the local account and must be set explicitly.
     * This is useful when sharing the portfolio with multiple accounts.
     * <p>
     * @param product A service catalog product. This parameter is required.
     * @param launchRole The IAM role a user must assume when provisioning the product. This parameter is required.
     * @param options options for the constraint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void setLocalLaunchRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole launchRole, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.CommonConstraintOptions options);

    /**
     * Force users to assume a certain role when launching a product.
     * <p>
     * The role name will be referenced by in the local account and must be set explicitly.
     * This is useful when sharing the portfolio with multiple accounts.
     * <p>
     * @param product A service catalog product. This parameter is required.
     * @param launchRole The IAM role a user must assume when provisioning the product. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void setLocalLaunchRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole launchRole);

    /**
     * Force users to assume a certain role when launching a product.
     * <p>
     * The role will be referenced by name in the local account instead of a static role arn.
     * A role with this name will automatically be created and assumable by Service Catalog in this account.
     * This is useful when sharing the portfolio with multiple accounts.
     * <p>
     * @param product A service catalog product. This parameter is required.
     * @param launchRoleName The name of the IAM role a user must assume when provisioning the product. This parameter is required.
     * @param options options for the constraint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole setLocalLaunchRoleName(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull java.lang.String launchRoleName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.CommonConstraintOptions options);

    /**
     * Force users to assume a certain role when launching a product.
     * <p>
     * The role will be referenced by name in the local account instead of a static role arn.
     * A role with this name will automatically be created and assumable by Service Catalog in this account.
     * This is useful when sharing the portfolio with multiple accounts.
     * <p>
     * @param product A service catalog product. This parameter is required.
     * @param launchRoleName The name of the IAM role a user must assume when provisioning the product. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole setLocalLaunchRoleName(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull java.lang.String launchRoleName);

    /**
     * Initiate a portfolio share with another account.
     * <p>
     * @param accountId AWS account to share portfolio with. This parameter is required.
     * @param options Options for the initiate share.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void shareWithAccount(final @org.jetbrains.annotations.NotNull java.lang.String accountId, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.PortfolioShareOptions options);

    /**
     * Initiate a portfolio share with another account.
     * <p>
     * @param accountId AWS account to share portfolio with. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void shareWithAccount(final @org.jetbrains.annotations.NotNull java.lang.String accountId);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.servicecatalog.IPortfolio.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
        }

        /**
         * The ARN of the portfolio.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getPortfolioArn() {
            return software.amazon.jsii.Kernel.get(this, "portfolioArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The ID of the portfolio.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getPortfolioId() {
            return software.amazon.jsii.Kernel.get(this, "portfolioId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Associate portfolio with the given product.
         * <p>
         * @param product A service catalog produt. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addProduct(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product) {
            software.amazon.jsii.Kernel.call(this, "addProduct", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required") });
        }

        /**
         * Associate Tag Options.
         * <p>
         * A TagOption is a key-value pair managed in AWS Service Catalog.
         * It is not an AWS tag, but serves as a template for creating an AWS tag based on the TagOption.
         * <p>
         * @param tagOptions This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void associateTagOptions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.TagOptions tagOptions) {
            software.amazon.jsii.Kernel.call(this, "associateTagOptions", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(tagOptions, "tagOptions is required") });
        }

        /**
         * Set provisioning rules for the product.
         * <p>
         * @param product A service catalog product. This parameter is required.
         * @param options options for the constraint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void constrainCloudFormationParameters(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.CloudFormationRuleConstraintOptions options) {
            software.amazon.jsii.Kernel.call(this, "constrainCloudFormationParameters", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }

        /**
         * Add a Resource Update Constraint.
         * <p>
         * @param product This parameter is required.
         * @param options
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void constrainTagUpdates(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.TagUpdateConstraintOptions options) {
            software.amazon.jsii.Kernel.call(this, "constrainTagUpdates", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), options });
        }

        /**
         * Add a Resource Update Constraint.
         * <p>
         * @param product This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void constrainTagUpdates(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product) {
            software.amazon.jsii.Kernel.call(this, "constrainTagUpdates", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required") });
        }

        /**
         * Configure deployment options using AWS Cloudformation StackSets.
         * <p>
         * @param product A service catalog product. This parameter is required.
         * @param options Configuration options for the constraint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void deployWithStackSets(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.StackSetsConstraintOptions options) {
            software.amazon.jsii.Kernel.call(this, "deployWithStackSets", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }

        /**
         * Associate portfolio with an IAM Group.
         * <p>
         * @param group an IAM Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void giveAccessToGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGroup group) {
            software.amazon.jsii.Kernel.call(this, "giveAccessToGroup", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(group, "group is required") });
        }

        /**
         * Associate portfolio with an IAM Role.
         * <p>
         * @param role an IAM role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void giveAccessToRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole role) {
            software.amazon.jsii.Kernel.call(this, "giveAccessToRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(role, "role is required") });
        }

        /**
         * Associate portfolio with an IAM User.
         * <p>
         * @param user an IAM user. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void giveAccessToUser(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IUser user) {
            software.amazon.jsii.Kernel.call(this, "giveAccessToUser", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(user, "user is required") });
        }

        /**
         * Add notifications for supplied topics on the provisioned product.
         * <p>
         * @param product A service catalog product. This parameter is required.
         * @param topic A SNS Topic to receive notifications on events related to the provisioned product. This parameter is required.
         * @param options
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void notifyOnStackEvents(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic topic, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.CommonConstraintOptions options) {
            software.amazon.jsii.Kernel.call(this, "notifyOnStackEvents", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(topic, "topic is required"), options });
        }

        /**
         * Add notifications for supplied topics on the provisioned product.
         * <p>
         * @param product A service catalog product. This parameter is required.
         * @param topic A SNS Topic to receive notifications on events related to the provisioned product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void notifyOnStackEvents(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic topic) {
            software.amazon.jsii.Kernel.call(this, "notifyOnStackEvents", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(topic, "topic is required") });
        }

        /**
         * Force users to assume a certain role when launching a product.
         * <p>
         * This sets the launch role using the role arn which is tied to the account this role exists in.
         * This is useful if you will be provisioning products from the account where this role exists.
         * If you intend to share the portfolio across accounts, use a local launch role.
         * <p>
         * @param product A service catalog product. This parameter is required.
         * @param launchRole The IAM role a user must assume when provisioning the product. This parameter is required.
         * @param options options for the constraint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void setLaunchRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole launchRole, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.CommonConstraintOptions options) {
            software.amazon.jsii.Kernel.call(this, "setLaunchRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(launchRole, "launchRole is required"), options });
        }

        /**
         * Force users to assume a certain role when launching a product.
         * <p>
         * This sets the launch role using the role arn which is tied to the account this role exists in.
         * This is useful if you will be provisioning products from the account where this role exists.
         * If you intend to share the portfolio across accounts, use a local launch role.
         * <p>
         * @param product A service catalog product. This parameter is required.
         * @param launchRole The IAM role a user must assume when provisioning the product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void setLaunchRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole launchRole) {
            software.amazon.jsii.Kernel.call(this, "setLaunchRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(launchRole, "launchRole is required") });
        }

        /**
         * Force users to assume a certain role when launching a product.
         * <p>
         * The role name will be referenced by in the local account and must be set explicitly.
         * This is useful when sharing the portfolio with multiple accounts.
         * <p>
         * @param product A service catalog product. This parameter is required.
         * @param launchRole The IAM role a user must assume when provisioning the product. This parameter is required.
         * @param options options for the constraint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void setLocalLaunchRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole launchRole, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.CommonConstraintOptions options) {
            software.amazon.jsii.Kernel.call(this, "setLocalLaunchRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(launchRole, "launchRole is required"), options });
        }

        /**
         * Force users to assume a certain role when launching a product.
         * <p>
         * The role name will be referenced by in the local account and must be set explicitly.
         * This is useful when sharing the portfolio with multiple accounts.
         * <p>
         * @param product A service catalog product. This parameter is required.
         * @param launchRole The IAM role a user must assume when provisioning the product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void setLocalLaunchRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole launchRole) {
            software.amazon.jsii.Kernel.call(this, "setLocalLaunchRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(launchRole, "launchRole is required") });
        }

        /**
         * Force users to assume a certain role when launching a product.
         * <p>
         * The role will be referenced by name in the local account instead of a static role arn.
         * A role with this name will automatically be created and assumable by Service Catalog in this account.
         * This is useful when sharing the portfolio with multiple accounts.
         * <p>
         * @param product A service catalog product. This parameter is required.
         * @param launchRoleName The name of the IAM role a user must assume when provisioning the product. This parameter is required.
         * @param options options for the constraint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole setLocalLaunchRoleName(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull java.lang.String launchRoleName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.CommonConstraintOptions options) {
            return software.amazon.jsii.Kernel.call(this, "setLocalLaunchRoleName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class), new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(launchRoleName, "launchRoleName is required"), options });
        }

        /**
         * Force users to assume a certain role when launching a product.
         * <p>
         * The role will be referenced by name in the local account instead of a static role arn.
         * A role with this name will automatically be created and assumable by Service Catalog in this account.
         * This is useful when sharing the portfolio with multiple accounts.
         * <p>
         * @param product A service catalog product. This parameter is required.
         * @param launchRoleName The name of the IAM role a user must assume when provisioning the product. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole setLocalLaunchRoleName(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull java.lang.String launchRoleName) {
            return software.amazon.jsii.Kernel.call(this, "setLocalLaunchRoleName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class), new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(launchRoleName, "launchRoleName is required") });
        }

        /**
         * Initiate a portfolio share with another account.
         * <p>
         * @param accountId AWS account to share portfolio with. This parameter is required.
         * @param options Options for the initiate share.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void shareWithAccount(final @org.jetbrains.annotations.NotNull java.lang.String accountId, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.PortfolioShareOptions options) {
            software.amazon.jsii.Kernel.call(this, "shareWithAccount", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(accountId, "accountId is required"), options });
        }

        /**
         * Initiate a portfolio share with another account.
         * <p>
         * @param accountId AWS account to share portfolio with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void shareWithAccount(final @org.jetbrains.annotations.NotNull java.lang.String accountId) {
            software.amazon.jsii.Kernel.call(this, "shareWithAccount", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(accountId, "accountId is required") });
        }
    }

    /**
     * Internal default implementation for {@link IPortfolio}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IPortfolio, software.amazon.awscdk.core.IResource.Jsii$Default {

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
        }

        /**
         * The ARN of the portfolio.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getPortfolioArn() {
            return software.amazon.jsii.Kernel.get(this, "portfolioArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The ID of the portfolio.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getPortfolioId() {
            return software.amazon.jsii.Kernel.get(this, "portfolioId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Associate portfolio with the given product.
         * <p>
         * @param product A service catalog produt. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addProduct(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product) {
            software.amazon.jsii.Kernel.call(this, "addProduct", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required") });
        }

        /**
         * Associate Tag Options.
         * <p>
         * A TagOption is a key-value pair managed in AWS Service Catalog.
         * It is not an AWS tag, but serves as a template for creating an AWS tag based on the TagOption.
         * <p>
         * @param tagOptions This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void associateTagOptions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.TagOptions tagOptions) {
            software.amazon.jsii.Kernel.call(this, "associateTagOptions", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(tagOptions, "tagOptions is required") });
        }

        /**
         * Set provisioning rules for the product.
         * <p>
         * @param product A service catalog product. This parameter is required.
         * @param options options for the constraint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void constrainCloudFormationParameters(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.CloudFormationRuleConstraintOptions options) {
            software.amazon.jsii.Kernel.call(this, "constrainCloudFormationParameters", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }

        /**
         * Add a Resource Update Constraint.
         * <p>
         * @param product This parameter is required.
         * @param options
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void constrainTagUpdates(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.TagUpdateConstraintOptions options) {
            software.amazon.jsii.Kernel.call(this, "constrainTagUpdates", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), options });
        }

        /**
         * Configure deployment options using AWS Cloudformation StackSets.
         * <p>
         * @param product A service catalog product. This parameter is required.
         * @param options Configuration options for the constraint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void deployWithStackSets(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.StackSetsConstraintOptions options) {
            software.amazon.jsii.Kernel.call(this, "deployWithStackSets", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }

        /**
         * Associate portfolio with an IAM Group.
         * <p>
         * @param group an IAM Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void giveAccessToGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGroup group) {
            software.amazon.jsii.Kernel.call(this, "giveAccessToGroup", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(group, "group is required") });
        }

        /**
         * Associate portfolio with an IAM Role.
         * <p>
         * @param role an IAM role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void giveAccessToRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole role) {
            software.amazon.jsii.Kernel.call(this, "giveAccessToRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(role, "role is required") });
        }

        /**
         * Associate portfolio with an IAM User.
         * <p>
         * @param user an IAM user. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void giveAccessToUser(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IUser user) {
            software.amazon.jsii.Kernel.call(this, "giveAccessToUser", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(user, "user is required") });
        }

        /**
         * Add notifications for supplied topics on the provisioned product.
         * <p>
         * @param product A service catalog product. This parameter is required.
         * @param topic A SNS Topic to receive notifications on events related to the provisioned product. This parameter is required.
         * @param options
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void notifyOnStackEvents(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic topic, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.CommonConstraintOptions options) {
            software.amazon.jsii.Kernel.call(this, "notifyOnStackEvents", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(topic, "topic is required"), options });
        }

        /**
         * Force users to assume a certain role when launching a product.
         * <p>
         * This sets the launch role using the role arn which is tied to the account this role exists in.
         * This is useful if you will be provisioning products from the account where this role exists.
         * If you intend to share the portfolio across accounts, use a local launch role.
         * <p>
         * @param product A service catalog product. This parameter is required.
         * @param launchRole The IAM role a user must assume when provisioning the product. This parameter is required.
         * @param options options for the constraint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void setLaunchRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole launchRole, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.CommonConstraintOptions options) {
            software.amazon.jsii.Kernel.call(this, "setLaunchRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(launchRole, "launchRole is required"), options });
        }

        /**
         * Force users to assume a certain role when launching a product.
         * <p>
         * The role name will be referenced by in the local account and must be set explicitly.
         * This is useful when sharing the portfolio with multiple accounts.
         * <p>
         * @param product A service catalog product. This parameter is required.
         * @param launchRole The IAM role a user must assume when provisioning the product. This parameter is required.
         * @param options options for the constraint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void setLocalLaunchRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole launchRole, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.CommonConstraintOptions options) {
            software.amazon.jsii.Kernel.call(this, "setLocalLaunchRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(launchRole, "launchRole is required"), options });
        }

        /**
         * Force users to assume a certain role when launching a product.
         * <p>
         * The role will be referenced by name in the local account instead of a static role arn.
         * A role with this name will automatically be created and assumable by Service Catalog in this account.
         * This is useful when sharing the portfolio with multiple accounts.
         * <p>
         * @param product A service catalog product. This parameter is required.
         * @param launchRoleName The name of the IAM role a user must assume when provisioning the product. This parameter is required.
         * @param options options for the constraint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole setLocalLaunchRoleName(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.IProduct product, final @org.jetbrains.annotations.NotNull java.lang.String launchRoleName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.CommonConstraintOptions options) {
            return software.amazon.jsii.Kernel.call(this, "setLocalLaunchRoleName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class), new Object[] { java.util.Objects.requireNonNull(product, "product is required"), java.util.Objects.requireNonNull(launchRoleName, "launchRoleName is required"), options });
        }

        /**
         * Initiate a portfolio share with another account.
         * <p>
         * @param accountId AWS account to share portfolio with. This parameter is required.
         * @param options Options for the initiate share.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void shareWithAccount(final @org.jetbrains.annotations.NotNull java.lang.String accountId, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.PortfolioShareOptions options) {
            software.amazon.jsii.Kernel.call(this, "shareWithAccount", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(accountId, "accountId is required"), options });
        }
    }
}
