package software.amazon.awscdk.services.servicecatalog;

/**
 * Properties for TagOptions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Portfolio portfolio;
 * CloudFormationProduct product;
 * TagOptions tagOptionsForPortfolio = TagOptions.Builder.create(this, "OrgTagOptions")
 *         .allowedValuesForTags(Map.of(
 *                 "Group", List.of("finance", "engineering", "marketing", "research"),
 *                 "CostCenter", List.of("01", "02", "03")))
 *         .build();
 * portfolio.associateTagOptions(tagOptionsForPortfolio);
 * TagOptions tagOptionsForProduct = TagOptions.Builder.create(this, "ProductTagOptions")
 *         .allowedValuesForTags(Map.of(
 *                 "Environment", List.of("dev", "alpha", "prod")))
 *         .build();
 * product.associateTagOptions(tagOptionsForProduct);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.84.0 (build 5404dcf)", date = "2023-06-19T16:30:39.823Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalog.$Module.class, fqn = "@aws-cdk/aws-servicecatalog.TagOptionsProps")
@software.amazon.jsii.Jsii.Proxy(TagOptionsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TagOptionsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The values that are allowed to be set for specific tags.
     * <p>
     * The keys of the map represent the tag keys,
     * and the values of the map are a list of allowed values for that particular tag key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.util.List<java.lang.String>> getAllowedValuesForTags();

    /**
     * @return a {@link Builder} of {@link TagOptionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TagOptionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TagOptionsProps> {
        java.util.Map<java.lang.String, java.util.List<java.lang.String>> allowedValuesForTags;

        /**
         * Sets the value of {@link TagOptionsProps#getAllowedValuesForTags}
         * @param allowedValuesForTags The values that are allowed to be set for specific tags. This parameter is required.
         *                             The keys of the map represent the tag keys,
         *                             and the values of the map are a list of allowed values for that particular tag key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder allowedValuesForTags(java.util.Map<java.lang.String, ? extends java.util.List<java.lang.String>> allowedValuesForTags) {
            this.allowedValuesForTags = (java.util.Map<java.lang.String, java.util.List<java.lang.String>>)allowedValuesForTags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TagOptionsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TagOptionsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TagOptionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagOptionsProps {
        private final java.util.Map<java.lang.String, java.util.List<java.lang.String>> allowedValuesForTags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowedValuesForTags = software.amazon.jsii.Kernel.get(this, "allowedValuesForTags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowedValuesForTags = (java.util.Map<java.lang.String, java.util.List<java.lang.String>>)java.util.Objects.requireNonNull(builder.allowedValuesForTags, "allowedValuesForTags is required");
        }

        @Override
        public final java.util.Map<java.lang.String, java.util.List<java.lang.String>> getAllowedValuesForTags() {
            return this.allowedValuesForTags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("allowedValuesForTags", om.valueToTree(this.getAllowedValuesForTags()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicecatalog.TagOptionsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TagOptionsProps.Jsii$Proxy that = (TagOptionsProps.Jsii$Proxy) o;

            return this.allowedValuesForTags.equals(that.allowedValuesForTags);
        }

        @Override
        public final int hashCode() {
            int result = this.allowedValuesForTags.hashCode();
            return result;
        }
    }
}
