package software.amazon.awscdk.services.sns;

/**
 * Either a new or imported Topic
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-11-21T12:43:40.822Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sns.$Module.class, fqn = "@aws-cdk/aws-sns.TopicRef")
public abstract class TopicRef extends software.amazon.awscdk.Construct implements software.amazon.awscdk.services.events.IEventRuleTarget,software.amazon.awscdk.services.cloudwatch.IAlarmAction,software.amazon.awscdk.services.s3.notifications.IBucketNotificationDestination,software.amazon.awscdk.services.autoscaling.api.ILifecycleHookTarget {
    protected TopicRef(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }

    /**
     * Import a Topic defined elsewhere
     */
    public static software.amazon.awscdk.services.sns.TopicRef import_(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.sns.TopicRefProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.sns.TopicRef.class, "import", software.amazon.awscdk.services.sns.TopicRef.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Adds a statement to the IAM resource policy associated with this topic.
     * 
     * If this topic was created in this stack (`new Topic`), a topic policy
     * will be automatically created upon the first call to `addToPolicy`. If
     * the topic is improted (`Topic.import`), then this is a no-op.
     */
    public void addToResourcePolicy(final software.amazon.awscdk.services.iam.PolicyStatement statement) {
        this.jsiiCall("addToResourcePolicy", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(statement, "statement is required")).toArray());
    }

    /**
     * Implements the IBucketNotificationDestination interface, allowing topics to be used
     * as bucket notification destinations.
     * @param bucketArn The ARN of the bucket sending the notifications
     * @param bucketId A unique ID of the bucket
     */
    @Override
    public software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationProps asBucketNotificationDestination(final java.lang.String bucketArn, final java.lang.String bucketId) {
        return this.jsiiCall("asBucketNotificationDestination", software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationProps.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(bucketArn, "bucketArn is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(bucketId, "bucketId is required"))).toArray());
    }

    /**
     * Returns a RuleTarget that can be used to trigger this SNS topic as a
     * result from a CloudWatch event.
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/resource-based-policies-cwe.html#sns-permissions
     */
    @Override
    public software.amazon.awscdk.services.events.EventRuleTargetProps asEventRuleTarget(final java.lang.String _ruleArn, final java.lang.String _ruleId) {
        return this.jsiiCall("asEventRuleTarget", software.amazon.awscdk.services.events.EventRuleTargetProps.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(_ruleArn, "_ruleArn is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(_ruleId, "_ruleId is required"))).toArray());
    }

    /**
     * Allow using SNS topics as lifecycle hook targets
     */
    @Override
    public software.amazon.awscdk.services.autoscaling.api.LifecycleHookTargetProps asLifecycleHookTarget(final software.amazon.awscdk.services.autoscaling.api.ILifecycleHook lifecycleHook) {
        return this.jsiiCall("asLifecycleHookTarget", software.amazon.awscdk.services.autoscaling.api.LifecycleHookTargetProps.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(lifecycleHook, "lifecycleHook is required")).toArray());
    }

    /**
     * Export this Topic
     */
    public software.amazon.awscdk.services.sns.TopicRefProps export() {
        return this.jsiiCall("export", software.amazon.awscdk.services.sns.TopicRefProps.class);
    }

    /**
     * Grant topic publishing permissions to the given identity
     */
    public void grantPublish(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity) {
        this.jsiiCall("grantPublish", Void.class, java.util.stream.Stream.of(identity).toArray());
    }

    /**
     * Grant topic publishing permissions to the given identity
     */
    public void grantPublish() {
        this.jsiiCall("grantPublish", Void.class);
    }

    /**
     * Construct a Metric object for the current topic for the given metric
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metric(final java.lang.String metricName, @javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(metricName, "metricName is required")), java.util.stream.Stream.of(props)).toArray());
    }

    /**
     * Construct a Metric object for the current topic for the given metric
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metric(final java.lang.String metricName) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(metricName, "metricName is required")).toArray());
    }

    /**
     * Metric for the number of messages that were successfully delivered through this topic
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesDelivered(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricNumberOfMessagesDelivered", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * Metric for the number of messages that were successfully delivered through this topic
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesDelivered() {
        return this.jsiiCall("metricNumberOfMessagesDelivered", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of messages that failed to publish through this topic
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesFailed(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricNumberOfMessagesFailed", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * Metric for the number of messages that failed to publish through this topic
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesFailed() {
        return this.jsiiCall("metricNumberOfMessagesFailed", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of messages published through this topic
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesPublished(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricNumberOfMessagesPublished", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * Metric for the number of messages published through this topic
     * @default sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesPublished() {
        return this.jsiiCall("metricNumberOfMessagesPublished", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the size of messages published through this topic
     * @default average over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricPublishSize(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricPublishSize", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * Metric for the size of messages published through this topic
     * @default average over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricPublishSize() {
        return this.jsiiCall("metricPublishSize", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Subscribe some endpoint to this topic
     */
    public void subscribe(final java.lang.String name, final java.lang.String endpoint, final software.amazon.awscdk.services.sns.SubscriptionProtocol protocol) {
        this.jsiiCall("subscribe", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(endpoint, "endpoint is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(protocol, "protocol is required"))).toArray());
    }

    /**
     * Defines a subscription from this SNS topic to an email address.
     * @param name A name for the subscription
     * @param emailAddress The email address to use.
     */
    public software.amazon.awscdk.services.sns.Subscription subscribeEmail(final java.lang.String name, final java.lang.String emailAddress, @javax.annotation.Nullable final software.amazon.awscdk.services.sns.EmailSubscriptionOptions options) {
        return this.jsiiCall("subscribeEmail", software.amazon.awscdk.services.sns.Subscription.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(emailAddress, "emailAddress is required"))), java.util.stream.Stream.of(options)).toArray());
    }

    /**
     * Defines a subscription from this SNS topic to an email address.
     * @param name A name for the subscription
     * @param emailAddress The email address to use.
     */
    public software.amazon.awscdk.services.sns.Subscription subscribeEmail(final java.lang.String name, final java.lang.String emailAddress) {
        return this.jsiiCall("subscribeEmail", software.amazon.awscdk.services.sns.Subscription.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(emailAddress, "emailAddress is required"))).toArray());
    }

    /**
     * Defines a subscription from this SNS Topic to a Lambda function.
     * 
     * The Lambda's resource policy will be updated to allow this topic to
     * invoke the function.
     * @param lambdaFunction The Lambda function to invoke
     */
    public software.amazon.awscdk.services.sns.Subscription subscribeLambda(final software.amazon.awscdk.services.lambda.FunctionRef lambdaFunction) {
        return this.jsiiCall("subscribeLambda", software.amazon.awscdk.services.sns.Subscription.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(lambdaFunction, "lambdaFunction is required")).toArray());
    }

    /**
     * Defines a subscription from this SNS topic to an SQS queue.
     * 
     * The queue resource policy will be updated to allow this SNS topic to send
     * messages to the queue.
     * 
     * TODO: change to QueueRef.
     * @param queue The target queue
     */
    public software.amazon.awscdk.services.sns.Subscription subscribeQueue(final software.amazon.awscdk.services.sqs.QueueRef queue) {
        return this.jsiiCall("subscribeQueue", software.amazon.awscdk.services.sns.Subscription.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(queue, "queue is required")).toArray());
    }

    /**
     * Defines a subscription from this SNS topic to an http:// or https:// URL.
     * @param name A name for the subscription
     * @param url The URL to invoke
     */
    public software.amazon.awscdk.services.sns.Subscription subscribeUrl(final java.lang.String name, final java.lang.String url) {
        return this.jsiiCall("subscribeUrl", software.amazon.awscdk.services.sns.Subscription.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(url, "url is required"))).toArray());
    }

    /**
     * Return the ARN that should be used for a CloudWatch Alarm action
     */
    @Override
    public java.lang.String getAlarmActionArn() {
        return this.jsiiGet("alarmActionArn", java.lang.String.class);
    }

    /**
     * Controls automatic creation of policy objects.
     * 
     * Set by subclasses.
     */
    protected java.lang.Boolean getAutoCreatePolicy() {
        return this.jsiiGet("autoCreatePolicy", java.lang.Boolean.class);
    }

    public java.lang.String getTopicArn() {
        return this.jsiiGet("topicArn", java.lang.String.class);
    }

    public java.lang.String getTopicName() {
        return this.jsiiGet("topicName", java.lang.String.class);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.sns.TopicRef {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Controls automatic creation of policy objects.
         * 
         * Set by subclasses.
         */
        @Override
        protected java.lang.Boolean getAutoCreatePolicy() {
            return this.jsiiGet("autoCreatePolicy", java.lang.Boolean.class);
        }

        @Override
        public java.lang.String getTopicArn() {
            return this.jsiiGet("topicArn", java.lang.String.class);
        }

        @Override
        public java.lang.String getTopicName() {
            return this.jsiiGet("topicName", java.lang.String.class);
        }

        /**
         * Return the ARN that should be used for a CloudWatch Alarm action
         */
        @Override
        public java.lang.String getAlarmActionArn() {
            return this.jsiiGet("alarmActionArn", java.lang.String.class);
        }

        /**
         * Returns the rule target specification.
         * NOTE: Do not use the various `inputXxx` options. They can be set in a call to `addTarget`.
         * @param ruleArn The ARN of the CloudWatch Event Rule that would trigger this target.
         * @param ruleUniqueId A unique ID for this rule. Can be used to implement idempotency.
         */
        @Override
        public software.amazon.awscdk.services.events.EventRuleTargetProps asEventRuleTarget(final java.lang.String ruleArn, final java.lang.String ruleUniqueId) {
            return this.jsiiCall("asEventRuleTarget", software.amazon.awscdk.services.events.EventRuleTargetProps.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(ruleArn, "ruleArn is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(ruleUniqueId, "ruleUniqueId is required"))).toArray());
        }

        /**
         * Registers this resource to receive notifications for the specified
         * bucket. This method will only be called once for each destination/bucket
         * pair and the result will be cached, so there is no need to implement
         * idempotency in each destination.
         * @param bucketArn The ARN of the bucket
         * @param bucketId A unique ID of this bucket in the stack
         */
        @Override
        public software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationProps asBucketNotificationDestination(final java.lang.String bucketArn, final java.lang.String bucketId) {
            return this.jsiiCall("asBucketNotificationDestination", software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationProps.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(bucketArn, "bucketArn is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(bucketId, "bucketId is required"))).toArray());
        }

        /**
         * Called when this object is used as the target of a lifecycle hook
         */
        @Override
        public software.amazon.awscdk.services.autoscaling.api.LifecycleHookTargetProps asLifecycleHookTarget(final software.amazon.awscdk.services.autoscaling.api.ILifecycleHook lifecycleHook) {
            return this.jsiiCall("asLifecycleHookTarget", software.amazon.awscdk.services.autoscaling.api.LifecycleHookTargetProps.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(lifecycleHook, "lifecycleHook is required")).toArray());
        }
    }
}
