package software.amazon.awscdk.services.sns;

/**
 * A CloudFormation `AWS::SNS::Subscription`.
 * <p>
 * The <code>AWS::SNS::Subscription</code> resource subscribes an endpoint to an Amazon SNS topic. For a subscription to be created, the owner of the endpoint must confirm the subscription.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sns.*;
 * Object deliveryPolicy;
 * Object filterPolicy;
 * Object redrivePolicy;
 * CfnSubscription cfnSubscription = CfnSubscription.Builder.create(this, "MyCfnSubscription")
 *         .protocol("protocol")
 *         .topicArn("topicArn")
 *         // the properties below are optional
 *         .deliveryPolicy(deliveryPolicy)
 *         .endpoint("endpoint")
 *         .filterPolicy(filterPolicy)
 *         .rawMessageDelivery(false)
 *         .redrivePolicy(redrivePolicy)
 *         .region("region")
 *         .subscriptionRoleArn("subscriptionRoleArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-27T11:48:55.677Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sns.$Module.class, fqn = "@aws-cdk/aws-sns.CfnSubscription")
public class CfnSubscription extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnSubscription(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSubscription(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sns.CfnSubscription.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::SNS::Subscription`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSubscription(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.CfnSubscriptionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The delivery policy JSON assigned to the subscription.
     * <p>
     * Enables the subscriber to define the message delivery retry strategy in the case of an HTTP/S endpoint subscribed to the topic. For more information, see <code>[GetSubscriptionAttributes](https://docs.aws.amazon.com/sns/latest/api/API_GetSubscriptionAttributes.html)</code> in the <em>Amazon SNS API Reference</em> and <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-delivery-retries.html">Message delivery retries</a> in the <em>Amazon SNS Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDeliveryPolicy() {
        return software.amazon.jsii.Kernel.get(this, "deliveryPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The delivery policy JSON assigned to the subscription.
     * <p>
     * Enables the subscriber to define the message delivery retry strategy in the case of an HTTP/S endpoint subscribed to the topic. For more information, see <code>[GetSubscriptionAttributes](https://docs.aws.amazon.com/sns/latest/api/API_GetSubscriptionAttributes.html)</code> in the <em>Amazon SNS API Reference</em> and <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-delivery-retries.html">Message delivery retries</a> in the <em>Amazon SNS Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeliveryPolicy(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "deliveryPolicy", java.util.Objects.requireNonNull(value, "deliveryPolicy is required"));
    }

    /**
     * The filter policy JSON assigned to the subscription.
     * <p>
     * Enables the subscriber to filter out unwanted messages. For more information, see <code>[GetSubscriptionAttributes](https://docs.aws.amazon.com/sns/latest/api/API_GetSubscriptionAttributes.html)</code> in the <em>Amazon SNS API Reference</em> and <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-filtering.html">Message filtering</a> in the <em>Amazon SNS Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getFilterPolicy() {
        return software.amazon.jsii.Kernel.get(this, "filterPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The filter policy JSON assigned to the subscription.
     * <p>
     * Enables the subscriber to filter out unwanted messages. For more information, see <code>[GetSubscriptionAttributes](https://docs.aws.amazon.com/sns/latest/api/API_GetSubscriptionAttributes.html)</code> in the <em>Amazon SNS API Reference</em> and <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-filtering.html">Message filtering</a> in the <em>Amazon SNS Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFilterPolicy(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "filterPolicy", java.util.Objects.requireNonNull(value, "filterPolicy is required"));
    }

    /**
     * The subscription's protocol.
     * <p>
     * For more information, see the <code>Protocol</code> parameter of the <code>[Subscribe](https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html)</code> action in the <em>Amazon SNS API Reference</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProtocol() {
        return software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The subscription's protocol.
     * <p>
     * For more information, see the <code>Protocol</code> parameter of the <code>[Subscribe](https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html)</code> action in the <em>Amazon SNS API Reference</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProtocol(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "protocol", java.util.Objects.requireNonNull(value, "protocol is required"));
    }

    /**
     * When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue.
     * <p>
     * Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is unreachable) or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held in the dead-letter queue for further analysis or reprocessing.
     * <p>
     * For more information about the redrive policy and dead-letter queues, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html">Amazon SQS dead-letter queues</a> in the <em>Amazon SQS Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRedrivePolicy() {
        return software.amazon.jsii.Kernel.get(this, "redrivePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue.
     * <p>
     * Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is unreachable) or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held in the dead-letter queue for further analysis or reprocessing.
     * <p>
     * For more information about the redrive policy and dead-letter queues, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html">Amazon SQS dead-letter queues</a> in the <em>Amazon SQS Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedrivePolicy(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "redrivePolicy", java.util.Objects.requireNonNull(value, "redrivePolicy is required"));
    }

    /**
     * The ARN of the topic to subscribe to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTopicArn() {
        return software.amazon.jsii.Kernel.get(this, "topicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the topic to subscribe to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTopicArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "topicArn", java.util.Objects.requireNonNull(value, "topicArn is required"));
    }

    /**
     * The subscription's endpoint.
     * <p>
     * The endpoint value depends on the protocol that you specify. For more information, see the <code>Endpoint</code> parameter of the <code>[Subscribe](https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html)</code> action in the <em>Amazon SNS API Reference</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The subscription's endpoint.
     * <p>
     * The endpoint value depends on the protocol that you specify. For more information, see the <code>Endpoint</code> parameter of the <code>[Subscribe](https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html)</code> action in the <em>Amazon SNS API Reference</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpoint(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endpoint", value);
    }

    /**
     * When set to `true` , enables raw message delivery.
     * <p>
     * Raw messages don't contain any JSON formatting and can be sent to Amazon SQS and HTTP/S endpoints. For more information, see <code>[GetSubscriptionAttributes](https://docs.aws.amazon.com/sns/latest/api/API_GetSubscriptionAttributes.html)</code> in the <em>Amazon SNS API Reference</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRawMessageDelivery() {
        return software.amazon.jsii.Kernel.get(this, "rawMessageDelivery", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * When set to `true` , enables raw message delivery.
     * <p>
     * Raw messages don't contain any JSON formatting and can be sent to Amazon SQS and HTTP/S endpoints. For more information, see <code>[GetSubscriptionAttributes](https://docs.aws.amazon.com/sns/latest/api/API_GetSubscriptionAttributes.html)</code> in the <em>Amazon SNS API Reference</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRawMessageDelivery(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "rawMessageDelivery", value);
    }

    /**
     * When set to `true` , enables raw message delivery.
     * <p>
     * Raw messages don't contain any JSON formatting and can be sent to Amazon SQS and HTTP/S endpoints. For more information, see <code>[GetSubscriptionAttributes](https://docs.aws.amazon.com/sns/latest/api/API_GetSubscriptionAttributes.html)</code> in the <em>Amazon SNS API Reference</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRawMessageDelivery(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "rawMessageDelivery", value);
    }

    /**
     * For cross-region subscriptions, the region in which the topic resides.
     * <p>
     * If no region is specified, AWS CloudFormation uses the region of the caller as the default.
     * <p>
     * If you perform an update operation that only updates the <code>Region</code> property of a <code>AWS::SNS::Subscription</code> resource, that operation will fail unless you are either:
     * <p>
     * <ul>
     * <li>Updating the <code>Region</code> from <code>NULL</code> to the caller region.</li>
     * <li>Updating the <code>Region</code> from the caller region to <code>NULL</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * For cross-region subscriptions, the region in which the topic resides.
     * <p>
     * If no region is specified, AWS CloudFormation uses the region of the caller as the default.
     * <p>
     * If you perform an update operation that only updates the <code>Region</code> property of a <code>AWS::SNS::Subscription</code> resource, that operation will fail unless you are either:
     * <p>
     * <ul>
     * <li>Updating the <code>Region</code> from <code>NULL</code> to the caller region.</li>
     * <li>Updating the <code>Region</code> from the caller region to <code>NULL</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRegion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "region", value);
    }

    /**
     * This property applies only to Amazon Kinesis Data Firehose delivery stream subscriptions.
     * <p>
     * Specify the ARN of the IAM role that has the following:
     * <p>
     * <ul>
     * <li>Permission to write to the Amazon Kinesis Data Firehose delivery stream</li>
     * <li>Amazon SNS listed as a trusted entity</li>
     * </ul>
     * <p>
     * Specifying a valid ARN for this attribute is required for Kinesis Data Firehose delivery stream subscriptions. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">Fanout to Amazon Kinesis Data Firehose delivery streams</a> in the <em>Amazon SNS Developer Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSubscriptionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "subscriptionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * This property applies only to Amazon Kinesis Data Firehose delivery stream subscriptions.
     * <p>
     * Specify the ARN of the IAM role that has the following:
     * <p>
     * <ul>
     * <li>Permission to write to the Amazon Kinesis Data Firehose delivery stream</li>
     * <li>Amazon SNS listed as a trusted entity</li>
     * </ul>
     * <p>
     * Specifying a valid ARN for this attribute is required for Kinesis Data Firehose delivery stream subscriptions. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">Fanout to Amazon Kinesis Data Firehose delivery streams</a> in the <em>Amazon SNS Developer Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubscriptionRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "subscriptionRoleArn", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sns.CfnSubscription}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sns.CfnSubscription> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sns.CfnSubscriptionProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sns.CfnSubscriptionProps.Builder();
        }

        /**
         * The subscription's protocol.
         * <p>
         * For more information, see the <code>Protocol</code> parameter of the <code>[Subscribe](https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html)</code> action in the <em>Amazon SNS API Reference</em> .
         * <p>
         * @return {@code this}
         * @param protocol The subscription's protocol. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(final java.lang.String protocol) {
            this.props.protocol(protocol);
            return this;
        }

        /**
         * The ARN of the topic to subscribe to.
         * <p>
         * @return {@code this}
         * @param topicArn The ARN of the topic to subscribe to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicArn(final java.lang.String topicArn) {
            this.props.topicArn(topicArn);
            return this;
        }

        /**
         * The delivery policy JSON assigned to the subscription.
         * <p>
         * Enables the subscriber to define the message delivery retry strategy in the case of an HTTP/S endpoint subscribed to the topic. For more information, see <code>[GetSubscriptionAttributes](https://docs.aws.amazon.com/sns/latest/api/API_GetSubscriptionAttributes.html)</code> in the <em>Amazon SNS API Reference</em> and <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-delivery-retries.html">Message delivery retries</a> in the <em>Amazon SNS Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param deliveryPolicy The delivery policy JSON assigned to the subscription. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryPolicy(final java.lang.Object deliveryPolicy) {
            this.props.deliveryPolicy(deliveryPolicy);
            return this;
        }

        /**
         * The subscription's endpoint.
         * <p>
         * The endpoint value depends on the protocol that you specify. For more information, see the <code>Endpoint</code> parameter of the <code>[Subscribe](https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html)</code> action in the <em>Amazon SNS API Reference</em> .
         * <p>
         * @return {@code this}
         * @param endpoint The subscription's endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(final java.lang.String endpoint) {
            this.props.endpoint(endpoint);
            return this;
        }

        /**
         * The filter policy JSON assigned to the subscription.
         * <p>
         * Enables the subscriber to filter out unwanted messages. For more information, see <code>[GetSubscriptionAttributes](https://docs.aws.amazon.com/sns/latest/api/API_GetSubscriptionAttributes.html)</code> in the <em>Amazon SNS API Reference</em> and <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-filtering.html">Message filtering</a> in the <em>Amazon SNS Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param filterPolicy The filter policy JSON assigned to the subscription. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPolicy(final java.lang.Object filterPolicy) {
            this.props.filterPolicy(filterPolicy);
            return this;
        }

        /**
         * When set to `true` , enables raw message delivery.
         * <p>
         * Raw messages don't contain any JSON formatting and can be sent to Amazon SQS and HTTP/S endpoints. For more information, see <code>[GetSubscriptionAttributes](https://docs.aws.amazon.com/sns/latest/api/API_GetSubscriptionAttributes.html)</code> in the <em>Amazon SNS API Reference</em> .
         * <p>
         * @return {@code this}
         * @param rawMessageDelivery When set to `true` , enables raw message delivery. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rawMessageDelivery(final java.lang.Boolean rawMessageDelivery) {
            this.props.rawMessageDelivery(rawMessageDelivery);
            return this;
        }
        /**
         * When set to `true` , enables raw message delivery.
         * <p>
         * Raw messages don't contain any JSON formatting and can be sent to Amazon SQS and HTTP/S endpoints. For more information, see <code>[GetSubscriptionAttributes](https://docs.aws.amazon.com/sns/latest/api/API_GetSubscriptionAttributes.html)</code> in the <em>Amazon SNS API Reference</em> .
         * <p>
         * @return {@code this}
         * @param rawMessageDelivery When set to `true` , enables raw message delivery. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rawMessageDelivery(final software.amazon.awscdk.core.IResolvable rawMessageDelivery) {
            this.props.rawMessageDelivery(rawMessageDelivery);
            return this;
        }

        /**
         * When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue.
         * <p>
         * Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is unreachable) or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held in the dead-letter queue for further analysis or reprocessing.
         * <p>
         * For more information about the redrive policy and dead-letter queues, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html">Amazon SQS dead-letter queues</a> in the <em>Amazon SQS Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param redrivePolicy When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redrivePolicy(final java.lang.Object redrivePolicy) {
            this.props.redrivePolicy(redrivePolicy);
            return this;
        }

        /**
         * For cross-region subscriptions, the region in which the topic resides.
         * <p>
         * If no region is specified, AWS CloudFormation uses the region of the caller as the default.
         * <p>
         * If you perform an update operation that only updates the <code>Region</code> property of a <code>AWS::SNS::Subscription</code> resource, that operation will fail unless you are either:
         * <p>
         * <ul>
         * <li>Updating the <code>Region</code> from <code>NULL</code> to the caller region.</li>
         * <li>Updating the <code>Region</code> from the caller region to <code>NULL</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param region For cross-region subscriptions, the region in which the topic resides. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * This property applies only to Amazon Kinesis Data Firehose delivery stream subscriptions.
         * <p>
         * Specify the ARN of the IAM role that has the following:
         * <p>
         * <ul>
         * <li>Permission to write to the Amazon Kinesis Data Firehose delivery stream</li>
         * <li>Amazon SNS listed as a trusted entity</li>
         * </ul>
         * <p>
         * Specifying a valid ARN for this attribute is required for Kinesis Data Firehose delivery stream subscriptions. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">Fanout to Amazon Kinesis Data Firehose delivery streams</a> in the <em>Amazon SNS Developer Guide.</em>
         * <p>
         * @return {@code this}
         * @param subscriptionRoleArn This property applies only to Amazon Kinesis Data Firehose delivery stream subscriptions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriptionRoleArn(final java.lang.String subscriptionRoleArn) {
            this.props.subscriptionRoleArn(subscriptionRoleArn);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sns.CfnSubscription}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sns.CfnSubscription build() {
            return new software.amazon.awscdk.services.sns.CfnSubscription(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
