package software.amazon.awscdk.services.sns;

/**
 * Between condition for a numeric attribute.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Function fn;
 * Topic myTopic = new Topic(this, "MyTopic");
 * // Lambda should receive only message matching the following conditions on attributes:
 * // color: 'red' or 'orange' or begins with 'bl'
 * // size: anything but 'small' or 'medium'
 * // price: between 100 and 200 or greater than 300
 * // store: attribute must be present
 * myTopic.addSubscription(LambdaSubscription.Builder.create(fn)
 *         .filterPolicy(Map.of(
 *                 "color", SubscriptionFilter.stringFilter(StringConditions.builder()
 *                         .allowlist(List.of("red", "orange"))
 *                         .matchPrefixes(List.of("bl"))
 *                         .build()),
 *                 "size", SubscriptionFilter.stringFilter(StringConditions.builder()
 *                         .denylist(List.of("small", "medium"))
 *                         .build()),
 *                 "price", SubscriptionFilter.numericFilter(NumericConditions.builder()
 *                         .between(BetweenCondition.builder().start(100).stop(200).build())
 *                         .greaterThan(300)
 *                         .build()),
 *                 "store", SubscriptionFilter.existsFilter()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:40.055Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sns.$Module.class, fqn = "@aws-cdk/aws-sns.BetweenCondition")
@software.amazon.jsii.Jsii.Proxy(BetweenCondition.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BetweenCondition extends software.amazon.jsii.JsiiSerializable {

    /**
     * The start value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getStart();

    /**
     * The stop value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getStop();

    /**
     * @return a {@link Builder} of {@link BetweenCondition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BetweenCondition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BetweenCondition> {
        java.lang.Number start;
        java.lang.Number stop;

        /**
         * Sets the value of {@link BetweenCondition#getStart}
         * @param start The start value. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder start(java.lang.Number start) {
            this.start = start;
            return this;
        }

        /**
         * Sets the value of {@link BetweenCondition#getStop}
         * @param stop The stop value. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stop(java.lang.Number stop) {
            this.stop = stop;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BetweenCondition}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BetweenCondition build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BetweenCondition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BetweenCondition {
        private final java.lang.Number start;
        private final java.lang.Number stop;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.start = software.amazon.jsii.Kernel.get(this, "start", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.stop = software.amazon.jsii.Kernel.get(this, "stop", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.start = java.util.Objects.requireNonNull(builder.start, "start is required");
            this.stop = java.util.Objects.requireNonNull(builder.stop, "stop is required");
        }

        @Override
        public final java.lang.Number getStart() {
            return this.start;
        }

        @Override
        public final java.lang.Number getStop() {
            return this.stop;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("start", om.valueToTree(this.getStart()));
            data.set("stop", om.valueToTree(this.getStop()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sns.BetweenCondition"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BetweenCondition.Jsii$Proxy that = (BetweenCondition.Jsii$Proxy) o;

            if (!start.equals(that.start)) return false;
            return this.stop.equals(that.stop);
        }

        @Override
        public final int hashCode() {
            int result = this.start.hashCode();
            result = 31 * result + (this.stop.hashCode());
            return result;
        }
    }
}
