package software.amazon.awscdk.services.sns;

/**
 * A new subscription.
 * <p>
 * Prefer to use the <code>ITopic.addSubscription()</code> methods to create instances of
 * this class.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.1.0 (build df55f5e)", date = "2020-04-07T12:30:30.507Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sns.$Module.class, fqn = "@aws-cdk/aws-sns.Subscription")
public class Subscription extends software.amazon.awscdk.core.Resource {

    protected Subscription(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Subscription(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Subscription(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.SubscriptionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sns.Subscription}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sns.SubscriptionProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sns.SubscriptionProps.Builder();
        }

        /**
         * The subscription endpoint.
         * <p>
         * The meaning of this value depends on the value for 'protocol'.
         * <p>
         * @return {@code this}
         * @param endpoint The subscription endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(final java.lang.String endpoint) {
            this.props.endpoint(endpoint);
            return this;
        }

        /**
         * What type of subscription to add.
         * <p>
         * @return {@code this}
         * @param protocol What type of subscription to add. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(final software.amazon.awscdk.services.sns.SubscriptionProtocol protocol) {
            this.props.protocol(protocol);
            return this;
        }

        /**
         * The filter policy.
         * <p>
         * Default: - all messages are delivered
         * <p>
         * @return {@code this}
         * @param filterPolicy The filter policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPolicy(final java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy) {
            this.props.filterPolicy(filterPolicy);
            return this;
        }

        /**
         * true if raw message delivery is enabled for the subscription.
         * <p>
         * Raw messages are free of JSON formatting and can be
         * sent to HTTP/S and Amazon SQS endpoints. For more information, see GetSubscriptionAttributes in the Amazon Simple
         * Notification Service API Reference.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param rawMessageDelivery true if raw message delivery is enabled for the subscription. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rawMessageDelivery(final java.lang.Boolean rawMessageDelivery) {
            this.props.rawMessageDelivery(rawMessageDelivery);
            return this;
        }

        /**
         * The region where the topic resides, in the case of cross-region subscriptions.
         * <p>
         * Default: - the region where the CloudFormation stack is being deployed.
         * <p>
         * @return {@code this}
         * @param region The region where the topic resides, in the case of cross-region subscriptions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * The topic to subscribe to.
         * <p>
         * @return {@code this}
         * @param topic The topic to subscribe to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topic(final software.amazon.awscdk.services.sns.ITopic topic) {
            this.props.topic(topic);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sns.Subscription}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.sns.Subscription build() {
            return new software.amazon.awscdk.services.sns.Subscription(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
